<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.36.10.10
Name: Resultaatdocument MDL bevolkingsonderzoek darmkanker
Description: Template voor CDA document resultaten bevolkingsonderzoek darmkanker voor screeningsorganisatie maag-, darm-, levercentrum (transactie T4)
                 
                 Nadere toelichtingen mbt Zorgverlener en Zorginstelling in de context ColonIS 
                In de context van ColonIS zijn de volgende zorgverleners relevant: 
                     de uitvoerder van de coloscopie 
                     de autoriseerder van het coloscopieverslag 
                     de patholoog die de biopten analyseert 
                     de autoriseerder van het pathologieverslag. 
                 
                De autoriseerder mag dezelfde zijn als de uitvoerder, maar dat hoeft niet het geval te zijn. Andere betrokken personen worden niet opgenomen. Wanneer bijvoorbeeld het coloscopieverslag wordt gedicteerd en door een andere persoon ingevoerd, is nog steeds alleen de uitvoerder van de coloscopie van belang.
                 
                Er zijn drie soorten organisaties relevant: 
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000">
   <title>Resultaatdocument MDL bevolkingsonderzoek darmkanker</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.10
Context: /
Item: (nspbcmdl)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.10
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']
Item: (nspbcmdl)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']"
         id="tmp-r-56387ba6-595c-4fbe-9f1d-3b41024df35d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:realmCode[@code='NL'])&gt;=1 and not(hl7:realmCode[@code='NL']/@nullFlavor)">(nspbcmdl): element hl7:realmCode[@code='NL'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:realmCode[@code='NL'])&lt;=1">(nspbcmdl): element hl7:realmCode[@code='NL'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:typeId[@root='2.16.840.1.113883.1.3'])&gt;=1 and not(hl7:typeId[@root='2.16.840.1.113883.1.3']/@nullFlavor)">(nspbcmdl): element hl7:typeId[@root='2.16.840.1.113883.1.3'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:typeId[@root='2.16.840.1.113883.1.3'])&lt;=1">(nspbcmdl): element hl7:typeId[@root='2.16.840.1.113883.1.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.10'])&gt;=1 and not(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.10']/@nullFlavor)">(nspbcmdl): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.10'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.10'])&lt;=1">(nspbcmdl): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.10'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1'])&gt;=1 and not(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1']/@nullFlavor)">(nspbcmdl): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1'])&lt;=1">(nspbcmdl): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:id)&gt;=1 and not(hl7:id/@nullFlavor)">(nspbcmdl): element hl7:id is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:id)&lt;=1">(nspbcmdl): element hl7:id komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')])&gt;=1 and not(hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]/@nullFlavor)">(nspbcmdl): element hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')])&lt;=1">(nspbcmdl): element hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:title)&lt;=1">(nspbcmdl): element hl7:title komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:effectiveTime)&gt;=1 and not(hl7:effectiveTime/@nullFlavor)">(nspbcmdl): element hl7:effectiveTime is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:effectiveTime)&lt;=1">(nspbcmdl): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])&gt;=1 and not(hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]/@nullFlavor)">(nspbcmdl): element hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])&lt;=1">(nspbcmdl): element hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:languageCode)&gt;=1 and not(hl7:languageCode/@nullFlavor)">(nspbcmdl): element hl7:languageCode is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:languageCode)&lt;=1">(nspbcmdl): element hl7:languageCode komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:setId)&gt;=1 and not(hl7:setId/@nullFlavor)">(nspbcmdl): element hl7:setId is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:setId)&lt;=1">(nspbcmdl): element hl7:setId komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:versionNumber)&gt;=1 and not(hl7:versionNumber/@nullFlavor)">(nspbcmdl): element hl7:versionNumber is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:versionNumber)&lt;=1">(nspbcmdl): element hl7:versionNumber komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:recordTarget)&gt;=1 and not(hl7:recordTarget/@nullFlavor)">(nspbcmdl): element hl7:recordTarget is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:recordTarget)&lt;=1">(nspbcmdl): element hl7:recordTarget komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100'])&gt;=1 and not(hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100']/@nullFlavor)">(nspbcmdl): element hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:custodian)&gt;=1 and not(hl7:custodian/@nullFlavor)">(nspbcmdl): element hl7:custodian is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:custodian)&lt;=1">(nspbcmdl): element hl7:custodian komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:legalAuthenticator)&lt;=1">(nspbcmdl): element hl7:legalAuthenticator komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:participant)&lt;=1">(nspbcmdl): element hl7:participant komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900800
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:realmCode[@code='NL']
Item: (CDArealmCode)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:realmCode[@code='NL']"
         id="tmp-r-7bd80e2b-06b8-48e0-a408-4593c431631c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900800-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArealmCode): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900800-2012-07-04T000000.html"
              test="@nullFlavor or (@code='NL')">(CDArealmCode): de elementwaarde MOET een zijn van 'code 'NL''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900801
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:typeId[@root='2.16.840.1.113883.1.3']
Item: (CDAtypeId)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:typeId[@root='2.16.840.1.113883.1.3']"
         id="tmp-r-cac7840d-4699-4ecd-bfa5-7e9f752a20bd">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900801-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAtypeId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900801-2012-07-04T000000.html"
              test="string(@extension)=('POCD_HD000040')">(CDAtypeId): de waarde van @extension MOET 'POCD_HD000040' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900801-2012-07-04T000000.html"
              test="string(@root)=('2.16.840.1.113883.1.3')">(CDAtypeId): de waarde van @root MOET '2.16.840.1.113883.1.3' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.10
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.10']
Item: (nspbcmdl)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.10']"
         id="tmp-r-08091e01-df94-4d54-8776-7b00e5066bee">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(nspbcmdl): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="string(@root)=('2.16.840.1.113883.2.4.3.36.10.10')">(nspbcmdl): de waarde van @root MOET '2.16.840.1.113883.2.4.3.36.10.10' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.10
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1']
Item: (nspbcmdl)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1']"
         id="tmp-r-643b0f07-6cbd-416c-a935-b0ef2f2de61a">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(nspbcmdl): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="string(@root)=('2.16.840.1.113883.2.4.3.36.10.1')">(nspbcmdl): de waarde van @root MOET '2.16.840.1.113883.2.4.3.36.10.1' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900802
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:id
Item: (CDAid)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:id"
         id="tmp-r-5423c4a0-4df1-491d-a04f-2bb94a066459">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900802-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAid): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.10
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]
Item: (nspbcmdl)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]"
         id="tmp-r-c56711fc-9b73-4a24-9dff-6956dcbcbd85">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(nspbcmdl): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="@nullFlavor or (@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')">(nspbcmdl): de elementwaarde MOET een zijn van 'code '18746-8' codeSystem '2.16.840.1.113883.6.1''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900803
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:title
Item: (CDAtitle)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:title"
         id="tmp-r-04457f5f-5c49-4cf0-ba64-22cd002cfb1f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900803-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ST' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAtitle): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="ST"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900804
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:effectiveTime
Item: (CDAeffectiveTime)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:effectiveTime"
         id="tmp-r-2f1518e5-d1d6-4871-a382-4bdf8206d1a0">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900804-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAeffectiveTime): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TS.DATETIME.MIN"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900805
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]
Item: (CDAconfidentialityCode)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]"
         id="tmp-r-c7dd1760-d419-45c9-9174-f97057969f79">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900805-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAconfidentialityCode): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900805-2012-07-04T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(CDAconfidentialityCode): de elementwaarde MOET een zijn van 'BasicConfidentialityKind Basic Confidentiality Kind (HL7) (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900805-2012-07-04T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(CDAconfidentialityCode): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst BasicConfidentialityKind Basic Confidentiality Kind (HL7) (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900806
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:languageCode
Item: (CDAlanguageCode)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:languageCode"
         id="tmp-r-b71a8425-0e30-4b3f-a3f2-89183b598f01">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900806-2012-03-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAlanguageCode): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CS.LANG"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900807
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:setId
Item: (CDAsetIdversionNumber)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:setId"
         id="tmp-r-86b53c66-8a32-4d06-8690-bfaa91f3109b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900807-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAsetIdversionNumber): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900807
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:versionNumber
Item: (CDAsetIdversionNumber)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:versionNumber"
         id="tmp-r-453fe27a-68bc-4970-9bcc-53cc54ef0d3f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900807-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='INT' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAsetIdversionNumber): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:INT" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="INT.NONNEG"/>
      <let name="theValue" value="@value"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900807-2012-07-04T000000.html"
              test="(@nullFlavor or (number($theValue)&gt;=1))">(CDAsetIdversionNumber): value MOET in bereik [1..] liggen  </assert>
      <let name="digitok" value="matches(string(@value), '^-?[1-9]\d*$|^+?\d*$')"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900807-2012-07-04T000000.html"
              test="$digitok or @nullFlavor">(CDAsetIdversionNumber): @value is geen geldig INT getal <value-of select="@value"/>
      </assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900808
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget
Item: (CDArecordTarget)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget"
         id="tmp-r-f5e993bc-f75d-4d3c-b341-c3a24de3d011">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900808-2012-07-04T000000.html"
              test="string(@typeCode)=('RCT')">(CDArecordTarget): de waarde van @typeCode MOET 'RCT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900808-2012-07-04T000000.html"
              test="count(hl7:patientRole)&gt;=1 and not(hl7:patientRole/@nullFlavor)">(CDArecordTarget): element hl7:patientRole is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900808-2012-07-04T000000.html"
              test="count(hl7:patientRole)&lt;=1">(CDArecordTarget): element hl7:patientRole komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900808
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget/hl7:patientRole
Item: (CDArecordTarget)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget/hl7:patientRole"
         id="tmp-r-328c8647-fe77-4266-9cf6-3a4c6dbcfca6">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900808-2012-07-04T000000.html"
              test="string(@classCode)=('PAT')">(CDArecordTarget): de waarde van @classCode MOET 'PAT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900808-2012-07-04T000000.html"
              test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.3'])&gt;=1 and not(hl7:id[@root='2.16.840.1.113883.2.4.6.3']/@nullFlavor)">(CDArecordTarget): element hl7:id[@root='2.16.840.1.113883.2.4.6.3'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900808-2012-07-04T000000.html"
              test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.3'])&lt;=1">(CDArecordTarget): element hl7:id[@root='2.16.840.1.113883.2.4.6.3'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900014
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget/hl7:patientRole/hl7:id[@root='2.16.840.1.113883.2.4.6.3']
Item: (BurgerServiceNummer)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget/hl7:patientRole/hl7:id[@root='2.16.840.1.113883.2.4.6.3']"
         id="tmp-r-43cdaf41-f78e-4386-8bd0-4bcd50e5f094">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900014-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(BurgerServiceNummer): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II.NL.BSN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900014-2012-07-04T000000.html"
              test="string(@root)=('2.16.840.1.113883.2.4.6.3')">(BurgerServiceNummer): de waarde van @root MOET '2.16.840.1.113883.2.4.6.3' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900014-2012-07-04T000000.html"
              test="@extension">(BurgerServiceNummer): attribute @extension MOET aanwezig zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900808
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget/hl7:patientRole/hl7:id
Item: (CDArecordTarget)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget/hl7:patientRole/hl7:id"
         id="tmp-r-251187b4-ba4b-4745-979f-bc52d1530b8e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900808-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArecordTarget): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900810
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian
Item: (CDAcustodian)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian"
         id="tmp-r-e59ae1f7-b9de-4c18-a991-57dc1d4f7c0b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="string(@typeCode)=('CST')">(CDAcustodian): de waarde van @typeCode MOET 'CST' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="count(hl7:assignedCustodian)&gt;=1 and not(hl7:assignedCustodian/@nullFlavor)">(CDAcustodian): element hl7:assignedCustodian is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="count(hl7:assignedCustodian)&lt;=1">(CDAcustodian): element hl7:assignedCustodian komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900810
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian
Item: (CDAcustodian)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian"
         id="tmp-r-02ce0e3d-dfd6-4b86-a94e-35a7f38bd37c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="string(@classCode)=('ASSIGNED')">(CDAcustodian): de waarde van @classCode MOET 'ASSIGNED' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="count(hl7:representedCustodianOrganization)&lt;=1">(CDAcustodian): element hl7:representedCustodianOrganization komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900810
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization
Item: (CDAcustodian)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization"
         id="tmp-r-5f9c7abe-cb1b-4bb4-b405-06cbf41e53dc">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="string(@classCode)=('ORG')">(CDAcustodian): de waarde van @classCode MOET 'ORG' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(CDAcustodian): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <let name="elmcount"
           value="count(hl7:id[@root='2.16.528.1.1007.3.3']|hl7:id)"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="$elmcount&gt;=1">(CDAcustodian): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="count(hl7:id[@root='2.16.528.1.1007.3.3'])&lt;=1">(CDAcustodian): element hl7:id[@root='2.16.528.1.1007.3.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor)">(CDAcustodian): element hl7:name is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="count(hl7:name)&lt;=1">(CDAcustodian): element hl7:name komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="count(hl7:addr)&lt;=1">(CDAcustodian): element hl7:addr komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="count(lab:code)&lt;=1">(CDAcustodian): element lab:code komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization
Item: (CDArepresentedOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:id[@root='2.16.528.1.1007.3.3']
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:id[@root='2.16.528.1.1007.3.3']"
         id="tmp-r-5d9a41b8-84f7-4f43-bdf5-e80e42fa3613">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="string(@root)=('2.16.528.1.1007.3.3')">(CDArepresentedOrganization): de waarde van @root MOET '2.16.528.1.1007.3.3' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:id
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:id"
         id="tmp-r-c2d00c56-5451-45bb-a8c8-16eeb8df2a50">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:name
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:name"
         id="tmp-r-fcfb49d2-2107-4df6-b63e-0531bde344c5">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="ON"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:addr
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:addr"
         id="tmp-r-93683f2c-b2e6-49b6-8794-ee1abf7e631d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="AD"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:telecom
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:telecom"
         id="tmp-r-46b8df2f-8360-4c8c-9c32-0678e7547257">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TEL"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/lab:code
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/lab:code"
         id="tmp-r-d0b7d9a4-7bca-43ca-a08b-715dbf899ad6">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(CDArepresentedOrganization): de elementwaarde MOET een zijn van 'vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(CDArepresentedOrganization): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900811
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient
Item: (CDAinformationRecipient)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient"
         id="tmp-r-b8089a6d-475b-48fa-9e1c-09c72886e840">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="@typeCode">(CDAinformationRecipient): attribute @typeCode MOET aanwezig zijn.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),' '))"/>
      <let name="theAttCheck"
           value="distinct-values(for $code in tokenize(@typeCode,' ') return if ($code=('PRCP','TRC')) then ($code) else ())"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="not(@typeCode) or count($theAttValue) = count($theAttCheck)">(CDAinformationRecipient): de waarde van typeCode MOET 'code PRCP of code TRC' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="count(hl7:intendedRecipient)&gt;=1 and not(hl7:intendedRecipient/@nullFlavor)">(CDAinformationRecipient): element hl7:intendedRecipient is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="count(hl7:intendedRecipient)&lt;=1">(CDAinformationRecipient): element hl7:intendedRecipient komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900811
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient
Item: (CDAinformationRecipient)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient"
         id="tmp-r-403b9f88-45de-4c04-835d-8e5b9419b89c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="string(@classCode)=('ASSIGNED')">(CDAinformationRecipient): de waarde van @classCode MOET 'ASSIGNED' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="count(hl7:informationRecipient)&lt;=1">(CDAinformationRecipient): element hl7:informationRecipient komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="count(hl7:representedOrganization)&lt;=1">(CDAinformationRecipient): element hl7:representedOrganization komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900811
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:id
Item: (CDAinformationRecipient)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:id"
         id="tmp-r-d5b9ab8a-800f-40ba-a689-d1ac2615a363">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAinformationRecipient): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900811
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:informationRecipient
Item: (CDAinformationRecipient)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:informationRecipient"
         id="tmp-r-380e4c73-9054-4596-9f8a-794fc0687096">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="string(@classCode)=('PSN')">(CDAinformationRecipient): de waarde van @classCode MOET 'PSN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(CDAinformationRecipient): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="count(hl7:name)&lt;=1">(CDAinformationRecipient): element hl7:name komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900811
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:informationRecipient/hl7:name
Item: (CDAinformationRecipient)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:informationRecipient/hl7:name"
         id="tmp-r-2a63c334-bad5-452e-bc94-861bdd026aee">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAinformationRecipient): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="PN"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900811
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization
Item: (CDAinformationRecipient)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization"
         id="tmp-r-7a5d614f-0df5-4495-978b-a6d5ffae0241">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="string(@classCode)=('ORG')">(CDAinformationRecipient): de waarde van @classCode MOET 'ORG' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(CDAinformationRecipient): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <let name="elmcount"
           value="count(hl7:id[@root='2.16.528.1.1007.3.3']|hl7:id)"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="$elmcount&gt;=1">(CDAinformationRecipient): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="count(hl7:id[@root='2.16.528.1.1007.3.3'])&lt;=1">(CDAinformationRecipient): element hl7:id[@root='2.16.528.1.1007.3.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor)">(CDAinformationRecipient): element hl7:name is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="count(hl7:name)&lt;=1">(CDAinformationRecipient): element hl7:name komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="count(hl7:addr)&lt;=1">(CDAinformationRecipient): element hl7:addr komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="count(lab:code)&lt;=1">(CDAinformationRecipient): element lab:code komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization
Item: (CDArepresentedOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:id[@root='2.16.528.1.1007.3.3']
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:id[@root='2.16.528.1.1007.3.3']"
         id="tmp-r-97d5e222-85d2-4f92-bbbb-7417b853c915">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="string(@root)=('2.16.528.1.1007.3.3')">(CDArepresentedOrganization): de waarde van @root MOET '2.16.528.1.1007.3.3' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:id
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:id"
         id="tmp-r-83fe472e-d475-4f23-97b2-5bce06d9bb2c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:name
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:name"
         id="tmp-r-b9123acc-8aec-4721-85bb-598d01853d66">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="ON"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:addr
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:addr"
         id="tmp-r-f7523989-2b65-445f-8aa0-f62d06d0d4f9">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="AD"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:telecom
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:telecom"
         id="tmp-r-110c6f84-bd38-402c-a2f6-dee9d3bbbe07">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TEL"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/lab:code
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/lab:code"
         id="tmp-r-eb38e220-cf3c-43ae-ac23-cdfcd262922f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(CDArepresentedOrganization): de elementwaarde MOET een zijn van 'vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(CDArepresentedOrganization): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900812
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:authenticator
Item: (CDAauthenticator)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:authenticator"
         id="tmp-r-1b00122e-8d4c-4cc4-9f10-dfd7fefa785f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900812-2012-07-04T000000.html"
              test="string(@typeCode)=('AUTHEN')">(CDAauthenticator): de waarde van @typeCode MOET 'AUTHEN' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900813
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator
Item: (CDlegalAuthenticator)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator"
         id="tmp-r-76acba68-a0ce-484a-aaf9-13d5e985f8a4">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="string(@typeCode)=('LA')">(CDlegalAuthenticator): de waarde van @typeCode MOET 'LA' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:time)&gt;=1 ">(CDlegalAuthenticator): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:time)&lt;=1">(CDlegalAuthenticator): element hl7:time komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:signatureCode[@code='S'])&gt;=1 and not(hl7:signatureCode[@code='S']/@nullFlavor)">(CDlegalAuthenticator): element hl7:signatureCode[@code='S'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:signatureCode[@code='S'])&lt;=1">(CDlegalAuthenticator): element hl7:signatureCode[@code='S'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:assignedEntity)&gt;=1 and not(hl7:assignedEntity/@nullFlavor)">(CDlegalAuthenticator): element hl7:assignedEntity is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:assignedEntity)&lt;=1">(CDlegalAuthenticator): element hl7:assignedEntity komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900813
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:time
Item: (CDlegalAuthenticator)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:time"
         id="tmp-r-b27e1f06-829a-438f-927f-bac561fee602">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDlegalAuthenticator): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TS.DATE.MIN"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900813
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:signatureCode[@code='S']
Item: (CDlegalAuthenticator)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:signatureCode[@code='S']"
         id="tmp-r-0fbda2c2-db17-421c-a36f-c96ddb30f6ad">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDlegalAuthenticator): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="@nullFlavor or (@code='S')">(CDlegalAuthenticator): de elementwaarde MOET een zijn van 'code 'S''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900813
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity
Item: (CDlegalAuthenticator)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity"
         id="tmp-r-02f5fb43-dec1-4c1b-9edf-26814e8f8fa4">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="string(@classCode)=('ASSIGNED')">(CDlegalAuthenticator): de waarde van @classCode MOET 'ASSIGNED' zijn.</assert>
      <let name="elmcount"
           value="count(hl7:id[@root='2.16.528.1.1007.3.1']|hl7:id)"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="$elmcount&gt;=1">(CDlegalAuthenticator): keuze (hl7:id[@root='2.16.528.1.1007.3.1'] of hl7:id) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:id[@root='2.16.528.1.1007.3.1'])&lt;=1">(CDlegalAuthenticator): element hl7:id[@root='2.16.528.1.1007.3.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:code)&lt;=1">(CDlegalAuthenticator): element hl7:code komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:assignedPerson)&lt;=1">(CDlegalAuthenticator): element hl7:assignedPerson komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:representedOrganization)&lt;=1">(CDlegalAuthenticator): element hl7:representedOrganization komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900829
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity
Item: (CDAassignedEntityIdentification)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900829
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:id[@root='2.16.528.1.1007.3.1']
Item: (CDAassignedEntityIdentification)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:id[@root='2.16.528.1.1007.3.1']"
         id="tmp-r-b3fa11a9-2c14-48b7-b2cf-3e94d77597c5">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAassignedEntityIdentification): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html"
              test="string(@root)=('2.16.528.1.1007.3.1')">(CDAassignedEntityIdentification): de waarde van @root MOET '2.16.528.1.1007.3.1' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900829
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:id
Item: (CDAassignedEntityIdentification)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:id"
         id="tmp-r-2f5d734e-92d2-4b96-bf4c-c294b40434f9">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAassignedEntityIdentification): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900813
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:code
Item: (CDlegalAuthenticator)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:code"
         id="tmp-r-9e752be7-e01d-4d22-ade3-815adbff3b53">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDlegalAuthenticator): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(CDlegalAuthenticator): de elementwaarde MOET een zijn van 'vs_typerol Medische rollen (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(CDlegalAuthenticator): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_typerol Medische rollen (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900813
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:assignedPerson
Item: (CDlegalAuthenticator)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:assignedPerson"
         id="tmp-r-3432df96-33f4-4c7d-a5ea-2db119a94e7a">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="string(@classCode)=('PSN')">(CDlegalAuthenticator): de waarde van @classCode MOET 'PSN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(CDlegalAuthenticator): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor)">(CDlegalAuthenticator): element hl7:name is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:name)&lt;=1">(CDlegalAuthenticator): element hl7:name komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900813
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDlegalAuthenticator)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:assignedPerson/hl7:name"
         id="tmp-r-289bf15e-a8f5-458d-9eaf-6a7fb925a4b2">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDlegalAuthenticator): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="PN"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900813
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization
Item: (CDlegalAuthenticator)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization"
         id="tmp-r-fe5ef78d-0d43-47cd-adbb-1e31b2b58b18">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="string(@classCode)=('ORG')">(CDlegalAuthenticator): de waarde van @classCode MOET 'ORG' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(CDlegalAuthenticator): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <let name="elmcount"
           value="count(hl7:id[@root='2.16.528.1.1007.3.3']|hl7:id)"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="$elmcount&gt;=1">(CDlegalAuthenticator): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:id[@root='2.16.528.1.1007.3.3'])&lt;=1">(CDlegalAuthenticator): element hl7:id[@root='2.16.528.1.1007.3.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor)">(CDlegalAuthenticator): element hl7:name is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:name)&lt;=1">(CDlegalAuthenticator): element hl7:name komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:addr)&lt;=1">(CDlegalAuthenticator): element hl7:addr komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(lab:code)&lt;=1">(CDlegalAuthenticator): element lab:code komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization
Item: (CDArepresentedOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:id[@root='2.16.528.1.1007.3.3']
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:id[@root='2.16.528.1.1007.3.3']"
         id="tmp-r-4ee7e2f9-f953-48d6-b034-9c551615d3e6">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="string(@root)=('2.16.528.1.1007.3.3')">(CDArepresentedOrganization): de waarde van @root MOET '2.16.528.1.1007.3.3' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:id
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:id"
         id="tmp-r-fa2d9b48-24fa-4bb3-a5c4-2f592903a75b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:name
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:name"
         id="tmp-r-496a3236-a64c-4453-8c15-fd7bbc735227">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="ON"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:addr
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:addr"
         id="tmp-r-756e60f9-4e90-433b-92bb-e775bd41f445">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="AD"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:telecom
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:telecom"
         id="tmp-r-7ebdf3b1-8d1e-4157-a93c-2c47d3f13129">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TEL"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/lab:code
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/lab:code"
         id="tmp-r-132dbe88-acd8-491e-a284-65855eacb27d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(CDArepresentedOrganization): de elementwaarde MOET een zijn van 'vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(CDArepresentedOrganization): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900817
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant
Item: (CDAParticipantVerifier)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant"
         id="tmp-r-6caf012e-6fc5-4810-93aa-a82d6523596c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="string(@typeCode)=('VRF')">(CDAParticipantVerifier): de waarde van @typeCode MOET 'VRF' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="count(hl7:time)&lt;=1">(CDAParticipantVerifier): element hl7:time komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="count(hl7:associatedEntity)&gt;=1 and not(hl7:associatedEntity/@nullFlavor)">(CDAParticipantVerifier): element hl7:associatedEntity is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="count(hl7:associatedEntity)&lt;=1">(CDAParticipantVerifier): element hl7:associatedEntity komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900817
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:time
Item: (CDAParticipantVerifier)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:time"
         id="tmp-r-2d1617cc-ef89-4fcc-8e40-2256788cb050">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantVerifier): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TS.DATE.MIN"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900817
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity
Item: (CDAParticipantVerifier)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity"
         id="tmp-r-d1c96fb1-6047-4781-ab20-b33af9505bfa">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="string(@classCode)=('ASSIGNED')">(CDAParticipantVerifier): de waarde van @classCode MOET 'ASSIGNED' zijn.</assert>
      <let name="elmcount"
           value="count(hl7:id[@root='2.16.528.1.1007.3.1']|hl7:id)"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="$elmcount&gt;=1">(CDAParticipantVerifier): keuze (hl7:id[@root='2.16.528.1.1007.3.1'] of hl7:id) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="count(hl7:id[@root='2.16.528.1.1007.3.1'])&lt;=1">(CDAParticipantVerifier): element hl7:id[@root='2.16.528.1.1007.3.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="count(hl7:code)&lt;=1">(CDAParticipantVerifier): element hl7:code komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="count(hl7:associatedPerson)&lt;=1">(CDAParticipantVerifier): element hl7:associatedPerson komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="count(hl7:scopingOrganization)&lt;=1">(CDAParticipantVerifier): element hl7:scopingOrganization komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900829
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity
Item: (CDAassignedEntityIdentification)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900829
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:id[@root='2.16.528.1.1007.3.1']
Item: (CDAassignedEntityIdentification)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:id[@root='2.16.528.1.1007.3.1']"
         id="tmp-r-5e64f585-7f67-4fcf-82f1-f7d087cfb903">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAassignedEntityIdentification): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html"
              test="string(@root)=('2.16.528.1.1007.3.1')">(CDAassignedEntityIdentification): de waarde van @root MOET '2.16.528.1.1007.3.1' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900829
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:id
Item: (CDAassignedEntityIdentification)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:id"
         id="tmp-r-98df7159-5ccd-4098-aaa0-56b3f7364dcb">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAassignedEntityIdentification): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900817
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:code
Item: (CDAParticipantVerifier)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:code"
         id="tmp-r-84b97fb1-506b-4398-b5cc-95a141355c58">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantVerifier): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(CDAParticipantVerifier): de elementwaarde MOET een zijn van 'vs_typerol Medische rollen (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(CDAParticipantVerifier): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_typerol Medische rollen (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900817
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:associatedPerson
Item: (CDAParticipantVerifier)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:associatedPerson"
         id="tmp-r-5b6fd298-43e8-43a8-8c1b-df1b77ffb70d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="string(@classCode)=('PSN')">(CDAParticipantVerifier): de waarde van @classCode MOET 'PSN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(CDAParticipantVerifier): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor)">(CDAParticipantVerifier): element hl7:name is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="count(hl7:name)&lt;=1">(CDAParticipantVerifier): element hl7:name komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900817
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:associatedPerson/hl7:name
Item: (CDAParticipantVerifier)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:associatedPerson/hl7:name"
         id="tmp-r-debe527e-7e2a-47aa-bd44-9dd801c74198">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantVerifier): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="PN"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900817
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization
Item: (CDAParticipantVerifier)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization"
         id="tmp-r-b4ef244d-f80e-480b-b813-21ee30267572">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="string(@classCode)=('ORG')">(CDAParticipantVerifier): de waarde van @classCode MOET 'ORG' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(CDAParticipantVerifier): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <let name="elmcount"
           value="count(hl7:id[@root='2.16.528.1.1007.3.3']|hl7:id)"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="$elmcount&gt;=1">(CDAParticipantVerifier): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="count(hl7:id[@root='2.16.528.1.1007.3.3'])&lt;=1">(CDAParticipantVerifier): element hl7:id[@root='2.16.528.1.1007.3.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor)">(CDAParticipantVerifier): element hl7:name is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="count(hl7:name)&lt;=1">(CDAParticipantVerifier): element hl7:name komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="count(hl7:addr)&lt;=1">(CDAParticipantVerifier): element hl7:addr komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="count(lab:code)&lt;=1">(CDAParticipantVerifier): element lab:code komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization
Item: (CDArepresentedOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/hl7:id[@root='2.16.528.1.1007.3.3']
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/hl7:id[@root='2.16.528.1.1007.3.3']"
         id="tmp-r-8b9d3c28-0b27-461a-8f6e-be8d9037cd1f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="string(@root)=('2.16.528.1.1007.3.3')">(CDArepresentedOrganization): de waarde van @root MOET '2.16.528.1.1007.3.3' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/hl7:id
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/hl7:id"
         id="tmp-r-b2c3d43b-d8c8-4b01-82f9-9d64ff2312a5">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/hl7:name
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/hl7:name"
         id="tmp-r-7fa93813-4926-4854-bf9b-4cab107a98a9">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="ON"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/hl7:addr
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/hl7:addr"
         id="tmp-r-6d19bff2-64ba-46d1-b868-161c76305de5">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="AD"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/hl7:telecom
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/hl7:telecom"
         id="tmp-r-a47f6ab7-68d5-4bb5-b9b0-6817fee1a714">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TEL"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/lab:code
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/lab:code"
         id="tmp-r-576b57b7-a35a-4cbb-8190-383ababa32a2">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(CDArepresentedOrganization): de elementwaarde MOET een zijn van 'vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(CDArepresentedOrganization): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900814
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:relatedDocument
Item: (CDArelatedDocument)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:relatedDocument"
         id="tmp-r-47eb291b-f962-42b8-8273-143660052ff5">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900814-2012-07-04T000000.html"
              test="string(@typeCode)=('RPLC')">(CDArelatedDocument): de waarde van @typeCode MOET 'RPLC' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900815
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]
Item: (CDAdocumentationOfMDL)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]"
         id="tmp-r-b275ab8f-925c-4e7d-9d46-dcb32500a88b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="string(@typeCode)=('DOC')">(CDAdocumentationOfMDL): de waarde van @typeCode MOET 'DOC' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="count(hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]])&gt;=1 and not(hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/@nullFlavor)">(CDAdocumentationOfMDL): element hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="count(hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]])&lt;=1">(CDAdocumentationOfMDL): element hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900815
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]
Item: (CDAdocumentationOfMDL)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]"
         id="tmp-r-f4696458-27fa-4410-8045-c6b4198581cc">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="string(@classCode)=('OBS')">(CDAdocumentationOfMDL): de waarde van @classCode MOET 'OBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="string(@moodCode)=('EVN')">(CDAdocumentationOfMDL): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="count(hl7:id)&gt;=1 ">(CDAdocumentationOfMDL): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="count(hl7:id)&lt;=1">(CDAdocumentationOfMDL): element hl7:id komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="count(hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')])&gt;=1 and not(hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]/@nullFlavor)">(CDAdocumentationOfMDL): element hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="count(hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')])&lt;=1">(CDAdocumentationOfMDL): element hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="count(lab:statusCode[@code='completed'])&gt;=1 and not(lab:statusCode[@code='completed']/@nullFlavor)">(CDAdocumentationOfMDL): element lab:statusCode[@code='completed'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="count(lab:statusCode[@code='completed'])&lt;=1">(CDAdocumentationOfMDL): element lab:statusCode[@code='completed'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="count(hl7:effectiveTime)&lt;=1">(CDAdocumentationOfMDL): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="count(hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]])&gt;=1 ">(CDAdocumentationOfMDL): element hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="count(hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]])&lt;=1">(CDAdocumentationOfMDL): element hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900815
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:id
Item: (CDAdocumentationOfMDL)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:id"
         id="tmp-r-7102e006-8393-4dba-a1ad-52597033606c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAdocumentationOfMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900815
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]
Item: (CDAdocumentationOfMDL)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]"
         id="tmp-r-71957a90-d7b1-4b70-958c-6f8160ec14a6">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAdocumentationOfMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="@nullFlavor or (@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')">(CDAdocumentationOfMDL): de elementwaarde MOET een zijn van 'code '18746-8' codeSystem '2.16.840.1.113883.6.1''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900815
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/lab:statusCode[@code='completed']
Item: (CDAdocumentationOfMDL)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/lab:statusCode[@code='completed']"
         id="tmp-r-5174565a-5983-48a0-a219-60bc996efb06">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAdocumentationOfMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="@nullFlavor or (@code='completed')">(CDAdocumentationOfMDL): de elementwaarde MOET een zijn van 'code 'completed''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900815
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:effectiveTime
Item: (CDAdocumentationOfMDL)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:effectiveTime"
         id="tmp-r-3e58baf5-22df-466f-8eb3-ada641cfccf6">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAdocumentationOfMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="count(hl7:low)&gt;=1 ">(CDAdocumentationOfMDL): element hl7:low is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="count(hl7:low)&lt;=1">(CDAdocumentationOfMDL): element hl7:low komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="count(hl7:high)&gt;=1 ">(CDAdocumentationOfMDL): element hl7:high is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="count(hl7:high)&lt;=1">(CDAdocumentationOfMDL): element hl7:high komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900005
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:effectiveTime/hl7:low
Item: (StartServiceDate)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:effectiveTime/hl7:low"
         id="tmp-r-c4d0adc2-7801-41cc-a647-f1115d394cac">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900005-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(StartServiceDate): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TS"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900035
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:effectiveTime/hl7:high
Item: (EndServiceDate)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:effectiveTime/hl7:high"
         id="tmp-r-badb2221-5c0a-410a-bc6d-8e7ac9996682">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900035-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(EndServiceDate): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TS"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900815
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]
Item: (CDAdocumentationOfMDL)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]"
         id="tmp-r-a479bfa8-03fa-42ae-97e3-5def7ceccdb2">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="string(@typeCode)=('PRF')">(CDAdocumentationOfMDL): de waarde van @typeCode MOET 'PRF' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="count(hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]])&gt;=1 ">(CDAdocumentationOfMDL): element hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="count(hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]])&lt;=1">(CDAdocumentationOfMDL): element hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900815
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]
Item: (CDAdocumentationOfMDL)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]"
         id="tmp-r-25390fef-a9e2-4b25-b596-558d57c18dee">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="string(@classCode)=('ASSIGNED')">(CDAdocumentationOfMDL): de waarde van @classCode MOET 'ASSIGNED' zijn.</assert>
      <let name="elmcount"
           value="count(hl7:id[@root='2.16.528.1.1007.3.1']|hl7:id)"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="$elmcount&gt;=1">(CDAdocumentationOfMDL): keuze (hl7:id[@root='2.16.528.1.1007.3.1'] of hl7:id) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="count(hl7:id[@root='2.16.528.1.1007.3.1'])&lt;=1">(CDAdocumentationOfMDL): element hl7:id[@root='2.16.528.1.1007.3.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="count(hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])&gt;=1 ">(CDAdocumentationOfMDL): element hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="count(hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])&lt;=1">(CDAdocumentationOfMDL): element hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="count(hl7:assignedPerson)&gt;=1 ">(CDAdocumentationOfMDL): element hl7:assignedPerson is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="count(hl7:assignedPerson)&lt;=1">(CDAdocumentationOfMDL): element hl7:assignedPerson komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="count(hl7:representedOrganization)&gt;=1 ">(CDAdocumentationOfMDL): element hl7:representedOrganization is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="count(hl7:representedOrganization)&lt;=1">(CDAdocumentationOfMDL): element hl7:representedOrganization komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900829
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]
Item: (CDAassignedEntityIdentification)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900829
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:id[@root='2.16.528.1.1007.3.1']
Item: (CDAassignedEntityIdentification)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:id[@root='2.16.528.1.1007.3.1']"
         id="tmp-r-9ba45a94-11d4-4784-b2be-789f8740ab41">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAassignedEntityIdentification): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html"
              test="string(@root)=('2.16.528.1.1007.3.1')">(CDAassignedEntityIdentification): de waarde van @root MOET '2.16.528.1.1007.3.1' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900829
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:id
Item: (CDAassignedEntityIdentification)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:id"
         id="tmp-r-f190139d-9e6a-4f4c-b960-409bf8816485">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAassignedEntityIdentification): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900815
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]
Item: (CDAdocumentationOfMDL)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]"
         id="tmp-r-1c9f3ed4-0984-4cf2-a712-1f106c7521e7">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAdocumentationOfMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(CDAdocumentationOfMDL): de elementwaarde MOET een zijn van 'vs_typerol Medische rollen (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(CDAdocumentationOfMDL): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_typerol Medische rollen (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900815
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:addr
Item: (CDAdocumentationOfMDL)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:addr"
         id="tmp-r-84246260-05ac-4ed3-845e-9b890e5cade4">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAdocumentationOfMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="AD"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900815
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:telecom
Item: (CDAdocumentationOfMDL)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:telecom"
         id="tmp-r-b6da1e8d-23f9-41e0-b187-132098353a73">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAdocumentationOfMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TEL"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900815
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:assignedPerson
Item: (CDAdocumentationOfMDL)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:assignedPerson"
         id="tmp-r-efaaa7e5-7041-453d-95bb-1ffdb302f761">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="string(@classCode)=('PSN')">(CDAdocumentationOfMDL): de waarde van @classCode MOET 'PSN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(CDAdocumentationOfMDL): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="count(hl7:name)&gt;=1 ">(CDAdocumentationOfMDL): element hl7:name is required [min 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900815
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:assignedPerson/hl7:name
Item: (CDAdocumentationOfMDL)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:assignedPerson/hl7:name"
         id="tmp-r-23526238-b6af-40ef-bb92-87f80f913e2d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAdocumentationOfMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="PN"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900815
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization
Item: (CDAdocumentationOfMDL)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization"
         id="tmp-r-b4194594-51ff-4a8a-aba4-5abaac91e635">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="string(@classCode)=('ORG')">(CDAdocumentationOfMDL): de waarde van @classCode MOET 'ORG' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(CDAdocumentationOfMDL): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <let name="elmcount"
           value="count(hl7:id[@root='2.16.528.1.1007.3.3']|hl7:id)"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="$elmcount&gt;=1">(CDAdocumentationOfMDL): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="count(hl7:id[@root='2.16.528.1.1007.3.3'])&lt;=1">(CDAdocumentationOfMDL): element hl7:id[@root='2.16.528.1.1007.3.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor)">(CDAdocumentationOfMDL): element hl7:name is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="count(hl7:name)&lt;=1">(CDAdocumentationOfMDL): element hl7:name komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="count(hl7:addr)&lt;=1">(CDAdocumentationOfMDL): element hl7:addr komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="count(lab:code)&lt;=1">(CDAdocumentationOfMDL): element lab:code komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization
Item: (CDArepresentedOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:id[@root='2.16.528.1.1007.3.3']
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:id[@root='2.16.528.1.1007.3.3']"
         id="tmp-r-7b8a1d85-e687-4340-be65-45277d1e2f1b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="string(@root)=('2.16.528.1.1007.3.3')">(CDArepresentedOrganization): de waarde van @root MOET '2.16.528.1.1007.3.3' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:id
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:id"
         id="tmp-r-9579ea3b-7c5f-4978-a2c2-6418e1bc6e0c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:name
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:name"
         id="tmp-r-4104fa2b-abb9-4132-9eeb-f232e2cdc6fc">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="ON"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:addr
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:addr"
         id="tmp-r-998d014c-ad8a-414e-99e2-8e398e8aa292">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="AD"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:telecom
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:telecom"
         id="tmp-r-adf6760a-c8cf-40c5-a5d7-ba0a7c7ea851">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TEL"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/lab:code
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/lab:code"
         id="tmp-r-f87e4053-3b6f-4295-a934-5a42a86ab848">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(CDArepresentedOrganization): de elementwaarde MOET een zijn van 'vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(CDArepresentedOrganization): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.10
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component
Item: (nspbcmdl)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component"
         id="tmp-r-9d30bc58-bb20-4472-b8a9-85619fdb36ad">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="string(@typeCode)=('COMP')">(nspbcmdl): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="string(@contextConductionInd)=('true')">(nspbcmdl): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.10
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody
Item: (nspbcmdl)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody"
         id="tmp-r-a77a7745-095f-4a1c-8432-95ca1fc4298e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="string(@classCode)=('DOCBODY')">(nspbcmdl): de waarde van @classCode MOET 'DOCBODY' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="string(@moodCode)=('EVN')">(nspbcmdl): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.201']])&lt;=1">(nspbcmdl): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.201']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']])&gt;=1 and not(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']]/@nullFlavor)">(nspbcmdl): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']])&lt;=1">(nspbcmdl): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']])&gt;=1 and not(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/@nullFlavor)">(nspbcmdl): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']])&lt;=1">(nspbcmdl): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']])&gt;=1 and not(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/@nullFlavor)">(nspbcmdl): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']])&lt;=1">(nspbcmdl): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']])&gt;=1 and not(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/@nullFlavor)">(nspbcmdl): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']])&lt;=1">(nspbcmdl): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']])&gt;=1 and not(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]/@nullFlavor)">(nspbcmdl): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']])&lt;=1">(nspbcmdl): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']])&gt;=1 and not(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']]/@nullFlavor)">(nspbcmdl): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']])&lt;=1">(nspbcmdl): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.10
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.201']]
Item: (nspbcmdl)
-->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.201']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="string(@typeCode)=('COMP')">(nspbcmdl): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="string(@contextConductionInd)=('true')">(nspbcmdl): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.10
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']]
Item: (nspbcmdl)
-->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="string(@typeCode)=('COMP')">(nspbcmdl): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="string(@contextConductionInd)=('true')">(nspbcmdl): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.10
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]
Item: (nspbcmdl)
-->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="string(@typeCode)=('COMP')">(nspbcmdl): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="string(@contextConductionInd)=('true')">(nspbcmdl): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.10
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]
Item: (nspbcmdl)
-->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="string(@typeCode)=('COMP')">(nspbcmdl): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="string(@contextConductionInd)=('true')">(nspbcmdl): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.10
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]
Item: (nspbcmdl)
-->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="string(@typeCode)=('COMP')">(nspbcmdl): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="string(@contextConductionInd)=('true')">(nspbcmdl): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.10
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]
Item: (nspbcmdl)
-->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="string(@typeCode)=('COMP')">(nspbcmdl): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="string(@contextConductionInd)=('true')">(nspbcmdl): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.10
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']]
Item: (nspbcmdl)
-->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="string(@typeCode)=('COMP')">(nspbcmdl): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="string(@contextConductionInd)=('true')">(nspbcmdl): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/*[not(self::hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1'])]"
         id="tmp-r-a9f44553-029d-4275-8e7d-484e60548c5e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-a9f44553-029d-4275-8e7d-484e60548c5e)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/*[not(self::hl7:realmCode[@code='NL']|self::hl7:typeId[@root='2.16.840.1.113883.1.3']|self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.10']|self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1']|self::hl7:id|self::hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:title|self::hl7:effectiveTime|self::hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]|self::hl7:languageCode|self::hl7:setId|self::hl7:versionNumber|self::hl7:recordTarget|self::hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100']|self::hl7:custodian|self::hl7:informationRecipient|self::hl7:authenticator|self::hl7:legalAuthenticator|self::hl7:participant|self::hl7:relatedDocument|self::hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]|self::hl7:component)]"
         id="tmp-r-4d853b58-1113-45eb-bd10-74b6b606df87">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-4d853b58-1113-45eb-bd10-74b6b606df87)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget/*[not(self::hl7:patientRole)]"
         id="tmp-r-496d174a-adc6-489b-8985-f331e8d01ae5">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900808-2012-07-04T000000.html"
              test="not(.)">(CDArecordTarget): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-496d174a-adc6-489b-8985-f331e8d01ae5)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget/hl7:patientRole/*[not(self::hl7:id[@root='2.16.840.1.113883.2.4.6.3']|self::hl7:id)]"
         id="tmp-r-22e7f1c1-bbf1-4182-ad75-f056006dfdba">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900808-2012-07-04T000000.html"
              test="not(.)">(CDArecordTarget): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-22e7f1c1-bbf1-4182-ad75-f056006dfdba)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.100']|self::hl7:time|self::hl7:assignedAuthor)]"
         id="tmp-r-0262fc18-75ea-4353-8fe0-9ae6a6c4c536">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.100-2012-07-04T000000.html"
              test="not(.)">(CDAauthor): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-0262fc18-75ea-4353-8fe0-9ae6a6c4c536)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100']/hl7:assignedAuthor/*[not(self::hl7:id[@root='2.16.528.1.1007.3.1']|self::hl7:id|self::hl7:code|self::hl7:assignedPerson|self::hl7:representedOrganization)]"
         id="tmp-r-24815a0e-67e0-4fcf-83c2-7e7c76e92e74">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.100-2012-07-04T000000.html"
              test="not(.)">(CDAauthor): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-24815a0e-67e0-4fcf-83c2-7e7c76e92e74)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100']/hl7:assignedAuthor/hl7:assignedPerson/*[not(self::hl7:name)]"
         id="tmp-r-eb338695-dad4-4b85-9716-e9f198d02b81">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.100-2012-07-04T000000.html"
              test="not(.)">(CDAauthor): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-eb338695-dad4-4b85-9716-e9f198d02b81)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100']/hl7:assignedAuthor/hl7:representedOrganization/*[not(self::hl7:id[@root='2.16.528.1.1007.3.3']|self::hl7:id|self::hl7:name|self::hl7:addr|self::hl7:telecom|self::lab:code)]"
         id="tmp-r-a2693df5-12da-44e8-8933-fea2f1adb069">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.100-2012-07-04T000000.html"
              test="not(.)">(CDAauthor): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-a2693df5-12da-44e8-8933-fea2f1adb069)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/*[not(self::hl7:assignedCustodian)]"
         id="tmp-r-fd3e92c9-6ca7-41ab-8482-1634e5cf4898">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="not(.)">(CDAcustodian): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-fd3e92c9-6ca7-41ab-8482-1634e5cf4898)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/*[not(self::hl7:representedCustodianOrganization)]"
         id="tmp-r-e2afd3e0-5cb7-46dc-af35-a90b5496bbcb">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="not(.)">(CDAcustodian): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-e2afd3e0-5cb7-46dc-af35-a90b5496bbcb)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/*[not(self::hl7:id[@root='2.16.528.1.1007.3.3']|self::hl7:id|self::hl7:name|self::hl7:addr|self::hl7:telecom|self::lab:code)]"
         id="tmp-r-0cea747e-ffb0-49ce-a528-25939b321837">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="not(.)">(CDAcustodian): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-0cea747e-ffb0-49ce-a528-25939b321837)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/*[not(self::hl7:intendedRecipient)]"
         id="tmp-r-c60bd9cf-f81c-46c5-ae55-b86f425c5fb1">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="not(.)">(CDAinformationRecipient): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-c60bd9cf-f81c-46c5-ae55-b86f425c5fb1)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/*[not(self::hl7:id|self::hl7:informationRecipient|self::hl7:representedOrganization)]"
         id="tmp-r-e2336fcf-62ac-4332-be26-ecf313567cd5">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="not(.)">(CDAinformationRecipient): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-e2336fcf-62ac-4332-be26-ecf313567cd5)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:informationRecipient/*[not(self::hl7:name)]"
         id="tmp-r-df1cdb4b-dcb1-419a-9a1c-5bf8c67bf3e1">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="not(.)">(CDAinformationRecipient): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-df1cdb4b-dcb1-419a-9a1c-5bf8c67bf3e1)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/*[not(self::hl7:id[@root='2.16.528.1.1007.3.3']|self::hl7:id|self::hl7:name|self::hl7:addr|self::hl7:telecom|self::lab:code)]"
         id="tmp-r-9a045c51-8d33-4e15-949a-5e4bccf580a9">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="not(.)">(CDAinformationRecipient): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-9a045c51-8d33-4e15-949a-5e4bccf580a9)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/*[not(self::hl7:time|self::hl7:signatureCode[@code='S']|self::hl7:assignedEntity)]"
         id="tmp-r-9fe40687-c456-403b-a8d8-e1297adf15e5">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="not(.)">(CDlegalAuthenticator): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-9fe40687-c456-403b-a8d8-e1297adf15e5)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/*[not(self::hl7:id[@root='2.16.528.1.1007.3.1']|self::hl7:id|self::hl7:code|self::hl7:assignedPerson|self::hl7:representedOrganization)]"
         id="tmp-r-61f0fbf1-85b3-4f15-8689-5c00acf781ec">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="not(.)">(CDlegalAuthenticator): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-61f0fbf1-85b3-4f15-8689-5c00acf781ec)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:assignedPerson/*[not(self::hl7:name)]"
         id="tmp-r-c59afef2-c756-48b2-b26a-cb1d4027e5b5">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="not(.)">(CDlegalAuthenticator): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-c59afef2-c756-48b2-b26a-cb1d4027e5b5)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/*[not(self::hl7:id[@root='2.16.528.1.1007.3.3']|self::hl7:id|self::hl7:name|self::hl7:addr|self::hl7:telecom|self::lab:code)]"
         id="tmp-r-c2fffb6d-5feb-4eaa-a453-441c3fbe049c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="not(.)">(CDlegalAuthenticator): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-c2fffb6d-5feb-4eaa-a453-441c3fbe049c)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/*[not(self::hl7:time|self::hl7:associatedEntity)]"
         id="tmp-r-d805c1dc-6225-4a43-a628-207bc0a3d6e9">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="not(.)">(CDAParticipantVerifier): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-d805c1dc-6225-4a43-a628-207bc0a3d6e9)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/*[not(self::hl7:id[@root='2.16.528.1.1007.3.1']|self::hl7:id|self::hl7:code|self::hl7:associatedPerson|self::hl7:scopingOrganization)]"
         id="tmp-r-56702a40-aa84-427a-8768-57a30fb1fa1b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="not(.)">(CDAParticipantVerifier): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-56702a40-aa84-427a-8768-57a30fb1fa1b)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:associatedPerson/*[not(self::hl7:name)]"
         id="tmp-r-321f953e-28a1-4cab-a439-a0b34901f37c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="not(.)">(CDAParticipantVerifier): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-321f953e-28a1-4cab-a439-a0b34901f37c)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/*[not(self::hl7:id[@root='2.16.528.1.1007.3.3']|self::hl7:id|self::hl7:name|self::hl7:addr|self::hl7:telecom|self::lab:code)]"
         id="tmp-r-41ec8c39-2f1f-425d-87c1-e84226ea7849">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="not(.)">(CDAParticipantVerifier): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-41ec8c39-2f1f-425d-87c1-e84226ea7849)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/*[not(self::hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]])]"
         id="tmp-r-68df3a64-0bcb-4f56-9cfd-020570377f04">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="not(.)">(CDAdocumentationOfMDL): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-68df3a64-0bcb-4f56-9cfd-020570377f04)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/*[not(self::hl7:id|self::hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]|self::lab:statusCode[@code='completed']|self::hl7:effectiveTime|self::hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]])]"
         id="tmp-r-1a9ff877-a5d4-42e2-b72d-e00c3ff5a45a">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="not(.)">(CDAdocumentationOfMDL): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-1a9ff877-a5d4-42e2-b72d-e00c3ff5a45a)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:effectiveTime/*[not(self::hl7:low|self::hl7:high)]"
         id="tmp-r-d93ce904-9d5d-4356-ba70-74bbc4f1a1f4">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="not(.)">(CDAdocumentationOfMDL): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-d93ce904-9d5d-4356-ba70-74bbc4f1a1f4)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/*[not(self::hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]])]"
         id="tmp-r-b64a086a-7d33-4514-9f3e-95f560168fa2">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="not(.)">(CDAdocumentationOfMDL): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-b64a086a-7d33-4514-9f3e-95f560168fa2)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/*[not(self::hl7:id[@root='2.16.528.1.1007.3.1']|self::hl7:id|self::hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]|self::hl7:addr|self::hl7:telecom|self::hl7:assignedPerson|self::hl7:representedOrganization)]"
         id="tmp-r-5f4f6760-dfb2-4444-9a4c-db8f669930eb">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="not(.)">(CDAdocumentationOfMDL): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-5f4f6760-dfb2-4444-9a4c-db8f669930eb)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:assignedPerson/*[not(self::hl7:name)]"
         id="tmp-r-20b815b6-620d-49fe-91c7-090420cdeda8">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="not(.)">(CDAdocumentationOfMDL): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-20b815b6-620d-49fe-91c7-090420cdeda8)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/*[not(self::hl7:id[@root='2.16.528.1.1007.3.3']|self::hl7:id|self::hl7:name|self::hl7:addr|self::hl7:telecom|self::lab:code)]"
         id="tmp-r-fedf7cac-3ca0-4857-ab56-2c761c048459">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2012-07-04T000000.html"
              test="not(.)">(CDAdocumentationOfMDL): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-fedf7cac-3ca0-4857-ab56-2c761c048459)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/*[not(self::hl7:structuredBody)]"
         id="tmp-r-951c30e8-efdb-42e5-b451-9d1cc0a5159e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-951c30e8-efdb-42e5-b451-9d1cc0a5159e)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/*[not(self::hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.201']]|self::hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']]|self::hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]|self::hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]|self::hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]|self::hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]|self::hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']])]"
         id="tmp-r-68add320-784f-424b-b8c9-9b95736586a4">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-68add320-784f-424b-b8c9-9b95736586a4)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.201']]/*[not(self::hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.201'])]"
         id="tmp-r-215011dd-12ff-4c33-b16b-92f981fcd0b4">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-215011dd-12ff-4c33-b16b-92f981fcd0b4)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.201']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.201']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.201']|self::hl7:code[(@code='X-SALUT' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:title|self::hl7:text)]"
         id="tmp-r-dca20dda-6874-497c-bf9a-f5887989e973">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-dca20dda-6874-497c-bf9a-f5887989e973)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']]/*[not(self::hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202'])]"
         id="tmp-r-727e9f54-1a39-47a6-82e9-dbed9dec6930">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-727e9f54-1a39-47a6-82e9-dbed9dec6930)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.202']|self::hl7:code[(@code='59768-2' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:title|self::hl7:text|self::hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']])]"
         id="tmp-r-2b125444-4e7e-48a1-b442-cafbb15963ff">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-2b125444-4e7e-48a1-b442-cafbb15963ff)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382'])]"
         id="tmp-r-521985d5-1afb-41af-855b-c3e776f120c7">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-521985d5-1afb-41af-855b-c3e776f120c7)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.382']|self::hl7:code[(@code='55607006' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:text|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.220-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.220-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.227-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.227-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])]"
         id="tmp-r-e6a5bcf0-bf6e-4381-b130-7d5ec52b821d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-e6a5bcf0-bf6e-4381-b130-7d5ec52b821d)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-410aceac-acfe-4274-9355-3a12e221addd">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-410aceac-acfe-4274-9355-3a12e221addd)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/*[not(self::hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203'])]"
         id="tmp-r-9ada5a4b-5717-4b2b-94a8-cca054f5e554">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-9ada5a4b-5717-4b2b-94a8-cca054f5e554)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.203']|self::hl7:code[(@code='29554-3' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:title|self::hl7:text|self::hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]|self::hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']]|self::hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.327']]|self::hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.342']])]"
         id="tmp-r-85da8fde-132e-4965-9a02-1bb68367a5e4">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-85da8fde-132e-4965-9a02-1bb68367a5e4)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/*[not(self::hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502'])]"
         id="tmp-r-9011c22e-4b9a-41ab-a5d8-59dc1ab027ed">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-9011c22e-4b9a-41ab-a5d8-59dc1ab027ed)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.502']|self::hl7:code[(@code='406187008' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:statusCode[@code='completed']|self::hl7:component[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]|self::hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.507']]|self::hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.504']])]"
         id="tmp-r-887c1288-bde6-4a38-bd8c-1ea51a755d41">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-887c1288-bde6-4a38-bd8c-1ea51a755d41)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/*[not(self::hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503'])]"
         id="tmp-r-e78d9a1d-9f87-4bca-99f0-f336c2cb78ff">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-e78d9a1d-9f87-4bca-99f0-f336c2cb78ff)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.503']|self::hl7:id|self::hl7:code[(@code='DRUG' and @codeSystem='2.16.840.1.113883.5.4')]|self::hl7:text|self::hl7:statusCode|self::hl7:effectiveTime|self::hl7:doseQuantity|self::hl7:consumable)]"
         id="tmp-r-3aaf3e5c-b98a-4a9e-a4dd-5c26c19732b2">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-3aaf3e5c-b98a-4a9e-a4dd-5c26c19732b2)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-c7049695-1cc3-4e99-871b-32d8102c6292">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-c7049695-1cc3-4e99-871b-32d8102c6292)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:consumable/*[not(self::hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]])]"
         id="tmp-r-dd785ec3-4acc-4ba0-ae2a-96a48bc37794">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900054-2012-04-10T000000.html"
              test="not(.)">(Medicationcoloscopy): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-dd785ec3-4acc-4ba0-ae2a-96a48bc37794)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:consumable/hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/*[not(self::hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]])]"
         id="tmp-r-2d3eaf0c-608d-4a21-842e-4cb1b2962e58">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900054-2012-04-10T000000.html"
              test="not(.)">(Medicationcoloscopy): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-2d3eaf0c-608d-4a21-842e-4cb1b2962e58)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:consumable/hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/*[not(self::hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]|self::hl7:name)]"
         id="tmp-r-eb59bd6a-e5e2-452d-8bc4-f6a0f8bfbe90">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900054-2012-04-10T000000.html"
              test="not(.)">(Medicationcoloscopy): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-eb59bd6a-e5e2-452d-8bc4-f6a0f8bfbe90)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.507']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.507'])]"
         id="tmp-r-fa4a4330-b8bd-4a7d-9dc1-5b2058638629">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-fa4a4330-b8bd-4a7d-9dc1-5b2058638629)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.507']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.507']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.507']|self::hl7:code[(@code='72641008' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:text|self::hl7:value)]"
         id="tmp-r-19df5b99-6d93-4ca3-a5eb-cc88e492dec0">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-19df5b99-6d93-4ca3-a5eb-cc88e492dec0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.507']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.507']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-e20d88c4-5b87-4258-a5f9-6be49993dae0">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-e20d88c4-5b87-4258-a5f9-6be49993dae0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.504']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.504'])]"
         id="tmp-r-d796d38d-c10f-4244-9be0-fc791b925a35">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-d796d38d-c10f-4244-9be0-fc791b925a35)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.504']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.504']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.504']|self::hl7:code[(@code='6942003' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:text|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.90-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.90-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])]"
         id="tmp-r-9b63ea3e-3f76-4d92-bdcf-95660defceec">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-9b63ea3e-3f76-4d92-bdcf-95660defceec)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.504']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.504']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-0045f867-95e6-4cad-bdf4-d01eaeb6a987">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-0045f867-95e6-4cad-bdf4-d01eaeb6a987)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305'])]"
         id="tmp-r-6107a5ef-9e37-4029-9ce4-523cab22ba6e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-6107a5ef-9e37-4029-9ce4-523cab22ba6e)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.305']|self::hl7:code[(@code='116223007' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:text|self::hl7:value|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.306']])]"
         id="tmp-r-1de9c2c9-0402-4c35-9256-6e5a2b8e4fc7">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-1de9c2c9-0402-4c35-9256-6e5a2b8e4fc7)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-f290102b-8cfe-453d-82b2-e01cfe6468a3">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-f290102b-8cfe-453d-82b2-e01cfe6468a3)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.306']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.306'])]"
         id="tmp-r-b6c2e06c-522c-4ab1-b5a3-3b8e8bdc0ee1">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-b6c2e06c-522c-4ab1-b5a3-3b8e8bdc0ee1)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.306']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.306']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.306']|self::hl7:code[(@code='SEV' and @codeSystem='2.16.840.1.113883.5.4')]|self::hl7:text|self::hl7:statusCode|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.36-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.36-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])]"
         id="tmp-r-751aabac-9a34-431c-affc-5191968c419b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-751aabac-9a34-431c-affc-5191968c419b)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.306']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.306']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-78071f66-98c1-4e31-9ed8-331961f3649c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-78071f66-98c1-4e31-9ed8-331961f3649c)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.327']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.327'])]"
         id="tmp-r-ac4d28e9-d211-4d8f-9397-f36389495be8">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-ac4d28e9-d211-4d8f-9397-f36389495be8)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.327']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.327']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.327']|self::hl7:code[(@code='62387-6' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:text|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.77-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.77-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-d272bba2-5fd1-4c09-8580-1b73b746185b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-d272bba2-5fd1-4c09-8580-1b73b746185b)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.327']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.327']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-1d1816be-f363-406b-beb0-351785b14302">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-1d1816be-f363-406b-beb0-351785b14302)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.342']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.342'])]"
         id="tmp-r-645c674e-19d2-48d9-b0af-b1e4e082f699">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-645c674e-19d2-48d9-b0af-b1e4e082f699)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.342']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.342']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.342']|self::hl7:code[(@code='416393001' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:text|self::hl7:value)]"
         id="tmp-r-96b645ff-167f-46e3-8564-ee39f8950a41">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-96b645ff-167f-46e3-8564-ee39f8950a41)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.342']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.342']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-4490955f-e487-4d52-acab-fdb145e72a89">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-4490955f-e487-4d52-acab-fdb145e72a89)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/*[not(self::hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204'])]"
         id="tmp-r-d1ea5d83-010f-457a-97bc-d1bc98d8e080">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-d1ea5d83-010f-457a-97bc-d1bc98d8e080)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.204']|self::hl7:code[(@code='59776-5' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:title|self::hl7:text|self::hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.337']]|self::hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]|self::hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']])]"
         id="tmp-r-4c4a311b-3409-4d9a-ae44-628d3fee0fa8">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-4c4a311b-3409-4d9a-ae44-628d3fee0fa8)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.337']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.337'])]"
         id="tmp-r-ebb784b9-2fc6-4949-920f-fda2903e374d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-ebb784b9-2fc6-4949-920f-fda2903e374d)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.337']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.337']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.337']|self::hl7:code[(@code='102486008' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:text|self::hl7:value)]"
         id="tmp-r-77fbdd7f-5e77-4af2-bb8b-97403b7515e2">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-77fbdd7f-5e77-4af2-bb8b-97403b7515e2)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.337']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.337']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-c20fb708-2601-4d8d-a3be-17fc2c911787">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-c20fb708-2601-4d8d-a3be-17fc2c911787)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/*[not(self::hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307'])]"
         id="tmp-r-8cf1b301-6052-4489-a758-34209fbda0cb">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-8cf1b301-6052-4489-a758-34209fbda0cb)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.307']|self::hl7:code[(@code='225106003' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:text|self::hl7:entryRelationship[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']])]"
         id="tmp-r-5abb1294-c135-4b17-9415-205c477ad48f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-5abb1294-c135-4b17-9415-205c477ad48f)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:code[(@code='225106003' and @codeSystem='2.16.840.1.113883.6.96')]/*[not(self::hl7:qualifier)]"
         id="tmp-r-93d4c2e0-009d-4692-857d-f5d03cbdff03">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-93d4c2e0-009d-4692-857d-f5d03cbdff03)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:code[(@code='225106003' and @codeSystem='2.16.840.1.113883.6.96')]/hl7:qualifier/*[not(self::hl7:name[(@code='370134009' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.223-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.223-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-50b93ee2-b319-4034-913c-2dca83f791ed">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-50b93ee2-b319-4034-913c-2dca83f791ed)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-66b97484-174f-4d87-aeee-b5eeaa072612">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-66b97484-174f-4d87-aeee-b5eeaa072612)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341']]/*[not(self::hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341'])]"
         id="tmp-r-90139295-51d4-4257-b464-d58a6ceda361">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-90139295-51d4-4257-b464-d58a6ceda361)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.341']|self::hl7:id|self::hl7:consumable)]"
         id="tmp-r-2d7b4349-73c6-435e-8846-c51cdb20e000">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-2d7b4349-73c6-435e-8846-c51cdb20e000)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341']/hl7:consumable/*[not(self::hl7:manufacturedProduct[hl7:manufacturedMaterial[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]])]"
         id="tmp-r-e7650c26-55ff-4537-bafc-37fb4d24a065">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900088-2012-04-10T000000.html"
              test="not(.)">(Medicationforpreparation): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-e7650c26-55ff-4537-bafc-37fb4d24a065)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341']/hl7:consumable/hl7:manufacturedProduct[hl7:manufacturedMaterial[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/*[not(self::hl7:manufacturedMaterial[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]])]"
         id="tmp-r-e3d55aa9-9a9d-461d-85fc-5e2390f1cc1e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900088-2012-04-10T000000.html"
              test="not(.)">(Medicationforpreparation): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-e3d55aa9-9a9d-461d-85fc-5e2390f1cc1e)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341']/hl7:consumable/hl7:manufacturedProduct[hl7:manufacturedMaterial[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:manufacturedMaterial[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/*[not(self::hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-81e8f4f0-aae6-4be2-be63-325f29c0ad91">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900088-2012-04-10T000000.html"
              test="not(.)">(Medicationforpreparation): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-81e8f4f0-aae6-4be2-be63-325f29c0ad91)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310'])]"
         id="tmp-r-66fb9c9a-004d-4254-b03e-243d7f5274cb">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-66fb9c9a-004d-4254-b03e-243d7f5274cb)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.310']|self::hl7:code[(@code='X_BBPSSS' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:text|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.103-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.103-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.311']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.312']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.313']])]"
         id="tmp-r-edbc5656-1be9-4bb4-a083-34f7b9280a41">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-edbc5656-1be9-4bb4-a083-34f7b9280a41)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-54575971-7e14-4c0d-804f-f10a6b5702f0">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-54575971-7e14-4c0d-804f-f10a6b5702f0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.311']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.311'])]"
         id="tmp-r-b7e666d7-f581-4658-809f-e8663f51e9d0">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-b7e666d7-f581-4658-809f-e8663f51e9d0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.311']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.311']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.311']|self::hl7:code[(@code='X_BBPSCR' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.102-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.102-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-bdf5dea6-5f04-4173-ac3a-45eabd3d6503">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-bdf5dea6-5f04-4173-ac3a-45eabd3d6503)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.312']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.312'])]"
         id="tmp-r-32ed9288-209f-402f-921b-2d791a805fba">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-32ed9288-209f-402f-921b-2d791a805fba)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.312']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.312']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.312']|self::hl7:code[(@code='X_BBPSCT' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.102-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.102-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-b355e7c2-bd71-4d42-88d2-5b013e2bd3ac">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-b355e7c2-bd71-4d42-88d2-5b013e2bd3ac)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.313']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.313'])]"
         id="tmp-r-a619de8b-2e7e-4e0b-875a-24dc7671c64d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-a619de8b-2e7e-4e0b-875a-24dc7671c64d)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.313']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.313']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.313']|self::hl7:code[(@code='X_BBPSCL' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.102-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.102-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-591c0b59-7956-4e6a-b3ac-bb8f9cffa717">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-591c0b59-7956-4e6a-b3ac-bb8f9cffa717)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/*[not(self::hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320'])]"
         id="tmp-r-cb013284-8d7e-459f-b25f-eaf769fe8c55">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-cb013284-8d7e-459f-b25f-eaf769fe8c55)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.320']|self::hl7:code[(@code='444783004' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:text|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.322']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.329']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.343']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.330']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.344']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.323']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.331']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.328']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.334']])]"
         id="tmp-r-b9ba56c9-d15d-4963-920b-77848d524fdf">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-b9ba56c9-d15d-4963-920b-77848d524fdf)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-68812051-a9dd-4536-aba9-66ff311c12c5">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-68812051-a9dd-4536-aba9-66ff311c12c5)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.322']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.322'])]"
         id="tmp-r-10ad4a0e-09e3-413a-9e7d-14e9d76ab5b6">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-10ad4a0e-09e3-413a-9e7d-14e9d76ab5b6)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.322']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.322']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.322']|self::hl7:code[(@code='C140022' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]|self::hl7:text|self::hl7:value)]"
         id="tmp-r-e9e71fb1-f757-4ee6-a26c-8cfb2da319fc">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-e9e71fb1-f757-4ee6-a26c-8cfb2da319fc)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.322']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.322']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-3a7faaa8-8bd0-448a-a371-9c7e5ba75c40">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-3a7faaa8-8bd0-448a-a371-9c7e5ba75c40)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.329']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.329'])]"
         id="tmp-r-c92b0677-0745-4d17-a0b6-b9e85764d6bf">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-c92b0677-0745-4d17-a0b6-b9e85764d6bf)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.329']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.329']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.329']|self::hl7:code[(@code='C140040' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]|self::hl7:text|self::hl7:value)]"
         id="tmp-r-9464395a-2175-4144-8e27-490f0ce61ef1">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-9464395a-2175-4144-8e27-490f0ce61ef1)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.329']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.329']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-f007fa68-1d12-46e9-b2b4-25f33bb96fc7">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-f007fa68-1d12-46e9-b2b4-25f33bb96fc7)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.343']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.343'])]"
         id="tmp-r-735a587a-cc28-4433-b77a-7194d3234b66">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-735a587a-cc28-4433-b77a-7194d3234b66)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.343']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.343']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.343']|self::hl7:code[(@code='C140041' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]|self::hl7:text|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.37-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.37-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-8d4be088-0c8a-4594-8b2a-89f7516357dc">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-8d4be088-0c8a-4594-8b2a-89f7516357dc)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.343']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.343']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-0f61e5a0-3d11-4da2-8fa0-b14f8dfb57aa">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-0f61e5a0-3d11-4da2-8fa0-b14f8dfb57aa)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.330']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.330'])]"
         id="tmp-r-b5438054-530a-431e-87b4-dbac33c18ded">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-b5438054-530a-431e-87b4-dbac33c18ded)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.330']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.330']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.330']|self::hl7:code[(@code='C140060' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]|self::hl7:text|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.108-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.108-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-80f337de-f80f-467b-85bd-65d7c95eaf15">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-80f337de-f80f-467b-85bd-65d7c95eaf15)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.330']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.330']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-3750ba48-0722-4c3b-9a83-60974263cf92">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-3750ba48-0722-4c3b-9a83-60974263cf92)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.344']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.344'])]"
         id="tmp-r-8e8441d7-e6d0-4b7a-8b63-3aa394071aef">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-8e8441d7-e6d0-4b7a-8b63-3aa394071aef)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.344']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.344']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.344']|self::hl7:code[(@code='C140065' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]|self::hl7:text|self::hl7:value)]"
         id="tmp-r-832f42b8-242f-4605-929c-12cc13dd1b4c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-832f42b8-242f-4605-929c-12cc13dd1b4c)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.344']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.344']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-c9d683dd-e710-4307-ba8a-baa85323c468">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-c9d683dd-e710-4307-ba8a-baa85323c468)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.323']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.323'])]"
         id="tmp-r-92d69743-05cc-4489-b702-2c10116da1a8">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-92d69743-05cc-4489-b702-2c10116da1a8)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.323']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.323']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.323']|self::hl7:code[(@code='C140070' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]|self::hl7:text|self::hl7:value)]"
         id="tmp-r-a8cf1b63-780e-4b5b-8b4e-e9f48418ce9e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-a8cf1b63-780e-4b5b-8b4e-e9f48418ce9e)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.323']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.323']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-be6e47f6-f4fa-49c3-8033-25c7e95d08ac">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-be6e47f6-f4fa-49c3-8033-25c7e95d08ac)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.331']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.331'])]"
         id="tmp-r-5395b035-276f-430e-888a-4fa53bc6daf9">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-5395b035-276f-430e-888a-4fa53bc6daf9)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.331']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.331']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.331']|self::hl7:code[(@code='C140105' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]|self::hl7:text|self::hl7:value)]"
         id="tmp-r-372ca5f4-3eda-46fb-bba3-4bf2deb7fab1">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-372ca5f4-3eda-46fb-bba3-4bf2deb7fab1)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.331']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.331']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-a2b8c845-8092-4aee-b687-ef4f00911e3b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-a2b8c845-8092-4aee-b687-ef4f00911e3b)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.328']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.328'])]"
         id="tmp-r-81170311-956b-4048-88a5-7c21a48239e9">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-81170311-956b-4048-88a5-7c21a48239e9)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.328']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.328']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.328']|self::hl7:code[(@code='X_GCS' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:text|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.104-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.104-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])]"
         id="tmp-r-815d75de-80e0-4618-a1cf-3625a5d2d51f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-815d75de-80e0-4618-a1cf-3625a5d2d51f)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.328']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.328']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-6b0f9318-af3e-45a4-b8a6-35a634d4d538">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-6b0f9318-af3e-45a4-b8a6-35a634d4d538)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.334']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.334'])]"
         id="tmp-r-f41b39d7-8785-41f6-beac-10652a6a3c3c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-f41b39d7-8785-41f6-beac-10652a6a3c3c)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.334']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.334']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.334']|self::hl7:code[(@code='445032002' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:text|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.37-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.37-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-ea7642ba-4c19-4132-9d36-ab6538216a61">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-ea7642ba-4c19-4132-9d36-ab6538216a61)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.334']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.334']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-9f0a00a2-1ba3-4802-889d-acd0a56d901a">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-9f0a00a2-1ba3-4802-889d-acd0a56d901a)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/*[not(self::hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205'])]"
         id="tmp-r-c5984aa8-3316-47a3-a095-17da0a73bdaa">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-c5984aa8-3316-47a3-a095-17da0a73bdaa)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.205']|self::hl7:code[(@code='51848-0' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:title|self::hl7:text|self::hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]|self::hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.332']])]"
         id="tmp-r-1c40287a-4180-401a-8fe3-51c02f6d3b33">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-1c40287a-4180-401a-8fe3-51c02f6d3b33)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/*[not(self::hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333'])]"
         id="tmp-r-989d3915-e133-49ce-9d3e-d0b9d4160241">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-989d3915-e133-49ce-9d3e-d0b9d4160241)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.333']|self::hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:specimen)]"
         id="tmp-r-e329da3a-28ac-49fc-9950-114bfe170842">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-e329da3a-28ac-49fc-9950-114bfe170842)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/*[not(self::hl7:specimenRole)]"
         id="tmp-r-2e9109c6-2e17-417b-afa0-d0ed4371683d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-2e9109c6-2e17-417b-afa0-d0ed4371683d)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/*[not(self::hl7:id|self::hl7:specimenPlayingEntity|self::lab:productOf|self::lab:subjectOf[lab:observationEvent/lab:code/@code='C145061']|self::lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']|self::lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']|self::lab:subjectOf[lab:observationEvent/lab:code/@code='DX']|self::lab:subjectOf[lab:observationEvent/lab:code/@code='269533000']|self::lab:subjectOf[lab:observationEvent/lab:code/@code='19132000']|self::lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']|self::lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']|self::lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']|self::lab:subjectOf[lab:procedure/lab:code/@code='702389009'])]"
         id="tmp-r-0b020f27-321c-4c83-840d-9e0ef94eec98">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-0b020f27-321c-4c83-840d-9e0ef94eec98)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity/*[not(self::hl7:code|self::hl7:quantity|self::lab:asSpecimenInContainer)]"
         id="tmp-r-f1963fbc-9ed2-4076-930c-eaf1a304da02">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-f1963fbc-9ed2-4076-930c-eaf1a304da02)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity/lab:asSpecimenInContainer/*[not(self::lab:container)]"
         id="tmp-r-c9f5c3bc-921b-4aaf-858f-7301bdad91a7">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-c9f5c3bc-921b-4aaf-858f-7301bdad91a7)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity/lab:asSpecimenInContainer/lab:container/*[not(self::lab:id)]"
         id="tmp-r-6494592a-2bce-4fd8-9646-ffc5979445f7">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-6494592a-2bce-4fd8-9646-ffc5979445f7)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/*[not(self::lab:specimenCollectionProcess)]"
         id="tmp-r-24313118-6908-46c7-b283-2d0bfe9d7295">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-24313118-6908-46c7-b283-2d0bfe9d7295)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/*[not(self::lab:code|self::lab:targetSiteCode|self::lab:methodCode)]"
         id="tmp-r-e11d0e9f-91d9-490c-9531-03a8573fa6e1">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-e11d0e9f-91d9-490c-9531-03a8573fa6e1)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/*[not(self::lab:qualifier[lab:name/@code='246386008']|self::lab:qualifier[lab:name/@code='260858005'])]"
         id="tmp-r-f129e692-cfb9-4faf-96b2-8675ba81913b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-f129e692-cfb9-4faf-96b2-8675ba81913b)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='246386008']/*[not(self::lab:name[(@code='246386008' and @codeSystem='2.16.840.1.113883.6.96')]|self::lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.229-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.229-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])]"
         id="tmp-r-d0144abe-2349-4cc0-99e1-4fe1e0d40749">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900121-2015-03-08T000000.html"
              test="not(.)">(Methodeverwijdering): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-d0144abe-2349-4cc0-99e1-4fe1e0d40749)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='260858005']/*[not(self::lab:name[(@code='260858005' and @codeSystem='2.16.840.1.113883.6.96')]|self::lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.230-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.230-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])]"
         id="tmp-r-b8901172-5715-41f1-9883-ccaa1939ae65">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900122-2015-03-08T000000.html"
              test="not(.)">(Resultaatverwijdering): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-b8901172-5715-41f1-9883-ccaa1939ae65)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:methodCode/*[not(self::lab:originalText)]"
         id="tmp-r-8f2b5d91-0f3d-430b-9085-0d52aa67df14">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-8f2b5d91-0f3d-430b-9085-0d52aa67df14)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145061']/*[not(self::lab:observationEvent)]"
         id="tmp-r-ad0c3493-ff25-4ebc-a642-b68eb9871eeb">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-ad0c3493-ff25-4ebc-a642-b68eb9871eeb)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145061']/lab:observationEvent/*[not(self::lab:code[(@code='C145061' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]|self::lab:value)]"
         id="tmp-r-dc45d6cc-d1c8-4d1f-a45e-b959ddacbf76">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-dc45d6cc-d1c8-4d1f-a45e-b959ddacbf76)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']/*[not(self::lab:observationEvent)]"
         id="tmp-r-3c5b3819-24f5-43cb-932d-47620405ff28">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-3c5b3819-24f5-43cb-932d-47620405ff28)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']/lab:observationEvent/*[not(self::lab:code[(@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')]|self::lab:value)]"
         id="tmp-r-92014a1a-9c2d-419d-8749-36e4bb39564d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-92014a1a-9c2d-419d-8749-36e4bb39564d)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']/*[not(self::lab:observationEvent)]"
         id="tmp-r-abdae3e9-0324-453b-b614-75c5d53d6493">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-abdae3e9-0324-453b-b614-75c5d53d6493)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']/lab:observationEvent/*[not(self::lab:code[(@code='41329004' and @codeSystem='2.16.840.1.113883.6.96')]|self::lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-34f223cd-da38-4907-8312-0fa30d219c39">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-34f223cd-da38-4907-8312-0fa30d219c39)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']/*[not(self::lab:observationEvent)]"
         id="tmp-r-fcd5b830-e25a-46b1-ba9c-d2faad3229d6">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-fcd5b830-e25a-46b1-ba9c-d2faad3229d6)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']/lab:observationEvent/*[not(self::lab:code[(@code='DX' and @codeSystem='2.16.840.1.113883.5.4')]|self::lab:text|self::lab:value)]"
         id="tmp-r-6f3033b5-ff61-4a2d-b835-71d850cbb69c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-6f3033b5-ff61-4a2d-b835-71d850cbb69c)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='269533000']/*[not(self::lab:observationEvent)]"
         id="tmp-r-89cfe207-84d0-4fda-9730-0271d49aa53c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-89cfe207-84d0-4fda-9730-0271d49aa53c)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='269533000']/lab:observationEvent/*[not(self::lab:code[(@code='269533000' and @codeSystem='2.16.840.1.113883.6.96')])]"
         id="tmp-r-93424f16-90b0-4783-93b4-870b8b7e0a2b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-93424f16-90b0-4783-93b4-870b8b7e0a2b)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='19132000']/*[not(self::lab:observationEvent)]"
         id="tmp-r-fa221f26-8009-426a-8649-265b008dc975">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-fa221f26-8009-426a-8649-265b008dc975)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='19132000']/lab:observationEvent/*[not(self::lab:code[(@code='19132000' and @codeSystem='2.16.840.1.113883.6.96')])]"
         id="tmp-r-c012c4e0-fddb-4132-be56-adb211d45bea">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-c012c4e0-fddb-4132-be56-adb211d45bea)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/*[not(self::lab:observationEvent)]"
         id="tmp-r-db8aa1f1-7cb0-42f3-a812-a4e5dd734b04">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-db8aa1f1-7cb0-42f3-a812-a4e5dd734b04)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent/*[not(self::lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')]|self::lab:value)]"
         id="tmp-r-bb42840d-e0f1-4e68-83ef-804e3aaa3108">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-bb42840d-e0f1-4e68-83ef-804e3aaa3108)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']/*[not(self::lab:observationEvent)]"
         id="tmp-r-c8f52d1d-f770-46c4-ac59-f725c558274d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-c8f52d1d-f770-46c4-ac59-f725c558274d)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']/lab:observationEvent/*[not(self::lab:code[(@code='C145140' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]|self::lab:value)]"
         id="tmp-r-a1e31ffe-dc62-4224-ab0e-4e6729ae03de">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-a1e31ffe-dc62-4224-ab0e-4e6729ae03de)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']/*[not(self::lab:observationEvent)]"
         id="tmp-r-a1545a3e-c727-49df-ae0c-bf0c15f4efcf">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-a1545a3e-c727-49df-ae0c-bf0c15f4efcf)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']/lab:observationEvent/*[not(self::lab:code[(@code='14792009' and @codeSystem='2.16.840.1.113883.6.96')]|self::lab:value)]"
         id="tmp-r-c0002c79-ac51-43b9-93fd-20cd59d96f71">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-c0002c79-ac51-43b9-93fd-20cd59d96f71)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:procedure/lab:code/@code='702389009']/*[not(self::lab:procedure)]"
         id="tmp-r-03d8040b-83a5-4a15-8024-34aaad24608b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-03d8040b-83a5-4a15-8024-34aaad24608b)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:procedure/lab:code/@code='702389009']/lab:procedure/*[not(self::lab:code[(@code='702389009' and @codeSystem='2.16.840.1.113883.6.96')])]"
         id="tmp-r-fe7dc654-33aa-4c55-b0bf-d4cfd2329679">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-fe7dc654-33aa-4c55-b0bf-d4cfd2329679)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.332']]/*[not(self::hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.332'])]"
         id="tmp-r-7ee99d79-1014-4e23-ad78-b37b3d16eb2d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-7ee99d79-1014-4e23-ad78-b37b3d16eb2d)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.332']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.332']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.332']|self::hl7:id|self::hl7:code[(@code='X-LAB-ORDER' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:text|self::hl7:statusCode[@code='completed'])]"
         id="tmp-r-fb3563a9-b9dc-42a2-9142-c83338cff41e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-fb3563a9-b9dc-42a2-9142-c83338cff41e)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.332']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.332']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-a43a62a3-f269-4591-a960-573438c92d1f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-a43a62a3-f269-4591-a960-573438c92d1f)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]/*[not(self::hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207'])]"
         id="tmp-r-8e4f31f4-c7eb-4444-93ce-a3e5951f4f01">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-8e4f31f4-c7eb-4444-93ce-a3e5951f4f01)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.207']|self::hl7:code[(@code='18776-5' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:title|self::hl7:text|self::hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.370']]|self::hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.372']])]"
         id="tmp-r-bcbf3d72-abf0-418b-9f56-e8bb1304f5a5">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-bcbf3d72-abf0-418b-9f56-e8bb1304f5a5)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.370']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.370'])]"
         id="tmp-r-560f2e2e-4eb6-45b5-914d-998b400bed2c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-560f2e2e-4eb6-45b5-914d-998b400bed2c)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.370']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.370']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.370']|self::hl7:code[(@code='409064004' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:text|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.38-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.38-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])]"
         id="tmp-r-de5a4a0e-5431-4308-9c10-0176eb6c36c2">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-de5a4a0e-5431-4308-9c10-0176eb6c36c2)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.370']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.370']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-3859d8f9-5364-428e-b87f-b1937225808b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-3859d8f9-5364-428e-b87f-b1937225808b)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.372']]/*[not(self::hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.372'])]"
         id="tmp-r-b0763e4a-011c-452d-b09a-e40489b0d268">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-b0763e4a-011c-452d-b09a-e40489b0d268)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.372']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.372']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.372']|self::hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.39-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.39-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]|self::hl7:text|self::hl7:effectiveTime|self::hl7:performer)]"
         id="tmp-r-485dc286-3768-4a2f-b535-0a9a9cec44d6">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-485dc286-3768-4a2f-b535-0a9a9cec44d6)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.372']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.372']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-0c67df35-4fb0-44a3-89ce-3f9180a7cd21">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-0c67df35-4fb0-44a3-89ce-3f9180a7cd21)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.372']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.372']/hl7:effectiveTime/*[not(self::hl7:width)]"
         id="tmp-r-f5899996-75f8-4965-887b-26d7548c80bf">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-f5899996-75f8-4965-887b-26d7548c80bf)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.372']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.372']/hl7:performer/*[not(self::hl7:assignedEntity)]"
         id="tmp-r-80a0cd41-eb75-4dbd-8a90-7f17bd58865e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-80a0cd41-eb75-4dbd-8a90-7f17bd58865e)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.372']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.372']/hl7:performer/hl7:assignedEntity/*[not(self::hl7:id|self::hl7:representedOrganization)]"
         id="tmp-r-714bab28-54b6-4263-9b8d-7e611cb0c005">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-714bab28-54b6-4263-9b8d-7e611cb0c005)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.372']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.372']/hl7:performer/hl7:assignedEntity/hl7:representedOrganization/*[not(self::hl7:name)]"
         id="tmp-r-1e69d1cd-37b8-44a1-ae4a-14a4dab513b9">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-1e69d1cd-37b8-44a1-ae4a-14a4dab513b9)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']]/*[not(self::hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208'])]"
         id="tmp-r-7f4d4dba-4086-45e1-97f0-db82a351bf7e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-7f4d4dba-4086-45e1-97f0-db82a351bf7e)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.208']|self::hl7:code[(@code='55110-1' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:title|self::hl7:text|self::hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.380']]|self::hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']])]"
         id="tmp-r-560c1c6f-2217-4784-bc46-ed6909404455">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-560c1c6f-2217-4784-bc46-ed6909404455)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.380']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.380'])]"
         id="tmp-r-caebe24f-da53-49db-a171-05007be23d15">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-caebe24f-da53-49db-a171-05007be23d15)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.380']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.380']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.380']|self::hl7:code[(@code='DX' and @codeSystem='2.16.840.1.113883.5.4')]|self::hl7:text|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.78-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.78-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-04f9dc0f-6412-4932-a8bb-b9be5570e14a">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-04f9dc0f-6412-4932-a8bb-b9be5570e14a)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.380']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.380']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-109a0edb-9edd-494c-a23a-1b6188b34479">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-109a0edb-9edd-494c-a23a-1b6188b34479)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381'])]"
         id="tmp-r-e5552e53-7f1a-4893-a840-2397dfc8877a">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-e5552e53-7f1a-4893-a840-2397dfc8877a)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.381']|self::hl7:code[(@code='ASSERTION' and @codeSystem='2.16.840.1.113883.5.4')]|self::hl7:text|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.76-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.76-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-448ed068-6662-4679-9f21-560c66a2924a">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-448ed068-6662-4679-9f21-560c66a2924a)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.10' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-5a7802a3-ad8f-4aa9-b82f-ac8e3447bd2b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.10-2012-07-04T000000.html"
              test="not(.)">(nspbcmdl): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-5a7802a3-ad8f-4aa9-b82f-ac8e3447bd2b)</assert>
   </rule>
</pattern>
