<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.36.10.21
Name: Resultaatdocument PA-lab bevolkingsonderzoek darmkanker
Description: Template: Documenten bevolkingsonderzoek darmkanker uitslag PA-lab (transactie T3), versie 2014  Dit Document bevat op dit moment de noodzakelijke gegevens voor een pathologie lab uitslag omtrent de analyse van ingezonden poliepen. Naast de gewone pathologie lab CDA header (die min of meer voor alle pathologie lab uitslagen gelijk gedefinieerd is) wordt er gebruik gemaakt
                van onderdelen (secties) die al bij IHE Anatomic Pathologie Structured Reporting (APSR) zijn (draft) gedefinieerd.   CDA Body Sections (pathologie lab uitslag mbt ingezonden poliepen):  
                     In de "Clinical Information Section" (template: ClinicalInformationSection) worden de vraagstelling en de klinische gegevens in tekstvorm meegegeven 
                     In de "Macroscopie Section" (template: GrossObservationSection) wordt het aantal inzendingen en per materiaal de monstergegevens genoemd (SpecimenMacroscopicObservation  Specimen Macroscopic Observation ). Hier gaat het met name p
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000">
   <title>Resultaatdocument PA-lab bevolkingsonderzoek darmkanker</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.21
Context: /
Item: (nspbcpa2014)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.21
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']
Item: (nspbcpa2014)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']"
         id="tmp-r-aed7f2b4-1b1d-4325-8e48-42f2af9f0d0e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:realmCode[@code='NL'])&gt;=1 and not(hl7:realmCode[@code='NL']/@nullFlavor)">(nspbcpa2014): element hl7:realmCode[@code='NL'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:realmCode[@code='NL'])&lt;=1">(nspbcpa2014): element hl7:realmCode[@code='NL'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:typeId[@root='2.16.840.1.113883.1.3'])&gt;=1 and not(hl7:typeId[@root='2.16.840.1.113883.1.3']/@nullFlavor)">(nspbcpa2014): element hl7:typeId[@root='2.16.840.1.113883.1.3'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:typeId[@root='2.16.840.1.113883.1.3'])&lt;=1">(nspbcpa2014): element hl7:typeId[@root='2.16.840.1.113883.1.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.21'])&gt;=1 and not(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.21']/@nullFlavor)">(nspbcpa2014): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.21'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.21'])&lt;=1">(nspbcpa2014): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.21'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1'])&gt;=1 and not(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1']/@nullFlavor)">(nspbcpa2014): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1'])&lt;=1">(nspbcpa2014): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:templateId[@root='1.3.6.1.4.1.19376.1.8.1.1.1'])&lt;=1">(nspbcpa2014): element hl7:templateId[@root='1.3.6.1.4.1.19376.1.8.1.1.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:templateId[@root='1.3.6.1.4.1.19376.1.8.1.1.2.2'])&lt;=1">(nspbcpa2014): element hl7:templateId[@root='1.3.6.1.4.1.19376.1.8.1.1.2.2'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:id)&gt;=1 and not(hl7:id/@nullFlavor)">(nspbcpa2014): element hl7:id is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:id)&lt;=1">(nspbcpa2014): element hl7:id komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:code[(@code='11526-1' and @codeSystem='2.16.840.1.113883.6.1')])&gt;=1 and not(hl7:code[(@code='11526-1' and @codeSystem='2.16.840.1.113883.6.1')]/@nullFlavor)">(nspbcpa2014): element hl7:code[(@code='11526-1' and @codeSystem='2.16.840.1.113883.6.1')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:code[(@code='11526-1' and @codeSystem='2.16.840.1.113883.6.1')])&lt;=1">(nspbcpa2014): element hl7:code[(@code='11526-1' and @codeSystem='2.16.840.1.113883.6.1')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:title)&lt;=1">(nspbcpa2014): element hl7:title komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:effectiveTime)&gt;=1 and not(hl7:effectiveTime/@nullFlavor)">(nspbcpa2014): element hl7:effectiveTime is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:effectiveTime)&lt;=1">(nspbcpa2014): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])&gt;=1 and not(hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]/@nullFlavor)">(nspbcpa2014): element hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])&lt;=1">(nspbcpa2014): element hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:languageCode)&gt;=1 and not(hl7:languageCode/@nullFlavor)">(nspbcpa2014): element hl7:languageCode is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:languageCode)&lt;=1">(nspbcpa2014): element hl7:languageCode komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:setId)&gt;=1 and not(hl7:setId/@nullFlavor)">(nspbcpa2014): element hl7:setId is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:setId)&lt;=1">(nspbcpa2014): element hl7:setId komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:versionNumber)&gt;=1 and not(hl7:versionNumber/@nullFlavor)">(nspbcpa2014): element hl7:versionNumber is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:versionNumber)&lt;=1">(nspbcpa2014): element hl7:versionNumber komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:recordTarget)&gt;=1 and not(hl7:recordTarget/@nullFlavor)">(nspbcpa2014): element hl7:recordTarget is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:recordTarget)&lt;=1">(nspbcpa2014): element hl7:recordTarget komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100'])&gt;=1 and not(hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100']/@nullFlavor)">(nspbcpa2014): element hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100'])&lt;=1">(nspbcpa2014): element hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:custodian)&gt;=1 and not(hl7:custodian/@nullFlavor)">(nspbcpa2014): element hl7:custodian is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:custodian)&lt;=1">(nspbcpa2014): element hl7:custodian komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:legalAuthenticator)&lt;=1">(nspbcpa2014): element hl7:legalAuthenticator komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900800
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:realmCode[@code='NL']
Item: (CDArealmCode)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:realmCode[@code='NL']"
         id="tmp-r-6bcd9d33-eada-4252-9741-86761008dfec">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900800-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArealmCode): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900800-2012-07-04T000000.html"
              test="@nullFlavor or (@code='NL')">(CDArealmCode): de elementwaarde MOET een zijn van 'code 'NL''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900801
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:typeId[@root='2.16.840.1.113883.1.3']
Item: (CDAtypeId)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:typeId[@root='2.16.840.1.113883.1.3']"
         id="tmp-r-91f1f6c1-f15d-4cfb-88e3-1efe5673be92">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900801-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAtypeId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900801-2012-07-04T000000.html"
              test="string(@extension)=('POCD_HD000040')">(CDAtypeId): de waarde van @extension MOET 'POCD_HD000040' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900801-2012-07-04T000000.html"
              test="string(@root)=('2.16.840.1.113883.1.3')">(CDAtypeId): de waarde van @root MOET '2.16.840.1.113883.1.3' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.21
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.21']
Item: (nspbcpa2014)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.21']"
         id="tmp-r-33d0207a-ec94-4062-86b7-c2634667b2c0">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(nspbcpa2014): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="string(@root)=('2.16.840.1.113883.2.4.3.36.10.21')">(nspbcpa2014): de waarde van @root MOET '2.16.840.1.113883.2.4.3.36.10.21' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.21
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1']
Item: (nspbcpa2014)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1']"
         id="tmp-r-5476ff87-5483-475e-a9cb-710145320aa0">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(nspbcpa2014): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="string(@root)=('2.16.840.1.113883.2.4.3.36.10.1')">(nspbcpa2014): de waarde van @root MOET '2.16.840.1.113883.2.4.3.36.10.1' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.21
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:templateId[@root='1.3.6.1.4.1.19376.1.8.1.1.1']
Item: (nspbcpa2014)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:templateId[@root='1.3.6.1.4.1.19376.1.8.1.1.1']"
         id="tmp-r-eaf4c2c0-f311-4964-9bf0-0a421ef2658b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(nspbcpa2014): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="string(@root)=('1.3.6.1.4.1.19376.1.8.1.1.1')">(nspbcpa2014): de waarde van @root MOET '1.3.6.1.4.1.19376.1.8.1.1.1' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.21
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:templateId[@root='1.3.6.1.4.1.19376.1.8.1.1.2.2']
Item: (nspbcpa2014)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:templateId[@root='1.3.6.1.4.1.19376.1.8.1.1.2.2']"
         id="tmp-r-c96ccd86-0cb6-43eb-b654-ea4a1e7ab93a">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(nspbcpa2014): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="string(@root)=('1.3.6.1.4.1.19376.1.8.1.1.2.2')">(nspbcpa2014): de waarde van @root MOET '1.3.6.1.4.1.19376.1.8.1.1.2.2' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900802
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:id
Item: (CDAid)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:id"
         id="tmp-r-a9c07323-6308-4417-b93e-3f13cb80e316">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900802-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAid): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.21
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:code[(@code='11526-1' and @codeSystem='2.16.840.1.113883.6.1')]
Item: (nspbcpa2014)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:code[(@code='11526-1' and @codeSystem='2.16.840.1.113883.6.1')]"
         id="tmp-r-6274383d-80c3-4115-a2eb-8c88e274016d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(nspbcpa2014): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="@nullFlavor or (@code='11526-1' and @codeSystem='2.16.840.1.113883.6.1')">(nspbcpa2014): de elementwaarde MOET een zijn van 'code '11526-1' codeSystem '2.16.840.1.113883.6.1''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900803
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:title
Item: (CDAtitle)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:title"
         id="tmp-r-fa832ffd-4d37-416e-a44b-370f86d1e1f0">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900803-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ST' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAtitle): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="ST"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900804
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:effectiveTime
Item: (CDAeffectiveTime)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:effectiveTime"
         id="tmp-r-5c4d230d-6bbd-4b57-ad5a-ca3f3fa523d7">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900804-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAeffectiveTime): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TS.DATETIME.MIN"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900805
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]
Item: (CDAconfidentialityCode)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]"
         id="tmp-r-7affe33c-9c2f-40a7-bb6b-45f812a7db3b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900805-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAconfidentialityCode): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900805-2012-07-04T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(CDAconfidentialityCode): de elementwaarde MOET een zijn van 'BasicConfidentialityKind Basic Confidentiality Kind (HL7) (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900805-2012-07-04T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(CDAconfidentialityCode): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst BasicConfidentialityKind Basic Confidentiality Kind (HL7) (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900806
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:languageCode
Item: (CDAlanguageCode)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:languageCode"
         id="tmp-r-5dac951c-ca94-4389-9ab7-17398b9dad90">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900806-2012-03-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAlanguageCode): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CS.LANG"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900807
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:setId
Item: (CDAsetIdversionNumber)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:setId"
         id="tmp-r-b432dd30-cb1c-413b-8f99-fbbc9b50edfe">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900807-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAsetIdversionNumber): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900807
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:versionNumber
Item: (CDAsetIdversionNumber)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:versionNumber"
         id="tmp-r-b578a338-ece0-42d9-9089-c0d08199c951">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900807-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='INT' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAsetIdversionNumber): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:INT" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="INT.NONNEG"/>
      <let name="theValue" value="@value"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900807-2012-07-04T000000.html"
              test="(@nullFlavor or (number($theValue)&gt;=1))">(CDAsetIdversionNumber): value MOET in bereik [1..] liggen  </assert>
      <let name="digitok" value="matches(string(@value), '^-?[1-9]\d*$|^+?\d*$')"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900807-2012-07-04T000000.html"
              test="$digitok or @nullFlavor">(CDAsetIdversionNumber): @value is geen geldig INT getal <value-of select="@value"/>
      </assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900831
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget
Item: (CDArecordTargetPA)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget"
         id="tmp-r-2d291812-e825-46e5-813c-f88d9cbecf03">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900831-2014-02-09T000000.html"
              test="string(@typeCode)=('RCT')">(CDArecordTargetPA): de waarde van @typeCode MOET 'RCT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900831-2014-02-09T000000.html"
              test="count(hl7:patientRole)&gt;=1 and not(hl7:patientRole/@nullFlavor)">(CDArecordTargetPA): element hl7:patientRole is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900831-2014-02-09T000000.html"
              test="count(hl7:patientRole)&lt;=1">(CDArecordTargetPA): element hl7:patientRole komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900831
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget/hl7:patientRole
Item: (CDArecordTargetPA)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget/hl7:patientRole"
         id="tmp-r-fc79382a-9917-4103-8734-ac31260967f6">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900831-2014-02-09T000000.html"
              test="string(@classCode)=('PAT')">(CDArecordTargetPA): de waarde van @classCode MOET 'PAT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900831-2014-02-09T000000.html"
              test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.3'])&gt;=1 and not(hl7:id[@root='2.16.840.1.113883.2.4.6.3']/@nullFlavor)">(CDArecordTargetPA): element hl7:id[@root='2.16.840.1.113883.2.4.6.3'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900831-2014-02-09T000000.html"
              test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.3'])&lt;=1">(CDArecordTargetPA): element hl7:id[@root='2.16.840.1.113883.2.4.6.3'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900014
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget/hl7:patientRole/hl7:id[@root='2.16.840.1.113883.2.4.6.3']
Item: (BurgerServiceNummer)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget/hl7:patientRole/hl7:id[@root='2.16.840.1.113883.2.4.6.3']"
         id="tmp-r-2002b092-a41c-4860-a42f-3b98988b001d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900014-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(BurgerServiceNummer): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II.NL.BSN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900014-2012-07-04T000000.html"
              test="string(@root)=('2.16.840.1.113883.2.4.6.3')">(BurgerServiceNummer): de waarde van @root MOET '2.16.840.1.113883.2.4.6.3' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900014-2012-07-04T000000.html"
              test="@extension">(BurgerServiceNummer): attribute @extension MOET aanwezig zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900810
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian
Item: (CDAcustodian)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian"
         id="tmp-r-89e43382-9a6b-402f-a719-eaeada01a92a">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="string(@typeCode)=('CST')">(CDAcustodian): de waarde van @typeCode MOET 'CST' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="count(hl7:assignedCustodian)&gt;=1 and not(hl7:assignedCustodian/@nullFlavor)">(CDAcustodian): element hl7:assignedCustodian is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="count(hl7:assignedCustodian)&lt;=1">(CDAcustodian): element hl7:assignedCustodian komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900810
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian
Item: (CDAcustodian)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian"
         id="tmp-r-965b7de9-f27b-46f1-a582-86c70fbaea06">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="string(@classCode)=('ASSIGNED')">(CDAcustodian): de waarde van @classCode MOET 'ASSIGNED' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="count(hl7:representedCustodianOrganization)&lt;=1">(CDAcustodian): element hl7:representedCustodianOrganization komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900810
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization
Item: (CDAcustodian)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization"
         id="tmp-r-c4c3bf29-0eea-4f2d-b861-e33041424ed1">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="string(@classCode)=('ORG')">(CDAcustodian): de waarde van @classCode MOET 'ORG' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(CDAcustodian): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <let name="elmcount"
           value="count(hl7:id[@root='2.16.528.1.1007.3.3']|hl7:id)"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="$elmcount&gt;=1">(CDAcustodian): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="count(hl7:id[@root='2.16.528.1.1007.3.3'])&lt;=1">(CDAcustodian): element hl7:id[@root='2.16.528.1.1007.3.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor)">(CDAcustodian): element hl7:name is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="count(hl7:name)&lt;=1">(CDAcustodian): element hl7:name komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="count(hl7:addr)&lt;=1">(CDAcustodian): element hl7:addr komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="count(lab:code)&lt;=1">(CDAcustodian): element lab:code komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization
Item: (CDArepresentedOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:id[@root='2.16.528.1.1007.3.3']
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:id[@root='2.16.528.1.1007.3.3']"
         id="tmp-r-32893ff2-388e-49a8-be27-15a912ea30a4">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="string(@root)=('2.16.528.1.1007.3.3')">(CDArepresentedOrganization): de waarde van @root MOET '2.16.528.1.1007.3.3' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:id
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:id"
         id="tmp-r-1374741b-1ca3-40c0-b6bd-fad22c15fa9b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:name
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:name"
         id="tmp-r-72b82970-95d4-43df-ba70-105a34d641e9">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="ON"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:addr
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:addr"
         id="tmp-r-83ae4fc7-133b-48b8-8e2e-ad4791a8591c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="AD"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:telecom
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:telecom"
         id="tmp-r-e76c8662-8fe1-40bb-b8ce-c7b4ea4ba4d7">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TEL"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/lab:code
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/lab:code"
         id="tmp-r-23efa1ba-223a-44eb-89e0-2612a8591b2c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(CDArepresentedOrganization): de elementwaarde MOET een zijn van 'vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(CDArepresentedOrganization): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900811
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient
Item: (CDAinformationRecipient)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient"
         id="tmp-r-fa90d2e1-580a-408e-a6a5-ab77044eb7ca">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="@typeCode">(CDAinformationRecipient): attribute @typeCode MOET aanwezig zijn.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),' '))"/>
      <let name="theAttCheck"
           value="distinct-values(for $code in tokenize(@typeCode,' ') return if ($code=('PRCP','TRC')) then ($code) else ())"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="not(@typeCode) or count($theAttValue) = count($theAttCheck)">(CDAinformationRecipient): de waarde van typeCode MOET 'code PRCP of code TRC' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="count(hl7:intendedRecipient)&gt;=1 and not(hl7:intendedRecipient/@nullFlavor)">(CDAinformationRecipient): element hl7:intendedRecipient is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="count(hl7:intendedRecipient)&lt;=1">(CDAinformationRecipient): element hl7:intendedRecipient komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900811
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient
Item: (CDAinformationRecipient)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient"
         id="tmp-r-9158101b-8813-4abf-999b-7b5b0a81bc05">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="string(@classCode)=('ASSIGNED')">(CDAinformationRecipient): de waarde van @classCode MOET 'ASSIGNED' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="count(hl7:informationRecipient)&lt;=1">(CDAinformationRecipient): element hl7:informationRecipient komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="count(hl7:representedOrganization)&lt;=1">(CDAinformationRecipient): element hl7:representedOrganization komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900811
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:id
Item: (CDAinformationRecipient)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:id"
         id="tmp-r-4a265165-a718-40e5-81cf-66092e6f94f5">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAinformationRecipient): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900811
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:informationRecipient
Item: (CDAinformationRecipient)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:informationRecipient"
         id="tmp-r-e00b3323-41ea-4930-8dfd-a9203e3d9eb6">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="string(@classCode)=('PSN')">(CDAinformationRecipient): de waarde van @classCode MOET 'PSN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(CDAinformationRecipient): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="count(hl7:name)&lt;=1">(CDAinformationRecipient): element hl7:name komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900811
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:informationRecipient/hl7:name
Item: (CDAinformationRecipient)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:informationRecipient/hl7:name"
         id="tmp-r-7ddf0b98-4d6b-4665-ab5f-6bbef931edd6">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAinformationRecipient): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="PN"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900811
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization
Item: (CDAinformationRecipient)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization"
         id="tmp-r-46d223ca-005c-4452-a324-6c9cf57583e8">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="string(@classCode)=('ORG')">(CDAinformationRecipient): de waarde van @classCode MOET 'ORG' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(CDAinformationRecipient): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <let name="elmcount"
           value="count(hl7:id[@root='2.16.528.1.1007.3.3']|hl7:id)"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="$elmcount&gt;=1">(CDAinformationRecipient): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="count(hl7:id[@root='2.16.528.1.1007.3.3'])&lt;=1">(CDAinformationRecipient): element hl7:id[@root='2.16.528.1.1007.3.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor)">(CDAinformationRecipient): element hl7:name is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="count(hl7:name)&lt;=1">(CDAinformationRecipient): element hl7:name komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="count(hl7:addr)&lt;=1">(CDAinformationRecipient): element hl7:addr komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="count(lab:code)&lt;=1">(CDAinformationRecipient): element lab:code komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization
Item: (CDArepresentedOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:id[@root='2.16.528.1.1007.3.3']
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:id[@root='2.16.528.1.1007.3.3']"
         id="tmp-r-370a8240-803b-404c-a3c4-12f8d52e4858">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="string(@root)=('2.16.528.1.1007.3.3')">(CDArepresentedOrganization): de waarde van @root MOET '2.16.528.1.1007.3.3' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:id
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:id"
         id="tmp-r-4ce996f3-7f41-4d35-9ee9-e49dad7b187f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:name
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:name"
         id="tmp-r-e020e1b9-fadd-4f41-8456-a7081e096f32">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="ON"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:addr
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:addr"
         id="tmp-r-e84d3e5b-3263-4221-a6f5-24dd5ef882d4">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="AD"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:telecom
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:telecom"
         id="tmp-r-87aada09-50aa-4dc7-9986-45317e99cfa9">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TEL"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/lab:code
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/lab:code"
         id="tmp-r-a9fe9d76-f4cb-4d0a-8152-082e877864d3">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(CDArepresentedOrganization): de elementwaarde MOET een zijn van 'vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(CDArepresentedOrganization): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900812
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:authenticator
Item: (CDAauthenticator)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:authenticator"
         id="tmp-r-6d191a6f-430a-4957-bf88-66188cd0df67">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900812-2012-07-04T000000.html"
              test="string(@typeCode)=('AUTHEN')">(CDAauthenticator): de waarde van @typeCode MOET 'AUTHEN' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900813
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator
Item: (CDlegalAuthenticator)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator"
         id="tmp-r-be0d3f6c-36fe-4223-84d7-aaa3643c3b85">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="string(@typeCode)=('LA')">(CDlegalAuthenticator): de waarde van @typeCode MOET 'LA' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:time)&gt;=1 ">(CDlegalAuthenticator): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:time)&lt;=1">(CDlegalAuthenticator): element hl7:time komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:signatureCode[@code='S'])&gt;=1 and not(hl7:signatureCode[@code='S']/@nullFlavor)">(CDlegalAuthenticator): element hl7:signatureCode[@code='S'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:signatureCode[@code='S'])&lt;=1">(CDlegalAuthenticator): element hl7:signatureCode[@code='S'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:assignedEntity)&gt;=1 and not(hl7:assignedEntity/@nullFlavor)">(CDlegalAuthenticator): element hl7:assignedEntity is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:assignedEntity)&lt;=1">(CDlegalAuthenticator): element hl7:assignedEntity komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900813
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:time
Item: (CDlegalAuthenticator)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:time"
         id="tmp-r-1f246eb5-f969-485b-91fe-364f40fb66d1">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDlegalAuthenticator): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TS.DATE.MIN"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900813
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:signatureCode[@code='S']
Item: (CDlegalAuthenticator)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:signatureCode[@code='S']"
         id="tmp-r-5bf9f16f-25e8-408f-8390-9a9d6e97f0df">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDlegalAuthenticator): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="@nullFlavor or (@code='S')">(CDlegalAuthenticator): de elementwaarde MOET een zijn van 'code 'S''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900813
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity
Item: (CDlegalAuthenticator)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity"
         id="tmp-r-f6ea91f6-fff4-46c8-bd78-c70dbb70f17c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="string(@classCode)=('ASSIGNED')">(CDlegalAuthenticator): de waarde van @classCode MOET 'ASSIGNED' zijn.</assert>
      <let name="elmcount"
           value="count(hl7:id[@root='2.16.528.1.1007.3.1']|hl7:id)"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="$elmcount&gt;=1">(CDlegalAuthenticator): keuze (hl7:id[@root='2.16.528.1.1007.3.1'] of hl7:id) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:id[@root='2.16.528.1.1007.3.1'])&lt;=1">(CDlegalAuthenticator): element hl7:id[@root='2.16.528.1.1007.3.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:code)&lt;=1">(CDlegalAuthenticator): element hl7:code komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:assignedPerson)&lt;=1">(CDlegalAuthenticator): element hl7:assignedPerson komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:representedOrganization)&lt;=1">(CDlegalAuthenticator): element hl7:representedOrganization komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900829
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity
Item: (CDAassignedEntityIdentification)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900829
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:id[@root='2.16.528.1.1007.3.1']
Item: (CDAassignedEntityIdentification)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:id[@root='2.16.528.1.1007.3.1']"
         id="tmp-r-5a66fe23-2bab-43e6-ac11-0115e80f4185">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAassignedEntityIdentification): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html"
              test="string(@root)=('2.16.528.1.1007.3.1')">(CDAassignedEntityIdentification): de waarde van @root MOET '2.16.528.1.1007.3.1' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900829
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:id
Item: (CDAassignedEntityIdentification)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:id"
         id="tmp-r-d31e2619-6b11-4260-b29a-983e931210e5">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAassignedEntityIdentification): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900813
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:code
Item: (CDlegalAuthenticator)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:code"
         id="tmp-r-673c8dc3-3362-4289-b35f-308cb30b6376">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDlegalAuthenticator): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(CDlegalAuthenticator): de elementwaarde MOET een zijn van 'vs_typerol Medische rollen (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(CDlegalAuthenticator): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_typerol Medische rollen (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900813
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:assignedPerson
Item: (CDlegalAuthenticator)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:assignedPerson"
         id="tmp-r-d3bca6a1-f7a8-4281-8571-0eeea177ac90">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="string(@classCode)=('PSN')">(CDlegalAuthenticator): de waarde van @classCode MOET 'PSN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(CDlegalAuthenticator): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor)">(CDlegalAuthenticator): element hl7:name is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:name)&lt;=1">(CDlegalAuthenticator): element hl7:name komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900813
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDlegalAuthenticator)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:assignedPerson/hl7:name"
         id="tmp-r-bde084dc-981d-4512-a48b-6f7ae6c9ef9d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDlegalAuthenticator): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="PN"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900813
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization
Item: (CDlegalAuthenticator)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization"
         id="tmp-r-4b014cd9-5887-4b6c-998e-7fa9c34e928e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="string(@classCode)=('ORG')">(CDlegalAuthenticator): de waarde van @classCode MOET 'ORG' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(CDlegalAuthenticator): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <let name="elmcount"
           value="count(hl7:id[@root='2.16.528.1.1007.3.3']|hl7:id)"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="$elmcount&gt;=1">(CDlegalAuthenticator): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:id[@root='2.16.528.1.1007.3.3'])&lt;=1">(CDlegalAuthenticator): element hl7:id[@root='2.16.528.1.1007.3.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor)">(CDlegalAuthenticator): element hl7:name is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:name)&lt;=1">(CDlegalAuthenticator): element hl7:name komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:addr)&lt;=1">(CDlegalAuthenticator): element hl7:addr komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(lab:code)&lt;=1">(CDlegalAuthenticator): element lab:code komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization
Item: (CDArepresentedOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:id[@root='2.16.528.1.1007.3.3']
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:id[@root='2.16.528.1.1007.3.3']"
         id="tmp-r-21136470-2f01-4fdc-9846-b6107240e78f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="string(@root)=('2.16.528.1.1007.3.3')">(CDArepresentedOrganization): de waarde van @root MOET '2.16.528.1.1007.3.3' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:id
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:id"
         id="tmp-r-982f5dc8-735c-426f-9387-479f6fb5361f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:name
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:name"
         id="tmp-r-8e67ffcb-1767-49e5-938d-ebc0f66ee99e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="ON"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:addr
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:addr"
         id="tmp-r-4f780bdf-e8ed-4701-83e3-a9082633461f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="AD"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:telecom
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:telecom"
         id="tmp-r-280620b3-0092-4f7b-a966-e0d5b74966c1">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TEL"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/lab:code
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/lab:code"
         id="tmp-r-f9b56ff8-24ac-4471-b434-c09da187129f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(CDArepresentedOrganization): de elementwaarde MOET een zijn van 'vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(CDArepresentedOrganization): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900814
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:relatedDocument
Item: (CDArelatedDocument)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:relatedDocument"
         id="tmp-r-9cff4925-b937-4099-a8a3-0dbd481ea0b1">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900814-2012-07-04T000000.html"
              test="string(@typeCode)=('RPLC')">(CDArelatedDocument): de waarde van @typeCode MOET 'RPLC' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900816
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]
Item: (CDAdocumentationOfPAlab)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]"
         id="tmp-r-dfc27563-6172-41b9-9c89-0c6b2aff93b7">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="string(@typeCode)=('DOC')">(CDAdocumentationOfPAlab): de waarde van @typeCode MOET 'DOC' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="count(hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]])&gt;=1 and not(hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/@nullFlavor)">(CDAdocumentationOfPAlab): element hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="count(hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]])&lt;=1">(CDAdocumentationOfPAlab): element hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900816
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]
Item: (CDAdocumentationOfPAlab)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]"
         id="tmp-r-282c5ad9-7d1c-4c9b-8186-6378a1924fce">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="string(@classCode)=('OBS')">(CDAdocumentationOfPAlab): de waarde van @classCode MOET 'OBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="string(@moodCode)=('EVN')">(CDAdocumentationOfPAlab): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="count(hl7:id)&gt;=1 ">(CDAdocumentationOfPAlab): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="count(hl7:id)&lt;=1">(CDAdocumentationOfPAlab): element hl7:id komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="count(hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])&gt;=1 and not(hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]/@nullFlavor)">(CDAdocumentationOfPAlab): element hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="count(hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])&lt;=1">(CDAdocumentationOfPAlab): element hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="count(lab:statusCode[@code='completed'])&gt;=1 and not(lab:statusCode[@code='completed']/@nullFlavor)">(CDAdocumentationOfPAlab): element lab:statusCode[@code='completed'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="count(lab:statusCode[@code='completed'])&lt;=1">(CDAdocumentationOfPAlab): element lab:statusCode[@code='completed'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="count(hl7:effectiveTime)&lt;=1">(CDAdocumentationOfPAlab): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="count(hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]])&gt;=1 ">(CDAdocumentationOfPAlab): element hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="count(hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]])&lt;=1">(CDAdocumentationOfPAlab): element hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900816
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:id
Item: (CDAdocumentationOfPAlab)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:id"
         id="tmp-r-dc3cb622-a425-43f7-99a3-2d6fa4ed0ac6">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAdocumentationOfPAlab): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900816
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]
Item: (CDAdocumentationOfPAlab)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]"
         id="tmp-r-aa167c55-384a-4a8a-b57a-bc647c2a89f1">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAdocumentationOfPAlab): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(CDAdocumentationOfPAlab): de elementwaarde MOET een zijn van 'PALGAServiceTypes PALGA Service Types (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(CDAdocumentationOfPAlab): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst PALGAServiceTypes PALGA Service Types (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900816
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/lab:statusCode[@code='completed']
Item: (CDAdocumentationOfPAlab)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/lab:statusCode[@code='completed']"
         id="tmp-r-81896dfa-5729-49b1-a349-0d26daa7eb9d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAdocumentationOfPAlab): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="@nullFlavor or (@code='completed')">(CDAdocumentationOfPAlab): de elementwaarde MOET een zijn van 'code 'completed''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900816
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:effectiveTime
Item: (CDAdocumentationOfPAlab)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:effectiveTime"
         id="tmp-r-7cd0bdf7-dea9-4c54-870b-2290b83beb20">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAdocumentationOfPAlab): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="count(hl7:low)&gt;=1 ">(CDAdocumentationOfPAlab): element hl7:low is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="count(hl7:low)&lt;=1">(CDAdocumentationOfPAlab): element hl7:low komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="count(hl7:high)&gt;=1 and not(hl7:high/@nullFlavor)">(CDAdocumentationOfPAlab): element hl7:high is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="count(hl7:high)&lt;=1">(CDAdocumentationOfPAlab): element hl7:high komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900005
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:effectiveTime/hl7:low
Item: (StartServiceDate)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:effectiveTime/hl7:low"
         id="tmp-r-e617b1e5-c9bb-4550-b567-138e97813d80">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900005-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(StartServiceDate): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TS"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900035
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:effectiveTime/hl7:high
Item: (EndServiceDate)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:effectiveTime/hl7:high"
         id="tmp-r-6a8a8847-72ac-4d91-a0e7-1fac39ceff41">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900035-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(EndServiceDate): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TS"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900816
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]
Item: (CDAdocumentationOfPAlab)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]"
         id="tmp-r-e42c5f99-201c-4cd4-b69b-6923d6b9db7b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="string(@typeCode)=('PRF')">(CDAdocumentationOfPAlab): de waarde van @typeCode MOET 'PRF' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="count(hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]])&gt;=1 ">(CDAdocumentationOfPAlab): element hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="count(hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]])&lt;=1">(CDAdocumentationOfPAlab): element hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900816
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]
Item: (CDAdocumentationOfPAlab)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]"
         id="tmp-r-b581baca-4dc5-4ec9-80e1-1d10f650341a">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="string(@classCode)=('ASSIGNED')">(CDAdocumentationOfPAlab): de waarde van @classCode MOET 'ASSIGNED' zijn.</assert>
      <let name="elmcount"
           value="count(hl7:id[@root='2.16.528.1.1007.3.1']|hl7:id)"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="$elmcount&gt;=1">(CDAdocumentationOfPAlab): keuze (hl7:id[@root='2.16.528.1.1007.3.1'] of hl7:id) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="count(hl7:id[@root='2.16.528.1.1007.3.1'])&lt;=1">(CDAdocumentationOfPAlab): element hl7:id[@root='2.16.528.1.1007.3.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="count(hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])&gt;=1 ">(CDAdocumentationOfPAlab): element hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="count(hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])&lt;=1">(CDAdocumentationOfPAlab): element hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="count(hl7:assignedPerson)&gt;=1 ">(CDAdocumentationOfPAlab): element hl7:assignedPerson is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="count(hl7:assignedPerson)&lt;=1">(CDAdocumentationOfPAlab): element hl7:assignedPerson komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="count(hl7:representedOrganization)&gt;=1 ">(CDAdocumentationOfPAlab): element hl7:representedOrganization is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="count(hl7:representedOrganization)&lt;=1">(CDAdocumentationOfPAlab): element hl7:representedOrganization komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900829
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]
Item: (CDAassignedEntityIdentification)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900829
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:id[@root='2.16.528.1.1007.3.1']
Item: (CDAassignedEntityIdentification)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:id[@root='2.16.528.1.1007.3.1']"
         id="tmp-r-f866fe43-44e4-46bd-b8e7-3d716d3aaf21">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAassignedEntityIdentification): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html"
              test="string(@root)=('2.16.528.1.1007.3.1')">(CDAassignedEntityIdentification): de waarde van @root MOET '2.16.528.1.1007.3.1' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900829
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:id
Item: (CDAassignedEntityIdentification)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:id"
         id="tmp-r-1136665f-bdf8-4958-a479-078012bc5f8f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAassignedEntityIdentification): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900816
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]
Item: (CDAdocumentationOfPAlab)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]"
         id="tmp-r-070db6a8-1bad-4e87-b29f-c39f30a7c3ab">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAdocumentationOfPAlab): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(CDAdocumentationOfPAlab): de elementwaarde MOET een zijn van 'vs_typerol Medische rollen (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(CDAdocumentationOfPAlab): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_typerol Medische rollen (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900816
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:addr
Item: (CDAdocumentationOfPAlab)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:addr"
         id="tmp-r-5ba4a446-2186-434a-aea9-5cfc8bdcb15d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAdocumentationOfPAlab): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="AD"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900816
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:telecom
Item: (CDAdocumentationOfPAlab)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:telecom"
         id="tmp-r-7b1bd84f-041c-49a5-b991-d0560f8759d7">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAdocumentationOfPAlab): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TEL"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900816
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:assignedPerson
Item: (CDAdocumentationOfPAlab)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:assignedPerson"
         id="tmp-r-de8eda3c-2203-4c08-9aca-edcc49c74cfb">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="string(@classCode)=('PSN')">(CDAdocumentationOfPAlab): de waarde van @classCode MOET 'PSN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(CDAdocumentationOfPAlab): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="count(hl7:name)&gt;=1 ">(CDAdocumentationOfPAlab): element hl7:name is required [min 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900816
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:assignedPerson/hl7:name
Item: (CDAdocumentationOfPAlab)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:assignedPerson/hl7:name"
         id="tmp-r-08149ed5-6e7f-4da5-a61c-c5cd56b35d1a">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAdocumentationOfPAlab): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="PN"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900816
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization
Item: (CDAdocumentationOfPAlab)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization"
         id="tmp-r-ea4fad9e-31d4-44f5-9c8d-8f3fd2473e74">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="string(@classCode)=('ORG')">(CDAdocumentationOfPAlab): de waarde van @classCode MOET 'ORG' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(CDAdocumentationOfPAlab): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <let name="elmcount"
           value="count(hl7:id[@root='2.16.528.1.1007.3.3']|hl7:id)"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="$elmcount&gt;=1">(CDAdocumentationOfPAlab): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="count(hl7:id[@root='2.16.528.1.1007.3.3'])&lt;=1">(CDAdocumentationOfPAlab): element hl7:id[@root='2.16.528.1.1007.3.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor)">(CDAdocumentationOfPAlab): element hl7:name is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="count(hl7:name)&lt;=1">(CDAdocumentationOfPAlab): element hl7:name komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="count(hl7:addr)&lt;=1">(CDAdocumentationOfPAlab): element hl7:addr komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="count(lab:code)&lt;=1">(CDAdocumentationOfPAlab): element lab:code komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization
Item: (CDArepresentedOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:id[@root='2.16.528.1.1007.3.3']
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:id[@root='2.16.528.1.1007.3.3']"
         id="tmp-r-1e6fce1f-0246-45b2-9579-e4c94ff958d9">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="string(@root)=('2.16.528.1.1007.3.3')">(CDArepresentedOrganization): de waarde van @root MOET '2.16.528.1.1007.3.3' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:id
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:id"
         id="tmp-r-a6a77620-089c-4da5-bcab-8235560047bb">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:name
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:name"
         id="tmp-r-63b1bcd7-d40b-43b0-9568-6f0a001524e0">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="ON"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:addr
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:addr"
         id="tmp-r-cda2ea4d-2403-4dcc-add3-909196ddea23">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="AD"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:telecom
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:telecom"
         id="tmp-r-7fdc4e67-f7d0-4130-b569-ff37ff1da973">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TEL"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/lab:code
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/lab:code"
         id="tmp-r-5a3e7d39-ed97-433b-838a-660b2da5f1a2">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(CDArepresentedOrganization): de elementwaarde MOET een zijn van 'vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(CDArepresentedOrganization): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.21
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component
Item: (nspbcpa2014)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component"
         id="tmp-r-7be9157f-5964-46a5-ae74-754fbb33336e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="string(@typeCode)=('COMP')">(nspbcpa2014): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="string(@contextConductionInd)=('true')">(nspbcpa2014): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.21
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody
Item: (nspbcpa2014)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody"
         id="tmp-r-1db0ce3d-6c9c-4a53-bd41-f996a6c25237">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="string(@classCode)=('DOCBODY')">(nspbcpa2014): de waarde van @classCode MOET 'DOCBODY' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="string(@moodCode)=('EVN')">(nspbcpa2014): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']])&lt;=1">(nspbcpa2014): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']])&lt;=1">(nspbcpa2014): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']])&lt;=1">(nspbcpa2014): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']])&gt;=1 ">(nspbcpa2014): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']])&lt;=1">(nspbcpa2014): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.21
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']]
Item: (nspbcpa2014)
-->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="string(@typeCode)=('COMP')">(nspbcpa2014): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="string(@contextConductionInd)=('true')">(nspbcpa2014): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.21
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']]
Item: (nspbcpa2014)
-->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="string(@typeCode)=('COMP')">(nspbcpa2014): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="string(@contextConductionInd)=('true')">(nspbcpa2014): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.21
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]
Item: (nspbcpa2014)
-->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="string(@typeCode)=('COMP')">(nspbcpa2014): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="string(@contextConductionInd)=('true')">(nspbcpa2014): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.21
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']]
Item: (nspbcpa2014)
-->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="string(@typeCode)=('COMP')">(nspbcpa2014): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="string(@contextConductionInd)=('true')">(nspbcpa2014): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/*[not(self::hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1'])]"
         id="tmp-r-1a1bbbd8-2076-4678-8ca7-b40cd4290467">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-1a1bbbd8-2076-4678-8ca7-b40cd4290467)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/*[not(self::hl7:realmCode[@code='NL']|self::hl7:typeId[@root='2.16.840.1.113883.1.3']|self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.21']|self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1']|self::hl7:templateId[@root='1.3.6.1.4.1.19376.1.8.1.1.1']|self::hl7:templateId[@root='1.3.6.1.4.1.19376.1.8.1.1.2.2']|self::hl7:id|self::hl7:code[(@code='11526-1' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:title|self::hl7:effectiveTime|self::hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]|self::hl7:languageCode|self::hl7:setId|self::hl7:versionNumber|self::hl7:recordTarget|self::hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100']|self::hl7:custodian|self::hl7:informationRecipient|self::hl7:authenticator|self::hl7:legalAuthenticator|self::hl7:relatedDocument|self::hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]|self::hl7:component)]"
         id="tmp-r-0d427f9e-a88e-41b9-8614-7e0665ebfbf2">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-0d427f9e-a88e-41b9-8614-7e0665ebfbf2)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget/*[not(self::hl7:patientRole)]"
         id="tmp-r-ad4c6b85-3ae3-45ef-af10-6e93dc724c4e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900831-2014-02-09T000000.html"
              test="not(.)">(CDArecordTargetPA): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-ad4c6b85-3ae3-45ef-af10-6e93dc724c4e)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget/hl7:patientRole/*[not(self::hl7:id[@root='2.16.840.1.113883.2.4.6.3'])]"
         id="tmp-r-4f2208c6-06cc-403b-864f-2a650c412fe3">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900831-2014-02-09T000000.html"
              test="not(.)">(CDArecordTargetPA): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-4f2208c6-06cc-403b-864f-2a650c412fe3)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.100']|self::hl7:time|self::hl7:assignedAuthor)]"
         id="tmp-r-ff0e1607-5879-4faa-ada0-e2703ce0655a">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.100-2012-07-04T000000.html"
              test="not(.)">(CDAauthor): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-ff0e1607-5879-4faa-ada0-e2703ce0655a)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100']/hl7:assignedAuthor/*[not(self::hl7:id[@root='2.16.528.1.1007.3.1']|self::hl7:id|self::hl7:code|self::hl7:assignedPerson|self::hl7:representedOrganization)]"
         id="tmp-r-55438dbf-c0e7-4e8d-96d0-673a8dff4041">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.100-2012-07-04T000000.html"
              test="not(.)">(CDAauthor): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-55438dbf-c0e7-4e8d-96d0-673a8dff4041)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100']/hl7:assignedAuthor/hl7:assignedPerson/*[not(self::hl7:name)]"
         id="tmp-r-faeb4f59-fbd1-433b-8105-7ac43363eaae">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.100-2012-07-04T000000.html"
              test="not(.)">(CDAauthor): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-faeb4f59-fbd1-433b-8105-7ac43363eaae)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100']/hl7:assignedAuthor/hl7:representedOrganization/*[not(self::hl7:id[@root='2.16.528.1.1007.3.3']|self::hl7:id|self::hl7:name|self::hl7:addr|self::hl7:telecom|self::lab:code)]"
         id="tmp-r-0732c7b4-1b04-479d-916d-46a954bd81d1">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.100-2012-07-04T000000.html"
              test="not(.)">(CDAauthor): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-0732c7b4-1b04-479d-916d-46a954bd81d1)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/*[not(self::hl7:assignedCustodian)]"
         id="tmp-r-effdbf5d-f36f-4ab3-afa5-8f8adb9ea19f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="not(.)">(CDAcustodian): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-effdbf5d-f36f-4ab3-afa5-8f8adb9ea19f)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/*[not(self::hl7:representedCustodianOrganization)]"
         id="tmp-r-cae05f95-b15b-422c-b876-6c96472e416c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="not(.)">(CDAcustodian): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-cae05f95-b15b-422c-b876-6c96472e416c)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/*[not(self::hl7:id[@root='2.16.528.1.1007.3.3']|self::hl7:id|self::hl7:name|self::hl7:addr|self::hl7:telecom|self::lab:code)]"
         id="tmp-r-179b6e2f-3629-4a2e-83e0-be35da53bc61">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="not(.)">(CDAcustodian): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-179b6e2f-3629-4a2e-83e0-be35da53bc61)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/*[not(self::hl7:intendedRecipient)]"
         id="tmp-r-593d9cb1-2ac5-4259-bd45-0c30d4e41bff">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="not(.)">(CDAinformationRecipient): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-593d9cb1-2ac5-4259-bd45-0c30d4e41bff)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/*[not(self::hl7:id|self::hl7:informationRecipient|self::hl7:representedOrganization)]"
         id="tmp-r-73a3c3e9-e519-489f-a268-fdd9f471558c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="not(.)">(CDAinformationRecipient): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-73a3c3e9-e519-489f-a268-fdd9f471558c)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:informationRecipient/*[not(self::hl7:name)]"
         id="tmp-r-54360c95-093f-4b97-8358-23f0c01cdf4e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="not(.)">(CDAinformationRecipient): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-54360c95-093f-4b97-8358-23f0c01cdf4e)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/*[not(self::hl7:id[@root='2.16.528.1.1007.3.3']|self::hl7:id|self::hl7:name|self::hl7:addr|self::hl7:telecom|self::lab:code)]"
         id="tmp-r-18e10967-3134-4311-b0ec-77eb8fdc841f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="not(.)">(CDAinformationRecipient): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-18e10967-3134-4311-b0ec-77eb8fdc841f)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/*[not(self::hl7:time|self::hl7:signatureCode[@code='S']|self::hl7:assignedEntity)]"
         id="tmp-r-de12979d-9304-4315-b7b6-99527ba36488">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="not(.)">(CDlegalAuthenticator): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-de12979d-9304-4315-b7b6-99527ba36488)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/*[not(self::hl7:id[@root='2.16.528.1.1007.3.1']|self::hl7:id|self::hl7:code|self::hl7:assignedPerson|self::hl7:representedOrganization)]"
         id="tmp-r-8550e8c2-e994-470e-acea-5ee3b5b8fca3">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="not(.)">(CDlegalAuthenticator): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-8550e8c2-e994-470e-acea-5ee3b5b8fca3)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:assignedPerson/*[not(self::hl7:name)]"
         id="tmp-r-91d00acd-8004-4dda-9526-31db531ea461">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="not(.)">(CDlegalAuthenticator): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-91d00acd-8004-4dda-9526-31db531ea461)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/*[not(self::hl7:id[@root='2.16.528.1.1007.3.3']|self::hl7:id|self::hl7:name|self::hl7:addr|self::hl7:telecom|self::lab:code)]"
         id="tmp-r-b9e5965a-504f-4645-9d89-6959a2fce960">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="not(.)">(CDlegalAuthenticator): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-b9e5965a-504f-4645-9d89-6959a2fce960)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/*[not(self::hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]])]"
         id="tmp-r-a9c86e24-4cda-47d8-9f06-60d8d0d0f27b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="not(.)">(CDAdocumentationOfPAlab): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-a9c86e24-4cda-47d8-9f06-60d8d0d0f27b)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/*[not(self::hl7:id|self::hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]|self::lab:statusCode[@code='completed']|self::hl7:effectiveTime|self::hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]])]"
         id="tmp-r-61360986-f3c1-4327-ad00-cd569a41fb71">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="not(.)">(CDAdocumentationOfPAlab): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-61360986-f3c1-4327-ad00-cd569a41fb71)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:effectiveTime/*[not(self::hl7:low|self::hl7:high)]"
         id="tmp-r-8d47c092-3b47-4587-8e1a-e99c2bd5e411">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="not(.)">(CDAdocumentationOfPAlab): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-8d47c092-3b47-4587-8e1a-e99c2bd5e411)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/*[not(self::hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]])]"
         id="tmp-r-24e2f1c4-a20d-46bc-bdd7-a7abcd5c160d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="not(.)">(CDAdocumentationOfPAlab): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-24e2f1c4-a20d-46bc-bdd7-a7abcd5c160d)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/*[not(self::hl7:id[@root='2.16.528.1.1007.3.1']|self::hl7:id|self::hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]|self::hl7:addr|self::hl7:telecom|self::hl7:assignedPerson|self::hl7:representedOrganization)]"
         id="tmp-r-fba75ab5-b366-471c-92b3-a9825fd8af3b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="not(.)">(CDAdocumentationOfPAlab): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-fba75ab5-b366-471c-92b3-a9825fd8af3b)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:assignedPerson/*[not(self::hl7:name)]"
         id="tmp-r-9b08616c-826d-4ff8-b007-802777ad3302">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="not(.)">(CDAdocumentationOfPAlab): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-9b08616c-826d-4ff8-b007-802777ad3302)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:serviceEvent[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.201-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/*[not(self::hl7:id[@root='2.16.528.1.1007.3.3']|self::hl7:id|self::hl7:name|self::hl7:addr|self::hl7:telecom|self::lab:code)]"
         id="tmp-r-851c3736-15f2-4102-92c8-5b22ae1d682b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900816-2014-04-16T000000.html"
              test="not(.)">(CDAdocumentationOfPAlab): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-851c3736-15f2-4102-92c8-5b22ae1d682b)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/*[not(self::hl7:structuredBody)]"
         id="tmp-r-19bf155d-5f28-42c5-af6d-61fb51f61f72">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-19bf155d-5f28-42c5-af6d-61fb51f61f72)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/*[not(self::hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']]|self::hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']]|self::hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]|self::hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']])]"
         id="tmp-r-0404ff88-a197-401b-a5b5-3c5506d46498">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-0404ff88-a197-401b-a5b5-3c5506d46498)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']]/*[not(self::hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200'])]"
         id="tmp-r-a0e65334-7e73-403d-b22d-69fbc43bd552">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-a0e65334-7e73-403d-b22d-69fbc43bd552)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']/*[not(self::hl7:templateId[@root='1.3.6.1.4.1.19376.1.8.1.2.1']|self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.200']|self::hl7:code[(@code='22636-5' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:title|self::hl7:text)]"
         id="tmp-r-e3c3aa3d-067a-4d9e-aeaf-c2e2cb494877">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-e3c3aa3d-067a-4d9e-aeaf-c2e2cb494877)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']]/*[not(self::hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210'])]"
         id="tmp-r-5df459f5-3005-4fe5-98ad-38b5d75ad09f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-5df459f5-3005-4fe5-98ad-38b5d75ad09f)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']/*[not(self::hl7:templateId[@root='1.3.6.1.4.1.19376.1.8.1.2.3']|self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.210']|self::hl7:code[(@code='22634-0' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:title|self::hl7:text|self::hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']])]"
         id="tmp-r-e61cf144-1002-4742-9df5-287fee110d50">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-e61cf144-1002-4742-9df5-287fee110d50)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/*[not(self::hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550'])]"
         id="tmp-r-7414a25a-8114-4928-a599-de55a0e1a818">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-7414a25a-8114-4928-a599-de55a0e1a818)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.550']|self::hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:statusCode|self::hl7:specimen)]"
         id="tmp-r-03c04854-2680-4329-9e43-746198df0832">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-03c04854-2680-4329-9e43-746198df0832)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/*[not(self::hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]])]"
         id="tmp-r-a27a1ae2-52a5-4213-b2f9-23ebc653d977">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-a27a1ae2-52a5-4213-b2f9-23ebc653d977)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/*[not(self::hl7:id|self::hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]|self::lab:productOf|self::lab:subjectOf[lab:observationEvent/lab:code/@code='371490004'])]"
         id="tmp-r-e90a573c-2d99-4d31-a2a9-9f9f5f9989e0">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-e90a573c-2d99-4d31-a2a9-9f9f5f9989e0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/*[not(self::hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]|self::hl7:quantity|self::lab:asSpecimenInContainer)]"
         id="tmp-r-1a25bc95-da9d-4f69-95fe-64af10d3f083">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-1a25bc95-da9d-4f69-95fe-64af10d3f083)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/lab:asSpecimenInContainer/*[not(self::lab:container)]"
         id="tmp-r-ad9501c3-790d-4d88-af00-848ed45a60dd">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-ad9501c3-790d-4d88-af00-848ed45a60dd)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/lab:asSpecimenInContainer/lab:container/*[not(self::lab:id)]"
         id="tmp-r-e30d58c1-e4d0-4c93-bc3c-79e1d5dffe1f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-e30d58c1-e4d0-4c93-bc3c-79e1d5dffe1f)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:productOf/*[not(self::lab:specimenCollectionProcess)]"
         id="tmp-r-133d56d2-f407-4137-9d4d-dcb67f692dab">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-133d56d2-f407-4137-9d4d-dcb67f692dab)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:productOf/lab:specimenCollectionProcess/*[not(self::lab:code|self::lab:effectiveTime|self::lab:targetSiteCode)]"
         id="tmp-r-87c4d8ac-89c4-4eb9-bdc7-2726f6d142ba">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-87c4d8ac-89c4-4eb9-bdc7-2726f6d142ba)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/*[not(self::lab:observationEvent)]"
         id="tmp-r-b57c8511-f6e3-470c-ae32-69296ab526f1">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-b57c8511-f6e3-470c-ae32-69296ab526f1)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent/*[not(self::lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')]|self::lab:value)]"
         id="tmp-r-a9e57c60-3c7b-47d8-9d66-49b7af47dc2e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-a9e57c60-3c7b-47d8-9d66-49b7af47dc2e)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/*[not(self::hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211'])]"
         id="tmp-r-f713840d-8642-4a2a-927b-2c747823a73f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-f713840d-8642-4a2a-927b-2c747823a73f)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/*[not(self::hl7:templateId[@root='1.3.6.1.4.1.19376.1.8.1.2.6']|self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.211']|self::hl7:code[(@code='22635-7' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:title|self::hl7:text|self::hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']])]"
         id="tmp-r-816e691e-8773-4dce-a0aa-0a9e93c35a54">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-816e691e-8773-4dce-a0aa-0a9e93c35a54)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/*[not(self::hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551'])]"
         id="tmp-r-56eab498-9264-4151-9efa-500c7e6790de">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-56eab498-9264-4151-9efa-500c7e6790de)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.551']|self::hl7:code[(@code='22635-7' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:statusCode[@code='completed']|self::hl7:specimen|self::hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']])]"
         id="tmp-r-1f10e54e-f627-4694-915a-4d8b4a465463">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-1f10e54e-f627-4694-915a-4d8b4a465463)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:specimen/*[not(self::hl7:specimenRole)]"
         id="tmp-r-285a3596-2b97-4b71-8d4a-284bb7eb7362">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.557-2012-04-10T000000.html"
              test="not(.)">(SpecimenReference): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-285a3596-2b97-4b71-8d4a-284bb7eb7362)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:specimen/hl7:specimenRole/*[not(self::hl7:id)]"
         id="tmp-r-144379db-ac15-48f5-8291-9f41c0b02037">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.557-2012-04-10T000000.html"
              test="not(.)">(SpecimenReference): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-144379db-ac15-48f5-8291-9f41c0b02037)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/*[not(self::hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8'])]"
         id="tmp-r-ddbc71b7-71d3-412a-a221-a87008f9f804">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-ddbc71b7-71d3-412a-a221-a87008f9f804)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/*[not(self::hl7:templateId[@root='1.3.6.1.4.1.19376.1.8.1.4.8']|self::hl7:statusCode[@code='completed']|self::hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.401']]|self::hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.402']]|self::hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.403']]|self::hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.404']]|self::hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.405']]|self::hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.406']]|self::hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.407']]|self::hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.408']]|self::hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.409']]|self::hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.410']]|self::hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.411']]|self::hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.412']]|self::hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.413']]|self::hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.420']]|self::hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.421']]|self::hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.422']]|self::hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.429']])]"
         id="tmp-r-39f95327-79e0-48ff-857f-b95c0ecb0c74">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-39f95327-79e0-48ff-857f-b95c0ecb0c74)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.401']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.401'])]"
         id="tmp-r-bdcd2221-2a5e-44a0-a646-2b230178d043">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-bdcd2221-2a5e-44a0-a646-2b230178d043)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.401']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.401']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.401']|self::hl7:code[(@code='399391008' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.19-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.19-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-ed845d8c-eb80-42c8-80a3-1163d44944e6">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-ed845d8c-eb80-42c8-80a3-1163d44944e6)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.402']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.402'])]"
         id="tmp-r-1a28aaf9-36f6-499e-9381-abee70e870f9">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-1a28aaf9-36f6-499e-9381-abee70e870f9)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.402']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.402']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.402']|self::hl7:code[(@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:value)]"
         id="tmp-r-29c4da2a-b093-4d18-8c40-5696c5025279">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-29c4da2a-b093-4d18-8c40-5696c5025279)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.403']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.403'])]"
         id="tmp-r-ce03bd9c-60ec-431b-9c5e-410657dc786c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-ce03bd9c-60ec-431b-9c5e-410657dc786c)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.403']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.403']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.403']|self::hl7:code[(@code='C155050' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.100')]|self::hl7:text|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.14-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.14-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-5c90ebc6-2cf0-44f3-b6c7-08445e1d1b74">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-5c90ebc6-2cf0-44f3-b6c7-08445e1d1b74)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.404']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.404'])]"
         id="tmp-r-a7ab6129-cad8-4e14-bc37-b99c0ec7fdb8">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-a7ab6129-cad8-4e14-bc37-b99c0ec7fdb8)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.404']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.404']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.404']|self::hl7:code[(@code='271920001' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:text|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.202-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.202-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-889a79c4-1af0-4291-addd-d541da5414cb">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-889a79c4-1af0-4291-addd-d541da5414cb)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.405']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.405'])]"
         id="tmp-r-82343968-dcf4-4d40-8a05-ed4ca8116160">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-82343968-dcf4-4d40-8a05-ed4ca8116160)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.405']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.405']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.405']|self::hl7:code[(@code='395526000' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.203-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.203-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-ca1337af-ddfb-4a7f-9290-5d1d889f087e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-ca1337af-ddfb-4a7f-9290-5d1d889f087e)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.406']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.406'])]"
         id="tmp-r-04f9ef39-af17-44ae-98a5-78a8a49bcd82">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-04f9ef39-af17-44ae-98a5-78a8a49bcd82)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.406']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.406']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.406']|self::hl7:code[(@code='373372005' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.204-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.204-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-9e113090-3547-4c32-a0fd-dd9566881f97">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-9e113090-3547-4c32-a0fd-dd9566881f97)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.407']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.407'])]"
         id="tmp-r-4ac3f45d-c657-4e75-b01a-48edae22617e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-4ac3f45d-c657-4e75-b01a-48edae22617e)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.407']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.407']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.407']|self::hl7:code[(@code='371487005' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.212-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.212-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-b187de58-bda5-4a52-a676-cadf04e13e0e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-b187de58-bda5-4a52-a676-cadf04e13e0e)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.408']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.408'])]"
         id="tmp-r-70727597-c619-4275-b629-ddbd7587b9c2">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-70727597-c619-4275-b629-ddbd7587b9c2)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.408']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.408']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.408']|self::hl7:code[(@code='C155080' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.100')]|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.11-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.11-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-c4851457-f5e2-41e4-ac1a-a39ebea81b11">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-c4851457-f5e2-41e4-ac1a-a39ebea81b11)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.409']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.409'])]"
         id="tmp-r-c9ca7c2d-b16b-4a8d-a979-9b817f9e7ef5">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-c9ca7c2d-b16b-4a8d-a979-9b817f9e7ef5)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.409']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.409']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.409']|self::hl7:code[(@code='C155090' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.100')]|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.12-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.12-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-701fa2a7-f9d2-456c-977e-f265a164a432">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-701fa2a7-f9d2-456c-977e-f265a164a432)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.410']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.410'])]"
         id="tmp-r-adf69907-bac8-45e0-b106-411268de477c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-adf69907-bac8-45e0-b106-411268de477c)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.410']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.410']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.410']|self::hl7:code[(@code='371512006' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.17-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.17-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-ad077ae1-60b6-45a3-99ad-50f47811799f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-ad077ae1-60b6-45a3-99ad-50f47811799f)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.411']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.411'])]"
         id="tmp-r-9266e40f-d616-4ed6-8726-0ca24715aaa1">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-9266e40f-d616-4ed6-8726-0ca24715aaa1)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.411']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.411']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.411']|self::hl7:code[(@code='372249001' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.206-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.206-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-884f49f9-e94e-4078-b70a-2598df386e1b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-884f49f9-e94e-4078-b70a-2598df386e1b)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.412']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.412'])]"
         id="tmp-r-ec3cd134-d1a9-4bdc-aeb7-612ca3651125">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-ec3cd134-d1a9-4bdc-aeb7-612ca3651125)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.412']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.412']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.412']|self::hl7:code[(@code='384822004' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.219-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.219-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-19784ca4-13c4-45bb-88b0-24c66169f0f8">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-19784ca4-13c4-45bb-88b0-24c66169f0f8)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.413']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.413'])]"
         id="tmp-r-ef35cf47-be18-4f82-9b60-c2ed43c1d6f6">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-ef35cf47-be18-4f82-9b60-c2ed43c1d6f6)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.413']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.413']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.413']|self::hl7:code[(@code='371441004' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:text|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.207-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.207-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-b7cc4486-5e46-4669-8745-5a54f6447533">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-b7cc4486-5e46-4669-8745-5a54f6447533)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.420']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.420'])]"
         id="tmp-r-a8a01b81-fcf2-4a0f-9d82-717cdf8c4a67">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-a8a01b81-fcf2-4a0f-9d82-717cdf8c4a67)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.420']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.420']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.420']|self::hl7:code[(@code='259981004' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.209-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.209-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-b01a1134-7e37-4688-b580-af7e0328366a">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-b01a1134-7e37-4688-b580-af7e0328366a)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.421']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.421'])]"
         id="tmp-r-c5a49698-503f-4dd4-a408-4f8b3cd1b3c7">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-c5a49698-503f-4dd4-a408-4f8b3cd1b3c7)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.421']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.421']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.421']|self::hl7:code[(@code='443158003' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.210-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.210-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-6e8e9583-257d-4c4c-bc44-b56ece6291e6">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-6e8e9583-257d-4c4c-bc44-b56ece6291e6)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.422']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.422'])]"
         id="tmp-r-4807e846-4423-404c-8beb-b3b6c0571f37">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-4807e846-4423-404c-8beb-b3b6c0571f37)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.422']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.422']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.422']|self::hl7:code[(@code='254310002' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.218-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.218-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-0f22ceb8-490b-470a-8ca1-72031c627b74">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-0f22ceb8-490b-470a-8ca1-72031c627b74)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.429']]/*[not(self::hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.429'])]"
         id="tmp-r-a820d30f-63e9-47d7-9c58-7800c2f4615e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-a820d30f-63e9-47d7-9c58-7800c2f4615e)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.429']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.429']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.429']|self::hl7:code[(@code='726007' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:text)]"
         id="tmp-r-cee0ee18-abf5-4d5f-84be-9d2d699f077d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-cee0ee18-abf5-4d5f-84be-9d2d699f077d)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.429']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.429']/hl7:code[(@code='726007' and @codeSystem='2.16.840.1.113883.6.96')]/*[not(self::hl7:qualifier)]"
         id="tmp-r-11f2d2d7-7f1f-423b-99b1-23c436d8cebb">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-11f2d2d7-7f1f-423b-99b1-23c436d8cebb)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.429']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.429']/hl7:code[(@code='726007' and @codeSystem='2.16.840.1.113883.6.96')]/hl7:qualifier/*[not(self::hl7:name[(@code='408730004' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.226-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.226-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])]"
         id="tmp-r-06ad4629-0b47-4b75-90c8-3291d22212f9">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-06ad4629-0b47-4b75-90c8-3291d22212f9)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.429']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.429']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-a4c8dfcd-5d19-440b-9228-81b0f3f34722">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-a4c8dfcd-5d19-440b-9228-81b0f3f34722)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']]/*[not(self::hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212'])]"
         id="tmp-r-c83c36d3-94f4-44b8-94db-dc2c188e989c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-c83c36d3-94f4-44b8-94db-dc2c188e989c)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.212']|self::hl7:code[(@code='22637-3' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:title|self::hl7:text|self::hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']]|self::hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.430']])]"
         id="tmp-r-c206baf8-f6a8-491a-a15d-95db61ba6e65">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-c206baf8-f6a8-491a-a15d-95db61ba6e65)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']]/*[not(self::hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315'])]"
         id="tmp-r-59546ea4-aa0e-4282-bb9f-122f752126f2">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-59546ea4-aa0e-4282-bb9f-122f752126f2)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.315']|self::hl7:statusCode[@code='completed']|self::hl7:effectiveTime|self::hl7:specimen|self::hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.317']])]"
         id="tmp-r-70e8d048-6478-4627-b2ea-838c4da0cd36">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-70e8d048-6478-4627-b2ea-838c4da0cd36)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']/hl7:specimen/*[not(self::hl7:specimenRole)]"
         id="tmp-r-2b967372-ee89-4ef0-93f1-7736d5a11d4c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.557-2012-04-10T000000.html"
              test="not(.)">(SpecimenReference): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-2b967372-ee89-4ef0-93f1-7736d5a11d4c)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']/hl7:specimen/hl7:specimenRole/*[not(self::hl7:id)]"
         id="tmp-r-69730623-bc2d-45df-ad04-2d8233e3a695">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.557-2012-04-10T000000.html"
              test="not(.)">(SpecimenReference): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-69730623-bc2d-45df-ad04-2d8233e3a695)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.317']]/*[not(self::hl7:sequenceNumber|self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.317'])]"
         id="tmp-r-8da1621c-e4f3-4bf9-8407-26b75ccdc8d8">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-8da1621c-e4f3-4bf9-8407-26b75ccdc8d8)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.317']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.317']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.317']|self::hl7:code[(@code='DX' and @codeSystem='2.16.840.1.113883.5.4')]|self::hl7:text|self::hl7:value[@codeSystem='2.16.840.1.113883.2.4.3.23.5.2' or @nullFlavor])]"
         id="tmp-r-e24ed3cc-a032-4475-9832-899bfab84461">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-e24ed3cc-a032-4475-9832-899bfab84461)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.317']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.317']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-39cf201f-5051-4a3d-b9cd-b7b1bc083372">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-39cf201f-5051-4a3d-b9cd-b7b1bc083372)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.430']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.430'])]"
         id="tmp-r-9721bb75-d439-4fd4-8b40-4dc66b725810">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-9721bb75-d439-4fd4-8b40-4dc66b725810)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.430']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.430']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.430']|self::hl7:code[(@code='C150090' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.100')]|self::hl7:text|self::hl7:value)]"
         id="tmp-r-8851ae27-3e49-40e1-9831-5cc4d29b0aa2">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-8851ae27-3e49-40e1-9831-5cc4d29b0aa2)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.21' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.430']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.430']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-ed743f92-eba8-4e28-8076-102e29af5ebe">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.21-2014-01-06T000000.html"
              test="not(.)">(nspbcpa2014): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-ed743f92-eba8-4e28-8076-102e29af5ebe)</assert>
   </rule>
</pattern>
