<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.36.10.210
Name: Macroscopie
Description: The Macroscopic Observation section contains the description of the specimen received or obtained by the laboratory (specimen type and state), the gross observation, links to gross images, if taken, processing information and tissue disposition (representative sampling and tissue submitted for additional studies or sent to biorepository.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.36.10.210-2012-04-10T000000">
   <title>Macroscopie</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.210
Context: *[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']]
Item: (GrossObservationSection)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.210
Context: *[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']
Item: (GrossObservationSection)
-->

   <rule context="*[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']"
         id="tmp-r-fe82d66a-501c-454a-a2bb-8769bde8a88a">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.210-2012-04-10T000000.html"
              test="string(@classCode)=('DOCSECT')">(GrossObservationSection): de waarde van @classCode MOET 'DOCSECT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.210-2012-04-10T000000.html"
              test="count(hl7:templateId[@root='1.3.6.1.4.1.19376.1.8.1.2.3'])&lt;=1">(GrossObservationSection): element hl7:templateId[@root='1.3.6.1.4.1.19376.1.8.1.2.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.210-2012-04-10T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.210'])&gt;=1 ">(GrossObservationSection): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.210'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.210-2012-04-10T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.210'])&lt;=1">(GrossObservationSection): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.210'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.210-2012-04-10T000000.html"
              test="count(hl7:code[(@code='22634-0' and @codeSystem='2.16.840.1.113883.6.1')])&gt;=1 and not(hl7:code[(@code='22634-0' and @codeSystem='2.16.840.1.113883.6.1')]/@nullFlavor)">(GrossObservationSection): element hl7:code[(@code='22634-0' and @codeSystem='2.16.840.1.113883.6.1')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.210-2012-04-10T000000.html"
              test="count(hl7:code[(@code='22634-0' and @codeSystem='2.16.840.1.113883.6.1')])&lt;=1">(GrossObservationSection): element hl7:code[(@code='22634-0' and @codeSystem='2.16.840.1.113883.6.1')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.210-2012-04-10T000000.html"
              test="count(hl7:title)&gt;=1 and not(hl7:title/@nullFlavor)">(GrossObservationSection): element hl7:title is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.210-2012-04-10T000000.html"
              test="count(hl7:title)&lt;=1">(GrossObservationSection): element hl7:title komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.210-2012-04-10T000000.html"
              test="count(hl7:text)&gt;=1 and not(hl7:text/@nullFlavor)">(GrossObservationSection): element hl7:text is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.210-2012-04-10T000000.html"
              test="count(hl7:text)&lt;=1">(GrossObservationSection): element hl7:text komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.210-2012-04-10T000000.html"
              test="count(hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']])&gt;=1 ">(GrossObservationSection): element hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']] is required [min 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.210
Context: *[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']/hl7:templateId[@root='1.3.6.1.4.1.19376.1.8.1.2.3']
Item: (GrossObservationSection)
-->

   <rule context="*[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']/hl7:templateId[@root='1.3.6.1.4.1.19376.1.8.1.2.3']"
         id="tmp-r-050ef57a-8a54-4886-991c-b3ff74b8eb46">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.210-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(GrossObservationSection): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.210-2012-04-10T000000.html"
              test="string(@root)=('1.3.6.1.4.1.19376.1.8.1.2.3')">(GrossObservationSection): de waarde van @root MOET '1.3.6.1.4.1.19376.1.8.1.2.3' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.210
Context: *[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.210']
Item: (GrossObservationSection)
-->

   <rule context="*[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.210']"
         id="tmp-r-8a37ee11-2b68-4e04-94b8-827ad0ae8dc8">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.210-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(GrossObservationSection): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.210-2012-04-10T000000.html"
              test="string(@root)=('2.16.840.1.113883.2.4.3.36.10.210')">(GrossObservationSection): de waarde van @root MOET '2.16.840.1.113883.2.4.3.36.10.210' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.210
Context: *[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']/hl7:code[(@code='22634-0' and @codeSystem='2.16.840.1.113883.6.1')]
Item: (GrossObservationSection)
-->

   <rule context="*[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']/hl7:code[(@code='22634-0' and @codeSystem='2.16.840.1.113883.6.1')]"
         id="tmp-r-98ff0f56-a193-4576-81e9-b678ea95dc43">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.210-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(GrossObservationSection): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.210-2012-04-10T000000.html"
              test="@nullFlavor or (@code='22634-0' and @codeSystem='2.16.840.1.113883.6.1')">(GrossObservationSection): de elementwaarde MOET een zijn van 'code '22634-0' codeSystem '2.16.840.1.113883.6.1''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.210
Context: *[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']/hl7:title
Item: (GrossObservationSection)
-->

   <rule context="*[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']/hl7:title"
         id="tmp-r-2e9c1c56-2009-4c80-a2ac-569f89b7f211">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.210-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ST' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(GrossObservationSection): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.210-2012-04-10T000000.html"
              test="text()='Macroscopie'">(GrossObservationSection): de element content van hl7:title MOET ''Macroscopie'' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.210
Context: *[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']/hl7:text
Item: (GrossObservationSection)
-->

   <rule context="*[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']/hl7:text"
         id="tmp-r-cb91d799-8f73-4cce-b920-8ab4b7fe33d9">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.210-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='SD.TEXT' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(GrossObservationSection): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:SD.TEXT" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="SD.TEXT"/>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.210
Context: *[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]
Item: (GrossObservationSection)
-->
   <rule context="*[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.210']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.210-2012-04-10T000000.html"
              test="string(@typeCode)=('DRIV')">(GrossObservationSection): de waarde van @typeCode MOET 'DRIV' zijn.</assert>
   </rule>
</pattern>
