<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.36.10.333
Name: Specimen collection
Description: Template: Specimen collection
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000">
   <title>Specimen collection</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]"
         id="tmp-r-5a33e304-0725-4f2a-a2c6-274990ed5fcc">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333'])&gt;=1 and not(hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/@nullFlavor)">(SpecimencollectionMDL): element hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333'])&lt;=1">(SpecimencollectionMDL): element hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']"
         id="tmp-r-60cb5ad7-07ab-4b23-be45-6141a2c7ff70">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="string(@classCode)=('ACT')">(SpecimencollectionMDL): de waarde van @classCode MOET 'ACT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="string(@moodCode)=('EVN')">(SpecimencollectionMDL): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.333'])&gt;=1 ">(SpecimencollectionMDL): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.333'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.333'])&lt;=1">(SpecimencollectionMDL): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.333'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')])&gt;=1 and not(hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')]/@nullFlavor)">(SpecimencollectionMDL): element hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')])&lt;=1">(SpecimencollectionMDL): element hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(hl7:specimen)&gt;=1 and not(hl7:specimen/@nullFlavor)">(SpecimencollectionMDL): element hl7:specimen is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(hl7:specimen)&lt;=1">(SpecimencollectionMDL): element hl7:specimen komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.333']
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.333']"
         id="tmp-r-b1486e37-33e8-4bb7-85e3-854b4d783653">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimencollectionMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="string(@root)=('2.16.840.1.113883.2.4.3.36.10.333')">(SpecimencollectionMDL): de waarde van @root MOET '2.16.840.1.113883.2.4.3.36.10.333' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')]
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')]"
         id="tmp-r-cb3a1279-2e35-43dc-983a-41eec5c0cc45">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimencollectionMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="@nullFlavor or (@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')">(SpecimencollectionMDL): de elementwaarde MOET een zijn van 'code 'X-LAB-SPMSCT' codeSystem '2.16.840.1.113883.6.1''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen"
         id="tmp-r-af9229ec-ff9c-4c00-b40f-c2e59be20507">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="string(@typeCode)=('SPC')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SPC' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(hl7:specimenRole)&gt;=1 and not(hl7:specimenRole/@nullFlavor)">(SpecimencollectionMDL): element hl7:specimenRole is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(hl7:specimenRole)&lt;=1">(SpecimencollectionMDL): element hl7:specimenRole komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole"
         id="tmp-r-5861a0ef-720f-4e13-b3e9-214239b392f4">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="string(@classCode)=('SPEC')">(SpecimencollectionMDL): de waarde van @classCode MOET 'SPEC' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(lab:subjectOf/lab:procedure[lab:code/@code='702389009'][@negationInd='false'])=0 or count(hl7:specimenPlayingEntity/lab:asSpecimenInContainer/lab:container/lab:id)&gt;0">(SpecimencollectionMDL): Als materiaal wordt ingezonden dan moet er een potjenummer opgegeven worden</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="(not(hl7:specimenPlayingEntity) or hl7:specimenPlayingEntity/hl7:code/@code!='309226005' or lab:subjectOf[lab:observationEvent/lab:code/@code='384627007'])">(SpecimencollectionMDL): 
                            If type of specimen = polpy, Diameterpoliep SHALL be present
                        </assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="(not(hl7:specimenPlayingEntity) or hl7:specimenPlayingEntity/hl7:code/@code!='309226005' or lab:subjectOf[lab:observationEvent/lab:code/@code='41329004'])">(SpecimencollectionMDL): 
                            If type of specimen = polpy, Morfologie SHALL be present
                        </assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="(not(hl7:specimenPlayingEntity) or hl7:specimenPlayingEntity/hl7:code/@code!='309226005' or lab:subjectOf[lab:observationEvent/lab:code/@code='DX'])">(SpecimencollectionMDL): 
                            If type of specimen = polpy, Klinischediagnosepoliep SHALL be present
                        </assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(hl7:id)&lt;=1">(SpecimencollectionMDL): element hl7:id komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(hl7:specimenPlayingEntity)&lt;=1">(SpecimencollectionMDL): element hl7:specimenPlayingEntity komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='C145061'])&lt;=1">(SpecimencollectionMDL): element lab:subjectOf[lab:observationEvent/lab:code/@code='C145061'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='384627007'])&lt;=1">(SpecimencollectionMDL): element lab:subjectOf[lab:observationEvent/lab:code/@code='384627007'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='41329004'])&lt;=1">(SpecimencollectionMDL): element lab:subjectOf[lab:observationEvent/lab:code/@code='41329004'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='DX'])&gt;=1 ">(SpecimencollectionMDL): element lab:subjectOf[lab:observationEvent/lab:code/@code='DX'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='DX'])&lt;=1">(SpecimencollectionMDL): element lab:subjectOf[lab:observationEvent/lab:code/@code='DX'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='269533000'])&lt;=1">(SpecimencollectionMDL): element lab:subjectOf[lab:observationEvent/lab:code/@code='269533000'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='19132000'])&lt;=1">(SpecimencollectionMDL): element lab:subjectOf[lab:observationEvent/lab:code/@code='19132000'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='371490004'])&lt;=1">(SpecimencollectionMDL): element lab:subjectOf[lab:observationEvent/lab:code/@code='371490004'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='C145140'])&lt;=1">(SpecimencollectionMDL): element lab:subjectOf[lab:observationEvent/lab:code/@code='C145140'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='14792009'])&lt;=1">(SpecimencollectionMDL): element lab:subjectOf[lab:observationEvent/lab:code/@code='14792009'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(lab:subjectOf[lab:procedure/lab:code/@code='702389009'])&lt;=1">(SpecimencollectionMDL): element lab:subjectOf[lab:procedure/lab:code/@code='702389009'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:id
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:id"
         id="tmp-r-1a886f8e-63c1-492d-a1ba-a5adff56f3d6">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimencollectionMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity"
         id="tmp-r-0f16bc58-27f0-4a76-b42d-416ca19548d9">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="string(@classCode)=('ENT')">(SpecimencollectionMDL): de waarde van @classCode MOET 'ENT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(SpecimencollectionMDL): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(hl7:code)&lt;=1">(SpecimencollectionMDL): element hl7:code komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(hl7:quantity)&lt;=1">(SpecimencollectionMDL): element hl7:quantity komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(lab:asSpecimenInContainer)&lt;=1">(SpecimencollectionMDL): element lab:asSpecimenInContainer komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity/hl7:code
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity/hl7:code"
         id="tmp-r-a39035a0-7e0f-4143-a27c-da7849c6140b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimencollectionMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(SpecimencollectionMDL): de elementwaarde MOET een zijn van 'vs_monstermateriaal Monster materiaal (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(SpecimencollectionMDL): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_monstermateriaal Monster materiaal (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity/hl7:quantity
Item: (SpecimencollectionMDL)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity/lab:asSpecimenInContainer
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity/lab:asSpecimenInContainer"
         id="tmp-r-1ca83dfd-4385-491f-989f-d0bf83d25e29">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="string(@classCode)=('CONT')">(SpecimencollectionMDL): de waarde van @classCode MOET 'CONT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(lab:container)&gt;=1 and not(lab:container/@nullFlavor)">(SpecimencollectionMDL): element lab:container is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(lab:container)&lt;=1">(SpecimencollectionMDL): element lab:container komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity/lab:asSpecimenInContainer/lab:container
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity/lab:asSpecimenInContainer/lab:container"
         id="tmp-r-8f90d339-0caf-495c-a141-9973a2966bdf">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="string(@classCode)=('CONT')">(SpecimencollectionMDL): de waarde van @classCode MOET 'CONT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(SpecimencollectionMDL): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(lab:id)&gt;=1 ">(SpecimencollectionMDL): element lab:id is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(lab:id)&lt;=1">(SpecimencollectionMDL): element lab:id komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity/lab:asSpecimenInContainer/lab:container/lab:id
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity/lab:asSpecimenInContainer/lab:container/lab:id"
         id="tmp-r-2312e509-68d7-4215-a183-113ddd9eabc6">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimencollectionMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="@extension">(SpecimencollectionMDL): attribute @extension MOET aanwezig zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="string(@nullFlavor)=('UNC')">(SpecimencollectionMDL): de waarde van @nullFlavor MOET 'UNC' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf"
         id="tmp-r-87715824-a620-418b-9121-942645aff813">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="string(@typeCode)=('PRD')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'PRD' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess"
         id="tmp-r-e1b5462b-9adc-4d5a-b62e-e11f6abad908">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="string(@classCode)=('SPECCOLLECT')">(SpecimencollectionMDL): de waarde van @classCode MOET 'SPECCOLLECT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="string(@moodCode)=('EVN')">(SpecimencollectionMDL): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="not(lab:methodCode[@nullFlavor='OTH']) or string-length(lab:methodCode/lab:originalText)&gt;0">(SpecimencollectionMDL): lab:originalText is verplicht indien bij lab:methodCode voor nullFlavor=OTH (overige) is gekozen</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="lab:methodCode[@code='9'] or lab:methodCode[@nullFlavor='OTH'] or count(lab:code/lab:qualifier)&gt;0">(SpecimencollectionMDL): lab:code/lab:qualifier (Methodeverwijdering, Resultaatverwijdering) aangeven indien lab:methodCode anders dan code=9 (niet verwijderd) is</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="not(lab:methodCode[@code='9']) or count(lab:code/lab:qualifier)=0">(SpecimencollectionMDL): Indien lab:methodCode code=9 (niet verwijderd) is mogen lab:code/lab:qualifier (Methodeverwijdering, Resultaatverwijdering) niet worden aangegeven</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(lab:code)&lt;=1">(SpecimencollectionMDL): element lab:code komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(lab:targetSiteCode)&lt;=1">(SpecimencollectionMDL): element lab:targetSiteCode komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code"
         id="tmp-r-b7012748-93a9-4672-aa5b-08d592946f7d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimencollectionMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CD"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.13-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(SpecimencollectionMDL): de elementwaarde MOET een zijn van 'vs_verkrijgingswijze Verkrijgingswijze (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.13-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(SpecimencollectionMDL): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_verkrijgingswijze Verkrijgingswijze (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900121
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='246386008']
Item: (Methodeverwijdering)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='246386008']"
         id="tmp-r-851117af-c4fb-46fc-b448-38977c12ed6d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900121-2015-03-08T000000.html"
              test="count(lab:name[(@code='246386008' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(lab:name[(@code='246386008' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Methodeverwijdering): element lab:name[(@code='246386008' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900121-2015-03-08T000000.html"
              test="count(lab:name[(@code='246386008' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Methodeverwijdering): element lab:name[(@code='246386008' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900121-2015-03-08T000000.html"
              test="count(lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.229-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.229-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])&gt;=1 and not(lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.229-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.229-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]/@nullFlavor)">(Methodeverwijdering): element lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.229-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.229-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900121-2015-03-08T000000.html"
              test="count(lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.229-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.229-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])&lt;=1">(Methodeverwijdering): element lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.229-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.229-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900121
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='246386008']/lab:name[(@code='246386008' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Methodeverwijdering)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='246386008']/lab:name[(@code='246386008' and @codeSystem='2.16.840.1.113883.6.96')]"
         id="tmp-r-9a094419-a5b3-410b-b9bd-bbd772a120a5">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900121-2015-03-08T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Methodeverwijdering): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900121-2015-03-08T000000.html"
              test="@nullFlavor or (@code='246386008' and @codeSystem='2.16.840.1.113883.6.96')">(Methodeverwijdering): de elementwaarde MOET een zijn van 'code '246386008' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900121
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='246386008']/lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.229-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.229-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]
Item: (Methodeverwijdering)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='246386008']/lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.229-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.229-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]"
         id="tmp-r-4657b7f1-4f99-41b2-a9fc-8981271ecc15">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900121-2015-03-08T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Methodeverwijdering): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900121-2015-03-08T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.229-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(Methodeverwijdering): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.36.77.11.229 Method of excision (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.229-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900121-2015-03-08T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(Methodeverwijdering): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst 2.16.840.1.113883.2.4.3.36.77.11.229 Method of excision (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900122
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='260858005']
Item: (Resultaatverwijdering)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='260858005']"
         id="tmp-r-23a95b8b-dfbb-4d1b-bc4c-1864edb5c7f4">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900122-2015-03-08T000000.html"
              test="count(lab:name[(@code='260858005' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(lab:name[(@code='260858005' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Resultaatverwijdering): element lab:name[(@code='260858005' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900122-2015-03-08T000000.html"
              test="count(lab:name[(@code='260858005' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Resultaatverwijdering): element lab:name[(@code='260858005' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900122-2015-03-08T000000.html"
              test="count(lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.230-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.230-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])&gt;=1 and not(lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.230-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.230-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]/@nullFlavor)">(Resultaatverwijdering): element lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.230-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.230-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900122-2015-03-08T000000.html"
              test="count(lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.230-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.230-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])&lt;=1">(Resultaatverwijdering): element lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.230-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.230-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900122
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='260858005']/lab:name[(@code='260858005' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Resultaatverwijdering)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='260858005']/lab:name[(@code='260858005' and @codeSystem='2.16.840.1.113883.6.96')]"
         id="tmp-r-087c4805-d606-42d7-a14f-7a7964bf7591">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900122-2015-03-08T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Resultaatverwijdering): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900122-2015-03-08T000000.html"
              test="@nullFlavor or (@code='260858005' and @codeSystem='2.16.840.1.113883.6.96')">(Resultaatverwijdering): de elementwaarde MOET een zijn van 'code '260858005' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900122
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='260858005']/lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.230-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.230-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]
Item: (Resultaatverwijdering)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='260858005']/lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.230-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.230-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]"
         id="tmp-r-d69fd51b-ee24-49dd-98f0-33a602598338">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900122-2015-03-08T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Resultaatverwijdering): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900122-2015-03-08T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.230-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(Resultaatverwijdering): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.36.77.11.230 Extent (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.230-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900122-2015-03-08T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(Resultaatverwijdering): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst 2.16.840.1.113883.2.4.3.36.77.11.230 Extent (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:targetSiteCode
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:targetSiteCode"
         id="tmp-r-c2e69941-781a-48f7-ae51-d310dadfd82b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimencollectionMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.23-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(SpecimencollectionMDL): de elementwaarde MOET een zijn van 'vs_lokalisatie Lokalisatie laesie bij coloscopie (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.23-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(SpecimencollectionMDL): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_lokalisatie Lokalisatie laesie bij coloscopie (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:methodCode
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:methodCode"
         id="tmp-r-1445ed22-73f0-48d5-af3f-9618b7e566f9">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimencollectionMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.34-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(SpecimencollectionMDL): de elementwaarde MOET een zijn van 'vs_verwijderingstechniek Verwijderingstechniek (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.34-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(SpecimencollectionMDL): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_verwijderingstechniek Verwijderingstechniek (DYNAMISCH).</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="count(lab:originalText)&lt;=1">(SpecimencollectionMDL): element lab:originalText komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:methodCode/lab:originalText
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:methodCode/lab:originalText"
         id="tmp-r-fa32d5f3-0d1a-4006-a5da-527d46a8492d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ST' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimencollectionMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="ST"/>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145061']
Item: (SpecimencollectionMDL)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145061']">
      <extends rule="tmp-r-0ab1f4dc-1f73-4136-978f-e28c78064002"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.348
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145061']
Item: (Distancefromanalvergelesion)
-->
   <rule id="tmp-r-0ab1f4dc-1f73-4136-978f-e28c78064002" abstract="true">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.348-2014-02-09T000000.html"
              test="count(lab:observationEvent)&gt;=1 and not(lab:observationEvent/@nullFlavor)">(Distancefromanalvergelesion): element lab:observationEvent is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.348-2014-02-09T000000.html"
              test="count(lab:observationEvent)&lt;=1">(Distancefromanalvergelesion): element lab:observationEvent komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.348
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145061']/lab:observationEvent
Item: (Distancefromanalvergelesion)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145061']/lab:observationEvent">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.348-2014-02-09T000000.html"
              test="string(@classCode)=('SPCOBS')">(Distancefromanalvergelesion): de waarde van @classCode MOET 'SPCOBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.348-2014-02-09T000000.html"
              test="string(@moodCode)=('EVN')">(Distancefromanalvergelesion): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.348-2014-02-09T000000.html"
              test="count(lab:code[(@code='C145061' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')])&gt;=1 and not(lab:code[(@code='C145061' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]/@nullFlavor)">(Distancefromanalvergelesion): element lab:code[(@code='C145061' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.348-2014-02-09T000000.html"
              test="count(lab:code[(@code='C145061' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')])&lt;=1">(Distancefromanalvergelesion): element lab:code[(@code='C145061' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.348-2014-02-09T000000.html"
              test="count(lab:value)&gt;=1 ">(Distancefromanalvergelesion): element lab:value is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.348-2014-02-09T000000.html"
              test="count(lab:value)&lt;=1">(Distancefromanalvergelesion): element lab:value komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.348
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145061']/lab:observationEvent/lab:code[(@code='C145061' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]
Item: (Distancefromanalvergelesion)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145061']/lab:observationEvent/lab:code[(@code='C145061' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.348-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Distancefromanalvergelesion): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.348-2014-02-09T000000.html"
              test="@nullFlavor or (@code='C145061' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')">(Distancefromanalvergelesion): de elementwaarde MOET een zijn van 'code 'C145061' codeSystem '2.16.840.1.113883.2.4.3.36.77.5.200''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.348
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145061']/lab:observationEvent/lab:value
Item: (Distancefromanalvergelesion)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145061']/lab:observationEvent/lab:value">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.348-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PQ' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Distancefromanalvergelesion): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PQ" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="PQ"/>
      <let name="theValue" value="@value"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.348-2014-02-09T000000.html"
              test="(@nullFlavor or (@unit='cm' and number($theValue)&gt;=1 and number($theValue)&lt;=200))">(Distancefromanalvergelesion): value MOET eenheid 'cm' gebruiken en in bereik [1..200] liggen  </assert>
      <let name="digitok"
           value="matches(string(@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.348-2014-02-09T000000.html"
              test="$digitok or @nullFlavor">(Distancefromanalvergelesion): @value is geen geldig PQ getal <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.348-2014-02-09T000000.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(Distancefromanalvergelesion): value/@unit (PQ) MOET een geldige UCUM-eenheid zijn (<value-of select="$UCUMtest"/>).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']
Item: (SpecimencollectionMDL)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']">
      <extends rule="tmp-r-0f9d2ca5-e260-4b9e-8de4-46f18ab7455c"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900102
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']
Item: (Diameterpoliep)
-->
   <rule id="tmp-r-0f9d2ca5-e260-4b9e-8de4-46f18ab7455c" abstract="true">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="count(lab:observationEvent)&gt;=1 and not(lab:observationEvent/@nullFlavor)">(Diameterpoliep): element lab:observationEvent is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="count(lab:observationEvent)&lt;=1">(Diameterpoliep): element lab:observationEvent komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900102
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']/lab:observationEvent
Item: (Diameterpoliep)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']/lab:observationEvent">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="string(@classCode)=('SPCOBS')">(Diameterpoliep): de waarde van @classCode MOET 'SPCOBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="string(@moodCode)=('EVN')">(Diameterpoliep): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="count(lab:code[(@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(lab:code[(@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Diameterpoliep): element lab:code[(@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="count(lab:code[(@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Diameterpoliep): element lab:code[(@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="count(lab:value)&gt;=1 ">(Diameterpoliep): element lab:value is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="count(lab:value)&lt;=1">(Diameterpoliep): element lab:value komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900102
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']/lab:observationEvent/lab:code[(@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Diameterpoliep)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']/lab:observationEvent/lab:code[(@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Diameterpoliep): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="@nullFlavor or (@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')">(Diameterpoliep): de elementwaarde MOET een zijn van 'code '384627007' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900102
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']/lab:observationEvent/lab:value
Item: (Diameterpoliep)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']/lab:observationEvent/lab:value">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PQ' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Diameterpoliep): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PQ" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="PQ"/>
      <let name="theValue" value="@value"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="(@nullFlavor or (@unit='mm'))">(Diameterpoliep): value MOET eenheid 'mm' gebruiken </assert>
      <let name="digitok"
           value="matches(string(@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="$digitok or @nullFlavor">(Diameterpoliep): @value is geen geldig PQ getal <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(Diameterpoliep): value/@unit (PQ) MOET een geldige UCUM-eenheid zijn (<value-of select="$UCUMtest"/>).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']
Item: (SpecimencollectionMDL)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']">
      <extends rule="tmp-r-4db6be37-54bf-4cf6-a884-3f98e17c9006"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900109
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']
Item: (Morfologie)
-->
   <rule id="tmp-r-4db6be37-54bf-4cf6-a884-3f98e17c9006" abstract="true">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="count(lab:observationEvent)&gt;=1 and not(lab:observationEvent/@nullFlavor)">(Morfologie): element lab:observationEvent is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="count(lab:observationEvent)&lt;=1">(Morfologie): element lab:observationEvent komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900109
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']/lab:observationEvent
Item: (Morfologie)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']/lab:observationEvent">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="string(@classCode)=('SPCOBS')">(Morfologie): de waarde van @classCode MOET 'SPCOBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="string(@moodCode)=('EVN')">(Morfologie): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="count(lab:code[(@code='41329004' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(lab:code[(@code='41329004' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Morfologie): element lab:code[(@code='41329004' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="count(lab:code[(@code='41329004' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Morfologie): element lab:code[(@code='41329004' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="count(lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])&gt;=1 ">(Morfologie): element lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="count(lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])&lt;=1">(Morfologie): element lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900109
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']/lab:observationEvent/lab:code[(@code='41329004' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Morfologie)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']/lab:observationEvent/lab:code[(@code='41329004' and @codeSystem='2.16.840.1.113883.6.96')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Morfologie): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="@nullFlavor or (@code='41329004' and @codeSystem='2.16.840.1.113883.6.96')">(Morfologie): de elementwaarde MOET een zijn van 'code '41329004' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900109
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']/lab:observationEvent/lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]
Item: (Morfologie)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']/lab:observationEvent/lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Morfologie): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(Morfologie): de elementwaarde MOET een zijn van 'vs_morfologie_coloscopie Morfologie coloscopie (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(Morfologie): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_morfologie_coloscopie Morfologie coloscopie (DYNAMISCH).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']
Item: (SpecimencollectionMDL)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']">
      <extends rule="tmp-r-fea5b845-5d8e-4f1b-952c-6dd8ce482f87"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900106
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']
Item: (Klinischediagnosepoliep)
-->
   <rule id="tmp-r-fea5b845-5d8e-4f1b-952c-6dd8ce482f87" abstract="true">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="count(lab:observationEvent)&gt;=1 and not(lab:observationEvent/@nullFlavor)">(Klinischediagnosepoliep): element lab:observationEvent is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="count(lab:observationEvent)&lt;=1">(Klinischediagnosepoliep): element lab:observationEvent komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900106
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']/lab:observationEvent
Item: (Klinischediagnosepoliep)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']/lab:observationEvent">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="string(@classCode)=('SPCOBS')">(Klinischediagnosepoliep): de waarde van @classCode MOET 'SPCOBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="string(@moodCode)=('EVN')">(Klinischediagnosepoliep): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="count(lab:code[(@code='DX' and @codeSystem='2.16.840.1.113883.5.4')])&gt;=1 and not(lab:code[(@code='DX' and @codeSystem='2.16.840.1.113883.5.4')]/@nullFlavor)">(Klinischediagnosepoliep): element lab:code[(@code='DX' and @codeSystem='2.16.840.1.113883.5.4')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="count(lab:code[(@code='DX' and @codeSystem='2.16.840.1.113883.5.4')])&lt;=1">(Klinischediagnosepoliep): element lab:code[(@code='DX' and @codeSystem='2.16.840.1.113883.5.4')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="count(lab:text)&lt;=1">(Klinischediagnosepoliep): element lab:text komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="count(lab:value)&lt;=1">(Klinischediagnosepoliep): element lab:value komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900106
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']/lab:observationEvent/lab:code[(@code='DX' and @codeSystem='2.16.840.1.113883.5.4')]
Item: (Klinischediagnosepoliep)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']/lab:observationEvent/lab:code[(@code='DX' and @codeSystem='2.16.840.1.113883.5.4')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Klinischediagnosepoliep): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="@nullFlavor or (@code='DX' and @codeSystem='2.16.840.1.113883.5.4')">(Klinischediagnosepoliep): de elementwaarde MOET een zijn van 'code 'DX' codeSystem '2.16.840.1.113883.5.4''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900107
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']/lab:observationEvent/lab:text
Item: (Overigeklinischediagnosepoliep)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']/lab:observationEvent/lab:text">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900107-2012-10-30T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ST' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Overigeklinischediagnosepoliep): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="ST"/>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900106
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']/lab:observationEvent/lab:value
Item: (Klinischediagnosepoliep)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']/lab:observationEvent/lab:value">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Klinischediagnosepoliep): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.30-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(Klinischediagnosepoliep): de elementwaarde MOET een zijn van 'vs_klindiag_coloscopie Klinische diagnose coloscopie (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.30-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(Klinischediagnosepoliep): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_klindiag_coloscopie Klinische diagnose coloscopie (DYNAMISCH).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='269533000']
Item: (SpecimencollectionMDL)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='269533000']">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.339
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='269533000']
Item: (Carcinoom)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.339
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='269533000']/lab:observationEvent
Item: (Carcinoom)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='269533000']/lab:observationEvent">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.339-2013-03-08T000000.html"
              test="string(@classCode)=('SPCOBS')">(Carcinoom): de waarde van @classCode MOET 'SPCOBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.339-2013-03-08T000000.html"
              test="string(@moodCode)=('EVN')">(Carcinoom): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.339-2013-03-08T000000.html"
              test="count(lab:code[(@code='269533000' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(lab:code[(@code='269533000' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Carcinoom): element lab:code[(@code='269533000' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.339-2013-03-08T000000.html"
              test="count(lab:code[(@code='269533000' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Carcinoom): element lab:code[(@code='269533000' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.339
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='269533000']/lab:observationEvent/lab:code[(@code='269533000' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Carcinoom)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='269533000']/lab:observationEvent/lab:code[(@code='269533000' and @codeSystem='2.16.840.1.113883.6.96')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.339-2013-03-08T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Carcinoom): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.339-2013-03-08T000000.html"
              test="@nullFlavor or (@code='269533000' and @codeSystem='2.16.840.1.113883.6.96')">(Carcinoom): de elementwaarde MOET een zijn van 'code '269533000' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='19132000']
Item: (SpecimencollectionMDL)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='19132000']">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.424
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='19132000']
Item: (Stenosis)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.424
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='19132000']/lab:observationEvent
Item: (Stenosis)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='19132000']/lab:observationEvent">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.424-2013-03-08T000000.html"
              test="string(@classCode)=('SPCOBS')">(Stenosis): de waarde van @classCode MOET 'SPCOBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.424-2013-03-08T000000.html"
              test="string(@moodCode)=('EVN')">(Stenosis): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.424-2013-03-08T000000.html"
              test="count(lab:code[(@code='19132000' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(lab:code[(@code='19132000' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Stenosis): element lab:code[(@code='19132000' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.424-2013-03-08T000000.html"
              test="count(lab:code[(@code='19132000' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Stenosis): element lab:code[(@code='19132000' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.424
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='19132000']/lab:observationEvent/lab:code[(@code='19132000' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Stenosis)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='19132000']/lab:observationEvent/lab:code[(@code='19132000' and @codeSystem='2.16.840.1.113883.6.96')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.424-2013-03-08T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Stenosis): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.424-2013-03-08T000000.html"
              test="@nullFlavor or (@code='19132000' and @codeSystem='2.16.840.1.113883.6.96')">(Stenosis): de elementwaarde MOET een zijn van 'code '19132000' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']
Item: (SpecimencollectionMDL)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']">
      <extends rule="tmp-r-be9bf5a0-8827-4f02-86ae-b52d646c6bc1"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900120
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']
Item: (Distanceoftumorfromanalverge)
-->
   <rule id="tmp-r-be9bf5a0-8827-4f02-86ae-b52d646c6bc1" abstract="true">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="count(lab:observationEvent)&gt;=1 and not(lab:observationEvent/@nullFlavor)">(Distanceoftumorfromanalverge): element lab:observationEvent is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="count(lab:observationEvent)&lt;=1">(Distanceoftumorfromanalverge): element lab:observationEvent komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900120
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent
Item: (Distanceoftumorfromanalverge)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="string(@classCode)=('SPCOBS')">(Distanceoftumorfromanalverge): de waarde van @classCode MOET 'SPCOBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="string(@moodCode)=('EVN')">(Distanceoftumorfromanalverge): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="count(lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Distanceoftumorfromanalverge): element lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="count(lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Distanceoftumorfromanalverge): element lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="count(lab:value)&gt;=1 ">(Distanceoftumorfromanalverge): element lab:value is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="count(lab:value)&lt;=1">(Distanceoftumorfromanalverge): element lab:value komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900120
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent/lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Distanceoftumorfromanalverge)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent/lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Distanceoftumorfromanalverge): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="@nullFlavor or (@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')">(Distanceoftumorfromanalverge): de elementwaarde MOET een zijn van 'code '371490004' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900120
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent/lab:value
Item: (Distanceoftumorfromanalverge)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent/lab:value">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PQ' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Distanceoftumorfromanalverge): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PQ" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="PQ"/>
      <let name="theValue" value="@value"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="(@nullFlavor or (@unit='cm' and number($theValue)&gt;=0 and number($theValue)&lt;=200))">(Distanceoftumorfromanalverge): value MOET eenheid 'cm' gebruiken en in bereik [0..200] liggen  </assert>
      <let name="digitok"
           value="matches(string(@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="$digitok or @nullFlavor">(Distanceoftumorfromanalverge): @value is geen geldig PQ getal <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(Distanceoftumorfromanalverge): value/@unit (PQ) MOET een geldige UCUM-eenheid zijn (<value-of select="$UCUMtest"/>).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']
Item: (SpecimencollectionMDL)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.427
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']
Item: (Carcinomapassable)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.427
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']/lab:observationEvent
Item: (Carcinomapassable)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']/lab:observationEvent">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.427-2013-03-08T000000.html"
              test="string(@classCode)=('SPCOBS')">(Carcinomapassable): de waarde van @classCode MOET 'SPCOBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.427-2013-03-08T000000.html"
              test="string(@moodCode)=('EVN')">(Carcinomapassable): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.427-2013-03-08T000000.html"
              test="count(lab:code[(@code='C145140' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')])&gt;=1 and not(lab:code[(@code='C145140' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]/@nullFlavor)">(Carcinomapassable): element lab:code[(@code='C145140' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.427-2013-03-08T000000.html"
              test="count(lab:code[(@code='C145140' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')])&lt;=1">(Carcinomapassable): element lab:code[(@code='C145140' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.427-2013-03-08T000000.html"
              test="count(lab:value)&gt;=1 ">(Carcinomapassable): element lab:value is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.427-2013-03-08T000000.html"
              test="count(lab:value)&lt;=1">(Carcinomapassable): element lab:value komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.427
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']/lab:observationEvent/lab:code[(@code='C145140' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]
Item: (Carcinomapassable)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']/lab:observationEvent/lab:code[(@code='C145140' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.427-2013-03-08T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Carcinomapassable): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.427-2013-03-08T000000.html"
              test="@nullFlavor or (@code='C145140' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')">(Carcinomapassable): de elementwaarde MOET een zijn van 'code 'C145140' codeSystem '2.16.840.1.113883.2.4.3.36.77.5.200''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.427
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']/lab:observationEvent/lab:value
Item: (Carcinomapassable)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']/lab:observationEvent/lab:value">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.427-2013-03-08T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='BL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Carcinomapassable): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:BL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="BL"/>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']
Item: (SpecimencollectionMDL)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900118
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']
Item: (Tattooing)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900118
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']/lab:observationEvent
Item: (Tattooing)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']/lab:observationEvent">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900118-2012-04-10T000000.html"
              test="string(@classCode)=('SPCOBS')">(Tattooing): de waarde van @classCode MOET 'SPCOBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900118-2012-04-10T000000.html"
              test="string(@moodCode)=('EVN')">(Tattooing): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900118-2012-04-10T000000.html"
              test="count(lab:code[(@code='14792009' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(lab:code[(@code='14792009' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Tattooing): element lab:code[(@code='14792009' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900118-2012-04-10T000000.html"
              test="count(lab:code[(@code='14792009' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Tattooing): element lab:code[(@code='14792009' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900118-2012-04-10T000000.html"
              test="count(lab:value)&gt;=1 ">(Tattooing): element lab:value is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900118-2012-04-10T000000.html"
              test="count(lab:value)&lt;=1">(Tattooing): element lab:value komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900118
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']/lab:observationEvent/lab:code[(@code='14792009' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Tattooing)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']/lab:observationEvent/lab:code[(@code='14792009' and @codeSystem='2.16.840.1.113883.6.96')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900118-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Tattooing): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900118-2012-04-10T000000.html"
              test="@nullFlavor or (@code='14792009' and @codeSystem='2.16.840.1.113883.6.96')">(Tattooing): de elementwaarde MOET een zijn van 'code '14792009' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900118
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']/lab:observationEvent/lab:value
Item: (Tattooing)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']/lab:observationEvent/lab:value">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900118-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='BL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Tattooing): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:BL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="BL"/>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:procedure/lab:code/@code='702389009']
Item: (SpecimencollectionMDL)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:procedure/lab:code/@code='702389009']">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2015-02-15T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.431
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:procedure/lab:code/@code='702389009']
Item: (Pathologyspecimensubmitted)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.431
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:procedure/lab:code/@code='702389009']/lab:procedure
Item: (Pathologyspecimensubmitted)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:procedure/lab:code/@code='702389009']/lab:procedure">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.431-2015-03-08T000000.html"
              test="string(@classCode)=('PROC')">(Pathologyspecimensubmitted): de waarde van @classCode MOET 'PROC' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.431-2015-03-08T000000.html"
              test="string(@moodCode)=('EVN')">(Pathologyspecimensubmitted): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.431-2015-03-08T000000.html"
              test="@negationInd">(Pathologyspecimensubmitted): attribute @negationInd MOET aanwezig zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.431-2015-03-08T000000.html"
              test="not(@negationInd) or string(@negationInd)=('true','false')">(Pathologyspecimensubmitted): attribuut @negationInd MOET datatype 'bl' hebben</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.431-2015-03-08T000000.html"
              test="count(lab:code[(@code='702389009' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(lab:code[(@code='702389009' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Pathologyspecimensubmitted): element lab:code[(@code='702389009' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.431-2015-03-08T000000.html"
              test="count(lab:code[(@code='702389009' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Pathologyspecimensubmitted): element lab:code[(@code='702389009' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.431
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:procedure/lab:code/@code='702389009']/lab:procedure/lab:code[(@code='702389009' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Pathologyspecimensubmitted)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:procedure/lab:code/@code='702389009']/lab:procedure/lab:code[(@code='702389009' and @codeSystem='2.16.840.1.113883.6.96')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.431-2015-03-08T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Pathologyspecimensubmitted): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.431-2015-03-08T000000.html"
              test="@nullFlavor or (@code='702389009' and @codeSystem='2.16.840.1.113883.6.96')">(Pathologyspecimensubmitted): de elementwaarde MOET een zijn van 'code '702389009' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>
</pattern>
