<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.36.10.338
Name: Verslag identificatie pathologie
Description: Template: Verslag identificatie pathologie 
                Pathologieverslagen worden geïdentificeerd met T-nummers of pa-nummers. Een verslag wordt normaal aangeduid met 
                een pa-nummer: Xjj-nnnnn (b.v. T12-60123). Een specifieke versie kan worden aangegeven met de versie-aanduiding (letter) daar achter (b.v. T12-60123A).
                 Maar de versie wordt tot dusver alleen intern in het lab gebruikt (en heel recent tussen laboratoria 
                onderling waar ook CDA consult uitslagen verstuurd worden), naar buiten toe (MDL) gaat alleen het pa-nummer.
                 Deze nummers worden opgenomen in de CDA  PA verslagen , zonder streepje: 
                     pa-nummer (zonder volgletter): staat in ClinicalDocument.setId (b.v. T1260123) 
                     pa-nummer (met volgletter): staat in ClinicalDocument.id (b.v. T1260123A) 
                 
                Verder is het T-nummer in het  MDL-verslag  opgenomen in dit template zoals in het voorbeeld 
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.36.10.338-2014-02-24T000000">
   <title>Verslag identificatie pathologie</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.338
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.338']]
Item: (Verslagidentificatiepathologie)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.338
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.338']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.338']
Item: (Verslagidentificatiepathologie)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.338']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.338']"
         id="tmp-r-d99227a6-4407-4a82-87ee-da530190f8d8">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.338-2014-02-24T000000.html"
              test="string(@classCode)=('ACT')">(Verslagidentificatiepathologie): de waarde van @classCode MOET 'ACT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.338-2014-02-24T000000.html"
              test="string(@moodCode)=('EVN')">(Verslagidentificatiepathologie): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.338-2014-02-24T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.338'])&gt;=1 ">(Verslagidentificatiepathologie): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.338'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.338-2014-02-24T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.338'])&lt;=1">(Verslagidentificatiepathologie): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.338'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.338-2014-02-24T000000.html"
              test="count(hl7:id)&gt;=1 and not(hl7:id/@nullFlavor)">(Verslagidentificatiepathologie): element hl7:id is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.338-2014-02-24T000000.html"
              test="count(hl7:id)&lt;=1">(Verslagidentificatiepathologie): element hl7:id komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.338-2014-02-24T000000.html"
              test="count(hl7:code[(@code='11526-1' and @codeSystem='2.16.840.1.113883.6.1')])&gt;=1 and not(hl7:code[(@code='11526-1' and @codeSystem='2.16.840.1.113883.6.1')]/@nullFlavor)">(Verslagidentificatiepathologie): element hl7:code[(@code='11526-1' and @codeSystem='2.16.840.1.113883.6.1')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.338-2014-02-24T000000.html"
              test="count(hl7:code[(@code='11526-1' and @codeSystem='2.16.840.1.113883.6.1')])&lt;=1">(Verslagidentificatiepathologie): element hl7:code[(@code='11526-1' and @codeSystem='2.16.840.1.113883.6.1')] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.338
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.338']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.338']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.338']
Item: (Verslagidentificatiepathologie)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.338']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.338']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.338']"
         id="tmp-r-b82b9465-df9a-44a9-bf9a-5b158eed862b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.338-2014-02-24T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Verslagidentificatiepathologie): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.338-2014-02-24T000000.html"
              test="string(@root)=('2.16.840.1.113883.2.4.3.36.10.338')">(Verslagidentificatiepathologie): de waarde van @root MOET '2.16.840.1.113883.2.4.3.36.10.338' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.338
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.338']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.338']/hl7:id
Item: (Verslagidentificatiepathologie)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.338']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.338']/hl7:id"
         id="tmp-r-d4009872-2fb6-4b89-9c5d-2e63fa8e37a7">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.338-2014-02-24T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Verslagidentificatiepathologie): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.338-2014-02-24T000000.html"
              test="matches(@extension, '^T\d{2}\d{5}$') or matches(@extension, '^T\d{2}\d{6}$')">(Verslagidentificatiepathologie): Format of T-nummer SHALL be Tjjnnnnn of Tjjnnnnnn</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.338
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.338']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.338']/hl7:code[(@code='11526-1' and @codeSystem='2.16.840.1.113883.6.1')]
Item: (Verslagidentificatiepathologie)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.338']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.338']/hl7:code[(@code='11526-1' and @codeSystem='2.16.840.1.113883.6.1')]"
         id="tmp-r-6d37b0b6-ce82-4347-a14e-5c254e4483b7">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.338-2014-02-24T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Verslagidentificatiepathologie): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.338-2014-02-24T000000.html"
              test="@nullFlavor or (@code='11526-1' and @codeSystem='2.16.840.1.113883.6.1')">(Verslagidentificatiepathologie): de elementwaarde MOET een zijn van 'code '11526-1' codeSystem '2.16.840.1.113883.6.1''.</assert>
   </rule>
</pattern>
