<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.36.10.550
Name: Specimen Macroscopic Observation
Description: Template: Specimen Macroscopic Observation
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000">
   <title>Specimen Macroscopic Observation</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]"
         id="tmp-r-51982f06-f738-41d1-8084-ed0a162d7080">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="count(hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550'])&gt;=1 and not(hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/@nullFlavor)">(SpecimenMacroscopicObservation): element hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="count(hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550'])&lt;=1">(SpecimenMacroscopicObservation): element hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']"
         id="tmp-r-0326e080-89ec-4d81-97be-175d68696b88">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="string(@classCode)=('ACT')">(SpecimenMacroscopicObservation): de waarde van @classCode MOET 'ACT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="string(@moodCode)=('EVN')">(SpecimenMacroscopicObservation): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.550'])&gt;=1 ">(SpecimenMacroscopicObservation): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.550'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.550'])&lt;=1">(SpecimenMacroscopicObservation): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.550'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="count(hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')])&gt;=1 and not(hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')]/@nullFlavor)">(SpecimenMacroscopicObservation): element hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="count(hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')])&lt;=1">(SpecimenMacroscopicObservation): element hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="count(hl7:statusCode)&lt;=1">(SpecimenMacroscopicObservation): element hl7:statusCode komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="count(hl7:specimen)&gt;=1 and not(hl7:specimen/@nullFlavor)">(SpecimenMacroscopicObservation): element hl7:specimen is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="count(hl7:specimen)&lt;=1">(SpecimenMacroscopicObservation): element hl7:specimen komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.550']
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.550']"
         id="tmp-r-f945c861-1eae-4506-a30e-ce5514810a45">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimenMacroscopicObservation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="string(@root)=('2.16.840.1.113883.2.4.3.36.10.550')">(SpecimenMacroscopicObservation): de waarde van @root MOET '2.16.840.1.113883.2.4.3.36.10.550' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')]
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')]"
         id="tmp-r-018e1065-31f9-466f-bf45-5f812b4536e5">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimenMacroscopicObservation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="@nullFlavor or (@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')">(SpecimenMacroscopicObservation): de elementwaarde MOET een zijn van 'code 'X-LAB-SPMSCT' codeSystem '2.16.840.1.113883.6.1''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:statusCode
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:statusCode"
         id="tmp-r-5dce65c4-3d58-4256-813f-aa4628e609e8">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimenMacroscopicObservation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="@nullFlavor or (@code='completed')">(SpecimenMacroscopicObservation): de elementwaarde MOET een zijn van 'code 'completed''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen"
         id="tmp-r-fad635b9-1926-42e6-ae90-527caa86e642">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="string(@typeCode)=('SPC')">(SpecimenMacroscopicObservation): de waarde van @typeCode MOET 'SPC' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="count(hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]])&gt;=1 and not(hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/@nullFlavor)">(SpecimenMacroscopicObservation): element hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="count(hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]])&lt;=1">(SpecimenMacroscopicObservation): element hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]"
         id="tmp-r-fbf0c626-a592-400c-bc4b-cb720a63aa35">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="string(@classCode)=('SPEC')">(SpecimenMacroscopicObservation): de waarde van @classCode MOET 'SPEC' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="count(hl7:id)&gt;=1 and not(hl7:id/@nullFlavor)">(SpecimenMacroscopicObservation): element hl7:id is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="count(hl7:id)&lt;=1">(SpecimenMacroscopicObservation): element hl7:id komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="count(hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]])&lt;=1">(SpecimenMacroscopicObservation): element hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='371490004'])&lt;=1">(SpecimenMacroscopicObservation): element lab:subjectOf[lab:observationEvent/lab:code/@code='371490004'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:id
Item: (SpecimenMacroscopicObservation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]"
         id="tmp-r-5c948104-3e8d-4a17-b984-138824382e68">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="string(@classCode)=('ENT')">(SpecimenMacroscopicObservation): de waarde van @classCode MOET 'ENT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(SpecimenMacroscopicObservation): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="count(hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])&gt;=1 and not(hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]/@nullFlavor)">(SpecimenMacroscopicObservation): element hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="count(hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])&lt;=1">(SpecimenMacroscopicObservation): element hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="count(hl7:quantity)&lt;=1">(SpecimenMacroscopicObservation): element hl7:quantity komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="count(lab:asSpecimenInContainer)&lt;=1">(SpecimenMacroscopicObservation): element lab:asSpecimenInContainer komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]"
         id="tmp-r-1c119051-bad1-4dc7-9328-5ceb8d519137">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(SpecimenMacroscopicObservation): de elementwaarde MOET een zijn van 'vs_monstermateriaal Monster materiaal (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(SpecimenMacroscopicObservation): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_monstermateriaal Monster materiaal (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:quantity
Item: (SpecimenMacroscopicObservation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/lab:asSpecimenInContainer
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/lab:asSpecimenInContainer"
         id="tmp-r-dac6db8a-0155-4cb6-8272-fae11ca83812">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="string(@classCode)=('CONT')">(SpecimenMacroscopicObservation): de waarde van @classCode MOET 'CONT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="count(lab:container)&gt;=1 and not(lab:container/@nullFlavor)">(SpecimenMacroscopicObservation): element lab:container is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="count(lab:container)&lt;=1">(SpecimenMacroscopicObservation): element lab:container komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/lab:asSpecimenInContainer/lab:container
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/lab:asSpecimenInContainer/lab:container"
         id="tmp-r-6bbf8976-2bf3-4793-9b09-ece7accfe698">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="string(@classCode)=('CONT')">(SpecimenMacroscopicObservation): de waarde van @classCode MOET 'CONT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(SpecimenMacroscopicObservation): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="count(lab:id)&gt;=1 ">(SpecimenMacroscopicObservation): element lab:id is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="count(lab:id)&lt;=1">(SpecimenMacroscopicObservation): element lab:id komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/lab:asSpecimenInContainer/lab:container/lab:id
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/lab:asSpecimenInContainer/lab:container/lab:id"
         id="tmp-r-c95cd93a-3b34-47df-b8d7-1685f819a2f3">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="@extension">(SpecimenMacroscopicObservation): attribute @extension MOET aanwezig zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="string(@nullFlavor)=('UNC')">(SpecimenMacroscopicObservation): de waarde van @nullFlavor MOET 'UNC' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:productOf
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:productOf"
         id="tmp-r-bc423ae0-4cba-42bb-8573-536a9e164c7b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="string(@typeCode)=('PRD')">(SpecimenMacroscopicObservation): de waarde van @typeCode MOET 'PRD' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:productOf/lab:specimenCollectionProcess
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:productOf/lab:specimenCollectionProcess"
         id="tmp-r-c74be348-2c27-41cb-8731-768a9cea083b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="string(@classCode)=('SPECCOLLECT')">(SpecimenMacroscopicObservation): de waarde van @classCode MOET 'SPECCOLLECT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="string(@moodCode)=('EVN')">(SpecimenMacroscopicObservation): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="count(lab:code)&lt;=1">(SpecimenMacroscopicObservation): element lab:code komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="count(lab:effectiveTime)&lt;=1">(SpecimenMacroscopicObservation): element lab:effectiveTime komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="count(lab:targetSiteCode)&lt;=1">(SpecimenMacroscopicObservation): element lab:targetSiteCode komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:productOf/lab:specimenCollectionProcess/lab:code
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:productOf/lab:specimenCollectionProcess/lab:code"
         id="tmp-r-e314fe3d-6bfd-49bb-9448-530f5d1ba0d9">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimenMacroscopicObservation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.13-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(SpecimenMacroscopicObservation): de elementwaarde MOET een zijn van 'vs_verkrijgingswijze Verkrijgingswijze (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.13-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(SpecimenMacroscopicObservation): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_verkrijgingswijze Verkrijgingswijze (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:productOf/lab:specimenCollectionProcess/lab:effectiveTime
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:productOf/lab:specimenCollectionProcess/lab:effectiveTime"
         id="tmp-r-a613976d-c1bb-4d0f-ab2e-187aab775c10">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimenMacroscopicObservation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TS.DATE.MIN"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:productOf/lab:specimenCollectionProcess/lab:targetSiteCode
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:productOf/lab:specimenCollectionProcess/lab:targetSiteCode"
         id="tmp-r-f5171b13-cf6e-4f57-a273-3e0480baa54b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimenMacroscopicObservation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.23-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(SpecimenMacroscopicObservation): de elementwaarde MOET een zijn van 'vs_lokalisatie Lokalisatie laesie bij coloscopie (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.23-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(SpecimenMacroscopicObservation): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_lokalisatie Lokalisatie laesie bij coloscopie (DYNAMISCH).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']
Item: (SpecimenMacroscopicObservation)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']">
      <extends rule="tmp-r-2ae6a5f7-632b-4cdb-b90c-f501e9f9d9d4"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2014-02-24T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimenMacroscopicObservation): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900120
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']
Item: (Distanceoftumorfromanalverge)
-->
   <rule id="tmp-r-2ae6a5f7-632b-4cdb-b90c-f501e9f9d9d4" abstract="true">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="count(lab:observationEvent)&gt;=1 and not(lab:observationEvent/@nullFlavor)">(Distanceoftumorfromanalverge): element lab:observationEvent is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="count(lab:observationEvent)&lt;=1">(Distanceoftumorfromanalverge): element lab:observationEvent komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900120
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent
Item: (Distanceoftumorfromanalverge)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="string(@classCode)=('SPCOBS')">(Distanceoftumorfromanalverge): de waarde van @classCode MOET 'SPCOBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="string(@moodCode)=('EVN')">(Distanceoftumorfromanalverge): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="count(lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Distanceoftumorfromanalverge): element lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="count(lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Distanceoftumorfromanalverge): element lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="count(lab:value)&gt;=1 ">(Distanceoftumorfromanalverge): element lab:value is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="count(lab:value)&lt;=1">(Distanceoftumorfromanalverge): element lab:value komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900120
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent/lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Distanceoftumorfromanalverge)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent/lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Distanceoftumorfromanalverge): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="@nullFlavor or (@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')">(Distanceoftumorfromanalverge): de elementwaarde MOET een zijn van 'code '371490004' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900120
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent/lab:value
Item: (Distanceoftumorfromanalverge)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent/lab:value">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PQ' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Distanceoftumorfromanalverge): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PQ" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="PQ"/>
      <let name="theValue" value="@value"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="(@nullFlavor or (@unit='cm' and number($theValue)&gt;=0 and number($theValue)&lt;=200))">(Distanceoftumorfromanalverge): value MOET eenheid 'cm' gebruiken en in bereik [0..200] liggen  </assert>
      <let name="digitok"
           value="matches(string(@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="$digitok or @nullFlavor">(Distanceoftumorfromanalverge): @value is geen geldig PQ getal <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(Distanceoftumorfromanalverge): value/@unit (PQ) MOET een geldige UCUM-eenheid zijn (<value-of select="$UCUMtest"/>).</assert>
   </rule>
</pattern>
