<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.36.10.12
Name: Resultaatdocument MDL bevolkingsonderzoek darmkanker
Description: Template voor CDA document resultaten bevolkingsonderzoek darmkanker voor screeningsorganisatie maag-, darm-, levercentrum (transactie T4), versie 2014
                 
                 Nadere toelichtingen mbt Zorgverlener en Zorginstelling in de context ColonIS 
                In de context van ColonIS zijn de volgende zorgverleners relevant: 
                     de uitvoerder van de coloscopie 
                     de autoriseerder van het coloscopieverslag 
                     de patholoog die de biopten analyseert 
                     de autoriseerder van het pathologieverslag. 
                 
                De autoriseerder mag dezelfde zijn als de uitvoerder, maar dat hoeft niet het geval te zijn. Andere betrokken personen worden niet opgenomen. Wanneer bijvoorbeeld het coloscopieverslag wordt gedicteerd en door een andere persoon ingevoerd, is nog steeds alleen de uitvoerder van de coloscopie van belang.
                 
                Er zijn drie soorten organisati
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000">
   <title>Resultaatdocument MDL bevolkingsonderzoek darmkanker</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.12
Context: /
Item: (nspbcmdl2014b)
-->

   <rule context="/" id="tmp-r-2c02fe7e-4776-4259-84ac-f78c90f0f28a">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1'])&gt;=1 ">(nspbcmdl2014b): element hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1'])&lt;=1">(nspbcmdl2014b): element hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.12
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']
Item: (nspbcmdl2014b)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']"
         id="tmp-r-34205b5b-1653-4279-88e7-86f1dc804b52">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:realmCode[@code='NL'])&gt;=1 and not(hl7:realmCode[@code='NL']/@nullFlavor)">(nspbcmdl2014b): element hl7:realmCode[@code='NL'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:realmCode[@code='NL'])&lt;=1">(nspbcmdl2014b): element hl7:realmCode[@code='NL'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:typeId[@root='2.16.840.1.113883.1.3'])&gt;=1 and not(hl7:typeId[@root='2.16.840.1.113883.1.3']/@nullFlavor)">(nspbcmdl2014b): element hl7:typeId[@root='2.16.840.1.113883.1.3'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:typeId[@root='2.16.840.1.113883.1.3'])&lt;=1">(nspbcmdl2014b): element hl7:typeId[@root='2.16.840.1.113883.1.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.12'])&gt;=1 and not(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.12']/@nullFlavor)">(nspbcmdl2014b): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.12'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.12'])&lt;=1">(nspbcmdl2014b): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.12'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1'])&gt;=1 and not(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1']/@nullFlavor)">(nspbcmdl2014b): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1'])&lt;=1">(nspbcmdl2014b): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:id)&gt;=1 and not(hl7:id/@nullFlavor)">(nspbcmdl2014b): element hl7:id is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:id)&lt;=1">(nspbcmdl2014b): element hl7:id komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')])&gt;=1 and not(hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]/@nullFlavor)">(nspbcmdl2014b): element hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')])&lt;=1">(nspbcmdl2014b): element hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:title)&lt;=1">(nspbcmdl2014b): element hl7:title komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:effectiveTime)&gt;=1 and not(hl7:effectiveTime/@nullFlavor)">(nspbcmdl2014b): element hl7:effectiveTime is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:effectiveTime)&lt;=1">(nspbcmdl2014b): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])&gt;=1 and not(hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]/@nullFlavor)">(nspbcmdl2014b): element hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])&lt;=1">(nspbcmdl2014b): element hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:languageCode)&gt;=1 and not(hl7:languageCode/@nullFlavor)">(nspbcmdl2014b): element hl7:languageCode is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:languageCode)&lt;=1">(nspbcmdl2014b): element hl7:languageCode komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:setId)&gt;=1 and not(hl7:setId/@nullFlavor)">(nspbcmdl2014b): element hl7:setId is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:setId)&lt;=1">(nspbcmdl2014b): element hl7:setId komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:versionNumber)&gt;=1 and not(hl7:versionNumber/@nullFlavor)">(nspbcmdl2014b): element hl7:versionNumber is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:versionNumber)&lt;=1">(nspbcmdl2014b): element hl7:versionNumber komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:recordTarget)&gt;=1 and not(hl7:recordTarget/@nullFlavor)">(nspbcmdl2014b): element hl7:recordTarget is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:recordTarget)&lt;=1">(nspbcmdl2014b): element hl7:recordTarget komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100'])&gt;=1 and not(hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100']/@nullFlavor)">(nspbcmdl2014b): element hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100'])&lt;=1">(nspbcmdl2014b): element hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:custodian)&gt;=1 and not(hl7:custodian/@nullFlavor)">(nspbcmdl2014b): element hl7:custodian is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:custodian)&lt;=1">(nspbcmdl2014b): element hl7:custodian komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:legalAuthenticator)&gt;=1 ">(nspbcmdl2014b): element hl7:legalAuthenticator is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:legalAuthenticator)&lt;=1">(nspbcmdl2014b): element hl7:legalAuthenticator komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:participant)&lt;=1">(nspbcmdl2014b): element hl7:participant komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900800
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:realmCode[@code='NL']
Item: (CDArealmCode)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:realmCode[@code='NL']"
         id="tmp-r-0e6ab22b-073e-48e5-a0b8-45c76bda0936">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900800-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArealmCode): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900800-2012-07-04T000000.html"
              test="@nullFlavor or (@code='NL')">(CDArealmCode): de elementwaarde MOET een zijn van 'code 'NL''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900801
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:typeId[@root='2.16.840.1.113883.1.3']
Item: (CDAtypeId)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:typeId[@root='2.16.840.1.113883.1.3']"
         id="tmp-r-33d89f29-11d0-415d-9961-24244b28a560">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900801-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAtypeId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900801-2012-07-04T000000.html"
              test="string(@extension)=('POCD_HD000040')">(CDAtypeId): de waarde van @extension MOET 'POCD_HD000040' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900801-2012-07-04T000000.html"
              test="string(@root)=('2.16.840.1.113883.1.3')">(CDAtypeId): de waarde van @root MOET '2.16.840.1.113883.1.3' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.12
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.12']
Item: (nspbcmdl2014b)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.12']"
         id="tmp-r-c542ab34-f7e7-43c6-8376-ef31937a19c5">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(nspbcmdl2014b): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="string(@root)=('2.16.840.1.113883.2.4.3.36.10.12')">(nspbcmdl2014b): de waarde van @root MOET '2.16.840.1.113883.2.4.3.36.10.12' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.12
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1']
Item: (nspbcmdl2014b)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1']"
         id="tmp-r-a48d839f-f261-45bf-b134-ed5c005c2f33">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(nspbcmdl2014b): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="string(@root)=('2.16.840.1.113883.2.4.3.36.10.1')">(nspbcmdl2014b): de waarde van @root MOET '2.16.840.1.113883.2.4.3.36.10.1' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900802
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:id
Item: (CDAid)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:id"
         id="tmp-r-a3977e6d-97dd-4b00-a6bb-3f28b5048303">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900802-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAid): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.12
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]
Item: (nspbcmdl2014b)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]"
         id="tmp-r-cb8c8ede-5500-48e5-bb2c-46551522b485">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(nspbcmdl2014b): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="@nullFlavor or (@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')">(nspbcmdl2014b): de elementwaarde MOET een zijn van 'code '18746-8' codeSystem '2.16.840.1.113883.6.1''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900803
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:title
Item: (CDAtitle)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:title"
         id="tmp-r-bb0916fe-3593-49cf-b607-f4871c8bc31a">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900803-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ST' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAtitle): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="ST"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900804
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:effectiveTime
Item: (CDAeffectiveTime)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:effectiveTime"
         id="tmp-r-bf6ffbd0-2cef-4084-8230-8ee46d90d159">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900804-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAeffectiveTime): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TS.DATETIME.MIN"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900805
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]
Item: (CDAconfidentialityCode)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]"
         id="tmp-r-4534b5af-192f-48f1-8d06-f54cd5c8f638">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900805-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAconfidentialityCode): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900805-2012-07-04T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(CDAconfidentialityCode): de elementwaarde MOET een zijn van 'BasicConfidentialityKind Basic Confidentiality Kind (HL7) (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900805-2012-07-04T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(CDAconfidentialityCode): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst BasicConfidentialityKind Basic Confidentiality Kind (HL7) (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900806
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:languageCode
Item: (CDAlanguageCode)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:languageCode"
         id="tmp-r-60f9b8a2-9b26-4f42-9eb9-19108c5c7825">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900806-2012-03-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAlanguageCode): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CS.LANG"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900807
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:setId
Item: (CDAsetIdversionNumber)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:setId"
         id="tmp-r-035bbe44-1914-43c0-a309-32ae97c1087f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900807-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAsetIdversionNumber): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900807
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:versionNumber
Item: (CDAsetIdversionNumber)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:versionNumber"
         id="tmp-r-85366c02-0a78-46d3-9452-a0d84290f86b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900807-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='INT' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAsetIdversionNumber): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:INT" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="INT.NONNEG"/>
      <let name="theValue" value="@value"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900807-2012-07-04T000000.html"
              test="(@nullFlavor or (number($theValue)&gt;=1))">(CDAsetIdversionNumber): value MOET in bereik [1..] liggen  </assert>
      <let name="digitok" value="matches(string(@value), '^-?[1-9]\d*$|^+?\d*$')"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900807-2012-07-04T000000.html"
              test="$digitok or @nullFlavor">(CDAsetIdversionNumber): @value is geen geldig INT getal <value-of select="@value"/>
      </assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900830
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget
Item: (CDArecordTargetMDL)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget"
         id="tmp-r-8f2cd7a1-533e-443f-a185-b95dbd3c3089">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900830-2014-02-09T000000.html"
              test="string(@typeCode)=('RCT')">(CDArecordTargetMDL): de waarde van @typeCode MOET 'RCT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900830-2014-02-09T000000.html"
              test="count(hl7:patientRole)&gt;=1 and not(hl7:patientRole/@nullFlavor)">(CDArecordTargetMDL): element hl7:patientRole is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900830-2014-02-09T000000.html"
              test="count(hl7:patientRole)&lt;=1">(CDArecordTargetMDL): element hl7:patientRole komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900830
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget/hl7:patientRole
Item: (CDArecordTargetMDL)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget/hl7:patientRole"
         id="tmp-r-2c9c8a1f-d7da-4313-be53-4fba29a26c57">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900830-2014-02-09T000000.html"
              test="string(@classCode)=('PAT')">(CDArecordTargetMDL): de waarde van @classCode MOET 'PAT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900830-2014-02-09T000000.html"
              test="not(hl7:id[not(@root='2.16.840.1.113883.2.4.6.3')]/@extension) or string-length(hl7:id[not(@root='2.16.840.1.113883.2.4.6.3')]/@extension)&gt;0">(CDArecordTargetMDL): Als er een id/@extensie wordt aangegeven mag deze niet leeg zijn</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900830-2014-02-09T000000.html"
              test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.3'])&gt;=1 and not(hl7:id[@root='2.16.840.1.113883.2.4.6.3']/@nullFlavor)">(CDArecordTargetMDL): element hl7:id[@root='2.16.840.1.113883.2.4.6.3'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900830-2014-02-09T000000.html"
              test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.3'])&lt;=1">(CDArecordTargetMDL): element hl7:id[@root='2.16.840.1.113883.2.4.6.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900830-2014-02-09T000000.html"
              test="count(hl7:id[not(@root='2.16.840.1.113883.2.4.6.3')])&gt;=1 ">(CDArecordTargetMDL): element hl7:id[not(@root='2.16.840.1.113883.2.4.6.3')] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900830-2014-02-09T000000.html"
              test="count(hl7:id[not(@root='2.16.840.1.113883.2.4.6.3')])&lt;=1">(CDArecordTargetMDL): element hl7:id[not(@root='2.16.840.1.113883.2.4.6.3')] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900014
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget/hl7:patientRole/hl7:id[@root='2.16.840.1.113883.2.4.6.3']
Item: (BurgerServiceNummer)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget/hl7:patientRole/hl7:id[@root='2.16.840.1.113883.2.4.6.3']"
         id="tmp-r-b6224092-9044-4999-92a3-59aa2b6cf1be">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900014-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(BurgerServiceNummer): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II.NL.BSN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900014-2012-07-04T000000.html"
              test="string(@root)=('2.16.840.1.113883.2.4.6.3')">(BurgerServiceNummer): de waarde van @root MOET '2.16.840.1.113883.2.4.6.3' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900014-2012-07-04T000000.html"
              test="@extension">(BurgerServiceNummer): attribute @extension MOET aanwezig zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900830
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget/hl7:patientRole/hl7:id[not(@root='2.16.840.1.113883.2.4.6.3')]
Item: (CDArecordTargetMDL)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget/hl7:patientRole/hl7:id[not(@root='2.16.840.1.113883.2.4.6.3')]"
         id="tmp-r-2038d30e-215a-4533-ae41-0c016e34042a">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900830-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArecordTargetMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900810
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian
Item: (CDAcustodian)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian"
         id="tmp-r-b8257363-a62b-41ce-ad5b-1f0407667a1f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="string(@typeCode)=('CST')">(CDAcustodian): de waarde van @typeCode MOET 'CST' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="count(hl7:assignedCustodian)&gt;=1 and not(hl7:assignedCustodian/@nullFlavor)">(CDAcustodian): element hl7:assignedCustodian is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="count(hl7:assignedCustodian)&lt;=1">(CDAcustodian): element hl7:assignedCustodian komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900810
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian
Item: (CDAcustodian)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian"
         id="tmp-r-39451dbb-7765-449b-8be1-a1c7e60e6242">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="string(@classCode)=('ASSIGNED')">(CDAcustodian): de waarde van @classCode MOET 'ASSIGNED' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="count(hl7:representedCustodianOrganization)&lt;=1">(CDAcustodian): element hl7:representedCustodianOrganization komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900810
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization
Item: (CDAcustodian)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization"
         id="tmp-r-a8143eaa-ded7-4102-8d36-df61f2c5e98e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="string(@classCode)=('ORG')">(CDAcustodian): de waarde van @classCode MOET 'ORG' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(CDAcustodian): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <let name="elmcount"
           value="count(hl7:id[@root='2.16.528.1.1007.3.3']|hl7:id)"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="$elmcount&gt;=1">(CDAcustodian): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="count(hl7:id[@root='2.16.528.1.1007.3.3'])&lt;=1">(CDAcustodian): element hl7:id[@root='2.16.528.1.1007.3.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor)">(CDAcustodian): element hl7:name is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="count(hl7:name)&lt;=1">(CDAcustodian): element hl7:name komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="count(hl7:addr)&lt;=1">(CDAcustodian): element hl7:addr komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="count(lab:code)&lt;=1">(CDAcustodian): element lab:code komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization
Item: (CDArepresentedOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:id[@root='2.16.528.1.1007.3.3']
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:id[@root='2.16.528.1.1007.3.3']"
         id="tmp-r-703e8f14-9d71-4082-b5c1-7d49f808ddc3">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="string(@root)=('2.16.528.1.1007.3.3')">(CDArepresentedOrganization): de waarde van @root MOET '2.16.528.1.1007.3.3' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:id
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:id"
         id="tmp-r-7898bfe2-fb93-47a8-b331-20f1649bf0a8">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:name
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:name"
         id="tmp-r-54401b09-df12-441f-8975-608a0e1860bb">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="ON"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:addr
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:addr"
         id="tmp-r-292c09c4-6bfc-4468-8c98-cb13d2e2816c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="AD"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:telecom
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:telecom"
         id="tmp-r-62c5884a-7daf-4575-adc9-6db8393c74df">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TEL"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/lab:code
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/lab:code"
         id="tmp-r-8cd4ce05-e130-45fa-a2ef-004e73989a92">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(CDArepresentedOrganization): de elementwaarde MOET een zijn van 'vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(CDArepresentedOrganization): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900811
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient
Item: (CDAinformationRecipient)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient"
         id="tmp-r-41e350ea-100c-486e-8efa-eb13493cdb20">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="@typeCode">(CDAinformationRecipient): attribute @typeCode MOET aanwezig zijn.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),' '))"/>
      <let name="theAttCheck"
           value="distinct-values(for $code in tokenize(@typeCode,' ') return if ($code=('PRCP','TRC')) then ($code) else ())"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="not(@typeCode) or count($theAttValue) = count($theAttCheck)">(CDAinformationRecipient): de waarde van typeCode MOET 'code PRCP of code TRC' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="count(hl7:intendedRecipient)&gt;=1 and not(hl7:intendedRecipient/@nullFlavor)">(CDAinformationRecipient): element hl7:intendedRecipient is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="count(hl7:intendedRecipient)&lt;=1">(CDAinformationRecipient): element hl7:intendedRecipient komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900811
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient
Item: (CDAinformationRecipient)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient"
         id="tmp-r-333acfbc-f984-4bf5-85ab-e03c62cd668e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="string(@classCode)=('ASSIGNED')">(CDAinformationRecipient): de waarde van @classCode MOET 'ASSIGNED' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="count(hl7:informationRecipient)&lt;=1">(CDAinformationRecipient): element hl7:informationRecipient komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="count(hl7:representedOrganization)&lt;=1">(CDAinformationRecipient): element hl7:representedOrganization komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900811
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:id
Item: (CDAinformationRecipient)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:id"
         id="tmp-r-bc06a5d9-dc04-4faf-94c3-afa94977e85d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAinformationRecipient): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900811
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:informationRecipient
Item: (CDAinformationRecipient)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:informationRecipient"
         id="tmp-r-b1a1e56c-b1da-4b3f-80dd-37a1366ecd3a">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="string(@classCode)=('PSN')">(CDAinformationRecipient): de waarde van @classCode MOET 'PSN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(CDAinformationRecipient): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="count(hl7:name)&lt;=1">(CDAinformationRecipient): element hl7:name komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900811
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:informationRecipient/hl7:name
Item: (CDAinformationRecipient)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:informationRecipient/hl7:name"
         id="tmp-r-bc1e6cee-3a8a-449e-90ba-123f51fdfdbe">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAinformationRecipient): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="PN"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900811
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization
Item: (CDAinformationRecipient)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization"
         id="tmp-r-f47b7993-e4c3-46a5-b270-012ec24524cd">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="string(@classCode)=('ORG')">(CDAinformationRecipient): de waarde van @classCode MOET 'ORG' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(CDAinformationRecipient): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <let name="elmcount"
           value="count(hl7:id[@root='2.16.528.1.1007.3.3']|hl7:id)"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="$elmcount&gt;=1">(CDAinformationRecipient): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="count(hl7:id[@root='2.16.528.1.1007.3.3'])&lt;=1">(CDAinformationRecipient): element hl7:id[@root='2.16.528.1.1007.3.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor)">(CDAinformationRecipient): element hl7:name is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="count(hl7:name)&lt;=1">(CDAinformationRecipient): element hl7:name komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="count(hl7:addr)&lt;=1">(CDAinformationRecipient): element hl7:addr komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="count(lab:code)&lt;=1">(CDAinformationRecipient): element lab:code komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization
Item: (CDArepresentedOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:id[@root='2.16.528.1.1007.3.3']
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:id[@root='2.16.528.1.1007.3.3']"
         id="tmp-r-321a1ec0-b1fe-46c8-a4b5-304d32f3c054">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="string(@root)=('2.16.528.1.1007.3.3')">(CDArepresentedOrganization): de waarde van @root MOET '2.16.528.1.1007.3.3' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:id
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:id"
         id="tmp-r-2fa5dc2e-06ff-44e8-a222-f5e2d8e647c1">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:name
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:name"
         id="tmp-r-8938b6de-1d0f-49bd-9e17-20e78557d0f1">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="ON"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:addr
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:addr"
         id="tmp-r-2881c45d-5c54-4496-a143-4e362851e31c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="AD"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:telecom
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:telecom"
         id="tmp-r-381fc9bf-269f-4c06-a087-1570f8ada747">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TEL"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/lab:code
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/lab:code"
         id="tmp-r-344c8ee1-4882-47c0-9422-8a613cf10d6e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(CDArepresentedOrganization): de elementwaarde MOET een zijn van 'vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(CDArepresentedOrganization): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900812
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:authenticator
Item: (CDAauthenticator)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:authenticator"
         id="tmp-r-ea8592d4-5e80-4901-8a8a-5af853308670">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900812-2012-07-04T000000.html"
              test="string(@typeCode)=('AUTHEN')">(CDAauthenticator): de waarde van @typeCode MOET 'AUTHEN' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900813
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator
Item: (CDlegalAuthenticator)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator"
         id="tmp-r-4f1727bd-1f09-452c-821b-88f7bfc27c03">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="string(@typeCode)=('LA')">(CDlegalAuthenticator): de waarde van @typeCode MOET 'LA' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:time)&gt;=1 ">(CDlegalAuthenticator): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:time)&lt;=1">(CDlegalAuthenticator): element hl7:time komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:signatureCode[@code='S'])&gt;=1 and not(hl7:signatureCode[@code='S']/@nullFlavor)">(CDlegalAuthenticator): element hl7:signatureCode[@code='S'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:signatureCode[@code='S'])&lt;=1">(CDlegalAuthenticator): element hl7:signatureCode[@code='S'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:assignedEntity)&gt;=1 and not(hl7:assignedEntity/@nullFlavor)">(CDlegalAuthenticator): element hl7:assignedEntity is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:assignedEntity)&lt;=1">(CDlegalAuthenticator): element hl7:assignedEntity komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900813
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:time
Item: (CDlegalAuthenticator)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:time"
         id="tmp-r-e2b391bc-6812-4cd1-bf18-c9723fe11151">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDlegalAuthenticator): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TS.DATE.MIN"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900813
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:signatureCode[@code='S']
Item: (CDlegalAuthenticator)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:signatureCode[@code='S']"
         id="tmp-r-c2fbdf08-1310-4e0f-b04a-e2400ccece69">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDlegalAuthenticator): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="@nullFlavor or (@code='S')">(CDlegalAuthenticator): de elementwaarde MOET een zijn van 'code 'S''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900813
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity
Item: (CDlegalAuthenticator)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity"
         id="tmp-r-89f4e22a-f9b7-48f7-acc6-fe7ee3c75db9">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="string(@classCode)=('ASSIGNED')">(CDlegalAuthenticator): de waarde van @classCode MOET 'ASSIGNED' zijn.</assert>
      <let name="elmcount"
           value="count(hl7:id[@root='2.16.528.1.1007.3.1']|hl7:id)"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="$elmcount&gt;=1">(CDlegalAuthenticator): keuze (hl7:id[@root='2.16.528.1.1007.3.1'] of hl7:id) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:id[@root='2.16.528.1.1007.3.1'])&lt;=1">(CDlegalAuthenticator): element hl7:id[@root='2.16.528.1.1007.3.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:code)&lt;=1">(CDlegalAuthenticator): element hl7:code komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:assignedPerson)&lt;=1">(CDlegalAuthenticator): element hl7:assignedPerson komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:representedOrganization)&lt;=1">(CDlegalAuthenticator): element hl7:representedOrganization komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900829
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity
Item: (CDAassignedEntityIdentification)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900829
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:id[@root='2.16.528.1.1007.3.1']
Item: (CDAassignedEntityIdentification)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:id[@root='2.16.528.1.1007.3.1']"
         id="tmp-r-b748ce94-9f9b-4e4a-bdf3-4e56a8948de7">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAassignedEntityIdentification): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html"
              test="string(@root)=('2.16.528.1.1007.3.1')">(CDAassignedEntityIdentification): de waarde van @root MOET '2.16.528.1.1007.3.1' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900829
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:id
Item: (CDAassignedEntityIdentification)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:id"
         id="tmp-r-459b4566-7f00-4f3d-80fd-0059525b2ca3">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAassignedEntityIdentification): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900813
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:code
Item: (CDlegalAuthenticator)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:code"
         id="tmp-r-4ad8f372-e7ce-4b56-850a-01c6245d8f47">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDlegalAuthenticator): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(CDlegalAuthenticator): de elementwaarde MOET een zijn van 'vs_typerol Medische rollen (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(CDlegalAuthenticator): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_typerol Medische rollen (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900813
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:assignedPerson
Item: (CDlegalAuthenticator)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:assignedPerson"
         id="tmp-r-f7bb9ee4-6ae9-42c3-96fe-c935cb53429f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="string(@classCode)=('PSN')">(CDlegalAuthenticator): de waarde van @classCode MOET 'PSN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(CDlegalAuthenticator): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor)">(CDlegalAuthenticator): element hl7:name is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:name)&lt;=1">(CDlegalAuthenticator): element hl7:name komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900813
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDlegalAuthenticator)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:assignedPerson/hl7:name"
         id="tmp-r-5c53294f-013a-4a9d-966f-c49e791353e2">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDlegalAuthenticator): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="PN"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900813
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization
Item: (CDlegalAuthenticator)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization"
         id="tmp-r-5959c652-cd6b-49da-879d-001d6b196d30">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="string(@classCode)=('ORG')">(CDlegalAuthenticator): de waarde van @classCode MOET 'ORG' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(CDlegalAuthenticator): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <let name="elmcount"
           value="count(hl7:id[@root='2.16.528.1.1007.3.3']|hl7:id)"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="$elmcount&gt;=1">(CDlegalAuthenticator): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:id[@root='2.16.528.1.1007.3.3'])&lt;=1">(CDlegalAuthenticator): element hl7:id[@root='2.16.528.1.1007.3.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor)">(CDlegalAuthenticator): element hl7:name is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:name)&lt;=1">(CDlegalAuthenticator): element hl7:name komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(hl7:addr)&lt;=1">(CDlegalAuthenticator): element hl7:addr komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="count(lab:code)&lt;=1">(CDlegalAuthenticator): element lab:code komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization
Item: (CDArepresentedOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:id[@root='2.16.528.1.1007.3.3']
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:id[@root='2.16.528.1.1007.3.3']"
         id="tmp-r-1bd9b915-9f61-4450-8bbf-030ae1a75333">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="string(@root)=('2.16.528.1.1007.3.3')">(CDArepresentedOrganization): de waarde van @root MOET '2.16.528.1.1007.3.3' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:id
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:id"
         id="tmp-r-c6fdb5d9-794a-4488-937d-214bc9c0eb3b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:name
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:name"
         id="tmp-r-49833009-09a6-4915-a315-e867b96feb38">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="ON"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:addr
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:addr"
         id="tmp-r-7f652ac7-8311-4e09-a222-c6a6625f833b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="AD"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:telecom
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:telecom"
         id="tmp-r-0122e53b-657a-415e-b423-5e25bde7e70c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TEL"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/lab:code
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/lab:code"
         id="tmp-r-58903b81-ce02-404a-96fd-2dbbc3f30ce2">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(CDArepresentedOrganization): de elementwaarde MOET een zijn van 'vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(CDArepresentedOrganization): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900817
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant
Item: (CDAParticipantVerifier)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant"
         id="tmp-r-d0bbcf96-1874-4cfb-b458-fb53f78a04aa">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="string(@typeCode)=('VRF')">(CDAParticipantVerifier): de waarde van @typeCode MOET 'VRF' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="count(hl7:time)&lt;=1">(CDAParticipantVerifier): element hl7:time komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="count(hl7:associatedEntity)&gt;=1 and not(hl7:associatedEntity/@nullFlavor)">(CDAParticipantVerifier): element hl7:associatedEntity is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="count(hl7:associatedEntity)&lt;=1">(CDAParticipantVerifier): element hl7:associatedEntity komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900817
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:time
Item: (CDAParticipantVerifier)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:time"
         id="tmp-r-8834bc57-3581-4627-941a-cb0bd9dd3e33">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantVerifier): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TS.DATE.MIN"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900817
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity
Item: (CDAParticipantVerifier)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity"
         id="tmp-r-0421cc58-2bb8-4b4a-a3a5-9992f3bd8668">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="string(@classCode)=('ASSIGNED')">(CDAParticipantVerifier): de waarde van @classCode MOET 'ASSIGNED' zijn.</assert>
      <let name="elmcount"
           value="count(hl7:id[@root='2.16.528.1.1007.3.1']|hl7:id)"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="$elmcount&gt;=1">(CDAParticipantVerifier): keuze (hl7:id[@root='2.16.528.1.1007.3.1'] of hl7:id) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="count(hl7:id[@root='2.16.528.1.1007.3.1'])&lt;=1">(CDAParticipantVerifier): element hl7:id[@root='2.16.528.1.1007.3.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="count(hl7:code)&lt;=1">(CDAParticipantVerifier): element hl7:code komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="count(hl7:associatedPerson)&lt;=1">(CDAParticipantVerifier): element hl7:associatedPerson komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="count(hl7:scopingOrganization)&lt;=1">(CDAParticipantVerifier): element hl7:scopingOrganization komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900829
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity
Item: (CDAassignedEntityIdentification)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900829
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:id[@root='2.16.528.1.1007.3.1']
Item: (CDAassignedEntityIdentification)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:id[@root='2.16.528.1.1007.3.1']"
         id="tmp-r-ce8cf41b-d819-46a2-8e4b-f1907d512519">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAassignedEntityIdentification): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html"
              test="string(@root)=('2.16.528.1.1007.3.1')">(CDAassignedEntityIdentification): de waarde van @root MOET '2.16.528.1.1007.3.1' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900829
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:id
Item: (CDAassignedEntityIdentification)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:id"
         id="tmp-r-8a554ed1-c676-44b0-8f14-42e875c161e8">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAassignedEntityIdentification): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900817
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:code
Item: (CDAParticipantVerifier)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:code"
         id="tmp-r-d31cb300-e1c8-4ad7-865f-46108ab26fb0">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantVerifier): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(CDAParticipantVerifier): de elementwaarde MOET een zijn van 'vs_typerol Medische rollen (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(CDAParticipantVerifier): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_typerol Medische rollen (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900817
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:associatedPerson
Item: (CDAParticipantVerifier)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:associatedPerson"
         id="tmp-r-5908aa8d-2937-40bb-b051-418bbd612226">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="string(@classCode)=('PSN')">(CDAParticipantVerifier): de waarde van @classCode MOET 'PSN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(CDAParticipantVerifier): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor)">(CDAParticipantVerifier): element hl7:name is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="count(hl7:name)&lt;=1">(CDAParticipantVerifier): element hl7:name komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900817
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:associatedPerson/hl7:name
Item: (CDAParticipantVerifier)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:associatedPerson/hl7:name"
         id="tmp-r-b3a3d912-4032-4987-b25c-2bc6469f1ebf">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantVerifier): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="PN"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900817
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization
Item: (CDAParticipantVerifier)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization"
         id="tmp-r-0d823ccf-3cc8-4d69-b39f-d93efca0894a">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="string(@classCode)=('ORG')">(CDAParticipantVerifier): de waarde van @classCode MOET 'ORG' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(CDAParticipantVerifier): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <let name="elmcount"
           value="count(hl7:id[@root='2.16.528.1.1007.3.3']|hl7:id)"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="$elmcount&gt;=1">(CDAParticipantVerifier): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="count(hl7:id[@root='2.16.528.1.1007.3.3'])&lt;=1">(CDAParticipantVerifier): element hl7:id[@root='2.16.528.1.1007.3.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor)">(CDAParticipantVerifier): element hl7:name is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="count(hl7:name)&lt;=1">(CDAParticipantVerifier): element hl7:name komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="count(hl7:addr)&lt;=1">(CDAParticipantVerifier): element hl7:addr komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="count(lab:code)&lt;=1">(CDAParticipantVerifier): element lab:code komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization
Item: (CDArepresentedOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/hl7:id[@root='2.16.528.1.1007.3.3']
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/hl7:id[@root='2.16.528.1.1007.3.3']"
         id="tmp-r-ef2b36cd-a38c-439a-86a6-5bad747f4390">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="string(@root)=('2.16.528.1.1007.3.3')">(CDArepresentedOrganization): de waarde van @root MOET '2.16.528.1.1007.3.3' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/hl7:id
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/hl7:id"
         id="tmp-r-4f5522ef-92c3-4328-ad89-38172f2c2bf7">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/hl7:name
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/hl7:name"
         id="tmp-r-a70d647f-ecca-4f94-ac91-0d45296909c9">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="ON"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/hl7:addr
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/hl7:addr"
         id="tmp-r-61a11efb-ed50-4d33-920c-772be986e298">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="AD"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/hl7:telecom
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/hl7:telecom"
         id="tmp-r-c6d9ca04-8ea7-4636-ba6b-c773b4c69c7e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TEL"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/lab:code
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/lab:code"
         id="tmp-r-696df37e-fee3-4de9-a066-05201185ee45">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(CDArepresentedOrganization): de elementwaarde MOET een zijn van 'vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(CDArepresentedOrganization): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900814
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:relatedDocument
Item: (CDArelatedDocument)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:relatedDocument"
         id="tmp-r-1455c7f5-9c88-47d1-9ebb-f1523691533b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900814-2012-07-04T000000.html"
              test="string(@typeCode)=('RPLC')">(CDArelatedDocument): de waarde van @typeCode MOET 'RPLC' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900815
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]
Item: (CDAdocumentationOfMDL)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]"
         id="tmp-r-394a4501-903e-41dc-8aa4-bff3d1aae0c3">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="string(@typeCode)=('DOC')">(CDAdocumentationOfMDL): de waarde van @typeCode MOET 'DOC' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="count(hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]])&gt;=1 and not(hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/@nullFlavor)">(CDAdocumentationOfMDL): element hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="count(hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]])&lt;=1">(CDAdocumentationOfMDL): element hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900815
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]
Item: (CDAdocumentationOfMDL)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]"
         id="tmp-r-f3b6ff1b-047e-4f91-80d0-b708e5c8312f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="string(@classCode)=('OBS')">(CDAdocumentationOfMDL): de waarde van @classCode MOET 'OBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="string(@moodCode)=('EVN')">(CDAdocumentationOfMDL): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="count(hl7:id)&gt;=1 ">(CDAdocumentationOfMDL): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="count(hl7:id)&lt;=1">(CDAdocumentationOfMDL): element hl7:id komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="count(hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')])&gt;=1 and not(hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]/@nullFlavor)">(CDAdocumentationOfMDL): element hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="count(hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')])&lt;=1">(CDAdocumentationOfMDL): element hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="count(lab:statusCode[@code='completed'])&gt;=1 and not(lab:statusCode[@code='completed']/@nullFlavor)">(CDAdocumentationOfMDL): element lab:statusCode[@code='completed'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="count(lab:statusCode[@code='completed'])&lt;=1">(CDAdocumentationOfMDL): element lab:statusCode[@code='completed'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="count(hl7:effectiveTime)&gt;=1 ">(CDAdocumentationOfMDL): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="count(hl7:effectiveTime)&lt;=1">(CDAdocumentationOfMDL): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="count(hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]])&gt;=1 ">(CDAdocumentationOfMDL): element hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="count(hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]])&lt;=1">(CDAdocumentationOfMDL): element hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900815
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:id
Item: (CDAdocumentationOfMDL)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:id"
         id="tmp-r-c9d0dd4b-1f9c-49b5-b399-6e31ae4793eb">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAdocumentationOfMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900815
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]
Item: (CDAdocumentationOfMDL)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]"
         id="tmp-r-2e4b12dc-4f87-4f0e-b330-d1129be13090">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAdocumentationOfMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="@nullFlavor or (@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')">(CDAdocumentationOfMDL): de elementwaarde MOET een zijn van 'code '18746-8' codeSystem '2.16.840.1.113883.6.1''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900815
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/lab:statusCode[@code='completed']
Item: (CDAdocumentationOfMDL)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/lab:statusCode[@code='completed']"
         id="tmp-r-80586ffd-fd0e-4757-bb42-ba5800bfa965">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAdocumentationOfMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="@nullFlavor or (@code='completed')">(CDAdocumentationOfMDL): de elementwaarde MOET een zijn van 'code 'completed''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900815
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:effectiveTime
Item: (CDAdocumentationOfMDL)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:effectiveTime"
         id="tmp-r-5caa1293-3fbb-4946-80ae-6fcc657090a0">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAdocumentationOfMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="count(hl7:low)&gt;=1 ">(CDAdocumentationOfMDL): element hl7:low is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="count(hl7:low)&lt;=1">(CDAdocumentationOfMDL): element hl7:low komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900005
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:effectiveTime/hl7:low
Item: (StartServiceDate)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:effectiveTime/hl7:low"
         id="tmp-r-9b651ad7-6500-4aec-8e15-184a533c895b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900005-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(StartServiceDate): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TS"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900815
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]
Item: (CDAdocumentationOfMDL)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]"
         id="tmp-r-6e01c2e7-7fb3-456e-a5d9-9ece8037b408">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="string(@typeCode)=('PRF')">(CDAdocumentationOfMDL): de waarde van @typeCode MOET 'PRF' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="count(hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]])&gt;=1 ">(CDAdocumentationOfMDL): element hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="count(hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]])&lt;=1">(CDAdocumentationOfMDL): element hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900815
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]
Item: (CDAdocumentationOfMDL)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]"
         id="tmp-r-e2134cef-6aca-4c83-b63b-cd9cd9dbd3c7">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="string(@classCode)=('ASSIGNED')">(CDAdocumentationOfMDL): de waarde van @classCode MOET 'ASSIGNED' zijn.</assert>
      <let name="elmcount"
           value="count(hl7:id[@root='2.16.528.1.1007.3.1']|hl7:id)"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="$elmcount&gt;=1">(CDAdocumentationOfMDL): keuze (hl7:id[@root='2.16.528.1.1007.3.1'] of hl7:id) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="count(hl7:id[@root='2.16.528.1.1007.3.1'])&lt;=1">(CDAdocumentationOfMDL): element hl7:id[@root='2.16.528.1.1007.3.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="count(hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])&gt;=1 ">(CDAdocumentationOfMDL): element hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="count(hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])&lt;=1">(CDAdocumentationOfMDL): element hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="count(hl7:assignedPerson)&gt;=1 ">(CDAdocumentationOfMDL): element hl7:assignedPerson is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="count(hl7:assignedPerson)&lt;=1">(CDAdocumentationOfMDL): element hl7:assignedPerson komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="count(hl7:representedOrganization)&gt;=1 ">(CDAdocumentationOfMDL): element hl7:representedOrganization is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="count(hl7:representedOrganization)&lt;=1">(CDAdocumentationOfMDL): element hl7:representedOrganization komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900829
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]
Item: (CDAassignedEntityIdentification)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900829
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:id[@root='2.16.528.1.1007.3.1']
Item: (CDAassignedEntityIdentification)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:id[@root='2.16.528.1.1007.3.1']"
         id="tmp-r-320f06c0-7d65-4daa-b4f1-4a1f5f1b1dc9">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAassignedEntityIdentification): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html"
              test="string(@root)=('2.16.528.1.1007.3.1')">(CDAassignedEntityIdentification): de waarde van @root MOET '2.16.528.1.1007.3.1' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900829
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:id
Item: (CDAassignedEntityIdentification)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:id"
         id="tmp-r-38acbab4-33bc-405d-900f-56e427a7bfbb">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAassignedEntityIdentification): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900815
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]
Item: (CDAdocumentationOfMDL)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]"
         id="tmp-r-102624af-32cc-4bd4-a691-4a4eb1833e7c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAdocumentationOfMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(CDAdocumentationOfMDL): de elementwaarde MOET een zijn van 'vs_typerol Medische rollen (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(CDAdocumentationOfMDL): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_typerol Medische rollen (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900815
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:addr
Item: (CDAdocumentationOfMDL)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:addr"
         id="tmp-r-a110651f-1c9f-4151-a954-d6c34a3e39a4">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAdocumentationOfMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="AD"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900815
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:telecom
Item: (CDAdocumentationOfMDL)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:telecom"
         id="tmp-r-b48024d3-756b-4f69-a5bc-bf8b8dd37a94">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAdocumentationOfMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TEL"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900815
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:assignedPerson
Item: (CDAdocumentationOfMDL)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:assignedPerson"
         id="tmp-r-5106efb6-e258-4b5f-9927-23196b309ed6">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="string(@classCode)=('PSN')">(CDAdocumentationOfMDL): de waarde van @classCode MOET 'PSN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(CDAdocumentationOfMDL): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="count(hl7:name)&gt;=1 ">(CDAdocumentationOfMDL): element hl7:name is required [min 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900815
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:assignedPerson/hl7:name
Item: (CDAdocumentationOfMDL)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:assignedPerson/hl7:name"
         id="tmp-r-5d47e788-9fab-489d-91cd-81efa913d5b6">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAdocumentationOfMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="PN"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900815
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization
Item: (CDAdocumentationOfMDL)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization"
         id="tmp-r-bf529760-826b-4cc3-a697-fe8da42a463e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="string(@classCode)=('ORG')">(CDAdocumentationOfMDL): de waarde van @classCode MOET 'ORG' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(CDAdocumentationOfMDL): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <let name="elmcount"
           value="count(hl7:id[@root='2.16.528.1.1007.3.3']|hl7:id)"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="$elmcount&gt;=1">(CDAdocumentationOfMDL): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="count(hl7:id[@root='2.16.528.1.1007.3.3'])&lt;=1">(CDAdocumentationOfMDL): element hl7:id[@root='2.16.528.1.1007.3.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor)">(CDAdocumentationOfMDL): element hl7:name is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="count(hl7:name)&lt;=1">(CDAdocumentationOfMDL): element hl7:name komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="count(hl7:addr)&lt;=1">(CDAdocumentationOfMDL): element hl7:addr komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="count(lab:code)&lt;=1">(CDAdocumentationOfMDL): element lab:code komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization
Item: (CDArepresentedOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:id[@root='2.16.528.1.1007.3.3']
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:id[@root='2.16.528.1.1007.3.3']"
         id="tmp-r-a8b345aa-0891-4020-a617-8603b56845fb">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="string(@root)=('2.16.528.1.1007.3.3')">(CDArepresentedOrganization): de waarde van @root MOET '2.16.528.1.1007.3.3' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:id
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:id"
         id="tmp-r-2c848672-38bf-4139-9f99-2bab1ca36a08">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:name
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:name"
         id="tmp-r-85c67429-608a-4bd7-b159-e6b3ac178e68">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="ON"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:addr
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:addr"
         id="tmp-r-5bea4547-ef5c-4109-bcae-48cd3b7964a4">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="AD"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:telecom
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:telecom"
         id="tmp-r-8785fbad-7c01-4508-b367-00600ea3c6be">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TEL"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900809
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/lab:code
Item: (CDArepresentedOrganization)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/lab:code"
         id="tmp-r-1b227f14-1802-4b70-9f8c-68b06939da17">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(CDArepresentedOrganization): de elementwaarde MOET een zijn van 'vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(CDArepresentedOrganization): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.12
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component
Item: (nspbcmdl2014b)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component"
         id="tmp-r-3c2db82b-ffd1-4972-804a-2036dca35f1e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="string(@typeCode)=('COMP')">(nspbcmdl2014b): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="string(@contextConductionInd)=('true')">(nspbcmdl2014b): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.12
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody
Item: (nspbcmdl2014b)
-->

   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody"
         id="tmp-r-ff90b226-98fa-489e-a14f-08e61e9d2b53">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="string(@classCode)=('DOCBODY')">(nspbcmdl2014b): de waarde van @classCode MOET 'DOCBODY' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="string(@moodCode)=('EVN')">(nspbcmdl2014b): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.201']])&lt;=1">(nspbcmdl2014b): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.201']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']])&gt;=1 and not(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']]/@nullFlavor)">(nspbcmdl2014b): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']])&lt;=1">(nspbcmdl2014b): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']])&gt;=1 and not(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/@nullFlavor)">(nspbcmdl2014b): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']])&lt;=1">(nspbcmdl2014b): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']])&gt;=1 and not(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/@nullFlavor)">(nspbcmdl2014b): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']])&lt;=1">(nspbcmdl2014b): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']])&gt;=1 and not(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/@nullFlavor)">(nspbcmdl2014b): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']])&lt;=1">(nspbcmdl2014b): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']])&gt;=1 and not(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]/@nullFlavor)">(nspbcmdl2014b): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']])&lt;=1">(nspbcmdl2014b): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']])&gt;=1 and not(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']]/@nullFlavor)">(nspbcmdl2014b): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']])&lt;=1">(nspbcmdl2014b): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.12
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.201']]
Item: (nspbcmdl2014b)
-->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.201']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="string(@typeCode)=('COMP')">(nspbcmdl2014b): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="string(@contextConductionInd)=('true')">(nspbcmdl2014b): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.12
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']]
Item: (nspbcmdl2014b)
-->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="string(@typeCode)=('COMP')">(nspbcmdl2014b): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="string(@contextConductionInd)=('true')">(nspbcmdl2014b): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.12
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]
Item: (nspbcmdl2014b)
-->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="string(@typeCode)=('COMP')">(nspbcmdl2014b): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="string(@contextConductionInd)=('true')">(nspbcmdl2014b): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.12
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]
Item: (nspbcmdl2014b)
-->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="string(@typeCode)=('COMP')">(nspbcmdl2014b): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="string(@contextConductionInd)=('true')">(nspbcmdl2014b): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.12
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]
Item: (nspbcmdl2014b)
-->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="string(@typeCode)=('COMP')">(nspbcmdl2014b): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="string(@contextConductionInd)=('true')">(nspbcmdl2014b): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.12
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]
Item: (nspbcmdl2014b)
-->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="string(@typeCode)=('COMP')">(nspbcmdl2014b): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="string(@contextConductionInd)=('true')">(nspbcmdl2014b): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.12
Context: /hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']]
Item: (nspbcmdl2014b)
-->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="string(@typeCode)=('COMP')">(nspbcmdl2014b): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="string(@contextConductionInd)=('true')">(nspbcmdl2014b): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/*[not(self::hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1'])]"
         id="tmp-r-7617f3ac-aa8a-4909-b2e9-99ab59a4c344">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-7617f3ac-aa8a-4909-b2e9-99ab59a4c344)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/*[not(self::hl7:realmCode[@code='NL']|self::hl7:typeId[@root='2.16.840.1.113883.1.3']|self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.12']|self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1']|self::hl7:id|self::hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:title|self::hl7:effectiveTime|self::hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]|self::hl7:languageCode|self::hl7:setId|self::hl7:versionNumber|self::hl7:recordTarget|self::hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100']|self::hl7:custodian|self::hl7:informationRecipient|self::hl7:authenticator|self::hl7:legalAuthenticator|self::hl7:participant|self::hl7:relatedDocument|self::hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]|self::hl7:component)]"
         id="tmp-r-05507739-c06f-4190-9d2e-1dc4d891f2bf">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-05507739-c06f-4190-9d2e-1dc4d891f2bf)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget/*[not(self::hl7:patientRole)]"
         id="tmp-r-85b1a447-6d15-4445-ae05-644e0f3c49b2">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900830-2014-02-09T000000.html"
              test="not(.)">(CDArecordTargetMDL): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-85b1a447-6d15-4445-ae05-644e0f3c49b2)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget/hl7:patientRole/*[not(self::hl7:id[@root='2.16.840.1.113883.2.4.6.3']|self::hl7:id[not(@root='2.16.840.1.113883.2.4.6.3')])]"
         id="tmp-r-8b804858-7fcb-4ccb-9c6d-c397db6aa304">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900830-2014-02-09T000000.html"
              test="not(.)">(CDArecordTargetMDL): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-8b804858-7fcb-4ccb-9c6d-c397db6aa304)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.100']|self::hl7:time|self::hl7:assignedAuthor)]"
         id="tmp-r-07e40bdb-5e35-43fe-a9af-819fbcff4492">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.100-2012-07-04T000000.html"
              test="not(.)">(CDAauthor): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-07e40bdb-5e35-43fe-a9af-819fbcff4492)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100']/hl7:assignedAuthor/*[not(self::hl7:id[@root='2.16.528.1.1007.3.1']|self::hl7:id|self::hl7:code|self::hl7:assignedPerson|self::hl7:representedOrganization)]"
         id="tmp-r-24f76933-d9c4-4723-97d2-2b7fe72f3dd7">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.100-2012-07-04T000000.html"
              test="not(.)">(CDAauthor): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-24f76933-d9c4-4723-97d2-2b7fe72f3dd7)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100']/hl7:assignedAuthor/hl7:assignedPerson/*[not(self::hl7:name)]"
         id="tmp-r-3f914a51-ad78-4332-92d9-bad6ba9d39e6">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.100-2012-07-04T000000.html"
              test="not(.)">(CDAauthor): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-3f914a51-ad78-4332-92d9-bad6ba9d39e6)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100']/hl7:assignedAuthor/hl7:representedOrganization/*[not(self::hl7:id[@root='2.16.528.1.1007.3.3']|self::hl7:id|self::hl7:name|self::hl7:addr|self::hl7:telecom|self::lab:code)]"
         id="tmp-r-8b5ae2e9-bfdb-4628-a232-f6d6cb6b911a">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.100-2012-07-04T000000.html"
              test="not(.)">(CDAauthor): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-8b5ae2e9-bfdb-4628-a232-f6d6cb6b911a)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/*[not(self::hl7:assignedCustodian)]"
         id="tmp-r-50253cd3-a26c-42bf-b8ef-21516492883c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="not(.)">(CDAcustodian): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-50253cd3-a26c-42bf-b8ef-21516492883c)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/*[not(self::hl7:representedCustodianOrganization)]"
         id="tmp-r-399b19c3-529f-4364-a885-dd4987720649">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="not(.)">(CDAcustodian): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-399b19c3-529f-4364-a885-dd4987720649)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/*[not(self::hl7:id[@root='2.16.528.1.1007.3.3']|self::hl7:id|self::hl7:name|self::hl7:addr|self::hl7:telecom|self::lab:code)]"
         id="tmp-r-6334160f-a541-47c4-bff8-115126c05496">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html"
              test="not(.)">(CDAcustodian): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-6334160f-a541-47c4-bff8-115126c05496)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/*[not(self::hl7:intendedRecipient)]"
         id="tmp-r-78055947-345e-4e73-a288-13355bb6fb93">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="not(.)">(CDAinformationRecipient): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-78055947-345e-4e73-a288-13355bb6fb93)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/*[not(self::hl7:id|self::hl7:informationRecipient|self::hl7:representedOrganization)]"
         id="tmp-r-bbad7fbd-a1ec-421b-b0c6-abe7a9694138">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="not(.)">(CDAinformationRecipient): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-bbad7fbd-a1ec-421b-b0c6-abe7a9694138)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:informationRecipient/*[not(self::hl7:name)]"
         id="tmp-r-5ff018bf-8001-428b-bf8b-897473523fbc">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="not(.)">(CDAinformationRecipient): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-5ff018bf-8001-428b-bf8b-897473523fbc)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/*[not(self::hl7:id[@root='2.16.528.1.1007.3.3']|self::hl7:id|self::hl7:name|self::hl7:addr|self::hl7:telecom|self::lab:code)]"
         id="tmp-r-fcf8bdce-9969-41a5-9635-981327f679df">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html"
              test="not(.)">(CDAinformationRecipient): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-fcf8bdce-9969-41a5-9635-981327f679df)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/*[not(self::hl7:time|self::hl7:signatureCode[@code='S']|self::hl7:assignedEntity)]"
         id="tmp-r-656d6fc5-1ad3-4b6f-869e-98d5581df783">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="not(.)">(CDlegalAuthenticator): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-656d6fc5-1ad3-4b6f-869e-98d5581df783)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/*[not(self::hl7:id[@root='2.16.528.1.1007.3.1']|self::hl7:id|self::hl7:code|self::hl7:assignedPerson|self::hl7:representedOrganization)]"
         id="tmp-r-e17981a7-af76-4736-89b8-2c9a65dea770">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="not(.)">(CDlegalAuthenticator): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-e17981a7-af76-4736-89b8-2c9a65dea770)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:assignedPerson/*[not(self::hl7:name)]"
         id="tmp-r-aa30a37c-7be5-4744-a6fd-c3dd17f4a114">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="not(.)">(CDlegalAuthenticator): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-aa30a37c-7be5-4744-a6fd-c3dd17f4a114)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/*[not(self::hl7:id[@root='2.16.528.1.1007.3.3']|self::hl7:id|self::hl7:name|self::hl7:addr|self::hl7:telecom|self::lab:code)]"
         id="tmp-r-553326e8-fb9c-4ff3-ae71-68bbe319edb5">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html"
              test="not(.)">(CDlegalAuthenticator): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-553326e8-fb9c-4ff3-ae71-68bbe319edb5)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/*[not(self::hl7:time|self::hl7:associatedEntity)]"
         id="tmp-r-7c0d4b37-0421-4414-af0f-2b86ae2828cf">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="not(.)">(CDAParticipantVerifier): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-7c0d4b37-0421-4414-af0f-2b86ae2828cf)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/*[not(self::hl7:id[@root='2.16.528.1.1007.3.1']|self::hl7:id|self::hl7:code|self::hl7:associatedPerson|self::hl7:scopingOrganization)]"
         id="tmp-r-0379250f-41e3-48cb-a74c-0cdb06fb4183">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="not(.)">(CDAParticipantVerifier): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-0379250f-41e3-48cb-a74c-0cdb06fb4183)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:associatedPerson/*[not(self::hl7:name)]"
         id="tmp-r-a86a7c99-c8d4-4cdc-9231-c34fb99b09f5">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="not(.)">(CDAParticipantVerifier): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-a86a7c99-c8d4-4cdc-9231-c34fb99b09f5)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/*[not(self::hl7:id[@root='2.16.528.1.1007.3.3']|self::hl7:id|self::hl7:name|self::hl7:addr|self::hl7:telecom|self::lab:code)]"
         id="tmp-r-c2a7eae6-c3cc-471d-82fb-d43109f8ca99">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html"
              test="not(.)">(CDAParticipantVerifier): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-c2a7eae6-c3cc-471d-82fb-d43109f8ca99)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/*[not(self::hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]])]"
         id="tmp-r-6182cd39-ca29-4e0c-be4c-8f2edb66f6e3">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="not(.)">(CDAdocumentationOfMDL): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-6182cd39-ca29-4e0c-be4c-8f2edb66f6e3)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/*[not(self::hl7:id|self::hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]|self::lab:statusCode[@code='completed']|self::hl7:effectiveTime|self::hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]])]"
         id="tmp-r-8ad0af89-88e1-4f0e-9c5f-5b8d5022b7a1">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="not(.)">(CDAdocumentationOfMDL): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-8ad0af89-88e1-4f0e-9c5f-5b8d5022b7a1)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:effectiveTime/*[not(self::hl7:low)]"
         id="tmp-r-a115209e-0c8e-4280-8174-00034f31e77b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="not(.)">(CDAdocumentationOfMDL): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-a115209e-0c8e-4280-8174-00034f31e77b)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/*[not(self::hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]])]"
         id="tmp-r-9a2e0cd1-e965-4816-a343-2302b4ea7b58">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="not(.)">(CDAdocumentationOfMDL): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-9a2e0cd1-e965-4816-a343-2302b4ea7b58)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/*[not(self::hl7:id[@root='2.16.528.1.1007.3.1']|self::hl7:id|self::hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]|self::hl7:addr|self::hl7:telecom|self::hl7:assignedPerson|self::hl7:representedOrganization)]"
         id="tmp-r-a700c602-b41e-4ab9-84a3-21301dde87ec">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="not(.)">(CDAdocumentationOfMDL): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-a700c602-b41e-4ab9-84a3-21301dde87ec)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:assignedPerson/*[not(self::hl7:name)]"
         id="tmp-r-d74e34a8-6622-442c-8349-0b0722af4238">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="not(.)">(CDAdocumentationOfMDL): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-d74e34a8-6622-442c-8349-0b0722af4238)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/*[not(self::hl7:id[@root='2.16.528.1.1007.3.3']|self::hl7:id|self::hl7:name|self::hl7:addr|self::hl7:telecom|self::lab:code)]"
         id="tmp-r-d1be493c-486f-4351-be35-32d05952457e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html"
              test="not(.)">(CDAdocumentationOfMDL): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-d1be493c-486f-4351-be35-32d05952457e)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/*[not(self::hl7:structuredBody)]"
         id="tmp-r-dbbfae9d-4a50-4206-a85d-919e796866ce">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-dbbfae9d-4a50-4206-a85d-919e796866ce)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/*[not(self::hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.201']]|self::hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']]|self::hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]|self::hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]|self::hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]|self::hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]|self::hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']])]"
         id="tmp-r-cd47028a-e9b5-496b-a9e9-c3fa016b814b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-cd47028a-e9b5-496b-a9e9-c3fa016b814b)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.201']]/*[not(self::hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.201'])]"
         id="tmp-r-7a876ace-f716-4709-9050-c945bf6ced76">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-7a876ace-f716-4709-9050-c945bf6ced76)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.201']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.201']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.201']|self::hl7:code[(@code='X-SALUT' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:title|self::hl7:text)]"
         id="tmp-r-73bff5cf-a385-450c-9170-0523f3e4cadf">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-73bff5cf-a385-450c-9170-0523f3e4cadf)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']]/*[not(self::hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202'])]"
         id="tmp-r-4639da30-7952-4166-b7d7-e1cd61329093">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-4639da30-7952-4166-b7d7-e1cd61329093)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.202']|self::hl7:code[(@code='59768-2' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:title|self::hl7:text|self::hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']])]"
         id="tmp-r-a4a8f6ce-ae87-4e8f-b05f-64f6cc7f8510">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-a4a8f6ce-ae87-4e8f-b05f-64f6cc7f8510)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382'])]"
         id="tmp-r-32c76a76-4f47-410e-b016-3d1b1f7bbad3">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-32c76a76-4f47-410e-b016-3d1b1f7bbad3)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.382']|self::hl7:code[(@code='55607006' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:text|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.220-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.220-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.227-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.227-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])]"
         id="tmp-r-e63fa5f2-68cb-48fb-8c7c-3376de6e733b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-e63fa5f2-68cb-48fb-8c7c-3376de6e733b)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-a4971a1e-1734-4649-b0ff-b2447bdd99cf">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-a4971a1e-1734-4649-b0ff-b2447bdd99cf)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/*[not(self::hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203'])]"
         id="tmp-r-388fad26-d330-476c-9b45-498664165bf6">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-388fad26-d330-476c-9b45-498664165bf6)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.203']|self::hl7:code[(@code='29554-3' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:title|self::hl7:text|self::hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]|self::hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']]|self::hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.342']])]"
         id="tmp-r-c3f37cb0-a63d-43b4-84a0-6f990258ae61">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-c3f37cb0-a63d-43b4-84a0-6f990258ae61)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/*[not(self::hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502'])]"
         id="tmp-r-f7082ada-c25e-4ce2-9d73-0f790145d933">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-f7082ada-c25e-4ce2-9d73-0f790145d933)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.502']|self::hl7:code[(@code='406187008' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:statusCode[@code='completed']|self::hl7:component[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]|self::hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.507']]|self::hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.504']])]"
         id="tmp-r-556f8765-ee81-48dc-a2dd-607ad52215e3">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-556f8765-ee81-48dc-a2dd-607ad52215e3)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/*[not(self::hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503'])]"
         id="tmp-r-4a039de2-02bc-479e-af02-b7416429a2e5">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-4a039de2-02bc-479e-af02-b7416429a2e5)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.503']|self::hl7:id|self::hl7:code[(@code='DRUG' and @codeSystem='2.16.840.1.113883.5.4')]|self::hl7:text|self::hl7:statusCode|self::hl7:effectiveTime|self::hl7:doseQuantity|self::hl7:consumable)]"
         id="tmp-r-7a31dd32-0209-45db-a330-d84b2fb64ef1">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-7a31dd32-0209-45db-a330-d84b2fb64ef1)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-6d01cb43-c706-4da0-94a1-b22374140957">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-6d01cb43-c706-4da0-94a1-b22374140957)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:consumable/*[not(self::hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]])]"
         id="tmp-r-3beb2f28-6424-4f45-afe7-aaf44f14a49c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900054-2012-04-10T000000.html"
              test="not(.)">(Medicationcoloscopy): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-3beb2f28-6424-4f45-afe7-aaf44f14a49c)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:consumable/hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/*[not(self::hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]])]"
         id="tmp-r-d57ed7cc-edbb-4f47-9ad5-9e68889317df">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900054-2012-04-10T000000.html"
              test="not(.)">(Medicationcoloscopy): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-d57ed7cc-edbb-4f47-9ad5-9e68889317df)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:consumable/hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/*[not(self::hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]|self::hl7:name)]"
         id="tmp-r-a58c383a-fa6c-4556-93db-5ddf2dd98be4">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900054-2012-04-10T000000.html"
              test="not(.)">(Medicationcoloscopy): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-a58c383a-fa6c-4556-93db-5ddf2dd98be4)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.507']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.507'])]"
         id="tmp-r-180fe650-f2f0-49ca-bc25-3ff234efb3b9">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-180fe650-f2f0-49ca-bc25-3ff234efb3b9)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.507']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.507']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.507']|self::hl7:code[(@code='72641008' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:text|self::hl7:value)]"
         id="tmp-r-20167f53-1c24-415c-92ca-564b4bc04111">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-20167f53-1c24-415c-92ca-564b4bc04111)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.507']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.507']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-e78d429f-0ea8-484c-8538-3299f7922601">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-e78d429f-0ea8-484c-8538-3299f7922601)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.504']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.504'])]"
         id="tmp-r-a2fb0d8b-f8d2-45aa-9450-fd8b0e63f912">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-a2fb0d8b-f8d2-45aa-9450-fd8b0e63f912)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.504']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.504']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.504']|self::hl7:code[(@code='6942003' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:text|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.90-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.90-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])]"
         id="tmp-r-d3a52983-948e-4660-b8df-aedd5bbcff64">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-d3a52983-948e-4660-b8df-aedd5bbcff64)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.504']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.504']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-5151874a-e5fa-466d-91c4-40a14f10f257">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-5151874a-e5fa-466d-91c4-40a14f10f257)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305'])]"
         id="tmp-r-87835a7d-9036-45cd-a9aa-80370d38ddf3">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-87835a7d-9036-45cd-a9aa-80370d38ddf3)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.305']|self::hl7:code[(@code='116223007' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:text|self::hl7:value|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.306']])]"
         id="tmp-r-451b3a80-9c25-4fc9-a60b-ef8dde4f8e3c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-451b3a80-9c25-4fc9-a60b-ef8dde4f8e3c)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-7d525228-41c6-44d1-995f-243bbdbdffa6">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-7d525228-41c6-44d1-995f-243bbdbdffa6)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.306']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.306'])]"
         id="tmp-r-9ae227c9-5f10-403f-b6bd-a5fda775700f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-9ae227c9-5f10-403f-b6bd-a5fda775700f)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.306']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.306']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.306']|self::hl7:code[(@code='SEV' and @codeSystem='2.16.840.1.113883.5.4')]|self::hl7:text|self::hl7:statusCode|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.36-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.36-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])]"
         id="tmp-r-03712ac1-6652-4d48-8514-b976b29070bb">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-03712ac1-6652-4d48-8514-b976b29070bb)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.306']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.306']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-6aa52ed0-417f-4e17-874f-29bfcea7b615">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-6aa52ed0-417f-4e17-874f-29bfcea7b615)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.342']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.342'])]"
         id="tmp-r-bb22b601-acf1-4fe6-af1d-a76cb751ff62">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-bb22b601-acf1-4fe6-af1d-a76cb751ff62)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.342']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.342']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.342']|self::hl7:code[(@code='416393001' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:text|self::hl7:value)]"
         id="tmp-r-6fd8713a-5bb2-413a-b1bc-4c709f788acd">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-6fd8713a-5bb2-413a-b1bc-4c709f788acd)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.342']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.342']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-10b571f0-2d04-409b-b927-f55cd8e388b0">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-10b571f0-2d04-409b-b927-f55cd8e388b0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/*[not(self::hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204'])]"
         id="tmp-r-ab493084-fd1c-42fb-9e81-6ae73a207546">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-ab493084-fd1c-42fb-9e81-6ae73a207546)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.204']|self::hl7:code[(@code='59776-5' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:title|self::hl7:text|self::hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.337']]|self::hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]|self::hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']])]"
         id="tmp-r-0fd300ab-588e-4629-bedc-c1df8d6808d8">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-0fd300ab-588e-4629-bedc-c1df8d6808d8)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.337']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.337'])]"
         id="tmp-r-b504e0f4-876a-4af0-a25e-13b595e33ff2">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-b504e0f4-876a-4af0-a25e-13b595e33ff2)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.337']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.337']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.337']|self::hl7:code[(@code='102486008' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:text|self::hl7:value)]"
         id="tmp-r-f0f6d1a0-a8bb-45e5-8b7f-58e41698ad25">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-f0f6d1a0-a8bb-45e5-8b7f-58e41698ad25)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.337']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.337']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-cdcd52cd-cf79-4c29-9015-96cfbb5c7f5a">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-cdcd52cd-cf79-4c29-9015-96cfbb5c7f5a)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/*[not(self::hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307'])]"
         id="tmp-r-e260f245-17ee-400e-a082-8132066e017e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-e260f245-17ee-400e-a082-8132066e017e)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.307']|self::hl7:code[(@code='225106003' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:text|self::hl7:entryRelationship[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']])]"
         id="tmp-r-3a06a404-1a8a-488d-aacc-81f3fa471162">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-3a06a404-1a8a-488d-aacc-81f3fa471162)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:code[(@code='225106003' and @codeSystem='2.16.840.1.113883.6.96')]/*[not(self::hl7:qualifier)]"
         id="tmp-r-ba78260f-d6ba-417a-be21-a3cd101cb10e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-ba78260f-d6ba-417a-be21-a3cd101cb10e)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:code[(@code='225106003' and @codeSystem='2.16.840.1.113883.6.96')]/hl7:qualifier/*[not(self::hl7:name[(@code='370134009' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.223-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.223-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-a1789e2e-8e44-4944-bc3d-c0ada9b5b850">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-a1789e2e-8e44-4944-bc3d-c0ada9b5b850)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-165ce7d7-41e4-4617-9461-08e0501a0391">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-165ce7d7-41e4-4617-9461-08e0501a0391)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341']]/*[not(self::hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341'])]"
         id="tmp-r-1776e118-a52a-432d-871d-dfa8733f147a">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-1776e118-a52a-432d-871d-dfa8733f147a)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.341']|self::hl7:id|self::hl7:consumable)]"
         id="tmp-r-68b4189a-493a-481d-8c9a-092fdf8c9324">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-68b4189a-493a-481d-8c9a-092fdf8c9324)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341']/hl7:consumable/*[not(self::hl7:manufacturedProduct[hl7:manufacturedMaterial[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]])]"
         id="tmp-r-10f906d8-0dac-47eb-b249-07b6382e7815">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900088-2012-04-10T000000.html"
              test="not(.)">(Medicationforpreparation): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-10f906d8-0dac-47eb-b249-07b6382e7815)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341']/hl7:consumable/hl7:manufacturedProduct[hl7:manufacturedMaterial[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/*[not(self::hl7:manufacturedMaterial[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]])]"
         id="tmp-r-fb074860-ff72-4d67-8354-ab0254741e6e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900088-2012-04-10T000000.html"
              test="not(.)">(Medicationforpreparation): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-fb074860-ff72-4d67-8354-ab0254741e6e)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341']/hl7:consumable/hl7:manufacturedProduct[hl7:manufacturedMaterial[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:manufacturedMaterial[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/*[not(self::hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-b157ff73-3007-4a16-b25d-7cf7547bb00d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900088-2012-04-10T000000.html"
              test="not(.)">(Medicationforpreparation): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-b157ff73-3007-4a16-b25d-7cf7547bb00d)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310'])]"
         id="tmp-r-54f9d70b-0303-4d48-9f88-029c7f0fc331">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-54f9d70b-0303-4d48-9f88-029c7f0fc331)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.310']|self::hl7:code[(@code='X_BBPSSS' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:text|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.103-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.103-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.311']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.312']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.313']])]"
         id="tmp-r-86debd39-03be-4164-8eda-151961cb2be2">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-86debd39-03be-4164-8eda-151961cb2be2)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-16299ca8-6491-4875-910d-977f97b93702">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-16299ca8-6491-4875-910d-977f97b93702)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.311']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.311'])]"
         id="tmp-r-89934993-28d8-44f4-8e5e-d7d731fe70bf">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-89934993-28d8-44f4-8e5e-d7d731fe70bf)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.311']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.311']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.311']|self::hl7:code[(@code='X_BBPSCR' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.102-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.102-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-b450afc5-8d50-4d20-abab-40909d4d6a8c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-b450afc5-8d50-4d20-abab-40909d4d6a8c)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.312']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.312'])]"
         id="tmp-r-07b0818d-98e8-4fa4-8028-f57cecdea34e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-07b0818d-98e8-4fa4-8028-f57cecdea34e)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.312']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.312']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.312']|self::hl7:code[(@code='X_BBPSCT' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.102-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.102-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-d4a526e1-9da2-4f45-8282-32a7b16ec8e1">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-d4a526e1-9da2-4f45-8282-32a7b16ec8e1)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.313']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.313'])]"
         id="tmp-r-1111fba7-7a20-4431-8faf-f897f582a85b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-1111fba7-7a20-4431-8faf-f897f582a85b)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.313']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.313']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.313']|self::hl7:code[(@code='X_BBPSCL' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.102-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.102-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-d7aecd90-7568-42a9-b91f-b61d04049c94">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-d7aecd90-7568-42a9-b91f-b61d04049c94)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/*[not(self::hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320'])]"
         id="tmp-r-354d5662-d16d-4cae-9c55-a22ff9642146">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-354d5662-d16d-4cae-9c55-a22ff9642146)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.320']|self::hl7:code[(@code='444783004' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:text|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.322']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.329']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.343']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.330']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.344']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.323']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.331']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.328']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.334']])]"
         id="tmp-r-7c8eeaae-5128-4658-86a0-4a611368f48d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-7c8eeaae-5128-4658-86a0-4a611368f48d)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-da86bffe-8ed8-4c40-a3f9-de6fc41fc55e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-da86bffe-8ed8-4c40-a3f9-de6fc41fc55e)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.322']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.322'])]"
         id="tmp-r-ab3d1458-ae38-4878-b7fd-896cafe275e8">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-ab3d1458-ae38-4878-b7fd-896cafe275e8)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.322']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.322']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.322']|self::hl7:code[(@code='C140022' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]|self::hl7:text|self::hl7:value)]"
         id="tmp-r-937f5cd5-84ed-4e5b-87e7-699d9cd48847">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-937f5cd5-84ed-4e5b-87e7-699d9cd48847)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.322']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.322']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-5ba24441-59ed-48af-93f2-2dde1c7b4c05">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-5ba24441-59ed-48af-93f2-2dde1c7b4c05)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.329']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.329'])]"
         id="tmp-r-e8f6326d-06ef-490e-b2d2-ab995160505d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-e8f6326d-06ef-490e-b2d2-ab995160505d)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.329']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.329']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.329']|self::hl7:code[(@code='C140040' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]|self::hl7:text|self::hl7:value)]"
         id="tmp-r-3fb536d3-0e5b-4473-a712-78e82db065b1">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-3fb536d3-0e5b-4473-a712-78e82db065b1)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.329']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.329']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-fd22cff1-ee1c-47ac-8989-88969c9321b0">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-fd22cff1-ee1c-47ac-8989-88969c9321b0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.343']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.343'])]"
         id="tmp-r-25573a3d-d082-4c68-8f15-7b18143692e7">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-25573a3d-d082-4c68-8f15-7b18143692e7)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.343']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.343']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.343']|self::hl7:code[(@code='C140041' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]|self::hl7:text|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.37-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.37-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-4bfb118f-d4d5-4c84-8d8b-7156b6139088">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-4bfb118f-d4d5-4c84-8d8b-7156b6139088)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.343']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.343']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-d9796f77-0897-4b50-9686-d78b0875b503">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-d9796f77-0897-4b50-9686-d78b0875b503)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.330']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.330'])]"
         id="tmp-r-9c6f5f71-22ee-4b7c-8dee-d40b6029b512">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-9c6f5f71-22ee-4b7c-8dee-d40b6029b512)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.330']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.330']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.330']|self::hl7:code[(@code='C140060' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]|self::hl7:text|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.108-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.108-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-949f5e87-7d29-474a-b93f-c7c09cc6b749">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-949f5e87-7d29-474a-b93f-c7c09cc6b749)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.330']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.330']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-68f6d5b6-41ae-4ee5-98ec-2e1b1b142a5b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-68f6d5b6-41ae-4ee5-98ec-2e1b1b142a5b)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.344']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.344'])]"
         id="tmp-r-afb44887-76f5-43c3-9f20-f7c91f1f3ec3">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-afb44887-76f5-43c3-9f20-f7c91f1f3ec3)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.344']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.344']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.344']|self::hl7:code[(@code='C140065' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]|self::hl7:text|self::hl7:value)]"
         id="tmp-r-04c16766-89d7-493b-b63e-32a9c7089f8c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-04c16766-89d7-493b-b63e-32a9c7089f8c)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.344']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.344']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-e1884102-3c12-418d-98dd-3cd03f07fa67">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-e1884102-3c12-418d-98dd-3cd03f07fa67)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.323']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.323'])]"
         id="tmp-r-c56f4dd0-1a81-4109-a99b-19ace79d03a5">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-c56f4dd0-1a81-4109-a99b-19ace79d03a5)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.323']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.323']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.323']|self::hl7:code[(@code='C140070' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]|self::hl7:text|self::hl7:value)]"
         id="tmp-r-a6d13651-5680-4118-98fe-43893db9f28e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-a6d13651-5680-4118-98fe-43893db9f28e)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.323']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.323']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-fe17b27d-fb17-4817-b9e1-3861f0da995f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-fe17b27d-fb17-4817-b9e1-3861f0da995f)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.331']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.331'])]"
         id="tmp-r-e94dab17-ce9c-4361-9d80-e10f39ff96e8">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-e94dab17-ce9c-4361-9d80-e10f39ff96e8)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.331']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.331']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.331']|self::hl7:code[(@code='C140105' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]|self::hl7:text|self::hl7:value)]"
         id="tmp-r-470fa910-8cf7-49b3-a380-70b8e8dce505">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-470fa910-8cf7-49b3-a380-70b8e8dce505)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.331']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.331']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-df0d65ce-a80d-4eb8-8732-52ee77eafe52">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-df0d65ce-a80d-4eb8-8732-52ee77eafe52)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.328']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.328'])]"
         id="tmp-r-4092f335-e00b-43c7-945b-fd30d98451c0">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-4092f335-e00b-43c7-945b-fd30d98451c0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.328']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.328']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.328']|self::hl7:code[(@code='X_GCS' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:text|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.104-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.104-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])]"
         id="tmp-r-566c9e0d-923a-46f2-8de7-c51394c6df46">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-566c9e0d-923a-46f2-8de7-c51394c6df46)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.328']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.328']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-3397c64f-ac11-436c-82f4-bc31610bfeb0">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-3397c64f-ac11-436c-82f4-bc31610bfeb0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.334']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.334'])]"
         id="tmp-r-eafa59c7-9776-4759-808b-7732178875f2">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-eafa59c7-9776-4759-808b-7732178875f2)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.334']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.334']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.334']|self::hl7:code[(@code='445032002' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:text|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.37-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.37-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-9ef89066-feb8-42dc-869d-783f67ee3fc0">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-9ef89066-feb8-42dc-869d-783f67ee3fc0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.334']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.334']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-eab12e9a-3e51-4036-b110-aa5324f0aae8">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-eab12e9a-3e51-4036-b110-aa5324f0aae8)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/*[not(self::hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205'])]"
         id="tmp-r-ea769bc0-73fa-45d4-a451-f2612ca3b89d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-ea769bc0-73fa-45d4-a451-f2612ca3b89d)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.205']|self::hl7:code[(@code='51848-0' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:title|self::hl7:text|self::hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.345']]|self::hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.346']]|self::hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]|self::hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.332']]|self::hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.338']])]"
         id="tmp-r-acfde323-1362-4b6f-b89f-e2499fb7941f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-acfde323-1362-4b6f-b89f-e2499fb7941f)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.345']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.345'])]"
         id="tmp-r-bf74e1c0-f6e5-4bda-9ea2-4895f333f0d0">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-bf74e1c0-f6e5-4bda-9ea2-4895f333f0d0)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.345']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.345']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.345']|self::hl7:code[(@code='300579006' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:value)]"
         id="tmp-r-c2fc0b36-4ad8-484c-86fc-c76b9bed6ff9">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-c2fc0b36-4ad8-484c-86fc-c76b9bed6ff9)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.346']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.346'])]"
         id="tmp-r-431bf5f0-346a-46ca-ba5d-d149186099e6">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-431bf5f0-346a-46ca-ba5d-d149186099e6)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.346']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.346']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.346']|self::hl7:code[(@code='246206008' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:value|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.347']])]"
         id="tmp-r-e0854cd5-f9e2-4d88-aca7-f3258a8afeff">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-e0854cd5-f9e2-4d88-aca7-f3258a8afeff)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.346']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.346']/hl7:code[(@code='246206008' and @codeSystem='2.16.840.1.113883.6.96')]/*[not(self::hl7:qualifier)]"
         id="tmp-r-c50091f6-036b-4fd6-bdf9-89e2bc58ea10">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-c50091f6-036b-4fd6-bdf9-89e2bc58ea10)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.346']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.346']/hl7:code[(@code='246206008' and @codeSystem='2.16.840.1.113883.6.96')]/hl7:qualifier/*[not(self::hl7:name[(@code='408730004' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:value[(@code='408836004' and @codeSystem='2.16.840.1.113883.6.96')])]"
         id="tmp-r-a744a61f-deed-4e3d-a3b8-febb14e02e18">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-a744a61f-deed-4e3d-a3b8-febb14e02e18)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.346']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.346']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.347']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.347'])]"
         id="tmp-r-531c7545-6df6-4112-9161-1f6aa3691bf3">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-531c7545-6df6-4112-9161-1f6aa3691bf3)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.346']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.346']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.347']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.347']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.347']|self::hl7:code[(@code='445032002' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.224-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.224-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-858ae818-35a1-49c4-ab6b-29562bb8464d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-858ae818-35a1-49c4-ab6b-29562bb8464d)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/*[not(self::hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383'])]"
         id="tmp-r-10eea47b-6175-4c53-9fcf-c2d3e867e03c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-10eea47b-6175-4c53-9fcf-c2d3e867e03c)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.383']|self::hl7:statusCode[@code='completed']|self::hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']])]"
         id="tmp-r-1fec48a4-5354-4764-ac5b-30bb6ce925a5">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-1fec48a4-5354-4764-ac5b-30bb6ce925a5)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/*[not(self::hl7:sequenceNumber|self::hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333'])]"
         id="tmp-r-60601114-9ac1-4a5f-8c29-63abe9cdf2d6">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-60601114-9ac1-4a5f-8c29-63abe9cdf2d6)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.333']|self::hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:specimen)]"
         id="tmp-r-aadf19a4-2f7f-4f23-86f4-d46ccbbd4886">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-aadf19a4-2f7f-4f23-86f4-d46ccbbd4886)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/*[not(self::hl7:specimenRole)]"
         id="tmp-r-001354e5-6ac0-4d74-84f4-03578ff314d9">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-001354e5-6ac0-4d74-84f4-03578ff314d9)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/*[not(self::hl7:id|self::hl7:specimenPlayingEntity|self::lab:productOf|self::lab:subjectOf[lab:observationEvent/lab:code/@code='C145061']|self::lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']|self::lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']|self::lab:subjectOf[lab:observationEvent/lab:code/@code='DX']|self::lab:subjectOf[lab:observationEvent/lab:code/@code='269533000']|self::lab:subjectOf[lab:observationEvent/lab:code/@code='19132000']|self::lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']|self::lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']|self::lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']|self::lab:subjectOf[lab:procedure/lab:code/@code='702389009'])]"
         id="tmp-r-32f6f090-4d47-4b03-af5e-d8b6a39324b8">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-32f6f090-4d47-4b03-af5e-d8b6a39324b8)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity/*[not(self::hl7:code|self::hl7:quantity|self::lab:asSpecimenInContainer)]"
         id="tmp-r-05f5e3c1-cd8b-4c43-9ff0-00941d5c6f74">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-05f5e3c1-cd8b-4c43-9ff0-00941d5c6f74)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity/lab:asSpecimenInContainer/*[not(self::lab:container)]"
         id="tmp-r-663885b2-4699-43b1-a767-670c2808ef90">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-663885b2-4699-43b1-a767-670c2808ef90)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity/lab:asSpecimenInContainer/lab:container/*[not(self::lab:id)]"
         id="tmp-r-fe41f97b-722c-450a-b297-cf7278ecd7bb">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-fe41f97b-722c-450a-b297-cf7278ecd7bb)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/*[not(self::lab:specimenCollectionProcess)]"
         id="tmp-r-3b7f1977-1ab7-4f26-8ab2-56eb26611c6e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-3b7f1977-1ab7-4f26-8ab2-56eb26611c6e)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/*[not(self::lab:code|self::lab:targetSiteCode|self::lab:methodCode)]"
         id="tmp-r-2616f398-7931-4ca5-946c-c14579fa98f8">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-2616f398-7931-4ca5-946c-c14579fa98f8)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/*[not(self::lab:qualifier[lab:name/@code='246386008']|self::lab:qualifier[lab:name/@code='260858005'])]"
         id="tmp-r-6448df50-68b7-47ae-ba92-66281cfe6c97">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-6448df50-68b7-47ae-ba92-66281cfe6c97)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='246386008']/*[not(self::lab:name[(@code='246386008' and @codeSystem='2.16.840.1.113883.6.96')]|self::lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.229-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.229-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])]"
         id="tmp-r-a87039ce-9dfa-4454-a2af-fb936fdd840d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900121-2015-03-08T000000.html"
              test="not(.)">(Methodeverwijdering): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-a87039ce-9dfa-4454-a2af-fb936fdd840d)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='260858005']/*[not(self::lab:name[(@code='260858005' and @codeSystem='2.16.840.1.113883.6.96')]|self::lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.230-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.230-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])]"
         id="tmp-r-4bf9fe5a-9744-4981-8c9b-2ea5e49d8b3d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900122-2015-03-08T000000.html"
              test="not(.)">(Resultaatverwijdering): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-4bf9fe5a-9744-4981-8c9b-2ea5e49d8b3d)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:methodCode/*[not(self::lab:originalText)]"
         id="tmp-r-c5bdf6a9-ea30-4559-9ec4-01ba834317da">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-c5bdf6a9-ea30-4559-9ec4-01ba834317da)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145061']/*[not(self::lab:observationEvent)]"
         id="tmp-r-a524dcb2-f55b-40a5-a431-a17c5e4597f5">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-a524dcb2-f55b-40a5-a431-a17c5e4597f5)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145061']/lab:observationEvent/*[not(self::lab:code[(@code='C145061' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]|self::lab:value)]"
         id="tmp-r-0402df98-f7f7-4384-a6c2-603ed75db4cc">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-0402df98-f7f7-4384-a6c2-603ed75db4cc)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']/*[not(self::lab:observationEvent)]"
         id="tmp-r-85b01d22-4fe9-49ec-80df-730c29415c7b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-85b01d22-4fe9-49ec-80df-730c29415c7b)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']/lab:observationEvent/*[not(self::lab:code[(@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')]|self::lab:value)]"
         id="tmp-r-816687fc-dc7d-4019-83f8-d2d33c8f8026">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-816687fc-dc7d-4019-83f8-d2d33c8f8026)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']/*[not(self::lab:observationEvent)]"
         id="tmp-r-2947049d-1b1a-425e-a33d-f5b709555f23">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-2947049d-1b1a-425e-a33d-f5b709555f23)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']/lab:observationEvent/*[not(self::lab:code[(@code='41329004' and @codeSystem='2.16.840.1.113883.6.96')]|self::lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-04fd3483-16b4-4ebe-9053-f71db6c0b70e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-04fd3483-16b4-4ebe-9053-f71db6c0b70e)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']/*[not(self::lab:observationEvent)]"
         id="tmp-r-8f12359f-14c7-4706-8650-82c61fa254d4">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-8f12359f-14c7-4706-8650-82c61fa254d4)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']/lab:observationEvent/*[not(self::lab:code[(@code='DX' and @codeSystem='2.16.840.1.113883.5.4')]|self::lab:text|self::lab:value)]"
         id="tmp-r-2d0f9a05-6dab-4afd-a494-bb813593f282">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-2d0f9a05-6dab-4afd-a494-bb813593f282)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='269533000']/*[not(self::lab:observationEvent)]"
         id="tmp-r-dc3b61ce-237b-450d-b867-b2a2f2d50a65">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-dc3b61ce-237b-450d-b867-b2a2f2d50a65)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='269533000']/lab:observationEvent/*[not(self::lab:code[(@code='269533000' and @codeSystem='2.16.840.1.113883.6.96')])]"
         id="tmp-r-31d4d616-c340-4538-a15b-4eadb463df8e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-31d4d616-c340-4538-a15b-4eadb463df8e)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='19132000']/*[not(self::lab:observationEvent)]"
         id="tmp-r-72cb0069-748b-4ed0-a010-52a1ef12912b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-72cb0069-748b-4ed0-a010-52a1ef12912b)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='19132000']/lab:observationEvent/*[not(self::lab:code[(@code='19132000' and @codeSystem='2.16.840.1.113883.6.96')])]"
         id="tmp-r-dd7ab043-63d3-4e11-923a-f435396dcea4">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-dd7ab043-63d3-4e11-923a-f435396dcea4)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/*[not(self::lab:observationEvent)]"
         id="tmp-r-4b22d8f2-fb31-49c1-9088-c36ea0f986c7">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-4b22d8f2-fb31-49c1-9088-c36ea0f986c7)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent/*[not(self::lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')]|self::lab:value)]"
         id="tmp-r-4c6f4369-771a-400e-9142-98067908d372">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-4c6f4369-771a-400e-9142-98067908d372)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']/*[not(self::lab:observationEvent)]"
         id="tmp-r-bd7cfa85-67fa-4b6f-abdb-95b0c355af20">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-bd7cfa85-67fa-4b6f-abdb-95b0c355af20)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']/lab:observationEvent/*[not(self::lab:code[(@code='C145140' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]|self::lab:value)]"
         id="tmp-r-89e5009f-f02d-4e0d-9504-55c33075913a">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-89e5009f-f02d-4e0d-9504-55c33075913a)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']/*[not(self::lab:observationEvent)]"
         id="tmp-r-5a09e9aa-1ba8-4e84-ac73-00559f611ac2">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-5a09e9aa-1ba8-4e84-ac73-00559f611ac2)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']/lab:observationEvent/*[not(self::lab:code[(@code='14792009' and @codeSystem='2.16.840.1.113883.6.96')]|self::lab:value)]"
         id="tmp-r-d3813c13-f08d-48f0-816b-88410e5ee865">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-d3813c13-f08d-48f0-816b-88410e5ee865)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:procedure/lab:code/@code='702389009']/*[not(self::lab:procedure)]"
         id="tmp-r-78b09039-8089-48d8-8544-0b118cc37609">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-78b09039-8089-48d8-8544-0b118cc37609)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:procedure/lab:code/@code='702389009']/lab:procedure/*[not(self::lab:code[(@code='702389009' and @codeSystem='2.16.840.1.113883.6.96')])]"
         id="tmp-r-6ab93efc-6248-4147-8e50-50a424d35e56">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-6ab93efc-6248-4147-8e50-50a424d35e56)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.332']]/*[not(self::hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.332'])]"
         id="tmp-r-d8e8062a-1a3f-42c1-9219-3959ac9fbdcf">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-d8e8062a-1a3f-42c1-9219-3959ac9fbdcf)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.332']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.332']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.332']|self::hl7:id|self::hl7:code[(@code='X-LAB-ORDER' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:text|self::hl7:statusCode[@code='completed'])]"
         id="tmp-r-0f6d04f9-157b-4e67-a45b-826d9fc83f32">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-0f6d04f9-157b-4e67-a45b-826d9fc83f32)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.332']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.332']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-953fa305-4d21-4cff-ac66-bf9cce5ec0ac">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-953fa305-4d21-4cff-ac66-bf9cce5ec0ac)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.338']]/*[not(self::hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.338'])]"
         id="tmp-r-de3a603e-e27c-4419-be6d-4b2e1d04d8a9">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-de3a603e-e27c-4419-be6d-4b2e1d04d8a9)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.338']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.338']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.338']|self::hl7:id|self::hl7:code[(@code='11526-1' and @codeSystem='2.16.840.1.113883.6.1')])]"
         id="tmp-r-507e14bb-bc3c-4e19-8d72-4df06674cdc7">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-507e14bb-bc3c-4e19-8d72-4df06674cdc7)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]/*[not(self::hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207'])]"
         id="tmp-r-64579733-bea8-466f-b1c3-5ea6b76a9ec3">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-64579733-bea8-466f-b1c3-5ea6b76a9ec3)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.207']|self::hl7:code[(@code='18776-5' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:title|self::hl7:text|self::hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.370']]|self::hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.372']])]"
         id="tmp-r-d94d2d6f-4506-44d7-a376-c842e74221b5">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-d94d2d6f-4506-44d7-a376-c842e74221b5)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.370']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.370'])]"
         id="tmp-r-bd41f533-21be-477b-9dd1-154440103e6f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-bd41f533-21be-477b-9dd1-154440103e6f)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.370']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.370']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.370']|self::hl7:code[(@code='409064004' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:text|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.38-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.38-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])]"
         id="tmp-r-27ad9e4f-b15f-40d3-aa78-48653bc53efa">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-27ad9e4f-b15f-40d3-aa78-48653bc53efa)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.370']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.370']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-16e18e98-5755-458a-a609-c02c9a2b24d7">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-16e18e98-5755-458a-a609-c02c9a2b24d7)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.372']]/*[not(self::hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.372'])]"
         id="tmp-r-c686930f-286b-40db-8410-14745064dfa4">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-c686930f-286b-40db-8410-14745064dfa4)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.372']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.372']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.372']|self::hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.39-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.39-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]|self::hl7:text|self::hl7:effectiveTime|self::hl7:performer)]"
         id="tmp-r-2eed7ca3-3cc9-4970-a18f-e34ed547d7ba">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-2eed7ca3-3cc9-4970-a18f-e34ed547d7ba)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.372']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.372']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-bacf3947-e77d-409a-bb8f-dbf9d0e955e6">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-bacf3947-e77d-409a-bb8f-dbf9d0e955e6)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.372']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.372']/hl7:effectiveTime/*[not(self::hl7:width)]"
         id="tmp-r-d61202ac-c8ba-4f6b-a38c-2f768c2f552d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-d61202ac-c8ba-4f6b-a38c-2f768c2f552d)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.372']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.372']/hl7:performer/*[not(self::hl7:assignedEntity)]"
         id="tmp-r-7c23cc53-aa74-48cd-88dd-d4fa2eecaee5">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-7c23cc53-aa74-48cd-88dd-d4fa2eecaee5)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.372']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.372']/hl7:performer/hl7:assignedEntity/*[not(self::hl7:id|self::hl7:representedOrganization)]"
         id="tmp-r-7acd7666-d0a9-4dfc-871e-4e25a2f7f9dd">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-7acd7666-d0a9-4dfc-871e-4e25a2f7f9dd)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.372']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.372']/hl7:performer/hl7:assignedEntity/hl7:representedOrganization/*[not(self::hl7:name)]"
         id="tmp-r-cd98e01e-b9d5-43de-92e9-adc966089e2b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-cd98e01e-b9d5-43de-92e9-adc966089e2b)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']]/*[not(self::hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208'])]"
         id="tmp-r-eb5be3e7-2acd-4754-84f3-f9a3004bc1e4">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-eb5be3e7-2acd-4754-84f3-f9a3004bc1e4)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.208']|self::hl7:code[(@code='55110-1' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:title|self::hl7:text|self::hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.380']]|self::hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']])]"
         id="tmp-r-22267f3d-656c-4d38-b1c0-578d50ad064e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-22267f3d-656c-4d38-b1c0-578d50ad064e)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.380']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.380'])]"
         id="tmp-r-eb09efe8-fe5d-4bf6-b6f0-805e5cf160b1">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-eb09efe8-fe5d-4bf6-b6f0-805e5cf160b1)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.380']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.380']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.380']|self::hl7:code[(@code='DX' and @codeSystem='2.16.840.1.113883.5.4')]|self::hl7:text|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.78-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.78-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-02550f9d-c664-4276-b93e-29fd68ca5801">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-02550f9d-c664-4276-b93e-29fd68ca5801)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.380']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.380']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-50d4842e-2324-40ff-bc33-9d8f449adce3">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-50d4842e-2324-40ff-bc33-9d8f449adce3)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381'])]"
         id="tmp-r-bbce35a8-643f-4c70-a7d0-0b875e878216">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-bbce35a8-643f-4c70-a7d0-0b875e878216)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.381']|self::hl7:code[(@code='ASSERTION' and @codeSystem='2.16.840.1.113883.5.4')]|self::hl7:text|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.76-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.76-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
         id="tmp-r-32b24946-0ee6-46dc-af83-7bdb52513508">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-32b24946-0ee6-46dc-af83-7bdb52513508)</assert>
   </rule>

   <!-- Checking undefined contents for template/element @isClosed="true". Match context that we did not already match -->
   <rule context="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.12' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']/hl7:text/*[not(self::hl7:reference)]"
         id="tmp-r-6614eed2-de42-4c46-8c5c-c546f6b93c07">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.12-2014-07-13T000000.html"
              test="not(.)">(nspbcmdl2014b): '<name path=".."/>' is gedefinieerd als gesloten en dit element '<name/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-6614eed2-de42-4c46-8c5c-c546f6b93c07)</assert>
   </rule>
</pattern>
