<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.36.10.200
Name: Clinical Information Section
Description: The Clinical Information section contains the information provided by the ordering physician: Clinical history, preoperative diagnosis, postoperative diagnosis, clinical laboratory data, specimen(s) description, collection procedure, reason for anatomic pathology procedure
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.36.10.200-2012-04-10T000000">
   <title>Clinical Information Section</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.200
Context: *[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']]
Item: (ClinicalInformationSection)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.200
Context: *[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']
Item: (ClinicalInformationSection)
-->

   <rule context="*[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']"
         id="tmp-r-f17c29d3-530f-4523-bb4e-e561a59419fa">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.200-2012-04-10T000000.html"
              test="string(@classCode)=('DOCSECT')">(ClinicalInformationSection): de waarde van @classCode MOET 'DOCSECT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.200-2012-04-10T000000.html"
              test="count(hl7:templateId[@root='1.3.6.1.4.1.19376.1.8.1.2.1'])&lt;=1">(ClinicalInformationSection): element hl7:templateId[@root='1.3.6.1.4.1.19376.1.8.1.2.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.200-2012-04-10T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.200'])&gt;=1 ">(ClinicalInformationSection): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.200'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.200-2012-04-10T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.200'])&lt;=1">(ClinicalInformationSection): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.200'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.200-2012-04-10T000000.html"
              test="count(hl7:code[(@code='22636-5' and @codeSystem='2.16.840.1.113883.6.1')])&gt;=1 and not(hl7:code[(@code='22636-5' and @codeSystem='2.16.840.1.113883.6.1')]/@nullFlavor)">(ClinicalInformationSection): element hl7:code[(@code='22636-5' and @codeSystem='2.16.840.1.113883.6.1')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.200-2012-04-10T000000.html"
              test="count(hl7:code[(@code='22636-5' and @codeSystem='2.16.840.1.113883.6.1')])&lt;=1">(ClinicalInformationSection): element hl7:code[(@code='22636-5' and @codeSystem='2.16.840.1.113883.6.1')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.200-2012-04-10T000000.html"
              test="count(hl7:title)&gt;=1 and not(hl7:title/@nullFlavor)">(ClinicalInformationSection): element hl7:title is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.200-2012-04-10T000000.html"
              test="count(hl7:title)&lt;=1">(ClinicalInformationSection): element hl7:title komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.200-2012-04-10T000000.html"
              test="count(hl7:text)&gt;=1 and not(hl7:text/@nullFlavor)">(ClinicalInformationSection): element hl7:text is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.200-2012-04-10T000000.html"
              test="count(hl7:text)&lt;=1">(ClinicalInformationSection): element hl7:text komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.200
Context: *[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']/hl7:templateId[@root='1.3.6.1.4.1.19376.1.8.1.2.1']
Item: (ClinicalInformationSection)
-->

   <rule context="*[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']/hl7:templateId[@root='1.3.6.1.4.1.19376.1.8.1.2.1']"
         id="tmp-r-2f0db755-43cd-4161-bc4c-9a4bcfbfa7ed">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.200-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ClinicalInformationSection): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.200-2012-04-10T000000.html"
              test="string(@root)=('1.3.6.1.4.1.19376.1.8.1.2.1')">(ClinicalInformationSection): de waarde van @root MOET '1.3.6.1.4.1.19376.1.8.1.2.1' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.200
Context: *[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.200']
Item: (ClinicalInformationSection)
-->

   <rule context="*[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.200']"
         id="tmp-r-5a723874-f8e5-4854-b89b-82c895eef11c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.200-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ClinicalInformationSection): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.200-2012-04-10T000000.html"
              test="string(@root)=('2.16.840.1.113883.2.4.3.36.10.200')">(ClinicalInformationSection): de waarde van @root MOET '2.16.840.1.113883.2.4.3.36.10.200' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.200
Context: *[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']/hl7:code[(@code='22636-5' and @codeSystem='2.16.840.1.113883.6.1')]
Item: (ClinicalInformationSection)
-->

   <rule context="*[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']/hl7:code[(@code='22636-5' and @codeSystem='2.16.840.1.113883.6.1')]"
         id="tmp-r-52da1cf4-7f62-426d-8667-8c1033fbca54">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.200-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ClinicalInformationSection): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.200-2012-04-10T000000.html"
              test="@nullFlavor or (@code='22636-5' and @codeSystem='2.16.840.1.113883.6.1')">(ClinicalInformationSection): de elementwaarde MOET een zijn van 'code '22636-5' codeSystem '2.16.840.1.113883.6.1''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.200
Context: *[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']/hl7:title
Item: (ClinicalInformationSection)
-->

   <rule context="*[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']/hl7:title"
         id="tmp-r-14cee594-2207-4aed-bb43-4c569062ac6d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.200-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ST' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ClinicalInformationSection): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.200-2012-04-10T000000.html"
              test="text()='Klinische gegevens'">(ClinicalInformationSection): de element content van hl7:title MOET ''Klinische gegevens'' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.200
Context: *[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']/hl7:text
Item: (ClinicalInformationSection)
-->

   <rule context="*[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.200']/hl7:text"
         id="tmp-r-d8313c8e-ae2e-4dc8-a251-136fc3168b1e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.200-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='SD.TEXT' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ClinicalInformationSection): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:SD.TEXT" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="SD.TEXT"/>
   </rule>
</pattern>
