<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.36.10.211
Name: Microscopie
Description: The Microscopic Observation section contains optionally the histopathologic findings of the case and many laboratories use this section to record the results of histochemical and immunohistochemical stains.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.36.10.211-2012-04-10T000000">
   <title>Microscopie</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.211
Context: *[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]
Item: (MicroscopicObservationSection)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.211
Context: *[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']
Item: (MicroscopicObservationSection)
-->

   <rule context="*[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']"
         id="tmp-r-ddd3a988-6483-4a39-97c1-93f5e6071bfb">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.211-2012-04-10T000000.html"
              test="string(@classCode)=('DOCSECT')">(MicroscopicObservationSection): de waarde van @classCode MOET 'DOCSECT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.211-2012-04-10T000000.html"
              test="count(hl7:templateId[@root='1.3.6.1.4.1.19376.1.8.1.2.6'])&lt;=1">(MicroscopicObservationSection): element hl7:templateId[@root='1.3.6.1.4.1.19376.1.8.1.2.6'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.211-2012-04-10T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.211'])&gt;=1 ">(MicroscopicObservationSection): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.211'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.211-2012-04-10T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.211'])&lt;=1">(MicroscopicObservationSection): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.211'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.211-2012-04-10T000000.html"
              test="count(hl7:code[(@code='22635-7' and @codeSystem='2.16.840.1.113883.6.1')])&gt;=1 and not(hl7:code[(@code='22635-7' and @codeSystem='2.16.840.1.113883.6.1')]/@nullFlavor)">(MicroscopicObservationSection): element hl7:code[(@code='22635-7' and @codeSystem='2.16.840.1.113883.6.1')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.211-2012-04-10T000000.html"
              test="count(hl7:code[(@code='22635-7' and @codeSystem='2.16.840.1.113883.6.1')])&lt;=1">(MicroscopicObservationSection): element hl7:code[(@code='22635-7' and @codeSystem='2.16.840.1.113883.6.1')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.211-2012-04-10T000000.html"
              test="count(hl7:title)&gt;=1 and not(hl7:title/@nullFlavor)">(MicroscopicObservationSection): element hl7:title is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.211-2012-04-10T000000.html"
              test="count(hl7:title)&lt;=1">(MicroscopicObservationSection): element hl7:title komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.211-2012-04-10T000000.html"
              test="count(hl7:text)&gt;=1 and not(hl7:text/@nullFlavor)">(MicroscopicObservationSection): element hl7:text is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.211-2012-04-10T000000.html"
              test="count(hl7:text)&lt;=1">(MicroscopicObservationSection): element hl7:text komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.211-2012-04-10T000000.html"
              test="count(hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']])&gt;=1 ">(MicroscopicObservationSection): element hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']] is required [min 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.211
Context: *[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:templateId[@root='1.3.6.1.4.1.19376.1.8.1.2.6']
Item: (MicroscopicObservationSection)
-->

   <rule context="*[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:templateId[@root='1.3.6.1.4.1.19376.1.8.1.2.6']"
         id="tmp-r-df9e2d0b-4251-4dc0-b94c-c89d4887f2ca">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.211-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MicroscopicObservationSection): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.211-2012-04-10T000000.html"
              test="string(@root)=('1.3.6.1.4.1.19376.1.8.1.2.6')">(MicroscopicObservationSection): de waarde van @root MOET '1.3.6.1.4.1.19376.1.8.1.2.6' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.211
Context: *[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.211']
Item: (MicroscopicObservationSection)
-->

   <rule context="*[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.211']"
         id="tmp-r-edfad2dc-9698-4e26-aeab-e00a595569c8">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.211-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MicroscopicObservationSection): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.211-2012-04-10T000000.html"
              test="string(@root)=('2.16.840.1.113883.2.4.3.36.10.211')">(MicroscopicObservationSection): de waarde van @root MOET '2.16.840.1.113883.2.4.3.36.10.211' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.211
Context: *[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:code[(@code='22635-7' and @codeSystem='2.16.840.1.113883.6.1')]
Item: (MicroscopicObservationSection)
-->

   <rule context="*[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:code[(@code='22635-7' and @codeSystem='2.16.840.1.113883.6.1')]"
         id="tmp-r-2d7d994c-9430-4117-9301-9cb6228f0371">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.211-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MicroscopicObservationSection): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.211-2012-04-10T000000.html"
              test="@nullFlavor or (@code='22635-7' and @codeSystem='2.16.840.1.113883.6.1')">(MicroscopicObservationSection): de elementwaarde MOET een zijn van 'code '22635-7' codeSystem '2.16.840.1.113883.6.1''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.211
Context: *[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:title
Item: (MicroscopicObservationSection)
-->

   <rule context="*[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:title"
         id="tmp-r-05620931-2c54-49db-b011-962258444276">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.211-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ST' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MicroscopicObservationSection): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.211-2012-04-10T000000.html"
              test="text()='Microscopie'">(MicroscopicObservationSection): de element content van hl7:title MOET ''Microscopie'' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.211
Context: *[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:text
Item: (MicroscopicObservationSection)
-->

   <rule context="*[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:text"
         id="tmp-r-aa0a405a-8fd0-4146-9bed-12e497560565">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.211-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='SD.TEXT' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MicroscopicObservationSection): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:SD.TEXT" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="SD.TEXT"/>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.211
Context: *[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]
Item: (MicroscopicObservationSection)
-->
   <rule context="*[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.211']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.211-2012-04-10T000000.html"
              test="string(@typeCode)=('DRIV')">(MicroscopicObservationSection): de waarde van @typeCode MOET 'DRIV' zijn.</assert>
   </rule>
</pattern>
