<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.36.10.212
Name: Diagnosis Section
Description: The Diagnosis section contains diagnoses on all specimens that are delivered to the pathology department from one operation or patient
                visit to a single clinician on a particular day. The diagnoses for each specimen or group of specimens are reported separately.
                This section includes additional pathologic finding(s) and the results of ancillary study(ies) and may
                include diagrams and still images or virtual slides, if taken. In case of cancer, this section includes the cancer checklist.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.36.10.212-2012-04-10T000000">
   <title>Diagnosis Section</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.212
Context: *[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']]
Item: (DiagnosisSection)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.212
Context: *[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']
Item: (DiagnosisSection)
-->

   <rule context="*[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']"
         id="tmp-r-2e81a5bf-8fc6-4cdd-a805-74fb191cf7fa">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.212-2012-04-10T000000.html"
              test="string(@classCode)=('DOCSECT')">(DiagnosisSection): de waarde van @classCode MOET 'DOCSECT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.212-2012-04-10T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.212'])&gt;=1 ">(DiagnosisSection): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.212'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.212-2012-04-10T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.212'])&lt;=1">(DiagnosisSection): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.212'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.212-2012-04-10T000000.html"
              test="count(hl7:code[(@code='22637-3' and @codeSystem='2.16.840.1.113883.6.1')])&gt;=1 and not(hl7:code[(@code='22637-3' and @codeSystem='2.16.840.1.113883.6.1')]/@nullFlavor)">(DiagnosisSection): element hl7:code[(@code='22637-3' and @codeSystem='2.16.840.1.113883.6.1')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.212-2012-04-10T000000.html"
              test="count(hl7:code[(@code='22637-3' and @codeSystem='2.16.840.1.113883.6.1')])&lt;=1">(DiagnosisSection): element hl7:code[(@code='22637-3' and @codeSystem='2.16.840.1.113883.6.1')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.212-2012-04-10T000000.html"
              test="count(hl7:title)&gt;=1 and not(hl7:title/@nullFlavor)">(DiagnosisSection): element hl7:title is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.212-2012-04-10T000000.html"
              test="count(hl7:title)&lt;=1">(DiagnosisSection): element hl7:title komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.212-2012-04-10T000000.html"
              test="count(hl7:text)&gt;=1 and not(hl7:text/@nullFlavor)">(DiagnosisSection): element hl7:text is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.212-2012-04-10T000000.html"
              test="count(hl7:text)&lt;=1">(DiagnosisSection): element hl7:text komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.212
Context: *[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.212']
Item: (DiagnosisSection)
-->

   <rule context="*[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.212']"
         id="tmp-r-5008e676-a6f9-46a5-b5ae-b369a3b03ac6">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.212-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(DiagnosisSection): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.212-2012-04-10T000000.html"
              test="string(@root)=('2.16.840.1.113883.2.4.3.36.10.212')">(DiagnosisSection): de waarde van @root MOET '2.16.840.1.113883.2.4.3.36.10.212' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.212
Context: *[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']/hl7:code[(@code='22637-3' and @codeSystem='2.16.840.1.113883.6.1')]
Item: (DiagnosisSection)
-->

   <rule context="*[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']/hl7:code[(@code='22637-3' and @codeSystem='2.16.840.1.113883.6.1')]"
         id="tmp-r-b96f5c65-17c5-41c2-9d68-d1c08fb58e01">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.212-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(DiagnosisSection): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.212-2012-04-10T000000.html"
              test="@nullFlavor or (@code='22637-3' and @codeSystem='2.16.840.1.113883.6.1')">(DiagnosisSection): de elementwaarde MOET een zijn van 'code '22637-3' codeSystem '2.16.840.1.113883.6.1''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.212
Context: *[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']/hl7:title
Item: (DiagnosisSection)
-->

   <rule context="*[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']/hl7:title"
         id="tmp-r-040a9460-6f0a-4405-9d01-17e6da6f3341">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.212-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ST' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(DiagnosisSection): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.212-2012-04-10T000000.html"
              test="text()='Conclusie en diagnosen'">(DiagnosisSection): de element content van hl7:title MOET ''Conclusie en diagnosen'' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.212
Context: *[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']/hl7:text
Item: (DiagnosisSection)
-->

   <rule context="*[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']/hl7:text"
         id="tmp-r-52166a7d-a351-49ed-a5a4-ac8e6924127e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.212-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='SD.TEXT' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(DiagnosisSection): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:SD.TEXT" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="SD.TEXT"/>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.212
Context: *[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']]
Item: (DiagnosisSection)
-->
   <rule context="*[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.212-2012-04-10T000000.html"
              test="string(@typeCode)=('DRIV')">(DiagnosisSection): de waarde van @typeCode MOET 'DRIV' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.212
Context: *[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.429']]
Item: (DiagnosisSection)
-->
   <rule context="*[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.429']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.212-2012-04-10T000000.html"
              test="string(@typeCode)=('DRIV')">(DiagnosisSection): de waarde van @typeCode MOET 'DRIV' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.212
Context: *[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.430']]
Item: (DiagnosisSection)
-->
   <rule context="*[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.212']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.430']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.212-2012-04-10T000000.html"
              test="string(@typeCode)=('DRIV')">(DiagnosisSection): de waarde van @typeCode MOET 'DRIV' zijn.</assert>
   </rule>
</pattern>
