<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.36.10.333
Name: Specimen collection
Description: Template: Specimen collection
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000">
   <title>Specimen collection</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]"
         id="tmp-r-a4da6b2a-84d6-4981-985c-db3b1fa1d966">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333'])&gt;=1 and not(hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/@nullFlavor)">(SpecimencollectionMDL): element hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333'])&lt;=1">(SpecimencollectionMDL): element hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']"
         id="tmp-r-4259b871-a737-40cf-9cc1-318834ac4f35">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="string(@classCode)=('ACT')">(SpecimencollectionMDL): de waarde van @classCode MOET 'ACT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="string(@moodCode)=('EVN')">(SpecimencollectionMDL): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.333'])&gt;=1 ">(SpecimencollectionMDL): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.333'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.333'])&lt;=1">(SpecimencollectionMDL): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.333'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')])&gt;=1 and not(hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')]/@nullFlavor)">(SpecimencollectionMDL): element hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')])&lt;=1">(SpecimencollectionMDL): element hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(hl7:specimen)&gt;=1 and not(hl7:specimen/@nullFlavor)">(SpecimencollectionMDL): element hl7:specimen is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(hl7:specimen)&lt;=1">(SpecimencollectionMDL): element hl7:specimen komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.336']])&lt;=1">(SpecimencollectionMDL): element hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.336']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.333']
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.333']"
         id="tmp-r-1416c4ee-371f-4fdb-8094-6b419c3aee88">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimencollectionMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="string(@root)=('2.16.840.1.113883.2.4.3.36.10.333')">(SpecimencollectionMDL): de waarde van @root MOET '2.16.840.1.113883.2.4.3.36.10.333' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')]
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')]"
         id="tmp-r-061c95b8-01e6-41ba-a715-6002e6d86aa0">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimencollectionMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="@nullFlavor or (@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')">(SpecimencollectionMDL): de elementwaarde MOET een zijn van 'code 'X-LAB-SPMSCT' codeSystem '2.16.840.1.113883.6.1''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen"
         id="tmp-r-8541980d-e710-4dda-b30f-be65472ca48f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="string(@typeCode)=('SPC')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SPC' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(hl7:specimenRole)&gt;=1 and not(hl7:specimenRole/@nullFlavor)">(SpecimencollectionMDL): element hl7:specimenRole is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(hl7:specimenRole)&lt;=1">(SpecimencollectionMDL): element hl7:specimenRole komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole"
         id="tmp-r-e2b01f31-744f-464a-a101-a7da6d98920a">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="string(@classCode)=('SPEC')">(SpecimencollectionMDL): de waarde van @classCode MOET 'SPEC' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="(not(hl7:specimenPlayingEntity) or hl7:specimenPlayingEntity/hl7:code/@code!='309226005' or lab:subjectOf[lab:observationEvent/lab:code/@code='384627007'])">(SpecimencollectionMDL): 
                            If type of specimen = polpy, Diameterpoliep SHALL be present
                        </assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="(not(hl7:specimenPlayingEntity) or hl7:specimenPlayingEntity/hl7:code/@code!='309226005' or lab:subjectOf[lab:observationEvent/lab:code/@code='41329004'])">(SpecimencollectionMDL): 
                            If type of specimen = polpy, Morfologie SHALL be present
                        </assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="(not(hl7:specimenPlayingEntity) or hl7:specimenPlayingEntity/hl7:code/@code!='309226005' or lab:subjectOf[lab:observationEvent/lab:code/@code='DX'])">(SpecimencollectionMDL): 
                            If type of specimen = polpy, Klinischediagnosepoliep SHALL be present
                        </assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(hl7:id)&gt;=1 ">(SpecimencollectionMDL): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(hl7:id)&lt;=1">(SpecimencollectionMDL): element hl7:id komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(hl7:specimenPlayingEntity)&lt;=1">(SpecimencollectionMDL): element hl7:specimenPlayingEntity komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='384627007'])&lt;=1">(SpecimencollectionMDL): element lab:subjectOf[lab:observationEvent/lab:code/@code='384627007'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='41329004'])&lt;=1">(SpecimencollectionMDL): element lab:subjectOf[lab:observationEvent/lab:code/@code='41329004'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='269533000'])&lt;=1">(SpecimencollectionMDL): element lab:subjectOf[lab:observationEvent/lab:code/@code='269533000'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='19132000'])&lt;=1">(SpecimencollectionMDL): element lab:subjectOf[lab:observationEvent/lab:code/@code='19132000'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='248365001'])&lt;=1">(SpecimencollectionMDL): element lab:subjectOf[lab:observationEvent/lab:code/@code='248365001'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='385300008'])&lt;=1">(SpecimencollectionMDL): element lab:subjectOf[lab:observationEvent/lab:code/@code='385300008'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='371490004'])&lt;=1">(SpecimencollectionMDL): element lab:subjectOf[lab:observationEvent/lab:code/@code='371490004'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='C145140'])&lt;=1">(SpecimencollectionMDL): element lab:subjectOf[lab:observationEvent/lab:code/@code='C145140'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='14792009'])&lt;=1">(SpecimencollectionMDL): element lab:subjectOf[lab:observationEvent/lab:code/@code='14792009'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:id
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:id"
         id="tmp-r-64b58514-46e6-4e1a-bf68-2d7fd4b2df75">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimencollectionMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity"
         id="tmp-r-bcf65659-17f1-4070-8cf8-566e83384e8f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="string(@classCode)=('ENT')">(SpecimencollectionMDL): de waarde van @classCode MOET 'ENT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(SpecimencollectionMDL): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(hl7:code)&lt;=1">(SpecimencollectionMDL): element hl7:code komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(hl7:quantity)&lt;=1">(SpecimencollectionMDL): element hl7:quantity komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(lab:asSpecimenInContainer)&lt;=1">(SpecimencollectionMDL): element lab:asSpecimenInContainer komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity/hl7:code
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity/hl7:code"
         id="tmp-r-8153f027-24b5-4912-abc9-54f5611d14a3">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimencollectionMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(SpecimencollectionMDL): de elementwaarde MOET een zijn van 'vs_monstermateriaal Monster materiaal (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(SpecimencollectionMDL): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_monstermateriaal Monster materiaal (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity/hl7:quantity
Item: (SpecimencollectionMDL)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity/lab:asSpecimenInContainer
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity/lab:asSpecimenInContainer"
         id="tmp-r-26bf7411-ca01-4ae1-bc67-82fe3336ffcd">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="string(@classCode)=('CONT')">(SpecimencollectionMDL): de waarde van @classCode MOET 'CONT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(lab:container)&gt;=1 and not(lab:container/@nullFlavor)">(SpecimencollectionMDL): element lab:container is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(lab:container)&lt;=1">(SpecimencollectionMDL): element lab:container komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity/lab:asSpecimenInContainer/lab:container
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity/lab:asSpecimenInContainer/lab:container"
         id="tmp-r-6e6ff2c4-0e27-45c8-a624-ef4c0951786d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="string(@classCode)=('CONT')">(SpecimencollectionMDL): de waarde van @classCode MOET 'CONT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(SpecimencollectionMDL): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(lab:id)&gt;=1 and not(lab:id/@nullFlavor)">(SpecimencollectionMDL): element lab:id is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(lab:id)&lt;=1">(SpecimencollectionMDL): element lab:id komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity/lab:asSpecimenInContainer/lab:container/lab:id
Item: (SpecimencollectionMDL)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf"
         id="tmp-r-742329b1-9c67-4c6c-a252-84cf93698a4c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="string(@typeCode)=('PRD')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'PRD' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess"
         id="tmp-r-568b2bdf-d1ea-444d-903e-b7fb1d9e7237">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="string(@classCode)=('SPECCOLLECT')">(SpecimencollectionMDL): de waarde van @classCode MOET 'SPECCOLLECT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="string(@moodCode)=('EVN')">(SpecimencollectionMDL): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(lab:code)&lt;=1">(SpecimencollectionMDL): element lab:code komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(lab:effectiveTime)&lt;=1">(SpecimencollectionMDL): element lab:effectiveTime komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(lab:targetSiteCode)&lt;=1">(SpecimencollectionMDL): element lab:targetSiteCode komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="count(lab:methodCode)&lt;=1">(SpecimencollectionMDL): element lab:methodCode komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code"
         id="tmp-r-78683fc4-7e8a-4c78-8bb0-e50f75dcd1d7">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimencollectionMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CD"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.13-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(SpecimencollectionMDL): de elementwaarde MOET een zijn van 'vs_verkrijgingswijze Verkrijgingswijze (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.13-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(SpecimencollectionMDL): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_verkrijgingswijze Verkrijgingswijze (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900110
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='84203001']
Item: (Manierverwijdering)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='84203001']"
         id="tmp-r-737de9f9-137c-449b-baf6-53ea53b95627">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900110-2012-04-10T000000.html"
              test="count(lab:name[(@code='84203001' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(lab:name[(@code='84203001' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Manierverwijdering): element lab:name[(@code='84203001' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900110-2012-04-10T000000.html"
              test="count(lab:name[(@code='84203001' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Manierverwijdering): element lab:name[(@code='84203001' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900110-2012-04-10T000000.html"
              test="count(lab:value)&lt;=1">(Manierverwijdering): element lab:value komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900110
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='84203001']/lab:name[(@code='84203001' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Manierverwijdering)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='84203001']/lab:name[(@code='84203001' and @codeSystem='2.16.840.1.113883.6.96')]"
         id="tmp-r-af82e32d-dc63-4174-b8dd-acf247f452ad">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900110-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Manierverwijdering): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900110-2012-04-10T000000.html"
              test="@nullFlavor or (@code='84203001' and @codeSystem='2.16.840.1.113883.6.96')">(Manierverwijdering): de elementwaarde MOET een zijn van 'code '84203001' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900110
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='84203001']/lab:value
Item: (Manierverwijdering)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='84203001']/lab:value"
         id="tmp-r-c748afed-5939-4d43-89dd-c8e3bd9b7e8a">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900110-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Manierverwijdering): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900110-2012-04-10T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.34-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(Manierverwijdering): de elementwaarde MOET een zijn van 'vs_verwijderingstechniek Verwijderingstechniek (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.34-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900110-2012-04-10T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(Manierverwijdering): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_verwijderingstechniek Verwijderingstechniek (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900111
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='272142003']
Item: (Volledigheidverwijdering)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='272142003']"
         id="tmp-r-c5efad62-d32a-4639-991b-472a8ed6bbd8">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900111-2012-04-10T000000.html"
              test="count(lab:name[(@code='272142003' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(lab:name[(@code='272142003' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Volledigheidverwijdering): element lab:name[(@code='272142003' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900111-2012-04-10T000000.html"
              test="count(lab:name[(@code='272142003' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Volledigheidverwijdering): element lab:name[(@code='272142003' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900111-2012-04-10T000000.html"
              test="count(lab:value)&lt;=1">(Volledigheidverwijdering): element lab:value komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900111
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='272142003']/lab:name[(@code='272142003' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Volledigheidverwijdering)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='272142003']/lab:name[(@code='272142003' and @codeSystem='2.16.840.1.113883.6.96')]"
         id="tmp-r-3ed6519a-cb55-4080-9581-570ddd8276d5">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900111-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Volledigheidverwijdering): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900111-2012-04-10T000000.html"
              test="@nullFlavor or (@code='272142003' and @codeSystem='2.16.840.1.113883.6.96')">(Volledigheidverwijdering): de elementwaarde MOET een zijn van 'code '272142003' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900111
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='272142003']/lab:value
Item: (Volledigheidverwijdering)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='272142003']/lab:value"
         id="tmp-r-1853c389-0650-437b-a0aa-67f758178428">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900111-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Volledigheidverwijdering): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900111-2012-04-10T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.35-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(Volledigheidverwijdering): de elementwaarde MOET een zijn van 'vs_verwijdering_compleet Verwijdering compleet (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.35-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900111-2012-04-10T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(Volledigheidverwijdering): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_verwijdering_compleet Verwijdering compleet (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:effectiveTime
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:effectiveTime"
         id="tmp-r-2729ec00-db3b-4bce-8d4e-09a62c16dcce">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimencollectionMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TS.DATE.MIN"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:targetSiteCode
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:targetSiteCode"
         id="tmp-r-69cfe2a0-36c5-4819-a4cd-9fbe535b2ca7">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimencollectionMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.23-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(SpecimencollectionMDL): de elementwaarde MOET een zijn van 'vs_lokalisatie Lokalisatie laesie bij coloscopie (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.23-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(SpecimencollectionMDL): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_lokalisatie Lokalisatie laesie bij coloscopie (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:methodCode
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:methodCode"
         id="tmp-r-79232c72-003c-4aa6-b5f7-6ce55e6a7196">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimencollectionMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.34-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(SpecimencollectionMDL): de elementwaarde MOET een zijn van 'vs_verwijderingstechniek Verwijderingstechniek (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.34-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(SpecimencollectionMDL): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_verwijderingstechniek Verwijderingstechniek (DYNAMISCH).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']
Item: (SpecimencollectionMDL)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']">
      <extends rule="tmp-r-a3ff0d50-199b-470b-8e31-23fb882334cf"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900102
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']
Item: (Diameterpoliep)
-->
   <rule id="tmp-r-a3ff0d50-199b-470b-8e31-23fb882334cf" abstract="true">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="count(lab:observationEvent)&gt;=1 and not(lab:observationEvent/@nullFlavor)">(Diameterpoliep): element lab:observationEvent is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="count(lab:observationEvent)&lt;=1">(Diameterpoliep): element lab:observationEvent komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900102
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']/lab:observationEvent
Item: (Diameterpoliep)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']/lab:observationEvent">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="string(@classCode)=('SPCOBS')">(Diameterpoliep): de waarde van @classCode MOET 'SPCOBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="string(@moodCode)=('EVN')">(Diameterpoliep): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="count(lab:code[(@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(lab:code[(@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Diameterpoliep): element lab:code[(@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="count(lab:code[(@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Diameterpoliep): element lab:code[(@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="count(lab:value)&gt;=1 ">(Diameterpoliep): element lab:value is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="count(lab:value)&lt;=1">(Diameterpoliep): element lab:value komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900102
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']/lab:observationEvent/lab:code[(@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Diameterpoliep)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']/lab:observationEvent/lab:code[(@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Diameterpoliep): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="@nullFlavor or (@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')">(Diameterpoliep): de elementwaarde MOET een zijn van 'code '384627007' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900102
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']/lab:observationEvent/lab:value
Item: (Diameterpoliep)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']/lab:observationEvent/lab:value">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PQ' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Diameterpoliep): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PQ" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="PQ"/>
      <let name="theValue" value="@value"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="(@nullFlavor or (@unit='mm'))">(Diameterpoliep): value MOET eenheid 'mm' gebruiken </assert>
      <let name="digitok"
           value="matches(string(@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="$digitok or @nullFlavor">(Diameterpoliep): @value is geen geldig PQ getal <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(Diameterpoliep): value/@unit (PQ) MOET een geldige UCUM-eenheid zijn (<value-of select="$UCUMtest"/>).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']
Item: (SpecimencollectionMDL)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']">
      <extends rule="tmp-r-d29fa030-26b4-4b53-af6d-2d3a3a7ecc97"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900109
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']
Item: (Morfologie)
-->
   <rule id="tmp-r-d29fa030-26b4-4b53-af6d-2d3a3a7ecc97" abstract="true">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="count(lab:observationEvent)&gt;=1 and not(lab:observationEvent/@nullFlavor)">(Morfologie): element lab:observationEvent is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="count(lab:observationEvent)&lt;=1">(Morfologie): element lab:observationEvent komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900109
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']/lab:observationEvent
Item: (Morfologie)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']/lab:observationEvent">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="string(@classCode)=('SPCOBS')">(Morfologie): de waarde van @classCode MOET 'SPCOBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="string(@moodCode)=('EVN')">(Morfologie): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="count(lab:code[(@code='41329004' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(lab:code[(@code='41329004' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Morfologie): element lab:code[(@code='41329004' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="count(lab:code[(@code='41329004' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Morfologie): element lab:code[(@code='41329004' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="count(lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])&gt;=1 ">(Morfologie): element lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="count(lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])&lt;=1">(Morfologie): element lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900109
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']/lab:observationEvent/lab:code[(@code='41329004' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Morfologie)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']/lab:observationEvent/lab:code[(@code='41329004' and @codeSystem='2.16.840.1.113883.6.96')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Morfologie): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="@nullFlavor or (@code='41329004' and @codeSystem='2.16.840.1.113883.6.96')">(Morfologie): de elementwaarde MOET een zijn van 'code '41329004' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900109
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']/lab:observationEvent/lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]
Item: (Morfologie)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']/lab:observationEvent/lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Morfologie): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(Morfologie): de elementwaarde MOET een zijn van 'vs_morfologie_coloscopie Morfologie coloscopie (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(Morfologie): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_morfologie_coloscopie Morfologie coloscopie (DYNAMISCH).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']
Item: (SpecimencollectionMDL)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']">
      <extends rule="tmp-r-5d310831-fe00-4c45-8677-e39904382aa9"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900106
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']
Item: (Klinischediagnosepoliep)
-->
   <rule id="tmp-r-5d310831-fe00-4c45-8677-e39904382aa9" abstract="true">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="count(lab:observationEvent)&gt;=1 and not(lab:observationEvent/@nullFlavor)">(Klinischediagnosepoliep): element lab:observationEvent is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="count(lab:observationEvent)&lt;=1">(Klinischediagnosepoliep): element lab:observationEvent komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900106
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']/lab:observationEvent
Item: (Klinischediagnosepoliep)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']/lab:observationEvent">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="string(@classCode)=('SPCOBS')">(Klinischediagnosepoliep): de waarde van @classCode MOET 'SPCOBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="string(@moodCode)=('EVN')">(Klinischediagnosepoliep): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="count(lab:code[(@code='DX' and @codeSystem='2.16.840.1.113883.5.4')])&gt;=1 and not(lab:code[(@code='DX' and @codeSystem='2.16.840.1.113883.5.4')]/@nullFlavor)">(Klinischediagnosepoliep): element lab:code[(@code='DX' and @codeSystem='2.16.840.1.113883.5.4')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="count(lab:code[(@code='DX' and @codeSystem='2.16.840.1.113883.5.4')])&lt;=1">(Klinischediagnosepoliep): element lab:code[(@code='DX' and @codeSystem='2.16.840.1.113883.5.4')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="count(lab:text)&lt;=1">(Klinischediagnosepoliep): element lab:text komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="count(lab:value)&lt;=1">(Klinischediagnosepoliep): element lab:value komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900106
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']/lab:observationEvent/lab:code[(@code='DX' and @codeSystem='2.16.840.1.113883.5.4')]
Item: (Klinischediagnosepoliep)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']/lab:observationEvent/lab:code[(@code='DX' and @codeSystem='2.16.840.1.113883.5.4')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Klinischediagnosepoliep): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="@nullFlavor or (@code='DX' and @codeSystem='2.16.840.1.113883.5.4')">(Klinischediagnosepoliep): de elementwaarde MOET een zijn van 'code 'DX' codeSystem '2.16.840.1.113883.5.4''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900107
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']/lab:observationEvent/lab:text
Item: (Overigeklinischediagnosepoliep)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']/lab:observationEvent/lab:text">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900107-2012-10-30T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ST' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Overigeklinischediagnosepoliep): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="ST"/>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900106
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']/lab:observationEvent/lab:value
Item: (Klinischediagnosepoliep)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']/lab:observationEvent/lab:value">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Klinischediagnosepoliep): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.30-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(Klinischediagnosepoliep): de elementwaarde MOET een zijn van 'vs_klindiag_coloscopie Klinische diagnose coloscopie (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.30-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(Klinischediagnosepoliep): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_klindiag_coloscopie Klinische diagnose coloscopie (DYNAMISCH).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='269533000']
Item: (SpecimencollectionMDL)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='269533000']">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.339
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='269533000']
Item: (Carcinoom)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.339
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='269533000']/lab:observationEvent
Item: (Carcinoom)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='269533000']/lab:observationEvent">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.339-2013-03-08T000000.html"
              test="string(@classCode)=('SPCOBS')">(Carcinoom): de waarde van @classCode MOET 'SPCOBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.339-2013-03-08T000000.html"
              test="string(@moodCode)=('EVN')">(Carcinoom): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.339-2013-03-08T000000.html"
              test="count(lab:code[(@code='269533000' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(lab:code[(@code='269533000' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Carcinoom): element lab:code[(@code='269533000' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.339-2013-03-08T000000.html"
              test="count(lab:code[(@code='269533000' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Carcinoom): element lab:code[(@code='269533000' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.339
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='269533000']/lab:observationEvent/lab:code[(@code='269533000' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Carcinoom)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='269533000']/lab:observationEvent/lab:code[(@code='269533000' and @codeSystem='2.16.840.1.113883.6.96')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.339-2013-03-08T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Carcinoom): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.339-2013-03-08T000000.html"
              test="@nullFlavor or (@code='269533000' and @codeSystem='2.16.840.1.113883.6.96')">(Carcinoom): de elementwaarde MOET een zijn van 'code '269533000' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='19132000']
Item: (SpecimencollectionMDL)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='19132000']">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.424
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='19132000']
Item: (Stenosis)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.424
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='19132000']/lab:observationEvent
Item: (Stenosis)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='19132000']/lab:observationEvent">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.424-2013-03-08T000000.html"
              test="string(@classCode)=('SPCOBS')">(Stenosis): de waarde van @classCode MOET 'SPCOBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.424-2013-03-08T000000.html"
              test="string(@moodCode)=('EVN')">(Stenosis): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.424-2013-03-08T000000.html"
              test="count(lab:code[(@code='19132000' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(lab:code[(@code='19132000' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Stenosis): element lab:code[(@code='19132000' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.424-2013-03-08T000000.html"
              test="count(lab:code[(@code='19132000' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Stenosis): element lab:code[(@code='19132000' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.424
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='19132000']/lab:observationEvent/lab:code[(@code='19132000' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Stenosis)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='19132000']/lab:observationEvent/lab:code[(@code='19132000' and @codeSystem='2.16.840.1.113883.6.96')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.424-2013-03-08T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Stenosis): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.424-2013-03-08T000000.html"
              test="@nullFlavor or (@code='19132000' and @codeSystem='2.16.840.1.113883.6.96')">(Stenosis): de elementwaarde MOET een zijn van 'code '19132000' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='248365001']
Item: (SpecimencollectionMDL)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='248365001']">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.425
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='248365001']
Item: (Circumferencemeasure)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.425
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='248365001']/lab:observationEvent
Item: (Circumferencemeasure)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='248365001']/lab:observationEvent">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.425-2014-02-09T000000.html"
              test="string(@classCode)=('SPCOBS')">(Circumferencemeasure): de waarde van @classCode MOET 'SPCOBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.425-2014-02-09T000000.html"
              test="string(@moodCode)=('EVN')">(Circumferencemeasure): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.425-2014-02-09T000000.html"
              test="count(lab:code[(@code='248365001' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(lab:code[(@code='248365001' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Circumferencemeasure): element lab:code[(@code='248365001' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.425-2014-02-09T000000.html"
              test="count(lab:code[(@code='248365001' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Circumferencemeasure): element lab:code[(@code='248365001' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.425-2014-02-09T000000.html"
              test="count(lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.225-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.225-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])&gt;=1 ">(Circumferencemeasure): element lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.225-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.225-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.425-2014-02-09T000000.html"
              test="count(lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.225-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.225-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])&lt;=1">(Circumferencemeasure): element lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.225-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.225-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.425
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='248365001']/lab:observationEvent/lab:code[(@code='248365001' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Circumferencemeasure)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='248365001']/lab:observationEvent/lab:code[(@code='248365001' and @codeSystem='2.16.840.1.113883.6.96')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.425-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Circumferencemeasure): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.425-2014-02-09T000000.html"
              test="@nullFlavor or (@code='248365001' and @codeSystem='2.16.840.1.113883.6.96')">(Circumferencemeasure): de elementwaarde MOET een zijn van 'code '248365001' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.425
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='248365001']/lab:observationEvent/lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.225-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.225-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]
Item: (Circumferencemeasure)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='248365001']/lab:observationEvent/lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.225-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.225-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.425-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Circumferencemeasure): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.425-2014-02-09T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.225-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(Circumferencemeasure): de elementwaarde MOET een zijn van 'vs_stenosiscircumference Stenosis circumference (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.225-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.425-2014-02-09T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(Circumferencemeasure): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_stenosiscircumference Stenosis circumference (DYNAMISCH).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='385300008']
Item: (SpecimencollectionMDL)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='385300008']">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.426
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='385300008']
Item: (Linearextent)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.426
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='385300008']/lab:observationEvent
Item: (Linearextent)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='385300008']/lab:observationEvent">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.426-2013-03-08T000000.html"
              test="string(@classCode)=('SPCOBS')">(Linearextent): de waarde van @classCode MOET 'SPCOBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.426-2013-03-08T000000.html"
              test="string(@moodCode)=('EVN')">(Linearextent): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.426-2013-03-08T000000.html"
              test="count(lab:code[(@code='385300008' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(lab:code[(@code='385300008' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Linearextent): element lab:code[(@code='385300008' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.426-2013-03-08T000000.html"
              test="count(lab:code[(@code='385300008' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Linearextent): element lab:code[(@code='385300008' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.426-2013-03-08T000000.html"
              test="count(lab:value)&gt;=1 ">(Linearextent): element lab:value is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.426-2013-03-08T000000.html"
              test="count(lab:value)&lt;=1">(Linearextent): element lab:value komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.426
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='385300008']/lab:observationEvent/lab:code[(@code='385300008' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Linearextent)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='385300008']/lab:observationEvent/lab:code[(@code='385300008' and @codeSystem='2.16.840.1.113883.6.96')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.426-2013-03-08T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Linearextent): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.426-2013-03-08T000000.html"
              test="@nullFlavor or (@code='385300008' and @codeSystem='2.16.840.1.113883.6.96')">(Linearextent): de elementwaarde MOET een zijn van 'code '385300008' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.426
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='385300008']/lab:observationEvent/lab:value
Item: (Linearextent)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='385300008']/lab:observationEvent/lab:value">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.426-2013-03-08T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PQ' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Linearextent): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PQ" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="PQ"/>
      <let name="theValue" value="@value"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.426-2013-03-08T000000.html"
              test="(@nullFlavor or (@unit='cm'))">(Linearextent): value MOET eenheid 'cm' gebruiken </assert>
      <let name="digitok"
           value="matches(string(@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.426-2013-03-08T000000.html"
              test="$digitok or @nullFlavor">(Linearextent): @value is geen geldig PQ getal <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.426-2013-03-08T000000.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(Linearextent): value/@unit (PQ) MOET een geldige UCUM-eenheid zijn (<value-of select="$UCUMtest"/>).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']
Item: (SpecimencollectionMDL)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']">
      <extends rule="tmp-r-d0dcd3a2-ec58-4d0c-be32-6060629717db"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900120
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']
Item: (Distanceoftumorfromanalverge)
-->
   <rule id="tmp-r-d0dcd3a2-ec58-4d0c-be32-6060629717db" abstract="true">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="count(lab:observationEvent)&gt;=1 and not(lab:observationEvent/@nullFlavor)">(Distanceoftumorfromanalverge): element lab:observationEvent is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="count(lab:observationEvent)&lt;=1">(Distanceoftumorfromanalverge): element lab:observationEvent komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900120
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent
Item: (Distanceoftumorfromanalverge)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="string(@classCode)=('SPCOBS')">(Distanceoftumorfromanalverge): de waarde van @classCode MOET 'SPCOBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="string(@moodCode)=('EVN')">(Distanceoftumorfromanalverge): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="count(lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Distanceoftumorfromanalverge): element lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="count(lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Distanceoftumorfromanalverge): element lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="count(lab:value)&gt;=1 ">(Distanceoftumorfromanalverge): element lab:value is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="count(lab:value)&lt;=1">(Distanceoftumorfromanalverge): element lab:value komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900120
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent/lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Distanceoftumorfromanalverge)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent/lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Distanceoftumorfromanalverge): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="@nullFlavor or (@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')">(Distanceoftumorfromanalverge): de elementwaarde MOET een zijn van 'code '371490004' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900120
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent/lab:value
Item: (Distanceoftumorfromanalverge)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent/lab:value">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PQ' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Distanceoftumorfromanalverge): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PQ" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="PQ"/>
      <let name="theValue" value="@value"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="(@nullFlavor or (@unit='cm' and number($theValue)&gt;=0 and number($theValue)&lt;=200))">(Distanceoftumorfromanalverge): value MOET eenheid 'cm' gebruiken en in bereik [0..200] liggen  </assert>
      <let name="digitok"
           value="matches(string(@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="$digitok or @nullFlavor">(Distanceoftumorfromanalverge): @value is geen geldig PQ getal <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(Distanceoftumorfromanalverge): value/@unit (PQ) MOET een geldige UCUM-eenheid zijn (<value-of select="$UCUMtest"/>).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']
Item: (SpecimencollectionMDL)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.427
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']
Item: (Carcinomapassable)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.427
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']/lab:observationEvent
Item: (Carcinomapassable)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']/lab:observationEvent">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.427-2013-03-08T000000.html"
              test="string(@classCode)=('SPCOBS')">(Carcinomapassable): de waarde van @classCode MOET 'SPCOBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.427-2013-03-08T000000.html"
              test="string(@moodCode)=('EVN')">(Carcinomapassable): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.427-2013-03-08T000000.html"
              test="count(lab:code[(@code='C145140' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')])&gt;=1 and not(lab:code[(@code='C145140' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]/@nullFlavor)">(Carcinomapassable): element lab:code[(@code='C145140' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.427-2013-03-08T000000.html"
              test="count(lab:code[(@code='C145140' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')])&lt;=1">(Carcinomapassable): element lab:code[(@code='C145140' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.427-2013-03-08T000000.html"
              test="count(lab:value)&gt;=1 ">(Carcinomapassable): element lab:value is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.427-2013-03-08T000000.html"
              test="count(lab:value)&lt;=1">(Carcinomapassable): element lab:value komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.427
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']/lab:observationEvent/lab:code[(@code='C145140' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]
Item: (Carcinomapassable)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']/lab:observationEvent/lab:code[(@code='C145140' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.427-2013-03-08T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Carcinomapassable): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.427-2013-03-08T000000.html"
              test="@nullFlavor or (@code='C145140' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')">(Carcinomapassable): de elementwaarde MOET een zijn van 'code 'C145140' codeSystem '2.16.840.1.113883.2.4.3.36.77.5.200''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.427
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']/lab:observationEvent/lab:value
Item: (Carcinomapassable)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']/lab:observationEvent/lab:value">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.427-2013-03-08T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='BL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Carcinomapassable): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:BL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="BL"/>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']
Item: (SpecimencollectionMDL)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900118
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']
Item: (Tattooing)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900118
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']/lab:observationEvent
Item: (Tattooing)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']/lab:observationEvent">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900118-2012-04-10T000000.html"
              test="string(@classCode)=('SPCOBS')">(Tattooing): de waarde van @classCode MOET 'SPCOBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900118-2012-04-10T000000.html"
              test="string(@moodCode)=('EVN')">(Tattooing): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900118-2012-04-10T000000.html"
              test="count(lab:code[(@code='14792009' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(lab:code[(@code='14792009' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Tattooing): element lab:code[(@code='14792009' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900118-2012-04-10T000000.html"
              test="count(lab:code[(@code='14792009' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Tattooing): element lab:code[(@code='14792009' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900118-2012-04-10T000000.html"
              test="count(lab:value)&gt;=1 ">(Tattooing): element lab:value is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900118-2012-04-10T000000.html"
              test="count(lab:value)&lt;=1">(Tattooing): element lab:value komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900118
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']/lab:observationEvent/lab:code[(@code='14792009' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Tattooing)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']/lab:observationEvent/lab:code[(@code='14792009' and @codeSystem='2.16.840.1.113883.6.96')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900118-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Tattooing): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900118-2012-04-10T000000.html"
              test="@nullFlavor or (@code='14792009' and @codeSystem='2.16.840.1.113883.6.96')">(Tattooing): de elementwaarde MOET een zijn van 'code '14792009' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900118
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']/lab:observationEvent/lab:value
Item: (Tattooing)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']/lab:observationEvent/lab:value">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900118-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='BL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Tattooing): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:BL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="BL"/>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.336']]
Item: (SpecimencollectionMDL)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.336']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2012-07-10T000000.html"
              test="string(@typeCode)=('COMP')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'COMP' zijn.</assert>
   </rule>
</pattern>
