<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.36.10.333
Name: Specimen collection
Description: Template: Specimen collection
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000">
   <title>Specimen collection</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]"
         id="tmp-r-6181f463-3fae-4a1d-8f2d-02060daec37b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333'])&gt;=1 and not(hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/@nullFlavor)">(SpecimencollectionMDL): element hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333'])&lt;=1">(SpecimencollectionMDL): element hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']"
         id="tmp-r-c124c5f2-aaad-4c6f-a0b9-93d19e5e83fa">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="string(@classCode)=('ACT')">(SpecimencollectionMDL): de waarde van @classCode MOET 'ACT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="string(@moodCode)=('EVN')">(SpecimencollectionMDL): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.333'])&gt;=1 ">(SpecimencollectionMDL): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.333'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.333'])&lt;=1">(SpecimencollectionMDL): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.333'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')])&gt;=1 and not(hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')]/@nullFlavor)">(SpecimencollectionMDL): element hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')])&lt;=1">(SpecimencollectionMDL): element hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(hl7:specimen)&gt;=1 and not(hl7:specimen/@nullFlavor)">(SpecimencollectionMDL): element hl7:specimen is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(hl7:specimen)&lt;=1">(SpecimencollectionMDL): element hl7:specimen komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.333']
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.333']"
         id="tmp-r-fac22aea-44de-488d-93e7-2b0475a4db74">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimencollectionMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="string(@root)=('2.16.840.1.113883.2.4.3.36.10.333')">(SpecimencollectionMDL): de waarde van @root MOET '2.16.840.1.113883.2.4.3.36.10.333' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')]
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')]"
         id="tmp-r-8380e9a9-35a6-4caa-9d97-e37ea83242ec">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimencollectionMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="@nullFlavor or (@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')">(SpecimencollectionMDL): de elementwaarde MOET een zijn van 'code 'X-LAB-SPMSCT' codeSystem '2.16.840.1.113883.6.1''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen"
         id="tmp-r-04ddf1d0-414c-4ad3-9f07-2d24f26ac3c3">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="string(@typeCode)=('SPC')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SPC' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(hl7:specimenRole)&gt;=1 and not(hl7:specimenRole/@nullFlavor)">(SpecimencollectionMDL): element hl7:specimenRole is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(hl7:specimenRole)&lt;=1">(SpecimencollectionMDL): element hl7:specimenRole komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole"
         id="tmp-r-e1047c7a-a934-4a40-8cdc-a8e11c0a0fb1">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="string(@classCode)=('SPEC')">(SpecimencollectionMDL): de waarde van @classCode MOET 'SPEC' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="(not(hl7:specimenPlayingEntity) or hl7:specimenPlayingEntity/hl7:code/@code!='309226005' or lab:subjectOf[lab:observationEvent/lab:code/@code='384627007'])">(SpecimencollectionMDL): 
                            If type of specimen = polpy, Diameterpoliep SHALL be present
                        </assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="(not(hl7:specimenPlayingEntity) or hl7:specimenPlayingEntity/hl7:code/@code!='309226005' or lab:subjectOf[lab:observationEvent/lab:code/@code='41329004'])">(SpecimencollectionMDL): 
                            If type of specimen = polpy, Morfologie SHALL be present
                        </assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="(not(hl7:specimenPlayingEntity) or hl7:specimenPlayingEntity/hl7:code/@code!='309226005' or lab:subjectOf[lab:observationEvent/lab:code/@code='DX'])">(SpecimencollectionMDL): 
                            If type of specimen = polpy, Klinischediagnosepoliep SHALL be present
                        </assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(hl7:id)&gt;=1 ">(SpecimencollectionMDL): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(hl7:id)&lt;=1">(SpecimencollectionMDL): element hl7:id komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(hl7:specimenPlayingEntity)&lt;=1">(SpecimencollectionMDL): element hl7:specimenPlayingEntity komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='C145061'])&lt;=1">(SpecimencollectionMDL): element lab:subjectOf[lab:observationEvent/lab:code/@code='C145061'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='384627007'])&lt;=1">(SpecimencollectionMDL): element lab:subjectOf[lab:observationEvent/lab:code/@code='384627007'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='41329004'])&lt;=1">(SpecimencollectionMDL): element lab:subjectOf[lab:observationEvent/lab:code/@code='41329004'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='DX'])&gt;=1 ">(SpecimencollectionMDL): element lab:subjectOf[lab:observationEvent/lab:code/@code='DX'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='DX'])&lt;=1">(SpecimencollectionMDL): element lab:subjectOf[lab:observationEvent/lab:code/@code='DX'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='269533000'])&lt;=1">(SpecimencollectionMDL): element lab:subjectOf[lab:observationEvent/lab:code/@code='269533000'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='19132000'])&lt;=1">(SpecimencollectionMDL): element lab:subjectOf[lab:observationEvent/lab:code/@code='19132000'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='248365001'])&lt;=1">(SpecimencollectionMDL): element lab:subjectOf[lab:observationEvent/lab:code/@code='248365001'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='385300008'])&lt;=1">(SpecimencollectionMDL): element lab:subjectOf[lab:observationEvent/lab:code/@code='385300008'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='371490004'])&lt;=1">(SpecimencollectionMDL): element lab:subjectOf[lab:observationEvent/lab:code/@code='371490004'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='C145140'])&lt;=1">(SpecimencollectionMDL): element lab:subjectOf[lab:observationEvent/lab:code/@code='C145140'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='14792009'])&lt;=1">(SpecimencollectionMDL): element lab:subjectOf[lab:observationEvent/lab:code/@code='14792009'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:id
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:id"
         id="tmp-r-36a8db0f-d65a-458a-ba55-56d183104dec">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimencollectionMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity"
         id="tmp-r-c343f817-2b12-4afd-9431-bc5e8ffc0c4e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="string(@classCode)=('ENT')">(SpecimencollectionMDL): de waarde van @classCode MOET 'ENT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(SpecimencollectionMDL): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(hl7:code)&lt;=1">(SpecimencollectionMDL): element hl7:code komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(hl7:quantity)&lt;=1">(SpecimencollectionMDL): element hl7:quantity komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(lab:asSpecimenInContainer)&lt;=1">(SpecimencollectionMDL): element lab:asSpecimenInContainer komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity/hl7:code
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity/hl7:code"
         id="tmp-r-17c5ac00-61aa-495d-9838-913489c80b53">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimencollectionMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(SpecimencollectionMDL): de elementwaarde MOET een zijn van 'vs_monstermateriaal Monster materiaal (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(SpecimencollectionMDL): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_monstermateriaal Monster materiaal (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity/hl7:quantity
Item: (SpecimencollectionMDL)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity/lab:asSpecimenInContainer
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity/lab:asSpecimenInContainer"
         id="tmp-r-46b0875c-f1c6-4cd1-b222-e24d71814a15">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="string(@classCode)=('CONT')">(SpecimencollectionMDL): de waarde van @classCode MOET 'CONT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(lab:container)&gt;=1 and not(lab:container/@nullFlavor)">(SpecimencollectionMDL): element lab:container is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(lab:container)&lt;=1">(SpecimencollectionMDL): element lab:container komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity/lab:asSpecimenInContainer/lab:container
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity/lab:asSpecimenInContainer/lab:container"
         id="tmp-r-a72f4cef-f921-48f0-b9b5-adf6024a03cd">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="string(@classCode)=('CONT')">(SpecimencollectionMDL): de waarde van @classCode MOET 'CONT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(SpecimencollectionMDL): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(lab:id)&gt;=1 ">(SpecimencollectionMDL): element lab:id is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(lab:id)&lt;=1">(SpecimencollectionMDL): element lab:id komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity/lab:asSpecimenInContainer/lab:container/lab:id
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/hl7:specimenPlayingEntity/lab:asSpecimenInContainer/lab:container/lab:id"
         id="tmp-r-d35d58f8-f61e-492e-8e94-a8baa52aabe1">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="@extension">(SpecimencollectionMDL): attribute @extension MOET aanwezig zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="string(@nullFlavor)=('UNC')">(SpecimencollectionMDL): de waarde van @nullFlavor MOET 'UNC' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf"
         id="tmp-r-9c2c1103-249f-4dbf-9285-d447db5df3c4">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="string(@typeCode)=('PRD')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'PRD' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess"
         id="tmp-r-ace97d0d-e7b9-4715-99ce-096fcbdef139">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="string(@classCode)=('SPECCOLLECT')">(SpecimencollectionMDL): de waarde van @classCode MOET 'SPECCOLLECT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="string(@moodCode)=('EVN')">(SpecimencollectionMDL): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(lab:code)&lt;=1">(SpecimencollectionMDL): element lab:code komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(lab:targetSiteCode)&lt;=1">(SpecimencollectionMDL): element lab:targetSiteCode komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(lab:methodCode)&lt;=1">(SpecimencollectionMDL): element lab:methodCode komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code"
         id="tmp-r-0245e883-1867-4b9c-b9fa-ba05638e782b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimencollectionMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CD"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.13-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(SpecimencollectionMDL): de elementwaarde MOET een zijn van 'vs_verkrijgingswijze Verkrijgingswijze (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.13-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(SpecimencollectionMDL): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_verkrijgingswijze Verkrijgingswijze (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900110
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='84203001']
Item: (Manierverwijdering)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='84203001']"
         id="tmp-r-ab83aed5-e45a-4c41-b883-6359aa50b6fd">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900110-2012-04-10T000000.html"
              test="count(lab:name[(@code='84203001' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(lab:name[(@code='84203001' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Manierverwijdering): element lab:name[(@code='84203001' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900110-2012-04-10T000000.html"
              test="count(lab:name[(@code='84203001' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Manierverwijdering): element lab:name[(@code='84203001' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900110-2012-04-10T000000.html"
              test="count(lab:value)&lt;=1">(Manierverwijdering): element lab:value komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900110
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='84203001']/lab:name[(@code='84203001' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Manierverwijdering)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='84203001']/lab:name[(@code='84203001' and @codeSystem='2.16.840.1.113883.6.96')]"
         id="tmp-r-9f2368b7-c53d-47c8-91a0-54e9ec58d4a9">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900110-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Manierverwijdering): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900110-2012-04-10T000000.html"
              test="@nullFlavor or (@code='84203001' and @codeSystem='2.16.840.1.113883.6.96')">(Manierverwijdering): de elementwaarde MOET een zijn van 'code '84203001' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900110
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='84203001']/lab:value
Item: (Manierverwijdering)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='84203001']/lab:value"
         id="tmp-r-5f3c2e28-eb05-43d7-a92a-e5e26c399fc8">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900110-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Manierverwijdering): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900110-2012-04-10T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.34-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(Manierverwijdering): de elementwaarde MOET een zijn van 'vs_verwijderingstechniek Verwijderingstechniek (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.34-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900110-2012-04-10T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(Manierverwijdering): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_verwijderingstechniek Verwijderingstechniek (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900111
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='272142003']
Item: (Volledigheidverwijdering)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='272142003']"
         id="tmp-r-a134036b-ebd7-4a38-b4e0-a1c5a8239bfa">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900111-2012-04-10T000000.html"
              test="count(lab:name[(@code='272142003' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(lab:name[(@code='272142003' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Volledigheidverwijdering): element lab:name[(@code='272142003' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900111-2012-04-10T000000.html"
              test="count(lab:name[(@code='272142003' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Volledigheidverwijdering): element lab:name[(@code='272142003' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900111-2012-04-10T000000.html"
              test="count(lab:value)&lt;=1">(Volledigheidverwijdering): element lab:value komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900111
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='272142003']/lab:name[(@code='272142003' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Volledigheidverwijdering)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='272142003']/lab:name[(@code='272142003' and @codeSystem='2.16.840.1.113883.6.96')]"
         id="tmp-r-396cc3aa-0a2f-4908-bc5a-7b5fb18bd27d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900111-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Volledigheidverwijdering): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900111-2012-04-10T000000.html"
              test="@nullFlavor or (@code='272142003' and @codeSystem='2.16.840.1.113883.6.96')">(Volledigheidverwijdering): de elementwaarde MOET een zijn van 'code '272142003' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900111
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='272142003']/lab:value
Item: (Volledigheidverwijdering)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:code/lab:qualifier[lab:name/@code='272142003']/lab:value"
         id="tmp-r-c7b0a277-8b9a-4653-8d18-8b179e13a92a">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900111-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Volledigheidverwijdering): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900111-2012-04-10T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.35-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(Volledigheidverwijdering): de elementwaarde MOET een zijn van 'vs_verwijdering_compleet Verwijdering compleet (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.35-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900111-2012-04-10T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(Volledigheidverwijdering): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_verwijdering_compleet Verwijdering compleet (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:targetSiteCode
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:targetSiteCode"
         id="tmp-r-a8a6934c-bc73-4096-ab2e-e65132cecaf6">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimencollectionMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.23-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(SpecimencollectionMDL): de elementwaarde MOET een zijn van 'vs_lokalisatie Lokalisatie laesie bij coloscopie (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.23-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(SpecimencollectionMDL): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_lokalisatie Lokalisatie laesie bij coloscopie (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:methodCode
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:methodCode"
         id="tmp-r-9b396845-f9df-426e-ad89-eae6162c300b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimencollectionMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.34-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(SpecimencollectionMDL): de elementwaarde MOET een zijn van 'vs_verwijderingstechniek Verwijderingstechniek (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.34-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(SpecimencollectionMDL): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_verwijderingstechniek Verwijderingstechniek (DYNAMISCH).</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="count(lab:originalText)&lt;=1">(SpecimencollectionMDL): element lab:originalText komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:methodCode/lab:originalText
Item: (SpecimencollectionMDL)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:productOf/lab:specimenCollectionProcess/lab:methodCode/lab:originalText"
         id="tmp-r-0493473c-b97d-4afb-a3f2-faf614241660">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ST' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimencollectionMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="ST"/>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145061']
Item: (SpecimencollectionMDL)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145061']">
      <extends rule="tmp-r-44cef702-9019-4437-bf00-8023be377e52"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.348
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145061']
Item: (Distancefromanalvergelesion)
-->
   <rule id="tmp-r-44cef702-9019-4437-bf00-8023be377e52" abstract="true">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.348-2014-02-09T000000.html"
              test="count(lab:observationEvent)&gt;=1 and not(lab:observationEvent/@nullFlavor)">(Distancefromanalvergelesion): element lab:observationEvent is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.348-2014-02-09T000000.html"
              test="count(lab:observationEvent)&lt;=1">(Distancefromanalvergelesion): element lab:observationEvent komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.348
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145061']/lab:observationEvent
Item: (Distancefromanalvergelesion)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145061']/lab:observationEvent">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.348-2014-02-09T000000.html"
              test="string(@classCode)=('SPCOBS')">(Distancefromanalvergelesion): de waarde van @classCode MOET 'SPCOBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.348-2014-02-09T000000.html"
              test="string(@moodCode)=('EVN')">(Distancefromanalvergelesion): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.348-2014-02-09T000000.html"
              test="count(lab:code[(@code='C145061' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')])&gt;=1 and not(lab:code[(@code='C145061' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]/@nullFlavor)">(Distancefromanalvergelesion): element lab:code[(@code='C145061' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.348-2014-02-09T000000.html"
              test="count(lab:code[(@code='C145061' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')])&lt;=1">(Distancefromanalvergelesion): element lab:code[(@code='C145061' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.348-2014-02-09T000000.html"
              test="count(lab:value)&gt;=1 ">(Distancefromanalvergelesion): element lab:value is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.348-2014-02-09T000000.html"
              test="count(lab:value)&lt;=1">(Distancefromanalvergelesion): element lab:value komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.348
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145061']/lab:observationEvent/lab:code[(@code='C145061' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]
Item: (Distancefromanalvergelesion)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145061']/lab:observationEvent/lab:code[(@code='C145061' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.348-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Distancefromanalvergelesion): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.348-2014-02-09T000000.html"
              test="@nullFlavor or (@code='C145061' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')">(Distancefromanalvergelesion): de elementwaarde MOET een zijn van 'code 'C145061' codeSystem '2.16.840.1.113883.2.4.3.36.77.5.200''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.348
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145061']/lab:observationEvent/lab:value
Item: (Distancefromanalvergelesion)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145061']/lab:observationEvent/lab:value">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.348-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PQ' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Distancefromanalvergelesion): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PQ" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="PQ"/>
      <let name="theValue" value="@value"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.348-2014-02-09T000000.html"
              test="(@nullFlavor or (@unit='cm' and number($theValue)&gt;=1 and number($theValue)&lt;=200))">(Distancefromanalvergelesion): value MOET eenheid 'cm' gebruiken en in bereik [1..200] liggen  </assert>
      <let name="digitok"
           value="matches(string(@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.348-2014-02-09T000000.html"
              test="$digitok or @nullFlavor">(Distancefromanalvergelesion): @value is geen geldig PQ getal <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.348-2014-02-09T000000.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(Distancefromanalvergelesion): value/@unit (PQ) MOET een geldige UCUM-eenheid zijn (<value-of select="$UCUMtest"/>).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']
Item: (SpecimencollectionMDL)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']">
      <extends rule="tmp-r-922e7557-5a63-447a-8c5d-7fbcb0ce2b9a"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900102
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']
Item: (Diameterpoliep)
-->
   <rule id="tmp-r-922e7557-5a63-447a-8c5d-7fbcb0ce2b9a" abstract="true">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="count(lab:observationEvent)&gt;=1 and not(lab:observationEvent/@nullFlavor)">(Diameterpoliep): element lab:observationEvent is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="count(lab:observationEvent)&lt;=1">(Diameterpoliep): element lab:observationEvent komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900102
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']/lab:observationEvent
Item: (Diameterpoliep)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']/lab:observationEvent">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="string(@classCode)=('SPCOBS')">(Diameterpoliep): de waarde van @classCode MOET 'SPCOBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="string(@moodCode)=('EVN')">(Diameterpoliep): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="count(lab:code[(@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(lab:code[(@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Diameterpoliep): element lab:code[(@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="count(lab:code[(@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Diameterpoliep): element lab:code[(@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="count(lab:value)&gt;=1 ">(Diameterpoliep): element lab:value is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="count(lab:value)&lt;=1">(Diameterpoliep): element lab:value komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900102
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']/lab:observationEvent/lab:code[(@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Diameterpoliep)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']/lab:observationEvent/lab:code[(@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Diameterpoliep): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="@nullFlavor or (@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')">(Diameterpoliep): de elementwaarde MOET een zijn van 'code '384627007' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900102
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']/lab:observationEvent/lab:value
Item: (Diameterpoliep)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='384627007']/lab:observationEvent/lab:value">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PQ' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Diameterpoliep): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PQ" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="PQ"/>
      <let name="theValue" value="@value"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="(@nullFlavor or (@unit='mm'))">(Diameterpoliep): value MOET eenheid 'mm' gebruiken </assert>
      <let name="digitok"
           value="matches(string(@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="$digitok or @nullFlavor">(Diameterpoliep): @value is geen geldig PQ getal <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900102-2012-04-10T000000.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(Diameterpoliep): value/@unit (PQ) MOET een geldige UCUM-eenheid zijn (<value-of select="$UCUMtest"/>).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']
Item: (SpecimencollectionMDL)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']">
      <extends rule="tmp-r-406c76c9-0961-450c-a67e-935c9213ea6e"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900109
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']
Item: (Morfologie)
-->
   <rule id="tmp-r-406c76c9-0961-450c-a67e-935c9213ea6e" abstract="true">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="count(lab:observationEvent)&gt;=1 and not(lab:observationEvent/@nullFlavor)">(Morfologie): element lab:observationEvent is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="count(lab:observationEvent)&lt;=1">(Morfologie): element lab:observationEvent komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900109
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']/lab:observationEvent
Item: (Morfologie)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']/lab:observationEvent">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="string(@classCode)=('SPCOBS')">(Morfologie): de waarde van @classCode MOET 'SPCOBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="string(@moodCode)=('EVN')">(Morfologie): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="count(lab:code[(@code='41329004' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(lab:code[(@code='41329004' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Morfologie): element lab:code[(@code='41329004' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="count(lab:code[(@code='41329004' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Morfologie): element lab:code[(@code='41329004' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="count(lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])&gt;=1 ">(Morfologie): element lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="count(lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])&lt;=1">(Morfologie): element lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900109
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']/lab:observationEvent/lab:code[(@code='41329004' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Morfologie)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']/lab:observationEvent/lab:code[(@code='41329004' and @codeSystem='2.16.840.1.113883.6.96')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Morfologie): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="@nullFlavor or (@code='41329004' and @codeSystem='2.16.840.1.113883.6.96')">(Morfologie): de elementwaarde MOET een zijn van 'code '41329004' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900109
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']/lab:observationEvent/lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]
Item: (Morfologie)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='41329004']/lab:observationEvent/lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Morfologie): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(Morfologie): de elementwaarde MOET een zijn van 'vs_morfologie_coloscopie Morfologie coloscopie (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.29-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900109-2012-04-10T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(Morfologie): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_morfologie_coloscopie Morfologie coloscopie (DYNAMISCH).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']
Item: (SpecimencollectionMDL)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']">
      <extends rule="tmp-r-1a19ecb5-a984-4f5d-b2b9-ae85e90aff04"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900106
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']
Item: (Klinischediagnosepoliep)
-->
   <rule id="tmp-r-1a19ecb5-a984-4f5d-b2b9-ae85e90aff04" abstract="true">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="count(lab:observationEvent)&gt;=1 and not(lab:observationEvent/@nullFlavor)">(Klinischediagnosepoliep): element lab:observationEvent is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="count(lab:observationEvent)&lt;=1">(Klinischediagnosepoliep): element lab:observationEvent komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900106
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']/lab:observationEvent
Item: (Klinischediagnosepoliep)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']/lab:observationEvent">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="string(@classCode)=('SPCOBS')">(Klinischediagnosepoliep): de waarde van @classCode MOET 'SPCOBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="string(@moodCode)=('EVN')">(Klinischediagnosepoliep): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="count(lab:code[(@code='DX' and @codeSystem='2.16.840.1.113883.5.4')])&gt;=1 and not(lab:code[(@code='DX' and @codeSystem='2.16.840.1.113883.5.4')]/@nullFlavor)">(Klinischediagnosepoliep): element lab:code[(@code='DX' and @codeSystem='2.16.840.1.113883.5.4')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="count(lab:code[(@code='DX' and @codeSystem='2.16.840.1.113883.5.4')])&lt;=1">(Klinischediagnosepoliep): element lab:code[(@code='DX' and @codeSystem='2.16.840.1.113883.5.4')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="count(lab:text)&lt;=1">(Klinischediagnosepoliep): element lab:text komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="count(lab:value)&lt;=1">(Klinischediagnosepoliep): element lab:value komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900106
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']/lab:observationEvent/lab:code[(@code='DX' and @codeSystem='2.16.840.1.113883.5.4')]
Item: (Klinischediagnosepoliep)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']/lab:observationEvent/lab:code[(@code='DX' and @codeSystem='2.16.840.1.113883.5.4')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Klinischediagnosepoliep): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="@nullFlavor or (@code='DX' and @codeSystem='2.16.840.1.113883.5.4')">(Klinischediagnosepoliep): de elementwaarde MOET een zijn van 'code 'DX' codeSystem '2.16.840.1.113883.5.4''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900107
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']/lab:observationEvent/lab:text
Item: (Overigeklinischediagnosepoliep)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']/lab:observationEvent/lab:text">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900107-2012-10-30T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ST' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Overigeklinischediagnosepoliep): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="ST"/>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900106
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']/lab:observationEvent/lab:value
Item: (Klinischediagnosepoliep)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='DX']/lab:observationEvent/lab:value">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Klinischediagnosepoliep): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.30-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(Klinischediagnosepoliep): de elementwaarde MOET een zijn van 'vs_klindiag_coloscopie Klinische diagnose coloscopie (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.30-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900106-2014-07-15T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(Klinischediagnosepoliep): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_klindiag_coloscopie Klinische diagnose coloscopie (DYNAMISCH).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='269533000']
Item: (SpecimencollectionMDL)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='269533000']">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.339
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='269533000']
Item: (Carcinoom)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.339
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='269533000']/lab:observationEvent
Item: (Carcinoom)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='269533000']/lab:observationEvent">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.339-2013-03-08T000000.html"
              test="string(@classCode)=('SPCOBS')">(Carcinoom): de waarde van @classCode MOET 'SPCOBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.339-2013-03-08T000000.html"
              test="string(@moodCode)=('EVN')">(Carcinoom): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.339-2013-03-08T000000.html"
              test="count(lab:code[(@code='269533000' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(lab:code[(@code='269533000' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Carcinoom): element lab:code[(@code='269533000' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.339-2013-03-08T000000.html"
              test="count(lab:code[(@code='269533000' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Carcinoom): element lab:code[(@code='269533000' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.339
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='269533000']/lab:observationEvent/lab:code[(@code='269533000' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Carcinoom)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='269533000']/lab:observationEvent/lab:code[(@code='269533000' and @codeSystem='2.16.840.1.113883.6.96')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.339-2013-03-08T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Carcinoom): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.339-2013-03-08T000000.html"
              test="@nullFlavor or (@code='269533000' and @codeSystem='2.16.840.1.113883.6.96')">(Carcinoom): de elementwaarde MOET een zijn van 'code '269533000' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='19132000']
Item: (SpecimencollectionMDL)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='19132000']">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.424
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='19132000']
Item: (Stenosis)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.424
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='19132000']/lab:observationEvent
Item: (Stenosis)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='19132000']/lab:observationEvent">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.424-2013-03-08T000000.html"
              test="string(@classCode)=('SPCOBS')">(Stenosis): de waarde van @classCode MOET 'SPCOBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.424-2013-03-08T000000.html"
              test="string(@moodCode)=('EVN')">(Stenosis): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.424-2013-03-08T000000.html"
              test="count(lab:code[(@code='19132000' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(lab:code[(@code='19132000' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Stenosis): element lab:code[(@code='19132000' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.424-2013-03-08T000000.html"
              test="count(lab:code[(@code='19132000' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Stenosis): element lab:code[(@code='19132000' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.424
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='19132000']/lab:observationEvent/lab:code[(@code='19132000' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Stenosis)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='19132000']/lab:observationEvent/lab:code[(@code='19132000' and @codeSystem='2.16.840.1.113883.6.96')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.424-2013-03-08T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Stenosis): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.424-2013-03-08T000000.html"
              test="@nullFlavor or (@code='19132000' and @codeSystem='2.16.840.1.113883.6.96')">(Stenosis): de elementwaarde MOET een zijn van 'code '19132000' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='248365001']
Item: (SpecimencollectionMDL)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='248365001']">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.425
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='248365001']
Item: (Circumferencemeasure)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.425
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='248365001']/lab:observationEvent
Item: (Circumferencemeasure)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='248365001']/lab:observationEvent">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.425-2014-02-09T000000.html"
              test="string(@classCode)=('SPCOBS')">(Circumferencemeasure): de waarde van @classCode MOET 'SPCOBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.425-2014-02-09T000000.html"
              test="string(@moodCode)=('EVN')">(Circumferencemeasure): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.425-2014-02-09T000000.html"
              test="count(lab:code[(@code='248365001' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(lab:code[(@code='248365001' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Circumferencemeasure): element lab:code[(@code='248365001' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.425-2014-02-09T000000.html"
              test="count(lab:code[(@code='248365001' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Circumferencemeasure): element lab:code[(@code='248365001' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.425-2014-02-09T000000.html"
              test="count(lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.225-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.225-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])&gt;=1 ">(Circumferencemeasure): element lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.225-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.225-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.425-2014-02-09T000000.html"
              test="count(lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.225-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.225-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])&lt;=1">(Circumferencemeasure): element lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.225-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.225-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.425
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='248365001']/lab:observationEvent/lab:code[(@code='248365001' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Circumferencemeasure)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='248365001']/lab:observationEvent/lab:code[(@code='248365001' and @codeSystem='2.16.840.1.113883.6.96')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.425-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Circumferencemeasure): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.425-2014-02-09T000000.html"
              test="@nullFlavor or (@code='248365001' and @codeSystem='2.16.840.1.113883.6.96')">(Circumferencemeasure): de elementwaarde MOET een zijn van 'code '248365001' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.425
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='248365001']/lab:observationEvent/lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.225-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.225-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]
Item: (Circumferencemeasure)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='248365001']/lab:observationEvent/lab:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.225-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.225-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.425-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Circumferencemeasure): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.425-2014-02-09T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.225-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(Circumferencemeasure): de elementwaarde MOET een zijn van 'vs_stenosiscircumference Stenosis circumference (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.225-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.425-2014-02-09T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(Circumferencemeasure): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_stenosiscircumference Stenosis circumference (DYNAMISCH).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='385300008']
Item: (SpecimencollectionMDL)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='385300008']">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.426
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='385300008']
Item: (Linearextent)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.426
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='385300008']/lab:observationEvent
Item: (Linearextent)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='385300008']/lab:observationEvent">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.426-2013-03-08T000000.html"
              test="string(@classCode)=('SPCOBS')">(Linearextent): de waarde van @classCode MOET 'SPCOBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.426-2013-03-08T000000.html"
              test="string(@moodCode)=('EVN')">(Linearextent): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.426-2013-03-08T000000.html"
              test="count(lab:code[(@code='385300008' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(lab:code[(@code='385300008' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Linearextent): element lab:code[(@code='385300008' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.426-2013-03-08T000000.html"
              test="count(lab:code[(@code='385300008' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Linearextent): element lab:code[(@code='385300008' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.426-2013-03-08T000000.html"
              test="count(lab:value)&gt;=1 ">(Linearextent): element lab:value is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.426-2013-03-08T000000.html"
              test="count(lab:value)&lt;=1">(Linearextent): element lab:value komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.426
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='385300008']/lab:observationEvent/lab:code[(@code='385300008' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Linearextent)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='385300008']/lab:observationEvent/lab:code[(@code='385300008' and @codeSystem='2.16.840.1.113883.6.96')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.426-2013-03-08T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Linearextent): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.426-2013-03-08T000000.html"
              test="@nullFlavor or (@code='385300008' and @codeSystem='2.16.840.1.113883.6.96')">(Linearextent): de elementwaarde MOET een zijn van 'code '385300008' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.426
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='385300008']/lab:observationEvent/lab:value
Item: (Linearextent)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='385300008']/lab:observationEvent/lab:value">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.426-2013-03-08T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PQ' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Linearextent): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PQ" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="PQ"/>
      <let name="theValue" value="@value"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.426-2013-03-08T000000.html"
              test="(@nullFlavor or (@unit='cm'))">(Linearextent): value MOET eenheid 'cm' gebruiken </assert>
      <let name="digitok"
           value="matches(string(@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.426-2013-03-08T000000.html"
              test="$digitok or @nullFlavor">(Linearextent): @value is geen geldig PQ getal <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.426-2013-03-08T000000.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(Linearextent): value/@unit (PQ) MOET een geldige UCUM-eenheid zijn (<value-of select="$UCUMtest"/>).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']
Item: (SpecimencollectionMDL)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']">
      <extends rule="tmp-r-5531ad38-e15b-4ae2-8d8d-cc62b97a0dd7"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900120
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']
Item: (Distanceoftumorfromanalverge)
-->
   <rule id="tmp-r-5531ad38-e15b-4ae2-8d8d-cc62b97a0dd7" abstract="true">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="count(lab:observationEvent)&gt;=1 and not(lab:observationEvent/@nullFlavor)">(Distanceoftumorfromanalverge): element lab:observationEvent is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="count(lab:observationEvent)&lt;=1">(Distanceoftumorfromanalverge): element lab:observationEvent komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900120
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent
Item: (Distanceoftumorfromanalverge)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="string(@classCode)=('SPCOBS')">(Distanceoftumorfromanalverge): de waarde van @classCode MOET 'SPCOBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="string(@moodCode)=('EVN')">(Distanceoftumorfromanalverge): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="count(lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Distanceoftumorfromanalverge): element lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="count(lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Distanceoftumorfromanalverge): element lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="count(lab:value)&gt;=1 ">(Distanceoftumorfromanalverge): element lab:value is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="count(lab:value)&lt;=1">(Distanceoftumorfromanalverge): element lab:value komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900120
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent/lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Distanceoftumorfromanalverge)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent/lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Distanceoftumorfromanalverge): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="@nullFlavor or (@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')">(Distanceoftumorfromanalverge): de elementwaarde MOET een zijn van 'code '371490004' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900120
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent/lab:value
Item: (Distanceoftumorfromanalverge)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent/lab:value">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PQ' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Distanceoftumorfromanalverge): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PQ" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="PQ"/>
      <let name="theValue" value="@value"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="(@nullFlavor or (@unit='cm' and number($theValue)&gt;=0 and number($theValue)&lt;=200))">(Distanceoftumorfromanalverge): value MOET eenheid 'cm' gebruiken en in bereik [0..200] liggen  </assert>
      <let name="digitok"
           value="matches(string(@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="$digitok or @nullFlavor">(Distanceoftumorfromanalverge): @value is geen geldig PQ getal <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(Distanceoftumorfromanalverge): value/@unit (PQ) MOET een geldige UCUM-eenheid zijn (<value-of select="$UCUMtest"/>).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']
Item: (SpecimencollectionMDL)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.427
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']
Item: (Carcinomapassable)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.427
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']/lab:observationEvent
Item: (Carcinomapassable)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']/lab:observationEvent">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.427-2013-03-08T000000.html"
              test="string(@classCode)=('SPCOBS')">(Carcinomapassable): de waarde van @classCode MOET 'SPCOBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.427-2013-03-08T000000.html"
              test="string(@moodCode)=('EVN')">(Carcinomapassable): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.427-2013-03-08T000000.html"
              test="count(lab:code[(@code='C145140' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')])&gt;=1 and not(lab:code[(@code='C145140' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]/@nullFlavor)">(Carcinomapassable): element lab:code[(@code='C145140' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.427-2013-03-08T000000.html"
              test="count(lab:code[(@code='C145140' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')])&lt;=1">(Carcinomapassable): element lab:code[(@code='C145140' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.427-2013-03-08T000000.html"
              test="count(lab:value)&gt;=1 ">(Carcinomapassable): element lab:value is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.427-2013-03-08T000000.html"
              test="count(lab:value)&lt;=1">(Carcinomapassable): element lab:value komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.427
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']/lab:observationEvent/lab:code[(@code='C145140' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]
Item: (Carcinomapassable)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']/lab:observationEvent/lab:code[(@code='C145140' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.427-2013-03-08T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Carcinomapassable): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.427-2013-03-08T000000.html"
              test="@nullFlavor or (@code='C145140' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')">(Carcinomapassable): de elementwaarde MOET een zijn van 'code 'C145140' codeSystem '2.16.840.1.113883.2.4.3.36.77.5.200''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.427
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']/lab:observationEvent/lab:value
Item: (Carcinomapassable)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='C145140']/lab:observationEvent/lab:value">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.427-2013-03-08T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='BL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Carcinomapassable): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:BL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="BL"/>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.333
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']
Item: (SpecimencollectionMDL)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.333-2014-02-09T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimencollectionMDL): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900118
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']
Item: (Tattooing)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900118
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']/lab:observationEvent
Item: (Tattooing)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']/lab:observationEvent">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900118-2012-04-10T000000.html"
              test="string(@classCode)=('SPCOBS')">(Tattooing): de waarde van @classCode MOET 'SPCOBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900118-2012-04-10T000000.html"
              test="string(@moodCode)=('EVN')">(Tattooing): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900118-2012-04-10T000000.html"
              test="count(lab:code[(@code='14792009' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(lab:code[(@code='14792009' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Tattooing): element lab:code[(@code='14792009' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900118-2012-04-10T000000.html"
              test="count(lab:code[(@code='14792009' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Tattooing): element lab:code[(@code='14792009' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900118-2012-04-10T000000.html"
              test="count(lab:value)&gt;=1 ">(Tattooing): element lab:value is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900118-2012-04-10T000000.html"
              test="count(lab:value)&lt;=1">(Tattooing): element lab:value komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900118
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']/lab:observationEvent/lab:code[(@code='14792009' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Tattooing)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']/lab:observationEvent/lab:code[(@code='14792009' and @codeSystem='2.16.840.1.113883.6.96')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900118-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Tattooing): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900118-2012-04-10T000000.html"
              test="@nullFlavor or (@code='14792009' and @codeSystem='2.16.840.1.113883.6.96')">(Tattooing): de elementwaarde MOET een zijn van 'code '14792009' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900118
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']/lab:observationEvent/lab:value
Item: (Tattooing)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']/hl7:specimen/hl7:specimenRole/lab:subjectOf[lab:observationEvent/lab:code/@code='14792009']/lab:observationEvent/lab:value">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900118-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='BL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Tattooing): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:BL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="BL"/>
   </rule>
</pattern>
