<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.36.10.382
Name: Indication
Description: Template: Indicatie
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.36.10.382-2014-04-25T000000">
   <title>Indication</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.382
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']]
Item: (Indication)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.382
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']
Item: (Indication)
-->

   <rule context="*[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']"
         id="tmp-r-6dc5b06d-c4da-456e-a573-1ebf6d65c75f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.382-2014-04-25T000000.html"
              test="string(@classCode)=('OBS')">(Indication): de waarde van @classCode MOET 'OBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.382-2014-04-25T000000.html"
              test="string(@moodCode)=('EVN')">(Indication): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.382-2014-04-25T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.382'])&gt;=1 ">(Indication): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.382'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.382-2014-04-25T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.382'])&lt;=1">(Indication): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.382'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.382-2014-04-25T000000.html"
              test="count(hl7:code[(@code='55607006' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(hl7:code[(@code='55607006' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Indication): element hl7:code[(@code='55607006' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.382-2014-04-25T000000.html"
              test="count(hl7:code[(@code='55607006' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Indication): element hl7:code[(@code='55607006' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.382-2014-04-25T000000.html"
              test="count(hl7:text)&lt;=1">(Indication): element hl7:text komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.382-2014-04-25T000000.html"
              test="count(hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.220-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.220-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.227-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.227-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])&gt;=1 and not(hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.220-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.220-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.227-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.227-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]/@nullFlavor)">(Indication): element hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.220-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.220-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.227-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.227-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.382-2014-04-25T000000.html"
              test="count(hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.220-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.220-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.227-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.227-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])&lt;=1">(Indication): element hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.220-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.220-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.227-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.227-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.382
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.382']
Item: (Indication)
-->

   <rule context="*[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.382']"
         id="tmp-r-6e64bb65-ad7e-4b68-9067-b654095223e0">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.382-2014-04-25T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Indication): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.382-2014-04-25T000000.html"
              test="string(@root)=('2.16.840.1.113883.2.4.3.36.10.382')">(Indication): de waarde van @root MOET '2.16.840.1.113883.2.4.3.36.10.382' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.382
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']/hl7:code[(@code='55607006' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Indication)
-->

   <rule context="*[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']/hl7:code[(@code='55607006' and @codeSystem='2.16.840.1.113883.6.96')]"
         id="tmp-r-1e936e38-7251-4ae5-9a8a-912c82db8c0b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.382-2014-04-25T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Indication): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.382-2014-04-25T000000.html"
              test="@nullFlavor or (@code='55607006' and @codeSystem='2.16.840.1.113883.6.96')">(Indication): de elementwaarde MOET een zijn van 'code '55607006' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.382
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']/hl7:text
Item: (Indication)
-->

   <rule context="*[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']/hl7:text"
         id="tmp-r-2a6d38f4-f929-460c-b1d5-b66a7095d26d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.382-2014-04-25T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ED' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Indication): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ED" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="ED"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.382-2014-04-25T000000.html"
              test="count(hl7:reference)&gt;=1 and not(hl7:reference/@nullFlavor)">(Indication): element hl7:reference is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.382-2014-04-25T000000.html"
              test="count(hl7:reference)&lt;=1">(Indication): element hl7:reference komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.382
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']/hl7:text/hl7:reference
Item: (Indication)
-->

   <rule context="*[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']/hl7:text/hl7:reference"
         id="tmp-r-ed96e728-c36a-4f77-a162-c8ab85282250">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.382-2014-04-25T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Indication): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TEL"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.382
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']/hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.220-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.220-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.227-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.227-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]
Item: (Indication)
-->

   <rule context="*[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']/hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.220-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.220-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.227-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.227-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]"
         id="tmp-r-39615528-722a-4cc0-852e-746e2754f76d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.382-2014-04-25T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Indication): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.382-2014-04-25T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.220-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]]) or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.227-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(Indication): de elementwaarde MOET een zijn van 'vs_procedureindication Procedure Indication (DYNAMISCH) of vs_procedureindication_longlist Procedure Indication (long list) (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.220-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008']) or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.227-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.382-2014-04-25T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(Indication): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_procedureindication Procedure Indication (DYNAMISCH) of vs_procedureindication_longlist Procedure Indication (long list) (DYNAMISCH).</assert>
   </rule>
</pattern>
