<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.36.10.503
Name: Sedation/relaxation medication administration
Description: Template: Sedation medication administration
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.36.10.503-2012-04-10T000000">
   <title>Sedation/relaxation medication administration</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.503
Context: *[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]
Item: (Sedationrelaxationmedicationadministration)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.503
Context: *[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']
Item: (Sedationrelaxationmedicationadministration)
-->

   <rule context="*[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']"
         id="tmp-r-72a3b692-ccb3-4dbe-b310-549201118f57">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.503-2012-04-10T000000.html"
              test="string(@classCode)=('SBADM')">(Sedationrelaxationmedicationadministration): de waarde van @classCode MOET 'SBADM' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.503-2012-04-10T000000.html"
              test="string(@moodCode)=('EVN')">(Sedationrelaxationmedicationadministration): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.503-2012-04-10T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.503'])&gt;=1 ">(Sedationrelaxationmedicationadministration): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.503'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.503-2012-04-10T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.503'])&lt;=1">(Sedationrelaxationmedicationadministration): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.503'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.503-2012-04-10T000000.html"
              test="count(hl7:id)&lt;=1">(Sedationrelaxationmedicationadministration): element hl7:id komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.503-2012-04-10T000000.html"
              test="count(hl7:code[(@code='DRUG' and @codeSystem='2.16.840.1.113883.5.4')])&gt;=1 and not(hl7:code[(@code='DRUG' and @codeSystem='2.16.840.1.113883.5.4')]/@nullFlavor)">(Sedationrelaxationmedicationadministration): element hl7:code[(@code='DRUG' and @codeSystem='2.16.840.1.113883.5.4')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.503-2012-04-10T000000.html"
              test="count(hl7:code[(@code='DRUG' and @codeSystem='2.16.840.1.113883.5.4')])&lt;=1">(Sedationrelaxationmedicationadministration): element hl7:code[(@code='DRUG' and @codeSystem='2.16.840.1.113883.5.4')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.503-2012-04-10T000000.html"
              test="count(hl7:text)&gt;=1 and not(hl7:text/@nullFlavor)">(Sedationrelaxationmedicationadministration): element hl7:text is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.503-2012-04-10T000000.html"
              test="count(hl7:text)&lt;=1">(Sedationrelaxationmedicationadministration): element hl7:text komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.503-2012-04-10T000000.html"
              test="count(hl7:statusCode)&lt;=1">(Sedationrelaxationmedicationadministration): element hl7:statusCode komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.503-2012-04-10T000000.html"
              test="count(hl7:effectiveTime)&lt;=1">(Sedationrelaxationmedicationadministration): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.503-2012-04-10T000000.html"
              test="count(hl7:doseQuantity)&gt;=1 and not(hl7:doseQuantity/@nullFlavor)">(Sedationrelaxationmedicationadministration): element hl7:doseQuantity is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.503-2012-04-10T000000.html"
              test="count(hl7:doseQuantity)&lt;=1">(Sedationrelaxationmedicationadministration): element hl7:doseQuantity komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.503-2012-04-10T000000.html"
              test="count(hl7:consumable)&gt;=1 and not(hl7:consumable/@nullFlavor)">(Sedationrelaxationmedicationadministration): element hl7:consumable is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.503-2012-04-10T000000.html"
              test="count(hl7:consumable)&lt;=1">(Sedationrelaxationmedicationadministration): element hl7:consumable komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.503
Context: *[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.503']
Item: (Sedationrelaxationmedicationadministration)
-->

   <rule context="*[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.503']"
         id="tmp-r-8d5fb6f5-9cac-4ee6-a7f6-1eefc71ed2c7">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.503-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Sedationrelaxationmedicationadministration): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.503-2012-04-10T000000.html"
              test="string(@root)=('2.16.840.1.113883.2.4.3.36.10.503')">(Sedationrelaxationmedicationadministration): de waarde van @root MOET '2.16.840.1.113883.2.4.3.36.10.503' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.503
Context: *[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:id
Item: (Sedationrelaxationmedicationadministration)
-->

   <rule context="*[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:id"
         id="tmp-r-aa4d81b2-01e4-4bea-a952-ac4bb749abe9">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.503-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Sedationrelaxationmedicationadministration): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.503
Context: *[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:code[(@code='DRUG' and @codeSystem='2.16.840.1.113883.5.4')]
Item: (Sedationrelaxationmedicationadministration)
-->

   <rule context="*[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:code[(@code='DRUG' and @codeSystem='2.16.840.1.113883.5.4')]"
         id="tmp-r-968cedf0-18d5-45c7-a746-ebc2fd10e53d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.503-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Sedationrelaxationmedicationadministration): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.503-2012-04-10T000000.html"
              test="@nullFlavor or (@code='DRUG' and @codeSystem='2.16.840.1.113883.5.4')">(Sedationrelaxationmedicationadministration): de elementwaarde MOET een zijn van 'code 'DRUG' codeSystem '2.16.840.1.113883.5.4''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.503
Context: *[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:text
Item: (Sedationrelaxationmedicationadministration)
-->

   <rule context="*[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:text"
         id="tmp-r-fe308010-60be-4c62-b248-059f68ece3c4">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.503-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ED' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Sedationrelaxationmedicationadministration): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ED" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="ED"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.503-2012-04-10T000000.html"
              test="count(hl7:reference)&gt;=1 and not(hl7:reference/@nullFlavor)">(Sedationrelaxationmedicationadministration): element hl7:reference is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.503-2012-04-10T000000.html"
              test="count(hl7:reference)&lt;=1">(Sedationrelaxationmedicationadministration): element hl7:reference komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.503
Context: *[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:text/hl7:reference
Item: (Sedationrelaxationmedicationadministration)
-->

   <rule context="*[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:text/hl7:reference"
         id="tmp-r-0479a436-133e-42f9-9b75-3338cb9816d2">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.503-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Sedationrelaxationmedicationadministration): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TEL"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.503
Context: *[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:statusCode
Item: (Sedationrelaxationmedicationadministration)
-->

   <rule context="*[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:statusCode"
         id="tmp-r-8218120f-f782-41c6-93af-43f7d7a3d2be">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.503-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Sedationrelaxationmedicationadministration): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.503-2012-04-10T000000.html"
              test="@nullFlavor or (@code='completed')">(Sedationrelaxationmedicationadministration): de elementwaarde MOET een zijn van 'code 'completed''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.503
Context: *[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:effectiveTime
Item: (Sedationrelaxationmedicationadministration)
-->

   <rule context="*[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:effectiveTime"
         id="tmp-r-e04db163-22c1-440e-9ab1-ecc6a69122e9">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.503-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Sedationrelaxationmedicationadministration): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TS"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900028
Context: *[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:doseQuantity
Item: (Dosagemedication)
-->

   <rule context="*[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:doseQuantity"
         id="tmp-r-74e1b73e-ff2a-4a01-a6d7-497626dcae8c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900028-2014-07-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_PQ' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Dosagemedication): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_PQ" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="IVL_PQ"/>
      <let name="theValue" value="@value"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900028-2014-07-15T000000.html"
              test="(@nullFlavor or (@unit='ug')) or (@nullFlavor or (@unit='mg'))">(Dosagemedication): value MOET eenheid 'ug' gebruiken  of eenheid 'mg' gebruiken </assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900028-2014-07-15T000000.html"
              test="not(hl7:low/@value) or matches(string(hl7:low/@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Dosagemedication): value/low @value is not a valid PQ number<value-of select="hl7:low/@value"/>
      </assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900028-2014-07-15T000000.html"
              test="not(hl7:high/@value) or matches(string(hl7:high/@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Dosagemedication): value/high @value is not a valid PQ number<value-of select="hl7:high/@value"/>
      </assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900028-2014-07-15T000000.html"
              test="not(hl7:center/@value) or matches(string(hl7:center/@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Dosagemedication): value/center @value is not a valid PQ number<value-of select="hl7:center/@value"/>
      </assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900054
Context: *[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:consumable
Item: (Medicationcoloscopy)
-->

   <rule context="*[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:consumable"
         id="tmp-r-bc612532-0b88-4910-90e5-8cf365d975b6">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900054-2012-04-10T000000.html"
              test="string(@typeCode)=('CSM')">(Medicationcoloscopy): de waarde van @typeCode MOET 'CSM' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900054-2012-04-10T000000.html"
              test="count(hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]])&gt;=1 and not(hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/@nullFlavor)">(Medicationcoloscopy): element hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900054-2012-04-10T000000.html"
              test="count(hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]])&lt;=1">(Medicationcoloscopy): element hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900054
Context: *[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:consumable/hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]
Item: (Medicationcoloscopy)
-->

   <rule context="*[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:consumable/hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]"
         id="tmp-r-bfdc1b98-da5b-4031-9b2e-65509ddb184c">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900054-2012-04-10T000000.html"
              test="string(@classCode)=('MANU')">(Medicationcoloscopy): de waarde van @classCode MOET 'MANU' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900054-2012-04-10T000000.html"
              test="count(hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]])&gt;=1 and not(hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/@nullFlavor)">(Medicationcoloscopy): element hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900054-2012-04-10T000000.html"
              test="count(hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]])&lt;=1">(Medicationcoloscopy): element hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900054
Context: *[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:consumable/hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]
Item: (Medicationcoloscopy)
-->

   <rule context="*[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:consumable/hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]"
         id="tmp-r-2eeaec49-ede3-428e-b069-16c2452c565a">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900054-2012-04-10T000000.html"
              test="string(@classCode)=('MMAT')">(Medicationcoloscopy): de waarde van @classCode MOET 'MMAT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900054-2012-04-10T000000.html"
              test="string(@determinerCode)=('KIND')">(Medicationcoloscopy): de waarde van @determinerCode MOET 'KIND' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900054-2012-04-10T000000.html"
              test="count(hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])&gt;=1 ">(Medicationcoloscopy): element hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900054-2012-04-10T000000.html"
              test="count(hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])&lt;=1">(Medicationcoloscopy): element hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900054-2012-04-10T000000.html"
              test="count(hl7:name)&lt;=1">(Medicationcoloscopy): element hl7:name komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900054
Context: *[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:consumable/hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]
Item: (Medicationcoloscopy)
-->

   <rule context="*[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:consumable/hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]"
         id="tmp-r-f0942eb6-84ed-48f7-aec0-33bb9970f049">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900054-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Medicationcoloscopy): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900054-2012-04-10T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(Medicationcoloscopy): de elementwaarde MOET een zijn van 'vs_medicatie_coloscopie Medicatie coloscopie (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900054-2012-04-10T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(Medicationcoloscopy): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_medicatie_coloscopie Medicatie coloscopie (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900054
Context: *[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:consumable/hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:name
Item: (Medicationcoloscopy)
-->

   <rule context="*[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:consumable/hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:name"
         id="tmp-r-dc3a99fd-ff83-45d8-a905-c91929d4a7dd">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900054-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ST' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Medicationcoloscopy): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="ST"/>
   </rule>
</pattern>
