<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.36.10.550
Name: Specimen Macroscopic Observation
Description: Template: Specimen Macroscopic Observation
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000">
   <title>Specimen Macroscopic Observation</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]"
         id="tmp-r-be75f58a-a094-4049-8681-756501520847">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="count(hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550'])&gt;=1 and not(hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/@nullFlavor)">(SpecimenMacroscopicObservation): element hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="count(hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550'])&lt;=1">(SpecimenMacroscopicObservation): element hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']"
         id="tmp-r-9aa16c32-30d1-4e00-b1b2-382c0a967f63">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="string(@classCode)=('ACT')">(SpecimenMacroscopicObservation): de waarde van @classCode MOET 'ACT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="string(@moodCode)=('EVN')">(SpecimenMacroscopicObservation): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.550'])&gt;=1 ">(SpecimenMacroscopicObservation): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.550'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.550'])&lt;=1">(SpecimenMacroscopicObservation): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.550'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="count(hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')])&gt;=1 and not(hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')]/@nullFlavor)">(SpecimenMacroscopicObservation): element hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="count(hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')])&lt;=1">(SpecimenMacroscopicObservation): element hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="count(hl7:statusCode)&lt;=1">(SpecimenMacroscopicObservation): element hl7:statusCode komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="count(hl7:specimen)&gt;=1 and not(hl7:specimen/@nullFlavor)">(SpecimenMacroscopicObservation): element hl7:specimen is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="count(hl7:specimen)&lt;=1">(SpecimenMacroscopicObservation): element hl7:specimen komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.550']
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.550']"
         id="tmp-r-d11d5c59-28ef-487c-ae27-d1e479a00727">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimenMacroscopicObservation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="string(@root)=('2.16.840.1.113883.2.4.3.36.10.550')">(SpecimenMacroscopicObservation): de waarde van @root MOET '2.16.840.1.113883.2.4.3.36.10.550' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')]
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:code[(@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')]"
         id="tmp-r-84e4b2da-642e-453e-98ef-548f336bdc18">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimenMacroscopicObservation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="@nullFlavor or (@code='X-LAB-SPMSCT' and @codeSystem='2.16.840.1.113883.6.1')">(SpecimenMacroscopicObservation): de elementwaarde MOET een zijn van 'code 'X-LAB-SPMSCT' codeSystem '2.16.840.1.113883.6.1''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:statusCode
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:statusCode"
         id="tmp-r-c21a4cc7-d687-4489-9863-9191e33b0bab">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimenMacroscopicObservation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="@nullFlavor or (@code='completed')">(SpecimenMacroscopicObservation): de elementwaarde MOET een zijn van 'code 'completed''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen"
         id="tmp-r-afa5da39-6284-45a5-bde8-f2da649dd472">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="string(@typeCode)=('SPC')">(SpecimenMacroscopicObservation): de waarde van @typeCode MOET 'SPC' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="count(hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]])&gt;=1 and not(hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/@nullFlavor)">(SpecimenMacroscopicObservation): element hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="count(hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]])&lt;=1">(SpecimenMacroscopicObservation): element hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]"
         id="tmp-r-2bb004bb-3406-49bb-ac0f-3af370c2340d">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="string(@classCode)=('SPEC')">(SpecimenMacroscopicObservation): de waarde van @classCode MOET 'SPEC' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="count(hl7:id)&gt;=1 and not(hl7:id/@nullFlavor)">(SpecimenMacroscopicObservation): element hl7:id is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="count(hl7:id)&lt;=1">(SpecimenMacroscopicObservation): element hl7:id komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="count(hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]])&lt;=1">(SpecimenMacroscopicObservation): element hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="count(lab:subjectOf[lab:observationEvent/lab:code/@code='371490004'])&lt;=1">(SpecimenMacroscopicObservation): element lab:subjectOf[lab:observationEvent/lab:code/@code='371490004'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:id
Item: (SpecimenMacroscopicObservation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]"
         id="tmp-r-9ac92bd2-5b97-420b-83e4-699736b418b2">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="string(@classCode)=('ENT')">(SpecimenMacroscopicObservation): de waarde van @classCode MOET 'ENT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(SpecimenMacroscopicObservation): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="count(hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])&gt;=1 and not(hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]/@nullFlavor)">(SpecimenMacroscopicObservation): element hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="count(hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])&lt;=1">(SpecimenMacroscopicObservation): element hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="count(hl7:quantity)&lt;=1">(SpecimenMacroscopicObservation): element hl7:quantity komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="count(lab:asSpecimenInContainer)&lt;=1">(SpecimenMacroscopicObservation): element lab:asSpecimenInContainer komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]"
         id="tmp-r-5bf71936-78d3-4384-a7fe-2340c46e3f8d">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(SpecimenMacroscopicObservation): de elementwaarde MOET een zijn van 'vs_monstermateriaal Monster materiaal (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(SpecimenMacroscopicObservation): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_monstermateriaal Monster materiaal (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/hl7:quantity
Item: (SpecimenMacroscopicObservation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/lab:asSpecimenInContainer
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/lab:asSpecimenInContainer"
         id="tmp-r-6624a6bf-0e59-4245-b01b-ae433eb86a10">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="string(@classCode)=('CONT')">(SpecimenMacroscopicObservation): de waarde van @classCode MOET 'CONT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="count(lab:container)&gt;=1 and not(lab:container/@nullFlavor)">(SpecimenMacroscopicObservation): element lab:container is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="count(lab:container)&lt;=1">(SpecimenMacroscopicObservation): element lab:container komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/lab:asSpecimenInContainer/lab:container
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/lab:asSpecimenInContainer/lab:container"
         id="tmp-r-e4039218-2f40-4665-a65c-183e2023a038">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="string(@classCode)=('CONT')">(SpecimenMacroscopicObservation): de waarde van @classCode MOET 'CONT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="string(@determinerCode)=('INSTANCE')">(SpecimenMacroscopicObservation): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="count(lab:id)&gt;=1 and not(lab:id/@nullFlavor)">(SpecimenMacroscopicObservation): element lab:id is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="count(lab:id)&lt;=1">(SpecimenMacroscopicObservation): element lab:id komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]/lab:asSpecimenInContainer/lab:container/lab:id
Item: (SpecimenMacroscopicObservation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:productOf
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:productOf"
         id="tmp-r-a5248be3-a44f-4c29-b23f-ad19e20abffa">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="string(@typeCode)=('PRD')">(SpecimenMacroscopicObservation): de waarde van @typeCode MOET 'PRD' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:productOf/lab:specimenCollectionProcess
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:productOf/lab:specimenCollectionProcess"
         id="tmp-r-2552045d-b99d-4fcc-a771-c969525d56b2">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="string(@classCode)=('SPECCOLLECT')">(SpecimenMacroscopicObservation): de waarde van @classCode MOET 'SPECCOLLECT' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="string(@moodCode)=('EVN')">(SpecimenMacroscopicObservation): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="count(lab:code)&lt;=1">(SpecimenMacroscopicObservation): element lab:code komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="count(lab:effectiveTime)&lt;=1">(SpecimenMacroscopicObservation): element lab:effectiveTime komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="count(lab:targetSiteCode)&lt;=1">(SpecimenMacroscopicObservation): element lab:targetSiteCode komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:productOf/lab:specimenCollectionProcess/lab:code
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:productOf/lab:specimenCollectionProcess/lab:code"
         id="tmp-r-e41da2e3-4c61-49cb-8d50-a264a422ff91">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimenMacroscopicObservation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.13-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(SpecimenMacroscopicObservation): de elementwaarde MOET een zijn van 'vs_verkrijgingswijze Verkrijgingswijze (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.13-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(SpecimenMacroscopicObservation): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_verkrijgingswijze Verkrijgingswijze (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:productOf/lab:specimenCollectionProcess/lab:effectiveTime
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:productOf/lab:specimenCollectionProcess/lab:effectiveTime"
         id="tmp-r-f634f998-9684-4243-b7a7-f184aa73003b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimenMacroscopicObservation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TS.DATE.MIN"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:productOf/lab:specimenCollectionProcess/lab:targetSiteCode
Item: (SpecimenMacroscopicObservation)
-->

   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:productOf/lab:specimenCollectionProcess/lab:targetSiteCode"
         id="tmp-r-f95289b2-70c5-47dd-a0f9-50298dca9cfe">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimenMacroscopicObservation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.23-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(SpecimenMacroscopicObservation): de elementwaarde MOET een zijn van 'vs_lokalisatie Lokalisatie laesie bij coloscopie (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.23-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(SpecimenMacroscopicObservation): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_lokalisatie Lokalisatie laesie bij coloscopie (DYNAMISCH).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.550
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']
Item: (SpecimenMacroscopicObservation)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']">
      <extends rule="tmp-r-90afa3b5-4b3c-48a4-9590-2c0543841a0f"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.550-2012-07-10T000000.html"
              test="string(@typeCode)=('SBJ')">(SpecimenMacroscopicObservation): de waarde van @typeCode MOET 'SBJ' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900120
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']
Item: (Distanceoftumorfromanalverge)
-->
   <rule id="tmp-r-90afa3b5-4b3c-48a4-9590-2c0543841a0f" abstract="true">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="count(lab:observationEvent)&gt;=1 and not(lab:observationEvent/@nullFlavor)">(Distanceoftumorfromanalverge): element lab:observationEvent is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="count(lab:observationEvent)&lt;=1">(Distanceoftumorfromanalverge): element lab:observationEvent komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900120
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent
Item: (Distanceoftumorfromanalverge)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="string(@classCode)=('SPCOBS')">(Distanceoftumorfromanalverge): de waarde van @classCode MOET 'SPCOBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="string(@moodCode)=('EVN')">(Distanceoftumorfromanalverge): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="count(lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Distanceoftumorfromanalverge): element lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="count(lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Distanceoftumorfromanalverge): element lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="count(lab:value)&gt;=1 ">(Distanceoftumorfromanalverge): element lab:value is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="count(lab:value)&lt;=1">(Distanceoftumorfromanalverge): element lab:value komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900120
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent/lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Distanceoftumorfromanalverge)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent/lab:code[(@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Distanceoftumorfromanalverge): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="@nullFlavor or (@code='371490004' and @codeSystem='2.16.840.1.113883.6.96')">(Distanceoftumorfromanalverge): de elementwaarde MOET een zijn van 'code '371490004' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.900120
Context: *[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent/lab:value
Item: (Distanceoftumorfromanalverge)
-->
   <rule context="*[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.550']/hl7:specimen/hl7:specimenRole[hl7:specimenPlayingEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.105-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]]]/lab:subjectOf[lab:observationEvent/lab:code/@code='371490004']/lab:observationEvent/lab:value">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PQ' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Distanceoftumorfromanalverge): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PQ" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="PQ"/>
      <let name="theValue" value="@value"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="(@nullFlavor or (@unit='cm' and number($theValue)&gt;=0 and number($theValue)&lt;=200))">(Distanceoftumorfromanalverge): value MOET eenheid 'cm' gebruiken en in bereik [0..200] liggen  </assert>
      <let name="digitok"
           value="matches(string(@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="$digitok or @nullFlavor">(Distanceoftumorfromanalverge): @value is geen geldig PQ getal <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900120-2015-02-14T000000.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(Distanceoftumorfromanalverge): value/@unit (PQ) MOET een geldige UCUM-eenheid zijn (<value-of select="$UCUMtest"/>).</assert>
   </rule>
</pattern>
