<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.36.10.551
Name: Specimen Microscopic Observation
Description: The Microscopic Observation section contains optionally the histopathologic findings of the case and many laboratories use this section to record the results of histochemical and immunohistochemical stains.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000">
   <title>Specimen Microscopic Observation</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.551
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]
Item: (SpecimenMicroscopicObservation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.551
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']
Item: (SpecimenMicroscopicObservation)
-->

   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']"
         id="tmp-r-dcf5bce5-09ef-4ca4-8e76-d3990c166586">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@classCode)=('CLUSTER')">(SpecimenMicroscopicObservation): de waarde van @classCode MOET 'CLUSTER' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@moodCode)=('EVN')">(SpecimenMicroscopicObservation): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.551'])&gt;=1 ">(SpecimenMicroscopicObservation): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.551'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.551'])&lt;=1">(SpecimenMicroscopicObservation): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.551'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="count(hl7:code[(@code='22635-7' and @codeSystem='2.16.840.1.113883.6.1')])&gt;=1 and not(hl7:code[(@code='22635-7' and @codeSystem='2.16.840.1.113883.6.1')]/@nullFlavor)">(SpecimenMicroscopicObservation): element hl7:code[(@code='22635-7' and @codeSystem='2.16.840.1.113883.6.1')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="count(hl7:code[(@code='22635-7' and @codeSystem='2.16.840.1.113883.6.1')])&lt;=1">(SpecimenMicroscopicObservation): element hl7:code[(@code='22635-7' and @codeSystem='2.16.840.1.113883.6.1')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="count(hl7:statusCode[@code='completed'])&gt;=1 and not(hl7:statusCode[@code='completed']/@nullFlavor)">(SpecimenMicroscopicObservation): element hl7:statusCode[@code='completed'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="count(hl7:statusCode[@code='completed'])&lt;=1">(SpecimenMicroscopicObservation): element hl7:statusCode[@code='completed'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="count(hl7:specimen)&lt;=1">(SpecimenMicroscopicObservation): element hl7:specimen komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="count(hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']])&lt;=1">(SpecimenMicroscopicObservation): element hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.551
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.551']
Item: (SpecimenMicroscopicObservation)
-->

   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.551']"
         id="tmp-r-f9534756-d1d7-4dbf-bb44-c39325bb1b69">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimenMicroscopicObservation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@root)=('2.16.840.1.113883.2.4.3.36.10.551')">(SpecimenMicroscopicObservation): de waarde van @root MOET '2.16.840.1.113883.2.4.3.36.10.551' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.551
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:code[(@code='22635-7' and @codeSystem='2.16.840.1.113883.6.1')]
Item: (SpecimenMicroscopicObservation)
-->

   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:code[(@code='22635-7' and @codeSystem='2.16.840.1.113883.6.1')]"
         id="tmp-r-41660c7e-78b1-4692-a1d0-aeadb5884482">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimenMicroscopicObservation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="@nullFlavor or (@code='22635-7' and @codeSystem='2.16.840.1.113883.6.1')">(SpecimenMicroscopicObservation): de elementwaarde MOET een zijn van 'code '22635-7' codeSystem '2.16.840.1.113883.6.1''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.551
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:statusCode[@code='completed']
Item: (SpecimenMicroscopicObservation)
-->

   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:statusCode[@code='completed']"
         id="tmp-r-fe5a8df5-fe8a-473d-a963-332c591797e6">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimenMicroscopicObservation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="@nullFlavor or (@code='completed')">(SpecimenMicroscopicObservation): de elementwaarde MOET een zijn van 'code 'completed''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.557
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:specimen
Item: (SpecimenReference)
-->

   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:specimen"
         id="tmp-r-9ded2e23-6979-49d0-9aba-875273dfad44">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.557-2012-04-10T000000.html"
              test="string(@typeCode)=('SPC')">(SpecimenReference): de waarde van @typeCode MOET 'SPC' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.557
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:specimen/hl7:specimenRole
Item: (SpecimenReference)
-->

   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:specimen/hl7:specimenRole"
         id="tmp-r-0076b72a-6e29-4c8e-a5c1-413ce5090297">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.557-2012-04-10T000000.html"
              test="string(@classCode)=('SPEC')">(SpecimenReference): de waarde van @classCode MOET 'SPEC' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.557-2012-04-10T000000.html"
              test="count(hl7:id)&gt;=1 and not(hl7:id/@nullFlavor)">(SpecimenReference): element hl7:id is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.557-2012-04-10T000000.html"
              test="count(hl7:id)&lt;=1">(SpecimenReference): element hl7:id komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.557
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:specimen/hl7:specimenRole/hl7:id
Item: (SpecimenReference)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.551
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]
Item: (SpecimenMicroscopicObservation)
-->

   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]"
         id="tmp-r-5c4ec12a-2c67-4ddf-9df1-8e6d80c173f4">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@typeCode)=('COMP')">(SpecimenMicroscopicObservation): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@contextConductionInd)=('true')">(SpecimenMicroscopicObservation): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.551
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']
Item: (SpecimenMicroscopicObservation)
-->

   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']"
         id="tmp-r-bba3b610-28b8-4585-b551-f9bda88cd4de">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@classCode)=('CLUSTER')">(SpecimenMicroscopicObservation): de waarde van @classCode MOET 'CLUSTER' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@moodCode)=('EVN')">(SpecimenMicroscopicObservation): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <let name="lepcode"
           value="ancestor::hl7:entry//hl7:observation[hl7:code[@code='371441004']]/hl7:value/@code"/>
      <let name="displcode"
           value="ancestor::hl7:entry//hl7:observation[hl7:code[@code='399391008']]/hl7:value/@code"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string-length($lepcode)=0 or $lepcode!='72495009' or string-length($displcode)=0">(SpecimenMicroscopicObservation): 
                            SpecimenMicroscopicObservation: Displaysiegraad n.v.t. als vastgestelde laesie poliep = mucineus adenocarcinoom
                        </assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="count(hl7:templateId[@root='1.3.6.1.4.1.19376.1.8.1.4.8'])&gt;=1 ">(SpecimenMicroscopicObservation): element hl7:templateId[@root='1.3.6.1.4.1.19376.1.8.1.4.8'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="count(hl7:templateId[@root='1.3.6.1.4.1.19376.1.8.1.4.8'])&lt;=1">(SpecimenMicroscopicObservation): element hl7:templateId[@root='1.3.6.1.4.1.19376.1.8.1.4.8'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="count(hl7:statusCode[@code='completed'])&gt;=1 and not(hl7:statusCode[@code='completed']/@nullFlavor)">(SpecimenMicroscopicObservation): element hl7:statusCode[@code='completed'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="count(hl7:statusCode[@code='completed'])&lt;=1">(SpecimenMicroscopicObservation): element hl7:statusCode[@code='completed'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="count(hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.401']])&lt;=1">(SpecimenMicroscopicObservation): element hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.401']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="count(hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.402']])&lt;=1">(SpecimenMicroscopicObservation): element hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.402']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="count(hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.403']])&gt;=1 ">(SpecimenMicroscopicObservation): element hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.403']] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="count(hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.403']])&lt;=1">(SpecimenMicroscopicObservation): element hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.403']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="count(hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.404']])&lt;=1">(SpecimenMicroscopicObservation): element hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.404']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="count(hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.405']])&lt;=1">(SpecimenMicroscopicObservation): element hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.405']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="count(hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.406']])&lt;=1">(SpecimenMicroscopicObservation): element hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.406']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="count(hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.407']])&lt;=1">(SpecimenMicroscopicObservation): element hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.407']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="count(hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.408']])&lt;=1">(SpecimenMicroscopicObservation): element hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.408']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="count(hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.409']])&lt;=1">(SpecimenMicroscopicObservation): element hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.409']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="count(hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.410']])&lt;=1">(SpecimenMicroscopicObservation): element hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.410']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="count(hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.411']])&lt;=1">(SpecimenMicroscopicObservation): element hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.411']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="count(hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.412']])&lt;=1">(SpecimenMicroscopicObservation): element hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.412']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="count(hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.413']])&lt;=1">(SpecimenMicroscopicObservation): element hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.413']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="count(hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.420']])&lt;=1">(SpecimenMicroscopicObservation): element hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.420']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="count(hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.421']])&lt;=1">(SpecimenMicroscopicObservation): element hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.421']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="count(hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.422']])&lt;=1">(SpecimenMicroscopicObservation): element hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.422']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="count(hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.429']])&lt;=1">(SpecimenMicroscopicObservation): element hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.429']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.551
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:templateId[@root='1.3.6.1.4.1.19376.1.8.1.4.8']
Item: (SpecimenMicroscopicObservation)
-->

   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:templateId[@root='1.3.6.1.4.1.19376.1.8.1.4.8']"
         id="tmp-r-ef21ec04-6973-4d6a-a340-3707489fc7b7">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimenMicroscopicObservation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@root)=('1.3.6.1.4.1.19376.1.8.1.4.8')">(SpecimenMicroscopicObservation): de waarde van @root MOET '1.3.6.1.4.1.19376.1.8.1.4.8' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.551
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:statusCode[@code='completed']
Item: (SpecimenMicroscopicObservation)
-->

   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:statusCode[@code='completed']"
         id="tmp-r-c6b0a608-e092-48f2-9daa-3d5ffd6e6b88">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimenMicroscopicObservation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="@nullFlavor or (@code='completed')">(SpecimenMicroscopicObservation): de elementwaarde MOET een zijn van 'code 'completed''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.551
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.401']]
Item: (SpecimenMicroscopicObservation)
-->
   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.401']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@typeCode)=('COMP')">(SpecimenMicroscopicObservation): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@contextConductionInd)=('true')">(SpecimenMicroscopicObservation): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.551
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.402']]
Item: (SpecimenMicroscopicObservation)
-->
   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.402']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@typeCode)=('COMP')">(SpecimenMicroscopicObservation): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@contextConductionInd)=('true')">(SpecimenMicroscopicObservation): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.551
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.403']]
Item: (SpecimenMicroscopicObservation)
-->
   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.403']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@typeCode)=('COMP')">(SpecimenMicroscopicObservation): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@contextConductionInd)=('true')">(SpecimenMicroscopicObservation): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.551
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.404']]
Item: (SpecimenMicroscopicObservation)
-->
   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.404']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@typeCode)=('COMP')">(SpecimenMicroscopicObservation): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@contextConductionInd)=('true')">(SpecimenMicroscopicObservation): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.551
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.405']]
Item: (SpecimenMicroscopicObservation)
-->
   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.405']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@typeCode)=('COMP')">(SpecimenMicroscopicObservation): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@contextConductionInd)=('true')">(SpecimenMicroscopicObservation): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.551
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.406']]
Item: (SpecimenMicroscopicObservation)
-->
   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.406']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@typeCode)=('COMP')">(SpecimenMicroscopicObservation): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@contextConductionInd)=('true')">(SpecimenMicroscopicObservation): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.551
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.407']]
Item: (SpecimenMicroscopicObservation)
-->
   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.407']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@typeCode)=('COMP')">(SpecimenMicroscopicObservation): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@contextConductionInd)=('true')">(SpecimenMicroscopicObservation): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.551
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.408']]
Item: (SpecimenMicroscopicObservation)
-->
   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.408']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@typeCode)=('COMP')">(SpecimenMicroscopicObservation): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@contextConductionInd)=('true')">(SpecimenMicroscopicObservation): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.551
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.409']]
Item: (SpecimenMicroscopicObservation)
-->
   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.409']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@typeCode)=('COMP')">(SpecimenMicroscopicObservation): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@contextConductionInd)=('true')">(SpecimenMicroscopicObservation): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.551
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.410']]
Item: (SpecimenMicroscopicObservation)
-->
   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.410']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@typeCode)=('COMP')">(SpecimenMicroscopicObservation): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@contextConductionInd)=('true')">(SpecimenMicroscopicObservation): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.551
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.411']]
Item: (SpecimenMicroscopicObservation)
-->
   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.411']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@typeCode)=('COMP')">(SpecimenMicroscopicObservation): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@contextConductionInd)=('true')">(SpecimenMicroscopicObservation): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.551
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.412']]
Item: (SpecimenMicroscopicObservation)
-->
   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.412']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@typeCode)=('COMP')">(SpecimenMicroscopicObservation): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@contextConductionInd)=('true')">(SpecimenMicroscopicObservation): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.551
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.413']]
Item: (SpecimenMicroscopicObservation)
-->
   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.413']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@typeCode)=('COMP')">(SpecimenMicroscopicObservation): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@contextConductionInd)=('true')">(SpecimenMicroscopicObservation): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.551
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.420']]
Item: (SpecimenMicroscopicObservation)
-->
   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.420']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@typeCode)=('COMP')">(SpecimenMicroscopicObservation): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@contextConductionInd)=('true')">(SpecimenMicroscopicObservation): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.551
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.421']]
Item: (SpecimenMicroscopicObservation)
-->
   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.421']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@typeCode)=('COMP')">(SpecimenMicroscopicObservation): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@contextConductionInd)=('true')">(SpecimenMicroscopicObservation): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.551
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.422']]
Item: (SpecimenMicroscopicObservation)
-->
   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.422']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@typeCode)=('COMP')">(SpecimenMicroscopicObservation): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@contextConductionInd)=('true')">(SpecimenMicroscopicObservation): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.551
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.429']]
Item: (SpecimenMicroscopicObservation)
-->
   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.551']/hl7:component[hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']]/hl7:organizer[hl7:templateId/@root='1.3.6.1.4.1.19376.1.8.1.4.8']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.429']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@typeCode)=('COMP')">(SpecimenMicroscopicObservation): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.551-2014-01-11T000000.html"
              test="string(@contextConductionInd)=('true')">(SpecimenMicroscopicObservation): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
   </rule>
</pattern>
