<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.36.10.315
Name: Specimen Diagnosis Entry
Description: Specimen Diagnosis Entry, per specimen
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.36.10.315-2012-07-04T000000">
   <title>Specimen Diagnosis Entry</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.315
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']]
Item: (SpecimenDiagnosisEntry)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.315
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']
Item: (SpecimenDiagnosisEntry)
-->

   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']"
         id="tmp-r-1ca21f34-4e72-4508-a2ba-a1c02fad233b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.315-2012-07-04T000000.html"
              test="string(@classCode)=('CLUSTER')">(SpecimenDiagnosisEntry): de waarde van @classCode MOET 'CLUSTER' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.315-2012-07-04T000000.html"
              test="string(@moodCode)=('EVN')">(SpecimenDiagnosisEntry): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.315-2012-07-04T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.315'])&gt;=1 ">(SpecimenDiagnosisEntry): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.315'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.315-2012-07-04T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.315'])&lt;=1">(SpecimenDiagnosisEntry): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.315'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.315-2012-07-04T000000.html"
              test="count(hl7:statusCode[@code='completed'])&gt;=1 and not(hl7:statusCode[@code='completed']/@nullFlavor)">(SpecimenDiagnosisEntry): element hl7:statusCode[@code='completed'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.315-2012-07-04T000000.html"
              test="count(hl7:statusCode[@code='completed'])&lt;=1">(SpecimenDiagnosisEntry): element hl7:statusCode[@code='completed'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.315-2012-07-04T000000.html"
              test="count(hl7:effectiveTime)&lt;=1">(SpecimenDiagnosisEntry): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.315-2012-07-04T000000.html"
              test="count(hl7:specimen)&lt;=1">(SpecimenDiagnosisEntry): element hl7:specimen komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.315
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.315']
Item: (SpecimenDiagnosisEntry)
-->

   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.315']"
         id="tmp-r-2adcd549-cdb8-45bd-8f0e-b639ccdf5367">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.315-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimenDiagnosisEntry): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.315-2012-07-04T000000.html"
              test="string(@root)=('2.16.840.1.113883.2.4.3.36.10.315')">(SpecimenDiagnosisEntry): de waarde van @root MOET '2.16.840.1.113883.2.4.3.36.10.315' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.315
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']/hl7:statusCode[@code='completed']
Item: (SpecimenDiagnosisEntry)
-->

   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']/hl7:statusCode[@code='completed']"
         id="tmp-r-f984f2f2-593f-4b6f-9083-91b0a78d92e5">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.315-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimenDiagnosisEntry): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.315-2012-07-04T000000.html"
              test="@nullFlavor or (@code='completed')">(SpecimenDiagnosisEntry): de elementwaarde MOET een zijn van 'code 'completed''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.315
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']/hl7:effectiveTime
Item: (SpecimenDiagnosisEntry)
-->

   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']/hl7:effectiveTime"
         id="tmp-r-1db0be1c-7efc-497e-82d1-6abd9d2e7994">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.315-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimenDiagnosisEntry): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="IVL_TS"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.557
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']/hl7:specimen
Item: (SpecimenReference)
-->

   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']/hl7:specimen"
         id="tmp-r-62166b01-585f-48fa-a731-ec3ff1fffe50">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.557-2012-04-10T000000.html"
              test="string(@typeCode)=('SPC')">(SpecimenReference): de waarde van @typeCode MOET 'SPC' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.557
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']/hl7:specimen/hl7:specimenRole
Item: (SpecimenReference)
-->

   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']/hl7:specimen/hl7:specimenRole"
         id="tmp-r-a3bdb899-592a-435f-ab25-887b424f875b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.557-2012-04-10T000000.html"
              test="string(@classCode)=('SPEC')">(SpecimenReference): de waarde van @classCode MOET 'SPEC' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.557-2012-04-10T000000.html"
              test="count(hl7:id)&gt;=1 and not(hl7:id/@nullFlavor)">(SpecimenReference): element hl7:id is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.557-2012-04-10T000000.html"
              test="count(hl7:id)&lt;=1">(SpecimenReference): element hl7:id komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.557
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']/hl7:specimen/hl7:specimenRole/hl7:id
Item: (SpecimenReference)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.315
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.317']]
Item: (SpecimenDiagnosisEntry)
-->
   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.317']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.315-2012-07-04T000000.html"
              test="string(@typeCode)=('COMP')">(SpecimenDiagnosisEntry): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.315-2012-07-04T000000.html"
              test="string(@contextConductionInd)=('true')">(SpecimenDiagnosisEntry): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.315-2012-07-04T000000.html"
              test="count(hl7:sequenceNumber)&lt;=1">(SpecimenDiagnosisEntry): element hl7:sequenceNumber komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.315
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.317']]/hl7:sequenceNumber
Item: (SpecimenDiagnosisEntry)
-->
   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.315']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.317']]/hl7:sequenceNumber">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.315-2012-07-04T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='INT' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(SpecimenDiagnosisEntry): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:INT" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="INT"/>
      <let name="digitok" value="matches(string(@value), '^-?[1-9]\d*$|^+?\d*$')"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.315-2012-07-04T000000.html"
              test="$digitok or @nullFlavor">(SpecimenDiagnosisEntry): @value is geen geldig INT getal <value-of select="@value"/>
      </assert>
   </rule>
</pattern>
