<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.36.10.345
Name: Total number of lesions
Description: Template: Totaal aantal gedetecteerde poliepen
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.36.10.345-2014-02-09T000000">
   <title>Total number of lesions</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.345
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.345']]
Item: (Totalnumberoflesions)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.345
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.345']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.345']
Item: (Totalnumberoflesions)
-->

   <rule context="*[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.345']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.345']"
         id="tmp-r-199f20d1-f69f-4d12-88e1-c5e92895d725">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.345-2014-02-09T000000.html"
              test="string(@classCode)=('OBS')">(Totalnumberoflesions): de waarde van @classCode MOET 'OBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.345-2014-02-09T000000.html"
              test="string(@moodCode)=('EVN')">(Totalnumberoflesions): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.345-2014-02-09T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.345'])&gt;=1 ">(Totalnumberoflesions): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.345'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.345-2014-02-09T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.345'])&lt;=1">(Totalnumberoflesions): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.345'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.345-2014-02-09T000000.html"
              test="count(hl7:code[(@code='300579006' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(hl7:code[(@code='300579006' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Totalnumberoflesions): element hl7:code[(@code='300579006' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.345-2014-02-09T000000.html"
              test="count(hl7:code[(@code='300579006' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Totalnumberoflesions): element hl7:code[(@code='300579006' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.345-2014-02-09T000000.html"
              test="count(hl7:value)&gt;=1 and not(hl7:value/@nullFlavor)">(Totalnumberoflesions): element hl7:value is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.345-2014-02-09T000000.html"
              test="count(hl7:value)&lt;=1">(Totalnumberoflesions): element hl7:value komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.345
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.345']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.345']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.345']
Item: (Totalnumberoflesions)
-->

   <rule context="*[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.345']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.345']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.345']"
         id="tmp-r-c7ae42ea-2944-4b81-bb33-57a261f62c90">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.345-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Totalnumberoflesions): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.345-2014-02-09T000000.html"
              test="string(@root)=('2.16.840.1.113883.2.4.3.36.10.345')">(Totalnumberoflesions): de waarde van @root MOET '2.16.840.1.113883.2.4.3.36.10.345' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.345
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.345']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.345']/hl7:code[(@code='300579006' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Totalnumberoflesions)
-->

   <rule context="*[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.345']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.345']/hl7:code[(@code='300579006' and @codeSystem='2.16.840.1.113883.6.96')]"
         id="tmp-r-721ca5e1-9388-4cb5-9da5-b212d8626df2">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.345-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Totalnumberoflesions): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.345-2014-02-09T000000.html"
              test="@nullFlavor or (@code='300579006' and @codeSystem='2.16.840.1.113883.6.96')">(Totalnumberoflesions): de elementwaarde MOET een zijn van 'code '300579006' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.345
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.345']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.345']/hl7:value
Item: (Totalnumberoflesions)
-->

   <rule context="*[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.345']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.345']/hl7:value"
         id="tmp-r-c5d0a78a-f0af-4962-a020-60d22a38b78b">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.345-2014-02-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='INT' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Totalnumberoflesions): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:INT" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="INT"/>
      <let name="digitok" value="matches(string(@value), '^-?[1-9]\d*$|^+?\d*$')"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.345-2014-02-09T000000.html"
              test="$digitok or @nullFlavor">(Totalnumberoflesions): @value is geen geldig INT getal <value-of select="@value"/>
      </assert>
   </rule>
</pattern>
