<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.36.10.381
Name: Assertion Colonoscopy Entry
Description: Conclusion Colonoscopy Entry
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.36.10.381-2013-04-15T000000">
   <title>Assertion Colonoscopy Entry</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.381
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']]
Item: (AssertionColonoscopyEntry)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.381
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']
Item: (AssertionColonoscopyEntry)
-->

   <rule context="*[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']"
         id="tmp-r-fc3fe3b9-5981-43c7-8a24-dd71f2fc43eb">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.381-2013-04-15T000000.html"
              test="string(@classCode)=('OBS')">(AssertionColonoscopyEntry): de waarde van @classCode MOET 'OBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.381-2013-04-15T000000.html"
              test="string(@moodCode)=('EVN')">(AssertionColonoscopyEntry): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.381-2013-04-15T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.381'])&gt;=1 ">(AssertionColonoscopyEntry): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.381'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.381-2013-04-15T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.381'])&lt;=1">(AssertionColonoscopyEntry): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.381'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.381-2013-04-15T000000.html"
              test="count(hl7:code[(@code='ASSERTION' and @codeSystem='2.16.840.1.113883.5.4')])&gt;=1 and not(hl7:code[(@code='ASSERTION' and @codeSystem='2.16.840.1.113883.5.4')]/@nullFlavor)">(AssertionColonoscopyEntry): element hl7:code[(@code='ASSERTION' and @codeSystem='2.16.840.1.113883.5.4')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.381-2013-04-15T000000.html"
              test="count(hl7:code[(@code='ASSERTION' and @codeSystem='2.16.840.1.113883.5.4')])&lt;=1">(AssertionColonoscopyEntry): element hl7:code[(@code='ASSERTION' and @codeSystem='2.16.840.1.113883.5.4')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.381-2013-04-15T000000.html"
              test="count(hl7:text)&lt;=1">(AssertionColonoscopyEntry): element hl7:text komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.381-2013-04-15T000000.html"
              test="count(hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.76-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.76-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])&gt;=1 ">(AssertionColonoscopyEntry): element hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.76-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.76-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.381-2013-04-15T000000.html"
              test="count(hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.76-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.76-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])&lt;=1">(AssertionColonoscopyEntry): element hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.76-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.76-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.381
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.381']
Item: (AssertionColonoscopyEntry)
-->

   <rule context="*[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.381']"
         id="tmp-r-fbcfb39e-f084-48f7-8268-8592956e69d0">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.381-2013-04-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(AssertionColonoscopyEntry): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.381-2013-04-15T000000.html"
              test="string(@root)=('2.16.840.1.113883.2.4.3.36.10.381')">(AssertionColonoscopyEntry): de waarde van @root MOET '2.16.840.1.113883.2.4.3.36.10.381' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.381
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']/hl7:code[(@code='ASSERTION' and @codeSystem='2.16.840.1.113883.5.4')]
Item: (AssertionColonoscopyEntry)
-->

   <rule context="*[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']/hl7:code[(@code='ASSERTION' and @codeSystem='2.16.840.1.113883.5.4')]"
         id="tmp-r-1e8b7e72-e749-44dd-aa13-c54b096ad7e3">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.381-2013-04-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(AssertionColonoscopyEntry): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.381-2013-04-15T000000.html"
              test="@nullFlavor or (@code='ASSERTION' and @codeSystem='2.16.840.1.113883.5.4')">(AssertionColonoscopyEntry): de elementwaarde MOET een zijn van 'code 'ASSERTION' codeSystem '2.16.840.1.113883.5.4''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.381
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']/hl7:text
Item: (AssertionColonoscopyEntry)
-->

   <rule context="*[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']/hl7:text"
         id="tmp-r-ebaca34f-9eb2-4dbb-abcf-fd2a23801e0f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.381-2013-04-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ED' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(AssertionColonoscopyEntry): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ED" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="ED"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.381-2013-04-15T000000.html"
              test="count(hl7:reference)&gt;=1 and not(hl7:reference/@nullFlavor)">(AssertionColonoscopyEntry): element hl7:reference is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.381-2013-04-15T000000.html"
              test="count(hl7:reference)&lt;=1">(AssertionColonoscopyEntry): element hl7:reference komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.381
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']/hl7:text/hl7:reference
Item: (AssertionColonoscopyEntry)
-->

   <rule context="*[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']/hl7:text/hl7:reference"
         id="tmp-r-129799d8-37e9-46c8-8aa6-d2208b57c0ef">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.381-2013-04-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(AssertionColonoscopyEntry): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="TEL"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.381
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']/hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.76-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.76-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]
Item: (AssertionColonoscopyEntry)
-->

   <rule context="*[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.381']/hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.76-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.76-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]"
         id="tmp-r-91523857-58dc-443e-a1c9-02b23b7ff256">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.381-2013-04-15T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(AssertionColonoscopyEntry): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.381-2013-04-15T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.76-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(AssertionColonoscopyEntry): de elementwaarde MOET een zijn van 'vs_overige_bevindingen Overige bevindingen (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.76-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.381-2013-04-15T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(AssertionColonoscopyEntry): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_overige_bevindingen Overige bevindingen (DYNAMISCH).</assert>
   </rule>
</pattern>
