<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.36.10.383
Name: Specimen Cluster
Description: Template: Specimen Cluster
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.36.10.383-2015-03-02T000000">
   <title>Specimen Cluster</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.383
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]
Item: (Specimencluster)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.383
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']
Item: (Specimencluster)
-->

   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']"
         id="tmp-r-28e71152-3af4-4c29-805c-2888586085ff">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.383-2015-03-02T000000.html"
              test="string(@classCode)=('CLUSTER')">(Specimencluster): de waarde van @classCode MOET 'CLUSTER' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.383-2015-03-02T000000.html"
              test="string(@moodCode)=('EVN')">(Specimencluster): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.383-2015-03-02T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.383'])&gt;=1 ">(Specimencluster): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.383'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.383-2015-03-02T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.383'])&lt;=1">(Specimencluster): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.383'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.383-2015-03-02T000000.html"
              test="count(hl7:statusCode[@code='completed'])&gt;=1 and not(hl7:statusCode[@code='completed']/@nullFlavor)">(Specimencluster): element hl7:statusCode[@code='completed'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.383-2015-03-02T000000.html"
              test="count(hl7:statusCode[@code='completed'])&lt;=1">(Specimencluster): element hl7:statusCode[@code='completed'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.383
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.383']
Item: (Specimencluster)
-->

   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.383']"
         id="tmp-r-1cbf363a-871e-4c5d-a57c-24054127d0fe">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.383-2015-03-02T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Specimencluster): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.383-2015-03-02T000000.html"
              test="string(@root)=('2.16.840.1.113883.2.4.3.36.10.383')">(Specimencluster): de waarde van @root MOET '2.16.840.1.113883.2.4.3.36.10.383' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.383
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:statusCode[@code='completed']
Item: (Specimencluster)
-->

   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:statusCode[@code='completed']"
         id="tmp-r-eca2551e-048e-4b9e-ad18-248b68e92015">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.383-2015-03-02T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Specimencluster): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.383-2015-03-02T000000.html"
              test="@nullFlavor or (@code='completed')">(Specimencluster): de elementwaarde MOET een zijn van 'code 'completed''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.383
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]
Item: (Specimencluster)
-->
   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.383-2015-03-02T000000.html"
              test="string(@typeCode)=('COMP')">(Specimencluster): de waarde van @typeCode MOET 'COMP' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.383-2015-03-02T000000.html"
              test="string(@contextConductionInd)=('true')">(Specimencluster): de waarde van @contextConductionInd MOET 'true' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.383-2015-03-02T000000.html"
              test="count(hl7:sequenceNumber)&gt;=1 ">(Specimencluster): element hl7:sequenceNumber is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.383-2015-03-02T000000.html"
              test="count(hl7:sequenceNumber)&lt;=1">(Specimencluster): element hl7:sequenceNumber komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.383
Context: *[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:sequenceNumber
Item: (Specimencluster)
-->
   <rule context="*[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.383']/hl7:component[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.333']]/hl7:sequenceNumber">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.383-2015-03-02T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='INT' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Specimencluster): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:INT" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="INT.POS"/>
      <let name="digitok" value="matches(string(@value), '^-?[1-9]\d*$|^+?\d*$')"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.383-2015-03-02T000000.html"
              test="$digitok or @nullFlavor">(Specimencluster): @value is geen geldig INT getal <value-of select="@value"/>
      </assert>
   </rule>
</pattern>
