<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.36.10.402
Name: Diameter materiaal
Description: Template: Diameter materiaal
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.36.10.402-2012-04-10T000000">
   <title>Diameter materiaal</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.402
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.402']]
Item: (Diametermaterial)
-->

   <rule context="*[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.402']]"
         id="tmp-r-ca003877-03d5-4c4f-9f62-2761489f6669">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.402-2012-04-10T000000.html"
              test="count(hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.402'])&gt;=1 and not(hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.402']/@nullFlavor)">(Diametermaterial): element hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.402'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.402-2012-04-10T000000.html"
              test="count(hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.402'])&lt;=1">(Diametermaterial): element hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.402'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.402
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.402']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.402']
Item: (Diametermaterial)
-->

   <rule context="*[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.402']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.402']"
         id="tmp-r-79bd9fa3-3776-42e3-bdda-3eb41809cd98">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.402-2012-04-10T000000.html"
              test="string(@classCode)=('OBS')">(Diametermaterial): de waarde van @classCode MOET 'OBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.402-2012-04-10T000000.html"
              test="string(@moodCode)=('EVN')">(Diametermaterial): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.402-2012-04-10T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.402'])&gt;=1 ">(Diametermaterial): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.402'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.402-2012-04-10T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.402'])&lt;=1">(Diametermaterial): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.402'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.402-2012-04-10T000000.html"
              test="count(hl7:code[(@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(hl7:code[(@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Diametermaterial): element hl7:code[(@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.402-2012-04-10T000000.html"
              test="count(hl7:code[(@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Diametermaterial): element hl7:code[(@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.402-2012-04-10T000000.html"
              test="count(hl7:value)&gt;=1 ">(Diametermaterial): element hl7:value is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.402-2012-04-10T000000.html"
              test="count(hl7:value)&lt;=1">(Diametermaterial): element hl7:value komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.402
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.402']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.402']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.402']
Item: (Diametermaterial)
-->

   <rule context="*[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.402']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.402']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.402']"
         id="tmp-r-774144ee-c0b1-48ab-99cd-0dc50f224df1">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.402-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Diametermaterial): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.402-2012-04-10T000000.html"
              test="string(@root)=('2.16.840.1.113883.2.4.3.36.10.402')">(Diametermaterial): de waarde van @root MOET '2.16.840.1.113883.2.4.3.36.10.402' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.402
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.402']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.402']/hl7:code[(@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Diametermaterial)
-->

   <rule context="*[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.402']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.402']/hl7:code[(@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')]"
         id="tmp-r-d9e2f7b0-2302-4760-89d9-d38428d5e017">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.402-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Diametermaterial): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.402-2012-04-10T000000.html"
              test="@nullFlavor or (@code='384627007' and @codeSystem='2.16.840.1.113883.6.96')">(Diametermaterial): de elementwaarde MOET een zijn van 'code '384627007' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.402
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.402']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.402']/hl7:value
Item: (Diametermaterial)
-->

   <rule context="*[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.402']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.402']/hl7:value"
         id="tmp-r-b670529c-e488-48f5-973d-a4887a44848f">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.402-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PQ' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Diametermaterial): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PQ" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="PQ"/>
      <let name="theValue" value="@value"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.402-2012-04-10T000000.html"
              test="(@nullFlavor or (@unit='cm' and number($theValue)&gt;=0.1 and number($theValue)&lt;=20.0 and (matches(string($theValue), '^[-+]?[0-9]*\.[0-9]{1,99}$'))))">(Diametermaterial): value MOET eenheid 'cm' gebruiken en in bereik [0.1..20.0] liggen  en tot op minstens 1 decimalen nauwkeurig zijn </assert>
      <let name="digitok"
           value="matches(string(@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.402-2012-04-10T000000.html"
              test="$digitok or @nullFlavor">(Diametermaterial): @value is geen geldig PQ getal <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.402-2012-04-10T000000.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(Diametermaterial): value/@unit (PQ) MOET een geldige UCUM-eenheid zijn (<value-of select="$UCUMtest"/>).</assert>
   </rule>
</pattern>
