<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.36.10.407
Name: Tumor extent of invasion
Description: Template: Invasiediepte
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.36.10.407-2012-04-10T000000">
   <title>Tumor extent of invasion</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.407
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.407']]
Item: (Tumorextentofinvasion)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.407
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.407']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.407']
Item: (Tumorextentofinvasion)
-->

   <rule context="*[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.407']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.407']"
         id="tmp-r-d18ee6d8-6e14-47e0-a80f-dce09a882b3e">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.407-2012-04-10T000000.html"
              test="string(@classCode)=('OBS')">(Tumorextentofinvasion): de waarde van @classCode MOET 'OBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.407-2012-04-10T000000.html"
              test="string(@moodCode)=('EVN')">(Tumorextentofinvasion): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.407-2012-04-10T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.407'])&gt;=1 ">(Tumorextentofinvasion): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.407'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.407-2012-04-10T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.407'])&lt;=1">(Tumorextentofinvasion): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.407'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.407-2012-04-10T000000.html"
              test="count(hl7:code[(@code='371487005' and @codeSystem='2.16.840.1.113883.6.96')])&gt;=1 and not(hl7:code[(@code='371487005' and @codeSystem='2.16.840.1.113883.6.96')]/@nullFlavor)">(Tumorextentofinvasion): element hl7:code[(@code='371487005' and @codeSystem='2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.407-2012-04-10T000000.html"
              test="count(hl7:code[(@code='371487005' and @codeSystem='2.16.840.1.113883.6.96')])&lt;=1">(Tumorextentofinvasion): element hl7:code[(@code='371487005' and @codeSystem='2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.407-2012-04-10T000000.html"
              test="count(hl7:value)&gt;=1 ">(Tumorextentofinvasion): element hl7:value is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.407-2012-04-10T000000.html"
              test="count(hl7:value)&lt;=1">(Tumorextentofinvasion): element hl7:value komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.407
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.407']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.407']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.407']
Item: (Tumorextentofinvasion)
-->

   <rule context="*[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.407']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.407']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.407']"
         id="tmp-r-1a3f5f09-1395-40c8-8ff4-707cf26793c0">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.407-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Tumorextentofinvasion): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.407-2012-04-10T000000.html"
              test="string(@root)=('2.16.840.1.113883.2.4.3.36.10.407')">(Tumorextentofinvasion): de waarde van @root MOET '2.16.840.1.113883.2.4.3.36.10.407' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.407
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.407']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.407']/hl7:code[(@code='371487005' and @codeSystem='2.16.840.1.113883.6.96')]
Item: (Tumorextentofinvasion)
-->

   <rule context="*[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.407']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.407']/hl7:code[(@code='371487005' and @codeSystem='2.16.840.1.113883.6.96')]"
         id="tmp-r-ae044c9c-0c10-4438-946d-864213ccafec">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.407-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Tumorextentofinvasion): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.407-2012-04-10T000000.html"
              test="@nullFlavor or (@code='371487005' and @codeSystem='2.16.840.1.113883.6.96')">(Tumorextentofinvasion): de elementwaarde MOET een zijn van 'code '371487005' codeSystem '2.16.840.1.113883.6.96''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.407
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.407']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.407']/hl7:value
Item: (Tumorextentofinvasion)
-->

   <rule context="*[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.407']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.407']/hl7:value"
         id="tmp-r-ed8aebcf-557a-4dbd-bf5b-cf9745f9fbde">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.407-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PQ' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Tumorextentofinvasion): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PQ" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="PQ"/>
      <let name="theValue" value="@value"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.407-2012-04-10T000000.html"
              test="(@nullFlavor or (@unit='cm'))">(Tumorextentofinvasion): value MOET eenheid 'cm' gebruiken </assert>
      <let name="digitok"
           value="matches(string(@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.407-2012-04-10T000000.html"
              test="$digitok or @nullFlavor">(Tumorextentofinvasion): @value is geen geldig PQ getal <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.407-2012-04-10T000000.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(Tumorextentofinvasion): value/@unit (PQ) MOET een geldige UCUM-eenheid zijn (<value-of select="$UCUMtest"/>).</assert>
   </rule>
</pattern>
