<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.36.10.409
Name: Kikuchi level
Description: Template: Kikuchi level (for sessile/flat tumours): sm1 / sm2 / sm3
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.36.10.409-2012-04-10T000000">
   <title>Kikuchi level</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.409
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.409']]
Item: (Kikuchilevel)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.409
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.409']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.409']
Item: (Kikuchilevel)
-->

   <rule context="*[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.409']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.409']"
         id="tmp-r-c723b4b4-be68-4283-9b7c-febf09e2f374">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.409-2012-04-10T000000.html"
              test="string(@classCode)=('OBS')">(Kikuchilevel): de waarde van @classCode MOET 'OBS' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.409-2012-04-10T000000.html"
              test="string(@moodCode)=('EVN')">(Kikuchilevel): de waarde van @moodCode MOET 'EVN' zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.409-2012-04-10T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.409'])&gt;=1 ">(Kikuchilevel): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.409'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.409-2012-04-10T000000.html"
              test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.409'])&lt;=1">(Kikuchilevel): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.409'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.409-2012-04-10T000000.html"
              test="count(hl7:code[(@code='C155090' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.100')])&gt;=1 and not(hl7:code[(@code='C155090' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.100')]/@nullFlavor)">(Kikuchilevel): element hl7:code[(@code='C155090' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.100')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.409-2012-04-10T000000.html"
              test="count(hl7:code[(@code='C155090' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.100')])&lt;=1">(Kikuchilevel): element hl7:code[(@code='C155090' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.100')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.409-2012-04-10T000000.html"
              test="count(hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.12-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.12-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])&gt;=1 ">(Kikuchilevel): element hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.12-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.12-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.409-2012-04-10T000000.html"
              test="count(hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.12-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.12-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])&lt;=1">(Kikuchilevel): element hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.12-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.12-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.409
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.409']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.409']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.409']
Item: (Kikuchilevel)
-->

   <rule context="*[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.409']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.409']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.409']"
         id="tmp-r-dbc6a8c9-522f-4a65-8736-d86072026f24">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.409-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Kikuchilevel): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.409-2012-04-10T000000.html"
              test="string(@root)=('2.16.840.1.113883.2.4.3.36.10.409')">(Kikuchilevel): de waarde van @root MOET '2.16.840.1.113883.2.4.3.36.10.409' zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.409
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.409']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.409']/hl7:code[(@code='C155090' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.100')]
Item: (Kikuchilevel)
-->

   <rule context="*[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.409']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.409']/hl7:code[(@code='C155090' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.100')]"
         id="tmp-r-bb83965e-f944-45a8-b8ec-baa735c09de0">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.409-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Kikuchilevel): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.409-2012-04-10T000000.html"
              test="@nullFlavor or (@code='C155090' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.100')">(Kikuchilevel): de elementwaarde MOET een zijn van 'code 'C155090' codeSystem '2.16.840.1.113883.2.4.3.36.77.5.100''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.36.10.409
Context: *[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.409']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.409']/hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.12-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.12-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]
Item: (Kikuchilevel)
-->

   <rule context="*[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.409']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.409']/hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.12-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.12-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]"
         id="tmp-r-05bd3e43-bfdb-4b2c-b18e-82208aa8323a">
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.409-2012-04-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(Kikuchilevel): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <extends rule="CE"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.409-2012-04-10T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.12-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(Kikuchilevel): de elementwaarde MOET een zijn van 'vs_kikuchi Kikuchi (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.12-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.409-2012-04-10T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(Kikuchilevel): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_kikuchi Kikuchi (DYNAMISCH).</assert>
   </rule>
</pattern>
