<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<xsl:stylesheet xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                xmlns:saxon="http://saxon.sf.net/"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:schold="http://www.ascc.net/xml/schematron"
                xmlns:iso="http://purl.oclc.org/dsdl/schematron"
                xmlns:xhtml="http://www.w3.org/1999/xhtml"
                xmlns:hl7="urn:hl7-org:v3"
                xmlns:cda="urn:hl7-org:v3"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                xmlns:lab="urn:oid:2.16.840.1.113883.2.4.6.10.35.81"
                version="2.0"><!--Implementers: please note that overriding process-prolog or process-root is 
    the preferred method for meta-stylesheets to use where possible. -->
   <xsl:param name="archiveDirParameter"/>
   <xsl:param name="archiveNameParameter"/>
   <xsl:param name="fileNameParameter"/>
   <xsl:param name="fileDirParameter"/>
   <xsl:variable name="document-uri">
      <xsl:value-of select="document-uri(/)"/>
   </xsl:variable>

   <!--PHASES-->


   <!--PROLOG-->
   <xsl:output method="text"/>

   <!--XSD TYPES FOR XSLT2-->


   <!--KEYS AND FUNCTIONS-->


   <!--DEFAULT RULES-->


   <!--MODE: SCHEMATRON-SELECT-FULL-PATH-->
   <!--This mode can be used to generate an ugly though full XPath for locators-->
   <xsl:template match="*" mode="schematron-select-full-path">
      <xsl:apply-templates select="." mode="schematron-get-full-path"/>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-->
   <!--This mode can be used to generate an ugly though full XPath for locators-->
   <xsl:template match="*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">
            <xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>*:</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>[namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="preceding"
                    select="count(preceding-sibling::*[local-name()=local-name(current())                                   and namespace-uri() = namespace-uri(current())])"/>
      <xsl:text>[</xsl:text>
      <xsl:value-of select="1+ $preceding"/>
      <xsl:text>]</xsl:text>
   </xsl:template>
   <xsl:template match="@*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">@<xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>@*[local-name()='</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>' and namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-2-->
   <!--This mode can be used to generate prefixed XPath for humans-->
   <xsl:template match="node() | @*" mode="schematron-get-full-path-2">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="preceding-sibling::*[name(.)=name(current())]">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>
   <!--MODE: SCHEMATRON-FULL-PATH-3-->
   <!--This mode can be used to generate prefixed XPath for humans 
	(Top-level element has index)-->
   <xsl:template match="node() | @*" mode="schematron-get-full-path-3">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="parent::*">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>

   <!--MODE: GENERATE-ID-FROM-PATH -->
   <xsl:template match="/" mode="generate-id-from-path"/>
   <xsl:template match="text()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')"/>
   </xsl:template>
   <xsl:template match="comment()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')"/>
   </xsl:template>
   <xsl:template match="processing-instruction()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.@', name())"/>
   </xsl:template>
   <xsl:template match="*" mode="generate-id-from-path" priority="-0.5">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:text>.</xsl:text>
      <xsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')"/>
   </xsl:template>

   <!--MODE: GENERATE-ID-2 -->
   <xsl:template match="/" mode="generate-id-2">U</xsl:template>
   <xsl:template match="*" mode="generate-id-2" priority="2">
      <xsl:text>U</xsl:text>
      <xsl:number level="multiple" count="*"/>
   </xsl:template>
   <xsl:template match="node()" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>n</xsl:text>
      <xsl:number count="node()"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="string-length(local-name(.))"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="translate(name(),':','.')"/>
   </xsl:template>
   <!--Strip characters-->
   <xsl:template match="text()" priority="-1"/>

   <!--SCHEMA SETUP-->
   <xsl:template match="/">
      <xsl:apply-templates select="/" mode="M6"/>
      <xsl:apply-templates select="/" mode="M7"/>
      <xsl:apply-templates select="/" mode="M8"/>
      <xsl:apply-templates select="/" mode="M9"/>
      <xsl:apply-templates select="/" mode="M10"/>
      <xsl:apply-templates select="/" mode="M11"/>
      <xsl:apply-templates select="/" mode="M12"/>
      <xsl:apply-templates select="/" mode="M13"/>
      <xsl:apply-templates select="/" mode="M14"/>
      <xsl:apply-templates select="/" mode="M15"/>
      <xsl:apply-templates select="/" mode="M16"/>
      <xsl:apply-templates select="/" mode="M17"/>
      <xsl:apply-templates select="/" mode="M18"/>
      <xsl:apply-templates select="/" mode="M19"/>
      <xsl:apply-templates select="/" mode="M20"/>
      <xsl:apply-templates select="/" mode="M21"/>
      <xsl:apply-templates select="/" mode="M22"/>
      <xsl:apply-templates select="/" mode="M23"/>
      <xsl:apply-templates select="/" mode="M24"/>
      <xsl:apply-templates select="/" mode="M25"/>
      <xsl:apply-templates select="/" mode="M26"/>
      <xsl:apply-templates select="/" mode="M27"/>
      <xsl:apply-templates select="/" mode="M28"/>
      <xsl:apply-templates select="/" mode="M29"/>
      <xsl:apply-templates select="/" mode="M30"/>
      <xsl:apply-templates select="/" mode="M31"/>
      <xsl:apply-templates select="/" mode="M32"/>
      <xsl:apply-templates select="/" mode="M33"/>
      <xsl:apply-templates select="/" mode="M34"/>
      <xsl:apply-templates select="/" mode="M35"/>
      <xsl:apply-templates select="/" mode="M36"/>
      <xsl:apply-templates select="/" mode="M37"/>
      <xsl:apply-templates select="/" mode="M38"/>
      <xsl:apply-templates select="/" mode="M39"/>
      <xsl:apply-templates select="/" mode="M40"/>
      <xsl:apply-templates select="/" mode="M41"/>
      <xsl:apply-templates select="/" mode="M42"/>
      <xsl:apply-templates select="/" mode="M43"/>
      <xsl:apply-templates select="/" mode="M44"/>
      <xsl:apply-templates select="/" mode="M45"/>
      <xsl:apply-templates select="/" mode="M46"/>
      <xsl:apply-templates select="/" mode="M47"/>
      <xsl:apply-templates select="/" mode="M48"/>
      <xsl:apply-templates select="/" mode="M49"/>
      <xsl:apply-templates select="/" mode="M50"/>
      <xsl:apply-templates select="/" mode="M51"/>
   </xsl:template>

   <!--SCHEMATRON PATTERNS-->


   <!--PATTERN -->
   <xsl:template match="text()" priority="-1" mode="M6"/>
   <xsl:template match="@*|node()" priority="-2" mode="M6">
      <xsl:apply-templates select="*" mode="M6"/>
   </xsl:template>

   <!--PATTERN template-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000Resultaatdocument MDL bevolkingsonderzoek darmkanker-->


	  <!--RULE tmp-r-29aa2b56-56b1-4ced-acf4-912694a762f3-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']"
                 priority="1290"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:realmCode[@code='NL'])&gt;=1 and not(hl7:realmCode[@code='NL']/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:realmCode[@code='NL'] is mandatory [min 1x]. (count(hl7:realmCode[@code='NL'])&gt;=1 and not(hl7:realmCode[@code='NL']/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:realmCode[@code='NL'])&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:realmCode[@code='NL'] komt te vaak voor [max 1x]. (count(hl7:realmCode[@code='NL'])&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:typeId[@root='2.16.840.1.113883.1.3'])&gt;=1 and not(hl7:typeId[@root='2.16.840.1.113883.1.3']/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:typeId[@root='2.16.840.1.113883.1.3'] is mandatory [min 1x]. (count(hl7:typeId[@root='2.16.840.1.113883.1.3'])&gt;=1 and not(hl7:typeId[@root='2.16.840.1.113883.1.3']/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:typeId[@root='2.16.840.1.113883.1.3'])&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:typeId[@root='2.16.840.1.113883.1.3'] komt te vaak voor [max 1x]. (count(hl7:typeId[@root='2.16.840.1.113883.1.3'])&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.11'])&gt;=1 and not(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.11']/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.11'] is mandatory [min 1x]. (count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.11'])&gt;=1 and not(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.11']/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.11'])&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.11'] komt te vaak voor [max 1x]. (count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.11'])&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1'])&gt;=1 and not(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1']/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1'] is mandatory [min 1x]. (count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1'])&gt;=1 and not(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1']/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1'])&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1'] komt te vaak voor [max 1x]. (count(hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1'])&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id)&gt;=1 and not(hl7:id/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:id is mandatory [min 1x]. (count(hl7:id)&gt;=1 and not(hl7:id/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:id komt te vaak voor [max 1x]. (count(hl7:id)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')])&gt;=1 and not(hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')] is mandatory [min 1x]. (count(hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')])&gt;=1 and not(hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')])&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')] komt te vaak voor [max 1x]. (count(hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')])&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:title komt te vaak voor [max 1x]. (count(hl7:title)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime)&gt;=1 and not(hl7:effectiveTime/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:effectiveTime is mandatory [min 1x]. (count(hl7:effectiveTime)&gt;=1 and not(hl7:effectiveTime/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:effectiveTime komt te vaak voor [max 1x]. (count(hl7:effectiveTime)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])&gt;=1 and not(hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)] is mandatory [min 1x]. (count(hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])&gt;=1 and not(hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)] komt te vaak voor [max 1x]. (count(hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:languageCode)&gt;=1 and not(hl7:languageCode/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:languageCode is mandatory [min 1x]. (count(hl7:languageCode)&gt;=1 and not(hl7:languageCode/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:languageCode)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:languageCode komt te vaak voor [max 1x]. (count(hl7:languageCode)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:setId)&gt;=1 and not(hl7:setId/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:setId is mandatory [min 1x]. (count(hl7:setId)&gt;=1 and not(hl7:setId/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:setId)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:setId komt te vaak voor [max 1x]. (count(hl7:setId)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:versionNumber)&gt;=1 and not(hl7:versionNumber/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:versionNumber is mandatory [min 1x]. (count(hl7:versionNumber)&gt;=1 and not(hl7:versionNumber/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:versionNumber)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:versionNumber komt te vaak voor [max 1x]. (count(hl7:versionNumber)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:recordTarget)&gt;=1 and not(hl7:recordTarget/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:recordTarget is mandatory [min 1x]. (count(hl7:recordTarget)&gt;=1 and not(hl7:recordTarget/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:recordTarget)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:recordTarget komt te vaak voor [max 1x]. (count(hl7:recordTarget)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100'])&gt;=1 and not(hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100']/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100'] is mandatory [min 1x]. (count(hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100'])&gt;=1 and not(hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100']/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100'])&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100'] komt te vaak voor [max 1x]. (count(hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100'])&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:custodian)&gt;=1 and not(hl7:custodian/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:custodian is mandatory [min 1x]. (count(hl7:custodian)&gt;=1 and not(hl7:custodian/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:custodian)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:custodian komt te vaak voor [max 1x]. (count(hl7:custodian)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:legalAuthenticator)&gt;=1 "/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:legalAuthenticator is required [min 1x]. (count(hl7:legalAuthenticator)&gt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:legalAuthenticator)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:legalAuthenticator komt te vaak voor [max 1x]. (count(hl7:legalAuthenticator)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:participant)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:participant komt te vaak voor [max 1x]. (count(hl7:participant)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-cb5d6df6-1dc3-4ccf-b035-fcbd2291db48-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:realmCode[@code='NL']"
                 priority="1289"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDArealmCode): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900800-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CS: @code/@typeCode and @nullFlavor are mutually exclusive ((@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CS: cannot have codeSystem (not(@codeSystem) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CS: cannot have codeSystemName (not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CS: cannot have codeSystemVersion (not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CS: cannot have displayName (not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CS: cannot have originalText (not(hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CS: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-CS: cannot have translation (not(hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (@code='NL')"/>
         <xsl:otherwise>
            <xsl:message>(CDArealmCode): de elementwaarde MOET een zijn van 'code 'NL''. (@nullFlavor or (@code='NL') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900800-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-1d160d9a-7b61-4233-bc04-edd0b32f06e9-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:typeId[@root='2.16.840.1.113883.1.3']"
                 priority="1288"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDAtypeId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900801-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="OIDpattern" select="'^[0-2](\.(0|[1-9]\d*))*$'"/>
      <xsl:variable name="RUIDpattern" select="'^[A-Za-z][A-Za-z\d\-]*$'"/>
      <xsl:variable name="UUIDpattern"
                    select="'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-II: @root SHALL be a syntactically correct OID, UUID. (not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern)))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10a-II: @root SHALL NOT be a RUID. Identifiers in this scheme are only defined by balloted HL7 specifications. Local communities or systems must never use such reserved identifiers based on bilateral negotiations. (not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <xsl:variable name="root" select="@root"/>
      <xsl:variable name="extension" select="@extension"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-II: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL be distinct (not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="UUIDpattern"
                    select="'^[0-9a-fA-F]{8}-[0-9a-fA-f]{4}-[0-9a-fA-F]{4}-[0-9a-aA-F]{4}-[0-9a-fA-F]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]'))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-II: When UUID is used, the hexadecimal digits A-F SHALL be in upper case (not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@extension)=('POCD_HD000040')"/>
         <xsl:otherwise>
            <xsl:message>(CDAtypeId): de waarde van @extension MOET 'POCD_HD000040' zijn. (string(@extension)=('POCD_HD000040') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900801-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root)=('2.16.840.1.113883.1.3')"/>
         <xsl:otherwise>
            <xsl:message>(CDAtypeId): de waarde van @root MOET '2.16.840.1.113883.1.3' zijn. (string(@root)=('2.16.840.1.113883.1.3') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900801-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-85df2e0a-b048-4d1f-a453-e5a58a24a421-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.11']"
                 priority="1287"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="OIDpattern" select="'^[0-2](\.(0|[1-9]\d*))*$'"/>
      <xsl:variable name="RUIDpattern" select="'^[A-Za-z][A-Za-z\d\-]*$'"/>
      <xsl:variable name="UUIDpattern"
                    select="'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-II: @root SHALL be a syntactically correct OID, UUID. (not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern)))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10a-II: @root SHALL NOT be a RUID. Identifiers in this scheme are only defined by balloted HL7 specifications. Local communities or systems must never use such reserved identifiers based on bilateral negotiations. (not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <xsl:variable name="root" select="@root"/>
      <xsl:variable name="extension" select="@extension"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-II: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL be distinct (not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="UUIDpattern"
                    select="'^[0-9a-fA-F]{8}-[0-9a-fA-f]{4}-[0-9a-fA-F]{4}-[0-9a-aA-F]{4}-[0-9a-fA-F]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]'))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-II: When UUID is used, the hexadecimal digits A-F SHALL be in upper case (not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root)=('2.16.840.1.113883.2.4.3.36.10.11')"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): de waarde van @root MOET '2.16.840.1.113883.2.4.3.36.10.11' zijn. (string(@root)=('2.16.840.1.113883.2.4.3.36.10.11') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-d8f41a28-2181-4752-8f7a-f0e6687d0792-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1']"
                 priority="1286"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="OIDpattern" select="'^[0-2](\.(0|[1-9]\d*))*$'"/>
      <xsl:variable name="RUIDpattern" select="'^[A-Za-z][A-Za-z\d\-]*$'"/>
      <xsl:variable name="UUIDpattern"
                    select="'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-II: @root SHALL be a syntactically correct OID, UUID. (not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern)))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10a-II: @root SHALL NOT be a RUID. Identifiers in this scheme are only defined by balloted HL7 specifications. Local communities or systems must never use such reserved identifiers based on bilateral negotiations. (not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <xsl:variable name="root" select="@root"/>
      <xsl:variable name="extension" select="@extension"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-II: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL be distinct (not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="UUIDpattern"
                    select="'^[0-9a-fA-F]{8}-[0-9a-fA-f]{4}-[0-9a-fA-F]{4}-[0-9a-aA-F]{4}-[0-9a-fA-F]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]'))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-II: When UUID is used, the hexadecimal digits A-F SHALL be in upper case (not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root)=('2.16.840.1.113883.2.4.3.36.10.1')"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): de waarde van @root MOET '2.16.840.1.113883.2.4.3.36.10.1' zijn. (string(@root)=('2.16.840.1.113883.2.4.3.36.10.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-52be31ec-fd84-4de4-afee-d2c3a7eadd83-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:id"
                 priority="1285"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDAid): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900802-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="OIDpattern" select="'^[0-2](\.(0|[1-9]\d*))*$'"/>
      <xsl:variable name="RUIDpattern" select="'^[A-Za-z][A-Za-z\d\-]*$'"/>
      <xsl:variable name="UUIDpattern"
                    select="'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-II: @root SHALL be a syntactically correct OID, UUID. (not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern)))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10a-II: @root SHALL NOT be a RUID. Identifiers in this scheme are only defined by balloted HL7 specifications. Local communities or systems must never use such reserved identifiers based on bilateral negotiations. (not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <xsl:variable name="root" select="@root"/>
      <xsl:variable name="extension" select="@extension"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-II: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL be distinct (not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="UUIDpattern"
                    select="'^[0-9a-fA-F]{8}-[0-9a-fA-f]{4}-[0-9a-fA-F]{4}-[0-9a-aA-F]{4}-[0-9a-fA-F]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]'))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-II: When UUID is used, the hexadecimal digits A-F SHALL be in upper case (not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-c980af94-f139-4926-85e3-e089390c4516-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]"
                 priority="1284"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CD: null or code and/or originalText (@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CD: code requires codeSystem (@codeSystem or not(@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CD: codeSystemName only if codeSystem (@codeSystem or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CD: codeSystemVersion only if codeSystem (@codeSystem or not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CD: displayName only if code (@code or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@code))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CD: no code if null (not(@nullFlavor) or (@nullFlavor and not(@code)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CD: no displayName if null (not(@nullFlavor) or (@nullFlavor and not(@displayName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-CD: no null on translations (Exceptional values (NULL-values) can not be elements of a set.) (not(.//hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystem][not(@code)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-11-CD: translation code requires codeSystem (not(.//hl7:translation[@codeSystem][not(@code)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystemName][not(@codeSystem)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-CD: translation codeSystemName only if codeSystem (not(.//hl7:translation[@codeSystemName][not(@codeSystem)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-CD: translation codeSystemVersion only if codeSystem (not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@displayName][not(@code)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-14-CD: translation displayName only if code (not(.//hl7:translation[@displayName][not(@code)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="matches(@displayName,'[\r\n\t]')">
         <xsl:message>dtr1-15-CD: it looks like there are formatting instructions in attribute @displayName. Please note that this may lead to
        interoperability problems. (matches(@displayName,'[\r\n\t]') / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-17-CD: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="code" select="@code"/>
      <xsl:variable name="codeSystem" select="@codeSystem"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@code=$code][@codeSystem=$codeSystem])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-18-CD: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (@code=<xsl:text/>
               <xsl:value-of select="$code"/>
               <xsl:text/> @codeSystem=<xsl:text/>
               <xsl:value-of select="$codeSystem"/>
               <xsl:text/>) SHALL be distinct (not($set_other[@code=$code][@codeSystem=$codeSystem]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="translations"
                    select=".//hl7:translation/concat(@code,@codeSystem)"/>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count($translations)=count(distinct-values($translations))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-19-CD: [RIM-002] translations SHALL be distinct (count($translations)=count(distinct-values($translations)) / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <xsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-20-CD: originalText/@language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CE: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): de elementwaarde MOET een zijn van 'code '18746-8' codeSystem '2.16.840.1.113883.6.1''. (@nullFlavor or (@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-bae584d3-69f1-4a90-ba0d-4d44e54dbc51-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:title"
                 priority="1283"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ST' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDAtitle): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='ST' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900803-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or count(*)&gt;0  or text()[string-length(normalize-space())&gt;0]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-BIN: there must be a nullFlavor, or content must be non-empty (@nullFlavor or count(*)&gt;0 or text()[string-length(normalize-space())&gt;0] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@integrityCheck) or @integrityCheckAlgorithm"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-ED: integrityCheckAlgorithm required if integrityCheck (not(@integrityCheck) or @integrityCheckAlgorithm / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-ED: thumbnails not null and reference (not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-ED: thumbnails do not have thumbnails (not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-ED: compression only on binary ((@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain'))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-ED: value implies mediaType is text/plain (not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-ED: no history or updateMode (count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value or xml) or not(@charset)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-ED: no charset for value or xml (not(@value or xml) or not(@charset) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:translation) or hl7:thumbnail[not(hl7:translation)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-9-ED: no nested translations (not(hl7:translation) or hl7:thumbnail[not(hl7:translation)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@mediaType))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-ED: no mediaType if null (not(@nullFlavor) or (@nullFlavor and not(@mediaType)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@charset))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-11-ED: no charset if null (not(@nullFlavor) or (@nullFlavor and not(@charset)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@language))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-ED: no language if null (not(@nullFlavor) or (@nullFlavor and not(@language)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@compression))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-ED: no compression if null (not(@nullFlavor) or (@nullFlavor and not(@compression)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@integrityCheck))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-14-ED: no integrityCheck if null (not(@nullFlavor) or (@nullFlavor and not(@integrityCheck)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@integrityCheckAlgorithm))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-15-ED: no integrityCheckAlgorithm if null (not(@nullFlavor) or (@nullFlavor and not(@integrityCheckAlgorithm)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-16-ED: no thumbnail if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(hl7:translation))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-17-ED: no translation if null (not(@nullFlavor) or (@nullFlavor and not(hl7:translation)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <xsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@language) or matches(@language,$RFC3066,'i')"/>
         <xsl:otherwise>
            <xsl:message>dtr1-18-ED: @language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(@language) or matches(@language,$RFC3066,'i') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:reference)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-ST: no reference (not(hl7:reference) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:thumbnail)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-ST: no thumbnail (not(hl7:thumbnail) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@representation) or @representation='TXT'"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-ST: @representation SHALL be 'TXT' if present. (not(@representation) or @representation='TXT' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@mediaType) or @mediaType='text/plain'"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-ST: @mediaType SHALL be 'text/plain' if present. (not(@mediaType) or @mediaType='text/plain' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@compression)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-ST: @compression SHALL NOT be used on ST. (not(@compression) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@integrityCheck)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-ST: @integrityCheck SHALL NOT be used on ST. (not(@integrityCheck) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@integrityCheckAlgorithm)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-ST: @integrityCheckAlgorithm SHALL NOT be used on ST. (not(@integrityCheckAlgorithm) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-c1c337ed-07e6-4861-9c4b-237d7455883f-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:effectiveTime"
                 priority="1282"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDAeffectiveTime): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900804-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-QTY: no uncertainty (not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-QTY: no history or updateMode (count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-QTY: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="value" select="@value"/>
      <xsl:variable name="unit" select="@unit"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@value=$value][@unit=$unit])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-QTY: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (@value=<xsl:text/>
               <xsl:value-of select="$value"/>
               <xsl:text/> @unit=<xsl:text/>
               <xsl:value-of select="$unit"/>
               <xsl:text/>) SHALL be distinct (not($set_other[@value=$value][@unit=$unit]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(@nullFlavor or @value or *) and not(@nullFlavor and @value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-TS: null or value or child element in case of extension ((@nullFlavor or @value or *) and not(@nullFlavor and @value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theTS" select="@value"/>
      <xsl:variable name="theBC" select="if (starts-with($theTS,'-')) then '-' else ()"/>
      <xsl:variable name="theTZ" select="replace($theTS,'-?[^+-]+([+-].*)?$','$1')"/>
      <xsl:variable name="theTZh"
                    select="if (string-length($theTZ)&gt;0) then substring($theTZ,1,3) else ()"/>
      <xsl:variable name="theTZm"
                    select="if (string-length($theTZ)&gt;3) then substring($theTZ,4) else ()"/>
      <xsl:variable name="theBaseTS" select="replace($theTS,'^-?([^+-]+)([+-].*)?','$1')"/>
      <xsl:variable name="theCentury"
                    select="if (substring($theBaseTS,1,2) castable as xs:integer) then substring($theBaseTS,1,2) else ()"/>
      <xsl:variable name="theYear"
                    select="if (substring($theBaseTS,3,2) castable as xs:integer) then substring($theBaseTS,3,2) else ()"/>
      <xsl:variable name="theMonth"
                    select="if (substring($theBaseTS,5,2) castable as xs:integer) then substring($theBaseTS,5,2) else ()"/>
      <xsl:variable name="theDay"
                    select="if (substring($theBaseTS,7,2) castable as xs:integer) then substring($theBaseTS,7,2) else ()"/>
      <xsl:variable name="theHour"
                    select="if (substring($theBaseTS,9,2) castable as xs:integer) then substring($theBaseTS,9,2) else ()"/>
      <xsl:variable name="theMinute"
                    select="if (substring($theBaseTS,11,2) castable as xs:integer) then substring($theBaseTS,11,2) else ()"/>
      <xsl:variable name="theSecond"
                    select="if (substring($theBaseTS,13,2) castable as xs:integer) then substring($theBaseTS,13,2) else ()"/>
      <xsl:variable name="theSubSecond"
                    select="if (substring($theBaseTS,16) castable as xs:integer) then substring($theBaseTS,15) else ()"/>
      <xsl:variable name="cCentury"
                    select="if (empty($theCentury)) then '00' else $theCentury"/>
      <xsl:variable name="cYear" select="if (empty($theYear)) then '00' else $theYear"/>
      <xsl:variable name="cMonth" select="if (empty($theMonth)) then '01' else $theMonth"/>
      <xsl:variable name="cDay" select="if (empty($theDay)) then '01' else $theDay"/>
      <xsl:variable name="cHour" select="if (empty($theHour)) then '00' else $theHour"/>
      <xsl:variable name="cMinute"
                    select="if (empty($theMinute)) then '00' else $theMinute"/>
      <xsl:variable name="cSecond"
                    select="if (empty($theSecond)) then '00' else $theSecond"/>
      <xsl:variable name="cTZ" select="string-join(($theTZh,$theTZm),':')"/>
      <xsl:variable name="theTSString"
                    select="string-join(($theBC,$theCentury,$theYear,$theMonth,$theDay,$theHour,$theMinute,$theSecond,$theSubSecond,$theTZ),'')"/>
      <xsl:variable name="theDateTime"
                    select="concat($theBC,$cCentury,$cYear,'-',$cMonth,'-',$cDay,'T',$cHour,':',$cMinute,':',$cSecond,$theSubSecond,$cTZ)"/>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="empty($theTS) or ($theTS=$theTSString and $theDateTime castable as xs:dateTime)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-TS: <xsl:text/>
               <xsl:value-of select="local-name()"/>
               <xsl:text/> "<xsl:text/>
               <xsl:value-of select="$theTS"/>
               <xsl:text/>" is not a valid timestamp. (empty($theTS) or ($theTS=$theTSString and $theDateTime castable as xs:dateTime) / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or matches(@value, '^[0-9]{14,14}')"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-TS.DATETIME.MIN: null or date precision of time stamp shall be at least YYYYMMDDhhmmss. (@nullFlavor or matches(@value, '^[0-9]{14,14}') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-81e59e10-02e4-4a19-8e23-d510dfe7a53d-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]"
                 priority="1281"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDAconfidentialityCode): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900805-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CD: null or code and/or originalText (@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CD: code requires codeSystem (@codeSystem or not(@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CD: codeSystemName only if codeSystem (@codeSystem or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CD: codeSystemVersion only if codeSystem (@codeSystem or not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CD: displayName only if code (@code or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@code))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CD: no code if null (not(@nullFlavor) or (@nullFlavor and not(@code)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CD: no displayName if null (not(@nullFlavor) or (@nullFlavor and not(@displayName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-CD: no null on translations (Exceptional values (NULL-values) can not be elements of a set.) (not(.//hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystem][not(@code)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-11-CD: translation code requires codeSystem (not(.//hl7:translation[@codeSystem][not(@code)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystemName][not(@codeSystem)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-CD: translation codeSystemName only if codeSystem (not(.//hl7:translation[@codeSystemName][not(@codeSystem)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-CD: translation codeSystemVersion only if codeSystem (not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@displayName][not(@code)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-14-CD: translation displayName only if code (not(.//hl7:translation[@displayName][not(@code)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="matches(@displayName,'[\r\n\t]')">
         <xsl:message>dtr1-15-CD: it looks like there are formatting instructions in attribute @displayName. Please note that this may lead to
        interoperability problems. (matches(@displayName,'[\r\n\t]') / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-17-CD: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="code" select="@code"/>
      <xsl:variable name="codeSystem" select="@codeSystem"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@code=$code][@codeSystem=$codeSystem])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-18-CD: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (@code=<xsl:text/>
               <xsl:value-of select="$code"/>
               <xsl:text/> @codeSystem=<xsl:text/>
               <xsl:value-of select="$codeSystem"/>
               <xsl:text/>) SHALL be distinct (not($set_other[@code=$code][@codeSystem=$codeSystem]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="translations"
                    select=".//hl7:translation/concat(@code,@codeSystem)"/>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count($translations)=count(distinct-values($translations))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-19-CD: [RIM-002] translations SHALL be distinct (count($translations)=count(distinct-values($translations)) / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <xsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-20-CD: originalText/@language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CE: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theCode" select="@code"/>
      <xsl:variable name="theCodeSystem" select="@codeSystem"/>
      <xsl:variable name="theCodeSystemVersion" select="@codeSystemVersion"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])"/>
         <xsl:otherwise>
            <xsl:message>(CDAconfidentialityCode): de elementwaarde MOET een zijn van 'BasicConfidentialityKind Basic Confidentiality Kind (HL7) (DYNAMISCH)'. (@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900805-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theNullFlavor" select="@nullFlavor"/>
      <xsl:variable name="validNullFlavorsFound"
                    select="exists(doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or $validNullFlavorsFound"/>
         <xsl:otherwise>
            <xsl:message>(CDAconfidentialityCode): de nulwaarde '<xsl:text/>
               <xsl:value-of select="@nullFlavor"/>
               <xsl:text/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst BasicConfidentialityKind Basic Confidentiality Kind (HL7) (DYNAMISCH). (not(@nullFlavor) or $validNullFlavorsFound / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900805-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-4c5b4219-83af-4cef-9279-bb8e64040d15-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:languageCode"
                 priority="1280"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDAlanguageCode): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900806-2012-03-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CS: @code/@typeCode and @nullFlavor are mutually exclusive ((@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CS: cannot have codeSystem (not(@codeSystem) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CS: cannot have codeSystemName (not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CS: cannot have codeSystemVersion (not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CS: cannot have displayName (not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CS: cannot have originalText (not(hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CS: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-CS: cannot have translation (not(hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <xsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or matches(@code,$RFC3066,'i')"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CS.LANG: @code SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(@code) or matches(@code,$RFC3066,'i') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-e13a50f4-5c10-4fe2-be46-fa43ab5d47a1-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:setId"
                 priority="1279"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDAsetIdversionNumber): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900807-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="OIDpattern" select="'^[0-2](\.(0|[1-9]\d*))*$'"/>
      <xsl:variable name="RUIDpattern" select="'^[A-Za-z][A-Za-z\d\-]*$'"/>
      <xsl:variable name="UUIDpattern"
                    select="'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-II: @root SHALL be a syntactically correct OID, UUID. (not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern)))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10a-II: @root SHALL NOT be a RUID. Identifiers in this scheme are only defined by balloted HL7 specifications. Local communities or systems must never use such reserved identifiers based on bilateral negotiations. (not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <xsl:variable name="root" select="@root"/>
      <xsl:variable name="extension" select="@extension"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-II: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL be distinct (not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="UUIDpattern"
                    select="'^[0-9a-fA-F]{8}-[0-9a-fA-f]{4}-[0-9a-fA-F]{4}-[0-9a-aA-F]{4}-[0-9a-fA-F]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]'))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-II: When UUID is used, the hexadecimal digits A-F SHALL be in upper case (not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-1c013971-6c69-4b98-b835-c18eb989a860-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:versionNumber"
                 priority="1278"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='INT' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDAsetIdversionNumber): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:INT" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='INT' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900807-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-QTY: no uncertainty (not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-QTY: no history or updateMode (count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-QTY: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="value" select="@value"/>
      <xsl:variable name="unit" select="@unit"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@value=$value][@unit=$unit])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-QTY: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (@value=<xsl:text/>
               <xsl:value-of select="$value"/>
               <xsl:text/> @unit=<xsl:text/>
               <xsl:value-of select="$unit"/>
               <xsl:text/>) SHALL be distinct (not($set_other[@value=$value][@unit=$unit]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(@nullFlavor or @value or *) and not(@nullFlavor and @value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-INT: null or value or child element in case of extension ((@nullFlavor or @value or *) and not(@nullFlavor and @value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:uncertainty)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-INT: no uncertainty (not(hl7:uncertainty) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or @value &gt;= 0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-INT.NONNEG: null or value &gt;= 0 (@nullFlavor or @value &gt;= 0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theValue" select="@value"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(@nullFlavor or (number($theValue)&gt;=1))"/>
         <xsl:otherwise>
            <xsl:message>(CDAsetIdversionNumber): value MOET in bereik [1..] liggen   ((@nullFlavor or (number($theValue)&gt;=1)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900807-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="digitok" select="matches(string(@value), '^-?[1-9]\d*$|^+?\d*$')"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="$digitok or @nullFlavor"/>
         <xsl:otherwise>
            <xsl:message>(CDAsetIdversionNumber): @value is geen geldig INT getal <xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>
       ($digitok or @nullFlavor / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900807-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-88966951-af80-4979-8b2f-1a4f826f3d42-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget"
                 priority="1277"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode)=('RCT')"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTargetMDL): de waarde van @typeCode MOET 'RCT' zijn. (string(@typeCode)=('RCT') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900830-2014-02-09T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patientRole)&gt;=1 and not(hl7:patientRole/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTargetMDL): element hl7:patientRole is mandatory [min 1x]. (count(hl7:patientRole)&gt;=1 and not(hl7:patientRole/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900830-2014-02-09T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patientRole)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTargetMDL): element hl7:patientRole komt te vaak voor [max 1x]. (count(hl7:patientRole)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900830-2014-02-09T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-91952d6d-a339-4dc5-bb6a-4aeaa0872a9a-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget/hl7:patientRole"
                 priority="1276"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode)=('PAT')"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTargetMDL): de waarde van @classCode MOET 'PAT' zijn. (string(@classCode)=('PAT') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900830-2014-02-09T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:id[not(@root='2.16.840.1.113883.2.4.6.3')]/@extension) or string-length(hl7:id[not(@root='2.16.840.1.113883.2.4.6.3')]/@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTargetMDL): Als er een id/@extensie wordt aangegeven mag deze niet leeg zijn (not(hl7:id[not(@root='2.16.840.1.113883.2.4.6.3')]/@extension) or string-length(hl7:id[not(@root='2.16.840.1.113883.2.4.6.3')]/@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900830-2014-02-09T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.3'])&gt;=1 and not(hl7:id[@root='2.16.840.1.113883.2.4.6.3']/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTargetMDL): element hl7:id[@root='2.16.840.1.113883.2.4.6.3'] is mandatory [min 1x]. (count(hl7:id[@root='2.16.840.1.113883.2.4.6.3'])&gt;=1 and not(hl7:id[@root='2.16.840.1.113883.2.4.6.3']/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900830-2014-02-09T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.3'])&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTargetMDL): element hl7:id[@root='2.16.840.1.113883.2.4.6.3'] komt te vaak voor [max 1x]. (count(hl7:id[@root='2.16.840.1.113883.2.4.6.3'])&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900830-2014-02-09T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[not(@root='2.16.840.1.113883.2.4.6.3')])&gt;=1 "/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTargetMDL): element hl7:id[not(@root='2.16.840.1.113883.2.4.6.3')] is required [min 1x]. (count(hl7:id[not(@root='2.16.840.1.113883.2.4.6.3')])&gt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900830-2014-02-09T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[not(@root='2.16.840.1.113883.2.4.6.3')])&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTargetMDL): element hl7:id[not(@root='2.16.840.1.113883.2.4.6.3')] komt te vaak voor [max 1x]. (count(hl7:id[not(@root='2.16.840.1.113883.2.4.6.3')])&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900830-2014-02-09T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-b2368b6f-a249-4bf3-bbcd-6df288da5a17-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget/hl7:patientRole/hl7:id[@root='2.16.840.1.113883.2.4.6.3']"
                 priority="1275"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(BurgerServiceNummer): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900014-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="OIDpattern" select="'^[0-2](\.(0|[1-9]\d*))*$'"/>
      <xsl:variable name="RUIDpattern" select="'^[A-Za-z][A-Za-z\d\-]*$'"/>
      <xsl:variable name="UUIDpattern"
                    select="'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-II: @root SHALL be a syntactically correct OID, UUID. (not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern)))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10a-II: @root SHALL NOT be a RUID. Identifiers in this scheme are only defined by balloted HL7 specifications. Local communities or systems must never use such reserved identifiers based on bilateral negotiations. (not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <xsl:variable name="root" select="@root"/>
      <xsl:variable name="extension" select="@extension"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-II: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL be distinct (not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="UUIDpattern"
                    select="'^[0-9a-fA-F]{8}-[0-9a-fA-f]{4}-[0-9a-fA-F]{4}-[0-9a-aA-F]{4}-[0-9a-fA-F]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]'))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-II: When UUID is used, the hexadecimal digits A-F SHALL be in upper case (not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or @root='2.16.840.1.113883.2.4.6.3'"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II.NL.BSN: Burgerservicenummer @root MOET 2.16.840.1.113883.2.4.6.3 zijn indien niet null (@nullFlavor or @root='2.16.840.1.113883.2.4.6.3' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II.NL.BSN: Burgerservicenummer MOET 9 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or (         (   number(substring(@extension,1,1))*9 )+         (   number(substring(@extension,2,1))*8 )+         (   number(substring(@extension,3,1))*7 )+         (   number(substring(@extension,4,1))*6 )+         (   number(substring(@extension,5,1))*5 )+         (   number(substring(@extension,6,1))*4 )+         (   number(substring(@extension,7,1))*3 )+         (   number(substring(@extension,8,1))*2 )+         (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-II.NL.BSN: Burgerservicenummer voldoet niet aan modulo 11 proef (not(@root='2.16.840.1.113883.2.4.6.3') or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root)=('2.16.840.1.113883.2.4.6.3')"/>
         <xsl:otherwise>
            <xsl:message>(BurgerServiceNummer): de waarde van @root MOET '2.16.840.1.113883.2.4.6.3' zijn. (string(@root)=('2.16.840.1.113883.2.4.6.3') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900014-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(BurgerServiceNummer): attribute @extension MOET aanwezig zijn. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900014-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-7157c954-185f-4898-afe7-4dfea6497c44-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget/hl7:patientRole/hl7:id[not(@root='2.16.840.1.113883.2.4.6.3')]"
                 priority="1274"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTargetMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900830-2014-02-09T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="OIDpattern" select="'^[0-2](\.(0|[1-9]\d*))*$'"/>
      <xsl:variable name="RUIDpattern" select="'^[A-Za-z][A-Za-z\d\-]*$'"/>
      <xsl:variable name="UUIDpattern"
                    select="'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-II: @root SHALL be a syntactically correct OID, UUID. (not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern)))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10a-II: @root SHALL NOT be a RUID. Identifiers in this scheme are only defined by balloted HL7 specifications. Local communities or systems must never use such reserved identifiers based on bilateral negotiations. (not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <xsl:variable name="root" select="@root"/>
      <xsl:variable name="extension" select="@extension"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-II: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL be distinct (not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="UUIDpattern"
                    select="'^[0-9a-fA-F]{8}-[0-9a-fA-f]{4}-[0-9a-fA-F]{4}-[0-9a-aA-F]{4}-[0-9a-fA-F]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]'))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-II: When UUID is used, the hexadecimal digits A-F SHALL be in upper case (not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-21b8a3fb-5dd5-4c79-9703-dcb30b796785-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian"
                 priority="1273"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode)=('CST')"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): de waarde van @typeCode MOET 'CST' zijn. (string(@typeCode)=('CST') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedCustodian)&gt;=1 and not(hl7:assignedCustodian/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): element hl7:assignedCustodian is mandatory [min 1x]. (count(hl7:assignedCustodian)&gt;=1 and not(hl7:assignedCustodian/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedCustodian)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): element hl7:assignedCustodian komt te vaak voor [max 1x]. (count(hl7:assignedCustodian)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-bf685ef0-4a40-4dd9-8107-d6c9f69c24b2-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian"
                 priority="1272"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode)=('ASSIGNED')"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): de waarde van @classCode MOET 'ASSIGNED' zijn. (string(@classCode)=('ASSIGNED') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedCustodianOrganization)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): element hl7:representedCustodianOrganization komt te vaak voor [max 1x]. (count(hl7:representedCustodianOrganization)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-e3e5ab8d-8754-48f2-9bdc-061bc86706a9-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization"
                 priority="1271"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode)=('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): de waarde van @classCode MOET 'ORG' zijn. (string(@classCode)=('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode)=('INSTANCE')"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): de waarde van @determinerCode MOET 'INSTANCE' zijn. (string(@determinerCode)=('INSTANCE') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="elmcount"
                    select="count(hl7:id[@root='2.16.528.1.1007.3.3']|hl7:id)"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="$elmcount&gt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id) bevat te weinig elementen [min 1x] ($elmcount&gt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[@root='2.16.528.1.1007.3.3'])&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): element hl7:id[@root='2.16.528.1.1007.3.3'] komt te vaak voor [max 1x]. (count(hl7:id[@root='2.16.528.1.1007.3.3'])&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): element hl7:name is mandatory [min 1x]. (count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): element hl7:name komt te vaak voor [max 1x]. (count(hl7:name)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): element hl7:addr komt te vaak voor [max 1x]. (count(hl7:addr)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(lab:code)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): element lab:code komt te vaak voor [max 1x]. (count(lab:code)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-db2b59be-d8fa-47b4-ab37-190bd4938021-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:id[@root='2.16.528.1.1007.3.3']"
                 priority="1270"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="OIDpattern" select="'^[0-2](\.(0|[1-9]\d*))*$'"/>
      <xsl:variable name="RUIDpattern" select="'^[A-Za-z][A-Za-z\d\-]*$'"/>
      <xsl:variable name="UUIDpattern"
                    select="'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-II: @root SHALL be a syntactically correct OID, UUID. (not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern)))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10a-II: @root SHALL NOT be a RUID. Identifiers in this scheme are only defined by balloted HL7 specifications. Local communities or systems must never use such reserved identifiers based on bilateral negotiations. (not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <xsl:variable name="root" select="@root"/>
      <xsl:variable name="extension" select="@extension"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-II: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL be distinct (not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="UUIDpattern"
                    select="'^[0-9a-fA-F]{8}-[0-9a-fA-f]{4}-[0-9a-fA-F]{4}-[0-9a-aA-F]{4}-[0-9a-fA-F]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]'))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-II: When UUID is used, the hexadecimal digits A-F SHALL be in upper case (not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root)=('2.16.528.1.1007.3.3')"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): de waarde van @root MOET '2.16.528.1.1007.3.3' zijn. (string(@root)=('2.16.528.1.1007.3.3') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-624eb762-95f7-4a76-804e-5116470a243a-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:id"
                 priority="1269"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="OIDpattern" select="'^[0-2](\.(0|[1-9]\d*))*$'"/>
      <xsl:variable name="RUIDpattern" select="'^[A-Za-z][A-Za-z\d\-]*$'"/>
      <xsl:variable name="UUIDpattern"
                    select="'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-II: @root SHALL be a syntactically correct OID, UUID. (not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern)))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10a-II: @root SHALL NOT be a RUID. Identifiers in this scheme are only defined by balloted HL7 specifications. Local communities or systems must never use such reserved identifiers based on bilateral negotiations. (not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <xsl:variable name="root" select="@root"/>
      <xsl:variable name="extension" select="@extension"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-II: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL be distinct (not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="UUIDpattern"
                    select="'^[0-9a-fA-F]{8}-[0-9a-fA-f]{4}-[0-9a-fA-F]{4}-[0-9a-aA-F]{4}-[0-9a-fA-F]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]'))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-II: When UUID is used, the hexadecimal digits A-F SHALL be in upper case (not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-03c8a5a3-15f4-4bd6-be0f-fb5f2fca1022-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:name"
                 priority="1268"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-EN: entity name shall be null or text only or element only (no mixed content) (@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="*[not(@nullFlavor)][normalize-space(.)='']">
         <xsl:message>dtr1-3-EN: empty name particles should not be present. (*[not(@nullFlavor)][normalize-space(.)=''] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="substring(normalize-space(.),1,1)='&#34;'">
         <xsl:message>dtr1-4-EN: Use of quotes at the beginning of a name are probably not correct. (substring(normalize-space(.),1,1)='"' / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="value" select="string-join(.//text(),'')"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-EN: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[string-join(.//text(),'')=$value])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-EN: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (<xsl:text/>
               <xsl:value-of select="$value"/>
               <xsl:text/>) SHALL be distinct (not($set_other[string-join(.//text(),'')=$value]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:*) or hl7:*[count(tokenize(@qualifier,'\s'))=count(distinct-values(tokenize(@qualifier,'\s')))]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-EN: enxp elements SHALL have distinct values in @qualifier (not(hl7:*) or hl7:*[count(tokenize(@qualifier,'\s'))=count(distinct-values(tokenize(@qualifier,'\s')))] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family)=0 and count(hl7:given)=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ON: no parts may be person name type particles (count(hl7:family)=0 and count(hl7:given)=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(*)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-ON: organization names SHALL be element content (not(*) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-41ec4d78-a181-4189-a3f1-3dd2681f965a-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:addr"
                 priority="1267"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (count(*)&gt;0 and not(text()[string-length(normalize-space())&gt;0])) or (count(*)=0 and text()[string-length(normalize-space())&gt;0])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-AD: address shall be null or text only or element only (no mixed content) (@nullFlavor or (count(*)&gt;0 and not(text()[string-length(normalize-space())&gt;0])) or (count(*)=0 and text()[string-length(normalize-space())&gt;0]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:useablePeriod/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-AD: no useablePeriod if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:useablePeriod/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(*[self::hl7:useablePeriod][@updateMode])=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-AD: updateMode shall not be used on address elements (count(*[self::hl7:useablePeriod][@updateMode])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or          string-length(hl7:useablePeriod/hl7:low/@value) = string-length(hl7:useablePeriod/hl7:high/@value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-AD: useablePeriod/low/@value must have the same precision as useablePeriod/high/@value (not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or string-length(hl7:useablePeriod/hl7:low/@value) = string-length(hl7:useablePeriod/hl7:high/@value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or         number(substring(concat(hl7:useablePeriod/hl7:low/@value,'00000000000000'),1,14)) &lt; number(substring(concat(hl7:useablePeriod/hl7:high/@value,'00000000000000'),1,14))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-AD: useablePeriod/low/@value must be before useablePeriod/high/@value (not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or number(substring(concat(hl7:useablePeriod/hl7:low/@value,'00000000000000'),1,14)) &lt; number(substring(concat(hl7:useablePeriod/hl7:high/@value,'00000000000000'),1,14)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="tum" select="'^(us|ms|s|min|h|d|wk|mo|a|)$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="matches(hl7:useablePeriod/hl7:width/@unit, $tum)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-AD: for useablePeriod/width only us (microseconds), ms (milliseconds), s (seconds), min (minute), h (hours), d (day), wk (week), mo (month) or a (year) are allowed (matches(hl7:useablePeriod/hl7:width/@unit, $tum) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="*[not(@nullFlavor or self::hl7:useablePeriod)][normalize-space(.)='']">
         <xsl:message>dtr1-8-AD: empty address particles should not be present. (*[not(@nullFlavor or self::hl7:useablePeriod)][normalize-space(.)=''] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="value" select="string-join(.//text(),'')"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-9-AD: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[string-join(.//text(),'')=$value])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-AD: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (<xsl:text/>
               <xsl:value-of select="$value"/>
               <xsl:text/>) SHALL be distinct (not($set_other[string-join(.//text(),'')=$value]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-1aac51f0-ece8-4b69-b769-6b228e72e0f7-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/hl7:telecom"
                 priority="1266"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or @value"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-URL: elements of type URL SHALL have a @value attribute. (@nullFlavor or @value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or @value=iri-to-uri(@value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-URL: @value must be a valid URI, e.g. '<xsl:text/>
               <xsl:value-of select="iri-to-uri(@value)"/>
               <xsl:text/>'. (@nullFlavor or @value=iri-to-uri(@value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="use" select="@use"/>
      <xsl:variable name="value" select="@value"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-URL: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@value=$value])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-URL: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (<xsl:text/>
               <xsl:value-of select="$value"/>
               <xsl:text/>) SHALL be distinct (not($set_other[@value=$value]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and hl7:usablePeriod)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-TEL: not null and usablePeriod (not(@nullFlavor and hl7:usablePeriod) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-97d870cc-d287-4371-a8f1-11499365504d-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/lab:code"
                 priority="1265"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CD: null or code and/or originalText (@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CD: code requires codeSystem (@codeSystem or not(@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CD: codeSystemName only if codeSystem (@codeSystem or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CD: codeSystemVersion only if codeSystem (@codeSystem or not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CD: displayName only if code (@code or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@code))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CD: no code if null (not(@nullFlavor) or (@nullFlavor and not(@code)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CD: no displayName if null (not(@nullFlavor) or (@nullFlavor and not(@displayName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-CD: no null on translations (Exceptional values (NULL-values) can not be elements of a set.) (not(.//hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystem][not(@code)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-11-CD: translation code requires codeSystem (not(.//hl7:translation[@codeSystem][not(@code)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystemName][not(@codeSystem)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-CD: translation codeSystemName only if codeSystem (not(.//hl7:translation[@codeSystemName][not(@codeSystem)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-CD: translation codeSystemVersion only if codeSystem (not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@displayName][not(@code)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-14-CD: translation displayName only if code (not(.//hl7:translation[@displayName][not(@code)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="matches(@displayName,'[\r\n\t]')">
         <xsl:message>dtr1-15-CD: it looks like there are formatting instructions in attribute @displayName. Please note that this may lead to
        interoperability problems. (matches(@displayName,'[\r\n\t]') / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-17-CD: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="code" select="@code"/>
      <xsl:variable name="codeSystem" select="@codeSystem"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@code=$code][@codeSystem=$codeSystem])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-18-CD: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (@code=<xsl:text/>
               <xsl:value-of select="$code"/>
               <xsl:text/> @codeSystem=<xsl:text/>
               <xsl:value-of select="$codeSystem"/>
               <xsl:text/>) SHALL be distinct (not($set_other[@code=$code][@codeSystem=$codeSystem]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="translations"
                    select=".//hl7:translation/concat(@code,@codeSystem)"/>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count($translations)=count(distinct-values($translations))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-19-CD: [RIM-002] translations SHALL be distinct (count($translations)=count(distinct-values($translations)) / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <xsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-20-CD: originalText/@language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CE: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theCode" select="@code"/>
      <xsl:variable name="theCodeSystem" select="@codeSystem"/>
      <xsl:variable name="theCodeSystemVersion" select="@codeSystemVersion"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): de elementwaarde MOET een zijn van 'vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH)'. (@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theNullFlavor" select="@nullFlavor"/>
      <xsl:variable name="validNullFlavorsFound"
                    select="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or $validNullFlavorsFound"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): de nulwaarde '<xsl:text/>
               <xsl:value-of select="@nullFlavor"/>
               <xsl:text/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH). (not(@nullFlavor) or $validNullFlavorsFound / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-16dce08a-6bf2-4e48-a8ee-b9ee4db4de7b-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient"
                 priority="1264"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@typeCode"/>
         <xsl:otherwise>
            <xsl:message>(CDAinformationRecipient): attribute @typeCode MOET aanwezig zijn. (@typeCode / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@typeCode),' '))"/>
      <xsl:variable name="theAttCheck"
                    select="distinct-values(for $code in tokenize(@typeCode,' ') return if ($code=('PRCP','TRC')) then ($code) else ())"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@typeCode) or count($theAttValue) = count($theAttCheck)"/>
         <xsl:otherwise>
            <xsl:message>(CDAinformationRecipient): de waarde van typeCode MOET 'code PRCP of code TRC' zijn. (not(@typeCode) or count($theAttValue) = count($theAttCheck) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:intendedRecipient)&gt;=1 and not(hl7:intendedRecipient/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(CDAinformationRecipient): element hl7:intendedRecipient is mandatory [min 1x]. (count(hl7:intendedRecipient)&gt;=1 and not(hl7:intendedRecipient/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:intendedRecipient)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAinformationRecipient): element hl7:intendedRecipient komt te vaak voor [max 1x]. (count(hl7:intendedRecipient)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-b0591ae4-fa53-4f05-9a73-c602723b7edc-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient"
                 priority="1263"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode)=('ASSIGNED')"/>
         <xsl:otherwise>
            <xsl:message>(CDAinformationRecipient): de waarde van @classCode MOET 'ASSIGNED' zijn. (string(@classCode)=('ASSIGNED') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:informationRecipient)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAinformationRecipient): element hl7:informationRecipient komt te vaak voor [max 1x]. (count(hl7:informationRecipient)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedOrganization)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAinformationRecipient): element hl7:representedOrganization komt te vaak voor [max 1x]. (count(hl7:representedOrganization)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-f4c3be1c-5b15-4323-9ceb-6227aea456fa-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:id"
                 priority="1262"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDAinformationRecipient): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="OIDpattern" select="'^[0-2](\.(0|[1-9]\d*))*$'"/>
      <xsl:variable name="RUIDpattern" select="'^[A-Za-z][A-Za-z\d\-]*$'"/>
      <xsl:variable name="UUIDpattern"
                    select="'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-II: @root SHALL be a syntactically correct OID, UUID. (not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern)))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10a-II: @root SHALL NOT be a RUID. Identifiers in this scheme are only defined by balloted HL7 specifications. Local communities or systems must never use such reserved identifiers based on bilateral negotiations. (not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <xsl:variable name="root" select="@root"/>
      <xsl:variable name="extension" select="@extension"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-II: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL be distinct (not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="UUIDpattern"
                    select="'^[0-9a-fA-F]{8}-[0-9a-fA-f]{4}-[0-9a-fA-F]{4}-[0-9a-aA-F]{4}-[0-9a-fA-F]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]'))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-II: When UUID is used, the hexadecimal digits A-F SHALL be in upper case (not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-cf295dcc-3f54-4eef-9375-648de16767bc-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:informationRecipient"
                 priority="1261"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode)=('PSN')"/>
         <xsl:otherwise>
            <xsl:message>(CDAinformationRecipient): de waarde van @classCode MOET 'PSN' zijn. (string(@classCode)=('PSN') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode)=('INSTANCE')"/>
         <xsl:otherwise>
            <xsl:message>(CDAinformationRecipient): de waarde van @determinerCode MOET 'INSTANCE' zijn. (string(@determinerCode)=('INSTANCE') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAinformationRecipient): element hl7:name komt te vaak voor [max 1x]. (count(hl7:name)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-76c0ac8c-2064-4066-a590-66a7e73eae2e-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:informationRecipient/hl7:name"
                 priority="1260"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDAinformationRecipient): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-EN: entity name shall be null or text only or element only (no mixed content) (@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="*[not(@nullFlavor)][normalize-space(.)='']">
         <xsl:message>dtr1-3-EN: empty name particles should not be present. (*[not(@nullFlavor)][normalize-space(.)=''] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="substring(normalize-space(.),1,1)='&#34;'">
         <xsl:message>dtr1-4-EN: Use of quotes at the beginning of a name are probably not correct. (substring(normalize-space(.),1,1)='"' / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="value" select="string-join(.//text(),'')"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-EN: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[string-join(.//text(),'')=$value])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-EN: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (<xsl:text/>
               <xsl:value-of select="$value"/>
               <xsl:text/>) SHALL be distinct (not($set_other[string-join(.//text(),'')=$value]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:*) or hl7:*[count(tokenize(@qualifier,'\s'))=count(distinct-values(tokenize(@qualifier,'\s')))]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-EN: enxp elements SHALL have distinct values in @qualifier (not(hl7:*) or hl7:*[count(tokenize(@qualifier,'\s'))=count(distinct-values(tokenize(@qualifier,'\s')))] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(*[tokenize(@qualifier,'\s')='LS'])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-PN: Person names SHALL NOT contain a name part qualified with 'LS' (Legal status for organizations) (not(*[tokenize(@qualifier,'\s')='LS']) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-ba92ce84-4368-4d40-b9c0-9c1a6e9e0911-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization"
                 priority="1259"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode)=('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDAinformationRecipient): de waarde van @classCode MOET 'ORG' zijn. (string(@classCode)=('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode)=('INSTANCE')"/>
         <xsl:otherwise>
            <xsl:message>(CDAinformationRecipient): de waarde van @determinerCode MOET 'INSTANCE' zijn. (string(@determinerCode)=('INSTANCE') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="elmcount"
                    select="count(hl7:id[@root='2.16.528.1.1007.3.3']|hl7:id)"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="$elmcount&gt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAinformationRecipient): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id) bevat te weinig elementen [min 1x] ($elmcount&gt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[@root='2.16.528.1.1007.3.3'])&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAinformationRecipient): element hl7:id[@root='2.16.528.1.1007.3.3'] komt te vaak voor [max 1x]. (count(hl7:id[@root='2.16.528.1.1007.3.3'])&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(CDAinformationRecipient): element hl7:name is mandatory [min 1x]. (count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAinformationRecipient): element hl7:name komt te vaak voor [max 1x]. (count(hl7:name)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAinformationRecipient): element hl7:addr komt te vaak voor [max 1x]. (count(hl7:addr)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(lab:code)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAinformationRecipient): element lab:code komt te vaak voor [max 1x]. (count(lab:code)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-ffb02a54-aa49-4936-9115-26811b3c42e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:id[@root='2.16.528.1.1007.3.3']"
                 priority="1258"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="OIDpattern" select="'^[0-2](\.(0|[1-9]\d*))*$'"/>
      <xsl:variable name="RUIDpattern" select="'^[A-Za-z][A-Za-z\d\-]*$'"/>
      <xsl:variable name="UUIDpattern"
                    select="'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-II: @root SHALL be a syntactically correct OID, UUID. (not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern)))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10a-II: @root SHALL NOT be a RUID. Identifiers in this scheme are only defined by balloted HL7 specifications. Local communities or systems must never use such reserved identifiers based on bilateral negotiations. (not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <xsl:variable name="root" select="@root"/>
      <xsl:variable name="extension" select="@extension"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-II: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL be distinct (not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="UUIDpattern"
                    select="'^[0-9a-fA-F]{8}-[0-9a-fA-f]{4}-[0-9a-fA-F]{4}-[0-9a-aA-F]{4}-[0-9a-fA-F]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]'))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-II: When UUID is used, the hexadecimal digits A-F SHALL be in upper case (not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root)=('2.16.528.1.1007.3.3')"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): de waarde van @root MOET '2.16.528.1.1007.3.3' zijn. (string(@root)=('2.16.528.1.1007.3.3') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-a3d1d361-9ce5-4e93-b447-b570e340e7e8-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:id"
                 priority="1257"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="OIDpattern" select="'^[0-2](\.(0|[1-9]\d*))*$'"/>
      <xsl:variable name="RUIDpattern" select="'^[A-Za-z][A-Za-z\d\-]*$'"/>
      <xsl:variable name="UUIDpattern"
                    select="'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-II: @root SHALL be a syntactically correct OID, UUID. (not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern)))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10a-II: @root SHALL NOT be a RUID. Identifiers in this scheme are only defined by balloted HL7 specifications. Local communities or systems must never use such reserved identifiers based on bilateral negotiations. (not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <xsl:variable name="root" select="@root"/>
      <xsl:variable name="extension" select="@extension"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-II: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL be distinct (not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="UUIDpattern"
                    select="'^[0-9a-fA-F]{8}-[0-9a-fA-f]{4}-[0-9a-fA-F]{4}-[0-9a-aA-F]{4}-[0-9a-fA-F]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]'))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-II: When UUID is used, the hexadecimal digits A-F SHALL be in upper case (not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-8b7dddbb-f3b3-44e3-be26-c659ccc641ca-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:name"
                 priority="1256"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-EN: entity name shall be null or text only or element only (no mixed content) (@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="*[not(@nullFlavor)][normalize-space(.)='']">
         <xsl:message>dtr1-3-EN: empty name particles should not be present. (*[not(@nullFlavor)][normalize-space(.)=''] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="substring(normalize-space(.),1,1)='&#34;'">
         <xsl:message>dtr1-4-EN: Use of quotes at the beginning of a name are probably not correct. (substring(normalize-space(.),1,1)='"' / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="value" select="string-join(.//text(),'')"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-EN: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[string-join(.//text(),'')=$value])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-EN: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (<xsl:text/>
               <xsl:value-of select="$value"/>
               <xsl:text/>) SHALL be distinct (not($set_other[string-join(.//text(),'')=$value]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:*) or hl7:*[count(tokenize(@qualifier,'\s'))=count(distinct-values(tokenize(@qualifier,'\s')))]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-EN: enxp elements SHALL have distinct values in @qualifier (not(hl7:*) or hl7:*[count(tokenize(@qualifier,'\s'))=count(distinct-values(tokenize(@qualifier,'\s')))] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family)=0 and count(hl7:given)=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ON: no parts may be person name type particles (count(hl7:family)=0 and count(hl7:given)=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(*)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-ON: organization names SHALL be element content (not(*) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-0fd4a46b-89dd-4122-a716-c9965af41f97-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:addr"
                 priority="1255"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (count(*)&gt;0 and not(text()[string-length(normalize-space())&gt;0])) or (count(*)=0 and text()[string-length(normalize-space())&gt;0])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-AD: address shall be null or text only or element only (no mixed content) (@nullFlavor or (count(*)&gt;0 and not(text()[string-length(normalize-space())&gt;0])) or (count(*)=0 and text()[string-length(normalize-space())&gt;0]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:useablePeriod/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-AD: no useablePeriod if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:useablePeriod/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(*[self::hl7:useablePeriod][@updateMode])=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-AD: updateMode shall not be used on address elements (count(*[self::hl7:useablePeriod][@updateMode])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or          string-length(hl7:useablePeriod/hl7:low/@value) = string-length(hl7:useablePeriod/hl7:high/@value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-AD: useablePeriod/low/@value must have the same precision as useablePeriod/high/@value (not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or string-length(hl7:useablePeriod/hl7:low/@value) = string-length(hl7:useablePeriod/hl7:high/@value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or         number(substring(concat(hl7:useablePeriod/hl7:low/@value,'00000000000000'),1,14)) &lt; number(substring(concat(hl7:useablePeriod/hl7:high/@value,'00000000000000'),1,14))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-AD: useablePeriod/low/@value must be before useablePeriod/high/@value (not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or number(substring(concat(hl7:useablePeriod/hl7:low/@value,'00000000000000'),1,14)) &lt; number(substring(concat(hl7:useablePeriod/hl7:high/@value,'00000000000000'),1,14)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="tum" select="'^(us|ms|s|min|h|d|wk|mo|a|)$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="matches(hl7:useablePeriod/hl7:width/@unit, $tum)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-AD: for useablePeriod/width only us (microseconds), ms (milliseconds), s (seconds), min (minute), h (hours), d (day), wk (week), mo (month) or a (year) are allowed (matches(hl7:useablePeriod/hl7:width/@unit, $tum) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="*[not(@nullFlavor or self::hl7:useablePeriod)][normalize-space(.)='']">
         <xsl:message>dtr1-8-AD: empty address particles should not be present. (*[not(@nullFlavor or self::hl7:useablePeriod)][normalize-space(.)=''] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="value" select="string-join(.//text(),'')"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-9-AD: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[string-join(.//text(),'')=$value])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-AD: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (<xsl:text/>
               <xsl:value-of select="$value"/>
               <xsl:text/>) SHALL be distinct (not($set_other[string-join(.//text(),'')=$value]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-8114063e-d199-4f00-a17b-74215474f76a-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/hl7:telecom"
                 priority="1254"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or @value"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-URL: elements of type URL SHALL have a @value attribute. (@nullFlavor or @value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or @value=iri-to-uri(@value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-URL: @value must be a valid URI, e.g. '<xsl:text/>
               <xsl:value-of select="iri-to-uri(@value)"/>
               <xsl:text/>'. (@nullFlavor or @value=iri-to-uri(@value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="use" select="@use"/>
      <xsl:variable name="value" select="@value"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-URL: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@value=$value])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-URL: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (<xsl:text/>
               <xsl:value-of select="$value"/>
               <xsl:text/>) SHALL be distinct (not($set_other[@value=$value]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and hl7:usablePeriod)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-TEL: not null and usablePeriod (not(@nullFlavor and hl7:usablePeriod) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-a4b2c1b0-ae3a-4355-808d-eae3316396ee-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/lab:code"
                 priority="1253"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CD: null or code and/or originalText (@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CD: code requires codeSystem (@codeSystem or not(@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CD: codeSystemName only if codeSystem (@codeSystem or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CD: codeSystemVersion only if codeSystem (@codeSystem or not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CD: displayName only if code (@code or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@code))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CD: no code if null (not(@nullFlavor) or (@nullFlavor and not(@code)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CD: no displayName if null (not(@nullFlavor) or (@nullFlavor and not(@displayName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-CD: no null on translations (Exceptional values (NULL-values) can not be elements of a set.) (not(.//hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystem][not(@code)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-11-CD: translation code requires codeSystem (not(.//hl7:translation[@codeSystem][not(@code)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystemName][not(@codeSystem)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-CD: translation codeSystemName only if codeSystem (not(.//hl7:translation[@codeSystemName][not(@codeSystem)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-CD: translation codeSystemVersion only if codeSystem (not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@displayName][not(@code)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-14-CD: translation displayName only if code (not(.//hl7:translation[@displayName][not(@code)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="matches(@displayName,'[\r\n\t]')">
         <xsl:message>dtr1-15-CD: it looks like there are formatting instructions in attribute @displayName. Please note that this may lead to
        interoperability problems. (matches(@displayName,'[\r\n\t]') / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-17-CD: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="code" select="@code"/>
      <xsl:variable name="codeSystem" select="@codeSystem"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@code=$code][@codeSystem=$codeSystem])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-18-CD: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (@code=<xsl:text/>
               <xsl:value-of select="$code"/>
               <xsl:text/> @codeSystem=<xsl:text/>
               <xsl:value-of select="$codeSystem"/>
               <xsl:text/>) SHALL be distinct (not($set_other[@code=$code][@codeSystem=$codeSystem]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="translations"
                    select=".//hl7:translation/concat(@code,@codeSystem)"/>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count($translations)=count(distinct-values($translations))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-19-CD: [RIM-002] translations SHALL be distinct (count($translations)=count(distinct-values($translations)) / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <xsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-20-CD: originalText/@language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CE: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theCode" select="@code"/>
      <xsl:variable name="theCodeSystem" select="@codeSystem"/>
      <xsl:variable name="theCodeSystemVersion" select="@codeSystemVersion"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): de elementwaarde MOET een zijn van 'vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH)'. (@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theNullFlavor" select="@nullFlavor"/>
      <xsl:variable name="validNullFlavorsFound"
                    select="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or $validNullFlavorsFound"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): de nulwaarde '<xsl:text/>
               <xsl:value-of select="@nullFlavor"/>
               <xsl:text/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH). (not(@nullFlavor) or $validNullFlavorsFound / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-11b94e68-d2c4-4d6b-92ea-1c4058b0ce02-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:authenticator"
                 priority="1252"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode)=('AUTHEN')"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthenticator): de waarde van @typeCode MOET 'AUTHEN' zijn. (string(@typeCode)=('AUTHEN') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900812-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-0afed1cf-caa4-421e-836c-8856e10bd3ff-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator"
                 priority="1251"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode)=('LA')"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): de waarde van @typeCode MOET 'LA' zijn. (string(@typeCode)=('LA') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time)&gt;=1 "/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): element hl7:time is required [min 1x]. (count(hl7:time)&gt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): element hl7:time komt te vaak voor [max 1x]. (count(hl7:time)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:signatureCode[@code='S'])&gt;=1 and not(hl7:signatureCode[@code='S']/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): element hl7:signatureCode[@code='S'] is mandatory [min 1x]. (count(hl7:signatureCode[@code='S'])&gt;=1 and not(hl7:signatureCode[@code='S']/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:signatureCode[@code='S'])&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): element hl7:signatureCode[@code='S'] komt te vaak voor [max 1x]. (count(hl7:signatureCode[@code='S'])&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity)&gt;=1 and not(hl7:assignedEntity/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): element hl7:assignedEntity is mandatory [min 1x]. (count(hl7:assignedEntity)&gt;=1 and not(hl7:assignedEntity/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): element hl7:assignedEntity komt te vaak voor [max 1x]. (count(hl7:assignedEntity)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-27c7c663-b560-40a0-a9ad-c3f7807b5f20-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:time"
                 priority="1250"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-QTY: no uncertainty (not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-QTY: no history or updateMode (count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-QTY: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="value" select="@value"/>
      <xsl:variable name="unit" select="@unit"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@value=$value][@unit=$unit])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-QTY: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (@value=<xsl:text/>
               <xsl:value-of select="$value"/>
               <xsl:text/> @unit=<xsl:text/>
               <xsl:value-of select="$unit"/>
               <xsl:text/>) SHALL be distinct (not($set_other[@value=$value][@unit=$unit]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(@nullFlavor or @value or *) and not(@nullFlavor and @value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-TS: null or value or child element in case of extension ((@nullFlavor or @value or *) and not(@nullFlavor and @value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theTS" select="@value"/>
      <xsl:variable name="theBC" select="if (starts-with($theTS,'-')) then '-' else ()"/>
      <xsl:variable name="theTZ" select="replace($theTS,'-?[^+-]+([+-].*)?$','$1')"/>
      <xsl:variable name="theTZh"
                    select="if (string-length($theTZ)&gt;0) then substring($theTZ,1,3) else ()"/>
      <xsl:variable name="theTZm"
                    select="if (string-length($theTZ)&gt;3) then substring($theTZ,4) else ()"/>
      <xsl:variable name="theBaseTS" select="replace($theTS,'^-?([^+-]+)([+-].*)?','$1')"/>
      <xsl:variable name="theCentury"
                    select="if (substring($theBaseTS,1,2) castable as xs:integer) then substring($theBaseTS,1,2) else ()"/>
      <xsl:variable name="theYear"
                    select="if (substring($theBaseTS,3,2) castable as xs:integer) then substring($theBaseTS,3,2) else ()"/>
      <xsl:variable name="theMonth"
                    select="if (substring($theBaseTS,5,2) castable as xs:integer) then substring($theBaseTS,5,2) else ()"/>
      <xsl:variable name="theDay"
                    select="if (substring($theBaseTS,7,2) castable as xs:integer) then substring($theBaseTS,7,2) else ()"/>
      <xsl:variable name="theHour"
                    select="if (substring($theBaseTS,9,2) castable as xs:integer) then substring($theBaseTS,9,2) else ()"/>
      <xsl:variable name="theMinute"
                    select="if (substring($theBaseTS,11,2) castable as xs:integer) then substring($theBaseTS,11,2) else ()"/>
      <xsl:variable name="theSecond"
                    select="if (substring($theBaseTS,13,2) castable as xs:integer) then substring($theBaseTS,13,2) else ()"/>
      <xsl:variable name="theSubSecond"
                    select="if (substring($theBaseTS,16) castable as xs:integer) then substring($theBaseTS,15) else ()"/>
      <xsl:variable name="cCentury"
                    select="if (empty($theCentury)) then '00' else $theCentury"/>
      <xsl:variable name="cYear" select="if (empty($theYear)) then '00' else $theYear"/>
      <xsl:variable name="cMonth" select="if (empty($theMonth)) then '01' else $theMonth"/>
      <xsl:variable name="cDay" select="if (empty($theDay)) then '01' else $theDay"/>
      <xsl:variable name="cHour" select="if (empty($theHour)) then '00' else $theHour"/>
      <xsl:variable name="cMinute"
                    select="if (empty($theMinute)) then '00' else $theMinute"/>
      <xsl:variable name="cSecond"
                    select="if (empty($theSecond)) then '00' else $theSecond"/>
      <xsl:variable name="cTZ" select="string-join(($theTZh,$theTZm),':')"/>
      <xsl:variable name="theTSString"
                    select="string-join(($theBC,$theCentury,$theYear,$theMonth,$theDay,$theHour,$theMinute,$theSecond,$theSubSecond,$theTZ),'')"/>
      <xsl:variable name="theDateTime"
                    select="concat($theBC,$cCentury,$cYear,'-',$cMonth,'-',$cDay,'T',$cHour,':',$cMinute,':',$cSecond,$theSubSecond,$cTZ)"/>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="empty($theTS) or ($theTS=$theTSString and $theDateTime castable as xs:dateTime)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-TS: <xsl:text/>
               <xsl:value-of select="local-name()"/>
               <xsl:text/> "<xsl:text/>
               <xsl:value-of select="$theTS"/>
               <xsl:text/>" is not a valid timestamp. (empty($theTS) or ($theTS=$theTSString and $theDateTime castable as xs:dateTime) / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or matches(@value, '^[0-9]{8,8}')"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-TS.DATE.MIN: null or date precision of time stamp shall be at least YYYYMMDD. (@nullFlavor or matches(@value, '^[0-9]{8,8}') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-85840f1f-b859-4945-8ec3-aaefa08a1438-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:signatureCode[@code='S']"
                 priority="1249"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CS: @code/@typeCode and @nullFlavor are mutually exclusive ((@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CS: cannot have codeSystem (not(@codeSystem) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CS: cannot have codeSystemName (not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CS: cannot have codeSystemVersion (not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CS: cannot have displayName (not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CS: cannot have originalText (not(hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CS: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-CS: cannot have translation (not(hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (@code='S')"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): de elementwaarde MOET een zijn van 'code 'S''. (@nullFlavor or (@code='S') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-1bb323db-5207-4e1b-b51c-f8b64619740c-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity"
                 priority="1248"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode)=('ASSIGNED')"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): de waarde van @classCode MOET 'ASSIGNED' zijn. (string(@classCode)=('ASSIGNED') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="elmcount"
                    select="count(hl7:id[@root='2.16.528.1.1007.3.1']|hl7:id)"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="$elmcount&gt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): keuze (hl7:id[@root='2.16.528.1.1007.3.1'] of hl7:id) bevat te weinig elementen [min 1x] ($elmcount&gt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[@root='2.16.528.1.1007.3.1'])&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): element hl7:id[@root='2.16.528.1.1007.3.1'] komt te vaak voor [max 1x]. (count(hl7:id[@root='2.16.528.1.1007.3.1'])&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): element hl7:code komt te vaak voor [max 1x]. (count(hl7:code)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): element hl7:assignedPerson komt te vaak voor [max 1x]. (count(hl7:assignedPerson)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedOrganization)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): element hl7:representedOrganization komt te vaak voor [max 1x]. (count(hl7:representedOrganization)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-30400a52-2aa5-4996-a513-31d18de37513-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:id[@root='2.16.528.1.1007.3.1']"
                 priority="1247"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDAassignedEntityIdentification): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="OIDpattern" select="'^[0-2](\.(0|[1-9]\d*))*$'"/>
      <xsl:variable name="RUIDpattern" select="'^[A-Za-z][A-Za-z\d\-]*$'"/>
      <xsl:variable name="UUIDpattern"
                    select="'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-II: @root SHALL be a syntactically correct OID, UUID. (not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern)))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10a-II: @root SHALL NOT be a RUID. Identifiers in this scheme are only defined by balloted HL7 specifications. Local communities or systems must never use such reserved identifiers based on bilateral negotiations. (not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <xsl:variable name="root" select="@root"/>
      <xsl:variable name="extension" select="@extension"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-II: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL be distinct (not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="UUIDpattern"
                    select="'^[0-9a-fA-F]{8}-[0-9a-fA-f]{4}-[0-9a-fA-F]{4}-[0-9a-aA-F]{4}-[0-9a-fA-F]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]'))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-II: When UUID is used, the hexadecimal digits A-F SHALL be in upper case (not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root)=('2.16.528.1.1007.3.1')"/>
         <xsl:otherwise>
            <xsl:message>(CDAassignedEntityIdentification): de waarde van @root MOET '2.16.528.1.1007.3.1' zijn. (string(@root)=('2.16.528.1.1007.3.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-cc39bc3f-ae43-4bec-9b4e-5b1bc9cd9742-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:id"
                 priority="1246"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDAassignedEntityIdentification): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="OIDpattern" select="'^[0-2](\.(0|[1-9]\d*))*$'"/>
      <xsl:variable name="RUIDpattern" select="'^[A-Za-z][A-Za-z\d\-]*$'"/>
      <xsl:variable name="UUIDpattern"
                    select="'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-II: @root SHALL be a syntactically correct OID, UUID. (not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern)))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10a-II: @root SHALL NOT be a RUID. Identifiers in this scheme are only defined by balloted HL7 specifications. Local communities or systems must never use such reserved identifiers based on bilateral negotiations. (not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <xsl:variable name="root" select="@root"/>
      <xsl:variable name="extension" select="@extension"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-II: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL be distinct (not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="UUIDpattern"
                    select="'^[0-9a-fA-F]{8}-[0-9a-fA-f]{4}-[0-9a-fA-F]{4}-[0-9a-aA-F]{4}-[0-9a-fA-F]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]'))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-II: When UUID is used, the hexadecimal digits A-F SHALL be in upper case (not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-57a01263-3445-4059-b094-f475c6bb0eea-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:code"
                 priority="1245"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CD: null or code and/or originalText (@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CD: code requires codeSystem (@codeSystem or not(@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CD: codeSystemName only if codeSystem (@codeSystem or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CD: codeSystemVersion only if codeSystem (@codeSystem or not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CD: displayName only if code (@code or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@code))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CD: no code if null (not(@nullFlavor) or (@nullFlavor and not(@code)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CD: no displayName if null (not(@nullFlavor) or (@nullFlavor and not(@displayName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-CD: no null on translations (Exceptional values (NULL-values) can not be elements of a set.) (not(.//hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystem][not(@code)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-11-CD: translation code requires codeSystem (not(.//hl7:translation[@codeSystem][not(@code)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystemName][not(@codeSystem)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-CD: translation codeSystemName only if codeSystem (not(.//hl7:translation[@codeSystemName][not(@codeSystem)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-CD: translation codeSystemVersion only if codeSystem (not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@displayName][not(@code)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-14-CD: translation displayName only if code (not(.//hl7:translation[@displayName][not(@code)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="matches(@displayName,'[\r\n\t]')">
         <xsl:message>dtr1-15-CD: it looks like there are formatting instructions in attribute @displayName. Please note that this may lead to
        interoperability problems. (matches(@displayName,'[\r\n\t]') / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-17-CD: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="code" select="@code"/>
      <xsl:variable name="codeSystem" select="@codeSystem"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@code=$code][@codeSystem=$codeSystem])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-18-CD: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (@code=<xsl:text/>
               <xsl:value-of select="$code"/>
               <xsl:text/> @codeSystem=<xsl:text/>
               <xsl:value-of select="$codeSystem"/>
               <xsl:text/>) SHALL be distinct (not($set_other[@code=$code][@codeSystem=$codeSystem]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="translations"
                    select=".//hl7:translation/concat(@code,@codeSystem)"/>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count($translations)=count(distinct-values($translations))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-19-CD: [RIM-002] translations SHALL be distinct (count($translations)=count(distinct-values($translations)) / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <xsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-20-CD: originalText/@language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CE: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theCode" select="@code"/>
      <xsl:variable name="theCodeSystem" select="@codeSystem"/>
      <xsl:variable name="theCodeSystemVersion" select="@codeSystemVersion"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): de elementwaarde MOET een zijn van 'vs_typerol Medische rollen (DYNAMISCH)'. (@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theNullFlavor" select="@nullFlavor"/>
      <xsl:variable name="validNullFlavorsFound"
                    select="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or $validNullFlavorsFound"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): de nulwaarde '<xsl:text/>
               <xsl:value-of select="@nullFlavor"/>
               <xsl:text/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_typerol Medische rollen (DYNAMISCH). (not(@nullFlavor) or $validNullFlavorsFound / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-f2b3630d-6ce1-4dfc-9bc5-9ac787ce4e4b-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:assignedPerson"
                 priority="1244"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode)=('PSN')"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): de waarde van @classCode MOET 'PSN' zijn. (string(@classCode)=('PSN') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode)=('INSTANCE')"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): de waarde van @determinerCode MOET 'INSTANCE' zijn. (string(@determinerCode)=('INSTANCE') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): element hl7:name is mandatory [min 1x]. (count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): element hl7:name komt te vaak voor [max 1x]. (count(hl7:name)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-b8e05ff9-af89-4e3c-ba7b-7af0b260d068-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:assignedPerson/hl7:name"
                 priority="1243"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-EN: entity name shall be null or text only or element only (no mixed content) (@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="*[not(@nullFlavor)][normalize-space(.)='']">
         <xsl:message>dtr1-3-EN: empty name particles should not be present. (*[not(@nullFlavor)][normalize-space(.)=''] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="substring(normalize-space(.),1,1)='&#34;'">
         <xsl:message>dtr1-4-EN: Use of quotes at the beginning of a name are probably not correct. (substring(normalize-space(.),1,1)='"' / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="value" select="string-join(.//text(),'')"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-EN: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[string-join(.//text(),'')=$value])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-EN: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (<xsl:text/>
               <xsl:value-of select="$value"/>
               <xsl:text/>) SHALL be distinct (not($set_other[string-join(.//text(),'')=$value]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:*) or hl7:*[count(tokenize(@qualifier,'\s'))=count(distinct-values(tokenize(@qualifier,'\s')))]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-EN: enxp elements SHALL have distinct values in @qualifier (not(hl7:*) or hl7:*[count(tokenize(@qualifier,'\s'))=count(distinct-values(tokenize(@qualifier,'\s')))] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(*[tokenize(@qualifier,'\s')='LS'])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-PN: Person names SHALL NOT contain a name part qualified with 'LS' (Legal status for organizations) (not(*[tokenize(@qualifier,'\s')='LS']) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-a4c90e1c-8ead-4308-996e-5285cef6a705-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization"
                 priority="1242"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode)=('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): de waarde van @classCode MOET 'ORG' zijn. (string(@classCode)=('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode)=('INSTANCE')"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): de waarde van @determinerCode MOET 'INSTANCE' zijn. (string(@determinerCode)=('INSTANCE') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="elmcount"
                    select="count(hl7:id[@root='2.16.528.1.1007.3.3']|hl7:id)"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="$elmcount&gt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id) bevat te weinig elementen [min 1x] ($elmcount&gt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[@root='2.16.528.1.1007.3.3'])&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): element hl7:id[@root='2.16.528.1.1007.3.3'] komt te vaak voor [max 1x]. (count(hl7:id[@root='2.16.528.1.1007.3.3'])&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): element hl7:name is mandatory [min 1x]. (count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): element hl7:name komt te vaak voor [max 1x]. (count(hl7:name)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): element hl7:addr komt te vaak voor [max 1x]. (count(hl7:addr)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(lab:code)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): element lab:code komt te vaak voor [max 1x]. (count(lab:code)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-d3cde2b3-9621-4dbb-9acd-f60ae783b21b-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:id[@root='2.16.528.1.1007.3.3']"
                 priority="1241"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="OIDpattern" select="'^[0-2](\.(0|[1-9]\d*))*$'"/>
      <xsl:variable name="RUIDpattern" select="'^[A-Za-z][A-Za-z\d\-]*$'"/>
      <xsl:variable name="UUIDpattern"
                    select="'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-II: @root SHALL be a syntactically correct OID, UUID. (not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern)))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10a-II: @root SHALL NOT be a RUID. Identifiers in this scheme are only defined by balloted HL7 specifications. Local communities or systems must never use such reserved identifiers based on bilateral negotiations. (not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <xsl:variable name="root" select="@root"/>
      <xsl:variable name="extension" select="@extension"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-II: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL be distinct (not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="UUIDpattern"
                    select="'^[0-9a-fA-F]{8}-[0-9a-fA-f]{4}-[0-9a-fA-F]{4}-[0-9a-aA-F]{4}-[0-9a-fA-F]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]'))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-II: When UUID is used, the hexadecimal digits A-F SHALL be in upper case (not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root)=('2.16.528.1.1007.3.3')"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): de waarde van @root MOET '2.16.528.1.1007.3.3' zijn. (string(@root)=('2.16.528.1.1007.3.3') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-c785534d-e728-4c23-b01e-9cae421ccdfd-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:id"
                 priority="1240"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="OIDpattern" select="'^[0-2](\.(0|[1-9]\d*))*$'"/>
      <xsl:variable name="RUIDpattern" select="'^[A-Za-z][A-Za-z\d\-]*$'"/>
      <xsl:variable name="UUIDpattern"
                    select="'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-II: @root SHALL be a syntactically correct OID, UUID. (not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern)))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10a-II: @root SHALL NOT be a RUID. Identifiers in this scheme are only defined by balloted HL7 specifications. Local communities or systems must never use such reserved identifiers based on bilateral negotiations. (not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <xsl:variable name="root" select="@root"/>
      <xsl:variable name="extension" select="@extension"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-II: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL be distinct (not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="UUIDpattern"
                    select="'^[0-9a-fA-F]{8}-[0-9a-fA-f]{4}-[0-9a-fA-F]{4}-[0-9a-aA-F]{4}-[0-9a-fA-F]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]'))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-II: When UUID is used, the hexadecimal digits A-F SHALL be in upper case (not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-b0dbd65a-a87f-4362-ae59-87b989ee1393-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:name"
                 priority="1239"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-EN: entity name shall be null or text only or element only (no mixed content) (@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="*[not(@nullFlavor)][normalize-space(.)='']">
         <xsl:message>dtr1-3-EN: empty name particles should not be present. (*[not(@nullFlavor)][normalize-space(.)=''] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="substring(normalize-space(.),1,1)='&#34;'">
         <xsl:message>dtr1-4-EN: Use of quotes at the beginning of a name are probably not correct. (substring(normalize-space(.),1,1)='"' / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="value" select="string-join(.//text(),'')"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-EN: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[string-join(.//text(),'')=$value])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-EN: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (<xsl:text/>
               <xsl:value-of select="$value"/>
               <xsl:text/>) SHALL be distinct (not($set_other[string-join(.//text(),'')=$value]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:*) or hl7:*[count(tokenize(@qualifier,'\s'))=count(distinct-values(tokenize(@qualifier,'\s')))]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-EN: enxp elements SHALL have distinct values in @qualifier (not(hl7:*) or hl7:*[count(tokenize(@qualifier,'\s'))=count(distinct-values(tokenize(@qualifier,'\s')))] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family)=0 and count(hl7:given)=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ON: no parts may be person name type particles (count(hl7:family)=0 and count(hl7:given)=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(*)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-ON: organization names SHALL be element content (not(*) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-aa7936c9-9bd7-494b-92b1-e3bf1453165e-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:addr"
                 priority="1238"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (count(*)&gt;0 and not(text()[string-length(normalize-space())&gt;0])) or (count(*)=0 and text()[string-length(normalize-space())&gt;0])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-AD: address shall be null or text only or element only (no mixed content) (@nullFlavor or (count(*)&gt;0 and not(text()[string-length(normalize-space())&gt;0])) or (count(*)=0 and text()[string-length(normalize-space())&gt;0]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:useablePeriod/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-AD: no useablePeriod if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:useablePeriod/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(*[self::hl7:useablePeriod][@updateMode])=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-AD: updateMode shall not be used on address elements (count(*[self::hl7:useablePeriod][@updateMode])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or          string-length(hl7:useablePeriod/hl7:low/@value) = string-length(hl7:useablePeriod/hl7:high/@value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-AD: useablePeriod/low/@value must have the same precision as useablePeriod/high/@value (not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or string-length(hl7:useablePeriod/hl7:low/@value) = string-length(hl7:useablePeriod/hl7:high/@value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or         number(substring(concat(hl7:useablePeriod/hl7:low/@value,'00000000000000'),1,14)) &lt; number(substring(concat(hl7:useablePeriod/hl7:high/@value,'00000000000000'),1,14))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-AD: useablePeriod/low/@value must be before useablePeriod/high/@value (not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or number(substring(concat(hl7:useablePeriod/hl7:low/@value,'00000000000000'),1,14)) &lt; number(substring(concat(hl7:useablePeriod/hl7:high/@value,'00000000000000'),1,14)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="tum" select="'^(us|ms|s|min|h|d|wk|mo|a|)$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="matches(hl7:useablePeriod/hl7:width/@unit, $tum)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-AD: for useablePeriod/width only us (microseconds), ms (milliseconds), s (seconds), min (minute), h (hours), d (day), wk (week), mo (month) or a (year) are allowed (matches(hl7:useablePeriod/hl7:width/@unit, $tum) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="*[not(@nullFlavor or self::hl7:useablePeriod)][normalize-space(.)='']">
         <xsl:message>dtr1-8-AD: empty address particles should not be present. (*[not(@nullFlavor or self::hl7:useablePeriod)][normalize-space(.)=''] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="value" select="string-join(.//text(),'')"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-9-AD: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[string-join(.//text(),'')=$value])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-AD: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (<xsl:text/>
               <xsl:value-of select="$value"/>
               <xsl:text/>) SHALL be distinct (not($set_other[string-join(.//text(),'')=$value]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-cb4f95fe-b094-4e61-b38a-34d62e7fdefa-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/hl7:telecom"
                 priority="1237"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or @value"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-URL: elements of type URL SHALL have a @value attribute. (@nullFlavor or @value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or @value=iri-to-uri(@value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-URL: @value must be a valid URI, e.g. '<xsl:text/>
               <xsl:value-of select="iri-to-uri(@value)"/>
               <xsl:text/>'. (@nullFlavor or @value=iri-to-uri(@value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="use" select="@use"/>
      <xsl:variable name="value" select="@value"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-URL: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@value=$value])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-URL: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (<xsl:text/>
               <xsl:value-of select="$value"/>
               <xsl:text/>) SHALL be distinct (not($set_other[@value=$value]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and hl7:usablePeriod)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-TEL: not null and usablePeriod (not(@nullFlavor and hl7:usablePeriod) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-7c7f1ee5-bce9-42ef-b41e-d9543a0d54e8-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/lab:code"
                 priority="1236"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CD: null or code and/or originalText (@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CD: code requires codeSystem (@codeSystem or not(@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CD: codeSystemName only if codeSystem (@codeSystem or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CD: codeSystemVersion only if codeSystem (@codeSystem or not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CD: displayName only if code (@code or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@code))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CD: no code if null (not(@nullFlavor) or (@nullFlavor and not(@code)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CD: no displayName if null (not(@nullFlavor) or (@nullFlavor and not(@displayName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-CD: no null on translations (Exceptional values (NULL-values) can not be elements of a set.) (not(.//hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystem][not(@code)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-11-CD: translation code requires codeSystem (not(.//hl7:translation[@codeSystem][not(@code)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystemName][not(@codeSystem)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-CD: translation codeSystemName only if codeSystem (not(.//hl7:translation[@codeSystemName][not(@codeSystem)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-CD: translation codeSystemVersion only if codeSystem (not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@displayName][not(@code)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-14-CD: translation displayName only if code (not(.//hl7:translation[@displayName][not(@code)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="matches(@displayName,'[\r\n\t]')">
         <xsl:message>dtr1-15-CD: it looks like there are formatting instructions in attribute @displayName. Please note that this may lead to
        interoperability problems. (matches(@displayName,'[\r\n\t]') / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-17-CD: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="code" select="@code"/>
      <xsl:variable name="codeSystem" select="@codeSystem"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@code=$code][@codeSystem=$codeSystem])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-18-CD: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (@code=<xsl:text/>
               <xsl:value-of select="$code"/>
               <xsl:text/> @codeSystem=<xsl:text/>
               <xsl:value-of select="$codeSystem"/>
               <xsl:text/>) SHALL be distinct (not($set_other[@code=$code][@codeSystem=$codeSystem]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="translations"
                    select=".//hl7:translation/concat(@code,@codeSystem)"/>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count($translations)=count(distinct-values($translations))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-19-CD: [RIM-002] translations SHALL be distinct (count($translations)=count(distinct-values($translations)) / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <xsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-20-CD: originalText/@language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CE: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theCode" select="@code"/>
      <xsl:variable name="theCodeSystem" select="@codeSystem"/>
      <xsl:variable name="theCodeSystemVersion" select="@codeSystemVersion"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): de elementwaarde MOET een zijn van 'vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH)'. (@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theNullFlavor" select="@nullFlavor"/>
      <xsl:variable name="validNullFlavorsFound"
                    select="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or $validNullFlavorsFound"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): de nulwaarde '<xsl:text/>
               <xsl:value-of select="@nullFlavor"/>
               <xsl:text/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH). (not(@nullFlavor) or $validNullFlavorsFound / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-3918a2b6-f5d5-425c-b415-9b2d4b5974b8-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant"
                 priority="1235"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode)=('VRF')"/>
         <xsl:otherwise>
            <xsl:message>(CDAParticipantVerifier): de waarde van @typeCode MOET 'VRF' zijn. (string(@typeCode)=('VRF') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAParticipantVerifier): element hl7:time komt te vaak voor [max 1x]. (count(hl7:time)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:associatedEntity)&gt;=1 and not(hl7:associatedEntity/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(CDAParticipantVerifier): element hl7:associatedEntity is mandatory [min 1x]. (count(hl7:associatedEntity)&gt;=1 and not(hl7:associatedEntity/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:associatedEntity)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAParticipantVerifier): element hl7:associatedEntity komt te vaak voor [max 1x]. (count(hl7:associatedEntity)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-cb09b505-84a7-43e9-95f2-00549fa345ad-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:time"
                 priority="1234"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDAParticipantVerifier): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-QTY: no uncertainty (not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-QTY: no history or updateMode (count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-QTY: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="value" select="@value"/>
      <xsl:variable name="unit" select="@unit"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@value=$value][@unit=$unit])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-QTY: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (@value=<xsl:text/>
               <xsl:value-of select="$value"/>
               <xsl:text/> @unit=<xsl:text/>
               <xsl:value-of select="$unit"/>
               <xsl:text/>) SHALL be distinct (not($set_other[@value=$value][@unit=$unit]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(@nullFlavor or @value or *) and not(@nullFlavor and @value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-TS: null or value or child element in case of extension ((@nullFlavor or @value or *) and not(@nullFlavor and @value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theTS" select="@value"/>
      <xsl:variable name="theBC" select="if (starts-with($theTS,'-')) then '-' else ()"/>
      <xsl:variable name="theTZ" select="replace($theTS,'-?[^+-]+([+-].*)?$','$1')"/>
      <xsl:variable name="theTZh"
                    select="if (string-length($theTZ)&gt;0) then substring($theTZ,1,3) else ()"/>
      <xsl:variable name="theTZm"
                    select="if (string-length($theTZ)&gt;3) then substring($theTZ,4) else ()"/>
      <xsl:variable name="theBaseTS" select="replace($theTS,'^-?([^+-]+)([+-].*)?','$1')"/>
      <xsl:variable name="theCentury"
                    select="if (substring($theBaseTS,1,2) castable as xs:integer) then substring($theBaseTS,1,2) else ()"/>
      <xsl:variable name="theYear"
                    select="if (substring($theBaseTS,3,2) castable as xs:integer) then substring($theBaseTS,3,2) else ()"/>
      <xsl:variable name="theMonth"
                    select="if (substring($theBaseTS,5,2) castable as xs:integer) then substring($theBaseTS,5,2) else ()"/>
      <xsl:variable name="theDay"
                    select="if (substring($theBaseTS,7,2) castable as xs:integer) then substring($theBaseTS,7,2) else ()"/>
      <xsl:variable name="theHour"
                    select="if (substring($theBaseTS,9,2) castable as xs:integer) then substring($theBaseTS,9,2) else ()"/>
      <xsl:variable name="theMinute"
                    select="if (substring($theBaseTS,11,2) castable as xs:integer) then substring($theBaseTS,11,2) else ()"/>
      <xsl:variable name="theSecond"
                    select="if (substring($theBaseTS,13,2) castable as xs:integer) then substring($theBaseTS,13,2) else ()"/>
      <xsl:variable name="theSubSecond"
                    select="if (substring($theBaseTS,16) castable as xs:integer) then substring($theBaseTS,15) else ()"/>
      <xsl:variable name="cCentury"
                    select="if (empty($theCentury)) then '00' else $theCentury"/>
      <xsl:variable name="cYear" select="if (empty($theYear)) then '00' else $theYear"/>
      <xsl:variable name="cMonth" select="if (empty($theMonth)) then '01' else $theMonth"/>
      <xsl:variable name="cDay" select="if (empty($theDay)) then '01' else $theDay"/>
      <xsl:variable name="cHour" select="if (empty($theHour)) then '00' else $theHour"/>
      <xsl:variable name="cMinute"
                    select="if (empty($theMinute)) then '00' else $theMinute"/>
      <xsl:variable name="cSecond"
                    select="if (empty($theSecond)) then '00' else $theSecond"/>
      <xsl:variable name="cTZ" select="string-join(($theTZh,$theTZm),':')"/>
      <xsl:variable name="theTSString"
                    select="string-join(($theBC,$theCentury,$theYear,$theMonth,$theDay,$theHour,$theMinute,$theSecond,$theSubSecond,$theTZ),'')"/>
      <xsl:variable name="theDateTime"
                    select="concat($theBC,$cCentury,$cYear,'-',$cMonth,'-',$cDay,'T',$cHour,':',$cMinute,':',$cSecond,$theSubSecond,$cTZ)"/>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="empty($theTS) or ($theTS=$theTSString and $theDateTime castable as xs:dateTime)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-TS: <xsl:text/>
               <xsl:value-of select="local-name()"/>
               <xsl:text/> "<xsl:text/>
               <xsl:value-of select="$theTS"/>
               <xsl:text/>" is not a valid timestamp. (empty($theTS) or ($theTS=$theTSString and $theDateTime castable as xs:dateTime) / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or matches(@value, '^[0-9]{8,8}')"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-TS.DATE.MIN: null or date precision of time stamp shall be at least YYYYMMDD. (@nullFlavor or matches(@value, '^[0-9]{8,8}') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-eaf66e15-b305-4516-8c55-1c3920794b97-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity"
                 priority="1233"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode)=('ASSIGNED')"/>
         <xsl:otherwise>
            <xsl:message>(CDAParticipantVerifier): de waarde van @classCode MOET 'ASSIGNED' zijn. (string(@classCode)=('ASSIGNED') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="elmcount"
                    select="count(hl7:id[@root='2.16.528.1.1007.3.1']|hl7:id)"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="$elmcount&gt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAParticipantVerifier): keuze (hl7:id[@root='2.16.528.1.1007.3.1'] of hl7:id) bevat te weinig elementen [min 1x] ($elmcount&gt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[@root='2.16.528.1.1007.3.1'])&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAParticipantVerifier): element hl7:id[@root='2.16.528.1.1007.3.1'] komt te vaak voor [max 1x]. (count(hl7:id[@root='2.16.528.1.1007.3.1'])&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAParticipantVerifier): element hl7:code komt te vaak voor [max 1x]. (count(hl7:code)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:associatedPerson)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAParticipantVerifier): element hl7:associatedPerson komt te vaak voor [max 1x]. (count(hl7:associatedPerson)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:scopingOrganization)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAParticipantVerifier): element hl7:scopingOrganization komt te vaak voor [max 1x]. (count(hl7:scopingOrganization)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-1dde0a17-1315-4e40-99ee-bf6ec8bccd3d-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:id[@root='2.16.528.1.1007.3.1']"
                 priority="1232"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDAassignedEntityIdentification): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="OIDpattern" select="'^[0-2](\.(0|[1-9]\d*))*$'"/>
      <xsl:variable name="RUIDpattern" select="'^[A-Za-z][A-Za-z\d\-]*$'"/>
      <xsl:variable name="UUIDpattern"
                    select="'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-II: @root SHALL be a syntactically correct OID, UUID. (not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern)))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10a-II: @root SHALL NOT be a RUID. Identifiers in this scheme are only defined by balloted HL7 specifications. Local communities or systems must never use such reserved identifiers based on bilateral negotiations. (not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <xsl:variable name="root" select="@root"/>
      <xsl:variable name="extension" select="@extension"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-II: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL be distinct (not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="UUIDpattern"
                    select="'^[0-9a-fA-F]{8}-[0-9a-fA-f]{4}-[0-9a-fA-F]{4}-[0-9a-aA-F]{4}-[0-9a-fA-F]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]'))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-II: When UUID is used, the hexadecimal digits A-F SHALL be in upper case (not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root)=('2.16.528.1.1007.3.1')"/>
         <xsl:otherwise>
            <xsl:message>(CDAassignedEntityIdentification): de waarde van @root MOET '2.16.528.1.1007.3.1' zijn. (string(@root)=('2.16.528.1.1007.3.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-6baef42b-5cb0-47f7-aba3-ee8f4fde73f5-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:id"
                 priority="1231"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDAassignedEntityIdentification): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="OIDpattern" select="'^[0-2](\.(0|[1-9]\d*))*$'"/>
      <xsl:variable name="RUIDpattern" select="'^[A-Za-z][A-Za-z\d\-]*$'"/>
      <xsl:variable name="UUIDpattern"
                    select="'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-II: @root SHALL be a syntactically correct OID, UUID. (not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern)))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10a-II: @root SHALL NOT be a RUID. Identifiers in this scheme are only defined by balloted HL7 specifications. Local communities or systems must never use such reserved identifiers based on bilateral negotiations. (not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <xsl:variable name="root" select="@root"/>
      <xsl:variable name="extension" select="@extension"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-II: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL be distinct (not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="UUIDpattern"
                    select="'^[0-9a-fA-F]{8}-[0-9a-fA-f]{4}-[0-9a-fA-F]{4}-[0-9a-aA-F]{4}-[0-9a-fA-F]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]'))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-II: When UUID is used, the hexadecimal digits A-F SHALL be in upper case (not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-b115b881-3bf3-4f19-8680-9cdb2019da20-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:code"
                 priority="1230"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDAParticipantVerifier): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CD: null or code and/or originalText (@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CD: code requires codeSystem (@codeSystem or not(@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CD: codeSystemName only if codeSystem (@codeSystem or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CD: codeSystemVersion only if codeSystem (@codeSystem or not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CD: displayName only if code (@code or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@code))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CD: no code if null (not(@nullFlavor) or (@nullFlavor and not(@code)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CD: no displayName if null (not(@nullFlavor) or (@nullFlavor and not(@displayName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-CD: no null on translations (Exceptional values (NULL-values) can not be elements of a set.) (not(.//hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystem][not(@code)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-11-CD: translation code requires codeSystem (not(.//hl7:translation[@codeSystem][not(@code)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystemName][not(@codeSystem)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-CD: translation codeSystemName only if codeSystem (not(.//hl7:translation[@codeSystemName][not(@codeSystem)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-CD: translation codeSystemVersion only if codeSystem (not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@displayName][not(@code)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-14-CD: translation displayName only if code (not(.//hl7:translation[@displayName][not(@code)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="matches(@displayName,'[\r\n\t]')">
         <xsl:message>dtr1-15-CD: it looks like there are formatting instructions in attribute @displayName. Please note that this may lead to
        interoperability problems. (matches(@displayName,'[\r\n\t]') / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-17-CD: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="code" select="@code"/>
      <xsl:variable name="codeSystem" select="@codeSystem"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@code=$code][@codeSystem=$codeSystem])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-18-CD: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (@code=<xsl:text/>
               <xsl:value-of select="$code"/>
               <xsl:text/> @codeSystem=<xsl:text/>
               <xsl:value-of select="$codeSystem"/>
               <xsl:text/>) SHALL be distinct (not($set_other[@code=$code][@codeSystem=$codeSystem]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="translations"
                    select=".//hl7:translation/concat(@code,@codeSystem)"/>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count($translations)=count(distinct-values($translations))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-19-CD: [RIM-002] translations SHALL be distinct (count($translations)=count(distinct-values($translations)) / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <xsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-20-CD: originalText/@language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CE: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theCode" select="@code"/>
      <xsl:variable name="theCodeSystem" select="@codeSystem"/>
      <xsl:variable name="theCodeSystemVersion" select="@codeSystemVersion"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])"/>
         <xsl:otherwise>
            <xsl:message>(CDAParticipantVerifier): de elementwaarde MOET een zijn van 'vs_typerol Medische rollen (DYNAMISCH)'. (@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theNullFlavor" select="@nullFlavor"/>
      <xsl:variable name="validNullFlavorsFound"
                    select="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or $validNullFlavorsFound"/>
         <xsl:otherwise>
            <xsl:message>(CDAParticipantVerifier): de nulwaarde '<xsl:text/>
               <xsl:value-of select="@nullFlavor"/>
               <xsl:text/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_typerol Medische rollen (DYNAMISCH). (not(@nullFlavor) or $validNullFlavorsFound / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-57b4317e-0892-46c2-9585-aba32a6f8004-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:associatedPerson"
                 priority="1229"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode)=('PSN')"/>
         <xsl:otherwise>
            <xsl:message>(CDAParticipantVerifier): de waarde van @classCode MOET 'PSN' zijn. (string(@classCode)=('PSN') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode)=('INSTANCE')"/>
         <xsl:otherwise>
            <xsl:message>(CDAParticipantVerifier): de waarde van @determinerCode MOET 'INSTANCE' zijn. (string(@determinerCode)=('INSTANCE') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(CDAParticipantVerifier): element hl7:name is mandatory [min 1x]. (count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAParticipantVerifier): element hl7:name komt te vaak voor [max 1x]. (count(hl7:name)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-ed04442c-f4ed-4b6f-9dda-b425c09ceb25-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:associatedPerson/hl7:name"
                 priority="1228"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDAParticipantVerifier): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-EN: entity name shall be null or text only or element only (no mixed content) (@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="*[not(@nullFlavor)][normalize-space(.)='']">
         <xsl:message>dtr1-3-EN: empty name particles should not be present. (*[not(@nullFlavor)][normalize-space(.)=''] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="substring(normalize-space(.),1,1)='&#34;'">
         <xsl:message>dtr1-4-EN: Use of quotes at the beginning of a name are probably not correct. (substring(normalize-space(.),1,1)='"' / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="value" select="string-join(.//text(),'')"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-EN: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[string-join(.//text(),'')=$value])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-EN: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (<xsl:text/>
               <xsl:value-of select="$value"/>
               <xsl:text/>) SHALL be distinct (not($set_other[string-join(.//text(),'')=$value]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:*) or hl7:*[count(tokenize(@qualifier,'\s'))=count(distinct-values(tokenize(@qualifier,'\s')))]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-EN: enxp elements SHALL have distinct values in @qualifier (not(hl7:*) or hl7:*[count(tokenize(@qualifier,'\s'))=count(distinct-values(tokenize(@qualifier,'\s')))] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(*[tokenize(@qualifier,'\s')='LS'])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-PN: Person names SHALL NOT contain a name part qualified with 'LS' (Legal status for organizations) (not(*[tokenize(@qualifier,'\s')='LS']) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-6d855331-1064-4c04-b583-6d7c471f910b-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization"
                 priority="1227"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode)=('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDAParticipantVerifier): de waarde van @classCode MOET 'ORG' zijn. (string(@classCode)=('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode)=('INSTANCE')"/>
         <xsl:otherwise>
            <xsl:message>(CDAParticipantVerifier): de waarde van @determinerCode MOET 'INSTANCE' zijn. (string(@determinerCode)=('INSTANCE') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="elmcount"
                    select="count(hl7:id[@root='2.16.528.1.1007.3.3']|hl7:id)"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="$elmcount&gt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAParticipantVerifier): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id) bevat te weinig elementen [min 1x] ($elmcount&gt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[@root='2.16.528.1.1007.3.3'])&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAParticipantVerifier): element hl7:id[@root='2.16.528.1.1007.3.3'] komt te vaak voor [max 1x]. (count(hl7:id[@root='2.16.528.1.1007.3.3'])&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(CDAParticipantVerifier): element hl7:name is mandatory [min 1x]. (count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAParticipantVerifier): element hl7:name komt te vaak voor [max 1x]. (count(hl7:name)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAParticipantVerifier): element hl7:addr komt te vaak voor [max 1x]. (count(hl7:addr)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(lab:code)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAParticipantVerifier): element lab:code komt te vaak voor [max 1x]. (count(lab:code)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-3d0e52d9-801b-4528-b72a-6181cfe4cb62-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/hl7:id[@root='2.16.528.1.1007.3.3']"
                 priority="1226"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="OIDpattern" select="'^[0-2](\.(0|[1-9]\d*))*$'"/>
      <xsl:variable name="RUIDpattern" select="'^[A-Za-z][A-Za-z\d\-]*$'"/>
      <xsl:variable name="UUIDpattern"
                    select="'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-II: @root SHALL be a syntactically correct OID, UUID. (not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern)))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10a-II: @root SHALL NOT be a RUID. Identifiers in this scheme are only defined by balloted HL7 specifications. Local communities or systems must never use such reserved identifiers based on bilateral negotiations. (not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <xsl:variable name="root" select="@root"/>
      <xsl:variable name="extension" select="@extension"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-II: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL be distinct (not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="UUIDpattern"
                    select="'^[0-9a-fA-F]{8}-[0-9a-fA-f]{4}-[0-9a-fA-F]{4}-[0-9a-aA-F]{4}-[0-9a-fA-F]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]'))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-II: When UUID is used, the hexadecimal digits A-F SHALL be in upper case (not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root)=('2.16.528.1.1007.3.3')"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): de waarde van @root MOET '2.16.528.1.1007.3.3' zijn. (string(@root)=('2.16.528.1.1007.3.3') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-3ee13a4f-ac6e-4d33-a39c-aa3e27c1b9b7-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/hl7:id"
                 priority="1225"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="OIDpattern" select="'^[0-2](\.(0|[1-9]\d*))*$'"/>
      <xsl:variable name="RUIDpattern" select="'^[A-Za-z][A-Za-z\d\-]*$'"/>
      <xsl:variable name="UUIDpattern"
                    select="'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-II: @root SHALL be a syntactically correct OID, UUID. (not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern)))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10a-II: @root SHALL NOT be a RUID. Identifiers in this scheme are only defined by balloted HL7 specifications. Local communities or systems must never use such reserved identifiers based on bilateral negotiations. (not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <xsl:variable name="root" select="@root"/>
      <xsl:variable name="extension" select="@extension"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-II: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL be distinct (not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="UUIDpattern"
                    select="'^[0-9a-fA-F]{8}-[0-9a-fA-f]{4}-[0-9a-fA-F]{4}-[0-9a-aA-F]{4}-[0-9a-fA-F]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]'))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-II: When UUID is used, the hexadecimal digits A-F SHALL be in upper case (not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-433e0bcd-2637-4e23-bebb-17add11ce713-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/hl7:name"
                 priority="1224"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-EN: entity name shall be null or text only or element only (no mixed content) (@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="*[not(@nullFlavor)][normalize-space(.)='']">
         <xsl:message>dtr1-3-EN: empty name particles should not be present. (*[not(@nullFlavor)][normalize-space(.)=''] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="substring(normalize-space(.),1,1)='&#34;'">
         <xsl:message>dtr1-4-EN: Use of quotes at the beginning of a name are probably not correct. (substring(normalize-space(.),1,1)='"' / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="value" select="string-join(.//text(),'')"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-EN: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[string-join(.//text(),'')=$value])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-EN: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (<xsl:text/>
               <xsl:value-of select="$value"/>
               <xsl:text/>) SHALL be distinct (not($set_other[string-join(.//text(),'')=$value]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:*) or hl7:*[count(tokenize(@qualifier,'\s'))=count(distinct-values(tokenize(@qualifier,'\s')))]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-EN: enxp elements SHALL have distinct values in @qualifier (not(hl7:*) or hl7:*[count(tokenize(@qualifier,'\s'))=count(distinct-values(tokenize(@qualifier,'\s')))] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family)=0 and count(hl7:given)=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ON: no parts may be person name type particles (count(hl7:family)=0 and count(hl7:given)=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(*)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-ON: organization names SHALL be element content (not(*) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-fb8487f0-74b3-4689-86cb-87fd8cdbe8d0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/hl7:addr"
                 priority="1223"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (count(*)&gt;0 and not(text()[string-length(normalize-space())&gt;0])) or (count(*)=0 and text()[string-length(normalize-space())&gt;0])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-AD: address shall be null or text only or element only (no mixed content) (@nullFlavor or (count(*)&gt;0 and not(text()[string-length(normalize-space())&gt;0])) or (count(*)=0 and text()[string-length(normalize-space())&gt;0]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:useablePeriod/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-AD: no useablePeriod if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:useablePeriod/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(*[self::hl7:useablePeriod][@updateMode])=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-AD: updateMode shall not be used on address elements (count(*[self::hl7:useablePeriod][@updateMode])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or          string-length(hl7:useablePeriod/hl7:low/@value) = string-length(hl7:useablePeriod/hl7:high/@value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-AD: useablePeriod/low/@value must have the same precision as useablePeriod/high/@value (not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or string-length(hl7:useablePeriod/hl7:low/@value) = string-length(hl7:useablePeriod/hl7:high/@value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or         number(substring(concat(hl7:useablePeriod/hl7:low/@value,'00000000000000'),1,14)) &lt; number(substring(concat(hl7:useablePeriod/hl7:high/@value,'00000000000000'),1,14))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-AD: useablePeriod/low/@value must be before useablePeriod/high/@value (not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or number(substring(concat(hl7:useablePeriod/hl7:low/@value,'00000000000000'),1,14)) &lt; number(substring(concat(hl7:useablePeriod/hl7:high/@value,'00000000000000'),1,14)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="tum" select="'^(us|ms|s|min|h|d|wk|mo|a|)$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="matches(hl7:useablePeriod/hl7:width/@unit, $tum)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-AD: for useablePeriod/width only us (microseconds), ms (milliseconds), s (seconds), min (minute), h (hours), d (day), wk (week), mo (month) or a (year) are allowed (matches(hl7:useablePeriod/hl7:width/@unit, $tum) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="*[not(@nullFlavor or self::hl7:useablePeriod)][normalize-space(.)='']">
         <xsl:message>dtr1-8-AD: empty address particles should not be present. (*[not(@nullFlavor or self::hl7:useablePeriod)][normalize-space(.)=''] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="value" select="string-join(.//text(),'')"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-9-AD: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[string-join(.//text(),'')=$value])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-AD: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (<xsl:text/>
               <xsl:value-of select="$value"/>
               <xsl:text/>) SHALL be distinct (not($set_other[string-join(.//text(),'')=$value]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-3640d4e9-ecda-4d3a-8d90-9f58ef398f87-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/hl7:telecom"
                 priority="1222"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or @value"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-URL: elements of type URL SHALL have a @value attribute. (@nullFlavor or @value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or @value=iri-to-uri(@value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-URL: @value must be a valid URI, e.g. '<xsl:text/>
               <xsl:value-of select="iri-to-uri(@value)"/>
               <xsl:text/>'. (@nullFlavor or @value=iri-to-uri(@value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="use" select="@use"/>
      <xsl:variable name="value" select="@value"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-URL: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@value=$value])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-URL: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (<xsl:text/>
               <xsl:value-of select="$value"/>
               <xsl:text/>) SHALL be distinct (not($set_other[@value=$value]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and hl7:usablePeriod)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-TEL: not null and usablePeriod (not(@nullFlavor and hl7:usablePeriod) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-c8d41117-1af3-4632-a78e-bfb73d7503bb-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/lab:code"
                 priority="1221"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CD: null or code and/or originalText (@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CD: code requires codeSystem (@codeSystem or not(@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CD: codeSystemName only if codeSystem (@codeSystem or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CD: codeSystemVersion only if codeSystem (@codeSystem or not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CD: displayName only if code (@code or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@code))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CD: no code if null (not(@nullFlavor) or (@nullFlavor and not(@code)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CD: no displayName if null (not(@nullFlavor) or (@nullFlavor and not(@displayName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-CD: no null on translations (Exceptional values (NULL-values) can not be elements of a set.) (not(.//hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystem][not(@code)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-11-CD: translation code requires codeSystem (not(.//hl7:translation[@codeSystem][not(@code)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystemName][not(@codeSystem)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-CD: translation codeSystemName only if codeSystem (not(.//hl7:translation[@codeSystemName][not(@codeSystem)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-CD: translation codeSystemVersion only if codeSystem (not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@displayName][not(@code)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-14-CD: translation displayName only if code (not(.//hl7:translation[@displayName][not(@code)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="matches(@displayName,'[\r\n\t]')">
         <xsl:message>dtr1-15-CD: it looks like there are formatting instructions in attribute @displayName. Please note that this may lead to
        interoperability problems. (matches(@displayName,'[\r\n\t]') / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-17-CD: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="code" select="@code"/>
      <xsl:variable name="codeSystem" select="@codeSystem"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@code=$code][@codeSystem=$codeSystem])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-18-CD: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (@code=<xsl:text/>
               <xsl:value-of select="$code"/>
               <xsl:text/> @codeSystem=<xsl:text/>
               <xsl:value-of select="$codeSystem"/>
               <xsl:text/>) SHALL be distinct (not($set_other[@code=$code][@codeSystem=$codeSystem]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="translations"
                    select=".//hl7:translation/concat(@code,@codeSystem)"/>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count($translations)=count(distinct-values($translations))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-19-CD: [RIM-002] translations SHALL be distinct (count($translations)=count(distinct-values($translations)) / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <xsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-20-CD: originalText/@language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CE: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theCode" select="@code"/>
      <xsl:variable name="theCodeSystem" select="@codeSystem"/>
      <xsl:variable name="theCodeSystemVersion" select="@codeSystemVersion"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): de elementwaarde MOET een zijn van 'vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH)'. (@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theNullFlavor" select="@nullFlavor"/>
      <xsl:variable name="validNullFlavorsFound"
                    select="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or $validNullFlavorsFound"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): de nulwaarde '<xsl:text/>
               <xsl:value-of select="@nullFlavor"/>
               <xsl:text/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH). (not(@nullFlavor) or $validNullFlavorsFound / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-9c570a92-773e-499b-b573-8fc84b1bc7a8-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:relatedDocument"
                 priority="1220"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode)=('RPLC')"/>
         <xsl:otherwise>
            <xsl:message>(CDArelatedDocument): de waarde van @typeCode MOET 'RPLC' zijn. (string(@typeCode)=('RPLC') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900814-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-86d27472-e6bc-4037-9caa-b5ee6b696099-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]"
                 priority="1219"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode)=('DOC')"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): de waarde van @typeCode MOET 'DOC' zijn. (string(@typeCode)=('DOC') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]])&gt;=1 and not(hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): element hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]] is mandatory [min 1x]. (count(hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]])&gt;=1 and not(hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]])&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): element hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]] komt te vaak voor [max 1x]. (count(hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]])&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-877c11dd-c994-44f7-a80d-6e1b4e9b2de0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]"
                 priority="1218"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode)=('OBS')"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): de waarde van @classCode MOET 'OBS' zijn. (string(@classCode)=('OBS') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode)=('EVN')"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): de waarde van @moodCode MOET 'EVN' zijn. (string(@moodCode)=('EVN') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id)&gt;=1 "/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): element hl7:id is required [min 1x]. (count(hl7:id)&gt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): element hl7:id komt te vaak voor [max 1x]. (count(hl7:id)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')])&gt;=1 and not(hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): element hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')] is mandatory [min 1x]. (count(hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')])&gt;=1 and not(hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')])&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): element hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')] komt te vaak voor [max 1x]. (count(hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')])&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(lab:statusCode[@code='completed'])&gt;=1 and not(lab:statusCode[@code='completed']/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): element lab:statusCode[@code='completed'] is mandatory [min 1x]. (count(lab:statusCode[@code='completed'])&gt;=1 and not(lab:statusCode[@code='completed']/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(lab:statusCode[@code='completed'])&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): element lab:statusCode[@code='completed'] komt te vaak voor [max 1x]. (count(lab:statusCode[@code='completed'])&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime)&gt;=1 "/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): element hl7:effectiveTime is required [min 1x]. (count(hl7:effectiveTime)&gt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): element hl7:effectiveTime komt te vaak voor [max 1x]. (count(hl7:effectiveTime)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]])&gt;=1 "/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): element hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]] is required [min 1x]. (count(hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]])&gt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]])&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): element hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]] komt te vaak voor [max 1x]. (count(hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]])&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-a707f70d-698c-47d1-ae15-a7408072d7b6-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:id"
                 priority="1217"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="OIDpattern" select="'^[0-2](\.(0|[1-9]\d*))*$'"/>
      <xsl:variable name="RUIDpattern" select="'^[A-Za-z][A-Za-z\d\-]*$'"/>
      <xsl:variable name="UUIDpattern"
                    select="'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-II: @root SHALL be a syntactically correct OID, UUID. (not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern)))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10a-II: @root SHALL NOT be a RUID. Identifiers in this scheme are only defined by balloted HL7 specifications. Local communities or systems must never use such reserved identifiers based on bilateral negotiations. (not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <xsl:variable name="root" select="@root"/>
      <xsl:variable name="extension" select="@extension"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-II: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL be distinct (not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="UUIDpattern"
                    select="'^[0-9a-fA-F]{8}-[0-9a-fA-f]{4}-[0-9a-fA-F]{4}-[0-9a-aA-F]{4}-[0-9a-fA-F]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]'))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-II: When UUID is used, the hexadecimal digits A-F SHALL be in upper case (not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-7b29eefa-21f9-454f-8445-61da5e7a9fe8-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]"
                 priority="1216"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CD: null or code and/or originalText (@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CD: code requires codeSystem (@codeSystem or not(@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CD: codeSystemName only if codeSystem (@codeSystem or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CD: codeSystemVersion only if codeSystem (@codeSystem or not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CD: displayName only if code (@code or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@code))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CD: no code if null (not(@nullFlavor) or (@nullFlavor and not(@code)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CD: no displayName if null (not(@nullFlavor) or (@nullFlavor and not(@displayName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-CD: no null on translations (Exceptional values (NULL-values) can not be elements of a set.) (not(.//hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystem][not(@code)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-11-CD: translation code requires codeSystem (not(.//hl7:translation[@codeSystem][not(@code)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystemName][not(@codeSystem)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-CD: translation codeSystemName only if codeSystem (not(.//hl7:translation[@codeSystemName][not(@codeSystem)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-CD: translation codeSystemVersion only if codeSystem (not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@displayName][not(@code)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-14-CD: translation displayName only if code (not(.//hl7:translation[@displayName][not(@code)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="matches(@displayName,'[\r\n\t]')">
         <xsl:message>dtr1-15-CD: it looks like there are formatting instructions in attribute @displayName. Please note that this may lead to
        interoperability problems. (matches(@displayName,'[\r\n\t]') / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-17-CD: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="code" select="@code"/>
      <xsl:variable name="codeSystem" select="@codeSystem"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@code=$code][@codeSystem=$codeSystem])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-18-CD: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (@code=<xsl:text/>
               <xsl:value-of select="$code"/>
               <xsl:text/> @codeSystem=<xsl:text/>
               <xsl:value-of select="$codeSystem"/>
               <xsl:text/>) SHALL be distinct (not($set_other[@code=$code][@codeSystem=$codeSystem]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="translations"
                    select=".//hl7:translation/concat(@code,@codeSystem)"/>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count($translations)=count(distinct-values($translations))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-19-CD: [RIM-002] translations SHALL be distinct (count($translations)=count(distinct-values($translations)) / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <xsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-20-CD: originalText/@language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CE: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): de elementwaarde MOET een zijn van 'code '18746-8' codeSystem '2.16.840.1.113883.6.1''. (@nullFlavor or (@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-9d51c159-1f39-4aba-b809-7d66b894fb45-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/lab:statusCode[@code='completed']"
                 priority="1215"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CS: @code/@typeCode and @nullFlavor are mutually exclusive ((@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CS: cannot have codeSystem (not(@codeSystem) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CS: cannot have codeSystemName (not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CS: cannot have codeSystemVersion (not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CS: cannot have displayName (not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CS: cannot have originalText (not(hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CS: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-CS: cannot have translation (not(hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (@code='completed')"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): de elementwaarde MOET een zijn van 'code 'completed''. (@nullFlavor or (@code='completed') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-b3de6511-8733-4544-82eb-ab8bd82c1ade-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:effectiveTime"
                 priority="1214"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-QTY: no uncertainty (not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-QTY: no history or updateMode (count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-QTY: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="value" select="@value"/>
      <xsl:variable name="unit" select="@unit"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@value=$value][@unit=$unit])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-QTY: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (@value=<xsl:text/>
               <xsl:value-of select="$value"/>
               <xsl:text/> @unit=<xsl:text/>
               <xsl:value-of select="$unit"/>
               <xsl:text/>) SHALL be distinct (not($set_other[@value=$value][@unit=$unit]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(@nullFlavor or @value or *) and not(@nullFlavor and @value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-TS: null or value or child element in case of extension ((@nullFlavor or @value or *) and not(@nullFlavor and @value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theTS" select="@value"/>
      <xsl:variable name="theBC" select="if (starts-with($theTS,'-')) then '-' else ()"/>
      <xsl:variable name="theTZ" select="replace($theTS,'-?[^+-]+([+-].*)?$','$1')"/>
      <xsl:variable name="theTZh"
                    select="if (string-length($theTZ)&gt;0) then substring($theTZ,1,3) else ()"/>
      <xsl:variable name="theTZm"
                    select="if (string-length($theTZ)&gt;3) then substring($theTZ,4) else ()"/>
      <xsl:variable name="theBaseTS" select="replace($theTS,'^-?([^+-]+)([+-].*)?','$1')"/>
      <xsl:variable name="theCentury"
                    select="if (substring($theBaseTS,1,2) castable as xs:integer) then substring($theBaseTS,1,2) else ()"/>
      <xsl:variable name="theYear"
                    select="if (substring($theBaseTS,3,2) castable as xs:integer) then substring($theBaseTS,3,2) else ()"/>
      <xsl:variable name="theMonth"
                    select="if (substring($theBaseTS,5,2) castable as xs:integer) then substring($theBaseTS,5,2) else ()"/>
      <xsl:variable name="theDay"
                    select="if (substring($theBaseTS,7,2) castable as xs:integer) then substring($theBaseTS,7,2) else ()"/>
      <xsl:variable name="theHour"
                    select="if (substring($theBaseTS,9,2) castable as xs:integer) then substring($theBaseTS,9,2) else ()"/>
      <xsl:variable name="theMinute"
                    select="if (substring($theBaseTS,11,2) castable as xs:integer) then substring($theBaseTS,11,2) else ()"/>
      <xsl:variable name="theSecond"
                    select="if (substring($theBaseTS,13,2) castable as xs:integer) then substring($theBaseTS,13,2) else ()"/>
      <xsl:variable name="theSubSecond"
                    select="if (substring($theBaseTS,16) castable as xs:integer) then substring($theBaseTS,15) else ()"/>
      <xsl:variable name="cCentury"
                    select="if (empty($theCentury)) then '00' else $theCentury"/>
      <xsl:variable name="cYear" select="if (empty($theYear)) then '00' else $theYear"/>
      <xsl:variable name="cMonth" select="if (empty($theMonth)) then '01' else $theMonth"/>
      <xsl:variable name="cDay" select="if (empty($theDay)) then '01' else $theDay"/>
      <xsl:variable name="cHour" select="if (empty($theHour)) then '00' else $theHour"/>
      <xsl:variable name="cMinute"
                    select="if (empty($theMinute)) then '00' else $theMinute"/>
      <xsl:variable name="cSecond"
                    select="if (empty($theSecond)) then '00' else $theSecond"/>
      <xsl:variable name="cTZ" select="string-join(($theTZh,$theTZm),':')"/>
      <xsl:variable name="theTSString"
                    select="string-join(($theBC,$theCentury,$theYear,$theMonth,$theDay,$theHour,$theMinute,$theSecond,$theSubSecond,$theTZ),'')"/>
      <xsl:variable name="theDateTime"
                    select="concat($theBC,$cCentury,$cYear,'-',$cMonth,'-',$cDay,'T',$cHour,':',$cMinute,':',$cSecond,$theSubSecond,$cTZ)"/>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="empty($theTS) or ($theTS=$theTSString and $theDateTime castable as xs:dateTime)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-TS: <xsl:text/>
               <xsl:value-of select="local-name()"/>
               <xsl:text/> "<xsl:text/>
               <xsl:value-of select="$theTS"/>
               <xsl:text/>" is not a valid timestamp. (empty($theTS) or ($theTS=$theTSString and $theDateTime castable as xs:dateTime) / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and @operator)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-SXCM_TS: not operator if null (not(@nullFlavor and @operator) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(@nullFlavor and not(@value|@unit|hl7:*)) or (not(@nullFlavor) and (@value|hl7:*))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-IVL_TS: null violation. Cannot have @nullFlavor and @value or child elements, or the other way around ((@nullFlavor and not(@value|@unit|hl7:*)) or (not(@nullFlavor) and (@value|hl7:*)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:*[@nullFlavor and (@value|@unit)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-IVL_TS: null violation. Cannot have @nullFlavor and @value on any child elements (not(hl7:*[@nullFlavor and (@value|@unit)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value and hl7:*)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-IVL_TS: co-occurence violation. Cannot have @value and other child elements (not(@value and hl7:*) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:center and (hl7:low|hl7:high|hl7:width))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-IVL_TS: co-occurence violation. Cannot have center and other child elements (not(hl7:center and (hl7:low|hl7:high|hl7:width)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:*[@updateMode])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-IVL_TS: no updateMode on IVL attributes (not(hl7:*[@updateMode]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:low/@value = hl7:high/@value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-IVL_TS: low/@value must not be equal to high/@value (not(hl7:low/@value = hl7:high/@value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:width[@unit][not(@value)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-PQR: width element: no unit without value (not(hl7:width[@unit][not(@value)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:width/hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-PQR: width element: no translation (not(hl7:width/hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:low/@value and hl7:high/@value) or number(substring(concat(hl7:low/@value,'00000000000000'),1,14)) &lt; number(substring(concat(hl7:high/@value,'00000000000000'),1,14))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-IVL_TS: low/@value must be before high/@value (not(hl7:low/@value and hl7:high/@value) or number(substring(concat(hl7:low/@value,'00000000000000'),1,14)) &lt; number(substring(concat(hl7:high/@value,'00000000000000'),1,14)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="tum" select="'^(us|ms|s|min|h|d|wk|mo|a|)$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="matches(hl7:width/@unit, $tum)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-IVL_TS: for width only us (microseconds), ms (milliseconds), s (seconds), min (minute), h (hours), d (day), wk (week), mo (month) or a (year) are allowed (matches(hl7:width/@unit, $tum) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theTS" select="hl7:low/@value"/>
      <xsl:variable name="theBC" select="if (starts-with($theTS,'-')) then '-' else ()"/>
      <xsl:variable name="theTZ" select="replace($theTS,'-?[^+-]+([+-].*)?$','$1')"/>
      <xsl:variable name="theTZh"
                    select="if (string-length($theTZ)&gt;0) then substring($theTZ,1,3) else ()"/>
      <xsl:variable name="theTZm"
                    select="if (string-length($theTZ)&gt;3) then substring($theTZ,4) else ()"/>
      <xsl:variable name="theBaseTS" select="replace($theTS,'^-?([^+-]+)([+-].*)?','$1')"/>
      <xsl:variable name="theCentury"
                    select="if (substring($theBaseTS,1,2) castable as xs:integer) then substring($theBaseTS,1,2) else ()"/>
      <xsl:variable name="theYear"
                    select="if (substring($theBaseTS,3,2) castable as xs:integer) then substring($theBaseTS,3,2) else ()"/>
      <xsl:variable name="theMonth"
                    select="if (substring($theBaseTS,5,2) castable as xs:integer) then substring($theBaseTS,5,2) else ()"/>
      <xsl:variable name="theDay"
                    select="if (substring($theBaseTS,7,2) castable as xs:integer) then substring($theBaseTS,7,2) else ()"/>
      <xsl:variable name="theHour"
                    select="if (substring($theBaseTS,9,2) castable as xs:integer) then substring($theBaseTS,9,2) else ()"/>
      <xsl:variable name="theMinute"
                    select="if (substring($theBaseTS,11,2) castable as xs:integer) then substring($theBaseTS,11,2) else ()"/>
      <xsl:variable name="theSecond"
                    select="if (substring($theBaseTS,13,2) castable as xs:integer) then substring($theBaseTS,13,2) else ()"/>
      <xsl:variable name="theSubSecond"
                    select="if (substring($theBaseTS,16) castable as xs:integer) then substring($theBaseTS,15) else ()"/>
      <xsl:variable name="cCentury"
                    select="if (empty($theCentury)) then '00' else $theCentury"/>
      <xsl:variable name="cYear" select="if (empty($theYear)) then '00' else $theYear"/>
      <xsl:variable name="cMonth" select="if (empty($theMonth)) then '01' else $theMonth"/>
      <xsl:variable name="cDay" select="if (empty($theDay)) then '01' else $theDay"/>
      <xsl:variable name="cHour" select="if (empty($theHour)) then '00' else $theHour"/>
      <xsl:variable name="cMinute"
                    select="if (empty($theMinute)) then '00' else $theMinute"/>
      <xsl:variable name="cSecond"
                    select="if (empty($theSecond)) then '00' else $theSecond"/>
      <xsl:variable name="cTZ" select="string-join(($theTZh,$theTZm),':')"/>
      <xsl:variable name="theTSString"
                    select="string-join(($theBC,$theCentury,$theYear,$theMonth,$theDay,$theHour,$theMinute,$theSecond,$theSubSecond,$theTZ),'')"/>
      <xsl:variable name="theDateTime"
                    select="concat($theBC,$cCentury,$cYear,'-',$cMonth,'-',$cDay,'T',$cHour,':',$cMinute,':',$cSecond,$theSubSecond,$cTZ)"/>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="empty($theTS) or ($theTS=$theTSString and $theDateTime castable as xs:dateTime)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-9-IVL_TS: <xsl:text/>
               <xsl:value-of select="local-name()"/>
               <xsl:text/>/low "<xsl:text/>
               <xsl:value-of select="$theTS"/>
               <xsl:text/>" is not a valid timestamp. (empty($theTS) or ($theTS=$theTSString and $theDateTime castable as xs:dateTime) / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theTS" select="hl7:center/@value"/>
      <xsl:variable name="theBC" select="if (starts-with($theTS,'-')) then '-' else ()"/>
      <xsl:variable name="theTZ" select="replace($theTS,'-?[^+-]+([+-].*)?$','$1')"/>
      <xsl:variable name="theTZh"
                    select="if (string-length($theTZ)&gt;0) then substring($theTZ,1,3) else ()"/>
      <xsl:variable name="theTZm"
                    select="if (string-length($theTZ)&gt;3) then substring($theTZ,4) else ()"/>
      <xsl:variable name="theBaseTS" select="replace($theTS,'^-?([^+-]+)([+-].*)?','$1')"/>
      <xsl:variable name="theCentury"
                    select="if (substring($theBaseTS,1,2) castable as xs:integer) then substring($theBaseTS,1,2) else ()"/>
      <xsl:variable name="theYear"
                    select="if (substring($theBaseTS,3,2) castable as xs:integer) then substring($theBaseTS,3,2) else ()"/>
      <xsl:variable name="theMonth"
                    select="if (substring($theBaseTS,5,2) castable as xs:integer) then substring($theBaseTS,5,2) else ()"/>
      <xsl:variable name="theDay"
                    select="if (substring($theBaseTS,7,2) castable as xs:integer) then substring($theBaseTS,7,2) else ()"/>
      <xsl:variable name="theHour"
                    select="if (substring($theBaseTS,9,2) castable as xs:integer) then substring($theBaseTS,9,2) else ()"/>
      <xsl:variable name="theMinute"
                    select="if (substring($theBaseTS,11,2) castable as xs:integer) then substring($theBaseTS,11,2) else ()"/>
      <xsl:variable name="theSecond"
                    select="if (substring($theBaseTS,13,2) castable as xs:integer) then substring($theBaseTS,13,2) else ()"/>
      <xsl:variable name="theSubSecond"
                    select="if (substring($theBaseTS,16) castable as xs:integer) then substring($theBaseTS,15) else ()"/>
      <xsl:variable name="cCentury"
                    select="if (empty($theCentury)) then '00' else $theCentury"/>
      <xsl:variable name="cYear" select="if (empty($theYear)) then '00' else $theYear"/>
      <xsl:variable name="cMonth" select="if (empty($theMonth)) then '01' else $theMonth"/>
      <xsl:variable name="cDay" select="if (empty($theDay)) then '01' else $theDay"/>
      <xsl:variable name="cHour" select="if (empty($theHour)) then '00' else $theHour"/>
      <xsl:variable name="cMinute"
                    select="if (empty($theMinute)) then '00' else $theMinute"/>
      <xsl:variable name="cSecond"
                    select="if (empty($theSecond)) then '00' else $theSecond"/>
      <xsl:variable name="cTZ" select="string-join(($theTZh,$theTZm),':')"/>
      <xsl:variable name="theTSString"
                    select="string-join(($theBC,$theCentury,$theYear,$theMonth,$theDay,$theHour,$theMinute,$theSecond,$theSubSecond,$theTZ),'')"/>
      <xsl:variable name="theDateTime"
                    select="concat($theBC,$cCentury,$cYear,'-',$cMonth,'-',$cDay,'T',$cHour,':',$cMinute,':',$cSecond,$theSubSecond,$cTZ)"/>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="empty($theTS) or ($theTS=$theTSString and $theDateTime castable as xs:dateTime)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-9-IVL_TS: <xsl:text/>
               <xsl:value-of select="local-name()"/>
               <xsl:text/>/center "<xsl:text/>
               <xsl:value-of select="$theTS"/>
               <xsl:text/>" is not a valid timestamp. (empty($theTS) or ($theTS=$theTSString and $theDateTime castable as xs:dateTime) / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theTS" select="hl7:high/@value"/>
      <xsl:variable name="theBC" select="if (starts-with($theTS,'-')) then '-' else ()"/>
      <xsl:variable name="theTZ" select="replace($theTS,'-?[^+-]+([+-].*)?$','$1')"/>
      <xsl:variable name="theTZh"
                    select="if (string-length($theTZ)&gt;0) then substring($theTZ,1,3) else ()"/>
      <xsl:variable name="theTZm"
                    select="if (string-length($theTZ)&gt;3) then substring($theTZ,4) else ()"/>
      <xsl:variable name="theBaseTS" select="replace($theTS,'^-?([^+-]+)([+-].*)?','$1')"/>
      <xsl:variable name="theCentury"
                    select="if (substring($theBaseTS,1,2) castable as xs:integer) then substring($theBaseTS,1,2) else ()"/>
      <xsl:variable name="theYear"
                    select="if (substring($theBaseTS,3,2) castable as xs:integer) then substring($theBaseTS,3,2) else ()"/>
      <xsl:variable name="theMonth"
                    select="if (substring($theBaseTS,5,2) castable as xs:integer) then substring($theBaseTS,5,2) else ()"/>
      <xsl:variable name="theDay"
                    select="if (substring($theBaseTS,7,2) castable as xs:integer) then substring($theBaseTS,7,2) else ()"/>
      <xsl:variable name="theHour"
                    select="if (substring($theBaseTS,9,2) castable as xs:integer) then substring($theBaseTS,9,2) else ()"/>
      <xsl:variable name="theMinute"
                    select="if (substring($theBaseTS,11,2) castable as xs:integer) then substring($theBaseTS,11,2) else ()"/>
      <xsl:variable name="theSecond"
                    select="if (substring($theBaseTS,13,2) castable as xs:integer) then substring($theBaseTS,13,2) else ()"/>
      <xsl:variable name="theSubSecond"
                    select="if (substring($theBaseTS,16) castable as xs:integer) then substring($theBaseTS,15) else ()"/>
      <xsl:variable name="cCentury"
                    select="if (empty($theCentury)) then '00' else $theCentury"/>
      <xsl:variable name="cYear" select="if (empty($theYear)) then '00' else $theYear"/>
      <xsl:variable name="cMonth" select="if (empty($theMonth)) then '01' else $theMonth"/>
      <xsl:variable name="cDay" select="if (empty($theDay)) then '01' else $theDay"/>
      <xsl:variable name="cHour" select="if (empty($theHour)) then '00' else $theHour"/>
      <xsl:variable name="cMinute"
                    select="if (empty($theMinute)) then '00' else $theMinute"/>
      <xsl:variable name="cSecond"
                    select="if (empty($theSecond)) then '00' else $theSecond"/>
      <xsl:variable name="cTZ" select="string-join(($theTZh,$theTZm),':')"/>
      <xsl:variable name="theTSString"
                    select="string-join(($theBC,$theCentury,$theYear,$theMonth,$theDay,$theHour,$theMinute,$theSecond,$theSubSecond,$theTZ),'')"/>
      <xsl:variable name="theDateTime"
                    select="concat($theBC,$cCentury,$cYear,'-',$cMonth,'-',$cDay,'T',$cHour,':',$cMinute,':',$cSecond,$theSubSecond,$cTZ)"/>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="empty($theTS) or ($theTS=$theTSString and $theDateTime castable as xs:dateTime)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-9-IVL_TS: <xsl:text/>
               <xsl:value-of select="local-name()"/>
               <xsl:text/>/high "<xsl:text/>
               <xsl:value-of select="$theTS"/>
               <xsl:text/>" is not a valid timestamp. (empty($theTS) or ($theTS=$theTSString and $theDateTime castable as xs:dateTime) / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:low)&gt;=1 "/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): element hl7:low is required [min 1x]. (count(hl7:low)&gt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:low)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): element hl7:low komt te vaak voor [max 1x]. (count(hl7:low)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-73de66ca-5ebc-428e-8e4a-0a330c741d0e-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:effectiveTime/hl7:low"
                 priority="1213"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(StartServiceDate): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900005-2012-04-10T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-QTY: no uncertainty (not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-QTY: no history or updateMode (count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-QTY: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="value" select="@value"/>
      <xsl:variable name="unit" select="@unit"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@value=$value][@unit=$unit])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-QTY: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (@value=<xsl:text/>
               <xsl:value-of select="$value"/>
               <xsl:text/> @unit=<xsl:text/>
               <xsl:value-of select="$unit"/>
               <xsl:text/>) SHALL be distinct (not($set_other[@value=$value][@unit=$unit]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(@nullFlavor or @value or *) and not(@nullFlavor and @value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-TS: null or value or child element in case of extension ((@nullFlavor or @value or *) and not(@nullFlavor and @value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theTS" select="@value"/>
      <xsl:variable name="theBC" select="if (starts-with($theTS,'-')) then '-' else ()"/>
      <xsl:variable name="theTZ" select="replace($theTS,'-?[^+-]+([+-].*)?$','$1')"/>
      <xsl:variable name="theTZh"
                    select="if (string-length($theTZ)&gt;0) then substring($theTZ,1,3) else ()"/>
      <xsl:variable name="theTZm"
                    select="if (string-length($theTZ)&gt;3) then substring($theTZ,4) else ()"/>
      <xsl:variable name="theBaseTS" select="replace($theTS,'^-?([^+-]+)([+-].*)?','$1')"/>
      <xsl:variable name="theCentury"
                    select="if (substring($theBaseTS,1,2) castable as xs:integer) then substring($theBaseTS,1,2) else ()"/>
      <xsl:variable name="theYear"
                    select="if (substring($theBaseTS,3,2) castable as xs:integer) then substring($theBaseTS,3,2) else ()"/>
      <xsl:variable name="theMonth"
                    select="if (substring($theBaseTS,5,2) castable as xs:integer) then substring($theBaseTS,5,2) else ()"/>
      <xsl:variable name="theDay"
                    select="if (substring($theBaseTS,7,2) castable as xs:integer) then substring($theBaseTS,7,2) else ()"/>
      <xsl:variable name="theHour"
                    select="if (substring($theBaseTS,9,2) castable as xs:integer) then substring($theBaseTS,9,2) else ()"/>
      <xsl:variable name="theMinute"
                    select="if (substring($theBaseTS,11,2) castable as xs:integer) then substring($theBaseTS,11,2) else ()"/>
      <xsl:variable name="theSecond"
                    select="if (substring($theBaseTS,13,2) castable as xs:integer) then substring($theBaseTS,13,2) else ()"/>
      <xsl:variable name="theSubSecond"
                    select="if (substring($theBaseTS,16) castable as xs:integer) then substring($theBaseTS,15) else ()"/>
      <xsl:variable name="cCentury"
                    select="if (empty($theCentury)) then '00' else $theCentury"/>
      <xsl:variable name="cYear" select="if (empty($theYear)) then '00' else $theYear"/>
      <xsl:variable name="cMonth" select="if (empty($theMonth)) then '01' else $theMonth"/>
      <xsl:variable name="cDay" select="if (empty($theDay)) then '01' else $theDay"/>
      <xsl:variable name="cHour" select="if (empty($theHour)) then '00' else $theHour"/>
      <xsl:variable name="cMinute"
                    select="if (empty($theMinute)) then '00' else $theMinute"/>
      <xsl:variable name="cSecond"
                    select="if (empty($theSecond)) then '00' else $theSecond"/>
      <xsl:variable name="cTZ" select="string-join(($theTZh,$theTZm),':')"/>
      <xsl:variable name="theTSString"
                    select="string-join(($theBC,$theCentury,$theYear,$theMonth,$theDay,$theHour,$theMinute,$theSecond,$theSubSecond,$theTZ),'')"/>
      <xsl:variable name="theDateTime"
                    select="concat($theBC,$cCentury,$cYear,'-',$cMonth,'-',$cDay,'T',$cHour,':',$cMinute,':',$cSecond,$theSubSecond,$cTZ)"/>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="empty($theTS) or ($theTS=$theTSString and $theDateTime castable as xs:dateTime)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-TS: <xsl:text/>
               <xsl:value-of select="local-name()"/>
               <xsl:text/> "<xsl:text/>
               <xsl:value-of select="$theTS"/>
               <xsl:text/>" is not a valid timestamp. (empty($theTS) or ($theTS=$theTSString and $theDateTime castable as xs:dateTime) / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-0c245496-80b5-43b9-95e2-6ada6969f331-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]"
                 priority="1212"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode)=('PRF')"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): de waarde van @typeCode MOET 'PRF' zijn. (string(@typeCode)=('PRF') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]])&gt;=1 "/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): element hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]] is required [min 1x]. (count(hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]])&gt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]])&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): element hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]] komt te vaak voor [max 1x]. (count(hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]])&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-9fccf01e-11d4-4af0-a783-b793c9dd6a84-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]"
                 priority="1211"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode)=('ASSIGNED')"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): de waarde van @classCode MOET 'ASSIGNED' zijn. (string(@classCode)=('ASSIGNED') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="elmcount"
                    select="count(hl7:id[@root='2.16.528.1.1007.3.1']|hl7:id)"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="$elmcount&gt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): keuze (hl7:id[@root='2.16.528.1.1007.3.1'] of hl7:id) bevat te weinig elementen [min 1x] ($elmcount&gt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[@root='2.16.528.1.1007.3.1'])&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): element hl7:id[@root='2.16.528.1.1007.3.1'] komt te vaak voor [max 1x]. (count(hl7:id[@root='2.16.528.1.1007.3.1'])&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])&gt;=1 "/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): element hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor] is required [min 1x]. (count(hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])&gt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): element hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor] komt te vaak voor [max 1x]. (count(hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson)&gt;=1 "/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): element hl7:assignedPerson is required [min 1x]. (count(hl7:assignedPerson)&gt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): element hl7:assignedPerson komt te vaak voor [max 1x]. (count(hl7:assignedPerson)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedOrganization)&gt;=1 "/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): element hl7:representedOrganization is required [min 1x]. (count(hl7:representedOrganization)&gt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedOrganization)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): element hl7:representedOrganization komt te vaak voor [max 1x]. (count(hl7:representedOrganization)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-9c05388f-da53-4aa2-82fe-b24048e667f3-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:id[@root='2.16.528.1.1007.3.1']"
                 priority="1210"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDAassignedEntityIdentification): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="OIDpattern" select="'^[0-2](\.(0|[1-9]\d*))*$'"/>
      <xsl:variable name="RUIDpattern" select="'^[A-Za-z][A-Za-z\d\-]*$'"/>
      <xsl:variable name="UUIDpattern"
                    select="'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-II: @root SHALL be a syntactically correct OID, UUID. (not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern)))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10a-II: @root SHALL NOT be a RUID. Identifiers in this scheme are only defined by balloted HL7 specifications. Local communities or systems must never use such reserved identifiers based on bilateral negotiations. (not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <xsl:variable name="root" select="@root"/>
      <xsl:variable name="extension" select="@extension"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-II: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL be distinct (not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="UUIDpattern"
                    select="'^[0-9a-fA-F]{8}-[0-9a-fA-f]{4}-[0-9a-fA-F]{4}-[0-9a-aA-F]{4}-[0-9a-fA-F]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]'))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-II: When UUID is used, the hexadecimal digits A-F SHALL be in upper case (not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root)=('2.16.528.1.1007.3.1')"/>
         <xsl:otherwise>
            <xsl:message>(CDAassignedEntityIdentification): de waarde van @root MOET '2.16.528.1.1007.3.1' zijn. (string(@root)=('2.16.528.1.1007.3.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-e51dac92-0288-40a3-86aa-c20ae9037349-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:id"
                 priority="1209"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDAassignedEntityIdentification): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900829-2014-02-09T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="OIDpattern" select="'^[0-2](\.(0|[1-9]\d*))*$'"/>
      <xsl:variable name="RUIDpattern" select="'^[A-Za-z][A-Za-z\d\-]*$'"/>
      <xsl:variable name="UUIDpattern"
                    select="'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-II: @root SHALL be a syntactically correct OID, UUID. (not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern)))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10a-II: @root SHALL NOT be a RUID. Identifiers in this scheme are only defined by balloted HL7 specifications. Local communities or systems must never use such reserved identifiers based on bilateral negotiations. (not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <xsl:variable name="root" select="@root"/>
      <xsl:variable name="extension" select="@extension"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-II: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL be distinct (not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="UUIDpattern"
                    select="'^[0-9a-fA-F]{8}-[0-9a-fA-f]{4}-[0-9a-fA-F]{4}-[0-9a-aA-F]{4}-[0-9a-fA-F]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]'))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-II: When UUID is used, the hexadecimal digits A-F SHALL be in upper case (not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-09c59ffc-5dba-4b3f-9582-8ab5d973e0e7-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]"
                 priority="1208"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CD: null or code and/or originalText (@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CD: code requires codeSystem (@codeSystem or not(@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CD: codeSystemName only if codeSystem (@codeSystem or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CD: codeSystemVersion only if codeSystem (@codeSystem or not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CD: displayName only if code (@code or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@code))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CD: no code if null (not(@nullFlavor) or (@nullFlavor and not(@code)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CD: no displayName if null (not(@nullFlavor) or (@nullFlavor and not(@displayName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-CD: no null on translations (Exceptional values (NULL-values) can not be elements of a set.) (not(.//hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystem][not(@code)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-11-CD: translation code requires codeSystem (not(.//hl7:translation[@codeSystem][not(@code)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystemName][not(@codeSystem)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-CD: translation codeSystemName only if codeSystem (not(.//hl7:translation[@codeSystemName][not(@codeSystem)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-CD: translation codeSystemVersion only if codeSystem (not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@displayName][not(@code)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-14-CD: translation displayName only if code (not(.//hl7:translation[@displayName][not(@code)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="matches(@displayName,'[\r\n\t]')">
         <xsl:message>dtr1-15-CD: it looks like there are formatting instructions in attribute @displayName. Please note that this may lead to
        interoperability problems. (matches(@displayName,'[\r\n\t]') / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-17-CD: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="code" select="@code"/>
      <xsl:variable name="codeSystem" select="@codeSystem"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@code=$code][@codeSystem=$codeSystem])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-18-CD: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (@code=<xsl:text/>
               <xsl:value-of select="$code"/>
               <xsl:text/> @codeSystem=<xsl:text/>
               <xsl:value-of select="$codeSystem"/>
               <xsl:text/>) SHALL be distinct (not($set_other[@code=$code][@codeSystem=$codeSystem]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="translations"
                    select=".//hl7:translation/concat(@code,@codeSystem)"/>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count($translations)=count(distinct-values($translations))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-19-CD: [RIM-002] translations SHALL be distinct (count($translations)=count(distinct-values($translations)) / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <xsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-20-CD: originalText/@language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CE: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theCode" select="@code"/>
      <xsl:variable name="theCodeSystem" select="@codeSystem"/>
      <xsl:variable name="theCodeSystemVersion" select="@codeSystemVersion"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): de elementwaarde MOET een zijn van 'vs_typerol Medische rollen (DYNAMISCH)'. (@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theNullFlavor" select="@nullFlavor"/>
      <xsl:variable name="validNullFlavorsFound"
                    select="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or $validNullFlavorsFound"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): de nulwaarde '<xsl:text/>
               <xsl:value-of select="@nullFlavor"/>
               <xsl:text/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_typerol Medische rollen (DYNAMISCH). (not(@nullFlavor) or $validNullFlavorsFound / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-444c6bcb-bd60-4f2e-897d-4dea60c23783-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:addr"
                 priority="1207"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (count(*)&gt;0 and not(text()[string-length(normalize-space())&gt;0])) or (count(*)=0 and text()[string-length(normalize-space())&gt;0])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-AD: address shall be null or text only or element only (no mixed content) (@nullFlavor or (count(*)&gt;0 and not(text()[string-length(normalize-space())&gt;0])) or (count(*)=0 and text()[string-length(normalize-space())&gt;0]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:useablePeriod/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-AD: no useablePeriod if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:useablePeriod/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(*[self::hl7:useablePeriod][@updateMode])=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-AD: updateMode shall not be used on address elements (count(*[self::hl7:useablePeriod][@updateMode])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or          string-length(hl7:useablePeriod/hl7:low/@value) = string-length(hl7:useablePeriod/hl7:high/@value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-AD: useablePeriod/low/@value must have the same precision as useablePeriod/high/@value (not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or string-length(hl7:useablePeriod/hl7:low/@value) = string-length(hl7:useablePeriod/hl7:high/@value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or         number(substring(concat(hl7:useablePeriod/hl7:low/@value,'00000000000000'),1,14)) &lt; number(substring(concat(hl7:useablePeriod/hl7:high/@value,'00000000000000'),1,14))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-AD: useablePeriod/low/@value must be before useablePeriod/high/@value (not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or number(substring(concat(hl7:useablePeriod/hl7:low/@value,'00000000000000'),1,14)) &lt; number(substring(concat(hl7:useablePeriod/hl7:high/@value,'00000000000000'),1,14)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="tum" select="'^(us|ms|s|min|h|d|wk|mo|a|)$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="matches(hl7:useablePeriod/hl7:width/@unit, $tum)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-AD: for useablePeriod/width only us (microseconds), ms (milliseconds), s (seconds), min (minute), h (hours), d (day), wk (week), mo (month) or a (year) are allowed (matches(hl7:useablePeriod/hl7:width/@unit, $tum) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="*[not(@nullFlavor or self::hl7:useablePeriod)][normalize-space(.)='']">
         <xsl:message>dtr1-8-AD: empty address particles should not be present. (*[not(@nullFlavor or self::hl7:useablePeriod)][normalize-space(.)=''] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="value" select="string-join(.//text(),'')"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-9-AD: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[string-join(.//text(),'')=$value])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-AD: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (<xsl:text/>
               <xsl:value-of select="$value"/>
               <xsl:text/>) SHALL be distinct (not($set_other[string-join(.//text(),'')=$value]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-69a2d4c2-1724-49c8-a028-a71fcaee0a92-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:telecom"
                 priority="1206"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or @value"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-URL: elements of type URL SHALL have a @value attribute. (@nullFlavor or @value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or @value=iri-to-uri(@value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-URL: @value must be a valid URI, e.g. '<xsl:text/>
               <xsl:value-of select="iri-to-uri(@value)"/>
               <xsl:text/>'. (@nullFlavor or @value=iri-to-uri(@value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="use" select="@use"/>
      <xsl:variable name="value" select="@value"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-URL: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@value=$value])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-URL: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (<xsl:text/>
               <xsl:value-of select="$value"/>
               <xsl:text/>) SHALL be distinct (not($set_other[@value=$value]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and hl7:usablePeriod)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-TEL: not null and usablePeriod (not(@nullFlavor and hl7:usablePeriod) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-36587874-2bfd-4210-bb68-26282b147846-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:assignedPerson"
                 priority="1205"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode)=('PSN')"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): de waarde van @classCode MOET 'PSN' zijn. (string(@classCode)=('PSN') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode)=('INSTANCE')"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): de waarde van @determinerCode MOET 'INSTANCE' zijn. (string(@determinerCode)=('INSTANCE') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name)&gt;=1 "/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): element hl7:name is required [min 1x]. (count(hl7:name)&gt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-5d9089d2-cabf-4bff-95a2-a6859bed3b0c-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:assignedPerson/hl7:name"
                 priority="1204"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-EN: entity name shall be null or text only or element only (no mixed content) (@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="*[not(@nullFlavor)][normalize-space(.)='']">
         <xsl:message>dtr1-3-EN: empty name particles should not be present. (*[not(@nullFlavor)][normalize-space(.)=''] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="substring(normalize-space(.),1,1)='&#34;'">
         <xsl:message>dtr1-4-EN: Use of quotes at the beginning of a name are probably not correct. (substring(normalize-space(.),1,1)='"' / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="value" select="string-join(.//text(),'')"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-EN: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[string-join(.//text(),'')=$value])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-EN: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (<xsl:text/>
               <xsl:value-of select="$value"/>
               <xsl:text/>) SHALL be distinct (not($set_other[string-join(.//text(),'')=$value]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:*) or hl7:*[count(tokenize(@qualifier,'\s'))=count(distinct-values(tokenize(@qualifier,'\s')))]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-EN: enxp elements SHALL have distinct values in @qualifier (not(hl7:*) or hl7:*[count(tokenize(@qualifier,'\s'))=count(distinct-values(tokenize(@qualifier,'\s')))] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(*[tokenize(@qualifier,'\s')='LS'])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-PN: Person names SHALL NOT contain a name part qualified with 'LS' (Legal status for organizations) (not(*[tokenize(@qualifier,'\s')='LS']) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-fe527ee3-da7e-4d4c-9261-8d35e5ccde80-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization"
                 priority="1203"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode)=('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): de waarde van @classCode MOET 'ORG' zijn. (string(@classCode)=('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode)=('INSTANCE')"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): de waarde van @determinerCode MOET 'INSTANCE' zijn. (string(@determinerCode)=('INSTANCE') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="elmcount"
                    select="count(hl7:id[@root='2.16.528.1.1007.3.3']|hl7:id)"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="$elmcount&gt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id) bevat te weinig elementen [min 1x] ($elmcount&gt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[@root='2.16.528.1.1007.3.3'])&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): element hl7:id[@root='2.16.528.1.1007.3.3'] komt te vaak voor [max 1x]. (count(hl7:id[@root='2.16.528.1.1007.3.3'])&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): element hl7:name is mandatory [min 1x]. (count(hl7:name)&gt;=1 and not(hl7:name/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): element hl7:name komt te vaak voor [max 1x]. (count(hl7:name)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): element hl7:addr komt te vaak voor [max 1x]. (count(hl7:addr)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(lab:code)&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): element lab:code komt te vaak voor [max 1x]. (count(lab:code)&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-deec171f-a177-4ad9-b2d5-134c23797ce3-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:id[@root='2.16.528.1.1007.3.3']"
                 priority="1202"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="OIDpattern" select="'^[0-2](\.(0|[1-9]\d*))*$'"/>
      <xsl:variable name="RUIDpattern" select="'^[A-Za-z][A-Za-z\d\-]*$'"/>
      <xsl:variable name="UUIDpattern"
                    select="'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-II: @root SHALL be a syntactically correct OID, UUID. (not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern)))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10a-II: @root SHALL NOT be a RUID. Identifiers in this scheme are only defined by balloted HL7 specifications. Local communities or systems must never use such reserved identifiers based on bilateral negotiations. (not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <xsl:variable name="root" select="@root"/>
      <xsl:variable name="extension" select="@extension"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-II: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL be distinct (not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="UUIDpattern"
                    select="'^[0-9a-fA-F]{8}-[0-9a-fA-f]{4}-[0-9a-fA-F]{4}-[0-9a-aA-F]{4}-[0-9a-fA-F]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]'))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-II: When UUID is used, the hexadecimal digits A-F SHALL be in upper case (not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root)=('2.16.528.1.1007.3.3')"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): de waarde van @root MOET '2.16.528.1.1007.3.3' zijn. (string(@root)=('2.16.528.1.1007.3.3') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-edd255bf-2c94-4333-8f53-a0556ecf853c-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:id"
                 priority="1201"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="OIDpattern" select="'^[0-2](\.(0|[1-9]\d*))*$'"/>
      <xsl:variable name="RUIDpattern" select="'^[A-Za-z][A-Za-z\d\-]*$'"/>
      <xsl:variable name="UUIDpattern"
                    select="'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-II: @root SHALL be a syntactically correct OID, UUID. (not(@root) or matches(@root, $OIDpattern) or matches(@root, $UUIDpattern) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern)))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10a-II: @root SHALL NOT be a RUID. Identifiers in this scheme are only defined by balloted HL7 specifications. Local communities or systems must never use such reserved identifiers based on bilateral negotiations. (not(matches(@root, $RUIDpattern) and not(matches(@root, $UUIDpattern))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>
      <xsl:variable name="root" select="@root"/>
      <xsl:variable name="extension" select="@extension"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-II: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL be distinct (not($set_other[@root=$root][empty($extension)] or $set_other[@root=$root][@extension=$extension]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="UUIDpattern"
                    select="'^[0-9a-fA-F]{8}-[0-9a-fA-f]{4}-[0-9a-fA-F]{4}-[0-9a-aA-F]{4}-[0-9a-fA-F]{12}$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]'))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-II: When UUID is used, the hexadecimal digits A-F SHALL be in upper case (not(@root) or not(matches(@root,$UUIDpattern) and matches(@root,'[a-z]')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-7b16f787-95ff-4768-a3c1-d5659ed579b5-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:name"
                 priority="1200"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-EN: entity name shall be null or text only or element only (no mixed content) (@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="*[not(@nullFlavor)][normalize-space(.)='']">
         <xsl:message>dtr1-3-EN: empty name particles should not be present. (*[not(@nullFlavor)][normalize-space(.)=''] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
      <xsl:if test="substring(normalize-space(.),1,1)='&#34;'">
         <xsl:message>dtr1-4-EN: Use of quotes at the beginning of a name are probably not correct. (substring(normalize-space(.),1,1)='"' / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="value" select="string-join(.//text(),'')"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-EN: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[string-join(.//text(),'')=$value])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-EN: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (<xsl:text/>
               <xsl:value-of select="$value"/>
               <xsl:text/>) SHALL be distinct (not($set_other[string-join(.//text(),'')=$value]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:*) or hl7:*[count(tokenize(@qualifier,'\s'))=count(distinct-values(tokenize(@qualifier,'\s')))]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-EN: enxp elements SHALL have distinct values in @qualifier (not(hl7:*) or hl7:*[count(tokenize(@qualifier,'\s'))=count(distinct-values(tokenize(@qualifier,'\s')))] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family)=0 and count(hl7:given)=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ON: no parts may be person name type particles (count(hl7:family)=0 and count(hl7:given)=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(*)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-ON: organization names SHALL be element content (not(*) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-eecf74fb-0961-41a9-a453-b2a3c2d66411-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:addr"
                 priority="1199"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (count(*)&gt;0 and not(text()[string-length(normalize-space())&gt;0])) or (count(*)=0 and text()[string-length(normalize-space())&gt;0])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-AD: address shall be null or text only or element only (no mixed content) (@nullFlavor or (count(*)&gt;0 and not(text()[string-length(normalize-space())&gt;0])) or (count(*)=0 and text()[string-length(normalize-space())&gt;0]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:useablePeriod/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-AD: no useablePeriod if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:useablePeriod/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(*[self::hl7:useablePeriod][@updateMode])=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-AD: updateMode shall not be used on address elements (count(*[self::hl7:useablePeriod][@updateMode])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or          string-length(hl7:useablePeriod/hl7:low/@value) = string-length(hl7:useablePeriod/hl7:high/@value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-AD: useablePeriod/low/@value must have the same precision as useablePeriod/high/@value (not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or string-length(hl7:useablePeriod/hl7:low/@value) = string-length(hl7:useablePeriod/hl7:high/@value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or         number(substring(concat(hl7:useablePeriod/hl7:low/@value,'00000000000000'),1,14)) &lt; number(substring(concat(hl7:useablePeriod/hl7:high/@value,'00000000000000'),1,14))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-AD: useablePeriod/low/@value must be before useablePeriod/high/@value (not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or number(substring(concat(hl7:useablePeriod/hl7:low/@value,'00000000000000'),1,14)) &lt; number(substring(concat(hl7:useablePeriod/hl7:high/@value,'00000000000000'),1,14)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="tum" select="'^(us|ms|s|min|h|d|wk|mo|a|)$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="matches(hl7:useablePeriod/hl7:width/@unit, $tum)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-AD: for useablePeriod/width only us (microseconds), ms (milliseconds), s (seconds), min (minute), h (hours), d (day), wk (week), mo (month) or a (year) are allowed (matches(hl7:useablePeriod/hl7:width/@unit, $tum) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="*[not(@nullFlavor or self::hl7:useablePeriod)][normalize-space(.)='']">
         <xsl:message>dtr1-8-AD: empty address particles should not be present. (*[not(@nullFlavor or self::hl7:useablePeriod)][normalize-space(.)=''] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="value" select="string-join(.//text(),'')"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-9-AD: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[string-join(.//text(),'')=$value])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-AD: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (<xsl:text/>
               <xsl:value-of select="$value"/>
               <xsl:text/>) SHALL be distinct (not($set_other[string-join(.//text(),'')=$value]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-77fbc822-c4c2-4385-9f9c-66ae6f7dd9e3-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/hl7:telecom"
                 priority="1198"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or @value"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-URL: elements of type URL SHALL have a @value attribute. (@nullFlavor or @value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or @value=iri-to-uri(@value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-URL: @value must be a valid URI, e.g. '<xsl:text/>
               <xsl:value-of select="iri-to-uri(@value)"/>
               <xsl:text/>'. (@nullFlavor or @value=iri-to-uri(@value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="use" select="@use"/>
      <xsl:variable name="value" select="@value"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-URL: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@value=$value])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-URL: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (<xsl:text/>
               <xsl:value-of select="$value"/>
               <xsl:text/>) SHALL be distinct (not($set_other[@value=$value]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and hl7:usablePeriod)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-TEL: not null and usablePeriod (not(@nullFlavor and hl7:usablePeriod) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-31190c8e-a608-4987-a023-cc84483490f5-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/lab:code"
                 priority="1197"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<xsl:text/>
               <xsl:value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>}:<xsl:text/>
               <xsl:value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>
               <xsl:text/>" ((local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(descendant-or-self::hl7:*[@nullFlavor]) or           descendant-or-self::hl7:*[           (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or            ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or            (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ANY: if there is a nullFlavor, there shall be no text or other attribute or element, unless it's nullFlavor='OTH' or 'NA' (@codeSystem, &lt;originalText&gt; or &lt;translation&gt; may have a value), or nullFlavor 'UNC' (@extension may have a value) (not(descendant-or-self::hl7:*[@nullFlavor]) or descendant-or-self::hl7:*[ (@nullFlavor and count(@* except (@xsi:type|@xsi:nil|@classCode|@typeCode|@determinerCode|@moodCode|@nullFlavor))=0 and count(*)=0 and not(text()[string-length(normalize-space())&gt;0])) or ((@nullFlavor='OTH' or @nullFlavor='NA') and (@codeSystem or hl7:originalText or hl7:translation) and count(@* except (@xsi:type|@xsi:nil|@codeSystem|@nullFlavor))=0) or (@nullFlavor='UNC' and (@extension) and count(@* except (@xsi:type|@xsi:nill|@extension|@nullFlavor))=0)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CD: null or code and/or originalText (@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CD: code requires codeSystem (@codeSystem or not(@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CD: codeSystemName only if codeSystem (@codeSystem or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CD: codeSystemVersion only if codeSystem (@codeSystem or not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CD: displayName only if code (@code or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@code))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CD: no code if null (not(@nullFlavor) or (@nullFlavor and not(@code)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CD: no displayName if null (not(@nullFlavor) or (@nullFlavor and not(@displayName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-CD: no null on translations (Exceptional values (NULL-values) can not be elements of a set.) (not(.//hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystem][not(@code)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-11-CD: translation code requires codeSystem (not(.//hl7:translation[@codeSystem][not(@code)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystemName][not(@codeSystem)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-CD: translation codeSystemName only if codeSystem (not(.//hl7:translation[@codeSystemName][not(@codeSystem)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-CD: translation codeSystemVersion only if codeSystem (not(.//hl7:translation[@codeSystemVersion][not(@codeSystem)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:translation[@displayName][not(@code)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-14-CD: translation displayName only if code (not(.//hl7:translation[@displayName][not(@code)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="matches(@displayName,'[\r\n\t]')">
         <xsl:message>dtr1-15-CD: it looks like there are formatting instructions in attribute @displayName. Please note that this may lead to
        interoperability problems. (matches(@displayName,'[\r\n\t]') / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="name" select="local-name()"/>
      <xsl:variable name="set_other"
                    select="preceding-sibling::*[local-name()=$name] | following-sibling::*[local-name()=$name]"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor and $set_other[not(@nullFlavor)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-17-CD: [RIM-001] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> SHALL NOT have nullFlavor, if there are other <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> elements which are not null (not(@nullFlavor and $set_other[not(@nullFlavor)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="code" select="@code"/>
      <xsl:variable name="codeSystem" select="@codeSystem"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not($set_other[@code=$code][@codeSystem=$codeSystem])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-18-CD: [RIM-002] <xsl:text/>
               <xsl:value-of select="$name"/>
               <xsl:text/> (@code=<xsl:text/>
               <xsl:value-of select="$code"/>
               <xsl:text/> @codeSystem=<xsl:text/>
               <xsl:value-of select="$codeSystem"/>
               <xsl:text/>) SHALL be distinct (not($set_other[@code=$code][@codeSystem=$codeSystem]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="translations"
                    select=".//hl7:translation/concat(@code,@codeSystem)"/>

		    <!--ASSERT -->
      <xsl:choose>
         <xsl:when test="count($translations)=count(distinct-values($translations))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-19-CD: [RIM-002] translations SHALL be distinct (count($translations)=count(distinct-values($translations)) / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="RFC3066" select="'^[a-z]{2,3}(-[a-z]{2})?|[ix](-[a-z\d]{2,8})+$'"/>
      <xsl:variable name="RFC3066restricted" select="'^[a-z]{2,3}(-[a-z]{2})?$'"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-20-CD: originalText/@language SHALL conform to RFC 3066. This usually has format sss?-CC with sss? for language code (ISO-639-1 / ISO-639-2) and optional CC for country code (conform ISO-3166 alpha-2) (not(.//hl7:originalText[@language and not(matches(@language,$RFC3066,'i'))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CE: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theCode" select="@code"/>
      <xsl:variable name="theCodeSystem" select="@codeSystem"/>
      <xsl:variable name="theCodeSystemVersion" select="@codeSystemVersion"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): de elementwaarde MOET een zijn van 'vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH)'. (@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet[conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theNullFlavor" select="@nullFlavor"/>
      <xsl:variable name="validNullFlavorsFound"
                    select="exists(doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.6-DYNAMIC.xml')/*/valueSet/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@nullFlavor) or $validNullFlavorsFound"/>
         <xsl:otherwise>
            <xsl:message>(CDArepresentedOrganization): de nulwaarde '<xsl:text/>
               <xsl:value-of select="@nullFlavor"/>
               <xsl:text/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst vs_typezorgaanbieder_SO Type zorgaanbieder (DYNAMISCH). (not(@nullFlavor) or $validNullFlavorsFound / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900809-2013-06-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-dbcccaf0-42c1-4db7-a038-10bee27b9b65-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component"
                 priority="1196"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode)=('COMP')"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): de waarde van @typeCode MOET 'COMP' zijn. (string(@typeCode)=('COMP') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextConductionInd)=('true')"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): de waarde van @contextConductionInd MOET 'true' zijn. (string(@contextConductionInd)=('true') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-f163b083-159a-4581-ae66-e30e57fd715f-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody"
                 priority="1195"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode)=('DOCBODY')"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): de waarde van @classCode MOET 'DOCBODY' zijn. (string(@classCode)=('DOCBODY') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode)=('EVN')"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): de waarde van @moodCode MOET 'EVN' zijn. (string(@moodCode)=('EVN') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.201']])&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.201']] komt te vaak voor [max 1x]. (count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.201']])&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']])&gt;=1 and not(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']]/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']] is mandatory [min 1x]. (count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']])&gt;=1 and not(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']]/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']])&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']] komt te vaak voor [max 1x]. (count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']])&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']])&gt;=1 and not(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']] is mandatory [min 1x]. (count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']])&gt;=1 and not(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']])&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']] komt te vaak voor [max 1x]. (count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']])&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']])&gt;=1 and not(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']] is mandatory [min 1x]. (count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']])&gt;=1 and not(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']])&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']] komt te vaak voor [max 1x]. (count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']])&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']])&gt;=1 and not(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']] is mandatory [min 1x]. (count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']])&gt;=1 and not(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']])&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']] komt te vaak voor [max 1x]. (count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']])&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']])&gt;=1 and not(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']] is mandatory [min 1x]. (count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']])&gt;=1 and not(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']])&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']] komt te vaak voor [max 1x]. (count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']])&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']])&gt;=1 and not(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']]/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']] is mandatory [min 1x]. (count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']])&gt;=1 and not(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']]/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']])&lt;=1"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): element hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']] komt te vaak voor [max 1x]. (count(hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']])&lt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.201']]"
                 priority="1194"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode)=('COMP')"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): de waarde van @typeCode MOET 'COMP' zijn. (string(@typeCode)=('COMP') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextConductionInd)=('true')"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): de waarde van @contextConductionInd MOET 'true' zijn. (string(@contextConductionInd)=('true') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']]"
                 priority="1193"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode)=('COMP')"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): de waarde van @typeCode MOET 'COMP' zijn. (string(@typeCode)=('COMP') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextConductionInd)=('true')"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): de waarde van @contextConductionInd MOET 'true' zijn. (string(@contextConductionInd)=('true') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]"
                 priority="1192"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode)=('COMP')"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): de waarde van @typeCode MOET 'COMP' zijn. (string(@typeCode)=('COMP') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextConductionInd)=('true')"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): de waarde van @contextConductionInd MOET 'true' zijn. (string(@contextConductionInd)=('true') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]"
                 priority="1191"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode)=('COMP')"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): de waarde van @typeCode MOET 'COMP' zijn. (string(@typeCode)=('COMP') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextConductionInd)=('true')"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): de waarde van @contextConductionInd MOET 'true' zijn. (string(@contextConductionInd)=('true') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]"
                 priority="1190"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode)=('COMP')"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): de waarde van @typeCode MOET 'COMP' zijn. (string(@typeCode)=('COMP') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextConductionInd)=('true')"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): de waarde van @contextConductionInd MOET 'true' zijn. (string(@contextConductionInd)=('true') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]"
                 priority="1189"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode)=('COMP')"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): de waarde van @typeCode MOET 'COMP' zijn. (string(@typeCode)=('COMP') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextConductionInd)=('true')"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): de waarde van @contextConductionInd MOET 'true' zijn. (string(@contextConductionInd)=('true') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']]"
                 priority="1188"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode)=('COMP')"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): de waarde van @typeCode MOET 'COMP' zijn. (string(@typeCode)=('COMP') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextConductionInd)=('true')"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): de waarde van @contextConductionInd MOET 'true' zijn. (string(@contextConductionInd)=('true') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-ca4f277f-5fd9-4bfb-8f47-960b1a814a75-->
   <xsl:template match="/*[not(self::hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1'])]"
                 priority="1187"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-ca4f277f-5fd9-4bfb-8f47-960b1a814a75) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-02b8e18d-ebeb-4080-8493-5f6d6021b7b4-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/*[not(self::hl7:realmCode[@code='NL']|self::hl7:typeId[@root='2.16.840.1.113883.1.3']|self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.11']|self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.1']|self::hl7:id|self::hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:title|self::hl7:effectiveTime|self::hl7:confidentialityCode[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)]|self::hl7:languageCode|self::hl7:setId|self::hl7:versionNumber|self::hl7:recordTarget|self::hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100']|self::hl7:custodian|self::hl7:informationRecipient|self::hl7:authenticator|self::hl7:legalAuthenticator|self::hl7:participant|self::hl7:relatedDocument|self::hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]|self::hl7:component)]"
                 priority="1186"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-02b8e18d-ebeb-4080-8493-5f6d6021b7b4) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-ca703da4-1594-42df-b63f-190fcf4b9593-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget/*[not(self::hl7:patientRole)]"
                 priority="1185"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTargetMDL): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-ca703da4-1594-42df-b63f-190fcf4b9593) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900830-2014-02-09T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-845b8f60-237a-4f3d-a215-28154f059d36-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:recordTarget/hl7:patientRole/*[not(self::hl7:id[@root='2.16.840.1.113883.2.4.6.3']|self::hl7:id[not(@root='2.16.840.1.113883.2.4.6.3')])]"
                 priority="1184"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTargetMDL): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-845b8f60-237a-4f3d-a215-28154f059d36) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900830-2014-02-09T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-18b86e36-1b05-4af9-9944-6b79d33d3305-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.100']|self::hl7:time|self::hl7:assignedAuthor)]"
                 priority="1183"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-18b86e36-1b05-4af9-9944-6b79d33d3305) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.100-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-5dc18098-e4e4-4ffc-bd85-6d92a92497b5-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100']/hl7:assignedAuthor/*[not(self::hl7:id[@root='2.16.528.1.1007.3.1']|self::hl7:id|self::hl7:code|self::hl7:assignedPerson|self::hl7:representedOrganization)]"
                 priority="1182"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-5dc18098-e4e4-4ffc-bd85-6d92a92497b5) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.100-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-7b5a6fd4-a6dc-4466-bee9-864ad05179d6-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100']/hl7:assignedAuthor/hl7:assignedPerson/*[not(self::hl7:name)]"
                 priority="1181"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-7b5a6fd4-a6dc-4466-bee9-864ad05179d6) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.100-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-6b61a7a2-2810-4e0c-b857-771ecca92564-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:author[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.100']/hl7:assignedAuthor/hl7:representedOrganization/*[not(self::hl7:id[@root='2.16.528.1.1007.3.3']|self::hl7:id|self::hl7:name|self::hl7:addr|self::hl7:telecom|self::lab:code)]"
                 priority="1180"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-6b61a7a2-2810-4e0c-b857-771ecca92564) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.100-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-5a181418-0e40-4b98-8cda-19720f7504fe-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/*[not(self::hl7:assignedCustodian)]"
                 priority="1179"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-5a181418-0e40-4b98-8cda-19720f7504fe) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-ac9227a7-6606-4b95-9377-7d134cd059d7-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/*[not(self::hl7:representedCustodianOrganization)]"
                 priority="1178"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-ac9227a7-6606-4b95-9377-7d134cd059d7) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-68b28e12-43e4-4bb3-8615-d8d9befb7a86-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization/*[not(self::hl7:id[@root='2.16.528.1.1007.3.3']|self::hl7:id|self::hl7:name|self::hl7:addr|self::hl7:telecom|self::lab:code)]"
                 priority="1177"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-68b28e12-43e4-4bb3-8615-d8d9befb7a86) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900810-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-2ba3a14f-c81e-4e83-9a59-0b711b1f5e1c-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/*[not(self::hl7:intendedRecipient)]"
                 priority="1176"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(CDAinformationRecipient): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-2ba3a14f-c81e-4e83-9a59-0b711b1f5e1c) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-c799008d-3b21-4a90-ac87-22976e2d232c-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/*[not(self::hl7:id|self::hl7:informationRecipient|self::hl7:representedOrganization)]"
                 priority="1175"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(CDAinformationRecipient): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-c799008d-3b21-4a90-ac87-22976e2d232c) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-7c3da2c8-c14e-4644-bb5f-a5316d38ffa4-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:informationRecipient/*[not(self::hl7:name)]"
                 priority="1174"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(CDAinformationRecipient): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-7c3da2c8-c14e-4644-bb5f-a5316d38ffa4) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-a9e29b24-b788-4612-ad79-3e0bcdf3ab4c-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:informationRecipient/hl7:intendedRecipient/hl7:representedOrganization/*[not(self::hl7:id[@root='2.16.528.1.1007.3.3']|self::hl7:id|self::hl7:name|self::hl7:addr|self::hl7:telecom|self::lab:code)]"
                 priority="1173"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(CDAinformationRecipient): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-a9e29b24-b788-4612-ad79-3e0bcdf3ab4c) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900811-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-3e9ff897-4300-4a89-b44e-1038c2a93bad-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/*[not(self::hl7:time|self::hl7:signatureCode[@code='S']|self::hl7:assignedEntity)]"
                 priority="1172"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-3e9ff897-4300-4a89-b44e-1038c2a93bad) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-ea26e9b8-2130-4115-b497-788342e2bf30-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/*[not(self::hl7:id[@root='2.16.528.1.1007.3.1']|self::hl7:id|self::hl7:code|self::hl7:assignedPerson|self::hl7:representedOrganization)]"
                 priority="1171"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-ea26e9b8-2130-4115-b497-788342e2bf30) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-6be54a48-8825-41ee-bed3-f7face05d4b2-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:assignedPerson/*[not(self::hl7:name)]"
                 priority="1170"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-6be54a48-8825-41ee-bed3-f7face05d4b2) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-fc9dba2a-5f69-4d30-9029-766aa3704a28-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:legalAuthenticator/hl7:assignedEntity/hl7:representedOrganization/*[not(self::hl7:id[@root='2.16.528.1.1007.3.3']|self::hl7:id|self::hl7:name|self::hl7:addr|self::hl7:telecom|self::lab:code)]"
                 priority="1169"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(CDlegalAuthenticator): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-fc9dba2a-5f69-4d30-9029-766aa3704a28) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900813-2012-07-04T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-ee7f110b-4245-459f-b71e-839037d2009c-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/*[not(self::hl7:time|self::hl7:associatedEntity)]"
                 priority="1168"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(CDAParticipantVerifier): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-ee7f110b-4245-459f-b71e-839037d2009c) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-d8f3b178-3fe4-4fab-af8b-8bb3794665e7-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/*[not(self::hl7:id[@root='2.16.528.1.1007.3.1']|self::hl7:id|self::hl7:code|self::hl7:associatedPerson|self::hl7:scopingOrganization)]"
                 priority="1167"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(CDAParticipantVerifier): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-d8f3b178-3fe4-4fab-af8b-8bb3794665e7) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-806d1e5c-848f-41bf-969e-fc1a7d59e260-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:associatedPerson/*[not(self::hl7:name)]"
                 priority="1166"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(CDAParticipantVerifier): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-806d1e5c-848f-41bf-969e-fc1a7d59e260) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-5b2d2a39-0f0d-4d14-a422-c650c9a2bbfa-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:participant/hl7:associatedEntity/hl7:scopingOrganization/*[not(self::hl7:id[@root='2.16.528.1.1007.3.3']|self::hl7:id|self::hl7:name|self::hl7:addr|self::hl7:telecom|self::lab:code)]"
                 priority="1165"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(CDAParticipantVerifier): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-5b2d2a39-0f0d-4d14-a422-c650c9a2bbfa) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900817-2012-12-11T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-c3df9367-e198-4751-9e96-875129585daf-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/*[not(self::hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]])]"
                 priority="1164"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-c3df9367-e198-4751-9e96-875129585daf) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-0e1548bf-eef4-4050-ba5e-99dbbe00718c-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/*[not(self::hl7:id|self::hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]|self::lab:statusCode[@code='completed']|self::hl7:effectiveTime|self::hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]])]"
                 priority="1163"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-0e1548bf-eef4-4050-ba5e-99dbbe00718c) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-6f9644b9-2d4f-4e40-8c4f-9334433ec388-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:effectiveTime/*[not(self::hl7:low)]"
                 priority="1162"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-6f9644b9-2d4f-4e40-8c4f-9334433ec388) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-1b68deb3-6c10-40d4-8c5d-fa90b78fea99-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/*[not(self::hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]])]"
                 priority="1161"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-1b68deb3-6c10-40d4-8c5d-fa90b78fea99) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-9bb93bcf-a6b9-4f99-bea0-d2e47918cb62-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/*[not(self::hl7:id[@root='2.16.528.1.1007.3.1']|self::hl7:id|self::hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]|self::hl7:addr|self::hl7:telecom|self::hl7:assignedPerson|self::hl7:representedOrganization)]"
                 priority="1160"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-9bb93bcf-a6b9-4f99-bea0-d2e47918cb62) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-b8317eb9-3acc-4470-9c77-27327771f9b4-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:assignedPerson/*[not(self::hl7:name)]"
                 priority="1159"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-b8317eb9-3acc-4470-9c77-27327771f9b4) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-1c2c0884-5db7-4051-9fd2-6c44549acf8b-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:documentationOf[hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]]/hl7:serviceEvent[hl7:code[(@code='18746-8' and @codeSystem='2.16.840.1.113883.6.1')]]/hl7:performer[hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:assignedEntity[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.5-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/hl7:representedOrganization/*[not(self::hl7:id[@root='2.16.528.1.1007.3.3']|self::hl7:id|self::hl7:name|self::hl7:addr|self::hl7:telecom|self::lab:code)]"
                 priority="1158"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(CDAdocumentationOfMDL): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-1c2c0884-5db7-4051-9fd2-6c44549acf8b) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900815-2014-07-15T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-fbdef1c1-8053-4cec-807d-f668a328c1e0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/*[not(self::hl7:structuredBody)]"
                 priority="1157"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-fbdef1c1-8053-4cec-807d-f668a328c1e0) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-d3f98449-7c93-491f-aa4e-cfc7317f473d-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/*[not(self::hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.201']]|self::hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']]|self::hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]|self::hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]|self::hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.205']]|self::hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.207']]|self::hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.208']])]"
                 priority="1156"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-d3f98449-7c93-491f-aa4e-cfc7317f473d) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-77f663ac-455d-4ae9-af09-31e9729a9f6f-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.201']]/*[not(self::hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.201'])]"
                 priority="1155"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-77f663ac-455d-4ae9-af09-31e9729a9f6f) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-93a9aca1-d38b-49ff-a4d0-d0c8debb3d79-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.201']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.201']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.201']|self::hl7:code[(@code='X-SALUT' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:title|self::hl7:text)]"
                 priority="1154"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-93a9aca1-d38b-49ff-a4d0-d0c8debb3d79) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-6f5328d9-6b26-4d45-87ae-84cf8a0fe769-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']]/*[not(self::hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202'])]"
                 priority="1153"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-6f5328d9-6b26-4d45-87ae-84cf8a0fe769) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-82724c9b-aeda-4a89-b9fd-663e900ee0ed-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.202']|self::hl7:code[(@code='59768-2' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:title|self::hl7:text|self::hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']])]"
                 priority="1152"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-82724c9b-aeda-4a89-b9fd-663e900ee0ed) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-ba991e27-95cf-4bb2-a4e2-de50ef32c21b-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382'])]"
                 priority="1151"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-ba991e27-95cf-4bb2-a4e2-de50ef32c21b) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-f257bf48-b7e7-42ea-b246-c16303cdb520-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.382']|self::hl7:code[(@code='55607006' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:text|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.220-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.220-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.227-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.227-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])]"
                 priority="1150"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-f257bf48-b7e7-42ea-b246-c16303cdb520) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-ba9416f6-3ba2-4f0d-a4c3-30037782dd54-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.202']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.382']/hl7:text/*[not(self::hl7:reference)]"
                 priority="1149"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-ba9416f6-3ba2-4f0d-a4c3-30037782dd54) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-80cc1a17-d65b-4304-84bf-0c3a9e44324f-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/*[not(self::hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203'])]"
                 priority="1148"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-80cc1a17-d65b-4304-84bf-0c3a9e44324f) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-0a738edf-6aab-43ed-9cf0-b3973e4cab1f-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.203']|self::hl7:code[(@code='29554-3' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:title|self::hl7:text|self::hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]|self::hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']]|self::hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.342']])]"
                 priority="1147"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-0a738edf-6aab-43ed-9cf0-b3973e4cab1f) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-126d28f0-585b-401d-a027-5f0317d00e3a-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/*[not(self::hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502'])]"
                 priority="1146"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-126d28f0-585b-401d-a027-5f0317d00e3a) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-b0e909c2-8304-46c4-909e-54136a755667-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.502']|self::hl7:code[(@code='406187008' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:statusCode[@code='completed']|self::hl7:component[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]|self::hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.507']]|self::hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.504']])]"
                 priority="1145"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-b0e909c2-8304-46c4-909e-54136a755667) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-acd959e4-a20d-462d-90c1-da9df2e5d5d7-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/*[not(self::hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503'])]"
                 priority="1144"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-acd959e4-a20d-462d-90c1-da9df2e5d5d7) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-a91e7c3c-45bd-4225-b70b-16e9125662c1-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.503']|self::hl7:id|self::hl7:code[(@code='DRUG' and @codeSystem='2.16.840.1.113883.5.4')]|self::hl7:text|self::hl7:statusCode|self::hl7:effectiveTime|self::hl7:doseQuantity|self::hl7:consumable)]"
                 priority="1143"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-a91e7c3c-45bd-4225-b70b-16e9125662c1) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-31de58a5-2287-4208-bea7-043f912c3bbc-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:text/*[not(self::hl7:reference)]"
                 priority="1142"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-31de58a5-2287-4208-bea7-043f912c3bbc) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-2b45b626-8253-46b3-8719-9d0516510a0f-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:consumable/*[not(self::hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]])]"
                 priority="1141"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(Medicationcoloscopy): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-2b45b626-8253-46b3-8719-9d0516510a0f) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900054-2012-04-10T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-455cae14-fed3-40d8-9800-57ca01075d8e-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:consumable/hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/*[not(self::hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]])]"
                 priority="1140"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(Medicationcoloscopy): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-455cae14-fed3-40d8-9800-57ca01075d8e) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900054-2012-04-10T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-2f835ba4-e4d3-44f1-ba0b-51e322005b02-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.503']/hl7:consumable/hl7:manufacturedProduct[hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:manufacturedLabeledDrug[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/*[not(self::hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.28-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]|self::hl7:name)]"
                 priority="1139"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(Medicationcoloscopy): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-2f835ba4-e4d3-44f1-ba0b-51e322005b02) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900054-2012-04-10T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-af42ac66-c1d8-46cf-bccf-604d2213d428-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.507']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.507'])]"
                 priority="1138"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-af42ac66-c1d8-46cf-bccf-604d2213d428) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-2c3fcda2-24f3-4662-bc8e-004c6d69d622-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.507']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.507']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.507']|self::hl7:code[(@code='72641008' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:text|self::hl7:value)]"
                 priority="1137"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-2c3fcda2-24f3-4662-bc8e-004c6d69d622) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-aa909bf6-1f31-4392-b6f5-25b366d8a58c-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.507']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.507']/hl7:text/*[not(self::hl7:reference)]"
                 priority="1136"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-aa909bf6-1f31-4392-b6f5-25b366d8a58c) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-b2b9beb4-ea73-45c5-8b85-0aa247d95ca1-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.504']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.504'])]"
                 priority="1135"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-b2b9beb4-ea73-45c5-8b85-0aa247d95ca1) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-f26adede-fad9-404b-ba0d-626ac6e52e64-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.504']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.504']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.504']|self::hl7:code[(@code='6942003' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:text|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.90-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.90-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])]"
                 priority="1134"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-f26adede-fad9-404b-ba0d-626ac6e52e64) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-31c489d7-b41c-469d-aba8-cecf92291de8-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']]/hl7:organizer[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.502']/hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.504']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.504']/hl7:text/*[not(self::hl7:reference)]"
                 priority="1133"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-31c489d7-b41c-469d-aba8-cecf92291de8) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-c3ba3817-024d-4fc3-8815-04e566a42101-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305'])]"
                 priority="1132"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-c3ba3817-024d-4fc3-8815-04e566a42101) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-5cc2177c-021c-4e86-9b0c-5d11c4ed57c5-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.305']|self::hl7:code[(@code='116223007' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:text|self::hl7:value|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.306']])]"
                 priority="1131"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-5cc2177c-021c-4e86-9b0c-5d11c4ed57c5) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-8f80f31b-fcca-4753-a681-6d78f8337262-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']/hl7:text/*[not(self::hl7:reference)]"
                 priority="1130"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-8f80f31b-fcca-4753-a681-6d78f8337262) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-4e41abac-920d-4478-9ab1-634f0bfc411d-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.306']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.306'])]"
                 priority="1129"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-4e41abac-920d-4478-9ab1-634f0bfc411d) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-136bc6c5-8fb0-44fb-af1e-865d74c194ac-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.306']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.306']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.306']|self::hl7:code[(@code='SEV' and @codeSystem='2.16.840.1.113883.5.4')]|self::hl7:text|self::hl7:statusCode|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.36-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.36-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code)])]"
                 priority="1128"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-136bc6c5-8fb0-44fb-af1e-865d74c194ac) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-cffb101a-5ba7-46ce-9aa3-6b1314127af0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.305']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.306']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.306']/hl7:text/*[not(self::hl7:reference)]"
                 priority="1127"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-cffb101a-5ba7-46ce-9aa3-6b1314127af0) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-b8213bdb-4011-4840-8918-1da84fd09f5b-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.342']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.342'])]"
                 priority="1126"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-b8213bdb-4011-4840-8918-1da84fd09f5b) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-52ab1785-27b0-42d6-8a03-cbfeeae05f27-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.342']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.342']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.342']|self::hl7:code[(@code='416393001' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:text|self::hl7:value)]"
                 priority="1125"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-52ab1785-27b0-42d6-8a03-cbfeeae05f27) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-2eaf7b35-6575-41d6-9504-77c2f810a8a5-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.203']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.342']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.342']/hl7:text/*[not(self::hl7:reference)]"
                 priority="1124"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-2eaf7b35-6575-41d6-9504-77c2f810a8a5) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-0fdcff1a-244e-42c6-a2b2-194596376812-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/*[not(self::hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204'])]"
                 priority="1123"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-0fdcff1a-244e-42c6-a2b2-194596376812) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-dc22ec11-4a86-430d-bf88-de62d395bdf4-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.204']|self::hl7:code[(@code='59776-5' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:title|self::hl7:text|self::hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.337']]|self::hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]|self::hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']])]"
                 priority="1122"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-dc22ec11-4a86-430d-bf88-de62d395bdf4) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-aa475e16-f340-4548-9102-ad5eb39b6095-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.337']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.337'])]"
                 priority="1121"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-aa475e16-f340-4548-9102-ad5eb39b6095) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-a46422e4-40da-4008-bc7f-117c7c55d0e7-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.337']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.337']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.337']|self::hl7:code[(@code='102486008' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:text|self::hl7:value)]"
                 priority="1120"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-a46422e4-40da-4008-bc7f-117c7c55d0e7) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-709ebcf4-5f94-42f8-ab03-8936ece4acab-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.337']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.337']/hl7:text/*[not(self::hl7:reference)]"
                 priority="1119"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-709ebcf4-5f94-42f8-ab03-8936ece4acab) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-cf7c2b01-c8c2-449e-83cf-3c3dde161606-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/*[not(self::hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307'])]"
                 priority="1118"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-cf7c2b01-c8c2-449e-83cf-3c3dde161606) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-ca9bf46b-e8ce-41a3-a784-8185f1974120-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.307']|self::hl7:code[(@code='225106003' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:text|self::hl7:entryRelationship[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']])]"
                 priority="1117"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-ca9bf46b-e8ce-41a3-a784-8185f1974120) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-ed5e30af-4f8a-435b-9118-47bb36aa4490-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:code[(@code='225106003' and @codeSystem='2.16.840.1.113883.6.96')]/*[not(self::hl7:qualifier)]"
                 priority="1116"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-ed5e30af-4f8a-435b-9118-47bb36aa4490) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-534b8ccf-c3a5-4122-993d-40c2a6faf7de-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:code[(@code='225106003' and @codeSystem='2.16.840.1.113883.6.96')]/hl7:qualifier/*[not(self::hl7:name[(@code='370134009' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.223-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.223-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
                 priority="1115"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-534b8ccf-c3a5-4122-993d-40c2a6faf7de) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-9600c030-86e3-40fc-9b7f-fbfddf521fa3-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:text/*[not(self::hl7:reference)]"
                 priority="1114"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-9600c030-86e3-40fc-9b7f-fbfddf521fa3) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-83708fa9-0567-4fb3-866c-4d21602480dc-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341']]/*[not(self::hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341'])]"
                 priority="1113"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-83708fa9-0567-4fb3-866c-4d21602480dc) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-62054a84-d7a7-4459-a53b-6df358fcc664-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.341']|self::hl7:id|self::hl7:consumable)]"
                 priority="1112"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-62054a84-d7a7-4459-a53b-6df358fcc664) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-3fe9d6bd-837c-4f31-a532-1e29b12f5af7-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341']/hl7:consumable/*[not(self::hl7:manufacturedProduct[hl7:manufacturedMaterial[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]])]"
                 priority="1111"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(Medicationforpreparation): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-3fe9d6bd-837c-4f31-a532-1e29b12f5af7) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900088-2012-04-10T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-e80ee6a5-5230-4d1c-a644-538ab20a981e-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341']/hl7:consumable/hl7:manufacturedProduct[hl7:manufacturedMaterial[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/*[not(self::hl7:manufacturedMaterial[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]])]"
                 priority="1110"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(Medicationforpreparation): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-e80ee6a5-5230-4d1c-a644-538ab20a981e) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900088-2012-04-10T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-709a16cf-30e8-41a1-9b8d-a16f54d1200d-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341']]/hl7:substanceAdministration[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.341']/hl7:consumable/hl7:manufacturedProduct[hl7:manufacturedMaterial[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]]/hl7:manufacturedMaterial[hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]]/*[not(self::hl7:code[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.75-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
                 priority="1109"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(Medicationforpreparation): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-709a16cf-30e8-41a1-9b8d-a16f54d1200d) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.900088-2012-04-10T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-6e8dfc9d-b273-44a1-9402-5fe96322c9c7-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310'])]"
                 priority="1108"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-6e8dfc9d-b273-44a1-9402-5fe96322c9c7) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-48673441-e759-44a6-b780-dc31b2ca61d0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.310']|self::hl7:code[(@code='X_BBPSSS' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:text|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.103-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.103-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.311']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.312']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.313']])]"
                 priority="1107"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-48673441-e759-44a6-b780-dc31b2ca61d0) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-2ac89e1b-c51b-41fb-a9ef-62bd0e89ba31-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']/hl7:text/*[not(self::hl7:reference)]"
                 priority="1106"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-2ac89e1b-c51b-41fb-a9ef-62bd0e89ba31) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-4c817b17-a2eb-4ae8-bbcd-3be3a9889dc0-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.311']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.311'])]"
                 priority="1105"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-4c817b17-a2eb-4ae8-bbcd-3be3a9889dc0) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-d67c5935-ec5b-40e9-802e-1a733d83e401-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.311']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.311']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.311']|self::hl7:code[(@code='X_BBPSCR' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.102-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.102-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
                 priority="1104"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-d67c5935-ec5b-40e9-802e-1a733d83e401) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-5beca961-dec1-484a-a8de-7b1142657637-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.312']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.312'])]"
                 priority="1103"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-5beca961-dec1-484a-a8de-7b1142657637) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-9caa15f4-9541-4938-9f4e-9471c9361db2-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.312']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.312']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.312']|self::hl7:code[(@code='X_BBPSCT' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.102-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.102-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
                 priority="1102"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-9caa15f4-9541-4938-9f4e-9471c9361db2) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-d7373fe5-7323-4a75-85df-6148673b76ec-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.313']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.313'])]"
                 priority="1101"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-d7373fe5-7323-4a75-85df-6148673b76ec) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-5693a02d-d2da-4ec7-8ee8-90e3f7996055-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.307']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.310']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.313']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.313']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.313']|self::hl7:code[(@code='X_BBPSCL' and @codeSystem='2.16.840.1.113883.6.1')]|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.102-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.102-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
                 priority="1100"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-5693a02d-d2da-4ec7-8ee8-90e3f7996055) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-50de2728-4a3f-45d4-88d2-3fc5ac71b2f9-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/*[not(self::hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320'])]"
                 priority="1099"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-50de2728-4a3f-45d4-88d2-3fc5ac71b2f9) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-96a4d989-4552-4544-9610-eae9719f56f6-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.320']|self::hl7:code[(@code='444783004' and @codeSystem='2.16.840.1.113883.6.96')]|self::hl7:text|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.322']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.329']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.343']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.330']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.344']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.323']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.331']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.328']]|self::hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.334']])]"
                 priority="1098"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-96a4d989-4552-4544-9610-eae9719f56f6) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-91070011-7325-49a1-b976-9973b236d822-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:text/*[not(self::hl7:reference)]"
                 priority="1097"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-91070011-7325-49a1-b976-9973b236d822) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-619a4d99-9e91-4b72-acd9-12cc322f9497-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.322']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.322'])]"
                 priority="1096"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-619a4d99-9e91-4b72-acd9-12cc322f9497) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-7fb36707-9d8c-45e7-a89d-6311fd14a1b7-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.322']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.322']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.322']|self::hl7:code[(@code='C140022' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]|self::hl7:text|self::hl7:value)]"
                 priority="1095"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-7fb36707-9d8c-45e7-a89d-6311fd14a1b7) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-6fe6089e-5b0f-4cd7-a4e6-bc7bbb786da8-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.322']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.322']/hl7:text/*[not(self::hl7:reference)]"
                 priority="1094"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-6fe6089e-5b0f-4cd7-a4e6-bc7bbb786da8) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-e92934ae-5d7e-4290-90c6-b3da5aa51e0a-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.329']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.329'])]"
                 priority="1093"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-e92934ae-5d7e-4290-90c6-b3da5aa51e0a) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-fa254e99-98ed-49b4-a743-9d52df140611-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.329']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.329']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.329']|self::hl7:code[(@code='C140040' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]|self::hl7:text|self::hl7:value)]"
                 priority="1092"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-fa254e99-98ed-49b4-a743-9d52df140611) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-655e8db3-d015-4198-84f0-9ec2526d2e1a-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.329']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.329']/hl7:text/*[not(self::hl7:reference)]"
                 priority="1091"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-655e8db3-d015-4198-84f0-9ec2526d2e1a) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-6e6c9fea-8c19-4fb7-bd14-735698615a23-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.343']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.343'])]"
                 priority="1090"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-6e6c9fea-8c19-4fb7-bd14-735698615a23) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-69842f88-06e1-4ae4-9208-2d6194eb18ae-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.343']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.343']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.343']|self::hl7:code[(@code='C140041' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]|self::hl7:text|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.37-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.37-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
                 priority="1089"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-69842f88-06e1-4ae4-9208-2d6194eb18ae) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-4f724946-890f-4a89-9a02-bd0093043000-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.343']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.343']/hl7:text/*[not(self::hl7:reference)]"
                 priority="1088"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-4f724946-890f-4a89-9a02-bd0093043000) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-4648bfbb-e5fa-45ec-9f00-5141a4f603aa-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.330']]/*[not(self::hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.330'])]"
                 priority="1087"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-4648bfbb-e5fa-45ec-9f00-5141a4f603aa) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-2a7b2b62-95bf-496d-9dd3-7c690da0e521-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.330']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.330']/*[not(self::hl7:templateId[@root='2.16.840.1.113883.2.4.3.36.10.330']|self::hl7:code[(@code='C140060' and @codeSystem='2.16.840.1.113883.2.4.3.36.77.5.200')]|self::hl7:text|self::hl7:value[concat(@code,@codeSystem)=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.108-DYNAMIC.xml')/*/valueSet/conceptList/concept/concat(@code,@codeSystem) or (@nullFlavor=doc('include/voc-2.16.840.1.113883.2.4.3.36.77.11.108-DYNAMIC.xml')/*/valueSet/conceptList/exception/@code) or @nullFlavor])]"
                 priority="1086"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-2a7b2b62-95bf-496d-9dd3-7c690da0e521) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE tmp-r-95c0d88a-21b9-4f80-a47e-0c394f01db92-->
   <xsl:template match="/hl7:ClinicalDocument[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.11' and hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.1']/hl7:component/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']]/hl7:section[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.204']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']]/hl7:act[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.320']/hl7:entryRelationship[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.330']]/hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.3.36.10.330']/hl7:text/*[not(self::hl7:reference)]"
                 priority="1085"
                 mode="M7">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>(nspbcmdl2014): '<xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>' is gedefinieerd als gesloten en dit element '<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>' is niet toegestaan, of niet toegestaan met deze inhoud. Mogelijk betreft dit het templateId, code, of id. (rule-reference: tmp-r-95c0d88a-21b9-4f80-a47e-0c394f01db92) (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://decor.nictiz.nl/rivmsp/rivmsp-html-20150616T110059/tmp-2.16.840.1.113883.2.4.3.36.10.11-2014-01-06T000000.html)</xsl:message>
         </xsl:othe