<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.3.6.1.4.1.19376.1.3.1.3
Name: Specimen Received
Description: Specimen Received, when present, SHALL be recorded under the Specimen Act in an entryRelationship under the Laboratory Data Processing Entry. The table below shows how the information for this element is coded, and further constraints are provided in the following sections.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.3.6.1.4.1.19376.1.3.1.3-2008-08-08T000000">
   <title>Specimen Received</title>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.3
Context: *[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3']]]
Item: (Specimen Received)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3']]]"
         id="d45e3-false-d471e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-1.3.6.1.4.1.19376.1.3.1.3-2008-08-08T000000.html"
              test="count(hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3']]) &gt;= 1">(Specimen Received): element hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-1.3.6.1.4.1.19376.1.3.1.3-2008-08-08T000000.html"
              test="count(hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3']]) &lt;= 1">(Specimen Received): element hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.3
Context: *[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3']]]/hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3']]
Item: (Specimen Received)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3']]]/hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3']]"
         id="d45e30-false-d489e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-1.3.6.1.4.1.19376.1.3.1.3-2008-08-08T000000.html"
              test="string(@classCode) = ('ACT')">(Specimen Received): de waarde van classCode MOET 'ACT' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-1.3.6.1.4.1.19376.1.3.1.3-2008-08-08T000000.html"
              test="string(@moodCode) = ('EVN')">(Specimen Received): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-1.3.6.1.4.1.19376.1.3.1.3-2008-08-08T000000.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3']) &gt;= 1">(Specimen Received): element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-1.3.6.1.4.1.19376.1.3.1.3-2008-08-08T000000.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3']) &lt;= 1">(Specimen Received): element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-1.3.6.1.4.1.19376.1.3.1.3-2008-08-08T000000.html"
              test="count(hl7:code[(@code = 'SPRECEIVE' and @codeSystem = '1.3.5.1.4.1.19376.1.5.3.2') or @nullFlavor]) &gt;= 1">(Specimen Received): element hl7:code[(@code = 'SPRECEIVE' and @codeSystem = '1.3.5.1.4.1.19376.1.5.3.2') or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-1.3.6.1.4.1.19376.1.3.1.3-2008-08-08T000000.html"
              test="count(hl7:code[(@code = 'SPRECEIVE' and @codeSystem = '1.3.5.1.4.1.19376.1.5.3.2') or @nullFlavor]) &lt;= 1">(Specimen Received): element hl7:code[(@code = 'SPRECEIVE' and @codeSystem = '1.3.5.1.4.1.19376.1.5.3.2') or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-1.3.6.1.4.1.19376.1.3.1.3-2008-08-08T000000.html"
              test="count(hl7:effectiveTime) &gt;= 1">(Specimen Received): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-1.3.6.1.4.1.19376.1.3.1.3-2008-08-08T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Specimen Received): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.3
Context: *[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3']]]/hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3']
Item: (Specimen Received)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3']]]/hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3']"
         id="d45e36-false-d532e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-1.3.6.1.4.1.19376.1.3.1.3-2008-08-08T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Specimen Received): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-1.3.6.1.4.1.19376.1.3.1.3-2008-08-08T000000.html"
              test="string(@root) = ('1.3.6.1.4.1.19376.1.3.1.3')">(Specimen Received): de waarde van root MOET '1.3.6.1.4.1.19376.1.3.1.3' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.3
Context: *[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3']]]/hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3']]/hl7:code[(@code = 'SPRECEIVE' and @codeSystem = '1.3.5.1.4.1.19376.1.5.3.2') or @nullFlavor]
Item: (Specimen Received)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3']]]/hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3']]/hl7:code[(@code = 'SPRECEIVE' and @codeSystem = '1.3.5.1.4.1.19376.1.5.3.2') or @nullFlavor]"
         id="d45e41-false-d549e0">
      <extends rule="CD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-1.3.6.1.4.1.19376.1.3.1.3-2008-08-08T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(Specimen Received): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CD" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-1.3.6.1.4.1.19376.1.3.1.3-2008-08-08T000000.html"
              test="@nullFlavor or (@code='SPRECEIVE' and @codeSystem='1.3.5.1.4.1.19376.1.5.3.2' and @codeSystemName='IHEActCode')">(Specimen Received): de elementwaarde MOET een zijn van 'code 'SPRECEIVE' codeSystem '1.3.5.1.4.1.19376.1.5.3.2' codeSystemName='IHEActCode''.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.3
Context: *[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3']]]/hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3']]/hl7:effectiveTime
Item: (Specimen Received)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3']]]/hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3']]/hl7:effectiveTime"
         id="d45e49-false-d565e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-1.3.6.1.4.1.19376.1.3.1.3-2008-08-08T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(Specimen Received): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
</pattern>
