<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9233
Name: MP CDA Medicatieafspraak inhoud
Description: Medicatieafspraak met eventueel op-/afbouw schema.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547">
   <title>MP CDA Medicatieafspraak inhoud</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9233
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]
Item: (MP CDA Medicatieafspraak inhoud)
-->

   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]"
         id="d45e3998-false-d6354e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="count(cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']) &gt;= 1">(MP CDA Medicatieafspraak inhoud): element cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="count(cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']) &lt;= 1">(MP CDA Medicatieafspraak inhoud): element cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="count(cda:id) &gt;= 1">(MP CDA Medicatieafspraak inhoud): element cda:id is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="count(cda:id) &lt;= 1">(MP CDA Medicatieafspraak inhoud): element cda:id komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="count(cda:code[(@code = '16076005' and @codeSystem = '2.16.840.1.113883.6.96')]) &gt;= 1">(MP CDA Medicatieafspraak inhoud): element cda:code[(@code = '16076005' and @codeSystem = '2.16.840.1.113883.6.96')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="count(cda:code[(@code = '16076005' and @codeSystem = '2.16.840.1.113883.6.96')]) &lt;= 1">(MP CDA Medicatieafspraak inhoud): element cda:code[(@code = '16076005' and @codeSystem = '2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="count(cda:text) &gt;= 1">(MP CDA Medicatieafspraak inhoud): element cda:text is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="count(cda:text) &lt;= 1">(MP CDA Medicatieafspraak inhoud): element cda:text komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="count(cda:statusCode[@code='nullified']) &lt;= 1">(MP CDA Medicatieafspraak inhoud): element cda:statusCode[@code='nullified'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="count(cda:effectiveTime[(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') ]) &lt;= 1">(MP CDA Medicatieafspraak inhoud): element cda:effectiveTime[(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') ] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="count(cda:routeCode) &gt;= 1">(MP CDA Medicatieafspraak inhoud): element cda:routeCode is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="count(cda:routeCode) &lt;= 1">(MP CDA Medicatieafspraak inhoud): element cda:routeCode komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="count(cda:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]) &gt;= 1">(MP CDA Medicatieafspraak inhoud): element cda:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="count(cda:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]) &lt;= 1">(MP CDA Medicatieafspraak inhoud): element cda:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="count(cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]) &gt;= 1">(MP CDA Medicatieafspraak inhoud): element cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="count(cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]) &lt;= 1">(MP CDA Medicatieafspraak inhoud): element cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="count(cda:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9067']]]) &lt;= 1">(MP CDA Medicatieafspraak inhoud): element cda:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9067']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="count(cda:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9270']]]) &lt;= 1">(MP CDA Medicatieafspraak inhoud): element cda:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9270']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="count(cda:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9160']]]) &lt;= 1">(MP CDA Medicatieafspraak inhoud): element cda:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9160']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="count(cda:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.7.10.30']]]) &lt;= 1">(MP CDA Medicatieafspraak inhoud): element cda:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.7.10.30']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="count(cda:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.7.10.28']]]) &lt;= 1">(MP CDA Medicatieafspraak inhoud): element cda:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.7.10.28']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="count(cda:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9069']]]) &lt;= 1">(MP CDA Medicatieafspraak inhoud): element cda:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9069']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="count(cda:entryRelationship[*/cda:templateId[@root= ('2.16.840.1.113883.2.4.3.11.60.20.77.10.9086', '2.16.840.1.113883.2.4.3.11.60.20.77.10.9101', '2.16.840.1.113883.2.4.3.11.60.20.77.10.9176')]]) &lt;= 1">(MP CDA Medicatieafspraak inhoud): element cda:entryRelationship[*/cda:templateId[@root= ('2.16.840.1.113883.2.4.3.11.60.20.77.10.9086', '2.16.840.1.113883.2.4.3.11.60.20.77.10.9101', '2.16.840.1.113883.2.4.3.11.60.20.77.10.9176')]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="count(cda:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9200']]]) &lt;= 1">(MP CDA Medicatieafspraak inhoud): element cda:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9200']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="count(cda:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9084']]]) &gt;= 1">(MP CDA Medicatieafspraak inhoud): element cda:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9084']]] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="count(cda:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9084']]]) &lt;= 1">(MP CDA Medicatieafspraak inhoud): element cda:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9084']]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9233
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']
Item: (MP CDA Medicatieafspraak inhoud)
-->

   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']"
         id="d45e4055-false-d6756e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(MP CDA Medicatieafspraak inhoud): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.20.77.10.9233')">(MP CDA Medicatieafspraak inhoud): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9184
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:id
Item: (MP CDA Medicatieafspraak onderdelen 1)
-->

   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:id"
         id="d6757e47-false-d6771e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(MP CDA Medicatieafspraak onderdelen 1): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9184
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:code[(@code = '16076005' and @codeSystem = '2.16.840.1.113883.6.96')]
Item: (MP CDA Medicatieafspraak onderdelen 1)
-->

   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:code[(@code = '16076005' and @codeSystem = '2.16.840.1.113883.6.96')]"
         id="d6757e54-false-d6782e0">
      <extends rule="CD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(MP CDA Medicatieafspraak onderdelen 1): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CD" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="@nullFlavor or (@code='16076005' and @codeSystem='2.16.840.1.113883.6.96')">(MP CDA Medicatieafspraak onderdelen 1): de elementwaarde MOET een zijn van 'code '16076005' codeSystem '2.16.840.1.113883.6.96''.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(MP CDA Medicatieafspraak onderdelen 1): attribuut @displayName MOET datatype 'st' hebben  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(MP CDA Medicatieafspraak onderdelen 1): attribuut @codeSystemName MOET datatype 'st' hebben  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9184
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:text
Item: (MP CDA Medicatieafspraak onderdelen 1)
-->

   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:text"
         id="d6757e70-false-d6804e0">
      <extends rule="ED"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(MP CDA Medicatieafspraak onderdelen 1): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ED" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="string(@mediaType) = ('text/plain') or not(@mediaType)">(MP CDA Medicatieafspraak onderdelen 1): de waarde van mediaType MOET 'text/plain' zijn. Gevonden: "<value-of select="@mediaType"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="not(@mediaType) or string-length(@mediaType)&gt;0">(MP CDA Medicatieafspraak onderdelen 1): attribuut @mediaType MOET datatype 'st' hebben  - '<value-of select="@mediaType"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9184
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:statusCode[@code='nullified']
Item: (MP CDA Medicatieafspraak onderdelen 1)
-->

   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:statusCode[@code='nullified']"
         id="d6757e80-false-d6819e0">
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(MP CDA Medicatieafspraak onderdelen 1): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="@nullFlavor or (@code='nullified')">(MP CDA Medicatieafspraak onderdelen 1): de elementwaarde MOET een zijn van 'code 'nullified''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9184
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:effectiveTime[(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') ]
Item: (MP CDA Medicatieafspraak onderdelen 1)
-->

   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:effectiveTime[(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') ]"
         id="d6757e92-false-d6833e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(MP CDA Medicatieafspraak onderdelen 1): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="count(hl7:low) &lt;= 1">(MP CDA Medicatieafspraak onderdelen 1): element hl7:low komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="count(hl7:width) &lt;= 1">(MP CDA Medicatieafspraak onderdelen 1): element hl7:width komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="count(hl7:high) &lt;= 1">(MP CDA Medicatieafspraak onderdelen 1): element hl7:high komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9019
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:effectiveTime[(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') ]/hl7:low
Item: (Usable Period)
-->

   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:effectiveTime[(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') ]/hl7:low"
         id="d6836e49-false-d6867e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9019-2016-07-01T155004.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(Usable Period): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9019-2016-07-01T155004.html"
              test="not(*)">(Usable Period): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9019
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:effectiveTime[(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') ]/hl7:width
Item: (Usable Period)
-->

   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:effectiveTime[(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') ]/hl7:width"
         id="d6836e64-false-d6880e0">
      <extends rule="PQ"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9019-2016-07-01T155004.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(Usable Period): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PQ" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9019-2016-07-01T155004.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Usable Period): @value is geen geldig PQ getal <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9019-2016-07-01T155004.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(Usable Period): value/@unit (PQ) MOET een geldige UCUM-eenheid zijn (<value-of select="$UCUMtest"/>).</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9019-2016-07-01T155004.html"
              test="@value">(Usable Period): attribute @value MOET aanwezig zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9019-2016-07-01T155004.html"
              test="not(@value) or matches(string(@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Usable Period): attribuut @value is geen geldig real getal <value-of select="@value"/>
      </assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9019-2016-07-01T155004.html"
              test="@unit">(Usable Period): attribute @unit MOET aanwezig zijn.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@unit),'\s'))"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9019-2016-07-01T155004.html"
              test="not(@unit) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.2.4.3.11.60.20.77.11.25-2016-07-01T160454.xml')/*/valueSet/conceptList/concept/@code))])">(Usable Period): de waarde van unit MOET worden gekozen uit waardelijst '2.16.840.1.113883.2.4.3.11.60.20.77.11.25' Time a tot h PQ (UCUM) - without Month (2016-07-01T16:04:54).</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9019-2016-07-01T155004.html"
              test="@value&gt;0">(Usable Period): @value moet een getal bevatten dat groter is dan nul.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9019
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:effectiveTime[(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') ]/hl7:high
Item: (Usable Period)
-->

   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:effectiveTime[(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') ]/hl7:high"
         id="d6836e91-false-d6913e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9019-2016-07-01T155004.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(Usable Period): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9019-2016-07-01T155004.html"
              test="not(*)">(Usable Period): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9019-2016-07-01T155004.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(Usable Period): attribuut @value MOET datatype 'ts' hebben  - '<value-of select="@value"/>'</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9019-2016-07-01T155004.html"
              test="not(@nullFlavor) or (string-length(@nullFlavor) &gt; 0 and not(matches(@nullFlavor,'\s')))">(Usable Period): attribuut @nullFlavor MOET datatype 'cs' hebben  - '<value-of select="@nullFlavor"/>'</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9019-2016-07-01T155004.html"
              test="not(../hl7:width)">(Usable Period): Einddatum/tijd mag niet voorkomen in combinatie met width.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9019-2016-07-01T155004.html"
              test="@nullFlavor or string-length(@value)&gt;10">(Usable Period): Einddatum/tijd minimaal tot op de minuut nauwkeurig meegeven (om verwarring tussen 'tot' en 'tot en met' te voorkomen).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9184
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:routeCode
Item: (MP CDA Medicatieafspraak onderdelen 1)
-->

   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:routeCode"
         id="d6757e106-false-d6933e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(MP CDA Medicatieafspraak onderdelen 1): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.2.4.4.9') or not(@codeSystem)">(MP CDA Medicatieafspraak onderdelen 1): de waarde van codeSystem MOET '2.16.840.1.113883.2.4.4.9' zijn. Gevonden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="not(@nullFlavor) or (string-length(@nullFlavor) &gt; 0 and not(matches(@nullFlavor,'\s')))">(MP CDA Medicatieafspraak onderdelen 1): attribuut @nullFlavor MOET datatype 'cs' hebben  - '<value-of select="@nullFlavor"/>'</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="not(starts-with(@code, '0'))">(MP CDA Medicatieafspraak onderdelen 1): Géén voorloopnullen opnemen bij code voor toedieningsweg.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9184-2017-08-18T092503.html"
              test="@nullFlavor or @displayName">(MP CDA Medicatieafspraak onderdelen 1): Het is verplicht de displayName mee te geven als er een waarde is.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9233
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9254']]]
Item: (MP CDA Medicatieafspraak inhoud)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9233
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]
Item: (MP CDA Medicatieafspraak inhoud)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]">
      <extends rule="d7002e0-false-d7006e0"/>
      <assert role="warning"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="count(hl7:assignedAuthor/hl7:representedOrganization/hl7:addr[@use='WP']) ge 1">(MP CDA Medicatieafspraak inhoud): Er is minimaal één werkadres van de auteur (hl7:assignedAuthor/hl7:representedOrganization/hl7:addr[@use='WP']) verwacht bij een medicatieafspraak.</assert>
      <assert role="warning"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="not(hl7:time/@value) or matches(string(hl7:time/@value), '^[0-9]{14,14}')">(MP CDA Medicatieafspraak inhoud): Bij afspraakdatum is het verplicht om de tijd met een minimale precisie van seconden mee te geven</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9066
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]
Item: (MP CDA Author Participation)
-->
   <rule fpi="RULC-1" id="d7002e0-false-d7006e0" abstract="true">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2018-12-05T174210.html"
              test="count(cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9066']) &lt;= 1">(MP CDA Author Participation): element cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9066'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2018-12-05T174210.html"
              test="count(cda:time) &gt;= 1">(MP CDA Author Participation): element cda:time is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2018-12-05T174210.html"
              test="count(cda:time) &lt;= 1">(MP CDA Author Participation): element cda:time komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2018-12-05T174210.html"
              test="count(cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]) &gt;= 1">(MP CDA Author Participation): element cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2018-12-05T174210.html"
              test="count(cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]) &lt;= 1">(MP CDA Author Participation): element cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9066
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9066']
Item: (MP CDA Author Participation)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9066']">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2018-12-05T174210.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(MP CDA Author Participation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2018-12-05T174210.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.20.77.10.9066')">(MP CDA Author Participation): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.20.77.10.9066' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9066
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:time
Item: (MP CDA Author Participation)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:time">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2018-12-05T174210.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(MP CDA Author Participation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2018-12-05T174210.html"
              test="not(*)">(MP CDA Author Participation): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2018-12-05T174210.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(MP CDA Author Participation): attribuut @value MOET datatype 'ts' hebben  - '<value-of select="@value"/>'</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2018-12-05T174210.html"
              test="not(@nullFlavor) or (string-length(@nullFlavor) &gt; 0 and not(matches(@nullFlavor,'\s')))">(MP CDA Author Participation): attribuut @nullFlavor MOET datatype 'cs' hebben  - '<value-of select="@nullFlavor"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9066
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]
Item: (MP CDA Author Participation)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2018-12-05T174210.html"
              test="count(cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9113']) &lt;= 1">(MP CDA Author Participation): element cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9113'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2018-12-05T174210.html"
              test="count(cda:id[@root='2.16.528.1.1007.3.1'] | cda:id[@root='2.16.840.1.113883.2.4.6.1'] | cda:id[@root='2.16.528.1.1007.5.1'] | cda:id[not(@root='2.16.528.1.1007.3.1' or @root='2.16.840.1.113883.2.4.6.1' or @root='2.16.528.1.1007.5.1')]) &gt;= 1">(MP CDA Author Participation): keuze (cda:id[@root='2.16.528.1.1007.3.1']  of  cda:id[@root='2.16.840.1.113883.2.4.6.1']  of  cda:id[@root='2.16.528.1.1007.5.1']  of  cda:id[not(@root='2.16.528.1.1007.3.1' or @root='2.16.840.1.113883.2.4.6.1' or @root='2.16.528.1.1007.5.1')]) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2018-12-05T174210.html"
              test="count(cda:id[@root='2.16.528.1.1007.3.1']) &lt;= 1">(MP CDA Author Participation): element cda:id[@root='2.16.528.1.1007.3.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2018-12-05T174210.html"
              test="count(cda:id[@root='2.16.840.1.113883.2.4.6.1']) &lt;= 1">(MP CDA Author Participation): element cda:id[@root='2.16.840.1.113883.2.4.6.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2018-12-05T174210.html"
              test="count(cda:id[@root='2.16.528.1.1007.5.1']) &lt;= 1">(MP CDA Author Participation): element cda:id[@root='2.16.528.1.1007.5.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2018-12-05T174210.html"
              test="count(cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]) &gt;= 1">(MP CDA Author Participation): element cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2018-12-05T174210.html"
              test="count(cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]) &lt;= 1">(MP CDA Author Participation): element cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2018-12-05T174210.html"
              test="count(cda:assignedPerson) &gt;= 1">(MP CDA Author Participation): element cda:assignedPerson is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2018-12-05T174210.html"
              test="count(cda:assignedPerson) &lt;= 1">(MP CDA Author Participation): element cda:assignedPerson komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2018-12-05T174210.html"
              test="count(hl7:representedOrganization) &lt;= 1">(MP CDA Author Participation): element hl7:representedOrganization komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9066-2018-12-05T174210.html"
              test="(cda:id[@nullFlavor] and not(cda:id[@root])) or (cda:id[@root] and not(cda:id[@nullFlavor]))">(MP CDA Author Participation): Neem ofwel minimaal één bekende identificatie, ofwel een id element met nullFlavor op [maar niet beide].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9113
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9113']
Item: (MP CDA Zorgverlener)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9113']">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9113-2018-12-05T174044.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(MP CDA Zorgverlener): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9113-2018-12-05T174044.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.20.77.10.9113')">(MP CDA Zorgverlener): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.20.77.10.9113' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9111
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]
Item: (MP CDA Zorgverlener identificaties)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9111
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:id[@root='2.16.528.1.1007.3.1']
Item: (MP CDA Zorgverlener identificaties)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:id[@root='2.16.528.1.1007.3.1']">
      <extends rule="II.NL.UZI"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9111-2016-07-07T212337.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(MP CDA Zorgverlener identificaties): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9111-2016-07-07T212337.html"
              test="string(@root) = ('2.16.528.1.1007.3.1')">(MP CDA Zorgverlener identificaties): de waarde van root MOET '2.16.528.1.1007.3.1' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9111
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:id[@root='2.16.840.1.113883.2.4.6.1']
Item: (MP CDA Zorgverlener identificaties)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:id[@root='2.16.840.1.113883.2.4.6.1']">
      <extends rule="II.NL.AGB"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9111-2016-07-07T212337.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(MP CDA Zorgverlener identificaties): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9111-2016-07-07T212337.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.6.1')">(MP CDA Zorgverlener identificaties): de waarde van root MOET '2.16.840.1.113883.2.4.6.1' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9111
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:id[@root='2.16.528.1.1007.5.1']
Item: (MP CDA Zorgverlener identificaties)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:id[@root='2.16.528.1.1007.5.1']">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9111-2016-07-07T212337.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(MP CDA Zorgverlener identificaties): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9111-2016-07-07T212337.html"
              test="string(@root) = ('2.16.528.1.1007.5.1')">(MP CDA Zorgverlener identificaties): de waarde van root MOET '2.16.528.1.1007.5.1' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9111
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:id[not(@root='2.16.528.1.1007.3.1' or @root='2.16.840.1.113883.2.4.6.1' or @root='2.16.528.1.1007.5.1')]
Item: (MP CDA Zorgverlener identificaties)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:id[not(@root='2.16.528.1.1007.3.1' or @root='2.16.840.1.113883.2.4.6.1' or @root='2.16.528.1.1007.5.1')]">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9111-2016-07-07T212337.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(MP CDA Zorgverlener identificaties): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9113
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]
Item: (MP CDA Zorgverlener)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9113-2018-12-05T174044.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(MP CDA Zorgverlener): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9113-2018-12-05T174044.html"
              test="@nullFlavor or (@codeSystem='2.16.840.1.113883.2.4.15.111') or (@codeSystem='2.16.840.1.113883.2.4.6.7')">(MP CDA Zorgverlener): de elementwaarde MOET een zijn van 'codeSystem '2.16.840.1.113883.2.4.15.111' of codeSystem '2.16.840.1.113883.2.4.6.7''.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9113-2018-12-05T174044.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(MP CDA Zorgverlener): attribuut @code MOET datatype 'cs' hebben  - '<value-of select="@code"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9113
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/cda:assignedPerson
Item: (MP CDA Zorgverlener)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.0.5
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization
Item: (uitvoerende zorgaanbieder)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(uitvoerende zorgaanbieder): de waarde van classCode MOET 'ORG' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="count(hl7:id[@root = '2.16.528.1.1007.3.3']) &lt;= 1">(uitvoerende zorgaanbieder): element hl7:id[@root = '2.16.528.1.1007.3.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="count(hl7:id[@root = '2.16.840.1.113883.2.4.6.1']) &lt;= 1">(uitvoerende zorgaanbieder): element hl7:id[@root = '2.16.840.1.113883.2.4.6.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="count(hl7:id[@root = '2.16.840.1.113883.2.4.6.8']) &lt;= 1">(uitvoerende zorgaanbieder): element hl7:id[@root = '2.16.840.1.113883.2.4.6.8'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="count(hl7:name) &lt;= 1">(uitvoerende zorgaanbieder): element hl7:name komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="count(hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-2017-12-31T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(uitvoerende zorgaanbieder): element hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-2017-12-31T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(uitvoerende zorgaanbieder): element hl7:asOrganizationPartOf komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.7.10.53
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization
Item: (zorgaanbiederidentificatienummer)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.7.10.53
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:id[@root = '2.16.528.1.1007.3.3']
Item: (zorgaanbiederidentificatienummer)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:id[@root = '2.16.528.1.1007.3.3']">
      <extends rule="II.NL.URA"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.53-2019-04-07T143608.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(zorgaanbiederidentificatienummer): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.53-2019-04-07T143608.html"
              test="string(@root) = ('2.16.528.1.1007.3.3')">(zorgaanbiederidentificatienummer): de waarde van root MOET '2.16.528.1.1007.3.3' zijn. Gevonden: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.53-2019-04-07T143608.html"
              test="@extension">(zorgaanbiederidentificatienummer): attribute @extension MOET aanwezig zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.53-2019-04-07T143608.html"
              test="not(@extension) or string-length(@extension)&gt;0">(zorgaanbiederidentificatienummer): attribuut @extension MOET datatype 'st' hebben  - '<value-of select="@extension"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.7.10.53
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:id[@root = '2.16.840.1.113883.2.4.6.1']
Item: (zorgaanbiederidentificatienummer)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:id[@root = '2.16.840.1.113883.2.4.6.1']">
      <extends rule="II.NL.AGB"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.53-2019-04-07T143608.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(zorgaanbiederidentificatienummer): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.53-2019-04-07T143608.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.6.1')">(zorgaanbiederidentificatienummer): de waarde van root MOET '2.16.840.1.113883.2.4.6.1' zijn. Gevonden: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.53-2019-04-07T143608.html"
              test="@extension">(zorgaanbiederidentificatienummer): attribute @extension MOET aanwezig zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.53-2019-04-07T143608.html"
              test="not(@extension) or string-length(@extension)&gt;0">(zorgaanbiederidentificatienummer): attribuut @extension MOET datatype 'st' hebben  - '<value-of select="@extension"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.7.10.53
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:id[@root = '2.16.840.1.113883.2.4.6.8']
Item: (zorgaanbiederidentificatienummer)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:id[@root = '2.16.840.1.113883.2.4.6.8']">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.53-2019-04-07T143608.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(zorgaanbiederidentificatienummer): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.53-2019-04-07T143608.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.6.8')">(zorgaanbiederidentificatienummer): de waarde van root MOET '2.16.840.1.113883.2.4.6.8' zijn. Gevonden: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.53-2019-04-07T143608.html"
              test="@extension">(zorgaanbiederidentificatienummer): attribute @extension MOET aanwezig zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.53-2019-04-07T143608.html"
              test="not(@extension) or string-length(@extension)&gt;0">(zorgaanbiederidentificatienummer): attribuut @extension MOET datatype 'st' hebben  - '<value-of select="@extension"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.7.10.53
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:id[not(@root = ('2.16.528.1.1007.3.3', '2.16.840.1.113883.2.4.6.1', '2.16.840.1.113883.2.4.6.8'))]
Item: (zorgaanbiederidentificatienummer)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:id[not(@root = ('2.16.528.1.1007.3.3', '2.16.840.1.113883.2.4.6.1', '2.16.840.1.113883.2.4.6.8'))]">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.53-2019-04-07T143608.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(zorgaanbiederidentificatienummer): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.0.5
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:name
Item: (uitvoerende zorgaanbieder)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:name">
      <extends rule="ON"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ON')">(uitvoerende zorgaanbieder): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.0.5
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:telecom[starts-with(@value,'tel:')]
Item: (uitvoerende zorgaanbieder)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:telecom[starts-with(@value,'tel:')]">
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="not(@use) or empty($theAttValue[not(. = (('MC','PG'), doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.20.6.2-2017-12-31T000000.xml')/*/valueSet/conceptList/concept/@code))])">(uitvoerende zorgaanbieder): de waarde van use MOET worden gekozen uit code MC of code PG of waardelijst '2.16.840.1.113883.2.4.3.11.60.40.2.20.6.2' NummerSoortCodelijst (2017-12-31T00:00:00).</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="@value">(uitvoerende zorgaanbieder): attribute @value MOET aanwezig zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="not(@value) or string(@value castable as xs:anyURI)">(uitvoerende zorgaanbieder): attribuut @value MOET datatype 'url' hebben  - '<value-of select="@value"/>'</assert>
      <extends rule="TEL.NL.EXTENDED"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(uitvoerende zorgaanbieder): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.0.5
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:telecom[starts-with(@value,'mailto:')]
Item: (uitvoerende zorgaanbieder)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:telecom[starts-with(@value,'mailto:')]">
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.20.6.3-2017-12-31T000000.xml')/*/valueSet/conceptList/concept/@code))])">(uitvoerende zorgaanbieder): de waarde van use MOET worden gekozen uit waardelijst '2.16.840.1.113883.2.4.3.11.60.40.2.20.6.3' EmailSoortCodelijst (2017-12-31T00:00:00).</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="@value">(uitvoerende zorgaanbieder): attribute @value MOET aanwezig zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="not(@value) or string(@value castable as xs:anyURI)">(uitvoerende zorgaanbieder): attribuut @value MOET datatype 'url' hebben  - '<value-of select="@value"/>'</assert>
      <extends rule="TEL.NL.EXTENDED"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(uitvoerende zorgaanbieder): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.0.5
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:addr
Item: (uitvoerende zorgaanbieder)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:addr">
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.20.5.3-2017-12-31T000000.xml')/*/valueSet/conceptList/concept/@code))])">(uitvoerende zorgaanbieder): de waarde van use MOET worden gekozen uit waardelijst '2.16.840.1.113883.2.4.3.11.60.40.2.20.5.3' AdresSoortCodelijst (2017-12-31T00:00:00).</assert>
      <extends rule="AD.NL"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'AD')">(uitvoerende zorgaanbieder): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="count(hl7:streetName) &lt;= 1">(uitvoerende zorgaanbieder): element hl7:streetName komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="count(hl7:houseNumber) &lt;= 1">(uitvoerende zorgaanbieder): element hl7:houseNumber komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="count(hl7:buildingNumberSuffix) &lt;= 1">(uitvoerende zorgaanbieder): element hl7:buildingNumberSuffix komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="count(hl7:additionalLocator) &lt;= 1">(uitvoerende zorgaanbieder): element hl7:additionalLocator komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="count(hl7:postalCode) &lt;= 1">(uitvoerende zorgaanbieder): element hl7:postalCode komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="count(hl7:county) &lt;= 1">(uitvoerende zorgaanbieder): element hl7:county komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="count(hl7:city) &lt;= 1">(uitvoerende zorgaanbieder): element hl7:city komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="count(hl7:country) &lt;= 1">(uitvoerende zorgaanbieder): element hl7:country komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="count(hl7:unitID) &lt;= 1">(uitvoerende zorgaanbieder): element hl7:unitID komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="count(hl7:useablePeriod) &lt;= 1">(uitvoerende zorgaanbieder): element hl7:useablePeriod komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.101
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:addr/hl7:streetName
Item: (address NL - generic)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:addr/hl7:streetName">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2018-06-11T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(address NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.101
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:addr/hl7:houseNumber
Item: (address NL - generic)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:addr/hl7:houseNumber">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2018-06-11T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(address NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.101
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:addr/hl7:buildingNumberSuffix
Item: (address NL - generic)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:addr/hl7:buildingNumberSuffix">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2018-06-11T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(address NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.101
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:addr/hl7:additionalLocator
Item: (address NL - generic)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:addr/hl7:additionalLocator">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2018-06-11T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(address NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2018-06-11T000000.html"
              test="text()='to' or text()='by'">(address NL - generic): de elementinhoud van hl7:additionalLocator MOET ''to' of 'by'' zijn. Gevonden: "<value-of select="."/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.101
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:addr/hl7:postalCode
Item: (address NL - generic)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:addr/hl7:postalCode">
      <extends rule="ADXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2018-06-11T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(address NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ADXP" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.101
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:addr/hl7:county
Item: (address NL - generic)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:addr/hl7:county">
      <extends rule="ADXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2018-06-11T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(address NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ADXP" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.101
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:addr/hl7:city
Item: (address NL - generic)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:addr/hl7:city">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2018-06-11T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(address NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.101
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:addr/hl7:country
Item: (address NL - generic)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:addr/hl7:country">
      <extends rule="ADXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2018-06-11T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(address NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ADXP" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.101
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:addr/hl7:unitID
Item: (address NL - generic)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:addr/hl7:unitID">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2018-06-11T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(address NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.101
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:addr/hl7:useablePeriod
Item: (address NL - generic)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:addr/hl7:useablePeriod">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2018-06-11T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(address NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.0.5
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-2017-12-31T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (uitvoerende zorgaanbieder)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-2017-12-31T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(uitvoerende zorgaanbieder): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-2017-12-31T000000.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(uitvoerende zorgaanbieder): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3 OrganisatieTypeCodelijst (2017-12-31T00:00:00)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.0.5
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:asOrganizationPartOf
Item: (uitvoerende zorgaanbieder)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:asOrganizationPartOf">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="count(hl7:code) &lt;= 1">(uitvoerende zorgaanbieder): element hl7:code komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="count(hl7:wholeOrganization) &lt;= 1">(uitvoerende zorgaanbieder): element hl7:wholeOrganization komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.0.5
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:code
Item: (uitvoerende zorgaanbieder)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:code">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(uitvoerende zorgaanbieder): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.4-2017-12-31T000000.xml')//valueSet[1][conceptList/include[@codeSystem = $theCodeSystem]])">(uitvoerende zorgaanbieder): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.40.2.17.2.4 AfdelingSpecialismeCodelijst (2017-12-31T00:00:00)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.0.5
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization
Item: (uitvoerende zorgaanbieder)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="count(hl7:name) &lt;= 1">(uitvoerende zorgaanbieder): element hl7:name komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.0.5
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:name
Item: (uitvoerende zorgaanbieder)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:author[cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]]/cda:assignedAuthor[cda:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @codeSystem = '2.16.840.1.113883.2.4.6.7' or @nullFlavor]]/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:name">
      <extends rule="ON"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.0.5-2018-06-11T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ON')">(uitvoerende zorgaanbieder): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9234
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9067']]]
Item: (MP CDA (voorstel) Medicatieafspraak onderdelen 2)
-->

   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9067']]]"
         id="d6998e617-false-d7825e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9234-2018-12-04T140853.html"
              test="string(@typeCode) = ('COMP')">(MP CDA (voorstel) Medicatieafspraak onderdelen 2): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9234
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9270']]]
Item: (MP CDA (voorstel) Medicatieafspraak onderdelen 2)
-->

   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9270']]]"
         id="d6998e639-false-d7840e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9234-2018-12-04T140853.html"
              test="string(@typeCode) = ('RSON')">(MP CDA (voorstel) Medicatieafspraak onderdelen 2): de waarde van typeCode MOET 'RSON' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9234
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9160']]]
Item: (MP CDA (voorstel) Medicatieafspraak onderdelen 2)
-->

   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9160']]]"
         id="d6998e661-false-d7855e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9234-2018-12-04T140853.html"
              test="string(@typeCode) = ('RSON')">(MP CDA (voorstel) Medicatieafspraak onderdelen 2): de waarde van typeCode MOET 'RSON' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9234
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9085']]]
Item: (MP CDA (voorstel) Medicatieafspraak onderdelen 2)
-->

   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9085']]]"
         id="d6998e668-false-d7873e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9234-2018-12-04T140853.html"
              test="string(@typeCode) = ('SPRT')">(MP CDA (voorstel) Medicatieafspraak onderdelen 2): de waarde van typeCode MOET 'SPRT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9234
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.7.10.30']]]
Item: (MP CDA (voorstel) Medicatieafspraak onderdelen 2)
-->

   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.7.10.30']]]"
         id="d6998e690-false-d7920e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9234-2018-12-04T140853.html"
              test="string(@typeCode) = ('COMP')">(MP CDA (voorstel) Medicatieafspraak onderdelen 2): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9234
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.7.10.28']]]
Item: (MP CDA (voorstel) Medicatieafspraak onderdelen 2)
-->

   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.7.10.28']]]"
         id="d6998e697-false-d7973e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9234-2018-12-04T140853.html"
              test="string(@typeCode) = ('COMP')">(MP CDA (voorstel) Medicatieafspraak onderdelen 2): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9234
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9177']]]
Item: (MP CDA (voorstel) Medicatieafspraak onderdelen 2)
-->

   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9177']]]"
         id="d6998e704-false-d7987e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9234-2018-12-04T140853.html"
              test="string(@typeCode) = ('COMP')">(MP CDA (voorstel) Medicatieafspraak onderdelen 2): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9234
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9069']]]
Item: (MP CDA (voorstel) Medicatieafspraak onderdelen 2)
-->

   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9069']]]"
         id="d6998e712-false-d8002e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9234-2018-12-04T140853.html"
              test="string(@typeCode) = ('SUBJ')">(MP CDA (voorstel) Medicatieafspraak onderdelen 2): de waarde van typeCode MOET 'SUBJ' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9234-2018-12-04T140853.html"
              test="string(@inversionInd) = ('true')">(MP CDA (voorstel) Medicatieafspraak onderdelen 2): de waarde van inversionInd MOET 'true' zijn. Gevonden: "<value-of select="@inversionInd"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9234
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:entryRelationship[cda:substanceAdministration[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9149']]]
Item: (MP CDA (voorstel) Medicatieafspraak onderdelen 2)
-->

   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:entryRelationship[cda:substanceAdministration[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9149']]]"
         id="d6998e739-false-d8122e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9234-2018-12-04T140853.html"
              test="string(@typeCode) = ('COMP')">(MP CDA (voorstel) Medicatieafspraak onderdelen 2): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9234-2018-12-04T140853.html"
              test="count(cda:sequenceNumber) &gt;= 1">(MP CDA (voorstel) Medicatieafspraak onderdelen 2): element cda:sequenceNumber is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9234-2018-12-04T140853.html"
              test="count(cda:sequenceNumber) &lt;= 1">(MP CDA (voorstel) Medicatieafspraak onderdelen 2): element cda:sequenceNumber komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9234-2018-12-04T140853.html"
              test="count(cda:substanceAdministration[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9149']]) &gt;= 1">(MP CDA (voorstel) Medicatieafspraak onderdelen 2): element cda:substanceAdministration[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9149']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9234-2018-12-04T140853.html"
              test="count(cda:substanceAdministration[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9149']]) &lt;= 1">(MP CDA (voorstel) Medicatieafspraak onderdelen 2): element cda:substanceAdministration[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9149']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9234
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:entryRelationship[cda:substanceAdministration[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9149']]]/cda:sequenceNumber
Item: (MP CDA (voorstel) Medicatieafspraak onderdelen 2)
-->

   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:entryRelationship[cda:substanceAdministration[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9149']]]/cda:sequenceNumber"
         id="d6998e746-false-d8284e0">
      <extends rule="INT"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9234-2018-12-04T140853.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'INT')">(MP CDA (voorstel) Medicatieafspraak onderdelen 2): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:INT" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9234-2018-12-04T140853.html"
              test="not(@value) or matches(@value, '^-?[1-9]\d*$|^+?\d*$')">(MP CDA (voorstel) Medicatieafspraak onderdelen 2): @value is geen geldig INT getal <value-of select="@value"/>
      </assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9234-2018-12-04T140853.html"
              test="@value">(MP CDA (voorstel) Medicatieafspraak onderdelen 2): attribute @value MOET aanwezig zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9234-2018-12-04T140853.html"
              test="not(@value) or matches(string(@value), '^-?[1-9]\d*$|^+?\d*$')">(MP CDA (voorstel) Medicatieafspraak onderdelen 2): attribuut @value is geen geldig int getal <value-of select="@value"/>
      </assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9234
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:entryRelationship[*/cda:templateId[@root= ('2.16.840.1.113883.2.4.3.11.60.20.77.10.9086', '2.16.840.1.113883.2.4.3.11.60.20.77.10.9101', '2.16.840.1.113883.2.4.3.11.60.20.77.10.9176')]]
Item: (MP CDA (voorstel) Medicatieafspraak onderdelen 2)
-->

   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:entryRelationship[*/cda:templateId[@root= ('2.16.840.1.113883.2.4.3.11.60.20.77.10.9086', '2.16.840.1.113883.2.4.3.11.60.20.77.10.9101', '2.16.840.1.113883.2.4.3.11.60.20.77.10.9176')]]"
         id="d6998e760-false-d8301e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9234-2018-12-04T140853.html"
              test="string(@typeCode) = ('REFR')">(MP CDA (voorstel) Medicatieafspraak onderdelen 2): de waarde van typeCode MOET 'REFR' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9234-2018-12-04T140853.html"
              test="count(hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9086']] | hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9101']] | hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9176']]) &lt;= 1">(MP CDA (voorstel) Medicatieafspraak onderdelen 2): keuze (hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9086']]  of  hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9101']]  of  hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9176']]) bevat te veel elementen [max 1x]</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9233
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9200']]]
Item: (MP CDA Medicatieafspraak inhoud)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9200']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="string(@typeCode) = ('COMP')">(MP CDA Medicatieafspraak inhoud): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9233
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9084']]]
Item: (MP CDA Medicatieafspraak inhoud)
-->
   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/cda:entryRelationship[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9084']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="string(@typeCode) = ('COMP')">(MP CDA Medicatieafspraak inhoud): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9233-2018-12-04T130547.html"
              test="string(@inversionInd) = ('true')">(MP CDA Medicatieafspraak inhoud): de waarde van inversionInd MOET 'true' zijn. Gevonden: "<value-of select="@inversionInd"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.7.10.32
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:encounter]
Item: (part Encounter reference)
-->

   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:encounter]"
         id="d8367e25-false-d8382e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.32-2017-12-21T123947.html"
              test="string(@typeCode) = ('REFR')">(part Encounter reference): de waarde van typeCode MOET 'REFR' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.32-2017-12-21T123947.html"
              test="count(hl7:encounter[not(@nullFlavor)][@classCode = 'ENC'][@moodCode = 'EVN']) &gt;= 1">(part Encounter reference): element hl7:encounter[not(@nullFlavor)][@classCode = 'ENC'][@moodCode = 'EVN'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.32-2017-12-21T123947.html"
              test="count(hl7:encounter[not(@nullFlavor)][@classCode = 'ENC'][@moodCode = 'EVN']) &lt;= 1">(part Encounter reference): element hl7:encounter[not(@nullFlavor)][@classCode = 'ENC'][@moodCode = 'EVN'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.7.10.32
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:encounter]/hl7:encounter[not(@nullFlavor)][@classCode = 'ENC'][@moodCode = 'EVN']
Item: (part Encounter reference)
-->

   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:encounter]/hl7:encounter[not(@nullFlavor)][@classCode = 'ENC'][@moodCode = 'EVN']"
         id="d8367e39-false-d8402e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.32-2017-12-21T123947.html"
              test="string(@classCode) = ('ENC')">(part Encounter reference): de waarde van classCode MOET 'ENC' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.32-2017-12-21T123947.html"
              test="string(@moodCode) = ('EVN')">(part Encounter reference): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.32-2017-12-21T123947.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(part Encounter reference): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.32-2017-12-21T123947.html"
              test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(part Encounter reference): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.7.10.32
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:encounter]/hl7:encounter[not(@nullFlavor)][@classCode = 'ENC'][@moodCode = 'EVN']/hl7:id[not(@nullFlavor)]
Item: (part Encounter reference)
-->

   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:encounter]/hl7:encounter[not(@nullFlavor)][@classCode = 'ENC'][@moodCode = 'EVN']/hl7:id[not(@nullFlavor)]"
         id="d8367e51-false-d8426e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.32-2017-12-21T123947.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(part Encounter reference): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.7.10.33
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]
Item: (part Concern reference)
-->

   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]"
         id="d8427e17-false-d8435e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.33-2017-12-21T124050.html"
              test="string(@typeCode) = ('REFR')">(part Concern reference): de waarde van typeCode MOET 'REFR' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.33-2017-12-21T124050.html"
              test="count(hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]) &gt;= 1">(part Concern reference): element hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.33-2017-12-21T124050.html"
              test="count(hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]) &lt;= 1">(part Concern reference): element hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.7.10.33
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]/hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]
Item: (part Concern reference)
-->

   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]/hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]"
         id="d8427e32-false-d8457e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.33-2017-12-21T124050.html"
              test="string(@classCode) = ('ACT')">(part Concern reference): de waarde van classCode MOET 'ACT' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.33-2017-12-21T124050.html"
              test="string(@moodCode) = ('EVN')">(part Concern reference): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.33-2017-12-21T124050.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(part Concern reference): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.33-2017-12-21T124050.html"
              test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(part Concern reference): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.33-2017-12-21T124050.html"
              test="count(hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]) &gt;= 1">(part Concern reference): element hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.33-2017-12-21T124050.html"
              test="count(hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]) &lt;= 1">(part Concern reference): element hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.7.10.33
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]/hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]/hl7:id[not(@nullFlavor)]
Item: (part Concern reference)
-->

   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]/hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]/hl7:id[not(@nullFlavor)]"
         id="d8427e44-false-d8490e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.33-2017-12-21T124050.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(part Concern reference): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.7.10.33
Context: *[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]/hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]/hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]
Item: (part Concern reference)
-->

   <rule fpi="RULC-1"
         context="*[cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9233']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]/hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]/hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]"
         id="d8427e54-false-d8501e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.33-2017-12-21T124050.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(part Concern reference): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.7.10.33-2017-12-21T124050.html"
              test="@nullFlavor or (@code='CONC' and @codeSystem='2.16.840.1.113883.5.6')">(part Concern reference): de elementwaarde MOET een zijn van 'code 'CONC' codeSystem '2.16.840.1.113883.5.6''.</assert>
   </rule>
</pattern>
