<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.11.60.66.10.20
Name: Organizer AllergieIntoleranties
Description: Lijst van allergie/intoleranties
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.11.60.66.10.20-2018-04-18T000000">
   <title>Organizer AllergieIntoleranties</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.20
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]
Item: (Organizer AllergieIntoleranties)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]"
         id="d45e9455-false-d62365e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.20-2018-04-18T000000.html"
              test="string(@classCode) = ('CLUSTER')">(Organizer AllergieIntoleranties): de waarde van classCode MOET 'CLUSTER' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.20-2018-04-18T000000.html"
              test="string(@moodCode) = ('EVN')">(Organizer AllergieIntoleranties): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.20-2018-04-18T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']) &gt;= 1">(Organizer AllergieIntoleranties): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.20-2018-04-18T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']) &lt;= 1">(Organizer AllergieIntoleranties): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.20-2018-04-18T000000.html"
              test="count(hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Organizer AllergieIntoleranties): element hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.20-2018-04-18T000000.html"
              test="count(hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Organizer AllergieIntoleranties): element hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.20-2018-04-18T000000.html"
              test="count(hl7:statusCode[@code = 'completed']) &gt;= 1">(Organizer AllergieIntoleranties): element hl7:statusCode[@code = 'completed'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.20-2018-04-18T000000.html"
              test="count(hl7:statusCode[@code = 'completed']) &lt;= 1">(Organizer AllergieIntoleranties): element hl7:statusCode[@code = 'completed'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.20-2018-04-18T000000.html"
              test="count(hl7:recordTarget[not(@nullFlavor)][hl7:patientRole]) &gt;= 1">(Organizer AllergieIntoleranties): element hl7:recordTarget[not(@nullFlavor)][hl7:patientRole] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.20-2018-04-18T000000.html"
              test="count(hl7:recordTarget[not(@nullFlavor)][hl7:patientRole]) &lt;= 1">(Organizer AllergieIntoleranties): element hl7:recordTarget[not(@nullFlavor)][hl7:patientRole] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.20-2018-04-18T000000.html"
              test="count(hl7:participant[@typeCode='RESP']) &lt;= 1">(Organizer AllergieIntoleranties): element hl7:participant[@typeCode='RESP'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.20-2018-04-18T000000.html"
              test="count(hl7:participant[@typeCode='CST']) &lt;= 1">(Organizer AllergieIntoleranties): element hl7:participant[@typeCode='CST'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.20
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']
Item: (Organizer AllergieIntoleranties)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']"
         id="d45e9461-false-d62484e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.20-2018-04-18T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Organizer AllergieIntoleranties): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.20-2018-04-18T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.66.10.20')">(Organizer AllergieIntoleranties): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.66.10.20' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.20
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Organizer AllergieIntoleranties)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]"
         id="d45e9466-false-d62499e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.20-2018-04-18T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Organizer AllergieIntoleranties): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.20-2018-04-18T000000.html"
              test="@nullFlavor or (@code='48765-2' and @codeSystem='2.16.840.1.113883.6.1')">(Organizer AllergieIntoleranties): de elementwaarde MOET een zijn van 'code '48765-2' codeSystem '2.16.840.1.113883.6.1''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.20
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:statusCode[@code = 'completed']
Item: (Organizer AllergieIntoleranties)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:statusCode[@code = 'completed']"
         id="d45e9474-false-d62516e0">
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.20-2018-04-18T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(Organizer AllergieIntoleranties): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.20-2018-04-18T000000.html"
              test="@nullFlavor or (@code='completed')">(Organizer AllergieIntoleranties): de elementwaarde MOET een zijn van 'code 'completed''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.2
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]
Item: (CDA recordTarget SDTC NL BSN Minimal)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]"
         id="d62517e34-false-d62540e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]) &gt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]) &lt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.2
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]
Item: (CDA recordTarget SDTC NL BSN Minimal)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]"
         id="d62517e36-false-d62571e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:id[@root = '2.16.840.1.113883.2.4.6.3']) &gt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:id[@root = '2.16.840.1.113883.2.4.6.3'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:id[@root = '2.16.840.1.113883.2.4.6.3']) &lt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:id[@root = '2.16.840.1.113883.2.4.6.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]) &gt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]) &lt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.2
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:id[@root = '2.16.840.1.113883.2.4.6.3']
Item: (CDA recordTarget SDTC NL BSN Minimal)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:id[@root = '2.16.840.1.113883.2.4.6.3']"
         id="d62517e38-false-d62610e0">
      <extends rule="II.NL.BSN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(CDA recordTarget SDTC NL BSN Minimal): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.6.3')">(CDA recordTarget SDTC NL BSN Minimal): de waarde van root MOET '2.16.840.1.113883.2.4.6.3' zijn. Gevonden: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="@extension">(CDA recordTarget SDTC NL BSN Minimal): attribute @extension MOET aanwezig zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.2
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr
Item: (CDA recordTarget SDTC NL BSN Minimal)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr"
         id="d62517e52-false-d62631e0">
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.2-2015-04-01T000000.xml')/*/valueSet/conceptList/concept/@code))])">(CDA recordTarget SDTC NL BSN Minimal): de waarde van use MOET worden gekozen uit waardelijst '2.16.840.1.113883.2.4.3.11.60.40.2.0.1.2' AdresSoortCodelijst (2015-04-01T00:00:00).</assert>
      <extends rule="AD.NL"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'AD')">(CDA recordTarget SDTC NL BSN Minimal): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:streetName) &lt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:streetName komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:houseNumber) &lt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:houseNumber komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:buildingNumberSuffix) &lt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:buildingNumberSuffix komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:additionalLocator) &lt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:additionalLocator komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:postalCode komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:county) &lt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:county komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:city) &lt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:city komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:country) &lt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:country komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:unitID) &lt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:unitID komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:useablePeriod) &lt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:useablePeriod komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.101
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:streetName
Item: (address NL - generic)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:streetName"
         id="d62628e343-false-d62709e0">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2017-06-02T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(address NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.101
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:houseNumber
Item: (address NL - generic)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:houseNumber"
         id="d62628e355-false-d62719e0">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2017-06-02T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(address NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.101
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:buildingNumberSuffix
Item: (address NL - generic)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:buildingNumberSuffix"
         id="d62628e370-false-d62729e0">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2017-06-02T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(address NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.101
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:additionalLocator
Item: (address NL - generic)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:additionalLocator"
         id="d62628e427-false-d62739e0">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2017-06-02T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(address NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2017-06-02T000000.html"
              test="text()='to' or text()='by'">(address NL - generic): de elementinhoud van hl7:additionalLocator MOET ''to' of 'by'' zijn. Gevonden: "<value-of select="."/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.101
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:postalCode
Item: (address NL - generic)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:postalCode"
         id="d62628e441-false-d62755e0">
      <extends rule="ADXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2017-06-02T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(address NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ADXP" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.101
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:county
Item: (address NL - generic)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:county"
         id="d62628e473-false-d62767e0">
      <extends rule="ADXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2017-06-02T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(address NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ADXP" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.101
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:city
Item: (address NL - generic)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:city"
         id="d62628e481-false-d62777e0">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2017-06-02T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(address NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.101
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:country
Item: (address NL - generic)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:country"
         id="d62628e489-false-d62787e0">
      <extends rule="ADXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2017-06-02T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(address NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ADXP" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.101
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:unitID
Item: (address NL - generic)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:unitID"
         id="d62628e524-false-d62799e0">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2017-06-02T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(address NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.101
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:useablePeriod
Item: (address NL - generic)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:useablePeriod"
         id="d62628e544-false-d62809e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2017-06-02T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(address NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.2
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]
Item: (CDA recordTarget SDTC NL BSN Minimal)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]"
         id="d62517e57-false-d62827e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:name) &gt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:name) &lt;= 2">(CDA recordTarget SDTC NL BSN Minimal): element hl7:name komt te vaak voor [max 2x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]) &gt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]) &lt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:birthTime) &lt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:birthTime komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(sdtc:multipleBirthInd) &lt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element sdtc:multipleBirthInd komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.2
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name
Item: (CDA recordTarget SDTC NL BSN Minimal)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name"
         id="d62517e59-false-d62875e0">
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="not(@use) or empty($theAttValue[not(. = (('L','A','OR')))])">(CDA recordTarget SDTC NL BSN Minimal): de waarde van use MOET 'code L of code A of code OR' zijn. Gevonden: "<value-of select="@use"/>"</assert>
      <extends rule="PN.NL"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PN')">(CDA recordTarget SDTC NL BSN Minimal): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:prefix[@qualifier='NB']) &lt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:prefix[@qualifier='NB'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:given[@qualifier='BR']) &lt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:given[@qualifier='BR'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:given[@qualifier='CL']) &lt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:given[@qualifier='CL'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:given[@qualifier='IN']) &lt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:given[@qualifier='IN'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:given[not(@qualifier)]) &lt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:given[not(@qualifier)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:prefix[not(@qualifier)]) &lt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:prefix[not(@qualifier)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:family[not(@qualifier)]) &lt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:family[not(@qualifier)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:prefix[tokenize(@qualifier,'\s')='VV'][following-sibling::hl7:family[1][tokenize(@qualifier,'\s')='BR']]) &lt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:prefix[tokenize(@qualifier,'\s')='VV'][following-sibling::hl7:family[1][tokenize(@qualifier,'\s')='BR']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:family[tokenize(@qualifier,'\s')='BR']) &lt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:family[tokenize(@qualifier,'\s')='BR'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:delimiter[not(@nullFlavor)]) &lt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:delimiter[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:prefix[tokenize(@qualifier,'\s')='VV'][following-sibling::hl7:family[1][tokenize(@qualifier,'\s')='SP']]) &lt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:prefix[tokenize(@qualifier,'\s')='VV'][following-sibling::hl7:family[1][tokenize(@qualifier,'\s')='SP']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:family[tokenize(@qualifier,'\s')='SP']) &lt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:family[tokenize(@qualifier,'\s')='SP'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:suffix[not(@nullFlavor)]) &lt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:suffix[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:validTime) &lt;= 1">(CDA recordTarget SDTC NL BSN Minimal): element hl7:validTime komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="not(*) or (hl7:given and hl7:family)">(CDA recordTarget SDTC NL BSN Minimal): In een gestructureerde naam moet minimaal één voornaam, initiaal of roepnaam en minimaal één geslachtsnaam of geslachtsnaam partner van een persoon aanwezig zijn, inclusief voorvoegsel(s) indien van toepassing</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.100
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name
Item: (name person NL - generic)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.100
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:prefix[@qualifier='NB']
Item: (name person NL - generic)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:prefix[@qualifier='NB']"
         id="d62871e414-false-d62966e0">
      <extends rule="ENXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(name person NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="string(@qualifier) = ('NB')">(name person NL - generic): de waarde van qualifier MOET 'NB' zijn. Gevonden: "<value-of select="@qualifier"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="not(@nullFlavor)">(name person NL - generic): attribute @nullFlavor MAG NIET voorkomen.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.100
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:given[@qualifier='BR']
Item: (name person NL - generic)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:given[@qualifier='BR']"
         id="d62871e433-false-d62982e0">
      <extends rule="ENXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(name person NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="string(@qualifier) = ('BR')">(name person NL - generic): de waarde van qualifier MOET 'BR' zijn. Gevonden: "<value-of select="@qualifier"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="not(@nullFlavor)">(name person NL - generic): attribute @nullFlavor MAG NIET voorkomen.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.100
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:given[@qualifier='CL']
Item: (name person NL - generic)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:given[@qualifier='CL']"
         id="d62871e452-false-d62998e0">
      <extends rule="ENXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(name person NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="string(@qualifier) = ('CL')">(name person NL - generic): de waarde van qualifier MOET 'CL' zijn. Gevonden: "<value-of select="@qualifier"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="not(@nullFlavor)">(name person NL - generic): attribute @nullFlavor MAG NIET voorkomen.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.100
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:given[@qualifier='IN']
Item: (name person NL - generic)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:given[@qualifier='IN']"
         id="d62871e472-false-d63014e0">
      <extends rule="ENXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(name person NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="string(@qualifier) = ('IN')">(name person NL - generic): de waarde van qualifier MOET 'IN' zijn. Gevonden: "<value-of select="@qualifier"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="not(@nullFlavor)">(name person NL - generic): attribute @nullFlavor MAG NIET voorkomen.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.100
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:given[not(@qualifier)]
Item: (name person NL - generic)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:given[not(@qualifier)]"
         id="d62871e491-false-d63030e0">
      <extends rule="ENXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(name person NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.100
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:prefix[not(@qualifier)]
Item: (name person NL - generic)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:prefix[not(@qualifier)]"
         id="d62871e500-false-d63038e0">
      <extends rule="ENXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(name person NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.100
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:family[not(@qualifier)]
Item: (name person NL - generic)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:family[not(@qualifier)]"
         id="d62871e509-false-d63046e0">
      <extends rule="ENXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(name person NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.100
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:prefix[tokenize(@qualifier,'\s')='VV'][following-sibling::hl7:family[1][tokenize(@qualifier,'\s')='BR']]
Item: (name person NL - generic)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:prefix[tokenize(@qualifier,'\s')='VV'][following-sibling::hl7:family[1][tokenize(@qualifier,'\s')='BR']]"
         id="d62871e518-false-d63054e0">
      <extends rule="ENXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(name person NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="string(@qualifier) = ('VV')">(name person NL - generic): de waarde van qualifier MOET 'VV' zijn. Gevonden: "<value-of select="@qualifier"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="not(@nullFlavor)">(name person NL - generic): attribute @nullFlavor MAG NIET voorkomen.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.100
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:family[tokenize(@qualifier,'\s')='BR']
Item: (name person NL - generic)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:family[tokenize(@qualifier,'\s')='BR']"
         id="d62871e551-false-d63070e0">
      <extends rule="ENXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(name person NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="string(@qualifier) = ('BR')">(name person NL - generic): de waarde van qualifier MOET 'BR' zijn. Gevonden: "<value-of select="@qualifier"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="not(@nullFlavor)">(name person NL - generic): attribute @nullFlavor MAG NIET voorkomen.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.100
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:delimiter[not(@nullFlavor)]
Item: (name person NL - generic)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:delimiter[not(@nullFlavor)]"
         id="d62871e571-false-d63088e0">
      <extends rule="ENXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(name person NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="not(@nullFlavor)">(name person NL - generic): attribute @nullFlavor MAG NIET voorkomen.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.100
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:prefix[tokenize(@qualifier,'\s')='VV'][following-sibling::hl7:family[1][tokenize(@qualifier,'\s')='SP']]
Item: (name person NL - generic)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:prefix[tokenize(@qualifier,'\s')='VV'][following-sibling::hl7:family[1][tokenize(@qualifier,'\s')='SP']]"
         id="d62871e606-false-d63100e0">
      <extends rule="ENXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(name person NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="string(@qualifier) = ('VV')">(name person NL - generic): de waarde van qualifier MOET 'VV' zijn. Gevonden: "<value-of select="@qualifier"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="not(@nullFlavor)">(name person NL - generic): attribute @nullFlavor MAG NIET voorkomen.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.100
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:family[tokenize(@qualifier,'\s')='SP']
Item: (name person NL - generic)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:family[tokenize(@qualifier,'\s')='SP']"
         id="d62871e639-false-d63116e0">
      <extends rule="ENXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(name person NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="string(@qualifier) = ('SP')">(name person NL - generic): de waarde van qualifier MOET 'SP' zijn. Gevonden: "<value-of select="@qualifier"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="not(@nullFlavor)">(name person NL - generic): attribute @nullFlavor MAG NIET voorkomen.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.100
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:suffix[not(@nullFlavor)]
Item: (name person NL - generic)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:suffix[not(@nullFlavor)]"
         id="d62871e658-false-d63134e0">
      <extends rule="ENXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(name person NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="string(@qualifier) = ('AC') or not(@qualifier)">(name person NL - generic): de waarde van qualifier MOET 'AC' zijn. Gevonden: "<value-of select="@qualifier"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="not(@nullFlavor)">(name person NL - generic): attribute @nullFlavor MAG NIET voorkomen.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.100
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:validTime
Item: (name person NL - generic)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:validTime"
         id="d62871e707-false-d63152e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(name person NL - generic): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.2
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]
Item: (CDA recordTarget SDTC NL BSN Minimal)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]"
         id="d62517e70-false-d63165e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(CDA recordTarget SDTC NL BSN Minimal): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA recordTarget SDTC NL BSN Minimal): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1 GeslachtCodelijst (2015-04-01T00:00:00)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(CDA recordTarget SDTC NL BSN Minimal): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst 2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1 GeslachtCodelijst (2015-04-01T00:00:00).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.2
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:birthTime
Item: (CDA recordTarget SDTC NL BSN Minimal)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:birthTime"
         id="d62517e75-false-d63185e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(CDA recordTarget SDTC NL BSN Minimal): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="not(*)">(CDA recordTarget SDTC NL BSN Minimal): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.2
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/sdtc:multipleBirthInd
Item: (CDA recordTarget SDTC NL BSN Minimal)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/sdtc:multipleBirthInd"
         id="d62517e77-false-d63198e0">
      <extends rule="BL"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'BL')">(CDA recordTarget SDTC NL BSN Minimal): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:BL" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9031
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='RESP']
Item: (KEZO PART CDA Inhoudsverantwoordelijke (Body))
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='RESP']"
         id="d63199e16-false-d63207e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9031-2014-11-13T000000.html"
              test="string(@typeCode) = ('RESP')">(KEZO PART CDA Inhoudsverantwoordelijke (Body)): de waarde van typeCode MOET 'RESP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9031-2014-11-13T000000.html"
              test="count(hl7:time) &lt;= 1">(KEZO PART CDA Inhoudsverantwoordelijke (Body)): element hl7:time komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9031-2014-11-13T000000.html"
              test="count(hl7:participantRole[@classCode = 'ASSIGNED']) &gt;= 1">(KEZO PART CDA Inhoudsverantwoordelijke (Body)): element hl7:participantRole[@classCode = 'ASSIGNED'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9031-2014-11-13T000000.html"
              test="count(hl7:participantRole[@classCode = 'ASSIGNED']) &lt;= 1">(KEZO PART CDA Inhoudsverantwoordelijke (Body)): element hl7:participantRole[@classCode = 'ASSIGNED'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='RESP']/hl7:time
Item: (KEZO PART CDA Responsible Party (Body))
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='RESP']/hl7:time"
         id="d63215e46-false-d63239e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(KEZO PART CDA Responsible Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']
Item: (KEZO PART CDA Responsible Party (Body))
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']"
         id="d63215e51-false-d63249e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="string(@classCode) = ('ASSIGNED')">(KEZO PART CDA Responsible Party (Body)): de waarde van classCode MOET 'ASSIGNED' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @nullFlavor]) &lt;= 1">(KEZO PART CDA Responsible Party (Body)): element hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="count(hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE']) &lt;= 1">(KEZO PART CDA Responsible Party (Body)): element hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="count(hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(KEZO PART CDA Responsible Party (Body)): element hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:id
Item: (KEZO PART CDA Responsible Party (Body))
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:id"
         id="d63215e55-false-d63292e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(KEZO PART CDA Responsible Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @nullFlavor]
Item: (KEZO PART CDA Responsible Party (Body))
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @nullFlavor]"
         id="d63215e61-false-d63303e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(KEZO PART CDA Responsible Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="@nullFlavor or (@codeSystem='2.16.840.1.113883.2.4.15.111')">(KEZO PART CDA Responsible Party (Body)): de elementwaarde MOET een zijn van 'codeSystem '2.16.840.1.113883.2.4.15.111''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:addr
Item: (KEZO PART CDA Responsible Party (Body))
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:addr"
         id="d63215e68-false-d63319e0">
      <extends rule="AD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'AD')">(KEZO PART CDA Responsible Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:telecom
Item: (KEZO PART CDA Responsible Party (Body))
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:telecom"
         id="d63215e70-false-d63329e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(KEZO PART CDA Responsible Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE']
Item: (KEZO PART CDA Responsible Party (Body))
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE']"
         id="d63215e73-false-d63339e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="string(@classCode) = ('PSN')">(KEZO PART CDA Responsible Party (Body)): de waarde van classCode MOET 'PSN' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="string(@determinerCode) = ('INSTANCE')">(KEZO PART CDA Responsible Party (Body)): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(KEZO PART CDA Responsible Party (Body)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (KEZO PART CDA Responsible Party (Body))
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d63215e82-false-d63370e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(KEZO PART CDA Responsible Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(KEZO PART CDA Responsible Party (Body)): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.1.11.2 RoleCodeNL - zorgverlenertype (personen) (DYNAMISCH)'.</assert>
      <report fpi="CD-DEPR-BSP"
              role="warning"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@type='D'][@code = $theCode][@codeSystem = $theCodeSystem])">(KEZO PART CDA Responsible Party (Body)): element hl7:code is gecodeerd met bindingssterkte 'required' en bevat een code die verouderd is.</report>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:name
Item: (KEZO PART CDA Responsible Party (Body))
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:name"
         id="d63215e87-false-d63392e0">
      <extends rule="PN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PN')">(KEZO PART CDA Responsible Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (KEZO PART CDA Responsible Party (Body))
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']"
         id="d63215e90-false-d63402e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="string(@classCode) = ('ORG')">(KEZO PART CDA Responsible Party (Body)): de waarde van classCode MOET 'ORG' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="string(@determinerCode) = ('INSTANCE')">(KEZO PART CDA Responsible Party (Body)): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor]) &lt;= 1">(KEZO PART CDA Responsible Party (Body)): element hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="count(hl7:desc) &lt;= 1">(KEZO PART CDA Responsible Party (Body)): element hl7:desc komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id
Item: (KEZO PART CDA Responsible Party (Body))
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id"
         id="d63215e99-false-d63435e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(KEZO PART CDA Responsible Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor]
Item: (KEZO PART CDA Responsible Party (Body))
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor]"
         id="d63215e101-false-d63446e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(KEZO PART CDA Responsible Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="@nullFlavor or (@codeSystem='2.16.840.1.113883.2.4.15.1060')">(KEZO PART CDA Responsible Party (Body)): de elementwaarde MOET een zijn van 'codeSystem '2.16.840.1.113883.2.4.15.1060''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:desc
Item: (KEZO PART CDA Responsible Party (Body))
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:desc"
         id="d63215e107-false-d63462e0">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(KEZO PART CDA Responsible Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9032
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='CST']
Item: (KEZO PART CDA Dossierhouder)
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='CST']"
         id="d63463e16-false-d63471e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9032-2014-11-13T000000.html"
              test="string(@typeCode) = ('CST')">(KEZO PART CDA Dossierhouder): de waarde van typeCode MOET 'CST' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9032-2014-11-13T000000.html"
              test="count(hl7:time) &lt;= 1">(KEZO PART CDA Dossierhouder): element hl7:time komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9032-2014-11-13T000000.html"
              test="count(hl7:participantRole[@classCode = 'ASSIGNED']) &gt;= 1">(KEZO PART CDA Dossierhouder): element hl7:participantRole[@classCode = 'ASSIGNED'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9032-2014-11-13T000000.html"
              test="count(hl7:participantRole[@classCode = 'ASSIGNED']) &lt;= 1">(KEZO PART CDA Dossierhouder): element hl7:participantRole[@classCode = 'ASSIGNED'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9041
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='CST']/hl7:time
Item: (KEZO PART CDA Custodian Party (Body))
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='CST']/hl7:time"
         id="d63479e52-false-d63503e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(KEZO PART CDA Custodian Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9041
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']
Item: (KEZO PART CDA Custodian Party (Body))
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']"
         id="d63479e57-false-d63513e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="string(@classCode) = ('ASSIGNED')">(KEZO PART CDA Custodian Party (Body)): de waarde van classCode MOET 'ASSIGNED' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="count(hl7:id) &gt;= 1">(KEZO PART CDA Custodian Party (Body)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="count(hl7:code) &lt;= 1">(KEZO PART CDA Custodian Party (Body)): element hl7:code komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="count(hl7:playingEntity[@classCode = ('PSN', 'ORG')][@determinerCode = 'INSTANCE']) &lt;= 1">(KEZO PART CDA Custodian Party (Body)): element hl7:playingEntity[@classCode = ('PSN', 'ORG')][@determinerCode = 'INSTANCE'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="count(hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(KEZO PART CDA Custodian Party (Body)): element hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9041
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:id
Item: (KEZO PART CDA Custodian Party (Body))
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:id"
         id="d63479e64-false-d63564e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(KEZO PART CDA Custodian Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9041
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:code
Item: (KEZO PART CDA Custodian Party (Body))
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:code"
         id="d63479e70-false-d63581e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(KEZO PART CDA Custodian Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]]) or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.1.6-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]]) or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.1.7-DYNAMIC.xml')//valueSet[1][conceptList/include[@codeSystem = $theCodeSystem]])">(KEZO PART CDA Custodian Party (Body)): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3 OrganisatieTypeCodelijst (DYNAMISCH) of 2.16.840.1.113883.2.4.3.11.60.40.2.17.1.6 SpecialismeUZICodelijst (DYNAMISCH) of 2.16.840.1.113883.2.4.3.11.60.40.2.17.1.7 SpecialismeAGBCodelijst (DYNAMISCH)'.</assert>
      <report fpi="CD-DEPR-BSP"
              role="warning"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.1.6-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@type='D'][@code = $theCode][@codeSystem = $theCodeSystem])">(KEZO PART CDA Custodian Party (Body)): element hl7:code is gecodeerd met bindingssterkte 'required' en bevat een code die verouderd is.</report>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9041
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:addr
Item: (KEZO PART CDA Custodian Party (Body))
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:addr"
         id="d63479e82-false-d63615e0">
      <extends rule="AD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'AD')">(KEZO PART CDA Custodian Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9041
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:telecom
Item: (KEZO PART CDA Custodian Party (Body))
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:telecom"
         id="d63479e85-false-d63625e0">
      <extends rule="TEL.NL.EXTENDED"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(KEZO PART CDA Custodian Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9041
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = ('PSN', 'ORG')][@determinerCode = 'INSTANCE']
Item: (KEZO PART CDA Custodian Party (Body))
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = ('PSN', 'ORG')][@determinerCode = 'INSTANCE']"
         id="d63479e87-false-d63635e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="@classCode">(KEZO PART CDA Custodian Party (Body)): attribute @classCode MOET aanwezig zijn.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@classCode),'\s'))"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="not(@classCode) or empty($theAttValue[not(. = (('PSN','ORG')))])">(KEZO PART CDA Custodian Party (Body)): de waarde van classCode MOET 'code PSN of code ORG' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="string(@determinerCode) = ('INSTANCE')">(KEZO PART CDA Custodian Party (Body)): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="count(hl7:name) &gt;= 1">(KEZO PART CDA Custodian Party (Body)): element hl7:name is required [min 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9041
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = ('PSN', 'ORG')][@determinerCode = 'INSTANCE']/hl7:name
Item: (KEZO PART CDA Custodian Party (Body))
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = ('PSN', 'ORG')][@determinerCode = 'INSTANCE']/hl7:name"
         id="d63479e98-false-d63669e0">
      <extends rule="PN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PN')">(KEZO PART CDA Custodian Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9041
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (KEZO PART CDA Custodian Party (Body))
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']"
         id="d63479e101-false-d63679e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="string(@classCode) = ('ORG')">(KEZO PART CDA Custodian Party (Body)): de waarde van classCode MOET 'ORG' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="string(@determinerCode) = ('INSTANCE')">(KEZO PART CDA Custodian Party (Body)): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(KEZO PART CDA Custodian Party (Body)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="count(hl7:desc) &gt;= 1">(KEZO PART CDA Custodian Party (Body)): element hl7:desc is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="count(hl7:desc) &lt;= 1">(KEZO PART CDA Custodian Party (Body)): element hl7:desc komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9041
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id
Item: (KEZO PART CDA Custodian Party (Body))
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id"
         id="d63479e113-false-d63716e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(KEZO PART CDA Custodian Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9041
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (KEZO PART CDA Custodian Party (Body))
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d63479e120-false-d63729e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(KEZO PART CDA Custodian Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(KEZO PART CDA Custodian Party (Body)): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3 OrganisatieTypeCodelijst (DYNAMISCH)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9041
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:desc
Item: (KEZO PART CDA Custodian Party (Body))
-->

   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:desc"
         id="d63479e125-false-d63749e0">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(KEZO PART CDA Custodian Party (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.20
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]
Item: (Organizer AllergieIntoleranties)
-->
   <rule fpi="RULC-1"
         context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.20']]/hl7:component[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.20-2018-04-18T000000.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Organizer AllergieIntoleranties): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.20-2018-04-18T000000.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(Organizer AllergieIntoleranties): de waarde van contextControlCode MOET 'OP' zijn. Gevonden: "<value-of select="@contextControlCode"/>"</assert>
   </rule>
</pattern>
