<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.11.60.66.10.218
Name: KEZO Criticality Observatie
Description: Criticality / Mate van kritiek zijn
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-08-21T000000">
   <title>KEZO Criticality Observatie</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.218
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]]
Item: (KEZO Criticality Observatie)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]]"
         id="d45e10995-false-d79865e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-08-21T000000.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]) &gt;= 1">(KEZO Criticality Observatie): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-08-21T000000.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]) &lt;= 1">(KEZO Criticality Observatie): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.218
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]
Item: (KEZO Criticality Observatie)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]"
         id="d45e11017-false-d79882e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-08-21T000000.html"
              test="string(@classCode) = ('OBS')">(KEZO Criticality Observatie): de waarde van classCode MOET 'OBS' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-08-21T000000.html"
              test="string(@moodCode) = ('EVN')">(KEZO Criticality Observatie): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-08-21T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']) &gt;= 1">(KEZO Criticality Observatie): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-08-21T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']) &lt;= 1">(KEZO Criticality Observatie): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-08-21T000000.html"
              test="count(hl7:code[(@code = 'CRIT' and @codeSystem = '2.16.840.1.113883.5.4')]) &gt;= 1">(KEZO Criticality Observatie): element hl7:code[(@code = 'CRIT' and @codeSystem = '2.16.840.1.113883.5.4')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-08-21T000000.html"
              test="count(hl7:code[(@code = 'CRIT' and @codeSystem = '2.16.840.1.113883.5.4')]) &lt;= 1">(KEZO Criticality Observatie): element hl7:code[(@code = 'CRIT' and @codeSystem = '2.16.840.1.113883.5.4')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-08-21T000000.html"
              test="count(hl7:statusCode[@code = 'completed']) &gt;= 1">(KEZO Criticality Observatie): element hl7:statusCode[@code = 'completed'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-08-21T000000.html"
              test="count(hl7:statusCode[@code = 'completed']) &lt;= 1">(KEZO Criticality Observatie): element hl7:statusCode[@code = 'completed'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-08-21T000000.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.117-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.117-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]) &gt;= 1">(KEZO Criticality Observatie): element hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.117-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.117-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-08-21T000000.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.117-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.117-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]) &lt;= 1">(KEZO Criticality Observatie): element hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.117-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.117-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.218
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']
Item: (KEZO Criticality Observatie)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']"
         id="d45e11023-false-d79937e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-08-21T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(KEZO Criticality Observatie): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-08-21T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.66.10.218')">(KEZO Criticality Observatie): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.66.10.218' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.218
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]/hl7:code[(@code = 'CRIT' and @codeSystem = '2.16.840.1.113883.5.4')]
Item: (KEZO Criticality Observatie)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]/hl7:code[(@code = 'CRIT' and @codeSystem = '2.16.840.1.113883.5.4')]"
         id="d45e11028-false-d79952e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-08-21T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(KEZO Criticality Observatie): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-08-21T000000.html"
              test="@nullFlavor or (@code='CRIT' and @codeSystem='2.16.840.1.113883.5.4')">(KEZO Criticality Observatie): de elementwaarde MOET een zijn van 'code 'CRIT' codeSystem '2.16.840.1.113883.5.4''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.218
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]/hl7:statusCode[@code = 'completed']
Item: (KEZO Criticality Observatie)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]/hl7:statusCode[@code = 'completed']"
         id="d45e11036-false-d79969e0">
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-08-21T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(KEZO Criticality Observatie): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-08-21T000000.html"
              test="@nullFlavor or (@code='completed')">(KEZO Criticality Observatie): de elementwaarde MOET een zijn van 'code 'completed''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.218
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.117-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.117-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]
Item: (KEZO Criticality Observatie)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.218']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.117-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.117-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]"
         id="d45e11041-false-d79988e0">
      <extends rule="CD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-08-21T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(KEZO Criticality Observatie): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CD" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-08-21T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.117-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(KEZO Criticality Observatie): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.66.11.117 Criticality (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.117-DYNAMIC.xml')//valueSet[1]/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/acutezorg/acutezorg-html-20260114T154913/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.218-2015-08-21T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(KEZO Criticality Observatie): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst 2.16.840.1.113883.2.4.3.11.60.66.11.117 Criticality (DYNAMISCH).</assert>
   </rule>
</pattern>
