<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.11.60.55.10.405
Name: Date Of Event
Description: Datum/tijd incident
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron" id="template-2.16.840.1.113883.2.4.3.11.60.55.10.405-2016-08-04T170436">
   <title>Date Of Event</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.405
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.405']]]
Item: (DateOfEvent)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.405']]]" id="d152e10304-false-d29079e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.405" test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.405']]) &gt;= 1">(DateOfEvent): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.405']] is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.405" test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.405']]) &lt;= 1">(DateOfEvent): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.405']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.405
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.405']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.405']]
Item: (DateOfEvent)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.405']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.405']]" id="d152e10328-false-d29101e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.405" test="string(@classCode) = ('INC')">(DateOfEvent): de waarde van classCode MOET 'INC' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.405" test="string(@moodCode) = ('EVN')">(DateOfEvent): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.405" test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.405']) &gt;= 1">(DateOfEvent): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.405'] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.405" test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.405']) &lt;= 1">(DateOfEvent): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.405'] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.405" test="count(hl7:code[(@code = '439771001' and @codeSystem = '2.16.840.1.113883.6.96')]) &gt;= 1">(DateOfEvent): element hl7:code[(@code = '439771001' and @codeSystem = '2.16.840.1.113883.6.96')] is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.405" test="count(hl7:code[(@code = '439771001' and @codeSystem = '2.16.840.1.113883.6.96')]) &lt;= 1">(DateOfEvent): element hl7:code[(@code = '439771001' and @codeSystem = '2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.405" test="count(hl7:effectiveTime) &lt;= 1">(DateOfEvent): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.405
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.405']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.405']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.405']
Item: (DateOfEvent)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.405']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.405']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.405']" id="d152e10334-false-d29161e0">
      <extends rule="II"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.405" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(DateOfEvent): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.405" test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.55.10.405')">(DateOfEvent): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.55.10.405' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.405
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.405']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.405']]/hl7:code[(@code = '439771001' and @codeSystem = '2.16.840.1.113883.6.96')]
Item: (DateOfEvent)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.405']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.405']]/hl7:code[(@code = '439771001' and @codeSystem = '2.16.840.1.113883.6.96')]" id="d152e10342-false-d29180e0">
      <extends rule="CD"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.405" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(DateOfEvent): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CD" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.405" test="string(@code) = ('439771001')">(DateOfEvent): de waarde van code MOET '439771001' zijn. Gevonden: "<value-of select="@code"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.405" test="@displayName">(DateOfEvent): attribute @displayName MOET aanwezig zijn.</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.405" test="not(@displayName) or string-length(@displayName)&gt;0">(DateOfEvent): attribuut @displayName MOET datatype 'st' hebben  - '<value-of select="@displayName"/>'</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.405" test="string(@codeSystem) = ('2.16.840.1.113883.6.96')">(DateOfEvent): de waarde van codeSystem MOET '2.16.840.1.113883.6.96' zijn. Gevonden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.405" test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(DateOfEvent): attribuut @codeSystemName MOET datatype 'st' hebben  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.405
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.405']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.405']]/hl7:effectiveTime
Item: (DateOfEvent)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.405']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.405']]/hl7:effectiveTime" id="d152e10361-false-d29220e0">
      <extends rule="IVL_TS"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.405" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(DateOfEvent): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.405" test="@value">(DateOfEvent): attribute @value MOET aanwezig zijn.</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.405" test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(DateOfEvent): attribuut @value MOET datatype 'ts' hebben  - '<value-of select="@value"/>'</assert>
   </rule>
</pattern>