<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.11.60.2.10.1
Name: GEBB Encounter Activity
Description: Encounter Activities
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.11.60.2.10.1-2013-12-31T000000">
   <title>GEBB Encounter Activity</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.1
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]
Item: (gebb-EncounterActivity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.1
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]
Item: (gebb-EncounterActivity)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]"
         id="d15e3178-false-d2054e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.1-2013-12-31T000000.html"
              test="string(@classCode) = ('ENC')">(gebb-EncounterActivity): de waarde van classCode MOET 'ENC' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.1-2013-12-31T000000.html"
              test="string(@moodCode) = ('EVN')">(gebb-EncounterActivity): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.1-2013-12-31T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']) &gt;= 1">(gebb-EncounterActivity): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.1-2013-12-31T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']) &lt;= 1">(gebb-EncounterActivity): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.1-2013-12-31T000000.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(gebb-EncounterActivity): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.1-2013-12-31T000000.html"
              test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(gebb-EncounterActivity): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.1-2013-12-31T000000.html"
              test="count(hl7:code) &lt;= 1">(gebb-EncounterActivity): element hl7:code komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.1-2013-12-31T000000.html"
              test="count(hl7:effectiveTime[not(@nullFlavor)][hl7:low]) &gt;= 1">(gebb-EncounterActivity): element hl7:effectiveTime[not(@nullFlavor)][hl7:low] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.1-2013-12-31T000000.html"
              test="count(hl7:effectiveTime[not(@nullFlavor)][hl7:low]) &lt;= 1">(gebb-EncounterActivity): element hl7:effectiveTime[not(@nullFlavor)][hl7:low] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.1
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']
Item: (gebb-EncounterActivity)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']"
         id="d15e3184-false-d2170e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.1-2013-12-31T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.2.10.1')">(gebb-EncounterActivity): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.2.10.1' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.1
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:id[not(@nullFlavor)]
Item: (gebb-EncounterActivity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.1
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:code
Item: (gebb-EncounterActivity)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:code"
         id="d15e3191-false-d2194e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.1-2013-12-31T000000.html"
              test="count(hl7:originalText) &lt;= 1">(gebb-EncounterActivity): element hl7:originalText komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.1
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:code/hl7:originalText
Item: (gebb-EncounterActivity)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:code/hl7:originalText"
         id="d15e3195-false-d2212e0">
      <extends rule="ED"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.1-2013-12-31T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ED' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(gebb-EncounterActivity): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ED" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.1-2013-12-31T000000.html"
              test="count(hl7:reference) &lt;= 1">(gebb-EncounterActivity): element hl7:reference komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.1
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:code/hl7:originalText/hl7:reference
Item: (gebb-EncounterActivity)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:code/hl7:originalText/hl7:reference"
         id="d15e3197-false-d2234e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.1-2013-12-31T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(gebb-EncounterActivity): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.1-2013-12-31T000000.html"
              test="@value">(gebb-EncounterActivity): attribute @value MOET aanwezig zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.1-2013-12-31T000000.html"
              test="not(@value) or string(@value castable as xs:anyURI)">(gebb-EncounterActivity): attribuut @value MOET datatype 'url' hebben  - '<value-of select="@value"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.1
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:effectiveTime[not(@nullFlavor)][hl7:low]
Item: (gebb-EncounterActivity)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:effectiveTime[not(@nullFlavor)][hl7:low]"
         id="d15e3205-false-d2257e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.1-2013-12-31T000000.html"
              test="count(hl7:low) &gt;= 1">(gebb-EncounterActivity): element hl7:low is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.1-2013-12-31T000000.html"
              test="count(hl7:low) &lt;= 1">(gebb-EncounterActivity): element hl7:low komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.1-2013-12-31T000000.html"
              test="count(hl7:high) &lt;= 1">(gebb-EncounterActivity): element hl7:high komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.1
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:effectiveTime[not(@nullFlavor)][hl7:low]/hl7:low
Item: (gebb-EncounterActivity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.1
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:effectiveTime[not(@nullFlavor)][hl7:low]/hl7:high
Item: (gebb-EncounterActivity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.1
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]
Item: (gebb-EncounterActivity)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]"
         id="d15e3216-false-d2328e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.1-2013-12-31T000000.html"
              test="string(@typeCode) = ('PRF') or not(@typeCode)">(gebb-EncounterActivity): de waarde van typeCode MOET 'PRF' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.1-2013-12-31T000000.html"
              test="count(hl7:time) &lt;= 1">(gebb-EncounterActivity): element hl7:time komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.1-2013-12-31T000000.html"
              test="count(hl7:modeCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16543-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(gebb-EncounterActivity): element hl7:modeCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16543-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.1-2013-12-31T000000.html"
              test="count(hl7:assignedEntity) &gt;= 1">(gebb-EncounterActivity): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.1-2013-12-31T000000.html"
              test="count(hl7:assignedEntity) &lt;= 1">(gebb-EncounterActivity): element hl7:assignedEntity komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9012
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]/hl7:time
Item: (CDAPerformerBody)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]/hl7:time"
         id="d2395e18-false-d2403e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9012-2014-04-03T162820.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAPerformerBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9012
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]/hl7:modeCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16543-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDAPerformerBody)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]/hl7:modeCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16543-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d2395e20-false-d2418e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9012-2014-04-03T162820.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAPerformerBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9012-2014-04-03T162820.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16543-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDAPerformerBody): de elementwaarde MOET een zijn van '2.16.840.1.113883.1.11.16543 ParticipationMode (DYNAMISCH)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9012
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity
Item: (CDAPerformerBody)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity"
         id="d2395e27-false-d2458e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9012-2014-04-03T162820.html"
              test="count(hl7:id) &gt;= 1">(CDAPerformerBody): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9012-2014-04-03T162820.html"
              test="count(hl7:code) &lt;= 1">(CDAPerformerBody): element hl7:code komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9012-2014-04-03T162820.html"
              test="count(hl7:addr) &lt;= 1">(CDAPerformerBody): element hl7:addr komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9012-2014-04-03T162820.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDAPerformerBody): element hl7:assignedPerson komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9012-2014-04-03T162820.html"
              test="count(hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]) &lt;= 1">(CDAPerformerBody): element hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9003
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:id
Item: (CDAAssignedEntity)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:id"
         id="d2526e8-false-d2534e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9003-2013-12-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAAssignedEntity): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9003
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:code
Item: (CDAAssignedEntity)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:code"
         id="d2526e10-false-d2547e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9003-2013-12-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAAssignedEntity): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9003
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDAAssignedEntity)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr"
         id="d2526e18-false-d2560e0">
      <extends rule="AD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9003-2013-12-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAAssignedEntity): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9003
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom
Item: (CDAAssignedEntity)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom"
         id="d2526e22-false-d2573e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9003-2013-12-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAAssignedEntity): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9003
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDAAssignedEntity)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson"
         id="d2526e24-false-d2588e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9003-2013-12-22T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDAAssignedEntity): de waarde van classCode MOET 'PSN' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9003-2013-12-22T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDAAssignedEntity): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9001
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDAPerson)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name"
         id="d2613e14-false-d2621e0">
      <extends rule="PN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9001-2013-12-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAPerson): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9003
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]
Item: (CDAAssignedEntity)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]"
         id="d2526e33-false-d2641e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9003-2013-12-22T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDAAssignedEntity): de waarde van classCode MOET 'ORG' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9003-2013-12-22T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDAAssignedEntity): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9003-2013-12-22T000000.html"
              test="count(hl7:id[@root = '2.16.528.1.1007.3.3']) &gt;= 1">(CDAAssignedEntity): element hl7:id[@root = '2.16.528.1.1007.3.3'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9003-2013-12-22T000000.html"
              test="count(hl7:id[@root = '2.16.528.1.1007.3.3']) &lt;= 1">(CDAAssignedEntity): element hl7:id[@root = '2.16.528.1.1007.3.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9003-2013-12-22T000000.html"
              test="count(hl7:name) &gt;= 1">(CDAAssignedEntity): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9003-2013-12-22T000000.html"
              test="count(hl7:name) &lt;= 1">(CDAAssignedEntity): element hl7:name komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9003-2013-12-22T000000.html"
              test="count(hl7:addr) &lt;= 1">(CDAAssignedEntity): element hl7:addr komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9003-2013-12-22T000000.html"
              test="count(hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDAAssignedEntity): element hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:id[@root = '2.16.528.1.1007.3.3']
Item: (CDAOrganization)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:id[@root = '2.16.528.1.1007.3.3']"
         id="d2720e16-false-d2728e0">
      <extends rule="II.NL.URA"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="string(@root) = ('2.16.528.1.1007.3.3')">(CDAOrganization): de waarde van root MOET '2.16.528.1.1007.3.3' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:id
Item: (CDAOrganization)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:id"
         id="d2720e24-false-d2747e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:name
Item: (CDAOrganization)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:name"
         id="d2720e32-false-d2760e0">
      <extends rule="ON"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:telecom
Item: (CDAOrganization)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:telecom"
         id="d2720e36-false-d2773e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:addr
Item: (CDAOrganization)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:addr"
         id="d2720e41-false-d2786e0">
      <extends rule="AD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDAOrganization)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d2720e43-false-d2801e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDAOrganization): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3 OrganisatieTypeCodelijst (DYNAMISCH)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.1
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.2']]]
Item: (gebb-EncounterActivity)
-->
   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.2']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.1-2013-12-31T000000.html"
              test="string(@typeCode) = ('LOC')">(gebb-EncounterActivity): de waarde van typeCode MOET 'LOC' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.1
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3']]]
Item: (gebb-EncounterActivity)
-->
   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.1-2013-12-31T000000.html"
              test="string(@typeCode) = ('RSON')">(gebb-EncounterActivity): de waarde van typeCode MOET 'RSON' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.1
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:entryRelationship[@typeCode = 'COMP']
Item: (gebb-EncounterActivity)
-->
   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:entryRelationship[@typeCode = 'COMP']">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.1-2013-12-31T000000.html"
              test="string(@typeCode) = ('COMP')">(gebb-EncounterActivity): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.4
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.1']]/hl7:entryRelationship[@typeCode = 'COMP']
Item: (gebb-EncounterDiagnosis)
--></pattern>
