<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.11.60.2.10.3
Name: GEBB Indication
Description: Indicatie: reden voor een activiteit, bijvoorbeeld een probleem of een diagnose
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.11.60.2.10.3-2013-01-31T000000">
   <title>GEBB Indication</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.3
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3']]]
Item: (gebb-Indication)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.3
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3']]
Item: (gebb-Indication)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3']]"
         id="d15e3332-false-d3096e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.3-2013-01-31T000000.html"
              test="string(@classCode) = ('OBS')">(gebb-Indication): de waarde van classCode MOET 'OBS' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.3-2013-01-31T000000.html"
              test="string(@moodCode) = ('EVN')">(gebb-Indication): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.3-2013-01-31T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3']) &gt;= 1">(gebb-Indication): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.3-2013-01-31T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3']) &lt;= 1">(gebb-Indication): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.3-2013-01-31T000000.html"
              test="count(hl7:id) &lt;= 1">(gebb-Indication): element hl7:id komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.3-2013-01-31T000000.html"
              test="count(hl7:code[not(@nullFlavor)]) &gt;= 1">(gebb-Indication): element hl7:code[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.3-2013-01-31T000000.html"
              test="count(hl7:code[not(@nullFlavor)]) &lt;= 1">(gebb-Indication): element hl7:code[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.3-2013-01-31T000000.html"
              test="count(hl7:statusCode[@code = 'completed']) &gt;= 1">(gebb-Indication): element hl7:statusCode[@code = 'completed'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.3-2013-01-31T000000.html"
              test="count(hl7:statusCode[@code = 'completed']) &lt;= 1">(gebb-Indication): element hl7:statusCode[@code = 'completed'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.3-2013-01-31T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(gebb-Indication): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.3-2013-01-31T000000.html"
              test="count(hl7:value) &lt;= 1">(gebb-Indication): element hl7:value komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.3
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3']
Item: (gebb-Indication)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3']"
         id="d15e3340-false-d3190e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.3-2013-01-31T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(gebb-Indication): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.3-2013-01-31T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.2.10.3')">(gebb-Indication): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.2.10.3' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.3
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3']]/hl7:id
Item: (gebb-Indication)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.3
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3']]/hl7:code[not(@nullFlavor)]
Item: (gebb-Indication)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.3
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3']]/hl7:statusCode[@code = 'completed']
Item: (gebb-Indication)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3']]/hl7:statusCode[@code = 'completed']"
         id="d15e3359-false-d3227e0">
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.3-2013-01-31T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(gebb-Indication): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.3-2013-01-31T000000.html"
              test="@nullFlavor or (@code='completed')">(gebb-Indication): de elementwaarde MOET een zijn van 'code 'completed''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.3
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3']]/hl7:effectiveTime
Item: (gebb-Indication)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3']]/hl7:effectiveTime"
         id="d15e3364-false-d3247e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.3-2013-01-31T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(gebb-Indication): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.3-2013-01-31T000000.html"
              test="not(*)">(gebb-Indication): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.3
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3']]/hl7:value
Item: (gebb-Indication)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.3']]/hl7:value"
         id="d15e3366-false-d3264e0">
      <extends rule="CD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.3-2013-01-31T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(gebb-Indication): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
</pattern>
