<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.11.60.2.10.5
Name: GEBB Laboratory Observation
Description: 
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000">
   <title>GEBB Laboratory Observation</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.5
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]
Item: (gebb-LaboratoryObservation)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]"
         id="d15e3389-false-d3434e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]) &gt;= 1">(gebb-LaboratoryObservation): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]) &lt;= 1">(gebb-LaboratoryObservation): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.5
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]
Item: (gebb-LaboratoryObservation)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]"
         id="d15e3399-false-d3751e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="string(@classCode) = ('OBS')">(gebb-LaboratoryObservation): de waarde van classCode MOET 'OBS' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="string(@moodCode) = ('EVN')">(gebb-LaboratoryObservation): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']) &gt;= 1">(gebb-LaboratoryObservation): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']) &lt;= 1">(gebb-LaboratoryObservation): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:id) &lt;= 1">(gebb-LaboratoryObservation): element hl7:id komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:code[not(@nullFlavor)]) &gt;= 1">(gebb-LaboratoryObservation): element hl7:code[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:code[not(@nullFlavor)]) &lt;= 1">(gebb-LaboratoryObservation): element hl7:code[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:text) &lt;= 1">(gebb-LaboratoryObservation): element hl7:text komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:statusCode[@code = 'active' or @code = 'completed' or @code = 'aborted' or @nullFlavor]) &gt;= 1">(gebb-LaboratoryObservation): element hl7:statusCode[@code = 'active' or @code = 'completed' or @code = 'aborted' or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:statusCode[@code = 'active' or @code = 'completed' or @code = 'aborted' or @nullFlavor]) &lt;= 1">(gebb-LaboratoryObservation): element hl7:statusCode[@code = 'active' or @code = 'completed' or @code = 'aborted' or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(gebb-LaboratoryObservation): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:value) &lt;= 1">(gebb-LaboratoryObservation): element hl7:value komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:interpretationCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.78-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(gebb-LaboratoryObservation): element hl7:interpretationCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.78-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:methodCode) &lt;= 1">(gebb-LaboratoryObservation): element hl7:methodCode komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:subject[hl7:relatedSubject[@classCode]]) &lt;= 1">(gebb-LaboratoryObservation): element hl7:subject[hl7:relatedSubject[@classCode]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:specimen[hl7:specimenRole]) &lt;= 1">(gebb-LaboratoryObservation): element hl7:specimen[hl7:specimenRole] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:performer[hl7:assignedEntity]) &lt;= 1">(gebb-LaboratoryObservation): element hl7:performer[hl7:assignedEntity] komt te vaak voor [max 1x].</assert>
      <let name="elmcount"
           value="count(hl7:participant[@typeCode='AUTHEN'] | hl7:participant[@typeCode='RESP'] | hl7:participant[@typeCode='DEV'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="$elmcount &lt;= 3">(gebb-LaboratoryObservation): keuze (hl7:participant[@typeCode='AUTHEN']  of  hl7:participant[@typeCode='RESP']  of  hl7:participant[@typeCode='DEV']) bevat te veel elementen [max 3x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:participant[@typeCode='AUTHEN']) &lt;= 1">(gebb-LaboratoryObservation): element hl7:participant[@typeCode='AUTHEN'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:participant[@typeCode='RESP']) &lt;= 1">(gebb-LaboratoryObservation): element hl7:participant[@typeCode='RESP'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:participant[@typeCode='DEV']) &lt;= 1">(gebb-LaboratoryObservation): element hl7:participant[@typeCode='DEV'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:referenceRange[@typeCode = 'REFV'][hl7:observationRange[@classCode = 'OBS'][@moodCode = 'EVN.CRT']]) &lt;= 1">(gebb-LaboratoryObservation): element hl7:referenceRange[@typeCode = 'REFV'][hl7:observationRange[@classCode = 'OBS'][@moodCode = 'EVN.CRT']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.5
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']
Item: (gebb-LaboratoryObservation)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']"
         id="d15e3405-false-d3992e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(gebb-LaboratoryObservation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.2.10.5')">(gebb-LaboratoryObservation): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.2.10.5' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.5
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:id
Item: (gebb-LaboratoryObservation)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:id"
         id="d15e3410-false-d4011e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(gebb-LaboratoryObservation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.5
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:code[not(@nullFlavor)]
Item: (gebb-LaboratoryObservation)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:code[not(@nullFlavor)]"
         id="d15e3416-false-d4024e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(gebb-LaboratoryObservation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.5
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:text
Item: (gebb-LaboratoryObservation)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:text"
         id="d15e3423-false-d4037e0">
      <extends rule="ED"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ED' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(gebb-LaboratoryObservation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ED" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.5
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:statusCode[@code = 'active' or @code = 'completed' or @code = 'aborted' or @nullFlavor]
Item: (gebb-LaboratoryObservation)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:statusCode[@code = 'active' or @code = 'completed' or @code = 'aborted' or @nullFlavor]"
         id="d15e3425-false-d4050e0">
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(gebb-LaboratoryObservation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="@nullFlavor or (@code='active') or (@code='completed') or (@code='aborted')">(gebb-LaboratoryObservation): de elementwaarde MOET een zijn van 'code 'active' of code 'completed' of code 'aborted''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.5
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:effectiveTime
Item: (gebb-LaboratoryObservation)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:effectiveTime"
         id="d15e3446-false-d4074e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(gebb-LaboratoryObservation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="not(*)">(gebb-LaboratoryObservation): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.5
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:value
Item: (gebb-LaboratoryObservation)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:value"
         id="d15e3452-false-d4091e0">
      <extends rule="ANY"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.5
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:interpretationCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.78-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (gebb-LaboratoryObservation)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:interpretationCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.78-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d15e3458-false-d4102e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(gebb-LaboratoryObservation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.78-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(gebb-LaboratoryObservation): de elementwaarde MOET een zijn van '2.16.840.1.113883.1.11.78 ObservationInterpretation (DYNAMISCH)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.5
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:methodCode
Item: (gebb-LaboratoryObservation)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:methodCode"
         id="d15e3466-false-d4126e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(gebb-LaboratoryObservation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.5
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:targetSiteCode
Item: (gebb-LaboratoryObservation)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:targetSiteCode"
         id="d15e3473-false-d4139e0">
      <extends rule="CD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(gebb-LaboratoryObservation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.5
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:subject[hl7:relatedSubject[@classCode]]
Item: (gebb-LaboratoryObservation)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:subject[hl7:relatedSubject[@classCode]]"
         id="d15e3478-false-d4155e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="string(@typeCode) = ('SBJ') or not(@typeCode)">(gebb-LaboratoryObservation): de waarde van typeCode MOET 'SBJ' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(gebb-LaboratoryObservation): de waarde van contextControlCode MOET 'OP' zijn. Gevonden: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(gebb-LaboratoryObservation): element hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:relatedSubject[@classCode]) &gt;= 1">(gebb-LaboratoryObservation): element hl7:relatedSubject[@classCode] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:relatedSubject[@classCode]) &lt;= 1">(gebb-LaboratoryObservation): element hl7:relatedSubject[@classCode] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9010
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:subject[hl7:relatedSubject[@classCode]]/hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDASubjectBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:subject[hl7:relatedSubject[@classCode]]/hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d4202e20-false-d4212e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9010-2014-04-03T155023.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDASubjectBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9010-2014-04-03T155023.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDASubjectBody): de elementwaarde MOET een zijn van '2.16.840.1.113883.1.11.10310 TargetAwareness (DYNAMISCH)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9010
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:subject[hl7:relatedSubject[@classCode]]/hl7:relatedSubject[@classCode]
Item: (CDASubjectBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:subject[hl7:relatedSubject[@classCode]]/hl7:relatedSubject[@classCode]"
         id="d4202e27-false-d4236e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9010-2014-04-03T155023.html"
              test="@classCode">(CDASubjectBody): attribute @classCode MOET aanwezig zijn.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@classCode),'\s'))"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9010-2014-04-03T155023.html"
              test="not(@classCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19368-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDASubjectBody): de waarde van classCode MOET worden gekozen uit waardelijst '2.16.840.1.113883.1.11.19368' x_DocumentSubject (DYNAMISCH).</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9010-2014-04-03T155023.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.19563-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDASubjectBody): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.19563-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9010-2014-04-03T155023.html"
              test="count(hl7:subject) &lt;= 1">(CDASubjectBody): element hl7:subject komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9010
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:subject[hl7:relatedSubject[@classCode]]/hl7:relatedSubject[@classCode]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.19563-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDASubjectBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:subject[hl7:relatedSubject[@classCode]]/hl7:relatedSubject[@classCode]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.19563-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d4202e36-false-d4294e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9010-2014-04-03T155023.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDASubjectBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9010-2014-04-03T155023.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.19563-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDASubjectBody): de elementwaarde MOET een zijn van '2.16.840.1.113883.1.11.19563 PersonalRelationshipRoleType (DYNAMISCH)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9010
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:subject[hl7:relatedSubject[@classCode]]/hl7:relatedSubject[@classCode]/hl7:addr
Item: (CDASubjectBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:subject[hl7:relatedSubject[@classCode]]/hl7:relatedSubject[@classCode]/hl7:addr"
         id="d4202e43-false-d4318e0">
      <extends rule="AD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9010-2014-04-03T155023.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDASubjectBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9010
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:subject[hl7:relatedSubject[@classCode]]/hl7:relatedSubject[@classCode]/hl7:telecom
Item: (CDASubjectBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:subject[hl7:relatedSubject[@classCode]]/hl7:relatedSubject[@classCode]/hl7:telecom"
         id="d4202e45-false-d4331e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9010-2014-04-03T155023.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDASubjectBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9010
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:subject[hl7:relatedSubject[@classCode]]/hl7:relatedSubject[@classCode]/hl7:subject
Item: (CDASubjectBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:subject[hl7:relatedSubject[@classCode]]/hl7:relatedSubject[@classCode]/hl7:subject"
         id="d4202e47-false-d4344e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9010-2014-04-03T155023.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDASubjectBody): de waarde van classCode MOET 'PSN' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9010-2014-04-03T155023.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDASubjectBody): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9010-2014-04-03T155023.html"
              test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDASubjectBody): element hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9010-2014-04-03T155023.html"
              test="count(hl7:birthTime) &lt;= 1">(CDASubjectBody): element hl7:birthTime komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9010
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:subject[hl7:relatedSubject[@classCode]]/hl7:relatedSubject[@classCode]/hl7:subject/hl7:name
Item: (CDASubjectBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:subject[hl7:relatedSubject[@classCode]]/hl7:relatedSubject[@classCode]/hl7:subject/hl7:name"
         id="d4202e53-false-d4389e0">
      <extends rule="PN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9010-2014-04-03T155023.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDASubjectBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9010
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:subject[hl7:relatedSubject[@classCode]]/hl7:relatedSubject[@classCode]/hl7:subject/hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDASubjectBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:subject[hl7:relatedSubject[@classCode]]/hl7:relatedSubject[@classCode]/hl7:subject/hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d4202e55-false-d4404e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9010-2014-04-03T155023.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDASubjectBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9010-2014-04-03T155023.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDASubjectBody): de elementwaarde MOET een zijn van '2.16.840.1.113883.1.11.1 AdministrativeGender (DYNAMISCH)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9010
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:subject[hl7:relatedSubject[@classCode]]/hl7:relatedSubject[@classCode]/hl7:subject/hl7:birthTime
Item: (CDASubjectBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:subject[hl7:relatedSubject[@classCode]]/hl7:relatedSubject[@classCode]/hl7:subject/hl7:birthTime"
         id="d4202e62-false-d4428e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9010-2014-04-03T155023.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDASubjectBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9010-2014-04-03T155023.html"
              test="not(*)">(CDASubjectBody): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.5
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:specimen[hl7:specimenRole]
Item: (gebb-LaboratoryObservation)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:specimen[hl7:specimenRole]"
         id="d15e3488-false-d4447e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="string(@typeCode) = ('SPC') or not(@typeCode)">(gebb-LaboratoryObservation): de waarde van typeCode MOET 'SPC' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:specimenRole) &gt;= 1">(gebb-LaboratoryObservation): element hl7:specimenRole is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:specimenRole) &lt;= 1">(gebb-LaboratoryObservation): element hl7:specimenRole komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9006
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:specimen[hl7:specimenRole]/hl7:specimenRole
Item: (CDASpecimen)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:specimen[hl7:specimenRole]/hl7:specimenRole"
         id="d4477e50-false-d4485e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9006-2014-04-03T151018.html"
              test="string(@classCode) = ('SPEC') or not(@classCode)">(CDASpecimen): de waarde van classCode MOET 'SPEC' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9006-2014-04-03T151018.html"
              test="count(hl7:specimenPlayingEntity) &lt;= 1">(CDASpecimen): element hl7:specimenPlayingEntity komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9006
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:specimen[hl7:specimenRole]/hl7:specimenRole/hl7:id
Item: (CDASpecimen)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:specimen[hl7:specimenRole]/hl7:specimenRole/hl7:id"
         id="d4477e54-false-d4513e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9006-2014-04-03T151018.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDASpecimen): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9006
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:specimen[hl7:specimenRole]/hl7:specimenRole/hl7:specimenPlayingEntity
Item: (CDASpecimen)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:specimen[hl7:specimenRole]/hl7:specimenRole/hl7:specimenPlayingEntity"
         id="d4477e56-false-d4526e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9006-2014-04-03T151018.html"
              test="string(@classCode) = ('ENT') or not(@classCode)">(CDASpecimen): de waarde van classCode MOET 'ENT' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9006-2014-04-03T151018.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDASpecimen): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9006-2014-04-03T151018.html"
              test="count(hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDASpecimen): element hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9006-2014-04-03T151018.html"
              test="count(hl7:desc) &lt;= 1">(CDASpecimen): element hl7:desc komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9006
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:specimen[hl7:specimenRole]/hl7:specimenRole/hl7:specimenPlayingEntity/hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDASpecimen)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:specimen[hl7:specimenRole]/hl7:specimenRole/hl7:specimenPlayingEntity/hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d4477e62-false-d4577e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9006-2014-04-03T151018.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDASpecimen): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9006-2014-04-03T151018.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | completeCodeSystem[@codeSystem=$theCodeSystem]])">(CDASpecimen): de elementwaarde MOET een zijn van '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMISCH)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9006
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:specimen[hl7:specimenRole]/hl7:specimenRole/hl7:specimenPlayingEntity/hl7:quantity
Item: (CDASpecimen)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:specimen[hl7:specimenRole]/hl7:specimenRole/hl7:specimenPlayingEntity/hl7:quantity"
         id="d4477e69-false-d4601e0">
      <extends rule="PQ"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9006-2014-04-03T151018.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PQ' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDASpecimen): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PQ" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9006-2014-04-03T151018.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(CDASpecimen): @value is geen geldig PQ getal <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9006-2014-04-03T151018.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(CDASpecimen): value/@unit (PQ) MOET een geldige UCUM-eenheid zijn (<value-of select="$UCUMtest"/>).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9006
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:specimen[hl7:specimenRole]/hl7:specimenRole/hl7:specimenPlayingEntity/hl7:name
Item: (CDASpecimen)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:specimen[hl7:specimenRole]/hl7:specimenRole/hl7:specimenPlayingEntity/hl7:name"
         id="d4477e71-false-d4621e0">
      <extends rule="PN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9006-2014-04-03T151018.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDASpecimen): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9006
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:specimen[hl7:specimenRole]/hl7:specimenRole/hl7:specimenPlayingEntity/hl7:desc
Item: (CDASpecimen)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:specimen[hl7:specimenRole]/hl7:specimenRole/hl7:specimenPlayingEntity/hl7:desc"
         id="d4477e74-false-d4634e0">
      <extends rule="ED"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9006-2014-04-03T151018.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ED' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDASpecimen): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ED" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.5
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]
Item: (gebb-LaboratoryObservation)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]"
         id="d15e3498-false-d4667e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="string(@typeCode) = ('PRF') or not(@typeCode)">(gebb-LaboratoryObservation): de waarde van typeCode MOET 'PRF' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:time) &lt;= 1">(gebb-LaboratoryObservation): element hl7:time komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:modeCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16543-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(gebb-LaboratoryObservation): element hl7:modeCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16543-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:assignedEntity) &gt;= 1">(gebb-LaboratoryObservation): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:assignedEntity) &lt;= 1">(gebb-LaboratoryObservation): element hl7:assignedEntity komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9012
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]/hl7:time
Item: (CDAPerformerBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]/hl7:time"
         id="d4733e18-false-d4741e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9012-2014-04-03T162820.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAPerformerBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9012
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]/hl7:modeCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16543-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDAPerformerBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]/hl7:modeCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16543-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d4733e20-false-d4756e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9012-2014-04-03T162820.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAPerformerBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9012-2014-04-03T162820.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16543-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDAPerformerBody): de elementwaarde MOET een zijn van '2.16.840.1.113883.1.11.16543 ParticipationMode (DYNAMISCH)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9012
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity
Item: (CDAPerformerBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity"
         id="d4733e27-false-d4796e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9012-2014-04-03T162820.html"
              test="count(hl7:id) &gt;= 1">(CDAPerformerBody): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9012-2014-04-03T162820.html"
              test="count(hl7:code) &lt;= 1">(CDAPerformerBody): element hl7:code komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9012-2014-04-03T162820.html"
              test="count(hl7:addr) &lt;= 1">(CDAPerformerBody): element hl7:addr komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9012-2014-04-03T162820.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDAPerformerBody): element hl7:assignedPerson komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9012-2014-04-03T162820.html"
              test="count(hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]) &lt;= 1">(CDAPerformerBody): element hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9003
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:id
Item: (CDAAssignedEntity)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:id"
         id="d4864e8-false-d4872e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9003-2013-12-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAAssignedEntity): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9003
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:code
Item: (CDAAssignedEntity)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:code"
         id="d4864e10-false-d4885e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9003-2013-12-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAAssignedEntity): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9003
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDAAssignedEntity)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr"
         id="d4864e18-false-d4898e0">
      <extends rule="AD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9003-2013-12-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAAssignedEntity): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9003
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom
Item: (CDAAssignedEntity)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom"
         id="d4864e22-false-d4911e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9003-2013-12-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAAssignedEntity): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9003
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDAAssignedEntity)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson"
         id="d4864e24-false-d4926e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9003-2013-12-22T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDAAssignedEntity): de waarde van classCode MOET 'PSN' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9003-2013-12-22T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDAAssignedEntity): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9001
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDAPerson)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name"
         id="d4951e14-false-d4959e0">
      <extends rule="PN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9001-2013-12-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAPerson): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9003
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]
Item: (CDAAssignedEntity)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]"
         id="d4864e33-false-d4979e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9003-2013-12-22T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDAAssignedEntity): de waarde van classCode MOET 'ORG' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9003-2013-12-22T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDAAssignedEntity): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9003-2013-12-22T000000.html"
              test="count(hl7:id[@root = '2.16.528.1.1007.3.3']) &gt;= 1">(CDAAssignedEntity): element hl7:id[@root = '2.16.528.1.1007.3.3'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9003-2013-12-22T000000.html"
              test="count(hl7:id[@root = '2.16.528.1.1007.3.3']) &lt;= 1">(CDAAssignedEntity): element hl7:id[@root = '2.16.528.1.1007.3.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9003-2013-12-22T000000.html"
              test="count(hl7:name) &gt;= 1">(CDAAssignedEntity): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9003-2013-12-22T000000.html"
              test="count(hl7:name) &lt;= 1">(CDAAssignedEntity): element hl7:name komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9003-2013-12-22T000000.html"
              test="count(hl7:addr) &lt;= 1">(CDAAssignedEntity): element hl7:addr komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9003-2013-12-22T000000.html"
              test="count(hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDAAssignedEntity): element hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:id[@root = '2.16.528.1.1007.3.3']
Item: (CDAOrganization)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:id[@root = '2.16.528.1.1007.3.3']"
         id="d5058e16-false-d5066e0">
      <extends rule="II.NL.URA"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="string(@root) = ('2.16.528.1.1007.3.3')">(CDAOrganization): de waarde van root MOET '2.16.528.1.1007.3.3' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:id
Item: (CDAOrganization)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:id"
         id="d5058e24-false-d5085e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:name
Item: (CDAOrganization)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:name"
         id="d5058e32-false-d5098e0">
      <extends rule="ON"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:telecom
Item: (CDAOrganization)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:telecom"
         id="d5058e36-false-d5111e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:addr
Item: (CDAOrganization)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:addr"
         id="d5058e41-false-d5124e0">
      <extends rule="AD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDAOrganization)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d5058e43-false-d5139e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDAOrganization): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3 OrganisatieTypeCodelijst (DYNAMISCH)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.5
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]
Item: (gebb-LaboratoryObservation)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]"
         id="d15e3508-false-d5174e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(gebb-LaboratoryObservation): de waarde van typeCode MOET 'AUT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(gebb-LaboratoryObservation): de waarde van contextControlCode MOET 'OP' zijn. Gevonden: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:functionCode) &lt;= 1">(gebb-LaboratoryObservation): element hl7:functionCode komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:time) &gt;= 1">(gebb-LaboratoryObservation): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:time) &lt;= 1">(gebb-LaboratoryObservation): element hl7:time komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(gebb-LaboratoryObservation): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(gebb-LaboratoryObservation): element hl7:assignedAuthor komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9011
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:functionCode
Item: (CDAAuthorBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:functionCode"
         id="d5241e14-false-d5249e0">
      <extends rule="CD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9011-2014-04-03T162802.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAAuthorBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9011
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (CDAAuthorBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:time"
         id="d5241e19-false-d5262e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9011-2014-04-03T162802.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAAuthorBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9011-2014-04-03T162802.html"
              test="not(*)">(CDAAuthorBody): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9011
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (CDAAuthorBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor"
         id="d5241e21-false-d5286e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9011-2014-04-03T162802.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDAAuthorBody): de waarde van classCode MOET 'ASSIGNED' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9011-2014-04-03T162802.html"
              test="count(hl7:id) &gt;= 1">(CDAAuthorBody): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9011-2014-04-03T162802.html"
              test="count(hl7:code) &lt;= 1">(CDAAuthorBody): element hl7:code komt te vaak voor [max 1x].</assert>
      <let name="elmcount"
           value="count(hl7:assignedPerson | hl7:assignedAuthoringDevice)"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9011-2014-04-03T162802.html"
              test="$elmcount &lt;= 1">(CDAAuthorBody): keuze (hl7:assignedPerson  of  hl7:assignedAuthoringDevice) bevat te veel elementen [max 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9011-2014-04-03T162802.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDAAuthorBody): element hl7:assignedPerson komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9011-2014-04-03T162802.html"
              test="count(hl7:assignedAuthoringDevice) &lt;= 1">(CDAAuthorBody): element hl7:assignedAuthoringDevice komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9011-2014-04-03T162802.html"
              test="count(hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]) &lt;= 1">(CDAAuthorBody): element hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9011
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (CDAAuthorBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id"
         id="d5241e25-false-d5381e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9011-2014-04-03T162802.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAAuthorBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9011
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:code
Item: (CDAAuthorBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:code"
         id="d5241e27-false-d5394e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9011-2014-04-03T162802.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAAuthorBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9011
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr
Item: (CDAAuthorBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr"
         id="d5241e32-false-d5407e0">
      <extends rule="AD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9011-2014-04-03T162802.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAAuthorBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9011
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:telecom
Item: (CDAAuthorBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:telecom"
         id="d5241e34-false-d5420e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9011-2014-04-03T162802.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAAuthorBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9011
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDAAuthorBody)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9001
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDAPerson)
-->
   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9001-2013-12-22T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDAPerson): de waarde van classCode MOET 'PSN' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9001-2013-12-22T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDAPerson): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9001
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDAPerson)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9011
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice
Item: (CDAAuthorBody)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9008
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice
Item: (CDADevice)
-->
   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="string(@classCode) = ('DEV') or not(@classCode)">(CDADevice): de waarde van classCode MOET 'DEV' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDADevice): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="count(hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDADevice): element hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="count(hl7:manufacturerModelName) &lt;= 1">(CDADevice): element hl7:manufacturerModelName komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="count(hl7:softwareName) &lt;= 1">(CDADevice): element hl7:softwareName komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9008
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDADevice)
-->
   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | completeCodeSystem[@codeSystem=$theCodeSystem]])">(CDADevice): de elementwaarde MOET een zijn van '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMISCH)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9008
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:manufacturerModelName
Item: (CDADevice)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9008
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:softwareName
Item: (CDADevice)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9008
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:asMaintainedEntity[@classCode = 'MNT'][hl7:maintainingPerson]
Item: (CDADevice)
-->
   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:asMaintainedEntity[@classCode = 'MNT'][hl7:maintainingPerson]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="string(@classCode) = ('MNT')">(CDADevice): de waarde van classCode MOET 'MNT' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDADevice): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="count(hl7:maintainingPerson) &gt;= 1">(CDADevice): element hl7:maintainingPerson is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="count(hl7:maintainingPerson) &lt;= 1">(CDADevice): element hl7:maintainingPerson komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9008
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:asMaintainedEntity[@classCode = 'MNT'][hl7:maintainingPerson]/hl7:effectiveTime
Item: (CDADevice)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9008
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:asMaintainedEntity[@classCode = 'MNT'][hl7:maintainingPerson]/hl7:maintainingPerson
Item: (CDADevice)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9001
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:asMaintainedEntity[@classCode = 'MNT'][hl7:maintainingPerson]/hl7:maintainingPerson
Item: (CDAPerson)
-->
   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:asMaintainedEntity[@classCode = 'MNT'][hl7:maintainingPerson]/hl7:maintainingPerson">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9001-2013-12-22T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDAPerson): de waarde van classCode MOET 'PSN' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9001-2013-12-22T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDAPerson): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9001
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:asMaintainedEntity[@classCode = 'MNT'][hl7:maintainingPerson]/hl7:maintainingPerson/hl7:name
Item: (CDAPerson)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9011
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]
Item: (CDAAuthorBody)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]
Item: (CDAOrganization)
-->
   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDAOrganization): de waarde van classCode MOET 'ORG' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDAOrganization): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="count(hl7:id[@root = '2.16.528.1.1007.3.3']) &gt;= 1">(CDAOrganization): element hl7:id[@root = '2.16.528.1.1007.3.3'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="count(hl7:id[@root = '2.16.528.1.1007.3.3']) &lt;= 1">(CDAOrganization): element hl7:id[@root = '2.16.528.1.1007.3.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="count(hl7:name) &gt;= 1">(CDAOrganization): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="count(hl7:name) &lt;= 1">(CDAOrganization): element hl7:name komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="count(hl7:addr) &lt;= 1">(CDAOrganization): element hl7:addr komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="count(hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDAOrganization): element hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:id[@root = '2.16.528.1.1007.3.3']
Item: (CDAOrganization)
-->
   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:id[@root = '2.16.528.1.1007.3.3']">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="string(@root) = ('2.16.528.1.1007.3.3')">(CDAOrganization): de waarde van root MOET '2.16.528.1.1007.3.3' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:id
Item: (CDAOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:name
Item: (CDAOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:telecom
Item: (CDAOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:addr
Item: (CDAOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDAOrganization)
-->
   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDAOrganization): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3 OrganisatieTypeCodelijst (DYNAMISCH)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.5
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']
Item: (gebb-LaboratoryObservation)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']"
         id="d15e3523-false-d5882e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="@typeCode">(gebb-LaboratoryObservation): attribute @typeCode MOET aanwezig zijn.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.10901-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(gebb-LaboratoryObservation): de waarde van typeCode MOET worden gekozen uit waardelijst '2.16.840.1.113883.1.11.10901' ParticipationType (DYNAMISCH).</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="string(@contextControlCode) = ('OP')">(gebb-LaboratoryObservation): de waarde van contextControlCode MOET 'OP' zijn. Gevonden: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="string(@typeCode) = ('AUTHEN')">(gebb-LaboratoryObservation): de waarde van typeCode MOET 'AUTHEN' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:time) &lt;= 1">(gebb-LaboratoryObservation): element hl7:time komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(gebb-LaboratoryObservation): element hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:participantRole) &gt;= 1">(gebb-LaboratoryObservation): element hl7:participantRole is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:participantRole) &lt;= 1">(gebb-LaboratoryObservation): element hl7:participantRole komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:time
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:time"
         id="d5962e25-false-d5970e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d5962e27-false-d5985e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDAParticipantBody): de elementwaarde MOET een zijn van '2.16.840.1.113883.1.11.10310 TargetAwareness (DYNAMISCH)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole"
         id="d5962e34-false-d6014e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="string(@classCode) = ('ROL') or not(@classCode)">(CDAParticipantBody): de waarde van classCode MOET 'ROL' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="count(hl7:code) &lt;= 1">(CDAParticipantBody): element hl7:code komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="count(hl7:scopingEntity) &lt;= 1">(CDAParticipantBody): element hl7:scopingEntity komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:id
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:id"
         id="d5962e38-false-d6085e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:code
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:code"
         id="d5962e40-false-d6098e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:addr
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:addr"
         id="d5962e45-false-d6111e0">
      <extends rule="AD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:telecom
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:telecom"
         id="d5962e47-false-d6124e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:playingDevice
Item: (CDAParticipantBody)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9008
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:playingDevice
Item: (CDADevice)
-->
   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:playingDevice">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="string(@classCode) = ('DEV') or not(@classCode)">(CDADevice): de waarde van classCode MOET 'DEV' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDADevice): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="count(hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDADevice): element hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="count(hl7:manufacturerModelName) &lt;= 1">(CDADevice): element hl7:manufacturerModelName komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="count(hl7:softwareName) &lt;= 1">(CDADevice): element hl7:softwareName komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9008
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:playingDevice/hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDADevice)
-->
   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:playingDevice/hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | completeCodeSystem[@codeSystem=$theCodeSystem]])">(CDADevice): de elementwaarde MOET een zijn van '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMISCH)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9008
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:playingDevice/hl7:manufacturerModelName
Item: (CDADevice)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9008
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:playingDevice/hl7:softwareName
Item: (CDADevice)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9008
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:playingDevice/hl7:asMaintainedEntity[@classCode = 'MNT'][hl7:maintainingPerson]
Item: (CDADevice)
-->
   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:playingDevice/hl7:asMaintainedEntity[@classCode = 'MNT'][hl7:maintainingPerson]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="string(@classCode) = ('MNT')">(CDADevice): de waarde van classCode MOET 'MNT' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDADevice): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="count(hl7:maintainingPerson) &gt;= 1">(CDADevice): element hl7:maintainingPerson is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="count(hl7:maintainingPerson) &lt;= 1">(CDADevice): element hl7:maintainingPerson komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9008
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:playingDevice/hl7:asMaintainedEntity[@classCode = 'MNT'][hl7:maintainingPerson]/hl7:effectiveTime
Item: (CDADevice)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9008
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:playingDevice/hl7:asMaintainedEntity[@classCode = 'MNT'][hl7:maintainingPerson]/hl7:maintainingPerson
Item: (CDADevice)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9001
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:playingDevice/hl7:asMaintainedEntity[@classCode = 'MNT'][hl7:maintainingPerson]/hl7:maintainingPerson
Item: (CDAPerson)
-->
   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:playingDevice/hl7:asMaintainedEntity[@classCode = 'MNT'][hl7:maintainingPerson]/hl7:maintainingPerson">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9001-2013-12-22T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDAPerson): de waarde van classCode MOET 'PSN' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9001-2013-12-22T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDAPerson): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9001
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:playingDevice/hl7:asMaintainedEntity[@classCode = 'MNT'][hl7:maintainingPerson]/hl7:maintainingPerson/hl7:name
Item: (CDAPerson)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:playingEntity
Item: (CDAParticipantBody)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9009
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:playingEntity
Item: (CDAPlayingEntity)
-->
   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:playingEntity">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9009-2014-04-03T154746.html"
              test="string(@classCode) = ('ENT') or not(@classCode)">(CDAPlayingEntity): de waarde van classCode MOET 'ENT' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9009-2014-04-03T154746.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDAPlayingEntity): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9009-2014-04-03T154746.html"
              test="count(hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDAPlayingEntity): element hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9009-2014-04-03T154746.html"
              test="count(hl7:desc) &lt;= 1">(CDAPlayingEntity): element hl7:desc komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9009
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:playingEntity/hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDAPlayingEntity)
-->
   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:playingEntity/hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9009-2014-04-03T154746.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | completeCodeSystem[@codeSystem=$theCodeSystem]])">(CDAPlayingEntity): de elementwaarde MOET een zijn van '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMISCH)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9009
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:playingEntity/hl7:quantity
Item: (CDAPlayingEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9009
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:playingEntity/hl7:name
Item: (CDAPlayingEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9009
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:playingEntity/hl7:desc
Item: (CDAPlayingEntity)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:scopingEntity
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:scopingEntity"
         id="d5962e61-false-d6483e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="string(@classCode) = ('ENT') or not(@classCode)">(CDAParticipantBody): de waarde van classCode MOET 'ENT' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDAParticipantBody): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="count(hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDAParticipantBody): element hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="count(hl7:desc) &lt;= 1">(CDAParticipantBody): element hl7:desc komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:scopingEntity/hl7:id
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:scopingEntity/hl7:id"
         id="d5962e67-false-d6528e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:scopingEntity/hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:scopingEntity/hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d5962e69-false-d6543e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | completeCodeSystem[@codeSystem=$theCodeSystem]])">(CDAParticipantBody): de elementwaarde MOET een zijn van '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMISCH)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:scopingEntity/hl7:desc
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='AUTHEN']/hl7:participantRole/hl7:scopingEntity/hl7:desc"
         id="d5962e76-false-d6567e0">
      <extends rule="ED"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ED' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ED" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.5
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']
Item: (gebb-LaboratoryObservation)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']"
         id="d15e3535-false-d6578e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="@typeCode">(gebb-LaboratoryObservation): attribute @typeCode MOET aanwezig zijn.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.10901-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(gebb-LaboratoryObservation): de waarde van typeCode MOET worden gekozen uit waardelijst '2.16.840.1.113883.1.11.10901' ParticipationType (DYNAMISCH).</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="string(@contextControlCode) = ('OP')">(gebb-LaboratoryObservation): de waarde van contextControlCode MOET 'OP' zijn. Gevonden: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="string(@typeCode) = ('RESP')">(gebb-LaboratoryObservation): de waarde van typeCode MOET 'RESP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:time) &lt;= 1">(gebb-LaboratoryObservation): element hl7:time komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(gebb-LaboratoryObservation): element hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:participantRole) &gt;= 1">(gebb-LaboratoryObservation): element hl7:participantRole is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:participantRole) &lt;= 1">(gebb-LaboratoryObservation): element hl7:participantRole komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:time
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:time"
         id="d6658e25-false-d6666e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d6658e27-false-d6681e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDAParticipantBody): de elementwaarde MOET een zijn van '2.16.840.1.113883.1.11.10310 TargetAwareness (DYNAMISCH)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole"
         id="d6658e34-false-d6710e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="string(@classCode) = ('ROL') or not(@classCode)">(CDAParticipantBody): de waarde van classCode MOET 'ROL' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="count(hl7:code) &lt;= 1">(CDAParticipantBody): element hl7:code komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="count(hl7:scopingEntity) &lt;= 1">(CDAParticipantBody): element hl7:scopingEntity komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:id
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:id"
         id="d6658e38-false-d6781e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:code
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:code"
         id="d6658e40-false-d6794e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:addr
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:addr"
         id="d6658e45-false-d6807e0">
      <extends rule="AD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:telecom
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:telecom"
         id="d6658e47-false-d6820e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:playingDevice
Item: (CDAParticipantBody)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9008
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:playingDevice
Item: (CDADevice)
-->
   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:playingDevice">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="string(@classCode) = ('DEV') or not(@classCode)">(CDADevice): de waarde van classCode MOET 'DEV' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDADevice): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="count(hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDADevice): element hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="count(hl7:manufacturerModelName) &lt;= 1">(CDADevice): element hl7:manufacturerModelName komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="count(hl7:softwareName) &lt;= 1">(CDADevice): element hl7:softwareName komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9008
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:playingDevice/hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDADevice)
-->
   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:playingDevice/hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | completeCodeSystem[@codeSystem=$theCodeSystem]])">(CDADevice): de elementwaarde MOET een zijn van '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMISCH)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9008
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:playingDevice/hl7:manufacturerModelName
Item: (CDADevice)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9008
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:playingDevice/hl7:softwareName
Item: (CDADevice)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9008
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:playingDevice/hl7:asMaintainedEntity[@classCode = 'MNT'][hl7:maintainingPerson]
Item: (CDADevice)
-->
   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:playingDevice/hl7:asMaintainedEntity[@classCode = 'MNT'][hl7:maintainingPerson]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="string(@classCode) = ('MNT')">(CDADevice): de waarde van classCode MOET 'MNT' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDADevice): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="count(hl7:maintainingPerson) &gt;= 1">(CDADevice): element hl7:maintainingPerson is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="count(hl7:maintainingPerson) &lt;= 1">(CDADevice): element hl7:maintainingPerson komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9008
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:playingDevice/hl7:asMaintainedEntity[@classCode = 'MNT'][hl7:maintainingPerson]/hl7:effectiveTime
Item: (CDADevice)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9008
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:playingDevice/hl7:asMaintainedEntity[@classCode = 'MNT'][hl7:maintainingPerson]/hl7:maintainingPerson
Item: (CDADevice)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9001
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:playingDevice/hl7:asMaintainedEntity[@classCode = 'MNT'][hl7:maintainingPerson]/hl7:maintainingPerson
Item: (CDAPerson)
-->
   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:playingDevice/hl7:asMaintainedEntity[@classCode = 'MNT'][hl7:maintainingPerson]/hl7:maintainingPerson">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9001-2013-12-22T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDAPerson): de waarde van classCode MOET 'PSN' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9001-2013-12-22T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDAPerson): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9001
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:playingDevice/hl7:asMaintainedEntity[@classCode = 'MNT'][hl7:maintainingPerson]/hl7:maintainingPerson/hl7:name
Item: (CDAPerson)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:playingEntity
Item: (CDAParticipantBody)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9009
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:playingEntity
Item: (CDAPlayingEntity)
-->
   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:playingEntity">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9009-2014-04-03T154746.html"
              test="string(@classCode) = ('ENT') or not(@classCode)">(CDAPlayingEntity): de waarde van classCode MOET 'ENT' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9009-2014-04-03T154746.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDAPlayingEntity): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9009-2014-04-03T154746.html"
              test="count(hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDAPlayingEntity): element hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9009-2014-04-03T154746.html"
              test="count(hl7:desc) &lt;= 1">(CDAPlayingEntity): element hl7:desc komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9009
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:playingEntity/hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDAPlayingEntity)
-->
   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:playingEntity/hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9009-2014-04-03T154746.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | completeCodeSystem[@codeSystem=$theCodeSystem]])">(CDAPlayingEntity): de elementwaarde MOET een zijn van '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMISCH)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9009
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:playingEntity/hl7:quantity
Item: (CDAPlayingEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9009
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:playingEntity/hl7:name
Item: (CDAPlayingEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9009
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:playingEntity/hl7:desc
Item: (CDAPlayingEntity)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:scopingEntity
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:scopingEntity"
         id="d6658e61-false-d7179e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="string(@classCode) = ('ENT') or not(@classCode)">(CDAParticipantBody): de waarde van classCode MOET 'ENT' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDAParticipantBody): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="count(hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDAParticipantBody): element hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="count(hl7:desc) &lt;= 1">(CDAParticipantBody): element hl7:desc komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:scopingEntity/hl7:id
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:scopingEntity/hl7:id"
         id="d6658e67-false-d7224e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:scopingEntity/hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:scopingEntity/hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d6658e69-false-d7239e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | completeCodeSystem[@codeSystem=$theCodeSystem]])">(CDAParticipantBody): de elementwaarde MOET een zijn van '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMISCH)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:scopingEntity/hl7:desc
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='RESP']/hl7:participantRole/hl7:scopingEntity/hl7:desc"
         id="d6658e76-false-d7263e0">
      <extends rule="ED"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ED' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ED" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.5
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']
Item: (gebb-LaboratoryObservation)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']"
         id="d15e3547-false-d7274e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="@typeCode">(gebb-LaboratoryObservation): attribute @typeCode MOET aanwezig zijn.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.10901-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(gebb-LaboratoryObservation): de waarde van typeCode MOET worden gekozen uit waardelijst '2.16.840.1.113883.1.11.10901' ParticipationType (DYNAMISCH).</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="string(@contextControlCode) = ('OP')">(gebb-LaboratoryObservation): de waarde van contextControlCode MOET 'OP' zijn. Gevonden: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="string(@typeCode) = ('DEV')">(gebb-LaboratoryObservation): de waarde van typeCode MOET 'DEV' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:time) &lt;= 1">(gebb-LaboratoryObservation): element hl7:time komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(gebb-LaboratoryObservation): element hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:participantRole) &gt;= 1">(gebb-LaboratoryObservation): element hl7:participantRole is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="count(hl7:participantRole) &lt;= 1">(gebb-LaboratoryObservation): element hl7:participantRole komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:time
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:time"
         id="d7354e25-false-d7362e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d7354e27-false-d7377e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDAParticipantBody): de elementwaarde MOET een zijn van '2.16.840.1.113883.1.11.10310 TargetAwareness (DYNAMISCH)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole"
         id="d7354e34-false-d7406e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="string(@classCode) = ('ROL') or not(@classCode)">(CDAParticipantBody): de waarde van classCode MOET 'ROL' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="count(hl7:code) &lt;= 1">(CDAParticipantBody): element hl7:code komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="count(hl7:scopingEntity) &lt;= 1">(CDAParticipantBody): element hl7:scopingEntity komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:id
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:id"
         id="d7354e38-false-d7477e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:code
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:code"
         id="d7354e40-false-d7490e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:addr
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:addr"
         id="d7354e45-false-d7503e0">
      <extends rule="AD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:telecom
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:telecom"
         id="d7354e47-false-d7516e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:playingDevice
Item: (CDAParticipantBody)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9008
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:playingDevice
Item: (CDADevice)
-->
   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:playingDevice">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="string(@classCode) = ('DEV') or not(@classCode)">(CDADevice): de waarde van classCode MOET 'DEV' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDADevice): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="count(hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDADevice): element hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="count(hl7:manufacturerModelName) &lt;= 1">(CDADevice): element hl7:manufacturerModelName komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="count(hl7:softwareName) &lt;= 1">(CDADevice): element hl7:softwareName komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9008
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:playingDevice/hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDADevice)
-->
   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:playingDevice/hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | completeCodeSystem[@codeSystem=$theCodeSystem]])">(CDADevice): de elementwaarde MOET een zijn van '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMISCH)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9008
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:playingDevice/hl7:manufacturerModelName
Item: (CDADevice)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9008
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:playingDevice/hl7:softwareName
Item: (CDADevice)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9008
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:playingDevice/hl7:asMaintainedEntity[@classCode = 'MNT'][hl7:maintainingPerson]
Item: (CDADevice)
-->
   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:playingDevice/hl7:asMaintainedEntity[@classCode = 'MNT'][hl7:maintainingPerson]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="string(@classCode) = ('MNT')">(CDADevice): de waarde van classCode MOET 'MNT' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDADevice): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="count(hl7:maintainingPerson) &gt;= 1">(CDADevice): element hl7:maintainingPerson is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9008-2014-04-03T154726.html"
              test="count(hl7:maintainingPerson) &lt;= 1">(CDADevice): element hl7:maintainingPerson komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9008
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:playingDevice/hl7:asMaintainedEntity[@classCode = 'MNT'][hl7:maintainingPerson]/hl7:effectiveTime
Item: (CDADevice)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9008
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:playingDevice/hl7:asMaintainedEntity[@classCode = 'MNT'][hl7:maintainingPerson]/hl7:maintainingPerson
Item: (CDADevice)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9001
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:playingDevice/hl7:asMaintainedEntity[@classCode = 'MNT'][hl7:maintainingPerson]/hl7:maintainingPerson
Item: (CDAPerson)
-->
   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:playingDevice/hl7:asMaintainedEntity[@classCode = 'MNT'][hl7:maintainingPerson]/hl7:maintainingPerson">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9001-2013-12-22T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDAPerson): de waarde van classCode MOET 'PSN' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9001-2013-12-22T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDAPerson): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9001
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:playingDevice/hl7:asMaintainedEntity[@classCode = 'MNT'][hl7:maintainingPerson]/hl7:maintainingPerson/hl7:name
Item: (CDAPerson)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:playingEntity
Item: (CDAParticipantBody)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9009
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:playingEntity
Item: (CDAPlayingEntity)
-->
   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:playingEntity">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9009-2014-04-03T154746.html"
              test="string(@classCode) = ('ENT') or not(@classCode)">(CDAPlayingEntity): de waarde van classCode MOET 'ENT' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9009-2014-04-03T154746.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDAPlayingEntity): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9009-2014-04-03T154746.html"
              test="count(hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDAPlayingEntity): element hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9009-2014-04-03T154746.html"
              test="count(hl7:desc) &lt;= 1">(CDAPlayingEntity): element hl7:desc komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9009
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:playingEntity/hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDAPlayingEntity)
-->
   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:playingEntity/hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9009-2014-04-03T154746.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | completeCodeSystem[@codeSystem=$theCodeSystem]])">(CDAPlayingEntity): de elementwaarde MOET een zijn van '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMISCH)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9009
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:playingEntity/hl7:quantity
Item: (CDAPlayingEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9009
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:playingEntity/hl7:name
Item: (CDAPlayingEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9009
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:playingEntity/hl7:desc
Item: (CDAPlayingEntity)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:scopingEntity
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:scopingEntity"
         id="d7354e61-false-d7875e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="string(@classCode) = ('ENT') or not(@classCode)">(CDAParticipantBody): de waarde van classCode MOET 'ENT' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDAParticipantBody): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="count(hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDAParticipantBody): element hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="count(hl7:desc) &lt;= 1">(CDAParticipantBody): element hl7:desc komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:scopingEntity/hl7:id
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:scopingEntity/hl7:id"
         id="d7354e67-false-d7920e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:scopingEntity/hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:scopingEntity/hl7:code[@codeSystem = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/completeCodeSystem/@codeSystem or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d7354e69-false-d7935e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | completeCodeSystem[@codeSystem=$theCodeSystem]])">(CDAParticipantBody): de elementwaarde MOET een zijn van '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMISCH)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9007
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:scopingEntity/hl7:desc
Item: (CDAParticipantBody)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:participant[@typeCode='DEV']/hl7:participantRole/hl7:scopingEntity/hl7:desc"
         id="d7354e76-false-d7959e0">
      <extends rule="ED"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9007-2014-04-03T152516.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ED' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAParticipantBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ED" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.5
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:entryRelationship[@typeCode='COMP']
Item: (gebb-LaboratoryObservation)
-->
   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:entryRelationship[@typeCode='COMP']">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="string(@typeCode) = ('COMP')">(gebb-LaboratoryObservation): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.2.10.5
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:entryRelationship[@typeCode='REFR']
Item: (gebb-LaboratoryObservation)
-->
   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:entryRelationship[@typeCode='REFR']">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.2.10.5-2014-03-31T000000.html"
              test="string(@typeCode) = ('REFR')">(gebb-LaboratoryObservation): de waarde van typeCode MOET 'REFR' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9005
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:referenceRange[@typeCode = 'REFV'][hl7:observationRange[@classCode = 'OBS'][@moodCode = 'EVN.CRT']]
Item: (CDAObservationReferenceRange)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:referenceRange[@typeCode = 'REFV'][hl7:observationRange[@classCode = 'OBS'][@moodCode = 'EVN.CRT']]"
         id="d8006e6-false-d8014e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9005-2013-12-27T000000.html"
              test="string(@typeCode) = ('REFV')">(CDAObservationReferenceRange): de waarde van typeCode MOET 'REFV' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9005-2013-12-27T000000.html"
              test="count(hl7:observationRange[hl7:interpretationCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.83')]]) &gt;= 1">(CDAObservationReferenceRange): element hl7:observationRange[hl7:interpretationCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.83')]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9005-2013-12-27T000000.html"
              test="count(hl7:observationRange[hl7:interpretationCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.83')]]) &lt;= 1">(CDAObservationReferenceRange): element hl7:observationRange[hl7:interpretationCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.83')]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9005
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:referenceRange[@typeCode = 'REFV'][hl7:observationRange[@classCode = 'OBS'][@moodCode = 'EVN.CRT']]/hl7:observationRange[hl7:interpretationCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.83')]]
Item: (CDAObservationReferenceRange)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:referenceRange[@typeCode = 'REFV'][hl7:observationRange[@classCode = 'OBS'][@moodCode = 'EVN.CRT']]/hl7:observationRange[hl7:interpretationCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.83')]]"
         id="d8006e58-false-d8044e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9005-2013-12-27T000000.html"
              test="string(@classCode) = ('OBS')">(CDAObservationReferenceRange): de waarde van classCode MOET 'OBS' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9005-2013-12-27T000000.html"
              test="string(@moodCode) = ('EVN.CRT')">(CDAObservationReferenceRange): de waarde van moodCode MOET 'EVN.CRT' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9005-2013-12-27T000000.html"
              test="count(hl7:code) = 0">(CDAObservationReferenceRange): element hl7:code MAG NIET voorkomen.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9005-2013-12-27T000000.html"
              test="count(hl7:text) &lt;= 1">(CDAObservationReferenceRange): element hl7:text komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9005-2013-12-27T000000.html"
              test="count(hl7:value) &lt;= 1">(CDAObservationReferenceRange): element hl7:value komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9005-2013-12-27T000000.html"
              test="count(hl7:interpretationCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.83')]) &gt;= 1">(CDAObservationReferenceRange): element hl7:interpretationCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.83')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9005-2013-12-27T000000.html"
              test="count(hl7:interpretationCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.83')]) &lt;= 1">(CDAObservationReferenceRange): element hl7:interpretationCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.83')] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9005
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:referenceRange[@typeCode = 'REFV'][hl7:observationRange[@classCode = 'OBS'][@moodCode = 'EVN.CRT']]/hl7:observationRange[hl7:interpretationCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.83')]]/hl7:code
Item: (CDAObservationReferenceRange)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9005
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:referenceRange[@typeCode = 'REFV'][hl7:observationRange[@classCode = 'OBS'][@moodCode = 'EVN.CRT']]/hl7:observationRange[hl7:interpretationCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.83')]]/hl7:text
Item: (CDAObservationReferenceRange)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:referenceRange[@typeCode = 'REFV'][hl7:observationRange[@classCode = 'OBS'][@moodCode = 'EVN.CRT']]/hl7:observationRange[hl7:interpretationCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.83')]]/hl7:text"
         id="d8006e68-false-d8115e0">
      <extends rule="ED"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9005-2013-12-27T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ED' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAObservationReferenceRange): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ED" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9005
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:referenceRange[@typeCode = 'REFV'][hl7:observationRange[@classCode = 'OBS'][@moodCode = 'EVN.CRT']]/hl7:observationRange[hl7:interpretationCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.83')]]/hl7:value
Item: (CDAObservationReferenceRange)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:referenceRange[@typeCode = 'REFV'][hl7:observationRange[@classCode = 'OBS'][@moodCode = 'EVN.CRT']]/hl7:observationRange[hl7:interpretationCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.83')]]/hl7:value"
         id="d8006e73-false-d8128e0">
      <extends rule="IVL_PQ"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9005-2013-12-27T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_PQ' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAObservationReferenceRange): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_PQ" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9005-2013-12-27T000000.html"
              test="not(hl7:low/@value) or matches(string(hl7:low/@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(CDAObservationReferenceRange): value/low @value is not a valid PQ number<value-of select="hl7:low/@value"/>
      </assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9005-2013-12-27T000000.html"
              test="not(hl7:high/@value) or matches(string(hl7:high/@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(CDAObservationReferenceRange): value/high @value is not a valid PQ number<value-of select="hl7:high/@value"/>
      </assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9005-2013-12-27T000000.html"
              test="not(hl7:center/@value) or matches(string(hl7:center/@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(CDAObservationReferenceRange): value/center @value is not a valid PQ number<value-of select="hl7:center/@value"/>
      </assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9005-2013-12-27T000000.html"
              test="count(hl7:low) &gt;= 1">(CDAObservationReferenceRange): element hl7:low is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9005-2013-12-27T000000.html"
              test="count(hl7:low) &lt;= 1">(CDAObservationReferenceRange): element hl7:low komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9005-2013-12-27T000000.html"
              test="count(hl7:high) &gt;= 1">(CDAObservationReferenceRange): element hl7:high is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9005-2013-12-27T000000.html"
              test="count(hl7:high) &lt;= 1">(CDAObservationReferenceRange): element hl7:high komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9005
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:referenceRange[@typeCode = 'REFV'][hl7:observationRange[@classCode = 'OBS'][@moodCode = 'EVN.CRT']]/hl7:observationRange[hl7:interpretationCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.83')]]/hl7:value/hl7:low
Item: (CDAObservationReferenceRange)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:referenceRange[@typeCode = 'REFV'][hl7:observationRange[@classCode = 'OBS'][@moodCode = 'EVN.CRT']]/hl7:observationRange[hl7:interpretationCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.83')]]/hl7:value/hl7:low"
         id="d8006e75-false-d8183e0">
      <extends rule="PQ"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9005-2013-12-27T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PQ' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAObservationReferenceRange): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PQ" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9005-2013-12-27T000000.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(CDAObservationReferenceRange): @value is geen geldig PQ getal <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9005-2013-12-27T000000.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(CDAObservationReferenceRange): value/@unit (PQ) MOET een geldige UCUM-eenheid zijn (<value-of select="$UCUMtest"/>).</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9005-2013-12-27T000000.html"
              test="not(@nullFlavor) or (string-length(@nullFlavor) &gt; 0 and not(matches(@nullFlavor,'\s')))">(CDAObservationReferenceRange): attribuut @nullFlavor MOET datatype 'cs' hebben  - '<value-of select="@nullFlavor"/>'</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9005-2013-12-27T000000.html"
              test="not(@nullFlavor='PINF')">(CDAObservationReferenceRange): NullFlavor PINF is geen geldige ondergrens omdat deze altijd boven de bovengrens zou liggen</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9005
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:referenceRange[@typeCode = 'REFV'][hl7:observationRange[@classCode = 'OBS'][@moodCode = 'EVN.CRT']]/hl7:observationRange[hl7:interpretationCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.83')]]/hl7:value/hl7:high
Item: (CDAObservationReferenceRange)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:referenceRange[@typeCode = 'REFV'][hl7:observationRange[@classCode = 'OBS'][@moodCode = 'EVN.CRT']]/hl7:observationRange[hl7:interpretationCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.83')]]/hl7:value/hl7:high"
         id="d8006e99-false-d8211e0">
      <extends rule="PQ"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9005-2013-12-27T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PQ' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAObservationReferenceRange): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PQ" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9005-2013-12-27T000000.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(CDAObservationReferenceRange): @value is geen geldig PQ getal <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9005-2013-12-27T000000.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(CDAObservationReferenceRange): value/@unit (PQ) MOET een geldige UCUM-eenheid zijn (<value-of select="$UCUMtest"/>).</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9005-2013-12-27T000000.html"
              test="not(@nullFlavor) or (string-length(@nullFlavor) &gt; 0 and not(matches(@nullFlavor,'\s')))">(CDAObservationReferenceRange): attribuut @nullFlavor MOET datatype 'cs' hebben  - '<value-of select="@nullFlavor"/>'</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9005-2013-12-27T000000.html"
              test="not(@nullFlavor='NINF')">(CDAObservationReferenceRange): NullFlavor NINF is geen geldige bovengrens omdat deze altijd onder de ondergrens zou liggen</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9005
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:referenceRange[@typeCode = 'REFV'][hl7:observationRange[@classCode = 'OBS'][@moodCode = 'EVN.CRT']]/hl7:observationRange[hl7:interpretationCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.83')]]/hl7:interpretationCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.83')]
Item: (CDAObservationReferenceRange)
-->

   <rule context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.2.10.5']]/hl7:referenceRange[@typeCode = 'REFV'][hl7:observationRange[@classCode = 'OBS'][@moodCode = 'EVN.CRT']]/hl7:observationRange[hl7:interpretationCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.83')]]/hl7:interpretationCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.83')]"
         id="d8006e126-false-d8239e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9005-2013-12-27T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAObservationReferenceRange): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9005-2013-12-27T000000.html"
              test="@nullFlavor or (@code='N' and @codeSystem='2.16.840.1.113883.5.83')">(CDAObservationReferenceRange): de elementwaarde MOET een zijn van 'code 'N' codeSystem '2.16.840.1.113883.5.83''.</assert>
   </rule>
</pattern>
