<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.116
Name: Medication Information
Description: Template Medication Information
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.11.60.20.77.10.116-2013-12-21T000000">
   <title>Medication Information</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.116
Context: *[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]]
Item: (MedicationInformation)
-->

   <rule context="*[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]]"
         id="d15e3810-false-d10068e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.116-2013-12-21T000000.html"
              test="count(hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]) &gt;= 1">(MedicationInformation): element hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.116-2013-12-21T000000.html"
              test="count(hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]) &lt;= 1">(MedicationInformation): element hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.116
Context: *[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]
Item: (MedicationInformation)
-->

   <rule context="*[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]"
         id="d15e3835-false-d10093e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.116-2013-12-21T000000.html"
              test="string(@classCode) = ('MANU')">(MedicationInformation): de waarde van classCode MOET 'MANU' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.116-2013-12-21T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']) &gt;= 1">(MedicationInformation): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.116-2013-12-21T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']) &lt;= 1">(MedicationInformation): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.116-2013-12-21T000000.html"
              test="count(hl7:manufacturedMaterial[@classCode = 'MMAT'][@determinerCode = 'KIND']) &gt;= 1">(MedicationInformation): element hl7:manufacturedMaterial[@classCode = 'MMAT'][@determinerCode = 'KIND'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.116-2013-12-21T000000.html"
              test="count(hl7:manufacturedMaterial[@classCode = 'MMAT'][@determinerCode = 'KIND']) &lt;= 1">(MedicationInformation): element hl7:manufacturedMaterial[@classCode = 'MMAT'][@determinerCode = 'KIND'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.116
Context: *[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']
Item: (MedicationInformation)
-->

   <rule context="*[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']"
         id="d15e3841-false-d10139e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.116-2013-12-21T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MedicationInformation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.116-2013-12-21T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.20.77.10.116')">(MedicationInformation): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.20.77.10.116' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.116
Context: *[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]/hl7:manufacturedMaterial[@classCode = 'MMAT'][@determinerCode = 'KIND']
Item: (MedicationInformation)
-->

   <rule context="*[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]/hl7:manufacturedMaterial[@classCode = 'MMAT'][@determinerCode = 'KIND']"
         id="d15e3846-false-d10159e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.116-2013-12-21T000000.html"
              test="string(@classCode) = ('MMAT')">(MedicationInformation): de waarde van classCode MOET 'MMAT' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.116-2013-12-21T000000.html"
              test="string(@determinerCode) = ('KIND')">(MedicationInformation): de waarde van determinerCode MOET 'KIND' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <let name="elmcount" value="count(hl7:code[@code] | hl7:code[@nullFlavor])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.116-2013-12-21T000000.html"
              test="$elmcount &gt;= 1">(MedicationInformation): keuze (hl7:code[@code]  of  hl7:code[@nullFlavor]) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.116-2013-12-21T000000.html"
              test="$elmcount &lt;= 1">(MedicationInformation): keuze (hl7:code[@code]  of  hl7:code[@nullFlavor]) bevat te veel elementen [max 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.116-2013-12-21T000000.html"
              test="count(hl7:code[@code]) &lt;= 1">(MedicationInformation): element hl7:code[@code] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.116-2013-12-21T000000.html"
              test="count(hl7:code[@nullFlavor]) &lt;= 1">(MedicationInformation): element hl7:code[@nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.116-2013-12-21T000000.html"
              test="count(hl7:name) &lt;= 1">(MedicationInformation): element hl7:name komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.116-2013-12-21T000000.html"
              test="count(pharm:desc) &lt;= 1">(MedicationInformation): element pharm:desc komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.116-2013-12-21T000000.html"
              test="count(pharm:formCode) &lt;= 1">(MedicationInformation): element pharm:formCode komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.116-2013-12-21T000000.html"
              test="count(hl7:lotNumberText) &lt;= 1">(MedicationInformation): element hl7:lotNumberText komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9005
Context: *[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]/hl7:manufacturedMaterial[@classCode = 'MMAT'][@determinerCode = 'KIND']
Item: (MedicationCode)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9005
Context: *[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]/hl7:manufacturedMaterial[@classCode = 'MMAT'][@determinerCode = 'KIND']/hl7:code[@code]
Item: (MedicationCode)
-->

   <rule context="*[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]/hl7:manufacturedMaterial[@classCode = 'MMAT'][@determinerCode = 'KIND']/hl7:code[@code]"
         id="d10244e14-false-d10253e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9005-2013-05-21T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MedicationCode): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9005-2013-05-21T000000.html"
              test="@nullFlavor or (@codeSystem='2.16.840.1.113883.2.4.4.1') or (@codeSystem='2.16.840.1.113883.2.4.4.7') or (@codeSystem='2.16.840.1.113883.2.4.4.8') or (@codeSystem='2.16.840.1.113883.2.4.4.10')">(MedicationCode): de elementwaarde MOET een zijn van 'codeSystem '2.16.840.1.113883.2.4.4.1' of codeSystem '2.16.840.1.113883.2.4.4.7' of codeSystem '2.16.840.1.113883.2.4.4.8' of codeSystem '2.16.840.1.113883.2.4.4.10''.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9005-2013-05-21T000000.html"
              test="(@code and @displayName) or not(@code)">(MedicationCode): Medicatiecode moet attribuut @displayName hebben tenzij er geen code is</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9005-2013-05-21T000000.html"
              test="not(hl7:translation/@codeSystem=@codeSystem)">(MedicationCode): Medicatiecode kan geen translation hebben uit hetzelfde codesysteem</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9005-2013-05-21T000000.html"
              test="not(hl7:translation/@codeSystem='2.16.840.1.113883.2.4.4.10') or (hl7:translation/@codeSystem='2.16.840.1.113883.2.4.4.10' and @codeSystem!='2.16.840.1.113883.2.4.4.1')">(MedicationCode): Eventuele translation elementen moeten equivalente of meer algemene alternatieve coderingen bevatten. GPK kan dus niet vertaald worden naar PRK.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9005-2013-05-21T000000.html"
              test="not(hl7:translation/@codeSystem='2.16.840.1.113883.2.4.4.7') or (hl7:translation/@codeSystem='2.16.840.1.113883.2.4.4.7' and @codeSystem='2.16.840.1.113883.2.4.4.8')">(MedicationCode): Eventuele translation elementen moeten equivalente of meer algemene alternatieve coderingen bevatten. Alleen artikelnummer kan dus vertaald worden naar HPK.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9005-2013-05-21T000000.html"
              test="not(hl7:translation/@codeSystem='2.16.840.1.113883.2.4.4.8')">(MedicationCode): Eventuele translation elementen moeten equivalente of meer algemene alternatieve coderingen bevatten. Er kan geen vertaling zijn naar artikelnummer.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9005-2013-05-21T000000.html"
              test="not(hl7:originalText)">(MedicationCode): Bij gecodeerde medicatie mag originalText geen waarde hebben</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9005
Context: *[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]/hl7:manufacturedMaterial[@classCode = 'MMAT'][@determinerCode = 'KIND']/hl7:code[@code]/hl7:translation
Item: (MedicationCode)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9005
Context: *[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]/hl7:manufacturedMaterial[@classCode = 'MMAT'][@determinerCode = 'KIND']/hl7:code[@nullFlavor]
Item: (MedicationCode)
-->

   <rule context="*[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]/hl7:manufacturedMaterial[@classCode = 'MMAT'][@determinerCode = 'KIND']/hl7:code[@nullFlavor]"
         id="d10244e69-false-d10290e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9005-2013-05-21T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MedicationCode): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9005-2013-05-21T000000.html"
              test="string(@nullFlavor) = ('OTH')">(MedicationCode): de waarde van nullFlavor MOET 'OTH' zijn. Gevonden: "<value-of select="@nullFlavor"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9005-2013-05-21T000000.html"
              test="not(@nullFlavor) or @nullFlavor='OTH'">(MedicationCode): Bij niet gecodeerde medicatie moet @nullFlavor 'OTH' bevatten</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9005-2013-05-21T000000.html"
              test="count(hl7:originalText[not(@nullFlavor)]) &gt;= 1">(MedicationCode): element hl7:originalText[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9005-2013-05-21T000000.html"
              test="count(hl7:originalText[not(@nullFlavor)]) &lt;= 1">(MedicationCode): element hl7:originalText[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.9005
Context: *[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]/hl7:manufacturedMaterial[@classCode = 'MMAT'][@determinerCode = 'KIND']/hl7:code[@nullFlavor]/hl7:originalText[not(@nullFlavor)]
Item: (MedicationCode)
-->

   <rule context="*[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]/hl7:manufacturedMaterial[@classCode = 'MMAT'][@determinerCode = 'KIND']/hl7:code[@nullFlavor]/hl7:originalText[not(@nullFlavor)]"
         id="d10244e76-false-d10324e0">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.9005-2013-05-21T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ST' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MedicationCode): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.116
Context: *[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]/hl7:manufacturedMaterial[@classCode = 'MMAT'][@determinerCode = 'KIND']/hl7:name
Item: (MedicationInformation)
-->

   <rule context="*[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]/hl7:manufacturedMaterial[@classCode = 'MMAT'][@determinerCode = 'KIND']/hl7:name"
         id="d15e3911-false-d10337e0">
      <extends rule="EN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.116-2013-12-21T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='EN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MedicationInformation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:EN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.116
Context: *[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]/hl7:manufacturedMaterial[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:desc
Item: (MedicationInformation)
-->

   <rule context="*[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]/hl7:manufacturedMaterial[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:desc"
         id="d15e3914-false-d10350e0">
      <extends rule="ED"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.116-2013-12-21T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ED' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MedicationInformation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ED" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.116
Context: *[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]/hl7:manufacturedMaterial[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:formCode
Item: (MedicationInformation)
-->

   <rule context="*[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]/hl7:manufacturedMaterial[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:formCode"
         id="d15e3916-false-d10363e0">
      <extends rule="CD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.116-2013-12-21T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MedicationInformation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.20.77.10.116
Context: *[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]/hl7:manufacturedMaterial[@classCode = 'MMAT'][@determinerCode = 'KIND']/hl7:lotNumberText
Item: (MedicationInformation)
-->

   <rule context="*[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.116']]/hl7:manufacturedMaterial[@classCode = 'MMAT'][@determinerCode = 'KIND']/hl7:lotNumberText"
         id="d15e3918-false-d10376e0">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.20.77.10.116-2013-12-21T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ST' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MedicationInformation): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
</pattern>
