<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.11.60.66.10.11
Name: VZVZ Opvragen Medicatievoorschriften
Description: Opvragen Medicatievoorschriften 
                 Verdere informatie 
            
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000">
   <title>VZVZ Opvragen Medicatievoorschriften</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.11
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]
Item: (opvragenVoorschriftenLijst)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]"
         id="d15e15838-false-d81129e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="count(hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]) &gt;= 1">(opvragenVoorschriftenLijst): element hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="count(hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]) &lt;= 1">(opvragenVoorschriftenLijst): element hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9022
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:attentionLine[hl7:keyWordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1']]
Item: (AttentionLineContextCode)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:attentionLine[hl7:keyWordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1']]"
         id="d81159e15-false-d81165e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="count(hl7:keyWordText[(@code = 'CONTEXT' and @codeSystem = '2.16.840.1.113883.2.4.15.1') or @nullFlavor]) &gt;= 1">(AttentionLineContextCode): element hl7:keyWordText[(@code = 'CONTEXT' and @codeSystem = '2.16.840.1.113883.2.4.15.1') or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="count(hl7:keyWordText[(@code = 'CONTEXT' and @codeSystem = '2.16.840.1.113883.2.4.15.1') or @nullFlavor]) &lt;= 1">(AttentionLineContextCode): element hl7:keyWordText[(@code = 'CONTEXT' and @codeSystem = '2.16.840.1.113883.2.4.15.1') or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.116-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(AttentionLineContextCode): element hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.116-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.116-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(AttentionLineContextCode): element hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.116-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9022
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:attentionLine[hl7:keyWordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1']]/hl7:keyWordText[(@code = 'CONTEXT' and @codeSystem = '2.16.840.1.113883.2.4.15.1') or @nullFlavor]
Item: (AttentionLineContextCode)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:attentionLine[hl7:keyWordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1']]/hl7:keyWordText[(@code = 'CONTEXT' and @codeSystem = '2.16.840.1.113883.2.4.15.1') or @nullFlavor]"
         id="d81159e17-false-d81206e0">
      <extends rule="SC"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='SC' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(AttentionLineContextCode): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:SC" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="@nullFlavor or not(@code) or (@code='CONTEXT' and @codeSystem='2.16.840.1.113883.2.4.15.1')">(AttentionLineContextCode): de elementwaarde MOET een zijn van 'code 'CONTEXT' codeSystem '2.16.840.1.113883.2.4.15.1''.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="text()='ContextCode'">(AttentionLineContextCode): de elementinhoud van hl7:keyWordText[(@code = 'CONTEXT' and @codeSystem = '2.16.840.1.113883.2.4.15.1') or @nullFlavor] MOET ''ContextCode'' zijn. Gevonden: "<value-of select="."/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9022
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:attentionLine[hl7:keyWordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.116-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (AttentionLineContextCode)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:attentionLine[hl7:keyWordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.116-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d81159e25-false-d81234e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(AttentionLineContextCode): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9022-2014-09-10T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.66.11.116-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(AttentionLineContextCode): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.66.11.116 AORTA Context Code (DYNAMISCH)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.11
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]
Item: (opvragenVoorschriftenLijst)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]"
         id="d15e15844-false-d81262e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="string(@moodCode) = ('EVN')">(opvragenVoorschriftenLijst): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.1.18' or @nullFlavor]) &lt;= 1">(opvragenVoorschriftenLijst): element hl7:code[@codeSystem = '2.16.840.1.113883.1.18' or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(opvragenVoorschriftenLijst): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="count(hl7:overseer[hl7:assignedEntity]) &gt;= 1">(opvragenVoorschriftenLijst): element hl7:overseer[hl7:assignedEntity] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="count(hl7:overseer[hl7:assignedEntity]) &lt;= 1">(opvragenVoorschriftenLijst): element hl7:overseer[hl7:assignedEntity] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="count(hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]) &gt;= 1">(opvragenVoorschriftenLijst): element hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="count(hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]) &lt;= 1">(opvragenVoorschriftenLijst): element hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.11
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:code[@codeSystem = '2.16.840.1.113883.1.18' or @nullFlavor]
Item: (opvragenVoorschriftenLijst)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:code[@codeSystem = '2.16.840.1.113883.1.18' or @nullFlavor]"
         id="d15e15848-false-d81333e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenVoorschriftenLijst): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="@nullFlavor or (@codeSystem='2.16.840.1.113883.1.18')">(opvragenVoorschriftenLijst): de elementwaarde MOET een zijn van 'codeSystem '2.16.840.1.113883.1.18''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.11
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:effectiveTime
Item: (opvragenVoorschriftenLijst)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:effectiveTime"
         id="d15e15856-false-d81353e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenVoorschriftenLijst): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="not(*)">(opvragenVoorschriftenLijst): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:overseer[hl7:assignedEntity]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:overseer[hl7:assignedEntity]"
         id="d81364e4-false-d81372e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="string(@typeCode) = ('RESP') or not(@typeCode)">(ControlActOverseerPerson): de waarde van typeCode MOET 'RESP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]) &gt;= 1">(ControlActOverseerPerson): element hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]) &lt;= 1">(ControlActOverseerPerson): element hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]"
         id="d81364e67-false-d81402e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:id[@root = '2.16.528.1.1007.3.1']) &gt;= 1">(ControlActOverseerPerson): element hl7:id[@root = '2.16.528.1.1007.3.1'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:id[@root = '2.16.528.1.1007.3.1']) &lt;= 1">(ControlActOverseerPerson): element hl7:id[@root = '2.16.528.1.1007.3.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:code[not(@nullFlavor)]) &gt;= 1">(ControlActOverseerPerson): element hl7:code[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:code[not(@nullFlavor)]) &lt;= 1">(ControlActOverseerPerson): element hl7:code[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson]) &gt;= 1">(ControlActOverseerPerson): element hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson]) &lt;= 1">(ControlActOverseerPerson): element hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:Organization[not(@nullFlavor)]) &gt;= 1">(ControlActOverseerPerson): element hl7:Organization[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:Organization[not(@nullFlavor)]) &lt;= 1">(ControlActOverseerPerson): element hl7:Organization[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:id[@root = '2.16.528.1.1007.3.1']
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:id[@root = '2.16.528.1.1007.3.1']"
         id="d81364e69-false-d81471e0">
      <extends rule="II.NL.UZI"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ControlActOverseerPerson): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="string(@root) = ('2.16.528.1.1007.3.1')">(ControlActOverseerPerson): de waarde van root MOET '2.16.528.1.1007.3.1' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:code[not(@nullFlavor)]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:code[not(@nullFlavor)]"
         id="d81364e77-false-d81490e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ControlActOverseerPerson): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="@codeSystem='2.16.840.1.113883.2.4.15.111' and not(@code='00.000')">(ControlActOverseerPerson): Control Act: / moet een UZI-register rolcode bevatten en deze mag niet 00.000 zijn</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson]"
         id="d81364e86-false-d81503e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:assignedPerson[not(@nullFlavor)]) &gt;= 1">(ControlActOverseerPerson): element hl7:assignedPerson[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:assignedPerson[not(@nullFlavor)]) &lt;= 1">(ControlActOverseerPerson): element hl7:assignedPerson[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]"
         id="d81364e88-false-d81527e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(ControlActOverseerPerson): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(ControlActOverseerPerson): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:assignedPrincipalChoiceList[not(@nullFlavor)][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]"
         id="d81364e93-false-d81551e0">
      <extends rule="PN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ControlActOverseerPerson): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]"
         id="d81364e101-false-d81564e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(ControlActOverseerPerson): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(ControlActOverseerPerson): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor]) &lt;= 1">(ControlActOverseerPerson): element hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(ControlActOverseerPerson): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(ControlActOverseerPerson): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:addr[not(@nullFlavor)]) &gt;= 1">(ControlActOverseerPerson): element hl7:addr[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="count(hl7:addr[not(@nullFlavor)]) &lt;= 1">(ControlActOverseerPerson): element hl7:addr[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]"
         id="d81364e106-false-d81627e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ControlActOverseerPerson): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="@root='2.16.528.1.1007.3.3' and @extension">(ControlActOverseerPerson): Control Act: / moet een URA bevatten</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]/hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]/hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor]"
         id="d81364e115-false-d81640e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ControlActOverseerPerson): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="@nullFlavor or (@codeSystem='2.16.840.1.113883.2.4.15.1060')">(ControlActOverseerPerson): de elementwaarde MOET een zijn van 'codeSystem '2.16.840.1.113883.2.4.15.1060''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]"
         id="d81364e123-false-d81660e0">
      <extends rule="ON"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ControlActOverseerPerson): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9023
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]/hl7:addr[not(@nullFlavor)]
Item: (ControlActOverseerPerson)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:overseer[hl7:assignedEntity]/hl7:assignedEntity[hl7:id[@root = '2.16.528.1.1007.3.1']]/hl7:Organization[not(@nullFlavor)]/hl7:addr[not(@nullFlavor)]"
         id="d81364e129-false-d81673e0">
      <extends rule="AD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(ControlActOverseerPerson): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9023-2014-09-22T000000.html"
              test="hl7:city">(ControlActOverseerPerson): Control Act: / moet tenminste de vestigingsplaats bevatten</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.11
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]
Item: (opvragenVoorschriftenLijst)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]"
         id="d15e15867-false-d81688e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']) &gt;= 1">(opvragenVoorschriftenLijst): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']) &lt;= 1">(opvragenVoorschriftenLijst): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="count(hl7:queryId[not(@nullFlavor)]) &gt;= 1">(opvragenVoorschriftenLijst): element hl7:queryId[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="count(hl7:queryId[not(@nullFlavor)]) &lt;= 1">(opvragenVoorschriftenLijst): element hl7:queryId[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="count(hl7:statusCode[@code = 'executing']) &gt;= 1">(opvragenVoorschriftenLijst): element hl7:statusCode[@code = 'executing'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="count(hl7:statusCode[@code = 'executing']) &lt;= 1">(opvragenVoorschriftenLijst): element hl7:statusCode[@code = 'executing'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="count(hl7:responseModalityCode[@code = 'R']) &gt;= 1">(opvragenVoorschriftenLijst): element hl7:responseModalityCode[@code = 'R'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="count(hl7:responseModalityCode[@code = 'R']) &lt;= 1">(opvragenVoorschriftenLijst): element hl7:responseModalityCode[@code = 'R'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="count(hl7:responsePriorityCode[@code = 'I']) &gt;= 1">(opvragenVoorschriftenLijst): element hl7:responsePriorityCode[@code = 'I'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="count(hl7:responsePriorityCode[@code = 'I']) &lt;= 1">(opvragenVoorschriftenLijst): element hl7:responsePriorityCode[@code = 'I'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="count(hl7:executionAndDeliveryTime[not(@nullFlavor)]) &gt;= 1">(opvragenVoorschriftenLijst): element hl7:executionAndDeliveryTime[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="count(hl7:executionAndDeliveryTime[not(@nullFlavor)]) &lt;= 1">(opvragenVoorschriftenLijst): element hl7:executionAndDeliveryTime[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="count(hl7:administrationRequestEffectiveTimeInterval) &lt;= 1">(opvragenVoorschriftenLijst): element hl7:administrationRequestEffectiveTimeInterval komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="count(hl7:medicationCode) &lt;= 1">(opvragenVoorschriftenLijst): element hl7:medicationCode komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="count(hl7:medicationCombinedOrderID) &lt;= 1">(opvragenVoorschriftenLijst): element hl7:medicationCombinedOrderID komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="count(hl7:patientId[hl7:value[@root = '2.16.840.1.113883.2.4.6.3']]) &gt;= 1">(opvragenVoorschriftenLijst): element hl7:patientId[hl7:value[@root = '2.16.840.1.113883.2.4.6.3']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="count(hl7:patientId[hl7:value[@root = '2.16.840.1.113883.2.4.6.3']]) &lt;= 1">(opvragenVoorschriftenLijst): element hl7:patientId[hl7:value[@root = '2.16.840.1.113883.2.4.6.3']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.11
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']
Item: (opvragenVoorschriftenLijst)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']"
         id="d15e15869-false-d81835e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenVoorschriftenLijst): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.66.10.11')">(opvragenVoorschriftenLijst): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.66.10.11' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.11
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]/hl7:queryId[not(@nullFlavor)]
Item: (opvragenVoorschriftenLijst)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]/hl7:queryId[not(@nullFlavor)]"
         id="d15e15874-false-d81854e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenVoorschriftenLijst): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.11
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]/hl7:statusCode[@code = 'executing']
Item: (opvragenVoorschriftenLijst)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]/hl7:statusCode[@code = 'executing']"
         id="d15e15885-false-d81867e0">
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenVoorschriftenLijst): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="@nullFlavor or (@code='executing')">(opvragenVoorschriftenLijst): de elementwaarde MOET een zijn van 'code 'executing''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.11
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]/hl7:responseModalityCode[@code = 'R']
Item: (opvragenVoorschriftenLijst)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]/hl7:responseModalityCode[@code = 'R']"
         id="d15e15898-false-d81887e0">
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenVoorschriftenLijst): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="@nullFlavor or (@code='R')">(opvragenVoorschriftenLijst): de elementwaarde MOET een zijn van 'code 'R''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.11
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]/hl7:responsePriorityCode[@code = 'I']
Item: (opvragenVoorschriftenLijst)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]/hl7:responsePriorityCode[@code = 'I']"
         id="d15e15911-false-d81907e0">
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenVoorschriftenLijst): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="@nullFlavor or (@code='I')">(opvragenVoorschriftenLijst): de elementwaarde MOET een zijn van 'code 'I''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.11
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]/hl7:executionAndDeliveryTime[not(@nullFlavor)]
Item: (opvragenVoorschriftenLijst)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]/hl7:executionAndDeliveryTime[not(@nullFlavor)]"
         id="d15e15925-false-d81927e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenVoorschriftenLijst): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="not(*)">(opvragenVoorschriftenLijst): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.11
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]/hl7:administrationRequestEffectiveTimeInterval
Item: (opvragenVoorschriftenLijst)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]/hl7:administrationRequestEffectiveTimeInterval"
         id="d15e15936-false-d81944e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="count(hl7:value[not(@nullFlavor)]) &gt;= 1">(opvragenVoorschriftenLijst): element hl7:value[not(@nullFlavor)] is mandatory [min 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.11
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]/hl7:administrationRequestEffectiveTimeInterval/hl7:value[not(@nullFlavor)]
Item: (opvragenVoorschriftenLijst)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]/hl7:administrationRequestEffectiveTimeInterval/hl7:value[not(@nullFlavor)]"
         id="d15e15958-false-d81963e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenVoorschriftenLijst): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="not(hl7:low) or string-length(hl7:low/@value)&gt;=12">(opvragenVoorschriftenLijst): Onder- en bovengrens (low, high) is tot op de minuut te specificeren</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="not(hl7:high) or string-length(hl7:high/@value)&gt;=12">(opvragenVoorschriftenLijst): Onder- en bovengrens (low, high) is tot op de minuut te specificeren</assert>
      <let name="elmcount" value="count(hl7:low | hl7:high)"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="$elmcount &gt;= 1">(opvragenVoorschriftenLijst): keuze (hl7:low  of  hl7:high) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="$elmcount &lt;= 2">(opvragenVoorschriftenLijst): keuze (hl7:low  of  hl7:high) bevat te veel elementen [max 2x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="count(hl7:low) &lt;= 1">(opvragenVoorschriftenLijst): element hl7:low komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="count(hl7:high) &lt;= 1">(opvragenVoorschriftenLijst): element hl7:high komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.11
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]/hl7:administrationRequestEffectiveTimeInterval/hl7:value[not(@nullFlavor)]/hl7:low
Item: (opvragenVoorschriftenLijst)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]/hl7:administrationRequestEffectiveTimeInterval/hl7:value[not(@nullFlavor)]/hl7:low"
         id="d15e15995-false-d82012e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenVoorschriftenLijst): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="not(*)">(opvragenVoorschriftenLijst): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.11
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]/hl7:administrationRequestEffectiveTimeInterval/hl7:value[not(@nullFlavor)]/hl7:high
Item: (opvragenVoorschriftenLijst)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]/hl7:administrationRequestEffectiveTimeInterval/hl7:value[not(@nullFlavor)]/hl7:high"
         id="d15e15997-false-d82029e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenVoorschriftenLijst): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="not(*)">(opvragenVoorschriftenLijst): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.11
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]/hl7:medicationCode
Item: (opvragenVoorschriftenLijst)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]/hl7:medicationCode"
         id="d15e16005-false-d82046e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="count(hl7:value[not(@nullFlavor)]) &gt;= 1">(opvragenVoorschriftenLijst): element hl7:value[not(@nullFlavor)] is mandatory [min 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.11
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]/hl7:medicationCode/hl7:value[not(@nullFlavor)]
Item: (opvragenVoorschriftenLijst)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]/hl7:medicationCode/hl7:value[not(@nullFlavor)]"
         id="d15e16010-false-d82065e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenVoorschriftenLijst): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.11
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]/hl7:medicationCombinedOrderID
Item: (opvragenVoorschriftenLijst)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]/hl7:medicationCombinedOrderID"
         id="d15e16013-false-d82078e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="count(hl7:value[not(@nullFlavor)]) &gt;= 1">(opvragenVoorschriftenLijst): element hl7:value[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="count(hl7:value[not(@nullFlavor)]) &lt;= 1">(opvragenVoorschriftenLijst): element hl7:value[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.11
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]/hl7:medicationCombinedOrderID/hl7:value[not(@nullFlavor)]
Item: (opvragenVoorschriftenLijst)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]/hl7:medicationCombinedOrderID/hl7:value[not(@nullFlavor)]"
         id="d15e16023-false-d82102e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.11-2014-01-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(opvragenVoorschriftenLijst): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9035
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]/hl7:patientId[hl7:value[@root = '2.16.840.1.113883.2.4.6.3']]
Item: (kezo-QRYpatientId)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]/hl7:patientId[hl7:value[@root = '2.16.840.1.113883.2.4.6.3']]"
         id="d82109e15-false-d82117e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9035-2015-06-01T000000.html"
              test="count(hl7:value[@root = '2.16.840.1.113883.2.4.6.3']) &gt;= 1">(kezo-QRYpatientId): element hl7:value[@root = '2.16.840.1.113883.2.4.6.3'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9035-2015-06-01T000000.html"
              test="count(hl7:value[@root = '2.16.840.1.113883.2.4.6.3']) &lt;= 1">(kezo-QRYpatientId): element hl7:value[@root = '2.16.840.1.113883.2.4.6.3'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9035
Context: //hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]/hl7:patientId[hl7:value[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:value[@root = '2.16.840.1.113883.2.4.6.3']
Item: (kezo-QRYpatientId)
-->

   <rule context="//hl7:QURX_IN990201NL01[hl7:ControlActProcess[@moodCode = 'EVN']]/hl7:ControlActProcess[hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]]/hl7:queryByParameter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.11']]/hl7:patientId[hl7:value[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:value[@root = '2.16.840.1.113883.2.4.6.3']"
         id="d82109e20-false-d82141e0">
      <extends rule="II.NL.BSN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9035-2015-06-01T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-QRYpatientId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9035-2015-06-01T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.6.3')">(kezo-QRYpatientId): de waarde van root MOET '2.16.840.1.113883.2.4.6.3' zijn. Gevonden: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9035-2015-06-01T000000.html"
              test="@extension">(kezo-QRYpatientId): attribute @extension MOET aanwezig zijn.</assert>
   </rule>
</pattern>
