<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.11.60.66.10.201
Name: KEZO Contactmoment
Description: Het bouwsteentype Contactmoment hoort bij elke situatie waarbij een patiënt contact heeft gehad met een zorgverlener in het kader van diagnostiek of behandeling. Dit komt globaal overeen met het HL7v3 concept van een Encounter. Een Encounter kan echter betrekking hebben op een klinische opname of dagopname, terwijl het Contactmoment zoals bedoeld in de data set Ketenzorg betrekking heeft op ambulante contacten (d.w.z. contacten waarbij de patiënt de zorginstelling bezoekt, maar er geen bed heeft gebruikt). 
                 Verdere informatie 
            
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000">
   <title>KEZO Contactmoment</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.201
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]
Item: (kezo-Contactmoment)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.201
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]
Item: (kezo-Contactmoment)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]"
         id="d15e19566-false-d175906e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="string(@classCode) = ('ENC')">(kezo-Contactmoment): de waarde van classCode MOET 'ENC' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="string(@moodCode) = ('EVN')">(kezo-Contactmoment): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']) &gt;= 1">(kezo-Contactmoment): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']) &lt;= 1">(kezo-Contactmoment): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(kezo-Contactmoment): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(kezo-Contactmoment): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.103.11.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(kezo-Contactmoment): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.103.11.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.103.11.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(kezo-Contactmoment): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.103.11.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="count(hl7:effectiveTime[not(@nullFlavor)]) &gt;= 1">(kezo-Contactmoment): element hl7:effectiveTime[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="count(hl7:effectiveTime[not(@nullFlavor)]) &lt;= 1">(kezo-Contactmoment): element hl7:effectiveTime[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="count(hl7:performer[not(@nullFlavor)][hl7:assignedEntity]) &gt;= 1">(kezo-Contactmoment): element hl7:performer[not(@nullFlavor)][hl7:assignedEntity] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="count(hl7:performer[not(@nullFlavor)][hl7:assignedEntity]) &lt;= 1">(kezo-Contactmoment): element hl7:performer[not(@nullFlavor)][hl7:assignedEntity] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.201
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']
Item: (kezo-Contactmoment)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']"
         id="d15e19572-false-d176020e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-Contactmoment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.66.10.201')">(kezo-Contactmoment): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.66.10.201' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.201
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:id[not(@nullFlavor)]
Item: (kezo-Contactmoment)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:id[not(@nullFlavor)]"
         id="d15e19577-false-d176039e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-Contactmoment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.201
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.103.11.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (kezo-Contactmoment)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.103.11.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d15e19583-false-d176054e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-Contactmoment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.103.11.3-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(kezo-Contactmoment): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.103.11.3 NHG tabel 14v7 - ContactType (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.103.11.3-DYNAMIC.xml')//valueSet[1]/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(kezo-Contactmoment): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst 2.16.840.1.113883.2.4.3.11.60.103.11.3 NHG tabel 14v7 - ContactType (DYNAMISCH).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.201
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:effectiveTime[not(@nullFlavor)]
Item: (kezo-Contactmoment)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:effectiveTime[not(@nullFlavor)]"
         id="d15e19592-false-d176083e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-Contactmoment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="count(hl7:low) &gt;= 1">(kezo-Contactmoment): element hl7:low is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="count(hl7:low) &lt;= 1">(kezo-Contactmoment): element hl7:low komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="count(hl7:high) &lt;= 1">(kezo-Contactmoment): element hl7:high komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.201
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:effectiveTime[not(@nullFlavor)]/hl7:low
Item: (kezo-Contactmoment)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:effectiveTime[not(@nullFlavor)]/hl7:low"
         id="d15e19599-false-d176120e0">
      <extends rule="TS.DATE.MIN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-Contactmoment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="not(*)">(kezo-Contactmoment): <value-of select="local-name()"/> met datatype TS.DATE.MIN, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.201
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:effectiveTime[not(@nullFlavor)]/hl7:high
Item: (kezo-Contactmoment)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:effectiveTime[not(@nullFlavor)]/hl7:high"
         id="d15e19603-false-d176137e0">
      <extends rule="TS.DATE.MIN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-Contactmoment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="not(*)">(kezo-Contactmoment): <value-of select="local-name()"/> met datatype TS.DATE.MIN, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.201
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]
Item: (kezo-Contactmoment)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]"
         id="d15e19606-false-d176170e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="string(@typeCode) = ('PRF') or not(@typeCode)">(kezo-Contactmoment): de waarde van typeCode MOET 'PRF' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="count(hl7:assignedEntity[not(@nullFlavor)]) &gt;= 1">(kezo-Contactmoment): element hl7:assignedEntity[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="count(hl7:assignedEntity[not(@nullFlavor)]) &lt;= 1">(kezo-Contactmoment): element hl7:assignedEntity[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.201
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]
Item: (kezo-Contactmoment)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]"
         id="d15e19613-false-d176232e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(kezo-Contactmoment): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(kezo-Contactmoment): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(kezo-Contactmoment): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="count(hl7:assignedPerson) &lt;= 1">(kezo-Contactmoment): element hl7:assignedPerson komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="count(hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]) &lt;= 1">(kezo-Contactmoment): element hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.201-2013-12-31T000000.html"
              test="hl7:assignedPerson | hl7:representedOrganization">(kezo-Contactmoment): Er moet tenminste een persoon of vertegenwoordigende organisatie zijn. Element assignedPerson of representedOrganization moet voorkomen</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9028
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]
Item: (kezo-CDAAssignedEntity)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]"
         id="d176302e11-false-d176310e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9028-2019-01-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-CDAAssignedEntity): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9028
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (kezo-CDAAssignedEntity)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d176302e20-false-d176325e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9028-2019-01-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-CDAAssignedEntity): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9028-2019-01-09T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(kezo-CDAAssignedEntity): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.1.11.2 RoleCodeNL - zorgverlenertype (personen) (DYNAMISCH)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9028
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:addr
Item: (kezo-CDAAssignedEntity)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:addr"
         id="d176302e30-false-d176349e0">
      <extends rule="AD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9028-2019-01-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-CDAAssignedEntity): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9028
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:telecom
Item: (kezo-CDAAssignedEntity)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:telecom"
         id="d176302e34-false-d176362e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9028-2019-01-09T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-CDAAssignedEntity): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9028
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:assignedPerson
Item: (kezo-CDAAssignedEntity)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:assignedPerson"
         id="d176302e46-false-d176377e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9028-2019-01-09T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(kezo-CDAAssignedEntity): de waarde van classCode MOET 'PSN' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9028-2019-01-09T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(kezo-CDAAssignedEntity): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9001
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:assignedPerson/hl7:name
Item: (CDAPerson)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:assignedPerson/hl7:name"
         id="d176402e14-false-d176410e0">
      <extends rule="PN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9001-2013-12-22T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAPerson): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9028
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]
Item: (kezo-CDAAssignedEntity)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]"
         id="d176302e58-false-d176430e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9028-2019-01-09T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(kezo-CDAAssignedEntity): de waarde van classCode MOET 'ORG' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9028-2019-01-09T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(kezo-CDAAssignedEntity): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9028-2019-01-09T000000.html"
              test="count(hl7:id[@root = '2.16.528.1.1007.3.3']) &gt;= 1">(kezo-CDAAssignedEntity): element hl7:id[@root = '2.16.528.1.1007.3.3'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9028-2019-01-09T000000.html"
              test="count(hl7:id[@root = '2.16.528.1.1007.3.3']) &lt;= 1">(kezo-CDAAssignedEntity): element hl7:id[@root = '2.16.528.1.1007.3.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9028-2019-01-09T000000.html"
              test="count(hl7:name) &gt;= 1">(kezo-CDAAssignedEntity): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9028-2019-01-09T000000.html"
              test="count(hl7:name) &lt;= 1">(kezo-CDAAssignedEntity): element hl7:name komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9028-2019-01-09T000000.html"
              test="count(hl7:addr) &lt;= 1">(kezo-CDAAssignedEntity): element hl7:addr komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9028-2019-01-09T000000.html"
              test="count(hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(kezo-CDAAssignedEntity): element hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:id[@root = '2.16.528.1.1007.3.3']
Item: (CDAOrganization)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:id[@root = '2.16.528.1.1007.3.3']"
         id="d176509e16-false-d176517e0">
      <extends rule="II.NL.URA"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="string(@root) = ('2.16.528.1.1007.3.3')">(CDAOrganization): de waarde van root MOET '2.16.528.1.1007.3.3' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:id
Item: (CDAOrganization)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:id"
         id="d176509e24-false-d176536e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:name
Item: (CDAOrganization)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:name"
         id="d176509e32-false-d176549e0">
      <extends rule="ON"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:telecom
Item: (CDAOrganization)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:telecom"
         id="d176509e36-false-d176562e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:addr
Item: (CDAOrganization)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:addr"
         id="d176509e41-false-d176575e0">
      <extends rule="AD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDAOrganization)
-->

   <rule context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d176509e43-false-d176590e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDAOrganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9002-2011-12-19T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDAOrganization): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3 OrganisatieTypeCodelijst (DYNAMISCH)'.</assert>
   </rule>
</pattern>
