<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.11.60.66.10.212
Name: KEZO Overdracht Concern
Description: Bouwsteen: Overdracht Concern Verdere informatie
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron" id="template-2.16.840.1.113883.2.4.3.11.60.66.10.212-2015-07-03T000000">
   <title>KEZO Overdracht Concern</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.212
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]
Item: (KEZO Overdracht Concern)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.212
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]
Item: (KEZO Overdracht Concern)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]" id="d152e9838-false-d82084e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="string(@classCode) = ('ACT')">(KEZO Overdracht Concern): de waarde van classCode MOET 'ACT' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="string(@moodCode) = ('EVN')">(KEZO Overdracht Concern): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']) &gt;= 1">(KEZO Overdracht Concern): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212'] is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']) &lt;= 1">(KEZO Overdracht Concern): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212'] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(KEZO Overdracht Concern): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="count(hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]) &gt;= 1">(KEZO Overdracht Concern): element hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="count(hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]) &lt;= 1">(KEZO Overdracht Concern): element hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="count(hl7:text) &lt;= 1">(KEZO Overdracht Concern): element hl7:text komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.11.20.9.19-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]) &gt;= 1">(KEZO Overdracht Concern): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.11.20.9.19-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.11.20.9.19-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]) &lt;= 1">(KEZO Overdracht Concern): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.11.20.9.19-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="count(hl7:effectiveTime) &lt;= 1">(KEZO Overdracht Concern): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]]) &gt;= 1">(KEZO Overdracht Concern): element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]] is required [min 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.212
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']
Item: (KEZO Overdracht Concern)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']" id="d152e9844-false-d82225e0">
      <extends rule="II"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(KEZO Overdracht Concern): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.66.10.212')">(KEZO Overdracht Concern): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.66.10.212' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.212
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:id[not(@nullFlavor)]
Item: (KEZO Overdracht Concern)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:id[not(@nullFlavor)]" id="d152e9849-false-d82243e0">
      <extends rule="II"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(KEZO Overdracht Concern): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.212
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]
Item: (KEZO Overdracht Concern)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]" id="d152e9851-false-d82255e0">
      <extends rule="CE"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(KEZO Overdracht Concern): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="@nullFlavor or (@code='CONC' and @codeSystem='2.16.840.1.113883.5.6')">(KEZO Overdracht Concern): de elementwaarde MOET een zijn van 'code 'CONC' codeSystem '2.16.840.1.113883.5.6''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.212
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:text
Item: (KEZO Overdracht Concern)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:text" id="d152e9857-false-d82274e0">
      <extends rule="ST"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(KEZO Overdracht Concern): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.212
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.11.20.9.19-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]
Item: (KEZO Overdracht Concern)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.11.20.9.19-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]" id="d152e9863-false-d82288e0">
      <extends rule="CS"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(KEZO Overdracht Concern): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.11.20.9.19-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(KEZO Overdracht Concern): de elementwaarde MOET een zijn van '2.16.840.1.113883.11.20.9.19 ProblemActStatusCode (DYNAMISCH)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.212
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:effectiveTime
Item: (KEZO Overdracht Concern)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:effectiveTime" id="d152e9874-false-d82311e0">
      <extends rule="IVL_TS"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(KEZO Overdracht Concern): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="count(hl7:low) &gt;= 1">(KEZO Overdracht Concern): element hl7:low is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="count(hl7:low) &lt;= 1">(KEZO Overdracht Concern): element hl7:low komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="count(hl7:high) &lt;= 1">(KEZO Overdracht Concern): element hl7:high komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.212
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:effectiveTime/hl7:low
Item: (KEZO Overdracht Concern)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:effectiveTime/hl7:low" id="d152e9882-false-d82347e0">
      <extends rule="TS"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(KEZO Overdracht Concern): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="not(*)">(KEZO Overdracht Concern): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.212
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:effectiveTime/hl7:high
Item: (KEZO Overdracht Concern)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:effectiveTime/hl7:high" id="d152e9884-false-d82363e0">
      <extends rule="TS"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(KEZO Overdracht Concern): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="not(*)">(KEZO Overdracht Concern): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.212
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]
Item: (KEZO Overdracht Concern)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]" id="d152e9887-false-d82399e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="string(@typeCode) = ('AUT') or not(@typeCode)">(KEZO Overdracht Concern): de waarde van typeCode MOET 'AUT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(KEZO Overdracht Concern): de waarde van contextControlCode MOET 'OP' zijn. Gevonden: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="count(hl7:functionCode) &lt;= 1">(KEZO Overdracht Concern): element hl7:functionCode komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="count(hl7:time) &gt;= 1">(KEZO Overdracht Concern): element hl7:time is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="count(hl7:time) &lt;= 1">(KEZO Overdracht Concern): element hl7:time komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="count(hl7:assignedAuthor) &gt;= 1">(KEZO Overdracht Concern): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="count(hl7:assignedAuthor) &lt;= 1">(KEZO Overdracht Concern): element hl7:assignedAuthor komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9025
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]/hl7:functionCode
Item: (KEZO PART CDA Author (Body))
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]/hl7:functionCode" id="d82475e8-false-d82482e0">
      <extends rule="CD"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9025" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(KEZO PART CDA Author (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CD" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9025
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (KEZO PART CDA Author (Body))
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]/hl7:time" id="d82475e12-false-d82494e0">
      <extends rule="TS"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9025" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(KEZO PART CDA Author (Body)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9025" test="not(*)">(KEZO PART CDA Author (Body)): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9025
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (KEZO PART CDA Author (Body))
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor" id="d82475e17-false-d82526e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9025" test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(KEZO PART CDA Author (Body)): de waarde van classCode MOET 'ASSIGNED' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9025" test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(KEZO PART CDA Author (Body)): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9025" test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(KEZO PART CDA Author (Body)): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9025" test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(KEZO PART CDA Author (Body)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9025" test="count(hl7:assignedPerson) &lt;= 1">(KEZO PART CDA Author (Body)): element hl7:assignedPerson komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9025" test="count(hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]) &lt;= 1">(KEZO PART CDA Author (Body)): element hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9025" test="hl7:assignedPerson | hl7:representedOrganization">(KEZO PART CDA Author (Body)): Er moet tenminste een persoon of vertegenwoordigende organisatie zijn. Element assignedPerson of representedOrganization moet voorkomen</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9028
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id[not(@nullFlavor)]
Item: (KEZO PART CDA Assigned Entity)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id[not(@nullFlavor)]" id="d82602e5-false-d82609e0">
      <extends rule="II"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(KEZO PART CDA Assigned Entity): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9028
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (KEZO PART CDA Assigned Entity)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]" id="d82602e10-false-d82623e0">
      <extends rule="CV"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(KEZO PART CDA Assigned Entity): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(KEZO PART CDA Assigned Entity): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.1.11.2 RoleCodeNL - zorgverlenertype (personen) (DYNAMISCH)'.</assert>
      <report fpi="CD-DEPR-BSP" role="warning" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@type='D'][@code = $theCode][@codeSystem = $theCodeSystem])">(KEZO PART CDA Assigned Entity): element hl7:code is gecodeerd met bindingssterkte 'required' en bevat een code die verouderd is.</report>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9028
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr
Item: (KEZO PART CDA Assigned Entity)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr" id="d82602e17-false-d82651e0">
      <extends rule="AD"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'AD')">(KEZO PART CDA Assigned Entity): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9028
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:telecom
Item: (KEZO PART CDA Assigned Entity)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:telecom" id="d82602e18-false-d82663e0">
      <extends rule="TEL"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(KEZO PART CDA Assigned Entity): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9028
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (KEZO PART CDA Assigned Entity)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson" id="d82602e25-false-d82677e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="string(@classCode) = ('PSN') or not(@classCode)">(KEZO PART CDA Assigned Entity): de waarde van classCode MOET 'PSN' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(KEZO PART CDA Assigned Entity): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9001
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (PART CDA Person)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name" id="d82702e7-false-d82709e0">
      <extends rule="PN"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9001" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PN')">(PART CDA Person): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9028
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]
Item: (KEZO PART CDA Assigned Entity)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]" id="d82602e35-false-d82728e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="string(@classCode) = ('ORG') or not(@classCode)">(KEZO PART CDA Assigned Entity): de waarde van classCode MOET 'ORG' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(KEZO PART CDA Assigned Entity): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="count(hl7:id[@root = '2.16.528.1.1007.3.3']) &gt;= 1">(KEZO PART CDA Assigned Entity): element hl7:id[@root = '2.16.528.1.1007.3.3'] is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="count(hl7:id[@root = '2.16.528.1.1007.3.3']) &lt;= 1">(KEZO PART CDA Assigned Entity): element hl7:id[@root = '2.16.528.1.1007.3.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="count(hl7:name) &gt;= 1">(KEZO PART CDA Assigned Entity): element hl7:name is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="count(hl7:name) &lt;= 1">(KEZO PART CDA Assigned Entity): element hl7:name komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="count(hl7:addr) &lt;= 1">(KEZO PART CDA Assigned Entity): element hl7:addr komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="count(hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(KEZO PART CDA Assigned Entity): element hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:id[@root = '2.16.528.1.1007.3.3']
Item: (PART CDA Organization)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:id[@root = '2.16.528.1.1007.3.3']" id="d82807e7-false-d82814e0">
      <extends rule="II.NL.URA"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9002" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(PART CDA Organization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9002" test="string(@root) = ('2.16.528.1.1007.3.3')">(PART CDA Organization): de waarde van root MOET '2.16.528.1.1007.3.3' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:id
Item: (PART CDA Organization)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:id" id="d82807e14-false-d82832e0">
      <extends rule="II"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9002" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(PART CDA Organization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:name
Item: (PART CDA Organization)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:name" id="d82807e19-false-d82844e0">
      <extends rule="ON"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9002" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ON')">(PART CDA Organization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:telecom
Item: (PART CDA Organization)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:telecom" id="d82807e20-false-d82856e0">
      <extends rule="TEL"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9002" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(PART CDA Organization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:addr
Item: (PART CDA Organization)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:addr" id="d82807e21-false-d82868e0">
      <extends rule="AD"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9002" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'AD')">(PART CDA Organization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (PART CDA Organization)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]" id="d82807e22-false-d82882e0">
      <extends rule="CE"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9002" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(PART CDA Organization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9002" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(PART CDA Organization): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3 OrganisatieTypeCodelijst (DYNAMISCH)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.212
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]]
Item: (KEZO Overdracht Concern)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.213']]]">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.212" test="string(@typeCode) = ('SUBJ')">(KEZO Overdracht Concern): de waarde van typeCode MOET 'SUBJ' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>
</pattern>