<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.11.60.66.10.302
Name: KEZO Summary Section
Description: 
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000">
   <title>KEZO Summary Section</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.302
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]]
Item: (kezo-Summary)
-->

   <rule context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]]"
         id="d15e24333-false-d221506e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]) &gt;= 1">(kezo-Summary): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]) &lt;= 1">(kezo-Summary): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.302
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]
Item: (kezo-Summary)
-->

   <rule context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]"
         id="d15e24359-false-d221841e0">
      <let name="concernReferencesContact"
           value="hl7:entry/*[hl7:templateId/@root='2.16.840.1.113883.2.4.3.11.60.66.10.201']/hl7:entryRelationship[@typeCode='REFR']/hl7:act"/>
      <let name="concernReferencesDiagresult"
           value="hl7:entry/*[hl7:templateId/@root='2.16.840.1.113883.2.4.3.11.60.66.10.202']/hl7:entryRelationship[@typeCode='REFR']/hl7:act"/>
      <let name="concernReferencesLabresult"
           value="hl7:entry/*[hl7:templateId/@root='2.16.840.1.113883.2.4.3.11.60.66.10.203']/hl7:entryRelationship[@typeCode='REFR']/hl7:act"/>
      <let name="concernReferencesPrescription"
           value="hl7:entry/*[hl7:templateId/@root='2.16.840.1.113883.2.4.3.11.60.66.10.204']/hl7:entryRelationship[@typeCode='REFR']/hl7:act"/>
      <let name="concernReferencesContactReport"
           value="hl7:entry/*[hl7:templateId/@root='2.16.840.1.113883.2.4.3.11.60.66.10.207']/hl7:entryRelationship[@typeCode='REFR']/hl7:act"/>
      <let name="concernReferencesAlert"
           value="hl7:entry/*[hl7:templateId/@root='2.16.840.1.113883.2.4.3.11.60.66.10.214']/hl7:entryRelationship[@typeCode='REFR']/hl7:act"/>
      <let name="concernReferences"
           value="$concernReferencesContact | $concernReferencesContactReport | $concernReferencesPrescription | $concernReferencesAlert | $concernReferencesDiagresult | $concernReferencesLabresult"/>
      <let name="concerns"
           value="hl7:entry/*[hl7:templateId/@root='2.16.840.1.113883.2.4.3.11.60.66.10.212']"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="count($concernReferencesContact) &gt; 0">(kezo-Summary): Een overdracht vanuit de keten dient te gebeuren onder verwijzing naar een OverdrachtConcern/Episode vanuit het contact, normalerwijs in elk geval de Episode waarmee de patiënt de keten in is gestuurd.</assert>
      <report role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="$concernReferencesContact/hl7:id[not(concat(@root,@extension) = $concerns/hl7:id/concat(@root,@extension))]">(kezo-Summary): Voor iedere verwijzing in een contact naar een OverdrachtConcern/Episode dient ook de OverdrachtConcern/Episode aanwezig te zijn.</report>
      <report role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="$concernReferencesContactReport/hl7:id[not(concat(@root,@extension) = $concerns/hl7:id/concat(@root,@extension))]">(kezo-Summary): Voor iedere verwijzing in een contactverslag naar een OverdrachtConcern/Episode dient ook de OverdrachtConcern/Episode aanwezig te zijn.</report>
      <report role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="$concernReferencesPrescription/hl7:id[not(concat(@root,@extension) = $concerns/hl7:id/concat(@root,@extension))]">(kezo-Summary): Voor iedere verwijzing in een voorschrift naar een OverdrachtConcern/Episode dient ook de OverdrachtConcern/Episode aanwezig te zijn.</report>
      <report role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="$concernReferencesAlert/hl7:id[not(concat(@root,@extension) = $concerns/hl7:id/concat(@root,@extension))]">(kezo-Summary): Voor iedere verwijzing in een alert naar een OverdrachtConcern/Episode dient ook de OverdrachtConcern/Episode aanwezig te zijn.</report>
      <report role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="$concernReferencesDiagresult/hl7:id[not(concat(@root,@extension) = $concerns/hl7:id/concat(@root,@extension))]">(kezo-Summary): Voor iedere verwijzing in een diagnostisch/algemeen resultaat naar een OverdrachtConcern/Episode dient ook de OverdrachtConcern/Episode aanwezig te zijn.</report>
      <report role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="$concernReferencesLabresult/hl7:id[not(concat(@root,@extension) = $concerns/hl7:id/concat(@root,@extension))]">(kezo-Summary): Voor iedere verwijzing in een laboratoriumresultaat naar een OverdrachtConcern/Episode dient ook de OverdrachtConcern/Episode aanwezig te zijn.</report>
      <report role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="$concerns/hl7:id[not(concat(@root,@extension) = $concernReferences/hl7:id/concat(@root,@extension))]">(kezo-Summary): Er kunnen geen andere OverdrachtConcerns/Episodes aanwezig zijn dan waarnaar wordt verwezen.</report>
      <let name="contactReferencesPrescription"
           value="hl7:entry/*[hl7:templateId/@root='2.16.840.1.113883.2.4.3.11.60.66.10.204']/hl7:entryRelationship[@typeCode='REFR']/hl7:encounter"/>
      <let name="contactReferencesDiagresult"
           value="hl7:entry/*[hl7:templateId/@root='2.16.840.1.113883.2.4.3.11.60.66.10.202']/hl7:entryRelationship[@typeCode='REFR']/hl7:encounter"/>
      <let name="contactReferencesLabresult"
           value="hl7:entry/*[hl7:templateId/@root='2.16.840.1.113883.2.4.3.11.60.66.10.203']/hl7:entryRelationship[@typeCode='REFR']/hl7:encounter"/>
      <let name="contactReferencesContactReport"
           value="hl7:entry/*[hl7:templateId/@root='2.16.840.1.113883.2.4.3.11.60.66.10.207']/hl7:entryRelationship[@typeCode='REFR']/hl7:encounter"/>
      <let name="contactReferencesAlert"
           value="hl7:entry/*[hl7:templateId/@root='2.16.840.1.113883.2.4.3.11.60.66.10.214']/hl7:entryRelationship[@typeCode='REFR']/hl7:encounter"/>
      <let name="contactReferences"
           value="$contactReferencesContactReport | $contactReferencesPrescription | $contactReferencesAlert | $contactReferencesDiagresult | $contactReferencesLabresult"/>
      <let name="contacts"
           value="hl7:entry/*[hl7:templateId/@root='2.16.840.1.113883.2.4.3.11.60.66.10.201']"/>
      <report role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="$contactReferencesContactReport/hl7:id[not(concat(@root,@extension) = $contacts/hl7:id/concat(@root,@extension))]">(kezo-Summary): Voor iedere verwijzing in een contactverslag naar een Contact dient ook het Contact aanwezig te zijn.</report>
      <report role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="$contactReferencesPrescription/hl7:id[not(concat(@root,@extension) = $contacts/hl7:id/concat(@root,@extension))]">(kezo-Summary): Voor iedere verwijzing in een voorschrift naar een Contact dient ook het Contact aanwezig te zijn.</report>
      <report role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="$contactReferencesAlert/hl7:id[not(concat(@root,@extension) = $contacts/hl7:id/concat(@root,@extension))]">(kezo-Summary): Voor iedere verwijzing in een alert naar een Contact dient ook het Contact aanwezig te zijn.</report>
      <report role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="$contactReferencesDiagresult/hl7:id[not(concat(@root,@extension) = $contacts/hl7:id/concat(@root,@extension))]">(kezo-Summary): Voor iedere verwijzing in een diagnostisch/algemeen resultaat naar een Contact dient ook het Contact aanwezig te zijn.</report>
      <report role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="$contactReferencesLabresult/hl7:id[not(concat(@root,@extension) = $contacts/hl7:id/concat(@root,@extension))]">(kezo-Summary): Voor iedere verwijzing in een laboratoriumresultaat naar een Contact dient ook het Contact aanwezig te zijn.</report>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']) &gt;= 1">(kezo-Summary): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']) &lt;= 1">(kezo-Summary): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="count(hl7:code[(@code = '67781-5' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(kezo-Summary): element hl7:code[(@code = '67781-5' and @codeSystem = '2.16.840.1.113883.6.1')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="count(hl7:code[(@code = '67781-5' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(kezo-Summary): element hl7:code[(@code = '67781-5' and @codeSystem = '2.16.840.1.113883.6.1')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="count(hl7:title) &lt;= 1">(kezo-Summary): element hl7:title komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="count(hl7:text[not(@nullFlavor)]) &gt;= 1">(kezo-Summary): element hl7:text[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="count(hl7:text[not(@nullFlavor)]) &lt;= 1">(kezo-Summary): element hl7:text[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="count(hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]) &gt;= 1">(kezo-Summary): element hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]] is required [min 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.302
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']
Item: (kezo-Summary)
-->

   <rule context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']"
         id="d15e24361-false-d222091e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.66.10.302')">(kezo-Summary): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.66.10.302' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.302
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]/hl7:code[(@code = '67781-5' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (kezo-Summary)
-->

   <rule context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]/hl7:code[(@code = '67781-5' and @codeSystem = '2.16.840.1.113883.6.1')]"
         id="d15e24366-false-d222106e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-Summary): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="@nullFlavor or (@code='67781-5' and @codeSystem='2.16.840.1.113883.6.1' and @displayName='Summarization of encounter note')">(kezo-Summary): de elementwaarde MOET een zijn van 'code '67781-5' codeSystem '2.16.840.1.113883.6.1' displayName='Summarization of encounter note''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.302
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]/hl7:title
Item: (kezo-Summary)
-->

   <rule context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]/hl7:title"
         id="d15e24371-false-d222126e0">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ST' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-Summary): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.302
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]/hl7:text[not(@nullFlavor)]
Item: (kezo-Summary)
-->

   <rule context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]/hl7:text[not(@nullFlavor)]"
         id="d15e24373-false-d222139e0">
      <extends rule="ED"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ED' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-Summary): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ED" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.302
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]/hl7:entry[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]
Item: (kezo-Summary)
-->
   <rule context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]/hl7:entry[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="string(@typeCode) = ('DRIV')">(kezo-Summary): de waarde van typeCode MOET 'DRIV' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.302
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.202']]]
Item: (kezo-Summary)
-->
   <rule context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.202']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="string(@typeCode) = ('DRIV')">(kezo-Summary): de waarde van typeCode MOET 'DRIV' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.302
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.203']]]
Item: (kezo-Summary)
-->
   <rule context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.203']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="string(@typeCode) = ('DRIV')">(kezo-Summary): de waarde van typeCode MOET 'DRIV' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.302
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.204']]]
Item: (kezo-Summary)
-->
   <rule context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.204']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="string(@typeCode) = ('DRIV')">(kezo-Summary): de waarde van typeCode MOET 'DRIV' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.302
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]
Item: (kezo-Summary)
-->
   <rule context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.207']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="string(@typeCode) = ('DRIV')">(kezo-Summary): de waarde van typeCode MOET 'DRIV' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.302
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]
Item: (kezo-Summary)
-->
   <rule context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.212']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="string(@typeCode) = ('DRIV')">(kezo-Summary): de waarde van typeCode MOET 'DRIV' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.302
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.214']]]
Item: (kezo-Summary)
-->
   <rule context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.214']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="string(@typeCode) = ('DRIV')">(kezo-Summary): de waarde van typeCode MOET 'DRIV' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.302
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]
Item: (kezo-Summary)
-->
   <rule context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.302']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.215']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.302-2015-07-13T000000.html"
              test="string(@typeCode) = ('DRIV')">(kezo-Summary): de waarde van typeCode MOET 'DRIV' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>
</pattern>
