<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.11.60.66.10.74
Name: Organizer Medicatieafspraken
Description: Lijst van medicatieafspraken. Deze lijst is gebaseerd op de lijst voor medicatiegegevens in Medicatieproces 9.0.5. Verschillen:  
                     Niet álle bouwstenen in medicatiegegevens: alleen medicatieafspraken 
                     Voor consistentie met overige lijst templates: statusCode/@code = 'completed' (versus statusCode/@nullFlavor = 'NI') 
                     Voor consistentie met overige lijst templates: CDA Inhoudsverantwoordelijke (niet gedefinieerd in medicatiegegevens), CDA Dossierhouder (niet gedefinieerd in medicatiegegevens) en Patient-BSN-Minimal (versus Patient-Contactible) 
                 
            
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.3.11.60.66.10.74-2018-04-18T000000">
   <title>Organizer Medicatieafspraken</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.74
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]
Item: (OrganizerMedicatieafspraken)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]"
         id="d15e28957-false-d362265e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.74-2018-04-18T000000.html"
              test="string(@classCode) = ('CLUSTER')">(OrganizerMedicatieafspraken): de waarde van classCode MOET 'CLUSTER' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.74-2018-04-18T000000.html"
              test="string(@moodCode) = ('EVN')">(OrganizerMedicatieafspraken): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.74-2018-04-18T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74']) &gt;= 1">(OrganizerMedicatieafspraken): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.74-2018-04-18T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74']) &lt;= 1">(OrganizerMedicatieafspraken): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.74-2018-04-18T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']) &gt;= 1">(OrganizerMedicatieafspraken): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.74-2018-04-18T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']) &lt;= 1">(OrganizerMedicatieafspraken): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.74-2018-04-18T000000.html"
              test="count(hl7:code[(@code = '102' and @codeSystem = '2.16.840.1.113883.2.4.3.11.60.20.77.4')]) &gt;= 1">(OrganizerMedicatieafspraken): element hl7:code[(@code = '102' and @codeSystem = '2.16.840.1.113883.2.4.3.11.60.20.77.4')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.74-2018-04-18T000000.html"
              test="count(hl7:code[(@code = '102' and @codeSystem = '2.16.840.1.113883.2.4.3.11.60.20.77.4')]) &lt;= 1">(OrganizerMedicatieafspraken): element hl7:code[(@code = '102' and @codeSystem = '2.16.840.1.113883.2.4.3.11.60.20.77.4')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.74-2018-04-18T000000.html"
              test="count(hl7:statusCode[@code = 'completed']) &gt;= 1">(OrganizerMedicatieafspraken): element hl7:statusCode[@code = 'completed'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.74-2018-04-18T000000.html"
              test="count(hl7:statusCode[@code = 'completed']) &lt;= 1">(OrganizerMedicatieafspraken): element hl7:statusCode[@code = 'completed'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.74-2018-04-18T000000.html"
              test="count(hl7:recordTarget[not(@nullFlavor)][hl7:patientRole]) &gt;= 1">(OrganizerMedicatieafspraken): element hl7:recordTarget[not(@nullFlavor)][hl7:patientRole] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.74-2018-04-18T000000.html"
              test="count(hl7:recordTarget[not(@nullFlavor)][hl7:patientRole]) &lt;= 1">(OrganizerMedicatieafspraken): element hl7:recordTarget[not(@nullFlavor)][hl7:patientRole] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.74-2018-04-18T000000.html"
              test="count(hl7:participant[@typeCode='RESP']) &lt;= 1">(OrganizerMedicatieafspraken): element hl7:participant[@typeCode='RESP'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.74-2018-04-18T000000.html"
              test="count(hl7:participant[@typeCode='CST']) &lt;= 1">(OrganizerMedicatieafspraken): element hl7:participant[@typeCode='CST'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.74
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74']
Item: (OrganizerMedicatieafspraken)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74']"
         id="d15e28963-false-d362469e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.74-2018-04-18T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(OrganizerMedicatieafspraken): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.74-2018-04-18T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.66.10.74')">(OrganizerMedicatieafspraken): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.66.10.74' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.74
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']
Item: (OrganizerMedicatieafspraken)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']"
         id="d15e28968-false-d362488e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.74-2018-04-18T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(OrganizerMedicatieafspraken): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.74-2018-04-18T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.20.77.10.9192')">(OrganizerMedicatieafspraken): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.74
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:code[(@code = '102' and @codeSystem = '2.16.840.1.113883.2.4.3.11.60.20.77.4')]
Item: (OrganizerMedicatieafspraken)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:code[(@code = '102' and @codeSystem = '2.16.840.1.113883.2.4.3.11.60.20.77.4')]"
         id="d15e28973-false-d362507e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.74-2018-04-18T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(OrganizerMedicatieafspraken): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.74-2018-04-18T000000.html"
              test="@nullFlavor or (@code='102' and @codeSystem='2.16.840.1.113883.2.4.3.11.60.20.77.4' and @displayName='Medicatiegegevens')">(OrganizerMedicatieafspraken): de elementwaarde MOET een zijn van 'code '102' codeSystem '2.16.840.1.113883.2.4.3.11.60.20.77.4' displayName='Medicatiegegevens''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.74
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:statusCode[@code = 'completed']
Item: (OrganizerMedicatieafspraken)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:statusCode[@code = 'completed']"
         id="d15e28984-false-d362527e0">
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.74-2018-04-18T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(OrganizerMedicatieafspraken): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.74-2018-04-18T000000.html"
              test="@nullFlavor or (@code='completed')">(OrganizerMedicatieafspraken): de elementwaarde MOET een zijn van 'code 'completed''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.2
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]
Item: (CDArecordTargetSDTC-NL-BSN-Minimal)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]"
         id="d362541e44-false-d362562e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]) &gt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]) &lt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.2
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]
Item: (CDArecordTargetSDTC-NL-BSN-Minimal)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]"
         id="d362541e46-false-d362612e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:id[@root = '2.16.840.1.113883.2.4.6.3']) &gt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:id[@root = '2.16.840.1.113883.2.4.6.3'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:id[@root = '2.16.840.1.113883.2.4.6.3']) &lt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:id[@root = '2.16.840.1.113883.2.4.6.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]) &gt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]) &lt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.2
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:id[@root = '2.16.840.1.113883.2.4.6.3']
Item: (CDArecordTargetSDTC-NL-BSN-Minimal)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:id[@root = '2.16.840.1.113883.2.4.6.3']"
         id="d362541e48-false-d362670e0">
      <extends rule="II.NL.BSN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArecordTargetSDTC-NL-BSN-Minimal): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.6.3')">(CDArecordTargetSDTC-NL-BSN-Minimal): de waarde van root MOET '2.16.840.1.113883.2.4.6.3' zijn. Gevonden: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="@extension">(CDArecordTargetSDTC-NL-BSN-Minimal): attribute @extension MOET aanwezig zijn.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.2
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr
Item: (CDArecordTargetSDTC-NL-BSN-Minimal)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr"
         id="d362541e62-false-d362705e0">
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.2-2015-04-01T000000.xml')/*/valueSet/conceptList/concept/@code))])">(CDArecordTargetSDTC-NL-BSN-Minimal): de waarde van use MOET worden gekozen uit waardelijst '2.16.840.1.113883.2.4.3.11.60.40.2.0.1.2' AdresSoortCodelijst (2015-04-01T00:00:00).</assert>
      <extends rule="AD.NL"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArecordTargetSDTC-NL-BSN-Minimal): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:streetName) &lt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:streetName komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:houseNumber) &lt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:houseNumber komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:buildingNumberSuffix) &lt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:buildingNumberSuffix komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:additionalLocator) &lt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:additionalLocator komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:postalCode) &lt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:postalCode komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:county) &lt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:county komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:city) &lt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:city komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:country) &lt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:country komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:unitID) &lt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:unitID komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:useablePeriod) &lt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:useablePeriod komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.101
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:streetName
Item: (AD.NL)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:streetName"
         id="d362821e101-false-d362829e0">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2017-06-02T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ST' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(AD.NL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.101
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:houseNumber
Item: (AD.NL)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:houseNumber"
         id="d362821e116-false-d362842e0">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2017-06-02T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ST' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(AD.NL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.101
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:buildingNumberSuffix
Item: (AD.NL)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:buildingNumberSuffix"
         id="d362821e135-false-d362855e0">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2017-06-02T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ST' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(AD.NL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.101
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:additionalLocator
Item: (AD.NL)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:additionalLocator"
         id="d362821e228-false-d362868e0">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2017-06-02T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ST' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(AD.NL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2017-06-02T000000.html"
              test="text()='to' or text()='by'">(AD.NL): de elementinhoud van hl7:additionalLocator MOET ''to' of 'by'' zijn. Gevonden: "<value-of select="."/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.101
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:postalCode
Item: (AD.NL)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:postalCode"
         id="d362821e243-false-d362889e0">
      <extends rule="ADXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2017-06-02T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ADXP' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(AD.NL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ADXP" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.101
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:county
Item: (AD.NL)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:county"
         id="d362821e276-false-d362904e0">
      <extends rule="ADXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2017-06-02T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ADXP' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(AD.NL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ADXP" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.101
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:city
Item: (AD.NL)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:city"
         id="d362821e285-false-d362917e0">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2017-06-02T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ST' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(AD.NL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.101
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:country
Item: (AD.NL)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:country"
         id="d362821e294-false-d362930e0">
      <extends rule="ADXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2017-06-02T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ADXP' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(AD.NL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ADXP" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.101
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:unitID
Item: (AD.NL)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:unitID"
         id="d362821e335-false-d362945e0">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2017-06-02T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ST' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(AD.NL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.101
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:useablePeriod
Item: (AD.NL)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:addr/hl7:useablePeriod"
         id="d362821e356-false-d362958e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.101-2017-06-02T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(AD.NL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.2
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]
Item: (CDArecordTargetSDTC-NL-BSN-Minimal)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]"
         id="d362541e67-false-d362975e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:name) &gt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:name) &lt;= 2">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:name komt te vaak voor [max 2x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]) &gt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]) &lt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:birthTime) &lt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:birthTime komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(sdtc:multipleBirthInd) &lt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element sdtc:multipleBirthInd komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.2
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name
Item: (CDArecordTargetSDTC-NL-BSN-Minimal)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name"
         id="d362541e69-false-d363038e0">
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="not(@use) or empty($theAttValue[not(. = (('L','A','OR')))])">(CDArecordTargetSDTC-NL-BSN-Minimal): de waarde van use MOET 'code L of code A of code OR' zijn. Gevonden: "<value-of select="@use"/>"</assert>
      <extends rule="PN.NL"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArecordTargetSDTC-NL-BSN-Minimal): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:given[@qualifier='BR']) &lt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:given[@qualifier='BR'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:given[@qualifier='CL']) &lt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:given[@qualifier='CL'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:given[@qualifier='IN']) &lt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:given[@qualifier='IN'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:given[not(@qualifier)]) &lt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:given[not(@qualifier)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:prefix[not(@qualifier)]) &lt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:prefix[not(@qualifier)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:family[not(@qualifier)]) &lt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:family[not(@qualifier)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:prefix[tokenize(@qualifier,'\s')='VV'][following-sibling::hl7:family[1][@qualifier='BR']]) &lt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:prefix[tokenize(@qualifier,'\s')='VV'][following-sibling::hl7:family[1][@qualifier='BR']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:family[@qualifier='BR']) &lt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:family[@qualifier='BR'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:delimiter[not(@nullFlavor)]) &lt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:delimiter[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:prefix[tokenize(@qualifier,'\s')='VV'][following-sibling::hl7:family[1][@qualifier='SP']]) &lt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:prefix[tokenize(@qualifier,'\s')='VV'][following-sibling::hl7:family[1][@qualifier='SP']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:family[@qualifier='SP']) &lt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:family[@qualifier='SP'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:suffix[not(@nullFlavor)]) &lt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:suffix[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="count(hl7:validTime) &lt;= 1">(CDArecordTargetSDTC-NL-BSN-Minimal): element hl7:validTime komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="not(*) or (hl7:given and hl7:family)">(CDArecordTargetSDTC-NL-BSN-Minimal): In een gestructureerde naam moet minimaal één voornaam, initiaal of roepnaam en minimaal één geslachtsnaam of geslachtsnaam partner van een persoon aanwezig zijn, inclusief voorvoegsel(s) indien van toepassing</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.100
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name
Item: (PN.NL)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.100
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:given[@qualifier='BR']
Item: (PN.NL)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:given[@qualifier='BR']"
         id="d363167e306-false-d363176e0">
      <extends rule="ENXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ENXP' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(PN.NL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="string(@qualifier) = ('BR')">(PN.NL): de waarde van qualifier MOET 'BR' zijn. Gevonden: "<value-of select="@qualifier"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="not(@nullFlavor)">(PN.NL): attribute @nullFlavor MAG NIET voorkomen.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.100
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:given[@qualifier='CL']
Item: (PN.NL)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:given[@qualifier='CL']"
         id="d363167e325-false-d363198e0">
      <extends rule="ENXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ENXP' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(PN.NL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="string(@qualifier) = ('CL')">(PN.NL): de waarde van qualifier MOET 'CL' zijn. Gevonden: "<value-of select="@qualifier"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="not(@nullFlavor)">(PN.NL): attribute @nullFlavor MAG NIET voorkomen.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.100
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:given[@qualifier='IN']
Item: (PN.NL)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:given[@qualifier='IN']"
         id="d363167e344-false-d363220e0">
      <extends rule="ENXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ENXP' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(PN.NL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="string(@qualifier) = ('IN')">(PN.NL): de waarde van qualifier MOET 'IN' zijn. Gevonden: "<value-of select="@qualifier"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="not(@nullFlavor)">(PN.NL): attribute @nullFlavor MAG NIET voorkomen.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.100
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:given[not(@qualifier)]
Item: (PN.NL)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:given[not(@qualifier)]"
         id="d363167e364-false-d363242e0">
      <extends rule="ENXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ENXP' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(PN.NL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.100
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:prefix[not(@qualifier)]
Item: (PN.NL)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:prefix[not(@qualifier)]"
         id="d363167e373-false-d363253e0">
      <extends rule="ENXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ENXP' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(PN.NL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.100
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:family[not(@qualifier)]
Item: (PN.NL)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:family[not(@qualifier)]"
         id="d363167e382-false-d363264e0">
      <extends rule="ENXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ENXP' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(PN.NL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.100
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:prefix[tokenize(@qualifier,'\s')='VV'][following-sibling::hl7:family[1][@qualifier='BR']]
Item: (PN.NL)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:prefix[tokenize(@qualifier,'\s')='VV'][following-sibling::hl7:family[1][@qualifier='BR']]"
         id="d363167e391-false-d363275e0">
      <extends rule="ENXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ENXP' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(PN.NL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="string(@qualifier) = ('VV')">(PN.NL): de waarde van qualifier MOET 'VV' zijn. Gevonden: "<value-of select="@qualifier"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="not(@nullFlavor)">(PN.NL): attribute @nullFlavor MAG NIET voorkomen.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.100
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:family[@qualifier='BR']
Item: (PN.NL)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:family[@qualifier='BR']"
         id="d363167e417-false-d363297e0">
      <extends rule="ENXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ENXP' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(PN.NL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="string(@qualifier) = ('BR')">(PN.NL): de waarde van qualifier MOET 'BR' zijn. Gevonden: "<value-of select="@qualifier"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="not(@nullFlavor)">(PN.NL): attribute @nullFlavor MAG NIET voorkomen.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.100
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:delimiter[not(@nullFlavor)]
Item: (PN.NL)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:delimiter[not(@nullFlavor)]"
         id="d363167e436-false-d363321e0">
      <extends rule="ENXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ENXP' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(PN.NL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="not(@nullFlavor)">(PN.NL): attribute @nullFlavor MAG NIET voorkomen.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.100
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:prefix[tokenize(@qualifier,'\s')='VV'][following-sibling::hl7:family[1][@qualifier='SP']]
Item: (PN.NL)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:prefix[tokenize(@qualifier,'\s')='VV'][following-sibling::hl7:family[1][@qualifier='SP']]"
         id="d363167e472-false-d363337e0">
      <extends rule="ENXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ENXP' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(PN.NL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="string(@qualifier) = ('VV')">(PN.NL): de waarde van qualifier MOET 'VV' zijn. Gevonden: "<value-of select="@qualifier"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="not(@nullFlavor)">(PN.NL): attribute @nullFlavor MAG NIET voorkomen.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.100
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:family[@qualifier='SP']
Item: (PN.NL)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:family[@qualifier='SP']"
         id="d363167e498-false-d363359e0">
      <extends rule="ENXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ENXP' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(PN.NL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="string(@qualifier) = ('SP')">(PN.NL): de waarde van qualifier MOET 'SP' zijn. Gevonden: "<value-of select="@qualifier"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="not(@nullFlavor)">(PN.NL): attribute @nullFlavor MAG NIET voorkomen.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.100
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:suffix[not(@nullFlavor)]
Item: (PN.NL)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:suffix[not(@nullFlavor)]"
         id="d363167e517-false-d363383e0">
      <extends rule="ENXP"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ENXP' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(PN.NL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ENXP" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="string(@qualifier) = ('AC') or not(@qualifier)">(PN.NL): de waarde van qualifier MOET 'AC' zijn. Gevonden: "<value-of select="@qualifier"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="not(@nullFlavor)">(PN.NL): attribute @nullFlavor MAG NIET voorkomen.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.1.100
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:validTime
Item: (PN.NL)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:name/hl7:validTime"
         id="d363167e567-false-d363407e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.1.100-2017-06-02T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(PN.NL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.2
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]
Item: (CDArecordTargetSDTC-NL-BSN-Minimal)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]"
         id="d362541e80-false-d363422e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArecordTargetSDTC-NL-BSN-Minimal): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDArecordTargetSDTC-NL-BSN-Minimal): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1 GeslachtCodelijst (2015-04-01T00:00:00)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(CDArecordTargetSDTC-NL-BSN-Minimal): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst 2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1 GeslachtCodelijst (2015-04-01T00:00:00).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.2
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:birthTime
Item: (CDArecordTargetSDTC-NL-BSN-Minimal)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:birthTime"
         id="d362541e85-false-d363449e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArecordTargetSDTC-NL-BSN-Minimal): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="not(*)">(CDArecordTargetSDTC-NL-BSN-Minimal): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.3.10.2
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/sdtc:multipleBirthInd
Item: (CDArecordTargetSDTC-NL-BSN-Minimal)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:id[@root = '2.16.840.1.113883.2.4.6.3']]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.0.1.1-2015-04-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/sdtc:multipleBirthInd"
         id="d362541e87-false-d363466e0">
      <extends rule="BL"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.3.10.2-2017-06-02T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='BL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(CDArecordTargetSDTC-NL-BSN-Minimal): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:BL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9031
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='RESP']
Item: (kezo-CDAInhoudsverantwoordelijke)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='RESP']"
         id="d363473e9-false-d363479e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9031-2014-11-13T000000.html"
              test="string(@typeCode) = ('RESP')">(kezo-CDAInhoudsverantwoordelijke): de waarde van typeCode MOET 'RESP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9031-2014-11-13T000000.html"
              test="count(hl7:time) &lt;= 1">(kezo-CDAInhoudsverantwoordelijke): element hl7:time komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9031-2014-11-13T000000.html"
              test="count(hl7:participantRole[@classCode = 'ASSIGNED']) &gt;= 1">(kezo-CDAInhoudsverantwoordelijke): element hl7:participantRole[@classCode = 'ASSIGNED'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9031-2014-11-13T000000.html"
              test="count(hl7:participantRole[@classCode = 'ASSIGNED']) &lt;= 1">(kezo-CDAInhoudsverantwoordelijke): element hl7:participantRole[@classCode = 'ASSIGNED'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='RESP']/hl7:time
Item: (kezo-CDAResponsiblePartyBody)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='RESP']/hl7:time"
         id="d363518e45-false-d363526e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-CDAResponsiblePartyBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']
Item: (kezo-CDAResponsiblePartyBody)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']"
         id="d363518e47-false-d363539e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="string(@classCode) = ('ASSIGNED')">(kezo-CDAResponsiblePartyBody): de waarde van classCode MOET 'ASSIGNED' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @nullFlavor]) &lt;= 1">(kezo-CDAResponsiblePartyBody): element hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="count(hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE']) &lt;= 1">(kezo-CDAResponsiblePartyBody): element hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="count(hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(kezo-CDAResponsiblePartyBody): element hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:id
Item: (kezo-CDAResponsiblePartyBody)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:id"
         id="d363518e51-false-d363593e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-CDAResponsiblePartyBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @nullFlavor]
Item: (kezo-CDAResponsiblePartyBody)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.111' or @nullFlavor]"
         id="d363518e57-false-d363606e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-CDAResponsiblePartyBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="@nullFlavor or (@codeSystem='2.16.840.1.113883.2.4.15.111')">(kezo-CDAResponsiblePartyBody): de elementwaarde MOET een zijn van 'codeSystem '2.16.840.1.113883.2.4.15.111''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:addr
Item: (kezo-CDAResponsiblePartyBody)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:addr"
         id="d363518e64-false-d363626e0">
      <extends rule="AD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-CDAResponsiblePartyBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:telecom
Item: (kezo-CDAResponsiblePartyBody)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:telecom"
         id="d363518e66-false-d363639e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-CDAResponsiblePartyBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE']
Item: (kezo-CDAResponsiblePartyBody)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE']"
         id="d363518e69-false-d363652e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="string(@classCode) = ('PSN')">(kezo-CDAResponsiblePartyBody): de waarde van classCode MOET 'PSN' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="string(@determinerCode) = ('INSTANCE')">(kezo-CDAResponsiblePartyBody): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(kezo-CDAResponsiblePartyBody): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (kezo-CDAResponsiblePartyBody)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d363518e78-false-d363690e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-CDAResponsiblePartyBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(kezo-CDAResponsiblePartyBody): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.1.11.2 RoleCodeNL - zorgverlenertype (personen) (DYNAMISCH)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:name
Item: (kezo-CDAResponsiblePartyBody)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:name"
         id="d363518e83-false-d363714e0">
      <extends rule="PN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-CDAResponsiblePartyBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (kezo-CDAResponsiblePartyBody)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']"
         id="d363518e86-false-d363727e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="string(@classCode) = ('ORG')">(kezo-CDAResponsiblePartyBody): de waarde van classCode MOET 'ORG' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="string(@determinerCode) = ('INSTANCE')">(kezo-CDAResponsiblePartyBody): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor]) &lt;= 1">(kezo-CDAResponsiblePartyBody): element hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="count(hl7:desc) &lt;= 1">(kezo-CDAResponsiblePartyBody): element hl7:desc komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id
Item: (kezo-CDAResponsiblePartyBody)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id"
         id="d363518e95-false-d363770e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-CDAResponsiblePartyBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor]
Item: (kezo-CDAResponsiblePartyBody)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:code[@codeSystem = '2.16.840.1.113883.2.4.15.1060' or @nullFlavor]"
         id="d363518e97-false-d363783e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-CDAResponsiblePartyBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="@nullFlavor or (@codeSystem='2.16.840.1.113883.2.4.15.1060')">(kezo-CDAResponsiblePartyBody): de elementwaarde MOET een zijn van 'codeSystem '2.16.840.1.113883.2.4.15.1060''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9030
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:desc
Item: (kezo-CDAResponsiblePartyBody)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='RESP']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:desc"
         id="d363518e103-false-d363803e0">
      <extends rule="ED"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9030-2014-11-13T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ED' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-CDAResponsiblePartyBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ED" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9032
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='CST']
Item: (kezo-CDADossierhouder)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='CST']"
         id="d363810e9-false-d363816e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9032-2014-11-13T000000.html"
              test="string(@typeCode) = ('CST')">(kezo-CDADossierhouder): de waarde van typeCode MOET 'CST' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9032-2014-11-13T000000.html"
              test="count(hl7:time) &lt;= 1">(kezo-CDADossierhouder): element hl7:time komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9032-2014-11-13T000000.html"
              test="count(hl7:participantRole[@classCode = 'ASSIGNED']) &gt;= 1">(kezo-CDADossierhouder): element hl7:participantRole[@classCode = 'ASSIGNED'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9032-2014-11-13T000000.html"
              test="count(hl7:participantRole[@classCode = 'ASSIGNED']) &lt;= 1">(kezo-CDADossierhouder): element hl7:participantRole[@classCode = 'ASSIGNED'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9041
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='CST']/hl7:time
Item: (kezo-CDACustodianPartyBody)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='CST']/hl7:time"
         id="d363855e79-false-d363863e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='IVL_TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-CDACustodianPartyBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9041
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']
Item: (kezo-CDACustodianPartyBody)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']"
         id="d363855e81-false-d363876e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="string(@classCode) = ('ASSIGNED')">(kezo-CDACustodianPartyBody): de waarde van classCode MOET 'ASSIGNED' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="count(hl7:id) &gt;= 1">(kezo-CDACustodianPartyBody): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.1.6-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.1.7-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(kezo-CDACustodianPartyBody): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.1.6-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.1.7-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="count(hl7:playingEntity[@classCode = ('PSN', 'ORG')][@determinerCode = 'INSTANCE']) &lt;= 1">(kezo-CDACustodianPartyBody): element hl7:playingEntity[@classCode = ('PSN', 'ORG')][@determinerCode = 'INSTANCE'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="count(hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(kezo-CDACustodianPartyBody): element hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9041
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:id
Item: (kezo-CDACustodianPartyBody)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:id"
         id="d363855e88-false-d363942e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-CDACustodianPartyBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9041
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.1.6-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.1.7-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (kezo-CDACustodianPartyBody)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.1.6-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.1.7-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d363855e94-false-d363961e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-CDACustodianPartyBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]]) or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.1.6-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]]) or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.1.7-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(kezo-CDACustodianPartyBody): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3 OrganisatieTypeCodelijst (DYNAMISCH) of 2.16.840.1.113883.2.4.3.11.60.40.2.17.1.6 SpecialismeUZICodelijst (DYNAMISCH) of 2.16.840.1.113883.2.4.3.11.60.40.2.17.1.7 SpecialismeAGBCodelijst (DYNAMISCH)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9041
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:addr
Item: (kezo-CDACustodianPartyBody)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:addr"
         id="d363855e106-false-d363997e0">
      <extends rule="AD"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-CDACustodianPartyBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9041
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:telecom
Item: (kezo-CDACustodianPartyBody)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:telecom"
         id="d363855e109-false-d364010e0">
      <extends rule="TEL.NL.EXTENDED"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-CDACustodianPartyBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9041
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = ('PSN', 'ORG')][@determinerCode = 'INSTANCE']
Item: (kezo-CDACustodianPartyBody)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = ('PSN', 'ORG')][@determinerCode = 'INSTANCE']"
         id="d363855e111-false-d364023e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="@classCode">(kezo-CDACustodianPartyBody): attribute @classCode MOET aanwezig zijn.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@classCode),'\s'))"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="not(@classCode) or empty($theAttValue[not(. = (('PSN','ORG')))])">(kezo-CDACustodianPartyBody): de waarde van classCode MOET 'code PSN of code ORG' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="string(@determinerCode) = ('INSTANCE')">(kezo-CDACustodianPartyBody): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="count(hl7:name) &gt;= 1">(kezo-CDACustodianPartyBody): element hl7:name is required [min 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9041
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = ('PSN', 'ORG')][@determinerCode = 'INSTANCE']/hl7:name
Item: (kezo-CDACustodianPartyBody)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:playingEntity[@classCode = ('PSN', 'ORG')][@determinerCode = 'INSTANCE']/hl7:name"
         id="d363855e122-false-d364068e0">
      <extends rule="PN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-CDACustodianPartyBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9041
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (kezo-CDACustodianPartyBody)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']"
         id="d363855e125-false-d364081e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="string(@classCode) = ('ORG')">(kezo-CDACustodianPartyBody): de waarde van classCode MOET 'ORG' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="string(@determinerCode) = ('INSTANCE')">(kezo-CDACustodianPartyBody): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(kezo-CDACustodianPartyBody): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="count(hl7:desc) &gt;= 1">(kezo-CDACustodianPartyBody): element hl7:desc is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="count(hl7:desc) &lt;= 1">(kezo-CDACustodianPartyBody): element hl7:desc komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9041
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id
Item: (kezo-CDACustodianPartyBody)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id"
         id="d363855e134-false-d364132e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-CDACustodianPartyBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9041
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (kezo-CDACustodianPartyBody)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d363855e140-false-d364147e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-CDACustodianPartyBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(kezo-CDACustodianPartyBody): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3 OrganisatieTypeCodelijst (DYNAMISCH)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9041
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:desc
Item: (kezo-CDACustodianPartyBody)
-->

   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:participant[@typeCode='CST']/hl7:participantRole[@classCode = 'ASSIGNED']/hl7:scopingEntity[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:desc"
         id="d363855e146-false-d364171e0">
      <extends rule="ED"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.9041-2018-10-16T000000.html"
              test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ED' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(kezo-CDACustodianPartyBody): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ED" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.74
Context: //hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:component[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]
Item: (OrganizerMedicatieafspraken)
-->
   <rule context="//hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.74'] and hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9192']]/hl7:component[cda:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.404'] and cda:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.20.77.10.9148']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.74-2018-04-18T000000.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(OrganizerMedicatieafspraken): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/ketenzorg/kz-html-20190110T164948/tmp-2.16.840.1.113883.2.4.3.11.60.66.10.74-2018-04-18T000000.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(OrganizerMedicatieafspraken): de waarde van contextControlCode MOET 'OP' zijn. Gevonden: "<value-of select="@contextControlCode"/>"</assert>
   </rule>
</pattern>
