<schema xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:hl7="urn:hl7-org:v3" xmlns:sch="http://purl.oclc.org/dsdl/schematron" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:uuid="java:java.util.UUID" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" queryBinding="xslt2">
    <!-- Template 2.16.840.1.113883.2.4.3.11.60.55.10.9021 - Transactie : Sturen raportage verleende zorg aan HA -->
    <!-- Schematron validatie voor Nictiz kwalificatie -->
    <!-- Tests zijn gebaseerd op het document 'Rapportage geleverde zorg - bijlage.docx' uit de PS folder -->
    
    <!-- Voorlopig zijn we niet te streng met precieze tijdstippen controleren; 
        Alleen controleren of tijdstippen inderdaad voor dan wel na het moment van verzenden vallen.  
        Met tijdstippen op precies T is het wellicht lastig dit in de software voor elkaar te krijgen; dan maar alleen datum controleren -->
    
    <ns uri="urn:hl7-org:v3" prefix="hl7"/>
    <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
    <ns uri="urn:oid:2.16.840.1.113883.2.4.6.10.35.81" prefix="lab"/>
    <ns uri="urn:ihe:pharm:medication" prefix="pharm"/>
    <ns uri="http://www.w3.org/XML/1998/namespace" prefix="xml"/>
    <ns uri="http://www.w3.org/2001/XMLSchema" prefix="xs"/>

    <let name="oidClinicalDocument" value="'2.16.840.1.113883.2.4.3.11.60.55.10.9021'"/>

    <!--<let name="gOIDICPCNL" value="'2.16.840.1.113883.2.4.4.31.1'"/>-->
    
<!--    <let name="OID_UZI" value="'2.16.528.1.1007.3.1'"/>
    <let name="OID_URA" value="'2.16.528.1.1007.3.3'"/>
    <let name="OID_AGB" value="'2.16.840.1.113883.2.4.6.1'"/>
    <let name="OID_GPK" value="'2.16.840.1.113883.2.4.4.1'"/>
    
    
    <let name="OID_OwnGP" value="'2.16.840.1.113883.2.4.3.11.60.55.10.105'"/>
    <let name="OID_ContactPerson" value="'2.16.840.1.113883.2.4.3.11.60.55.10.104'"/>-->
    
    <let name="OID_ContactReport" value="'2.16.840.1.113883.2.4.3.11.60.55.10.9022'"/>
    <let name="OID_ReportWithAttachments" value="'2.16.840.1.113883.2.4.3.11.60.55.10.9024'"/>

    <let name="baseT" value="//hl7:ClinicalDocument[hl7:templateId/@root = $oidClinicalDocument]/hl7:effectiveTime/@value"/>
    <let name="baseTd" value="if (matches($baseT, '^\d{8}')) then concat(substring($baseT,1,4),'-',substring($baseT,5,2),'-',substring($baseT,7,2)) else string(current-date())"/>
    
    <pattern id="RapportagenaarHA">
        <!-- Juiste document type -->
        <rule context="/">
            <assert role="error" test="count(//hl7:ClinicalDocument[hl7:templateId/@root = $oidClinicalDocument])=1">
                ClinicalDocument met templateId/@root = '<value-of select="$oidClinicalDocument"/>' is het root element en moet precies 1 keer voorkomen.
                Nu: <value-of select="count(//hl7:ClinicalDocument[hl7:templateId/@root = $oidClinicalDocument])"/>x 
            </assert>
        </rule>
        
        <!-- Zijn alle ID root - extension's uniek binnen het document, en zijn de gebruikte roots uniek over alle zorgaanbieders? -->
        <include href="include/ID_checks.sch"/>
        
        <!-- Patiënt -->
        <include href="include/r_patient_999910516_d_hofland.sch"/>
        <rule context="//hl7:ClinicalDocument[hl7:templateId/@root = $oidClinicalDocument]/hl7:recordTarget/hl7:patientRole">
            <let name="doDetails" value="true()"/>
            <extends rule="r_patient_999910516_d_hofland"/>
        </rule>
        
        <!-- Auteur -->
        <!-- TODO: eisen aan auteur? Meldkamertriagist? -->
 <!--       <let name="roleCodeVerpleegkundige" value="'30.*'"/>
        <rule context="//hl7:ClinicalDocument/hl7:author/hl7:assignedAuthor">
            <assert role="error" test="matches(hl7:code/@code, $roleCodeVerpleegkundige)">
                Auteur moet rolcode <value-of select="$roleCodeVerpleegkundige"/> (verpleegkundige) hebben. Gevonden: <value-of select="hl7:code/@code"/>
            </assert>
        </rule>-->
        
        <!-- Custodian - moet dit getest worden? Of is dat per leverancier anders? -->
<!--        <let name="custodianId" value="'25'"/>
        <let name="custodianIdRoot" value="'2.16.840.1.113883.2.4.3.11.60.55.15.1'"/>
        <rule context="//hl7:ClinicalDocument/hl7:custodian/hl7:assignedCustodian/hl7:representedCustodianOrganization">
            <assert role="error" test="hl7:id[@extension = $custodianId][@root = $custodianIdRoot]">
                Custodian moet id <value-of select="$custodianId"/> hebben. Gevonden: <value-of select="hl7:id/@extension"/>
            </assert>
        </rule>-->
   
        
        <!-- Check op de aanwezigheid van de secties (bij dit bericht allemaal) -->
        <rule context="//hl7:ClinicalDocument/hl7:component/hl7:structuredBody">
            <assert role="error" test="count(hl7:component/hl7:section/hl7:templateId[@root=$OID_ContactReport]) = 1">
                Sectie 'Emergency Notification' (template <value-of select="$OID_ContactReport"/>) moet precies 1x voorkomen
            </assert>
            <assert role="error" test="count(hl7:component/hl7:section/hl7:templateId[@root=$OID_ReportWithAttachments]) = 1">
                Sectie 'Ambulance Drive' (template <value-of select="$OID_ReportWithAttachments"/>) moet precies 1x voorkomen
            </assert>
        </rule>

        <!-- Contactverslag -->
        <rule context="//hl7:ClinicalDocument/hl7:component/hl7:structuredBody/hl7:component/hl7:section[hl7:templateId/@root=$OID_ContactReport]/hl7:entry/hl7:act">
            <let name="labelSection" value="'Contactverslag'"/>
            <let name="diagnoseCode" value="'K74'"/>
                        
            <!-- datum/tijd van de melding moet voor de creatie datum/tijd van het bericht liggen -->
            <assert test="xs:integer(substring(hl7:effectiveTime/@value, 1, 12)) - xs:integer(substring($baseT, 1, 12)) lt 0">
                <value-of select="$labelSection"/>: De datum/tijd van de melding (<value-of select="hl7:effectiveTime/@value"/>) moet voor de datum/tijd van het bericht (<value-of select="$baseT"/>) liggen. 
            </assert>
            
            <!-- S, E en P regel moeten aanwezig zijn, O regel mag niet -->
            <assert role="error" test="hl7:entryRelationship[hl7:act/hl7:templateId/@root='2.16.840.1.113883.2.4.3.11.60.66.10.208']/hl7:act/hl7:text">
                <value-of select="$labelSection"/> :: contactverslag - S-regel moet voorkomen. 
            </assert>    
            <assert role="error" test="not(hl7:entryRelationship[hl7:act/hl7:templateId/@root='2.16.840.1.113883.2.4.3.11.60.66.10.209']/hl7:act/hl7:text)">
                <value-of select="$labelSection"/> :: contactverslag - O-regel mag niet voorkomen. 
            </assert>    
            <assert role="error" test="hl7:entryRelationship[hl7:act/hl7:templateId/@root='2.16.840.1.113883.2.4.3.11.60.66.10.211']/hl7:act/hl7:text">
                <value-of select="$labelSection"/> :: contactverslag - P-regel moet voorkomen. 
            </assert>    
            <let name="E-act" value="hl7:entryRelationship[hl7:act/hl7:templateId/@root='2.16.840.1.113883.2.4.3.11.60.66.10.210']/hl7:act"/>
            <assert role="error" test="$E-act">
                <value-of select="$labelSection"/> :: contactverslag - E-regel moet voorkomen. 
            </assert>
            <!-- De juiste diagnose is ingevuld in de E regel -->
            <assert role="error" test="$E-act/hl7:entryRelationship/hl7:observation/hl7:value/@code = $diagnoseCode">
                <value-of select="$labelSection"/> :: contactverslag - E-regel moet de diagnose <value-of select="$diagnoseCode"/> bevatten. 
                Gevonden: <value-of select="$E-act/hl7:entryRelationship/hl7:observation/hl7:value/@code"/>.
            </assert>
        </rule>
        
        <!-- Rapportage en bijlagen -->
        <rule context="//hl7:ClinicalDocument/hl7:component/hl7:structuredBody/hl7:component/hl7:section[hl7:templateId/@root=$OID_ReportWithAttachments]">
            <let name="labelSection" value="'Rapportage en Bijlagen'"/>

            <!-- Rapportage tekst aanwezig en niet leeg -->
            <assert role="error" test="hl7:text and not(empty(hl7:text))">
                <value-of select="$labelSection"/> :: rapportage tekst moet ingevuld zijn.
            </assert>

            <!-- ofwel 0, ofwel 2 bijlagen -->
            <let name="attachmentList" value="hl7:entry[hl7:observation/hl7:templateId/@root = '2.16.840.1.113883.2.4.3.11.60.55.10.1181']"/>
            <let name="nrAttachments" value="count($attachmentList)"/>
            <assert role="warning" test="$nrAttachments ne 0">
                <value-of select="$labelSection"/> :: Voor meldkamer software is het toegestaan geen bijlagen op te leveren. 
                Voor Ambulance en SEH software worden wel 2 bijlagen verwacht.
            </assert>
            <assert role="error" test="$nrAttachments eq 2 or $nrAttachments eq 0">
                <value-of select="$labelSection"/> :: Er moeten 0 of 2 bijlagen aanwezig zijn. Gevonden: <value-of select="$nrAttachments"/>.
            </assert>
            
            <!-- Als bijlagen, dan verschillende setID's en bijlage ID's, en type bijlage = 001 -->
            <let name="setIds" value="$attachmentList/hl7:observation/hl7:reference/hl7:externalDocument/hl7:setId/@extension"/>
            <assert role="error" test="not($nrAttachments eq 2) or count(distinct-values($setIds)) eq 2">
                <value-of select="$labelSection"/> :: De setID's van de 2 bijlagen moeten verschillen. Gevonden: <value-of select="$setIds"/> 
            </assert>
            <let name="attachmentIds" value="$attachmentList/hl7:observation/hl7:reference/hl7:externalDocument/hl7:id/@extension"/>
            <assert role="error" test="not($nrAttachments eq 2) or count(distinct-values($attachmentIds)) eq 2">
                <value-of select="$labelSection"/> :: De bijlage ID's van de 2 bijlagen moeten verschillen. Gevonden: <value-of select="$attachmentIds"/> 
            </assert>
            <let name="attachmentTypes" value="$attachmentList/hl7:observation/hl7:reference/hl7:externalDocument/hl7:code/@code"/>
            <assert role="error" test="not($nrAttachments eq 2) or $attachmentTypes[1] = '001' and $attachmentTypes[2] = '001'">
                <value-of select="$labelSection"/> :: Het type van beide bijlagen moet '001' (12 afleidingen ECG) zijn. Gevonden: <value-of select="$attachmentTypes"/> 
            </assert>
        </rule>
            

        <!-- timezone checks -->
        <include href="include/timezone_checks.sch"/>
    </pattern>
    

</schema>