<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.11.60.55.10.306
Name: Acuity Assessment
Description: Acuity Assessment: Triagegevens. Wijzgingen t.o.v. van versie 2016-02-25T00:00:00: observation/participant[@typeCode=DEV] bevat het gebruikte triagesysteem. de observation/value bevat de urgentiecategorie zoals gegenereerd door het systeem (of @nullFlavor=NA (niet van toepassing)). Een urgentiecategorie van de triagist staat in observation/entryRelationship/observation/value met bijbehorende reden daarvoor. De template ondersteunt nu ook doorgeven van een reden voor overslaan.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron" id="template-2.16.840.1.113883.2.4.3.11.60.55.10.306-2018-11-01T000000">
   <title>Acuity Assessment</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.306
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]
Item: (AcuityAssessment)
-->
   <rule fpi="RULC-1" context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]" id="d152e9462-false-d26498e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]) &gt;= 1">(AcuityAssessment): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']] is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]) &lt;= 1">(AcuityAssessment): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.306
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]
Item: (AcuityAssessment)
-->
   <rule fpi="RULC-1" context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]" id="d152e9545-false-d26544e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="string(@classCode) = ('OBS')">(AcuityAssessment): de waarde van classCode MOET 'OBS' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="string(@moodCode) = ('EVN')">(AcuityAssessment): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="hl7:id[not(@nullFlavor)] or hl7:value[@nullFlavor = 'NA']">(AcuityAssessment): Als er een urgentiecategorie (systeem) is, dan moet de triage een identificatie hebben.</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="hl7:entryRelationship/*[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.315']] or hl7:value[@nullFlavor = 'NA']">(AcuityAssessment): Als er een urgentiecategorie (systeem) is, dan moet er ook een urgentiecategorie (triagist) zijn.</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="not(hl7:entryRelationship/*[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.9011']]) or hl7:value[@nullFlavor = 'NA']">(AcuityAssessment): Er kan alleen een reden overslaan triage zijn als er geen urgentiecategorie (systeem) is.</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']) &gt;= 1">(AcuityAssessment): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306'] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']) &lt;= 1">(AcuityAssessment): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306'] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:id) &gt;= 1">(AcuityAssessment): element hl7:id is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:code[(@code = '11283-9' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(AcuityAssessment): element hl7:code[(@code = '11283-9' and @codeSystem = '2.16.840.1.113883.6.1')] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:code[(@code = '11283-9' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(AcuityAssessment): element hl7:code[(@code = '11283-9' and @codeSystem = '2.16.840.1.113883.6.1')] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:text) &lt;= 1">(AcuityAssessment): element hl7:text komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:effectiveTime) &gt;= 1">(AcuityAssessment): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:effectiveTime) &lt;= 1">(AcuityAssessment): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:value) &gt;= 1">(AcuityAssessment): element hl7:value is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:value) &lt;= 1">(AcuityAssessment): element hl7:value komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:methodCode) &lt;= 1">(AcuityAssessment): element hl7:methodCode komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:performer[hl7:assignedEntity[@nullFlavor = 'NA']]) &lt;= 1">(AcuityAssessment): element hl7:performer[hl7:assignedEntity[@nullFlavor = 'NA']] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:participant[@typeCode = 'DEV'][hl7:participantRole]) &lt;= 1">(AcuityAssessment): element hl7:participant[@typeCode = 'DEV'][hl7:participantRole] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.315']]]) &lt;= 1">(AcuityAssessment): element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.315']]] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.307']]]) &lt;= 1">(AcuityAssessment): element hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.307']]] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:entryRelationship[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.308']]]) &lt;= 1">(AcuityAssessment): element hl7:entryRelationship[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.308']]] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.40'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.2']]]) &lt;= 1">(AcuityAssessment): element hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.40'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.2']]] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.9011']]]) &lt;= 1">(AcuityAssessment): element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.9011']]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.306
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']
Item: (AcuityAssessment)
-->
   <rule fpi="RULC-1" context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']" id="d152e9554-false-d26732e0">
      <extends rule="II"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(AcuityAssessment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.55.10.306')">(AcuityAssessment): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.55.10.306' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.306
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:id
Item: (AcuityAssessment)
-->
   <rule fpi="RULC-1" context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:id" id="d152e9559-false-d26750e0">
      <extends rule="II"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(AcuityAssessment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="string(@nullFlavor) = ('NA') or not(@nullFlavor)">(AcuityAssessment): de waarde van nullFlavor MOET 'NA' zijn. Gevonden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.306
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:code[(@code = '11283-9' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (AcuityAssessment)
-->
   <rule fpi="RULC-1" context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:code[(@code = '11283-9' and @codeSystem = '2.16.840.1.113883.6.1')]" id="d152e9568-false-d26769e0">
      <extends rule="CE"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(AcuityAssessment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="string(@code) = ('11283-9')">(AcuityAssessment): de waarde van code MOET '11283-9' zijn. Gevonden: "<value-of select="@code"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(AcuityAssessment): de waarde van codeSystem MOET '2.16.840.1.113883.6.1' zijn. Gevonden: "<value-of select="@codeSystem"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.306
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:text
Item: (AcuityAssessment)
-->
   <rule fpi="RULC-1" context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:text" id="d152e9575-false-d26793e0">
      <extends rule="ED"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(AcuityAssessment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ED" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:reference) &gt;= 1">(AcuityAssessment): element hl7:reference is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:reference) &lt;= 1">(AcuityAssessment): element hl7:reference komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.306
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:text/hl7:reference
Item: (AcuityAssessment)
-->
   <rule fpi="RULC-1" context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:text/hl7:reference" id="d152e9580-false-d26820e0">
      <extends rule="URL"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'URL')">(AcuityAssessment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:URL" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.306
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:effectiveTime
Item: (AcuityAssessment)
-->
   <rule fpi="RULC-1" context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:effectiveTime" id="d152e9583-false-d26832e0">
      <extends rule="IVL_TS"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(AcuityAssessment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:low) &gt;= 1">(AcuityAssessment): element hl7:low is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:low) &lt;= 1">(AcuityAssessment): element hl7:low komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:high) &lt;= 1">(AcuityAssessment): element hl7:high komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.306
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:effectiveTime/hl7:low
Item: (AcuityAssessment)
-->
   <rule fpi="RULC-1" context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:effectiveTime/hl7:low" id="d152e9588-false-d26868e0">
      <extends rule="TS"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(AcuityAssessment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="not(*)">(AcuityAssessment): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.306
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:effectiveTime/hl7:high
Item: (AcuityAssessment)
-->
   <rule fpi="RULC-1" context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:effectiveTime/hl7:high" id="d152e9594-false-d26884e0">
      <extends rule="TS"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(AcuityAssessment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="not(*)">(AcuityAssessment): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.306
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:value
Item: (AcuityAssessment)
-->
   <rule fpi="RULC-1" context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:value" id="d152e9599-false-d26902e0">
      <extends rule="CD"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(AcuityAssessment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CD" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="not(@nullFlavor) or @nullFlavor=('OTH','NA')">(AcuityAssessment): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst .</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(AcuityAssessment): attribuut @code MOET datatype 'cs' hebben  - '<value-of select="@code"/>'</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="not(@displayName) or string-length(@displayName)&gt;0">(AcuityAssessment): attribuut @displayName MOET datatype 'st' hebben  - '<value-of select="@displayName"/>'</assert>
      <let name="theAttValue" value="distinct-values(tokenize(normalize-space(@nullFlavor),'\s'))"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="not(@nullFlavor) or empty($theAttValue[not(. = (('OTH','NA')))])">(AcuityAssessment): de waarde van nullFlavor MOET 'code OTH of code NA' zijn. Gevonden: "<value-of select="@nullFlavor"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:originalText) &lt;= 1">(AcuityAssessment): element hl7:originalText komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:translation) &lt;= 1">(AcuityAssessment): element hl7:translation komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.306
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:value/hl7:originalText
Item: (AcuityAssessment)
-->
   <rule fpi="RULC-1" context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:value/hl7:originalText" id="d152e9633-false-d26969e0">
      <extends rule="ST"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(AcuityAssessment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.306
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:value/hl7:translation
Item: (AcuityAssessment)
-->
   <rule fpi="RULC-1" context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:value/hl7:translation" id="d152e9642-false-d26981e0">
      <extends rule="CD"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(AcuityAssessment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CD" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="@code">(AcuityAssessment): attribute @code MOET aanwezig zijn.</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(AcuityAssessment): attribuut @code MOET datatype 'cs' hebben  - '<value-of select="@code"/>'</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="@displayName">(AcuityAssessment): attribute @displayName MOET aanwezig zijn.</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="not(@displayName) or string-length(@displayName)&gt;0">(AcuityAssessment): attribuut @displayName MOET datatype 'st' hebben  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.306
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:methodCode
Item: (AcuityAssessment)
-->
   <rule fpi="RULC-1" context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:methodCode" id="d152e9656-false-d27015e0">
      <extends rule="CE"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(AcuityAssessment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.306
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:performer[hl7:assignedEntity[@nullFlavor = 'NA']]
Item: (AcuityAssessment)
-->
   <rule fpi="RULC-1" context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:performer[hl7:assignedEntity[@nullFlavor = 'NA']]" id="d152e9670-false-d27031e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:time) &lt;= 1">(AcuityAssessment): element hl7:time komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:assignedEntity[@nullFlavor = 'NA']) &gt;= 1">(AcuityAssessment): element hl7:assignedEntity[@nullFlavor = 'NA'] is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:assignedEntity[@nullFlavor = 'NA']) &lt;= 1">(AcuityAssessment): element hl7:assignedEntity[@nullFlavor = 'NA'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.306
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:performer[hl7:assignedEntity[@nullFlavor = 'NA']]/hl7:time
Item: (AcuityAssessment)
-->
   <rule fpi="RULC-1" context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:performer[hl7:assignedEntity[@nullFlavor = 'NA']]/hl7:time" id="d152e9694-false-d27063e0">
      <extends rule="IVL_TS"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(AcuityAssessment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:low) &lt;= 1">(AcuityAssessment): element hl7:low komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:high) &lt;= 1">(AcuityAssessment): element hl7:high komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.306
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:performer[hl7:assignedEntity[@nullFlavor = 'NA']]/hl7:time/hl7:low
Item: (AcuityAssessment)
-->
   <rule fpi="RULC-1" context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:performer[hl7:assignedEntity[@nullFlavor = 'NA']]/hl7:time/hl7:low" id="d152e9699-false-d27093e0">
      <extends rule="TS"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(AcuityAssessment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="not(*)">(AcuityAssessment): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.306
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:performer[hl7:assignedEntity[@nullFlavor = 'NA']]/hl7:time/hl7:high
Item: (AcuityAssessment)
-->
   <rule fpi="RULC-1" context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:performer[hl7:assignedEntity[@nullFlavor = 'NA']]/hl7:time/hl7:high" id="d152e9701-false-d27109e0">
      <extends rule="TS"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(AcuityAssessment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="not(*)">(AcuityAssessment): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.306
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:performer[hl7:assignedEntity[@nullFlavor = 'NA']]/hl7:assignedEntity[@nullFlavor = 'NA']
Item: (AcuityAssessment)
-->
   <rule fpi="RULC-1" context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:performer[hl7:assignedEntity[@nullFlavor = 'NA']]/hl7:assignedEntity[@nullFlavor = 'NA']" id="d152e9704-false-d27125e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="string(@nullFlavor) = ('NA')">(AcuityAssessment): de waarde van nullFlavor MOET 'NA' zijn. Gevonden: "<value-of select="@nullFlavor"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:id[@nullFlavor = 'NA']) &gt;= 1">(AcuityAssessment): element hl7:id[@nullFlavor = 'NA'] is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="count(hl7:id[@nullFlavor = 'NA']) &lt;= 1">(AcuityAssessment): element hl7:id[@nullFlavor = 'NA'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.306
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:performer[hl7:assignedEntity[@nullFlavor = 'NA']]/hl7:assignedEntity[@nullFlavor = 'NA']/hl7:id[@nullFlavor = 'NA']
Item: (AcuityAssessment)
-->
   <rule fpi="RULC-1" context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:performer[hl7:assignedEntity[@nullFlavor = 'NA']]/hl7:assignedEntity[@nullFlavor = 'NA']/hl7:id[@nullFlavor = 'NA']" id="d152e9708-false-d27154e0">
      <extends rule="II"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(AcuityAssessment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="string(@nullFlavor) = ('NA')">(AcuityAssessment): de waarde van nullFlavor MOET 'NA' zijn. Gevonden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.306
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:participant[@typeCode = 'DEV'][hl7:participantRole]
Item: (AcuityAssessment)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.9010
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:participant[@typeCode = 'DEV'][hl7:participantRole]
Item: (AcuityAssessmentSystem)
-->
   <rule fpi="RULC-1" context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:participant[@typeCode = 'DEV'][hl7:participantRole]">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.9010" test="string(@typeCode) = ('DEV')">(AcuityAssessmentSystem): de waarde van typeCode MOET 'DEV' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.9010" test="count(hl7:participantRole[hl7:playingDevice[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.85-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]) &gt;= 1">(AcuityAssessmentSystem): element hl7:participantRole[hl7:playingDevice[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.85-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]] is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.9010" test="count(hl7:participantRole[hl7:playingDevice[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.85-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]) &lt;= 1">(AcuityAssessmentSystem): element hl7:participantRole[hl7:playingDevice[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.85-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.9010
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:participant[@typeCode = 'DEV'][hl7:participantRole]/hl7:participantRole[hl7:playingDevice[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.85-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]
Item: (AcuityAssessmentSystem)
-->
   <rule fpi="RULC-1" context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:participant[@typeCode = 'DEV'][hl7:participantRole]/hl7:participantRole[hl7:playingDevice[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.85-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.9010" test="count(hl7:playingDevice[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.85-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &gt;= 1">(AcuityAssessmentSystem): element hl7:playingDevice[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.85-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.9010" test="count(hl7:playingDevice[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.85-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &lt;= 1">(AcuityAssessmentSystem): element hl7:playingDevice[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.85-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.9010
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:participant[@typeCode = 'DEV'][hl7:participantRole]/hl7:participantRole[hl7:playingDevice[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.85-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/hl7:playingDevice[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.85-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]
Item: (AcuityAssessmentSystem)
-->
   <rule fpi="RULC-1" context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:participant[@typeCode = 'DEV'][hl7:participantRole]/hl7:participantRole[hl7:playingDevice[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.85-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/hl7:playingDevice[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.85-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]">
      <report fpi="CD-UNKN-BSP" role="warning" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.9010" test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.85-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt; 1">(AcuityAssessmentSystem): element hl7:code is gecodeerd met bindingssterkte 'extensible' en bevat een code buiten de gespecificeerde set.</report>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.9010" test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.85-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(AcuityAssessmentSystem): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.85-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.9010
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:participant[@typeCode = 'DEV'][hl7:participantRole]/hl7:participantRole[hl7:playingDevice[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.85-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/hl7:playingDevice[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.85-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.85-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (AcuityAssessmentSystem)
-->
   <rule fpi="RULC-1" context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:participant[@typeCode = 'DEV'][hl7:participantRole]/hl7:participantRole[hl7:playingDevice[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.85-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/hl7:playingDevice[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.85-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.85-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <extends rule="CE"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.9010" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(AcuityAssessmentSystem): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.9010" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.85-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(AcuityAssessmentSystem): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.55.11.85 Triagesystemen (DYNAMISCH)'.</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.9010" test="not(@nullFlavor) or @nullFlavor=('OTH')">(AcuityAssessmentSystem): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst 2.16.840.1.113883.2.4.3.11.60.55.11.85 Triagesystemen (DYNAMISCH).</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.9010" test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(AcuityAssessmentSystem): attribuut @code MOET datatype 'cs' hebben  - '<value-of select="@code"/>'</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.9010" test="not(@displayName) or string-length(@displayName)&gt;0">(AcuityAssessmentSystem): attribuut @displayName MOET datatype 'st' hebben  - '<value-of select="@displayName"/>'</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.9010" test="count(hl7:originalText) &lt;= 1">(AcuityAssessmentSystem): element hl7:originalText komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.9010
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:participant[@typeCode = 'DEV'][hl7:participantRole]/hl7:participantRole[hl7:playingDevice[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.85-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/hl7:playingDevice[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.85-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.85-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]/hl7:originalText
Item: (AcuityAssessmentSystem)
-->
   <rule fpi="RULC-1" context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:participant[@typeCode = 'DEV'][hl7:participantRole]/hl7:participantRole[hl7:playingDevice[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.85-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/hl7:playingDevice[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.85-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.85-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]/hl7:originalText">
      <extends rule="ST"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.9010" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(AcuityAssessmentSystem): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.306
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.315']]]
Item: (AcuityAssessment)
-->
   <rule fpi="RULC-1" context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.315']]]">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="string(@typeCode) = ('SPRT')">(AcuityAssessment): de waarde van typeCode MOET 'SPRT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="string(@inversionInd) = ('true')">(AcuityAssessment): de waarde van inversionInd MOET 'true' zijn. Gevonden: "<value-of select="@inversionInd"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.306
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.307']]]
Item: (AcuityAssessment)
-->
   <rule fpi="RULC-1" context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.307']]]">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="string(@typeCode) = ('COMP')">(AcuityAssessment): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.306
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:entryRelationship[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.308']]]
Item: (AcuityAssessment)
-->
   <rule fpi="RULC-1" context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:entryRelationship[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.308']]]">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="string(@typeCode) = ('SPRT')">(AcuityAssessment): de waarde van typeCode MOET 'SPRT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.306
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.40'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.2']]]
Item: (AcuityAssessment)
-->
   <rule fpi="RULC-1" context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.40'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.2']]]">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="string(@typeCode) = ('COMP')">(AcuityAssessment): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.306
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.9011']]]
Item: (AcuityAssessment)
-->
   <rule fpi="RULC-1" context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.306']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.9011']]]">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.306" test="string(@typeCode) = ('COMP')">(AcuityAssessment): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>
</pattern>