<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.11.60.66.10.201
Name: KEZO Contactmoment
Description: Het bouwsteentype Contactmoment hoort bij elke situatie waarbij een patiënt contact heeft gehad met een zorgverlener in het kader van diagnostiek of behandeling. Dit komt globaal overeen met het HL7v3 concept van een Encounter. Een Encounter kan echter betrekking hebben op een klinische opname of dagopname, terwijl het Contactmoment zoals bedoeld in de data set Ketenzorg betrekking heeft op ambulante contacten (d.w.z. contacten waarbij de patiënt de zorginstelling bezoekt, maar er geen bed heeft gebruikt). Verdere informatie
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron" id="template-2.16.840.1.113883.2.4.3.11.60.66.10.201-2015-07-08T000000">
   <title>KEZO Contactmoment</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.201
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]
Item: (KEZO Contactmoment)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.201
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]
Item: (KEZO Contactmoment)
-->
   <rule fpi="RULC-1" context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]" id="d152e9186-false-d46761e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="string(@classCode) = ('ENC')">(KEZO Contactmoment): de waarde van classCode MOET 'ENC' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="string(@moodCode) = ('EVN')">(KEZO Contactmoment): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']) &gt;= 1">(KEZO Contactmoment): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201'] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']) &lt;= 1">(KEZO Contactmoment): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201'] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(KEZO Contactmoment): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(KEZO Contactmoment): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="count(hl7:code) &gt;= 1">(KEZO Contactmoment): element hl7:code is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="count(hl7:code) &lt;= 1">(KEZO Contactmoment): element hl7:code komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="count(hl7:effectiveTime[not(@nullFlavor)]) &gt;= 1">(KEZO Contactmoment): element hl7:effectiveTime[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="count(hl7:effectiveTime[not(@nullFlavor)]) &lt;= 1">(KEZO Contactmoment): element hl7:effectiveTime[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="count(hl7:performer[not(@nullFlavor)][hl7:assignedEntity]) &gt;= 1">(KEZO Contactmoment): element hl7:performer[not(@nullFlavor)][hl7:assignedEntity] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="count(hl7:performer[not(@nullFlavor)][hl7:assignedEntity]) &lt;= 1">(KEZO Contactmoment): element hl7:performer[not(@nullFlavor)][hl7:assignedEntity] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.201
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']
Item: (KEZO Contactmoment)
-->
   <rule fpi="RULC-1" context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']" id="d152e9192-false-d46882e0">
      <extends rule="II"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(KEZO Contactmoment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.66.10.201')">(KEZO Contactmoment): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.66.10.201' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.201
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:id[not(@nullFlavor)]
Item: (KEZO Contactmoment)
-->
   <rule fpi="RULC-1" context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:id[not(@nullFlavor)]" id="d152e9197-false-d46900e0">
      <extends rule="II"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(KEZO Contactmoment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.201
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:code
Item: (KEZO Contactmoment)
-->
   <rule fpi="RULC-1" context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:code" id="d152e9203-false-d46914e0">
      <extends rule="CV"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(KEZO Contactmoment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.103.11.3-DYNAMIC.xml')//valueSet[1][conceptList/include[@codeSystem = $theCodeSystem]])">(KEZO Contactmoment): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.103.11.3 NHG-Tabel 14 - Contactwijze (DYNAMISCH)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.201
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:effectiveTime[not(@nullFlavor)]
Item: (KEZO Contactmoment)
-->
   <rule fpi="RULC-1" context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:effectiveTime[not(@nullFlavor)]" id="d152e9212-false-d46937e0">
      <extends rule="IVL_TS"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(KEZO Contactmoment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="count(hl7:low) &gt;= 1">(KEZO Contactmoment): element hl7:low is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="count(hl7:low) &lt;= 1">(KEZO Contactmoment): element hl7:low komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="count(hl7:high) &lt;= 1">(KEZO Contactmoment): element hl7:high komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.201
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:effectiveTime[not(@nullFlavor)]/hl7:low
Item: (KEZO Contactmoment)
-->
   <rule fpi="RULC-1" context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:effectiveTime[not(@nullFlavor)]/hl7:low" id="d152e9217-false-d46973e0">
      <extends rule="TS.DATE.MIN"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(KEZO Contactmoment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="not(*)">(KEZO Contactmoment): <value-of select="local-name()"/> met datatype TS.DATE.MIN, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.201
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:effectiveTime[not(@nullFlavor)]/hl7:high
Item: (KEZO Contactmoment)
-->
   <rule fpi="RULC-1" context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:effectiveTime[not(@nullFlavor)]/hl7:high" id="d152e9219-false-d46989e0">
      <extends rule="TS.DATE.MIN"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(KEZO Contactmoment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="not(*)">(KEZO Contactmoment): <value-of select="local-name()"/> met datatype TS.DATE.MIN, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.201
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]
Item: (KEZO Contactmoment)
-->
   <rule fpi="RULC-1" context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]" id="d152e9222-false-d47021e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="string(@typeCode) = ('PRF') or not(@typeCode)">(KEZO Contactmoment): de waarde van typeCode MOET 'PRF' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="count(hl7:assignedEntity[not(@nullFlavor)]) &gt;= 1">(KEZO Contactmoment): element hl7:assignedEntity[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="count(hl7:assignedEntity[not(@nullFlavor)]) &lt;= 1">(KEZO Contactmoment): element hl7:assignedEntity[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.201
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]
Item: (KEZO Contactmoment)
-->
   <rule fpi="RULC-1" context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]" id="d152e9229-false-d47082e0">
      <assert role="warning" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test=".//hl7:assignedPerson/hl7:name[not(@nullFlavor)]">(KEZO Contactmoment): Artsnaam is verplicht</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(KEZO Contactmoment): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(KEZO Contactmoment): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(KEZO Contactmoment): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="count(hl7:assignedPerson) &lt;= 1">(KEZO Contactmoment): element hl7:assignedPerson komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="count(hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]) &lt;= 1">(KEZO Contactmoment): element hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.201" test="hl7:assignedPerson | hl7:representedOrganization">(KEZO Contactmoment): Er moet tenminste een persoon of vertegenwoordigende organisatie zijn. Element assignedPerson of representedOrganization moet voorkomen</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9028
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]
Item: (KEZO PART CDA Assigned Entity)
-->
   <rule fpi="RULC-1" context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]" id="d47152e5-false-d47159e0">
      <extends rule="II"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(KEZO PART CDA Assigned Entity): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9028
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (KEZO PART CDA Assigned Entity)
-->
   <rule fpi="RULC-1" context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]" id="d47152e10-false-d47173e0">
      <extends rule="CV"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(KEZO PART CDA Assigned Entity): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(KEZO PART CDA Assigned Entity): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.1.11.2 RoleCodeNL - zorgverlenertype (personen) (DYNAMISCH)'.</assert>
      <report fpi="CD-DEPR-BSP" role="warning" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@type='D'][@code = $theCode][@codeSystem = $theCodeSystem])">(KEZO PART CDA Assigned Entity): element hl7:code is gecodeerd met bindingssterkte 'required' en bevat een code die verouderd is.</report>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9028
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:addr
Item: (KEZO PART CDA Assigned Entity)
-->
   <rule fpi="RULC-1" context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:addr" id="d47152e17-false-d47201e0">
      <extends rule="AD"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'AD')">(KEZO PART CDA Assigned Entity): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9028
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:telecom
Item: (KEZO PART CDA Assigned Entity)
-->
   <rule fpi="RULC-1" context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:telecom" id="d47152e18-false-d47213e0">
      <extends rule="TEL"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(KEZO PART CDA Assigned Entity): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9028
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:assignedPerson
Item: (KEZO PART CDA Assigned Entity)
-->
   <rule fpi="RULC-1" context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:assignedPerson" id="d47152e25-false-d47227e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="string(@classCode) = ('PSN') or not(@classCode)">(KEZO PART CDA Assigned Entity): de waarde van classCode MOET 'PSN' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(KEZO PART CDA Assigned Entity): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9001
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:assignedPerson/hl7:name
Item: (PART CDA Person)
-->
   <rule fpi="RULC-1" context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:assignedPerson/hl7:name" id="d47252e7-false-d47259e0">
      <extends rule="PN"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9001" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PN')">(PART CDA Person): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9028
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]
Item: (KEZO PART CDA Assigned Entity)
-->
   <rule fpi="RULC-1" context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]" id="d47152e35-false-d47278e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="string(@classCode) = ('ORG') or not(@classCode)">(KEZO PART CDA Assigned Entity): de waarde van classCode MOET 'ORG' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(KEZO PART CDA Assigned Entity): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="count(hl7:id[@root = '2.16.528.1.1007.3.3']) &gt;= 1">(KEZO PART CDA Assigned Entity): element hl7:id[@root = '2.16.528.1.1007.3.3'] is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="count(hl7:id[@root = '2.16.528.1.1007.3.3']) &lt;= 1">(KEZO PART CDA Assigned Entity): element hl7:id[@root = '2.16.528.1.1007.3.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="count(hl7:name) &gt;= 1">(KEZO PART CDA Assigned Entity): element hl7:name is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="count(hl7:name) &lt;= 1">(KEZO PART CDA Assigned Entity): element hl7:name komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="count(hl7:addr) &lt;= 1">(KEZO PART CDA Assigned Entity): element hl7:addr komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9028" test="count(hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(KEZO PART CDA Assigned Entity): element hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:id[@root = '2.16.528.1.1007.3.3']
Item: (PART CDA Organization)
-->
   <rule fpi="RULC-1" context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:id[@root = '2.16.528.1.1007.3.3']" id="d47357e7-false-d47364e0">
      <extends rule="II.NL.URA"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9002" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(PART CDA Organization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9002" test="string(@root) = ('2.16.528.1.1007.3.3')">(PART CDA Organization): de waarde van root MOET '2.16.528.1.1007.3.3' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:id
Item: (PART CDA Organization)
-->
   <rule fpi="RULC-1" context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:id" id="d47357e14-false-d47382e0">
      <extends rule="II"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9002" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(PART CDA Organization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:name
Item: (PART CDA Organization)
-->
   <rule fpi="RULC-1" context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:name" id="d47357e19-false-d47394e0">
      <extends rule="ON"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9002" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ON')">(PART CDA Organization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:telecom
Item: (PART CDA Organization)
-->
   <rule fpi="RULC-1" context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:telecom" id="d47357e20-false-d47406e0">
      <extends rule="TEL"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9002" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(PART CDA Organization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:addr
Item: (PART CDA Organization)
-->
   <rule fpi="RULC-1" context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:addr" id="d47357e21-false-d47418e0">
      <extends rule="AD"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9002" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'AD')">(PART CDA Organization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.66.10.9002
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (PART CDA Organization)
-->
   <rule fpi="RULC-1" context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:performer[not(@nullFlavor)][hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)]/hl7:representedOrganization[hl7:id[@root = '2.16.528.1.1007.3.3']]/hl7:standardIndustryClassCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]" id="d47357e22-false-d47432e0">
      <extends rule="CE"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9002" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(PART CDA Organization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.66.10.9002" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(PART CDA Organization): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.40.2.17.2.3 OrganisatieTypeCodelijst (DYNAMISCH)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.7.10.33
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]
Item: (part Concern reference)
-->
   <rule fpi="RULC-1" context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]" id="d47450e6-false-d47455e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.33" test="string(@typeCode) = ('REFR')">(part Concern reference): de waarde van typeCode MOET 'REFR' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.33" test="count(hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]) &gt;= 1">(part Concern reference): element hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.33" test="count(hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]) &lt;= 1">(part Concern reference): element hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.7.10.33
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]/hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]
Item: (part Concern reference)
-->
   <rule fpi="RULC-1" context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]/hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]" id="d47450e21-false-d47484e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.33" test="string(@classCode) = ('ACT')">(part Concern reference): de waarde van classCode MOET 'ACT' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.33" test="string(@moodCode) = ('EVN')">(part Concern reference): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.33" test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(part Concern reference): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.33" test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(part Concern reference): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.33" test="count(hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]) &gt;= 1">(part Concern reference): element hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.33" test="count(hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]) &lt;= 1">(part Concern reference): element hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.7.10.33
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]/hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]/hl7:id[not(@nullFlavor)]
Item: (part Concern reference)
-->
   <rule fpi="RULC-1" context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]/hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]/hl7:id[not(@nullFlavor)]" id="d47450e33-false-d47534e0">
      <extends rule="II"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.33" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(part Concern reference): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.7.10.33
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]/hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]/hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]
Item: (part Concern reference)
-->
   <rule fpi="RULC-1" context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.66.10.201']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[hl7:code[@code = 'CONC'][@codeSystem = '2.16.840.1.113883.5.6']]]/hl7:act[hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]]/hl7:code[(@code = 'CONC' and @codeSystem = '2.16.840.1.113883.5.6')]" id="d47450e43-false-d47546e0">
      <extends rule="CV"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.33" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(part Concern reference): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.7.10.33" test="@nullFlavor or (@code='CONC' and @codeSystem='2.16.840.1.113883.5.6')">(part Concern reference): de elementwaarde MOET een zijn van 'code 'CONC' codeSystem '2.16.840.1.113883.5.6''.</assert>
   </rule>
</pattern>