<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.11.60.55.10.408
Name: Notification
Description: Bevat meldingsgegevens
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron" id="template-2.16.840.1.113883.2.4.3.11.60.55.10.408-2016-08-08T164028">
   <title>Notification</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.408
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]
Item: (Notification)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]" id="d152e10525-false-d29763e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]) &gt;= 1">(Notification): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']] is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]) &lt;= 1">(Notification): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.408
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]
Item: (Notification)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]" id="d152e10600-false-d29799e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="string(@classCode) = ('ACT') or not(@classCode)">(Notification): de waarde van classCode MOET 'ACT' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="string(@moodCode) = ('EVN')">(Notification): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']) &gt;= 1">(Notification): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408'] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']) &lt;= 1">(Notification): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408'] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="count(hl7:code[(@code = '185406000' and @codeSystem = '2.16.840.1.113883.6.96')]) &gt;= 1">(Notification): element hl7:code[(@code = '185406000' and @codeSystem = '2.16.840.1.113883.6.96')] is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="count(hl7:code[(@code = '185406000' and @codeSystem = '2.16.840.1.113883.6.96')]) &lt;= 1">(Notification): element hl7:code[(@code = '185406000' and @codeSystem = '2.16.840.1.113883.6.96')] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="count(hl7:effectiveTime) &lt;= 1">(Notification): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="count(hl7:performer[@typeCode = 'PRF'][hl7:assignedEntity]) &lt;= 1">(Notification): element hl7:performer[@typeCode = 'PRF'][hl7:assignedEntity] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.411']]]) &lt;= 1">(Notification): element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.411']]] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.9002']]]) &lt;= 1">(Notification): element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.9002']]] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.410']]]) &lt;= 1">(Notification): element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.410']]] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.9027']]]) &lt;= 1">(Notification): element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.9027']]] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.409']]]) &lt;= 1">(Notification): element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.409']]] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.1170']]]) &lt;= 1">(Notification): element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.1170']]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.408
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']
Item: (Notification)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']" id="d152e10606-false-d29929e0">
      <extends rule="II"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Notification): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.55.10.408')">(Notification): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.55.10.408' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.408
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:code[(@code = '185406000' and @codeSystem = '2.16.840.1.113883.6.96')]
Item: (Notification)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:code[(@code = '185406000' and @codeSystem = '2.16.840.1.113883.6.96')]" id="d152e10611-false-d29948e0">
      <extends rule="CD"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(Notification): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CD" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="string(@code) = ('185406000')">(Notification): de waarde van code MOET '185406000' zijn. Gevonden: "<value-of select="@code"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="@displayName">(Notification): attribute @displayName MOET aanwezig zijn.</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="not(@displayName) or string-length(@displayName)&gt;0">(Notification): attribuut @displayName MOET datatype 'st' hebben  - '<value-of select="@displayName"/>'</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="string(@codeSystem) = ('2.16.840.1.113883.6.96')">(Notification): de waarde van codeSystem MOET '2.16.840.1.113883.6.96' zijn. Gevonden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Notification): attribuut @codeSystemName MOET datatype 'st' hebben  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.408
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:effectiveTime
Item: (Notification)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:effectiveTime" id="d152e10627-false-d29988e0">
      <extends rule="IVL_TS"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(Notification): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="@value">(Notification): attribute @value MOET aanwezig zijn.</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(Notification): attribuut @value MOET datatype 'ts' hebben  - '<value-of select="@value"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.408
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:performer[@typeCode = 'PRF'][hl7:assignedEntity]
Item: (Notification)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:performer[@typeCode = 'PRF'][hl7:assignedEntity]" id="d152e10636-false-d30010e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="string(@typeCode) = ('PRF')">(Notification): de waarde van typeCode MOET 'PRF' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="count(hl7:assignedEntity) &gt;= 1">(Notification): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="count(hl7:assignedEntity) &lt;= 1">(Notification): element hl7:assignedEntity komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.408
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:performer[@typeCode = 'PRF'][hl7:assignedEntity]/hl7:assignedEntity
Item: (Notification)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:performer[@typeCode = 'PRF'][hl7:assignedEntity]/hl7:assignedEntity" id="d152e10643-false-d30039e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="count(hl7:id) &lt;= 1">(Notification): element hl7:id komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(Notification): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="count(hl7:telecom) &lt;= 1">(Notification): element hl7:telecom komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="count(hl7:assignedPerson) &lt;= 1">(Notification): element hl7:assignedPerson komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.408
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:performer[@typeCode = 'PRF'][hl7:assignedEntity]/hl7:assignedEntity/hl7:id
Item: (Notification)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:performer[@typeCode = 'PRF'][hl7:assignedEntity]/hl7:assignedEntity/hl7:id" id="d152e10645-false-d30085e0">
      <extends rule="II"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Notification): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.408
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:performer[@typeCode = 'PRF'][hl7:assignedEntity]/hl7:assignedEntity/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (Notification)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:performer[@typeCode = 'PRF'][hl7:assignedEntity]/hl7:assignedEntity/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]" id="d152e10663-false-d30099e0">
      <extends rule="CD"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(Notification): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CD" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.55.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Notification): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.55.11.1 Zorgaanvrager (DYNAMISCH)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.408
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:performer[@typeCode = 'PRF'][hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom
Item: (Notification)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:performer[@typeCode = 'PRF'][hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom" id="d152e10671-false-d30122e0">
      <extends rule="TEL"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Notification): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.408
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:performer[@typeCode = 'PRF'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (Notification)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:performer[@typeCode = 'PRF'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson" id="d152e10673-false-d30134e0">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="count(hl7:name) &lt;= 1">(Notification): element hl7:name komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.408
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:performer[@typeCode = 'PRF'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (Notification)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:performer[@typeCode = 'PRF'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name" id="d152e10675-false-d30151e0">
      <extends rule="PN"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PN')">(Notification): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.408
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.411']]]
Item: (Notification)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.411']]]">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="string(@typeCode) = ('SUBJ')">(Notification): de waarde van typeCode MOET 'SUBJ' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Notification): de waarde van contextConductionInd MOET 'true' zijn. Gevonden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.408
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.9002']]]
Item: (Notification)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.9002']]]">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="string(@typeCode) = ('SUBJ')">(Notification): de waarde van typeCode MOET 'SUBJ' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Notification): de waarde van contextConductionInd MOET 'true' zijn. Gevonden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.408
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.410']]]
Item: (Notification)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.410']]]">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="string(@typeCode) = ('SUBJ')">(Notification): de waarde van typeCode MOET 'SUBJ' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Notification): de waarde van contextConductionInd MOET 'true' zijn. Gevonden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.408
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.9027']]]
Item: (Notification)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.9027']]]">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="string(@typeCode) = ('SUBJ')">(Notification): de waarde van typeCode MOET 'SUBJ' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Notification): de waarde van contextConductionInd MOET 'true' zijn. Gevonden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.408
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.409']]]
Item: (Notification)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.409']]]">
      <extends rule="d30297e0-false-d30302e0"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="string(@typeCode) = ('SUBJ')">(Notification): de waarde van typeCode MOET 'SUBJ' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Notification): de waarde van contextConductionInd MOET 'true' zijn. Gevonden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.409
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.409']]]
Item: (MedicalNote)
-->
   <rule fpi="RULC-1" id="d30297e0-false-d30302e0" abstract="true">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.409" test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.409']]) &gt;= 1">(MedicalNote): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.409']] is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.409" test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.409']]) &lt;= 1">(MedicalNote): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.409']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.409
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.409']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.409']]
Item: (MedicalNote)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.409']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.409']]">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.409" test="string(@classCode) = ('OBS') or not(@classCode)">(MedicalNote): de waarde van classCode MOET 'OBS' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.409" test="string(@moodCode) = ('EVN')">(MedicalNote): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.409" test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.409']) &gt;= 1">(MedicalNote): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.409'] is mandatory [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.409" test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.409']) &lt;= 1">(MedicalNote): element hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.409'] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.409" test="count(hl7:code[(@code = '34109-9' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]) &gt;= 1">(MedicalNote): element hl7:code[(@code = '34109-9' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor] is required [min 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.409" test="count(hl7:code[(@code = '34109-9' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]) &lt;= 1">(MedicalNote): element hl7:code[(@code = '34109-9' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.409" test="count(hl7:value) &lt;= 1">(MedicalNote): element hl7:value komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.409
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.409']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.409']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.409']
Item: (MedicalNote)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.409']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.409']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.409']">
      <extends rule="II"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.409" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(MedicalNote): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.409" test="string(@root) = ('2.16.840.1.113883.2.4.3.11.60.55.10.409')">(MedicalNote): de waarde van root MOET '2.16.840.1.113883.2.4.3.11.60.55.10.409' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.409
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.409']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.409']]/hl7:code[(@code = '34109-9' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]
Item: (MedicalNote)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.409']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.409']]/hl7:code[(@code = '34109-9' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]">
      <extends rule="CD"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.409" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(MedicalNote): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CD" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.409" test="@nullFlavor or (@code='34109-9' and @codeSystem='2.16.840.1.113883.6.1' and @displayName='Note' and @codeSystemName='LOINC')">(MedicalNote): de elementwaarde MOET een zijn van 'code '34109-9' codeSystem '2.16.840.1.113883.6.1' displayName='Note' codeSystemName='LOINC''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.409
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.409']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.409']]/hl7:value
Item: (MedicalNote)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.409']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.409']]/hl7:value">
      <extends rule="ST"/>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.409" test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(MedicalNote): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.55.10.408
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.1170']]]
Item: (Notification)
-->
   <rule fpi="RULC-1" context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.408']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.3.11.60.55.10.1170']]]">
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="string(@typeCode) = ('SUBJ')">(Notification): de waarde van typeCode MOET 'SUBJ' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error" see="https://decor.nictiz.nl/art-decor/decor-templates--acutezorg-?id=2.16.840.1.113883.2.4.3.11.60.55.10.408" test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Notification): de waarde van contextConductionInd MOET 'true' zijn. Gevonden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>
</pattern>