<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.6.10.100.10000
Name: Versturen JGZ-dossieroverdrachtverzoek (payload)
Description: 
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000">
   <title>Versturen JGZ-dossieroverdrachtverzoek (payload)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10000
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]
Item: (Versturen JGZ-dossieroverdrachtverzoek (payload))
-->

   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]"
         id="d45e1590-false-d8150e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="count(hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]) &gt;= 1">(Versturen JGZ-dossieroverdrachtverzoek (payload)): element hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="count(hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]) &lt;= 1">(Versturen JGZ-dossieroverdrachtverzoek (payload)): element hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10000
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]
Item: (Versturen JGZ-dossieroverdrachtverzoek (payload))
-->

   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]"
         id="d45e1594-false-d8333e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="string(@classCode) = ('PCPR') or not(@classCode)">(Versturen JGZ-dossieroverdrachtverzoek (payload)): de waarde van classCode MOET 'PCPR' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="string(@moodCode) = ('RQO') or not(@moodCode)">(Versturen JGZ-dossieroverdrachtverzoek (payload)): de waarde van moodCode MOET 'RQO' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <report role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="descendant::*[@code][@codeSystem][not(@displayName)][not(ancestor::hl7:addr)][text() = '']">(Versturen JGZ-dossieroverdrachtverzoek (payload)): Gecodeerde elementen - datatype CV, CO, CE of CD - moeten een weergavenaam hebben indien ze een code bevatten.</report>
      <report role="warning"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="descendant::*[@nullFlavor = 'OTH']/hl7:originalText[string-length(string-join(.//text(), '')) gt 80]">(Versturen JGZ-dossieroverdrachtverzoek (payload)): Veldlengte van waarde "Anders" wordt gegarandeerd tot 80 tekens; daar buiten is afkapping van de waarde bij de ontvanger mogelijk. Waarden van voor 2020 zouden langer kunnen zijn. Gevonden: <value-of select="string-length(string-join(.//text(), ''))"/> tekens</report>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']) &gt;= 1">(Versturen JGZ-dossieroverdrachtverzoek (payload)): element hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']) &lt;= 1">(Versturen JGZ-dossieroverdrachtverzoek (payload)): element hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="count(hl7:id) &lt;= 1">(Versturen JGZ-dossieroverdrachtverzoek (payload)): element hl7:id komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="count(hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]) &gt;= 1">(Versturen JGZ-dossieroverdrachtverzoek (payload)): element hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="count(hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]) &lt;= 1">(Versturen JGZ-dossieroverdrachtverzoek (payload)): element hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="count(hl7:statusCode[@code = 'active']) &gt;= 1">(Versturen JGZ-dossieroverdrachtverzoek (payload)): element hl7:statusCode[@code = 'active'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="count(hl7:statusCode[@code = 'active']) &lt;= 1">(Versturen JGZ-dossieroverdrachtverzoek (payload)): element hl7:statusCode[@code = 'active'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="count(hl7:author[hl7:assignedEntity[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.122']]]) &gt;= 1">(Versturen JGZ-dossieroverdrachtverzoek (payload)): element hl7:author[hl7:assignedEntity[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.122']]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="count(hl7:author[hl7:assignedEntity[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.122']]]) &lt;= 1">(Versturen JGZ-dossieroverdrachtverzoek (payload)): element hl7:author[hl7:assignedEntity[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.122']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="count(hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]) &gt;= 1">(Versturen JGZ-dossieroverdrachtverzoek (payload)): element hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="count(hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]) &lt;= 1">(Versturen JGZ-dossieroverdrachtverzoek (payload)): element hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10000
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']
Item: (Versturen JGZ-dossieroverdrachtverzoek (payload))
-->

   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']"
         id="d45e1636-false-d8484e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Versturen JGZ-dossieroverdrachtverzoek (payload)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.6.10.100.10000')">(Versturen JGZ-dossieroverdrachtverzoek (payload)): de waarde van root MOET '2.16.840.1.113883.2.4.6.10.100.10000' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10000
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:id
Item: (Versturen JGZ-dossieroverdrachtverzoek (payload))
-->

   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:id"
         id="d45e1648-false-d8498e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Versturen JGZ-dossieroverdrachtverzoek (payload)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10000
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]
Item: (Versturen JGZ-dossieroverdrachtverzoek (payload))
-->

   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]"
         id="d45e1657-false-d8509e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Versturen JGZ-dossieroverdrachtverzoek (payload)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="@nullFlavor or (@code='CPHC' and @codeSystem='2.16.840.1.113883.5.4')">(Versturen JGZ-dossieroverdrachtverzoek (payload)): de elementwaarde MOET een zijn van 'code 'CPHC' codeSystem '2.16.840.1.113883.5.4''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10000
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:statusCode[@code = 'active']
Item: (Versturen JGZ-dossieroverdrachtverzoek (payload))
-->

   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:statusCode[@code = 'active']"
         id="d45e1667-false-d8526e0">
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(Versturen JGZ-dossieroverdrachtverzoek (payload)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="@nullFlavor or (@code='active')">(Versturen JGZ-dossieroverdrachtverzoek (payload)): de elementwaarde MOET een zijn van 'code 'active''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10000
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:author[hl7:assignedEntity[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.122']]]
Item: (Versturen JGZ-dossieroverdrachtverzoek (payload))
-->

   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:author[hl7:assignedEntity[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.122']]]"
         id="d45e1682-false-d8546e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(Versturen JGZ-dossieroverdrachtverzoek (payload)): de waarde van typeCode MOET 'AUT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="count(hl7:time[not(@nullFlavor)]) &gt;= 1">(Versturen JGZ-dossieroverdrachtverzoek (payload)): element hl7:time[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="count(hl7:time[not(@nullFlavor)]) &lt;= 1">(Versturen JGZ-dossieroverdrachtverzoek (payload)): element hl7:time[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="count(hl7:assignedEntity[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.122']]) &gt;= 1">(Versturen JGZ-dossieroverdrachtverzoek (payload)): element hl7:assignedEntity[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.122']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="count(hl7:assignedEntity[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.122']]) &lt;= 1">(Versturen JGZ-dossieroverdrachtverzoek (payload)): element hl7:assignedEntity[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.122']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10000
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:author[hl7:assignedEntity[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.122']]]/hl7:time[not(@nullFlavor)]
Item: (Versturen JGZ-dossieroverdrachtverzoek (payload))
-->

   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:author[hl7:assignedEntity[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.122']]]/hl7:time[not(@nullFlavor)]"
         id="d45e1704-false-d8579e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(Versturen JGZ-dossieroverdrachtverzoek (payload)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="not(*)">(Versturen JGZ-dossieroverdrachtverzoek (payload)): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10000
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]
Item: (Versturen JGZ-dossieroverdrachtverzoek (payload))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="string(@typeCode) = ('SEQL') or not(@typeCode)">(Versturen JGZ-dossieroverdrachtverzoek (payload)): de waarde van typeCode MOET 'SEQL' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10000-2024-11-01T000000.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Versturen JGZ-dossieroverdrachtverzoek (payload)): de waarde van contextConductionInd MOET 'true' zijn. Gevonden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10006
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]
Item: (Care Provision Dossier)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10006
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]
Item: (Care Provision Dossier)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="string(@classCode) = ('PCPR') or not(@classCode)">(Care Provision Dossier): de waarde van classCode MOET 'PCPR' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Care Provision Dossier): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="warning"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="hl7:appendage[hl7:document[hl7:code[@code='01'][@codeSystem='2.16.840.1.113883.2.4.4.40.303']]]">(Care Provision Dossier): Er is geen Integraal dossier JGZ meegeleverd. Dit is bij dossieroverdracht zeer wenselijk, omdat (mogelijk) nog niet alle delen van het dossier in het bericht staan. Deze informatie zou dan niet worden overgedragen.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(Care Provision Dossier): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(Care Provision Dossier): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="count(hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]) &gt;= 1">(Care Provision Dossier): element hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="count(hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]) &lt;= 1">(Care Provision Dossier): element hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="count(hl7:statusCode[@code = 'active' or @code = 'completed' or @code = 'aborted']) &gt;= 1">(Care Provision Dossier): element hl7:statusCode[@code = 'active' or @code = 'completed' or @code = 'aborted'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="count(hl7:statusCode[@code = 'active' or @code = 'completed' or @code = 'aborted']) &lt;= 1">(Care Provision Dossier): element hl7:statusCode[@code = 'active' or @code = 'completed' or @code = 'aborted'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Care Provision Dossier): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="count(hl7:subject[hl7:patient[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.131']]]) &gt;= 1">(Care Provision Dossier): element hl7:subject[hl7:patient[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.131']]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="count(hl7:subject[hl7:patient[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.131']]]) &lt;= 1">(Care Provision Dossier): element hl7:subject[hl7:patient[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.131']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="count(hl7:author[hl7:assignedEntity[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.122']]]) &gt;= 1">(Care Provision Dossier): element hl7:author[hl7:assignedEntity[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.122']]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="count(hl7:subjectOf) &gt;= 2">(Care Provision Dossier): element hl7:subjectOf is required [min 2x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10006
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:id[not(@nullFlavor)]
Item: (Care Provision Dossier)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:id[not(@nullFlavor)]">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Care Provision Dossier): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10006
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]
Item: (Care Provision Dossier)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Care Provision Dossier): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="@nullFlavor or (@code='CPHC' and @codeSystem='2.16.840.1.113883.5.4')">(Care Provision Dossier): de elementwaarde MOET een zijn van 'code 'CPHC' codeSystem '2.16.840.1.113883.5.4''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10006
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:statusCode[@code = 'active' or @code = 'completed' or @code = 'aborted']
Item: (Care Provision Dossier)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:statusCode[@code = 'active' or @code = 'completed' or @code = 'aborted']">
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(Care Provision Dossier): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="@nullFlavor or (@code='active') or (@code='completed') or (@code='aborted')">(Care Provision Dossier): de elementwaarde MOET een zijn van 'code 'active' of code 'completed' of code 'aborted''.</assert>
      <assert role="warning"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="@code='completed'">(Care Provision Dossier): Alleen in uitzonderlijke gevallen kan een dossierstatus bij overdracht iets anders dan 'completed' zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10006
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:effectiveTime
Item: (Care Provision Dossier)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:effectiveTime">
      <extends rule="d9436e0-false-d9442e0"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="not(../hl7:statusCode[@code='aborted' or @code='completed']) or hl7:high">(Care Provision Dossier): Als statusCode='aborted' of statusCode='completed' dan moet high/@value de datum en indien bekend de tijd bevatten van de afsluiting van de zorg.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10243
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:effectiveTime
Item: (Periode-M-Start-O-Eind-M)
-->
   <rule fpi="RULC-1" id="d9436e0-false-d9442e0" abstract="true">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10243-2012-08-01T000000.html"
              test="count(hl7:low) &lt;= 1">(Periode-M-Start-O-Eind-M): element hl7:low komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10243-2012-08-01T000000.html"
              test="count(hl7:high[not(@nullFlavor)]) &gt;= 1">(Periode-M-Start-O-Eind-M): element hl7:high[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10243-2012-08-01T000000.html"
              test="count(hl7:high[not(@nullFlavor)]) &lt;= 1">(Periode-M-Start-O-Eind-M): element hl7:high[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10243-2012-08-01T000000.html"
              test="count(hl7:width) = 0">(Periode-M-Start-O-Eind-M): element hl7:width MAG NIET voorkomen.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10243-2012-08-01T000000.html"
              test="count(hl7:center) = 0">(Periode-M-Start-O-Eind-M): element hl7:center MAG NIET voorkomen.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10243
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:effectiveTime/hl7:low
Item: (Periode-M-Start-O-Eind-M)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:effectiveTime/hl7:low">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10243-2012-08-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(Periode-M-Start-O-Eind-M): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10243-2012-08-01T000000.html"
              test="not(*)">(Periode-M-Start-O-Eind-M): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10243-2012-08-01T000000.html"
              test="string(@nullFlavor) = ('UNK') or not(@nullFlavor)">(Periode-M-Start-O-Eind-M): de waarde van nullFlavor MOET 'UNK' zijn. Gevonden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10243
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:effectiveTime/hl7:high[not(@nullFlavor)]
Item: (Periode-M-Start-O-Eind-M)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:effectiveTime/hl7:high[not(@nullFlavor)]">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10243-2012-08-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(Periode-M-Start-O-Eind-M): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10243-2012-08-01T000000.html"
              test="not(*)">(Periode-M-Start-O-Eind-M): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10243
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:effectiveTime/hl7:width
Item: (Periode-M-Start-O-Eind-M)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10243
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:effectiveTime/hl7:center
Item: (Periode-M-Start-O-Eind-M)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10006
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:subject[hl7:patient[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.131']]]
Item: (Care Provision Dossier)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:subject[hl7:patient[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.131']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="string(@typeCode) = ('SBJ') or not(@typeCode)">(Care Provision Dossier): de waarde van typeCode MOET 'SBJ' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <let name="patRoot" value="'2.16.840.1.113883.2.4.6.3'"/>
      <let name="patExt"
           value="(hl7:patient/hl7:id[@root=$patRoot])[1]/@extension"/>
      <assert role="info"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="not(ancestor::*/hl7:attentionLine) or ancestor::*/hl7:attentionLine/hl7:value[@extension = $patExt][@root = $patRoot]">(Care Provision Dossier): De patiënt in de Payload (BSN '<value-of select="$patExt"/>') moet overeen komen met de patient in de attentionLine (BSN '<value-of select="ancestor::*/hl7:attentionLine/hl7:value/@extension"/>')</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10006
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:author[hl7:assignedEntity[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.122']]]
Item: (Care Provision Dossier)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:author[hl7:assignedEntity[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.122']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(Care Provision Dossier): de waarde van typeCode MOET 'AUT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="count(hl7:time) &gt;= 1">(Care Provision Dossier): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="count(hl7:time) &lt;= 1">(Care Provision Dossier): element hl7:time komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="count(hl7:assignedEntity[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.122']]) &gt;= 1">(Care Provision Dossier): element hl7:assignedEntity[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.122']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="count(hl7:assignedEntity[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.122']]) &lt;= 1">(Care Provision Dossier): element hl7:assignedEntity[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.122']] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10006
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:author[hl7:assignedEntity[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.122']]]/hl7:time
Item: (Care Provision Dossier)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:author[hl7:assignedEntity[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.122']]]/hl7:time">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(Care Provision Dossier): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="string(@nullFlavor) = ('UNK') or not(@nullFlavor)">(Care Provision Dossier): de waarde van nullFlavor MOET 'UNK' zijn. Gevonden: "<value-of select="@nullFlavor"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="count(hl7:low) &lt;= 1">(Care Provision Dossier): element hl7:low komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="count(hl7:high) &lt;= 1">(Care Provision Dossier): element hl7:high komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="count(hl7:center) = 0">(Care Provision Dossier): element hl7:center MAG NIET voorkomen.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="count(hl7:width) = 0">(Care Provision Dossier): element hl7:width MAG NIET voorkomen.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10006
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:author[hl7:assignedEntity[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.122']]]/hl7:time/hl7:low
Item: (Care Provision Dossier)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:author[hl7:assignedEntity[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.122']]]/hl7:time/hl7:low">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(Care Provision Dossier): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="not(*)">(Care Provision Dossier): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="string(@nullFlavor) = ('UNK') or not(@nullFlavor)">(Care Provision Dossier): de waarde van nullFlavor MOET 'UNK' zijn. Gevonden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10006
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:author[hl7:assignedEntity[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.122']]]/hl7:time/hl7:high
Item: (Care Provision Dossier)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:author[hl7:assignedEntity[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.122']]]/hl7:time/hl7:high">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(Care Provision Dossier): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="not(*)">(Care Provision Dossier): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="string(@nullFlavor) = ('UNK') or not(@nullFlavor)">(Care Provision Dossier): de waarde van nullFlavor MOET 'UNK' zijn. Gevonden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10006
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:author[hl7:assignedEntity[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.122']]]/hl7:time/hl7:center
Item: (Care Provision Dossier)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10006
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:author[hl7:assignedEntity[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.122']]]/hl7:time/hl7:width
Item: (Care Provision Dossier)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10008
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:appendage[hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]
Item: (Care Provision Event Appendage)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:appendage[hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10008-2024-11-01T000000.html"
              test="string(@typeCode) = ('APND') or not(@typeCode)">(Care Provision Event Appendage): de waarde van typeCode MOET 'APND' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10008-2024-11-01T000000.html"
              test="count(hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]) &gt;= 1">(Care Provision Event Appendage): element hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10008-2024-11-01T000000.html"
              test="count(hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]) &lt;= 1">(Care Provision Event Appendage): element hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10008
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:appendage[hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]
Item: (Care Provision Event Appendage)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:appendage[hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10008-2024-11-01T000000.html"
              test="string(@classCode) = ('DOC') or not(@classCode)">(Care Provision Event Appendage): de waarde van classCode MOET 'DOC' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10008-2024-11-01T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Care Provision Event Appendage): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10008-2024-11-01T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]) &gt;= 1">(Care Provision Event Appendage): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10008-2024-11-01T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]) &lt;= 1">(Care Provision Event Appendage): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10008-2024-11-01T000000.html"
              test="count(hl7:text) &lt;= 1">(Care Provision Event Appendage): element hl7:text komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10008-2024-11-01T000000.html"
              test="count(hl7:effectiveTime[not(@nullFlavor)]) &gt;= 1">(Care Provision Event Appendage): element hl7:effectiveTime[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10008-2024-11-01T000000.html"
              test="count(hl7:effectiveTime[not(@nullFlavor)]) &lt;= 1">(Care Provision Event Appendage): element hl7:effectiveTime[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10008-2024-11-01T000000.html"
              test="count(hl7:author[hl7:assignedEntity]) &lt;= 1">(Care Provision Event Appendage): element hl7:author[hl7:assignedEntity] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10008
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:appendage[hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]
Item: (Care Provision Event Appendage)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:appendage[hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10008-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Care Provision Event Appendage): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10008-2024-11-01T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Care Provision Event Appendage): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.100.11.2.84 W0084 Onderwerp document (HL7) (2024-11-01T00:00:00)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10008-2024-11-01T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(Care Provision Event Appendage): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst 2.16.840.1.113883.2.4.3.11.60.100.11.2.84 W0084 Onderwerp document (HL7) (2024-11-01T00:00:00).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10008
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:appendage[hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:text
Item: (Care Provision Event Appendage)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10250
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:appendage[hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:text
Item: (DatatypeEDTextOrBase64)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:appendage[hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:text">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10250-2012-08-01T000000.html"
              test="not(@mediaType) or (string-length(@mediaType) &gt; 0 and not(matches(@mediaType,'\s')))">(DatatypeEDTextOrBase64): attribuut @mediaType MOET datatype 'cs' hebben  - '<value-of select="@mediaType"/>'</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10250-2012-08-01T000000.html"
              test="not(@representation) or (string-length(@representation) &gt; 0 and not(matches(@representation,'\s')))">(DatatypeEDTextOrBase64): attribuut @representation MOET datatype 'cs' hebben  - '<value-of select="@representation"/>'</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10250-2012-08-01T000000.html"
              test="count(hl7:reference) &gt;= 1">(DatatypeEDTextOrBase64): element hl7:reference is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10250-2012-08-01T000000.html"
              test="count(hl7:reference) &lt;= 1">(DatatypeEDTextOrBase64): element hl7:reference komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10250-2012-08-01T000000.html"
              test="count(hl7:thumbnail) = 0">(DatatypeEDTextOrBase64): element hl7:thumbnail MAG NIET voorkomen.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10250
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:appendage[hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:text/hl7:reference
Item: (DatatypeEDTextOrBase64)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:appendage[hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:text/hl7:reference">
      <extends rule="TEL"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10250-2012-08-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(DatatypeEDTextOrBase64): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10250-2012-08-01T000000.html"
              test="not(@value) or starts-with(@value,'file:///')">(DatatypeEDTextOrBase64): De bestandsnaam MOET met het file: scheme worden gecommuniceerd.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10250-2012-08-01T000000.html"
              test="not(@value) or matches(@value,'\.\S+$')">(DatatypeEDTextOrBase64): De bestandsnaam MOET een extensie hebben.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10250
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:appendage[hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:text/hl7:thumbnail
Item: (DatatypeEDTextOrBase64)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10008
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:appendage[hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:effectiveTime[not(@nullFlavor)]
Item: (Care Provision Event Appendage)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:appendage[hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:effectiveTime[not(@nullFlavor)]">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10008-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(Care Provision Event Appendage): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10008-2024-11-01T000000.html"
              test="not(*)">(Care Provision Event Appendage): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10008
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:appendage[hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:author[hl7:assignedEntity]
Item: (Care Provision Event Appendage)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:appendage[hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:author[hl7:assignedEntity]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10008-2024-11-01T000000.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(Care Provision Event Appendage): de waarde van typeCode MOET 'AUT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10008-2024-11-01T000000.html"
              test="count(hl7:assignedEntity[not(@nullFlavor)][hl7:assignedPerson]) &gt;= 1">(Care Provision Event Appendage): element hl7:assignedEntity[not(@nullFlavor)][hl7:assignedPerson] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10008-2024-11-01T000000.html"
              test="count(hl7:assignedEntity[not(@nullFlavor)][hl7:assignedPerson]) &lt;= 1">(Care Provision Event Appendage): element hl7:assignedEntity[not(@nullFlavor)][hl7:assignedPerson] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10008
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:appendage[hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:author[hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)][hl7:assignedPerson]
Item: (Care Provision Event Appendage)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:appendage[hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:author[hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)][hl7:assignedPerson]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10008-2024-11-01T000000.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(Care Provision Event Appendage): de waarde van classCode MOET 'ASSIGNED' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10008-2024-11-01T000000.html"
              test="count(hl7:assignedPerson[not(@nullFlavor)]) &gt;= 1">(Care Provision Event Appendage): element hl7:assignedPerson[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10008-2024-11-01T000000.html"
              test="count(hl7:assignedPerson[not(@nullFlavor)]) &lt;= 1">(Care Provision Event Appendage): element hl7:assignedPerson[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10008
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:appendage[hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:author[hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]
Item: (Care Provision Event Appendage)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:appendage[hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:author[hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10008-2024-11-01T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(Care Provision Event Appendage): de waarde van classCode MOET 'PSN' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10008-2024-11-01T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(Care Provision Event Appendage): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10008-2024-11-01T000000.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(Care Provision Event Appendage): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10008-2024-11-01T000000.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(Care Provision Event Appendage): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10008
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:appendage[hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:author[hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]
Item: (Care Provision Event Appendage)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:appendage[hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:document[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.84-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:author[hl7:assignedEntity]/hl7:assignedEntity[not(@nullFlavor)][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]">
      <extends rule="TN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10008-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TN')">(Care Provision Event Appendage): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TN" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10006
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]
Item: (Care Provision Dossier)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]">
      <extends rule="d10022e0-false-d10026e0"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="string(@typeCode) = ('AUTH') or not(@typeCode)">(Care Provision Dossier): de waarde van typeCode MOET 'AUTH' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10006-2024-11-01T000000.html"
              test="string(@contextConductionInd) = ('false') or not(@contextConductionInd)">(Care Provision Dossier): de waarde van contextConductionInd MOET 'false' zijn. Gevonden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.50115
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]
Item: (authorization Toestemming gegevensuitwisseling RVP)
-->
   <rule fpi="RULC-1" id="d10022e0-false-d10026e0" abstract="true">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]) &gt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]) &lt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.50115
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]
Item: (authorization Toestemming gegevensuitwisseling RVP)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="string(@classCode) = ('CONS') or not(@classCode)">(authorization Toestemming gegevensuitwisseling RVP): de waarde van classCode MOET 'CONS' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(authorization Toestemming gegevensuitwisseling RVP): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="not(@negationInd) or string(@negationInd)=('true','false')">(authorization Toestemming gegevensuitwisseling RVP): attribuut @negationInd MOET datatype 'bl' hebben  - '<value-of select="@negationInd"/>'</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]) &gt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]) &lt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:author[hl7:responsibleParty[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.435' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]) &lt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:author[hl7:responsibleParty[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.435' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:consultant[hl7:assignedEntity1]) &lt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:consultant[hl7:assignedEntity1] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:subjectOf[hl7:annotation[hl7:code[(@code = '1541' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]) &lt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:subjectOf[hl7:annotation[hl7:code[(@code = '1541' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.50115
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]
Item: (authorization Toestemming gegevensuitwisseling RVP)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(authorization Toestemming gegevensuitwisseling RVP): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="@nullFlavor or (@code='1533' and @codeSystem='2.16.840.1.113883.2.4.4.40.267')">(authorization Toestemming gegevensuitwisseling RVP): de elementwaarde MOET een zijn van 'code '1533' codeSystem '2.16.840.1.113883.2.4.4.40.267''.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="@displayName">(authorization Toestemming gegevensuitwisseling RVP): attribute @displayName MOET aanwezig zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.50115
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:effectiveTime
Item: (authorization Toestemming gegevensuitwisseling RVP)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:effectiveTime">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(authorization Toestemming gegevensuitwisseling RVP): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:high) &gt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:high is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:high) &lt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:high komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.50115
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:effectiveTime/hl7:high
Item: (authorization Toestemming gegevensuitwisseling RVP)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:effectiveTime/hl7:high">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(authorization Toestemming gegevensuitwisseling RVP): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="not(*)">(authorization Toestemming gegevensuitwisseling RVP): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.50115
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:author[hl7:responsibleParty[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.435' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]
Item: (authorization Toestemming gegevensuitwisseling RVP)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:author[hl7:responsibleParty[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.435' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(authorization Toestemming gegevensuitwisseling RVP): de waarde van typeCode MOET 'AUT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:time) &gt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:time) &lt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:time komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:responsibleParty[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.435' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &gt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:responsibleParty[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.435' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:responsibleParty[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.435' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &lt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:responsibleParty[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.435' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.50115
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:author[hl7:responsibleParty[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.435' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:time
Item: (authorization Toestemming gegevensuitwisseling RVP)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:author[hl7:responsibleParty[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.435' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:time">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(authorization Toestemming gegevensuitwisseling RVP): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="not(*)">(authorization Toestemming gegevensuitwisseling RVP): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="not(@nullFlavor) or (string-length(@nullFlavor) &gt; 0 and not(matches(@nullFlavor,'\s')))">(authorization Toestemming gegevensuitwisseling RVP): attribuut @nullFlavor MOET datatype 'cs' hebben  - '<value-of select="@nullFlavor"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.50115
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:author[hl7:responsibleParty[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.435' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:responsibleParty[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.435' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]
Item: (authorization Toestemming gegevensuitwisseling RVP)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:author[hl7:responsibleParty[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.435' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:responsibleParty[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.435' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="string(@classCode) = ('CON')">(authorization Toestemming gegevensuitwisseling RVP): de waarde van classCode MOET 'CON' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.435' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.435' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.435' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.435' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:agentPerson) &gt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:agentPerson is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:agentPerson) &lt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:agentPerson komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.50115
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:author[hl7:responsibleParty[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.435' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:responsibleParty[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.435' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.435' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (authorization Toestemming gegevensuitwisseling RVP)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:author[hl7:responsibleParty[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.435' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:responsibleParty[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.435' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.435' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(authorization Toestemming gegevensuitwisseling RVP): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(authorization Toestemming gegevensuitwisseling RVP): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.100.11.2.691 W0691 Bron toestemming cliënt/jeugdige/gezaghebbende (HL7) (2012-05-21T01:26:54)'.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="@code">(authorization Toestemming gegevensuitwisseling RVP): attribute @code MOET aanwezig zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.2.4.4.40.435')">(authorization Toestemming gegevensuitwisseling RVP): de waarde van codeSystem MOET '2.16.840.1.113883.2.4.4.40.435' zijn. Gevonden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="@displayName">(authorization Toestemming gegevensuitwisseling RVP): attribute @displayName MOET aanwezig zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.50115
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:author[hl7:responsibleParty[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.435' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:responsibleParty[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.435' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:agentPerson
Item: (authorization Toestemming gegevensuitwisseling RVP)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:author[hl7:responsibleParty[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.435' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:responsibleParty[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.435' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:agentPerson">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(authorization Toestemming gegevensuitwisseling RVP): de waarde van classCode MOET 'PSN' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(authorization Toestemming gegevensuitwisseling RVP): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:name) &gt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:name) &lt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:name komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.50115
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:author[hl7:responsibleParty[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.435' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:responsibleParty[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.435' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:agentPerson/hl7:name
Item: (authorization Toestemming gegevensuitwisseling RVP)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:author[hl7:responsibleParty[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.435' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:responsibleParty[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.435' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.691-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:agentPerson/hl7:name">
      <extends rule="TN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TN')">(authorization Toestemming gegevensuitwisseling RVP): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TN" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="string(@nullFlavor) = ('NI') or not(@nullFlavor)">(authorization Toestemming gegevensuitwisseling RVP): de waarde van nullFlavor MOET 'NI' zijn. Gevonden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.50115
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:consultant[hl7:assignedEntity1]
Item: (authorization Toestemming gegevensuitwisseling RVP)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:consultant[hl7:assignedEntity1]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="string(@typeCode) = ('CON') or not(@typeCode)">(authorization Toestemming gegevensuitwisseling RVP): de waarde van typeCode MOET 'CON' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:assignedEntity1[not(@nullFlavor)][hl7:assignedPerson]) &gt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:assignedEntity1[not(@nullFlavor)][hl7:assignedPerson] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:assignedEntity1[not(@nullFlavor)][hl7:assignedPerson]) &lt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:assignedEntity1[not(@nullFlavor)][hl7:assignedPerson] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.50115
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:consultant[hl7:assignedEntity1]/hl7:assignedEntity1[not(@nullFlavor)][hl7:assignedPerson]
Item: (authorization Toestemming gegevensuitwisseling RVP)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:consultant[hl7:assignedEntity1]/hl7:assignedEntity1[not(@nullFlavor)][hl7:assignedPerson]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(authorization Toestemming gegevensuitwisseling RVP): de waarde van classCode MOET 'ASSIGNED' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:assignedPerson) &gt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:assignedPerson is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:assignedPerson) &lt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:assignedPerson komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.50115
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:consultant[hl7:assignedEntity1]/hl7:assignedEntity1[not(@nullFlavor)][hl7:assignedPerson]/hl7:assignedPerson
Item: (authorization Toestemming gegevensuitwisseling RVP)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:consultant[hl7:assignedEntity1]/hl7:assignedEntity1[not(@nullFlavor)][hl7:assignedPerson]/hl7:assignedPerson">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(authorization Toestemming gegevensuitwisseling RVP): de waarde van classCode MOET 'PSN' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(authorization Toestemming gegevensuitwisseling RVP): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:name) &gt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:name) &lt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:name komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.50115
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:consultant[hl7:assignedEntity1]/hl7:assignedEntity1[not(@nullFlavor)][hl7:assignedPerson]/hl7:assignedPerson/hl7:name
Item: (authorization Toestemming gegevensuitwisseling RVP)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:consultant[hl7:assignedEntity1]/hl7:assignedEntity1[not(@nullFlavor)][hl7:assignedPerson]/hl7:assignedPerson/hl7:name">
      <extends rule="TN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TN')">(authorization Toestemming gegevensuitwisseling RVP): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TN" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="string(@nullFlavor) = ('NI') or not(@nullFlavor)">(authorization Toestemming gegevensuitwisseling RVP): de waarde van nullFlavor MOET 'NI' zijn. Gevonden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.50115
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:consultant[hl7:assignedEntity1]/hl7:assignedEntity1[not(@nullFlavor)][hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (authorization Toestemming gegevensuitwisseling RVP)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:consultant[hl7:assignedEntity1]/hl7:assignedEntity1[not(@nullFlavor)][hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="string(@classCode) = ('ORG')">(authorization Toestemming gegevensuitwisseling RVP): de waarde van classCode MOET 'ORG' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="string(@determinerCode) = ('INSTANCE')">(authorization Toestemming gegevensuitwisseling RVP): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:id[@root = '2.16.528.1.1007.3.3'] | hl7:id[@root = '2.16.840.1.113883.2.4.6.1']) &gt;= 1">(authorization Toestemming gegevensuitwisseling RVP): keuze (hl7:id[@root = '2.16.528.1.1007.3.3']  of  hl7:id[@root = '2.16.840.1.113883.2.4.6.1']) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:id[@root = '2.16.528.1.1007.3.3']) &lt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:id[@root = '2.16.528.1.1007.3.3'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:id[@root = '2.16.840.1.113883.2.4.6.1']) &lt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:id[@root = '2.16.840.1.113883.2.4.6.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.50115
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:consultant[hl7:assignedEntity1]/hl7:assignedEntity1[not(@nullFlavor)][hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id[@root = '2.16.528.1.1007.3.3']
Item: (authorization Toestemming gegevensuitwisseling RVP)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:consultant[hl7:assignedEntity1]/hl7:assignedEntity1[not(@nullFlavor)][hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id[@root = '2.16.528.1.1007.3.3']">
      <extends rule="II.NL.URA"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(authorization Toestemming gegevensuitwisseling RVP): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="string(@root) = ('2.16.528.1.1007.3.3')">(authorization Toestemming gegevensuitwisseling RVP): de waarde van root MOET '2.16.528.1.1007.3.3' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.50115
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:consultant[hl7:assignedEntity1]/hl7:assignedEntity1[not(@nullFlavor)][hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id[@root = '2.16.840.1.113883.2.4.6.1']
Item: (authorization Toestemming gegevensuitwisseling RVP)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:consultant[hl7:assignedEntity1]/hl7:assignedEntity1[not(@nullFlavor)][hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id[@root = '2.16.840.1.113883.2.4.6.1']">
      <extends rule="II.NL.AGB"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(authorization Toestemming gegevensuitwisseling RVP): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.6.1')">(authorization Toestemming gegevensuitwisseling RVP): de waarde van root MOET '2.16.840.1.113883.2.4.6.1' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.50115
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:consultant[hl7:assignedEntity1]/hl7:assignedEntity1[not(@nullFlavor)][hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:name[not(@nullFlavor)]
Item: (authorization Toestemming gegevensuitwisseling RVP)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:consultant[hl7:assignedEntity1]/hl7:assignedEntity1[not(@nullFlavor)][hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:name[not(@nullFlavor)]">
      <extends rule="TN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TN')">(authorization Toestemming gegevensuitwisseling RVP): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TN" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.50115
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:subjectOf[hl7:annotation[hl7:code[(@code = '1541' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]
Item: (authorization Toestemming gegevensuitwisseling RVP)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:subjectOf[hl7:annotation[hl7:code[(@code = '1541' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="string(@typeCode) = ('SUBJ') or not(@typeCode)">(authorization Toestemming gegevensuitwisseling RVP): de waarde van typeCode MOET 'SUBJ' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:annotation[hl7:code[(@code = '1541' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]) &gt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:annotation[hl7:code[(@code = '1541' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:annotation[hl7:code[(@code = '1541' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]) &lt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:annotation[hl7:code[(@code = '1541' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.50115
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:subjectOf[hl7:annotation[hl7:code[(@code = '1541' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:annotation[hl7:code[(@code = '1541' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]
Item: (authorization Toestemming gegevensuitwisseling RVP)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:subjectOf[hl7:annotation[hl7:code[(@code = '1541' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:annotation[hl7:code[(@code = '1541' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:code[(@code = '1541' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]) &gt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:code[(@code = '1541' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:code[(@code = '1541' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]) &lt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:code[(@code = '1541' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.678-2018-06-12T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.678-2018-06-12T000000.xml')//valueSet[1]/conceptList/exception/@code]) &gt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.678-2018-06-12T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.678-2018-06-12T000000.xml')//valueSet[1]/conceptList/exception/@code] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.678-2018-06-12T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.678-2018-06-12T000000.xml')//valueSet[1]/conceptList/exception/@code]) &lt;= 1">(authorization Toestemming gegevensuitwisseling RVP): element hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.678-2018-06-12T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.678-2018-06-12T000000.xml')//valueSet[1]/conceptList/exception/@code] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.50115
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:subjectOf[hl7:annotation[hl7:code[(@code = '1541' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:annotation[hl7:code[(@code = '1541' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:code[(@code = '1541' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]
Item: (authorization Toestemming gegevensuitwisseling RVP)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:subjectOf[hl7:annotation[hl7:code[(@code = '1541' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:annotation[hl7:code[(@code = '1541' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:code[(@code = '1541' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(authorization Toestemming gegevensuitwisseling RVP): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="@nullFlavor or (@code='1541' and @codeSystem='2.16.840.1.113883.2.4.4.40.267')">(authorization Toestemming gegevensuitwisseling RVP): de elementwaarde MOET een zijn van 'code '1541' codeSystem '2.16.840.1.113883.2.4.4.40.267''.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="@displayName">(authorization Toestemming gegevensuitwisseling RVP): attribute @displayName MOET aanwezig zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.50115
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:subjectOf[hl7:annotation[hl7:code[(@code = '1541' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:annotation[hl7:code[(@code = '1541' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.678-2018-06-12T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.678-2018-06-12T000000.xml')//valueSet[1]/conceptList/exception/@code]
Item: (authorization Toestemming gegevensuitwisseling RVP)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:consentEvent[hl7:code[(@code = '1533' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:subjectOf[hl7:annotation[hl7:code[(@code = '1541' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:annotation[hl7:code[(@code = '1541' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.678-2018-06-12T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.678-2018-06-12T000000.xml')//valueSet[1]/conceptList/exception/@code]">
      <extends rule="CV"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.678-2018-06-12T000000.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(authorization Toestemming gegevensuitwisseling RVP): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.100.11.2.678 W0678 Toestemmingswijze (HL7) (2018-06-12T00:00:00)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.678-2018-06-12T000000.xml')//valueSet[1]/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(authorization Toestemming gegevensuitwisseling RVP): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst 2.16.840.1.113883.2.4.3.11.60.100.11.2.678 W0678 Toestemmingswijze (HL7) (2018-06-12T00:00:00).</assert>
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.50115-2020-05-27T000000.html"
              test="@nullFlavor or ($xsiLocalName='CV' and $xsiLocalNS='urn:hl7-org:v3')">(authorization Toestemming gegevensuitwisseling RVP): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10012
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component1[hl7:nonBDSData]
Item: (Care Provision Event component1 NonBDSData)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component1[hl7:nonBDSData]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10012-2020-05-27T000000.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Care Provision Event component1 NonBDSData): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10012-2020-05-27T000000.html"
              test="count(hl7:nonBDSData[not(@nullFlavor)]) &gt;= 1">(Care Provision Event component1 NonBDSData): element hl7:nonBDSData[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10012-2020-05-27T000000.html"
              test="count(hl7:nonBDSData[not(@nullFlavor)]) &lt;= 1">(Care Provision Event component1 NonBDSData): element hl7:nonBDSData[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10012
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component1[hl7:nonBDSData]/hl7:nonBDSData[not(@nullFlavor)]
Item: (Care Provision Event component1 NonBDSData)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component1[hl7:nonBDSData]/hl7:nonBDSData[not(@nullFlavor)]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10012-2020-05-27T000000.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Care Provision Event component1 NonBDSData): de waarde van classCode MOET 'OBS' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10012-2020-05-27T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Care Provision Event component1 NonBDSData): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10012-2020-05-27T000000.html"
              test="count(hl7:code) &gt;= 1">(Care Provision Event component1 NonBDSData): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10012-2020-05-27T000000.html"
              test="count(hl7:code) &lt;= 1">(Care Provision Event component1 NonBDSData): element hl7:code komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10012-2020-05-27T000000.html"
              test="count(hl7:text) &gt;= 1">(Care Provision Event component1 NonBDSData): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10012-2020-05-27T000000.html"
              test="count(hl7:text) &lt;= 1">(Care Provision Event component1 NonBDSData): element hl7:text komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10012-2020-05-27T000000.html"
              test="count(hl7:value) &lt;= 1">(Care Provision Event component1 NonBDSData): element hl7:value komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10012-2020-05-27T000000.html"
              test="count(hl7:pertainsTo[hl7:categoryInBDS[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]) &lt;= 1">(Care Provision Event component1 NonBDSData): element hl7:pertainsTo[hl7:categoryInBDS[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10012
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component1[hl7:nonBDSData]/hl7:nonBDSData[not(@nullFlavor)]/hl7:code
Item: (Care Provision Event component1 NonBDSData)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component1[hl7:nonBDSData]/hl7:nonBDSData[not(@nullFlavor)]/hl7:code">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10012-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Care Provision Event component1 NonBDSData): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10012-2020-05-27T000000.html"
              test="string(@nullFlavor) = ('OTH') or not(@nullFlavor)">(Care Provision Event component1 NonBDSData): de waarde van nullFlavor MOET 'OTH' zijn. Gevonden: "<value-of select="@nullFlavor"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10012-2020-05-27T000000.html"
              test="count(hl7:originalText) &lt;= 1">(Care Provision Event component1 NonBDSData): element hl7:originalText komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10012
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component1[hl7:nonBDSData]/hl7:nonBDSData[not(@nullFlavor)]/hl7:code/hl7:originalText
Item: (Care Provision Event component1 NonBDSData)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component1[hl7:nonBDSData]/hl7:nonBDSData[not(@nullFlavor)]/hl7:code/hl7:originalText">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10012-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(Care Provision Event component1 NonBDSData): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10012
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component1[hl7:nonBDSData]/hl7:nonBDSData[not(@nullFlavor)]/hl7:text
Item: (Care Provision Event component1 NonBDSData)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component1[hl7:nonBDSData]/hl7:nonBDSData[not(@nullFlavor)]/hl7:text">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10012-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(Care Provision Event component1 NonBDSData): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10012-2020-05-27T000000.html"
              test="not(@nullFlavor = 'OTH')">(Care Provision Event component1 NonBDSData): @nullFlavor OTH is als waarde niet toegestaan. Er is altijd een echte waarde indien @nullFlavor='OTH'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10012
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component1[hl7:nonBDSData]/hl7:nonBDSData[not(@nullFlavor)]/hl7:value
Item: (Care Provision Event component1 NonBDSData)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component1[hl7:nonBDSData]/hl7:nonBDSData[not(@nullFlavor)]/hl7:value">
      <extends rule="ANY"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10012-2020-05-27T000000.html"
              test="@xsi:type">(Care Provision Event component1 NonBDSData): attribute @xsi:type MOET aanwezig zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10012-2020-05-27T000000.html"
              test="not(@xsi:type) or (string-length(@xsi:type) &gt; 0 and not(matches(@xsi:type,'\s')))">(Care Provision Event component1 NonBDSData): attribuut @xsi:type MOET datatype 'cs' hebben  - '<value-of select="@xsi:type"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10012
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component1[hl7:nonBDSData]/hl7:nonBDSData[not(@nullFlavor)]/hl7:pertainsTo[hl7:categoryInBDS[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]
Item: (Care Provision Event component1 NonBDSData)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component1[hl7:nonBDSData]/hl7:nonBDSData[not(@nullFlavor)]/hl7:pertainsTo[hl7:categoryInBDS[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10012-2020-05-27T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Care Provision Event component1 NonBDSData): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10012-2020-05-27T000000.html"
              test="count(hl7:categoryInBDS[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &gt;= 1">(Care Provision Event component1 NonBDSData): element hl7:categoryInBDS[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10012-2020-05-27T000000.html"
              test="count(hl7:categoryInBDS[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &lt;= 1">(Care Provision Event component1 NonBDSData): element hl7:categoryInBDS[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10012
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component1[hl7:nonBDSData]/hl7:nonBDSData[not(@nullFlavor)]/hl7:pertainsTo[hl7:categoryInBDS[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:categoryInBDS[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]
Item: (Care Provision Event component1 NonBDSData)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component1[hl7:nonBDSData]/hl7:nonBDSData[not(@nullFlavor)]/hl7:pertainsTo[hl7:categoryInBDS[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:categoryInBDS[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10012-2020-05-27T000000.html"
              test="string(@classCode) = ('CLUSTER') or not(@classCode)">(Care Provision Event component1 NonBDSData): de waarde van classCode MOET 'CLUSTER' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10012-2020-05-27T000000.html"
              test="string(@moodCode) = ('DEF') or not(@moodCode)">(Care Provision Event component1 NonBDSData): de waarde van moodCode MOET 'DEF' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10012-2020-05-27T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(Care Provision Event component1 NonBDSData): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10012-2020-05-27T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(Care Provision Event component1 NonBDSData): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10012
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component1[hl7:nonBDSData]/hl7:nonBDSData[not(@nullFlavor)]/hl7:pertainsTo[hl7:categoryInBDS[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:categoryInBDS[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (Care Provision Event component1 NonBDSData)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component1[hl7:nonBDSData]/hl7:nonBDSData[not(@nullFlavor)]/hl7:pertainsTo[hl7:categoryInBDS[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:categoryInBDS[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10012-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Care Provision Event component1 NonBDSData): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10012-2020-05-27T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Care Provision Event component1 NonBDSData): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1 W0639 RubriekID constante gegevens (2012-05-21T01:26:54)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10013
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component2[hl7:metaData]
Item: (Care Provision Event component2 MetaData)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component2[hl7:metaData]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10013-2020-05-27T000000.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Care Provision Event component2 MetaData): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10013-2020-05-27T000000.html"
              test="count(hl7:metaData[not(@nullFlavor)]) &gt;= 1">(Care Provision Event component2 MetaData): element hl7:metaData[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10013-2020-05-27T000000.html"
              test="count(hl7:metaData[not(@nullFlavor)]) &lt;= 1">(Care Provision Event component2 MetaData): element hl7:metaData[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10013
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component2[hl7:metaData]/hl7:metaData[not(@nullFlavor)]
Item: (Care Provision Event component2 MetaData)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component2[hl7:metaData]/hl7:metaData[not(@nullFlavor)]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10013-2020-05-27T000000.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Care Provision Event component2 MetaData): de waarde van classCode MOET 'OBS' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10013-2020-05-27T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Care Provision Event component2 MetaData): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10013-2020-05-27T000000.html"
              test="count(hl7:code[not(@nullFlavor)]) &gt;= 1">(Care Provision Event component2 MetaData): element hl7:code[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10013-2020-05-27T000000.html"
              test="count(hl7:code[not(@nullFlavor)]) &lt;= 1">(Care Provision Event component2 MetaData): element hl7:code[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10013-2020-05-27T000000.html"
              test="count(hl7:text | hl7:value) &gt;= 1">(Care Provision Event component2 MetaData): keuze (hl7:text  of  hl7:value) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10013-2020-05-27T000000.html"
              test="count(hl7:text | hl7:value) &lt;= 2">(Care Provision Event component2 MetaData): keuze (hl7:text  of  hl7:value) bevat te veel elementen [max 2x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10013-2020-05-27T000000.html"
              test="count(hl7:text) &lt;= 1">(Care Provision Event component2 MetaData): element hl7:text komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10013-2020-05-27T000000.html"
              test="count(hl7:value) &lt;= 1">(Care Provision Event component2 MetaData): element hl7:value komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10013-2020-05-27T000000.html"
              test="count(hl7:pertainsTo[hl7:categoryInBDS[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.646.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.647-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]) &lt;= 1">(Care Provision Event component2 MetaData): element hl7:pertainsTo[hl7:categoryInBDS[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.646.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.647-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10013
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component2[hl7:metaData]/hl7:metaData[not(@nullFlavor)]/hl7:code[not(@nullFlavor)]
Item: (Care Provision Event component2 MetaData)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component2[hl7:metaData]/hl7:metaData[not(@nullFlavor)]/hl7:code[not(@nullFlavor)]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10013-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Care Provision Event component2 MetaData): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10013-2020-05-27T000000.html"
              test="@displayName or not(@code)">(Care Provision Event component2 MetaData): 
                            <name path=".."/>/<name/>/@displayName MOET een waarde bevatten</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10013
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component2[hl7:metaData]/hl7:metaData[not(@nullFlavor)]/hl7:text
Item: (Care Provision Event component2 MetaData)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component2[hl7:metaData]/hl7:metaData[not(@nullFlavor)]/hl7:text">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10013-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(Care Provision Event component2 MetaData): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10013
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component2[hl7:metaData]/hl7:metaData[not(@nullFlavor)]/hl7:value
Item: (Care Provision Event component2 MetaData)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component2[hl7:metaData]/hl7:metaData[not(@nullFlavor)]/hl7:value">
      <extends rule="ANY"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10013-2020-05-27T000000.html"
              test="@xsi:type">(Care Provision Event component2 MetaData): attribute @xsi:type MOET aanwezig zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10013-2020-05-27T000000.html"
              test="@displayName or not(@code)">(Care Provision Event component2 MetaData): 
                                <name path=".."/>/<name/>/@displayName MOET een waarde bevatten als het gecodeerde gegevens betreft</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10013
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component2[hl7:metaData]/hl7:metaData[not(@nullFlavor)]/hl7:pertainsTo[hl7:categoryInBDS[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.646.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.647-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]
Item: (Care Provision Event component2 MetaData)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component2[hl7:metaData]/hl7:metaData[not(@nullFlavor)]/hl7:pertainsTo[hl7:categoryInBDS[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.646.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.647-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10013-2020-05-27T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Care Provision Event component2 MetaData): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10013-2020-05-27T000000.html"
              test="count(hl7:categoryInBDS[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.646.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.647-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &gt;= 1">(Care Provision Event component2 MetaData): element hl7:categoryInBDS[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.646.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.647-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10013-2020-05-27T000000.html"
              test="count(hl7:categoryInBDS[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.646.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.647-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &lt;= 1">(Care Provision Event component2 MetaData): element hl7:categoryInBDS[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.646.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.647-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10013
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component2[hl7:metaData]/hl7:metaData[not(@nullFlavor)]/hl7:pertainsTo[hl7:categoryInBDS[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.646.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.647-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:categoryInBDS[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.646.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.647-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]
Item: (Care Provision Event component2 MetaData)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component2[hl7:metaData]/hl7:metaData[not(@nullFlavor)]/hl7:pertainsTo[hl7:categoryInBDS[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.646.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.647-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:categoryInBDS[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.646.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.647-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10013-2020-05-27T000000.html"
              test="string(@classCode) = ('CLUSTER') or not(@classCode)">(Care Provision Event component2 MetaData): de waarde van classCode MOET 'CLUSTER' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10013-2020-05-27T000000.html"
              test="string(@moodCode) = ('DEF') or not(@moodCode)">(Care Provision Event component2 MetaData): de waarde van moodCode MOET 'DEF' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10013-2020-05-27T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.646.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.647-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(Care Provision Event component2 MetaData): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.646.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.647-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10013-2020-05-27T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.646.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.647-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(Care Provision Event component2 MetaData): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.646.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.647-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10013
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component2[hl7:metaData]/hl7:metaData[not(@nullFlavor)]/hl7:pertainsTo[hl7:categoryInBDS[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.646.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.647-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:categoryInBDS[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.646.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.647-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.646.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.647-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (Care Provision Event component2 MetaData)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component2[hl7:metaData]/hl7:metaData[not(@nullFlavor)]/hl7:pertainsTo[hl7:categoryInBDS[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.646.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.647-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:categoryInBDS[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.646.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.647-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.646.1-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.647-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10013-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Care Provision Event component2 MetaData): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10013-2020-05-27T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1-2012-05-21T012654.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]]) or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.646.1-2012-05-21T012654.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]]) or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.647-2012-05-21T012654.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Care Provision Event component2 MetaData): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.100.11.2.639.1 W0639 RubriekID constante gegevens (2012-05-21T01:26:54) of 2.16.840.1.113883.2.4.3.11.60.100.11.2.646.1 W0646 GroepID constante gegevens (2012-05-21T01:26:54) of 2.16.840.1.113883.2.4.3.11.60.100.11.2.647 W0647 BDS Elementen (2012-05-21T01:26:54)'.</assert>
      <report fpi="CD-DEPR-BSP"
              role="warning"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10013-2020-05-27T000000.html"
              test="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.647-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept[@type='D'][@code = $theCode][@codeSystem = $theCodeSystem])">(Care Provision Event component2 MetaData): element hl7:code is gecodeerd met bindingssterkte 'required' en bevat een code die verouderd is.</report>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10018
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7
Item: (Care Provision Event component7 Activiteiten)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10018-2024-11-01T000000.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Care Provision Event component7 Activiteiten): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10018-2024-11-01T000000.html"
              test="count(hl7:encounter[@moodCode='EVN'][not(@nullFlavor)] | hl7:encounter[@moodCode='INT'][not(@nullFlavor)]) &gt;= 1">(Care Provision Event component7 Activiteiten): keuze (hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]  of  hl7:encounter[@moodCode='INT'][not(@nullFlavor)]) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10018-2024-11-01T000000.html"
              test="count(hl7:encounter[@moodCode='EVN'][not(@nullFlavor)] | hl7:encounter[@moodCode='INT'][not(@nullFlavor)]) &lt;= 1">(Care Provision Event component7 Activiteiten): keuze (hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]  of  hl7:encounter[@moodCode='INT'][not(@nullFlavor)]) bevat te veel elementen [max 1x]</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10020
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]
Item: (Activiteit Contactmoment)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="string(@classCode) = ('ENC') or not(@classCode)">(Activiteit Contactmoment): de waarde van classCode MOET 'ENC' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="string(@moodCode) = ('EVN')">(Activiteit Contactmoment): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(Activiteit Contactmoment): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(Activiteit Contactmoment): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]) &gt;= 1">(Activiteit Contactmoment): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]) &lt;= 1">(Activiteit Contactmoment): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:statusCode[@code = 'completed' or @code = 'aborted']) &gt;= 1">(Activiteit Contactmoment): element hl7:statusCode[@code = 'completed' or @code = 'aborted'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:statusCode[@code = 'completed' or @code = 'aborted']) &lt;= 1">(Activiteit Contactmoment): element hl7:statusCode[@code = 'completed' or @code = 'aborted'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:effectiveTime[not(@nullFlavor)]) &gt;= 1">(Activiteit Contactmoment): element hl7:effectiveTime[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:effectiveTime[not(@nullFlavor)]) &lt;= 1">(Activiteit Contactmoment): element hl7:effectiveTime[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]) &lt;= 1">(Activiteit Contactmoment): element hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:author) = 0">(Activiteit Contactmoment): element hl7:author MAG NIET voorkomen.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:consultant[hl7:assignedEntity[@classCode = 'ASSIGNED']]) &lt;= 1">(Activiteit Contactmoment): element hl7:consultant[hl7:assignedEntity[@classCode = 'ASSIGNED']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:inFulfillmentOf[hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]]) &lt;= 1">(Activiteit Contactmoment): element hl7:inFulfillmentOf[hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11018']]]) &gt;= 1">(Activiteit Contactmoment): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11018']]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11018']]]) &lt;= 1">(Activiteit Contactmoment): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11018']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]]) &lt;= 1">(Activiteit Contactmoment): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11013']]]) &lt;= 1">(Activiteit Contactmoment): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11013']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11019']]]) &lt;= 1">(Activiteit Contactmoment): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11019']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11020']]]) &lt;= 1">(Activiteit Contactmoment): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11020']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11021']]]) &lt;= 1">(Activiteit Contactmoment): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11021']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11022']]]) &lt;= 1">(Activiteit Contactmoment): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11022']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11023']]]) &lt;= 1">(Activiteit Contactmoment): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11023']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11024']]]) &lt;= 1">(Activiteit Contactmoment): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11024']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11025']]]) &lt;= 1">(Activiteit Contactmoment): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11025']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11026']]]) &lt;= 1">(Activiteit Contactmoment): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11026']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11027']]]) &lt;= 1">(Activiteit Contactmoment): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11027']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11030']]]) &lt;= 1">(Activiteit Contactmoment): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11030']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11031']]]) &lt;= 1">(Activiteit Contactmoment): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11031']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11032']]]) &lt;= 1">(Activiteit Contactmoment): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11032']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11034']]]) &lt;= 1">(Activiteit Contactmoment): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11034']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11038']]]) &lt;= 1">(Activiteit Contactmoment): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11038']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11039']]]) &lt;= 1">(Activiteit Contactmoment): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11039']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11040']]]) &lt;= 1">(Activiteit Contactmoment): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11040']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11041']]]) &lt;= 1">(Activiteit Contactmoment): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11041']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11042']]]) &lt;= 1">(Activiteit Contactmoment): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11042']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11043']]]) &lt;= 1">(Activiteit Contactmoment): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11043']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11054']]]) &lt;= 1">(Activiteit Contactmoment): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11054']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11045']]]) &lt;= 1">(Activiteit Contactmoment): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11045']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11049']]]) &lt;= 1">(Activiteit Contactmoment): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11049']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:subjectOf[hl7:abortedEvent[hl7:code[(@code = '495' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267') or @nullFlavor]]]) &lt;= 1">(Activiteit Contactmoment): element hl7:subjectOf[hl7:abortedEvent[hl7:code[(@code = '495' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267') or @nullFlavor]]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:subjectOf1[hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]) &lt;= 1">(Activiteit Contactmoment): element hl7:subjectOf1[hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10020
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:id[not(@nullFlavor)]
Item: (Activiteit Contactmoment)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:id[not(@nullFlavor)]">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Activiteit Contactmoment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="@root and @extension">(Activiteit Contactmoment): 
                        <name path=".."/>/<name/> MOET een waarde in @root en @extension hebben.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10020
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]
Item: (Activiteit Contactmoment)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Activiteit Contactmoment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Activiteit Contactmoment): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.100.11.2.188 W0188 Soort activiteit (HL7) (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(Activiteit Contactmoment): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst 2.16.840.1.113883.2.4.3.11.60.100.11.2.188 W0188 Soort activiteit (HL7) (DYNAMISCH).</assert>
      <report fpi="CD-DEPR-BSP"
              role="warning"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@type='D'][@code = $theCode][@codeSystem = $theCodeSystem])">(Activiteit Contactmoment): element hl7:code is gecodeerd met bindingssterkte 'required' en bevat een code die verouderd is.</report>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10020
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:statusCode[@code = 'completed' or @code = 'aborted']
Item: (Activiteit Contactmoment)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:statusCode[@code = 'completed' or @code = 'aborted']">
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(Activiteit Contactmoment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="@nullFlavor or (@code='completed') or (@code='aborted')">(Activiteit Contactmoment): de elementwaarde MOET een zijn van 'code 'completed' of code 'aborted''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10020
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:effectiveTime[not(@nullFlavor)]
Item: (Activiteit Contactmoment)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:effectiveTime[not(@nullFlavor)]">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(Activiteit Contactmoment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="not(*)">(Activiteit Contactmoment): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10020
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:reasonCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.619-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.619-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]
Item: (Activiteit Contactmoment)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:reasonCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.619-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.619-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Activiteit Contactmoment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.619-2024-11-01T000000.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Activiteit Contactmoment): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.100.11.2.619 W0619 Indicatie (HL7) (2024-11-01T00:00:00)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.619-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(Activiteit Contactmoment): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst 2.16.840.1.113883.2.4.3.11.60.100.11.2.619 W0619 Indicatie (HL7) (2024-11-01T00:00:00).</assert>
      <report fpi="CD-DEPR-BSP"
              role="warning"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.619-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept[@type='D'][@code = $theCode][@codeSystem = $theCodeSystem])">(Activiteit Contactmoment): element hl7:reasonCode is gecodeerd met bindingssterkte 'required' en bevat een code die verouderd is.</report>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10022
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]
Item: (Activities performer (uitvoerende persoon))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="string(@typeCode) = ('PRF') or not(@typeCode)">(Activities performer (uitvoerende persoon)): de waarde van typeCode MOET 'PRF' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="count(hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']) &gt;= 1">(Activities performer (uitvoerende persoon)): element hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="count(hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']) &lt;= 1">(Activities performer (uitvoerende persoon)): element hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED'] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10022
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']
Item: (Activities performer (uitvoerende persoon))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="string(@classCode) = ('ASSIGNED')">(Activities performer (uitvoerende persoon)): de waarde van classCode MOET 'ASSIGNED' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="hl7:id[@root and @extension] or hl7:assignedPerson[hl7:name[string-length()&gt;0]]">(Activities performer (uitvoerende persoon)): Als gegevens van een uitvoerende worden doorgegeven dan is een waarde voor id en/of name verplicht</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="count(hl7:id[@root = '2.16.528.1.1007.3.1'] | hl7:id[@root = '2.16.528.1.1007.5.1'] | hl7:id[@root = '2.16.840.1.113883.2.4.6.1'] | hl7:id[@nullFlavor = 'NI']) &gt;= 1">(Activities performer (uitvoerende persoon)): keuze (hl7:id[@root = '2.16.528.1.1007.3.1']  of  hl7:id[@root = '2.16.528.1.1007.5.1']  of  hl7:id[@root = '2.16.840.1.113883.2.4.6.1']  of  hl7:id[@nullFlavor = 'NI']) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="count(hl7:id[@root = '2.16.528.1.1007.3.1'] | hl7:id[@root = '2.16.528.1.1007.5.1'] | hl7:id[@root = '2.16.840.1.113883.2.4.6.1'] | hl7:id[@nullFlavor = 'NI']) &lt;= 3">(Activities performer (uitvoerende persoon)): keuze (hl7:id[@root = '2.16.528.1.1007.3.1']  of  hl7:id[@root = '2.16.528.1.1007.5.1']  of  hl7:id[@root = '2.16.840.1.113883.2.4.6.1']  of  hl7:id[@nullFlavor = 'NI']) bevat te veel elementen [max 3x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="count(hl7:id[@root = '2.16.528.1.1007.3.1']) &lt;= 1">(Activities performer (uitvoerende persoon)): element hl7:id[@root = '2.16.528.1.1007.3.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="count(hl7:id[@root = '2.16.528.1.1007.5.1']) &lt;= 1">(Activities performer (uitvoerende persoon)): element hl7:id[@root = '2.16.528.1.1007.5.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="count(hl7:id[@root = '2.16.840.1.113883.2.4.6.1']) &lt;= 1">(Activities performer (uitvoerende persoon)): element hl7:id[@root = '2.16.840.1.113883.2.4.6.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="count(hl7:id[@nullFlavor = 'NI']) &lt;= 1">(Activities performer (uitvoerende persoon)): element hl7:id[@nullFlavor = 'NI'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.686-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.686-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]) &lt;= 1">(Activities performer (uitvoerende persoon)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.686-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.686-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="count(hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']) &lt;= 1">(Activities performer (uitvoerende persoon)): element hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE'] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10022
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']/hl7:id[@root = '2.16.528.1.1007.3.1']
Item: (Activities performer (uitvoerende persoon))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']/hl7:id[@root = '2.16.528.1.1007.3.1']">
      <extends rule="II.NL.UZI"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Activities performer (uitvoerende persoon)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="string(@root) = ('2.16.528.1.1007.3.1')">(Activities performer (uitvoerende persoon)): de waarde van root MOET '2.16.528.1.1007.3.1' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10022
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']/hl7:id[@root = '2.16.528.1.1007.5.1']
Item: (Activities performer (uitvoerende persoon))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']/hl7:id[@root = '2.16.528.1.1007.5.1']">
      <extends rule="II.NL.BIG"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Activities performer (uitvoerende persoon)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="string(@root) = ('2.16.528.1.1007.5.1')">(Activities performer (uitvoerende persoon)): de waarde van root MOET '2.16.528.1.1007.5.1' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10022
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']/hl7:id[@root = '2.16.840.1.113883.2.4.6.1']
Item: (Activities performer (uitvoerende persoon))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']/hl7:id[@root = '2.16.840.1.113883.2.4.6.1']">
      <extends rule="II.NL.AGB"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Activities performer (uitvoerende persoon)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.6.1')">(Activities performer (uitvoerende persoon)): de waarde van root MOET '2.16.840.1.113883.2.4.6.1' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10022
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']/hl7:id[@nullFlavor = 'NI']
Item: (Activities performer (uitvoerende persoon))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']/hl7:id[@nullFlavor = 'NI']">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Activities performer (uitvoerende persoon)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="string(@nullFlavor) = ('NI')">(Activities performer (uitvoerende persoon)): de waarde van nullFlavor MOET 'NI' zijn. Gevonden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10022
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.686-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.686-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]
Item: (Activities performer (uitvoerende persoon))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.686-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.686-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Activities performer (uitvoerende persoon)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.686-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Activities performer (uitvoerende persoon)): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.100.11.2.686 W0686 Uitvoerende activiteit discipline (HL7) (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.686-DYNAMIC.xml')//valueSet[1]/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(Activities performer (uitvoerende persoon)): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst 2.16.840.1.113883.2.4.3.11.60.100.11.2.686 W0686 Uitvoerende activiteit discipline (HL7) (DYNAMISCH).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10022
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']/hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']
Item: (Activities performer (uitvoerende persoon))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']/hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="string(@classCode) = ('PSN')">(Activities performer (uitvoerende persoon)): de waarde van classCode MOET 'PSN' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="string(@determinerCode) = ('INSTANCE')">(Activities performer (uitvoerende persoon)): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(Activities performer (uitvoerende persoon)): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(Activities performer (uitvoerende persoon)): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10022
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']/hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:name[not(@nullFlavor)]
Item: (Activities performer (uitvoerende persoon))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']/hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:name[not(@nullFlavor)]">
      <extends rule="PN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PN')">(Activities performer (uitvoerende persoon)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10020
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:author
Item: (Activiteit Contactmoment)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10024
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:consultant[hl7:assignedEntity[@classCode = 'ASSIGNED']]
Item: (Activities consultant (contact met))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:consultant[hl7:assignedEntity[@classCode = 'ASSIGNED']]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10024-2020-05-27T000000.html"
              test="string(@typeCode) = ('CON') or not(@typeCode)">(Activities consultant (contact met)): de waarde van typeCode MOET 'CON' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10024-2020-05-27T000000.html"
              test="count(hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED'][hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]) &gt;= 1">(Activities consultant (contact met)): element hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED'][hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10024-2020-05-27T000000.html"
              test="count(hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED'][hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]) &lt;= 1">(Activities consultant (contact met)): element hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED'][hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10024
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:consultant[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED'][hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]
Item: (Activities consultant (contact met))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:consultant[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED'][hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10024-2020-05-27T000000.html"
              test="string(@classCode) = ('ASSIGNED')">(Activities consultant (contact met)): de waarde van classCode MOET 'ASSIGNED' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10024-2020-05-27T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.680-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.680-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code]) &lt;= 1">(Activities consultant (contact met)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.680-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.680-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10024-2020-05-27T000000.html"
              test="count(hl7:assignedPerson[not(@nullFlavor)][@classCode = 'PSN'][@determinerCode = 'INSTANCE']) &gt;= 1">(Activities consultant (contact met)): element hl7:assignedPerson[not(@nullFlavor)][@classCode = 'PSN'][@determinerCode = 'INSTANCE'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10024-2020-05-27T000000.html"
              test="count(hl7:assignedPerson[not(@nullFlavor)][@classCode = 'PSN'][@determinerCode = 'INSTANCE']) &lt;= 1">(Activities consultant (contact met)): element hl7:assignedPerson[not(@nullFlavor)][@classCode = 'PSN'][@determinerCode = 'INSTANCE'] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10024
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:consultant[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED'][hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.680-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.680-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code]
Item: (Activities consultant (contact met))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:consultant[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED'][hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.680-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.680-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10024-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Activities consultant (contact met)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10024-2020-05-27T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.680-2020-05-27T000000.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Activities consultant (contact met)): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.100.11.2.680 W0680 Contact ivm meldcode met discipline (HL7) (2020-05-27T00:00:00)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.680-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10024-2020-05-27T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(Activities consultant (contact met)): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst 2.16.840.1.113883.2.4.3.11.60.100.11.2.680 W0680 Contact ivm meldcode met discipline (HL7) (2020-05-27T00:00:00).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10024
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:consultant[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED'][hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:assignedPerson[not(@nullFlavor)][@classCode = 'PSN'][@determinerCode = 'INSTANCE']
Item: (Activities consultant (contact met))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:consultant[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED'][hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:assignedPerson[not(@nullFlavor)][@classCode = 'PSN'][@determinerCode = 'INSTANCE']">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10024-2020-05-27T000000.html"
              test="string(@classCode) = ('PSN')">(Activities consultant (contact met)): de waarde van classCode MOET 'PSN' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10024-2020-05-27T000000.html"
              test="string(@determinerCode) = ('INSTANCE')">(Activities consultant (contact met)): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10024-2020-05-27T000000.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(Activities consultant (contact met)): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10024-2020-05-27T000000.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(Activities consultant (contact met)): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10024
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:consultant[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED'][hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:assignedPerson[not(@nullFlavor)][@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:name[not(@nullFlavor)]
Item: (Activities consultant (contact met))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:consultant[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED'][hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:assignedPerson[not(@nullFlavor)][@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:name[not(@nullFlavor)]">
      <extends rule="PN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10024-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PN')">(Activities consultant (contact met)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10025
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:escort[hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]
Item: (Activities escort (begeleider))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:escort[hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10025-2024-11-01T000000.html"
              test="string(@typeCode) = ('ESC') or not(@typeCode)">(Activities escort (begeleider)): de waarde van typeCode MOET 'ESC' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10025-2024-11-01T000000.html"
              test="count(hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]) &gt;= 1">(Activities escort (begeleider)): element hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10025-2024-11-01T000000.html"
              test="count(hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]) &lt;= 1">(Activities escort (begeleider)): element hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10025
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:escort[hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]
Item: (Activities escort (begeleider))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:escort[hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10025-2024-11-01T000000.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(Activities escort (begeleider)): de waarde van classCode MOET 'ASSIGNED' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10025-2024-11-01T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]) &gt;= 1">(Activities escort (begeleider)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10025-2024-11-01T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]) &lt;= 1">(Activities escort (begeleider)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10025-2024-11-01T000000.html"
              test="count(hl7:agentPerson[@nullFlavor = 'NI']) &gt;= 1">(Activities escort (begeleider)): element hl7:agentPerson[@nullFlavor = 'NI'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10025-2024-11-01T000000.html"
              test="count(hl7:agentPerson[@nullFlavor = 'NI']) &lt;= 1">(Activities escort (begeleider)): element hl7:agentPerson[@nullFlavor = 'NI'] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10025
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:escort[hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]
Item: (Activities escort (begeleider))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:escort[hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10025-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Activities escort (begeleider)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10025-2024-11-01T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Activities escort (begeleider)): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.100.11.2.193 W0193 Begeleider (HL7) (2024-11-01T00:00:00)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10025-2024-11-01T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(Activities escort (begeleider)): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst 2.16.840.1.113883.2.4.3.11.60.100.11.2.193 W0193 Begeleider (HL7) (2024-11-01T00:00:00).</assert>
      <report fpi="CD-DEPR-BSP"
              role="warning"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10025-2024-11-01T000000.html"
              test="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept[@type='D'][@code = $theCode][@codeSystem = $theCodeSystem])">(Activities escort (begeleider)): element hl7:code is gecodeerd met bindingssterkte 'required' en bevat een code die verouderd is.</report>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10025
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:escort[hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:agentPerson[@nullFlavor = 'NI']
Item: (Activities escort (begeleider))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:escort[hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:agentPerson[@nullFlavor = 'NI']">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10025-2024-11-01T000000.html"
              test="string(@nullFlavor) = ('NI')">(Activities escort (begeleider)): de waarde van nullFlavor MOET 'NI' zijn. Gevonden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10020
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:inFulfillmentOf[hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]]
Item: (Activiteit Contactmoment)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:inFulfillmentOf[hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="string(@typeCode) = ('FLFS') or not(@typeCode)">(Activiteit Contactmoment): de waarde van typeCode MOET 'FLFS' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]) &gt;= 1">(Activiteit Contactmoment): element hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]) &lt;= 1">(Activiteit Contactmoment): element hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10020
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:inFulfillmentOf[hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]
Item: (Activiteit Contactmoment)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:inFulfillmentOf[hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="string(@classCode) = ('ENC') or not(@classCode)">(Activiteit Contactmoment): de waarde van classCode MOET 'ENC' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="string(@moodCode) = ('INT')">(Activiteit Contactmoment): de waarde van moodCode MOET 'INT' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:id) &gt;= 1">(Activiteit Contactmoment): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:id) &lt;= 1">(Activiteit Contactmoment): element hl7:id komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]) &gt;= 1">(Activiteit Contactmoment): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]) &lt;= 1">(Activiteit Contactmoment): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:statusCode[@code = 'completed']) &gt;= 1">(Activiteit Contactmoment): element hl7:statusCode[@code = 'completed'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:statusCode[@code = 'completed']) &lt;= 1">(Activiteit Contactmoment): element hl7:statusCode[@code = 'completed'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Activiteit Contactmoment): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:author) &lt;= 1">(Activiteit Contactmoment): element hl7:author komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10020
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:inFulfillmentOf[hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:id
Item: (Activiteit Contactmoment)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:inFulfillmentOf[hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:id">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Activiteit Contactmoment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="string(@nullFlavor) = ('NI') or not(@nullFlavor)">(Activiteit Contactmoment): de waarde van nullFlavor MOET 'NI' zijn. Gevonden: "<value-of select="@nullFlavor"/>"</assert>
      <report role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="@root and concat(@root, @extension) = ../../../hl7:id/concat(@root, @extension)">(Activiteit Contactmoment): De identificatie van de afspraak (root="<value-of select="@root"/>" extension="<value-of select="@extension"/>") kan logisch gezien niet gelijk zijn aan die van het contactmoment zelf.</report>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10020
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:inFulfillmentOf[hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]
Item: (Activiteit Contactmoment)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:inFulfillmentOf[hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Activiteit Contactmoment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Activiteit Contactmoment): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.100.11.2.188 W0188 Soort activiteit (HL7) (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(Activiteit Contactmoment): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst 2.16.840.1.113883.2.4.3.11.60.100.11.2.188 W0188 Soort activiteit (HL7) (DYNAMISCH).</assert>
      <report fpi="CD-DEPR-BSP"
              role="warning"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@type='D'][@code = $theCode][@codeSystem = $theCodeSystem])">(Activiteit Contactmoment): element hl7:code is gecodeerd met bindingssterkte 'required' en bevat een code die verouderd is.</report>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10020
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:inFulfillmentOf[hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:statusCode[@code = 'completed']
Item: (Activiteit Contactmoment)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:inFulfillmentOf[hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:statusCode[@code = 'completed']">
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(Activiteit Contactmoment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="@nullFlavor or (@code='completed')">(Activiteit Contactmoment): de elementwaarde MOET een zijn van 'code 'completed''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10020
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:inFulfillmentOf[hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:effectiveTime
Item: (Activiteit Contactmoment)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:inFulfillmentOf[hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:effectiveTime">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(Activiteit Contactmoment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="not(*)">(Activiteit Contactmoment): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10023
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:inFulfillmentOf[hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:author
Item: (Activities encounterINT author (Verzoeker activiteit))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:inFulfillmentOf[hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:author">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(Activities encounterINT author (Verzoeker activiteit)): de waarde van typeCode MOET 'AUT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="count(hl7:patient | hl7:personalRelationship[hl7:code[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.411')]] | hl7:assignedEntity1[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code]]) &gt;= 1">(Activities encounterINT author (Verzoeker activiteit)): keuze (hl7:patient  of  hl7:personalRelationship[hl7:code[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.411')]]  of  hl7:assignedEntity1[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code]]) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="count(hl7:patient | hl7:personalRelationship[hl7:code[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.411')]] | hl7:assignedEntity1[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code]]) &lt;= 1">(Activities encounterINT author (Verzoeker activiteit)): keuze (hl7:patient  of  hl7:personalRelationship[hl7:code[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.411')]]  of  hl7:assignedEntity1[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code]]) bevat te veel elementen [max 1x]</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10023
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:inFulfillmentOf[hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:author/hl7:patient
Item: (Activities encounterINT author (Verzoeker activiteit))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:inFulfillmentOf[hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:author/hl7:patient">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="string(@classCode) = ('PAT') or not(@classCode)">(Activities encounterINT author (Verzoeker activiteit)): de waarde van classCode MOET 'PAT' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10023
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:inFulfillmentOf[hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:author/hl7:personalRelationship[hl7:code[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.411')]]
Item: (Activities encounterINT author (Verzoeker activiteit))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:inFulfillmentOf[hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:author/hl7:personalRelationship[hl7:code[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.411')]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="string(@classCode) = ('PRS') or not(@classCode)">(Activities encounterINT author (Verzoeker activiteit)): de waarde van classCode MOET 'PRS' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="count(hl7:code[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.411')]) &gt;= 1">(Activities encounterINT author (Verzoeker activiteit)): element hl7:code[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.411')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="count(hl7:code[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.411')]) &lt;= 1">(Activities encounterINT author (Verzoeker activiteit)): element hl7:code[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.411')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="count(hl7:relationshipHolder[@classCode = 'PSN'][@determinerCode = 'INSTANCE'][@nullFlavor = 'NI']) &gt;= 1">(Activities encounterINT author (Verzoeker activiteit)): element hl7:relationshipHolder[@classCode = 'PSN'][@determinerCode = 'INSTANCE'][@nullFlavor = 'NI'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="count(hl7:relationshipHolder[@classCode = 'PSN'][@determinerCode = 'INSTANCE'][@nullFlavor = 'NI']) &lt;= 1">(Activities encounterINT author (Verzoeker activiteit)): element hl7:relationshipHolder[@classCode = 'PSN'][@determinerCode = 'INSTANCE'][@nullFlavor = 'NI'] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10023
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:inFulfillmentOf[hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:author/hl7:personalRelationship[hl7:code[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.411')]]/hl7:code[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.411')]
Item: (Activities encounterINT author (Verzoeker activiteit))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:inFulfillmentOf[hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:author/hl7:personalRelationship[hl7:code[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.411')]]/hl7:code[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.411')]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Activities encounterINT author (Verzoeker activiteit)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="@nullFlavor or (@code='02' and @codeSystem='2.16.840.1.113883.2.4.4.40.411')">(Activities encounterINT author (Verzoeker activiteit)): de elementwaarde MOET een zijn van 'code '02' codeSystem '2.16.840.1.113883.2.4.4.40.411''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10023
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:inFulfillmentOf[hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:author/hl7:personalRelationship[hl7:code[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.411')]]/hl7:relationshipHolder[@classCode = 'PSN'][@determinerCode = 'INSTANCE'][@nullFlavor = 'NI']
Item: (Activities encounterINT author (Verzoeker activiteit))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:inFulfillmentOf[hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:author/hl7:personalRelationship[hl7:code[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.411')]]/hl7:relationshipHolder[@classCode = 'PSN'][@determinerCode = 'INSTANCE'][@nullFlavor = 'NI']">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="string(@classCode) = ('PSN')">(Activities encounterINT author (Verzoeker activiteit)): de waarde van classCode MOET 'PSN' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="string(@determinerCode) = ('INSTANCE')">(Activities encounterINT author (Verzoeker activiteit)): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="string(@nullFlavor) = ('NI')">(Activities encounterINT author (Verzoeker activiteit)): de waarde van nullFlavor MOET 'NI' zijn. Gevonden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10023
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:inFulfillmentOf[hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:author/hl7:assignedEntity1[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code]]
Item: (Activities encounterINT author (Verzoeker activiteit))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:inFulfillmentOf[hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:author/hl7:assignedEntity1[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(Activities encounterINT author (Verzoeker activiteit)): de waarde van classCode MOET 'ASSIGNED' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code]) &gt;= 1">(Activities encounterINT author (Verzoeker activiteit)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code]) &lt;= 1">(Activities encounterINT author (Verzoeker activiteit)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10023
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:inFulfillmentOf[hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:author/hl7:assignedEntity1[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code]
Item: (Activities encounterINT author (Verzoeker activiteit))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:inFulfillmentOf[hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:encounter[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:author/hl7:assignedEntity1[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Activities encounterINT author (Verzoeker activiteit)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Activities encounterINT author (Verzoeker activiteit)): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.100.11.2.659 W0659 Verzoeker activiteit (HL7) (2020-05-27T00:00:00)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound or @nullFlavor=('OTH')">(Activities encounterINT author (Verzoeker activiteit)): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst 2.16.840.1.113883.2.4.3.11.60.100.11.2.659 W0659 Verzoeker activiteit (HL7) (2020-05-27T00:00:00).</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="not(@code='02')">(Activities encounterINT author (Verzoeker activiteit)): 
                                <name path=".."/>/<name/>/@code '02' moet in element personalRelationship</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="not(@code='03')">(Activities encounterINT author (Verzoeker activiteit)): 
                                <name path=".."/>/<name/>/@code '03' moet in element patient</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11018']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11018']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11013']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11013']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11019']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11019']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11020']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11020']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11021']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11021']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11022']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11022']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11023']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11023']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11024']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11024']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11025']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11025']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11026']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11026']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11027']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11027']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11030']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11030']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11031']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11031']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11032']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11032']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11034']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11034']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11038']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11038']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11039']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11039']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11040']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11040']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11041']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11041']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11042']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11042']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11043']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11043']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11054']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11054']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11045']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11045']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11049']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11049']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10020
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:component1[hl7:nonBDSData[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10028']]]
Item: (Activiteit Contactmoment)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:component1[hl7:nonBDSData[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10028']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Activiteit Contactmoment): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10020
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:component2[hl7:metaData[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10029']]]
Item: (Activiteit Contactmoment)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:component2[hl7:metaData[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10029']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Activiteit Contactmoment): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10020
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:component3[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]
Item: (Activiteit Contactmoment)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:component3[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Activiteit Contactmoment): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10020
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:subjectOf[hl7:abortedEvent[hl7:code[(@code = '495' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267') or @nullFlavor]]]
Item: (Activiteit Contactmoment)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:subjectOf[hl7:abortedEvent[hl7:code[(@code = '495' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267') or @nullFlavor]]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="string(@typeCode) = ('SUBJ') or not(@typeCode)">(Activiteit Contactmoment): de waarde van typeCode MOET 'SUBJ' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:abortedEvent[hl7:code[(@code = '495' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267') or @nullFlavor]]) &gt;= 1">(Activiteit Contactmoment): element hl7:abortedEvent[hl7:code[(@code = '495' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267') or @nullFlavor]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:abortedEvent[hl7:code[(@code = '495' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267') or @nullFlavor]]) &lt;= 1">(Activiteit Contactmoment): element hl7:abortedEvent[hl7:code[(@code = '495' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267') or @nullFlavor]] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10020
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:subjectOf[hl7:abortedEvent[hl7:code[(@code = '495' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267') or @nullFlavor]]]/hl7:abortedEvent[hl7:code[(@code = '495' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267') or @nullFlavor]]
Item: (Activiteit Contactmoment)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:subjectOf[hl7:abortedEvent[hl7:code[(@code = '495' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267') or @nullFlavor]]]/hl7:abortedEvent[hl7:code[(@code = '495' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267') or @nullFlavor]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="string(@classCode) = ('STC') or not(@classCode)">(Activiteit Contactmoment): de waarde van classCode MOET 'STC' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Activiteit Contactmoment): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:code[(@code = '495' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267') or @nullFlavor]) &gt;= 1">(Activiteit Contactmoment): element hl7:code[(@code = '495' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267') or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:code[(@code = '495' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267') or @nullFlavor]) &lt;= 1">(Activiteit Contactmoment): element hl7:code[(@code = '495' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267') or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:reasonCode[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.309')]) &gt;= 1">(Activiteit Contactmoment): element hl7:reasonCode[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.309')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:reasonCode[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.309')]) &lt;= 1">(Activiteit Contactmoment): element hl7:reasonCode[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.309')] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10020
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:subjectOf[hl7:abortedEvent[hl7:code[(@code = '495' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267') or @nullFlavor]]]/hl7:abortedEvent[hl7:code[(@code = '495' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267') or @nullFlavor]]/hl7:code[(@code = '495' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267') or @nullFlavor]
Item: (Activiteit Contactmoment)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:subjectOf[hl7:abortedEvent[hl7:code[(@code = '495' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267') or @nullFlavor]]]/hl7:abortedEvent[hl7:code[(@code = '495' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267') or @nullFlavor]]/hl7:code[(@code = '495' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267') or @nullFlavor]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Activiteit Contactmoment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="@nullFlavor or (@code='495' and @codeSystem='2.16.840.1.113883.2.4.4.40.267')">(Activiteit Contactmoment): de elementwaarde MOET een zijn van 'code '495' codeSystem '2.16.840.1.113883.2.4.4.40.267''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10020
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:subjectOf[hl7:abortedEvent[hl7:code[(@code = '495' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267') or @nullFlavor]]]/hl7:abortedEvent[hl7:code[(@code = '495' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267') or @nullFlavor]]/hl7:reasonCode[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.309')]
Item: (Activiteit Contactmoment)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:subjectOf[hl7:abortedEvent[hl7:code[(@code = '495' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267') or @nullFlavor]]]/hl7:abortedEvent[hl7:code[(@code = '495' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267') or @nullFlavor]]/hl7:reasonCode[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.309')]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Activiteit Contactmoment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="@nullFlavor or (@code='02' and @codeSystem='2.16.840.1.113883.2.4.4.40.309')">(Activiteit Contactmoment): de elementwaarde MOET een zijn van 'code '02' codeSystem '2.16.840.1.113883.2.4.4.40.309''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10020
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:subjectOf1[hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]
Item: (Activiteit Contactmoment)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:subjectOf1[hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]">
      <extends rule="d22270e0-false-d22274e0"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="string(@typeCode) = ('SUBJ') or not(@typeCode)">(Activiteit Contactmoment): de waarde van typeCode MOET 'SUBJ' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10037
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:subjectOf1[hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]
Item: (Activities subjectOf1 Conclusie)
-->
   <rule fpi="RULC-1" id="d22270e0-false-d22274e0" abstract="true">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10037-2024-11-01T000000.html"
              test="count(hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]) &gt;= 1">(Activities subjectOf1 Conclusie): element hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10037-2024-11-01T000000.html"
              test="count(hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]) &lt;= 1">(Activities subjectOf1 Conclusie): element hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10037
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:subjectOf1[hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]
Item: (Activities subjectOf1 Conclusie)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:subjectOf1[hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10037-2024-11-01T000000.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Activities subjectOf1 Conclusie): de waarde van classCode MOET 'OBS' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10037-2024-11-01T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Activities subjectOf1 Conclusie): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10037-2024-11-01T000000.html"
              test="count(hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]) &gt;= 1">(Activities subjectOf1 Conclusie): element hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10037-2024-11-01T000000.html"
              test="count(hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]) &lt;= 1">(Activities subjectOf1 Conclusie): element hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10037-2024-11-01T000000.html"
              test="count(hl7:text[not(@nullFlavor)]) &gt;= 1">(Activities subjectOf1 Conclusie): element hl7:text[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10037-2024-11-01T000000.html"
              test="count(hl7:text[not(@nullFlavor)]) &lt;= 1">(Activities subjectOf1 Conclusie): element hl7:text[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10037
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:subjectOf1[hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]
Item: (Activities subjectOf1 Conclusie)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:subjectOf1[hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10037-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Activities subjectOf1 Conclusie): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10037-2024-11-01T000000.html"
              test="@nullFlavor or (@code='482' and @codeSystem='2.16.840.1.113883.2.4.4.40.267')">(Activities subjectOf1 Conclusie): de elementwaarde MOET een zijn van 'code '482' codeSystem '2.16.840.1.113883.2.4.4.40.267''.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10037-2024-11-01T000000.html"
              test="@displayName">(Activities subjectOf1 Conclusie): attribute @displayName MOET aanwezig zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10037
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:subjectOf1[hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:text[not(@nullFlavor)]
Item: (Activities subjectOf1 Conclusie)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:subjectOf1[hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:text[not(@nullFlavor)]">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10037-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(Activities subjectOf1 Conclusie): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10020
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:subjectOf2[hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]]]
Item: (Activiteit Contactmoment)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:subjectOf2[hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="string(@typeCode) = ('SUBJ') or not(@typeCode)">(Activiteit Contactmoment): de waarde van typeCode MOET 'SUBJ' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]]) &gt;= 1">(Activiteit Contactmoment): element hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]]) &lt;= 1">(Activiteit Contactmoment): element hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10020
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:subjectOf2[hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]]]/hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]]
Item: (Activiteit Contactmoment)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:subjectOf2[hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]]]/hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]) &gt;= 1">(Activiteit Contactmoment): element hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]) &lt;= 1">(Activiteit Contactmoment): element hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')]) &gt;= 1">(Activiteit Contactmoment): element hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="count(hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')]) &lt;= 1">(Activiteit Contactmoment): element hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10020
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:subjectOf2[hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]]]/hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]]/hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]
Item: (Activiteit Contactmoment)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:subjectOf2[hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]]]/hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]]/hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Activiteit Contactmoment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="@nullFlavor or (@codeSystem='2.16.840.1.113883.2.4.4.40.267')">(Activiteit Contactmoment): de elementwaarde MOET een zijn van 'codeSystem '2.16.840.1.113883.2.4.4.40.267''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10020
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:subjectOf2[hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]]]/hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]]/hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')]
Item: (Activiteit Contactmoment)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='EVN'][not(@nullFlavor)]/hl7:subjectOf2[hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]]]/hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]]/hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')]">
      <extends rule="ST"/>
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10020-2024-11-01T000000.html"
              test="@nullFlavor or ($xsiLocalName='ST' and $xsiLocalNS='urn:hl7-org:v3')">(Activiteit Contactmoment): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10021
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]
Item: (Activiteit Contactmomentafspraak)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="string(@classCode) = ('ENC') or not(@classCode)">(Activiteit Contactmomentafspraak): de waarde van classCode MOET 'ENC' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="string(@moodCode) = ('INT')">(Activiteit Contactmomentafspraak): de waarde van moodCode MOET 'INT' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:id) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:id komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]) &gt;= 1">(Activiteit Contactmomentafspraak): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:statusCode[@code = 'active' or @code = 'cancelled']) &gt;= 1">(Activiteit Contactmomentafspraak): element hl7:statusCode[@code = 'active' or @code = 'cancelled'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:statusCode[@code = 'active' or @code = 'cancelled']) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:statusCode[@code = 'active' or @code = 'cancelled'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:effectiveTime[not(@nullFlavor)]) &gt;= 1">(Activiteit Contactmomentafspraak): element hl7:effectiveTime[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:effectiveTime[not(@nullFlavor)]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:effectiveTime[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:author) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:author komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:consultant[hl7:assignedEntity[@classCode = 'ASSIGNED']]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:consultant[hl7:assignedEntity[@classCode = 'ASSIGNED']] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:inFulfillmentOf) = 0">(Activiteit Contactmomentafspraak): element hl7:inFulfillmentOf MAG NIET voorkomen.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11018']]]) &gt;= 1">(Activiteit Contactmomentafspraak): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11018']]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11018']]]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11018']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11013']]]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11013']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11019']]]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11019']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11020']]]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11020']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11021']]]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11021']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11022']]]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11022']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11023']]]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11023']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11024']]]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11024']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11025']]]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11025']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11026']]]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11026']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11027']]]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11027']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11030']]]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11030']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11031']]]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11031']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11032']]]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11032']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11034']]]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11034']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11038']]]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11038']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11039']]]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11039']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11040']]]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11040']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11041']]]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11041']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11042']]]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11042']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11043']]]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11043']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11054']]]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11054']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11045']]]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11045']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11049']]]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11049']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:subjectOf1[hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:subjectOf1[hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10021
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:id
Item: (Activiteit Contactmomentafspraak)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:id">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Activiteit Contactmomentafspraak): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="@root and @extension">(Activiteit Contactmomentafspraak): 
                        <name path=".."/>/<name/> MOET een waarde in @root en @extension hebben.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10021
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]
Item: (Activiteit Contactmomentafspraak)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Activiteit Contactmomentafspraak): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Activiteit Contactmomentafspraak): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.100.11.2.188 W0188 Soort activiteit (HL7) (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(Activiteit Contactmomentafspraak): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst 2.16.840.1.113883.2.4.3.11.60.100.11.2.188 W0188 Soort activiteit (HL7) (DYNAMISCH).</assert>
      <report fpi="CD-DEPR-BSP"
              role="warning"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.188-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@type='D'][@code = $theCode][@codeSystem = $theCodeSystem])">(Activiteit Contactmomentafspraak): element hl7:code is gecodeerd met bindingssterkte 'required' en bevat een code die verouderd is.</report>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10021
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:statusCode[@code = 'active' or @code = 'cancelled']
Item: (Activiteit Contactmomentafspraak)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:statusCode[@code = 'active' or @code = 'cancelled']">
      <extends rule="CS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(Activiteit Contactmomentafspraak): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="@nullFlavor or (@code='active') or (@code='cancelled')">(Activiteit Contactmomentafspraak): de elementwaarde MOET een zijn van 'code 'active' of code 'cancelled''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10021
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:effectiveTime[not(@nullFlavor)]
Item: (Activiteit Contactmomentafspraak)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:effectiveTime[not(@nullFlavor)]">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(Activiteit Contactmomentafspraak): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="not(*)">(Activiteit Contactmomentafspraak): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10021
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:reasonCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.619-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.619-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]
Item: (Activiteit Contactmomentafspraak)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:reasonCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.619-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.619-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Activiteit Contactmomentafspraak): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.619-2024-11-01T000000.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Activiteit Contactmomentafspraak): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.100.11.2.619 W0619 Indicatie (HL7) (2024-11-01T00:00:00)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.619-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(Activiteit Contactmomentafspraak): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst 2.16.840.1.113883.2.4.3.11.60.100.11.2.619 W0619 Indicatie (HL7) (2024-11-01T00:00:00).</assert>
      <report fpi="CD-DEPR-BSP"
              role="warning"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.619-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept[@type='D'][@code = $theCode][@codeSystem = $theCodeSystem])">(Activiteit Contactmomentafspraak): element hl7:reasonCode is gecodeerd met bindingssterkte 'required' en bevat een code die verouderd is.</report>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10022
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]
Item: (Activities performer (uitvoerende persoon))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="string(@typeCode) = ('PRF') or not(@typeCode)">(Activities performer (uitvoerende persoon)): de waarde van typeCode MOET 'PRF' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="count(hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']) &gt;= 1">(Activities performer (uitvoerende persoon)): element hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="count(hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']) &lt;= 1">(Activities performer (uitvoerende persoon)): element hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED'] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10022
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']
Item: (Activities performer (uitvoerende persoon))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="string(@classCode) = ('ASSIGNED')">(Activities performer (uitvoerende persoon)): de waarde van classCode MOET 'ASSIGNED' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="hl7:id[@root and @extension] or hl7:assignedPerson[hl7:name[string-length()&gt;0]]">(Activities performer (uitvoerende persoon)): Als gegevens van een uitvoerende worden doorgegeven dan is een waarde voor id en/of name verplicht</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="count(hl7:id[@root = '2.16.528.1.1007.3.1'] | hl7:id[@root = '2.16.528.1.1007.5.1'] | hl7:id[@root = '2.16.840.1.113883.2.4.6.1'] | hl7:id[@nullFlavor = 'NI']) &gt;= 1">(Activities performer (uitvoerende persoon)): keuze (hl7:id[@root = '2.16.528.1.1007.3.1']  of  hl7:id[@root = '2.16.528.1.1007.5.1']  of  hl7:id[@root = '2.16.840.1.113883.2.4.6.1']  of  hl7:id[@nullFlavor = 'NI']) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="count(hl7:id[@root = '2.16.528.1.1007.3.1'] | hl7:id[@root = '2.16.528.1.1007.5.1'] | hl7:id[@root = '2.16.840.1.113883.2.4.6.1'] | hl7:id[@nullFlavor = 'NI']) &lt;= 3">(Activities performer (uitvoerende persoon)): keuze (hl7:id[@root = '2.16.528.1.1007.3.1']  of  hl7:id[@root = '2.16.528.1.1007.5.1']  of  hl7:id[@root = '2.16.840.1.113883.2.4.6.1']  of  hl7:id[@nullFlavor = 'NI']) bevat te veel elementen [max 3x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="count(hl7:id[@root = '2.16.528.1.1007.3.1']) &lt;= 1">(Activities performer (uitvoerende persoon)): element hl7:id[@root = '2.16.528.1.1007.3.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="count(hl7:id[@root = '2.16.528.1.1007.5.1']) &lt;= 1">(Activities performer (uitvoerende persoon)): element hl7:id[@root = '2.16.528.1.1007.5.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="count(hl7:id[@root = '2.16.840.1.113883.2.4.6.1']) &lt;= 1">(Activities performer (uitvoerende persoon)): element hl7:id[@root = '2.16.840.1.113883.2.4.6.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="count(hl7:id[@nullFlavor = 'NI']) &lt;= 1">(Activities performer (uitvoerende persoon)): element hl7:id[@nullFlavor = 'NI'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.686-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.686-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]) &lt;= 1">(Activities performer (uitvoerende persoon)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.686-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.686-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="count(hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']) &lt;= 1">(Activities performer (uitvoerende persoon)): element hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE'] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10022
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']/hl7:id[@root = '2.16.528.1.1007.3.1']
Item: (Activities performer (uitvoerende persoon))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']/hl7:id[@root = '2.16.528.1.1007.3.1']">
      <extends rule="II.NL.UZI"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Activities performer (uitvoerende persoon)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="string(@root) = ('2.16.528.1.1007.3.1')">(Activities performer (uitvoerende persoon)): de waarde van root MOET '2.16.528.1.1007.3.1' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10022
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']/hl7:id[@root = '2.16.528.1.1007.5.1']
Item: (Activities performer (uitvoerende persoon))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']/hl7:id[@root = '2.16.528.1.1007.5.1']">
      <extends rule="II.NL.BIG"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Activities performer (uitvoerende persoon)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="string(@root) = ('2.16.528.1.1007.5.1')">(Activities performer (uitvoerende persoon)): de waarde van root MOET '2.16.528.1.1007.5.1' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10022
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']/hl7:id[@root = '2.16.840.1.113883.2.4.6.1']
Item: (Activities performer (uitvoerende persoon))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']/hl7:id[@root = '2.16.840.1.113883.2.4.6.1']">
      <extends rule="II.NL.AGB"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Activities performer (uitvoerende persoon)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.6.1')">(Activities performer (uitvoerende persoon)): de waarde van root MOET '2.16.840.1.113883.2.4.6.1' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10022
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']/hl7:id[@nullFlavor = 'NI']
Item: (Activities performer (uitvoerende persoon))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']/hl7:id[@nullFlavor = 'NI']">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Activities performer (uitvoerende persoon)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="string(@nullFlavor) = ('NI')">(Activities performer (uitvoerende persoon)): de waarde van nullFlavor MOET 'NI' zijn. Gevonden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10022
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.686-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.686-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]
Item: (Activities performer (uitvoerende persoon))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.686-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.686-DYNAMIC.xml')//valueSet[1]/conceptList/exception/@code]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Activities performer (uitvoerende persoon)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.686-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Activities performer (uitvoerende persoon)): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.100.11.2.686 W0686 Uitvoerende activiteit discipline (HL7) (DYNAMISCH)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.686-DYNAMIC.xml')//valueSet[1]/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(Activities performer (uitvoerende persoon)): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst 2.16.840.1.113883.2.4.3.11.60.100.11.2.686 W0686 Uitvoerende activiteit discipline (HL7) (DYNAMISCH).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10022
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']/hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']
Item: (Activities performer (uitvoerende persoon))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']/hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="string(@classCode) = ('PSN')">(Activities performer (uitvoerende persoon)): de waarde van classCode MOET 'PSN' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="string(@determinerCode) = ('INSTANCE')">(Activities performer (uitvoerende persoon)): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(Activities performer (uitvoerende persoon)): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(Activities performer (uitvoerende persoon)): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10022
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']/hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:name[not(@nullFlavor)]
Item: (Activities performer (uitvoerende persoon))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:performer[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED']/hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:name[not(@nullFlavor)]">
      <extends rule="PN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10022-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PN')">(Activities performer (uitvoerende persoon)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10023
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:author
Item: (Activities encounterINT author (Verzoeker activiteit))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:author">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(Activities encounterINT author (Verzoeker activiteit)): de waarde van typeCode MOET 'AUT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="count(hl7:patient | hl7:personalRelationship[hl7:code[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.411')]] | hl7:assignedEntity1[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code]]) &gt;= 1">(Activities encounterINT author (Verzoeker activiteit)): keuze (hl7:patient  of  hl7:personalRelationship[hl7:code[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.411')]]  of  hl7:assignedEntity1[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code]]) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="count(hl7:patient | hl7:personalRelationship[hl7:code[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.411')]] | hl7:assignedEntity1[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code]]) &lt;= 1">(Activities encounterINT author (Verzoeker activiteit)): keuze (hl7:patient  of  hl7:personalRelationship[hl7:code[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.411')]]  of  hl7:assignedEntity1[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code]]) bevat te veel elementen [max 1x]</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10023
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:author/hl7:patient
Item: (Activities encounterINT author (Verzoeker activiteit))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:author/hl7:patient">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="string(@classCode) = ('PAT') or not(@classCode)">(Activities encounterINT author (Verzoeker activiteit)): de waarde van classCode MOET 'PAT' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10023
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:author/hl7:personalRelationship[hl7:code[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.411')]]
Item: (Activities encounterINT author (Verzoeker activiteit))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:author/hl7:personalRelationship[hl7:code[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.411')]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="string(@classCode) = ('PRS') or not(@classCode)">(Activities encounterINT author (Verzoeker activiteit)): de waarde van classCode MOET 'PRS' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="count(hl7:code[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.411')]) &gt;= 1">(Activities encounterINT author (Verzoeker activiteit)): element hl7:code[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.411')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="count(hl7:code[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.411')]) &lt;= 1">(Activities encounterINT author (Verzoeker activiteit)): element hl7:code[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.411')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="count(hl7:relationshipHolder[@classCode = 'PSN'][@determinerCode = 'INSTANCE'][@nullFlavor = 'NI']) &gt;= 1">(Activities encounterINT author (Verzoeker activiteit)): element hl7:relationshipHolder[@classCode = 'PSN'][@determinerCode = 'INSTANCE'][@nullFlavor = 'NI'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="count(hl7:relationshipHolder[@classCode = 'PSN'][@determinerCode = 'INSTANCE'][@nullFlavor = 'NI']) &lt;= 1">(Activities encounterINT author (Verzoeker activiteit)): element hl7:relationshipHolder[@classCode = 'PSN'][@determinerCode = 'INSTANCE'][@nullFlavor = 'NI'] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10023
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:author/hl7:personalRelationship[hl7:code[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.411')]]/hl7:code[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.411')]
Item: (Activities encounterINT author (Verzoeker activiteit))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:author/hl7:personalRelationship[hl7:code[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.411')]]/hl7:code[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.411')]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Activities encounterINT author (Verzoeker activiteit)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="@nullFlavor or (@code='02' and @codeSystem='2.16.840.1.113883.2.4.4.40.411')">(Activities encounterINT author (Verzoeker activiteit)): de elementwaarde MOET een zijn van 'code '02' codeSystem '2.16.840.1.113883.2.4.4.40.411''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10023
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:author/hl7:personalRelationship[hl7:code[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.411')]]/hl7:relationshipHolder[@classCode = 'PSN'][@determinerCode = 'INSTANCE'][@nullFlavor = 'NI']
Item: (Activities encounterINT author (Verzoeker activiteit))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:author/hl7:personalRelationship[hl7:code[(@code = '02' and @codeSystem = '2.16.840.1.113883.2.4.4.40.411')]]/hl7:relationshipHolder[@classCode = 'PSN'][@determinerCode = 'INSTANCE'][@nullFlavor = 'NI']">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="string(@classCode) = ('PSN')">(Activities encounterINT author (Verzoeker activiteit)): de waarde van classCode MOET 'PSN' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="string(@determinerCode) = ('INSTANCE')">(Activities encounterINT author (Verzoeker activiteit)): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="string(@nullFlavor) = ('NI')">(Activities encounterINT author (Verzoeker activiteit)): de waarde van nullFlavor MOET 'NI' zijn. Gevonden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10023
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:author/hl7:assignedEntity1[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code]]
Item: (Activities encounterINT author (Verzoeker activiteit))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:author/hl7:assignedEntity1[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(Activities encounterINT author (Verzoeker activiteit)): de waarde van classCode MOET 'ASSIGNED' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code]) &gt;= 1">(Activities encounterINT author (Verzoeker activiteit)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code]) &lt;= 1">(Activities encounterINT author (Verzoeker activiteit)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10023
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:author/hl7:assignedEntity1[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code]
Item: (Activities encounterINT author (Verzoeker activiteit))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:author/hl7:assignedEntity1[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Activities encounterINT author (Verzoeker activiteit)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Activities encounterINT author (Verzoeker activiteit)): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.100.11.2.659 W0659 Verzoeker activiteit (HL7) (2020-05-27T00:00:00)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.659-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound or @nullFlavor=('OTH')">(Activities encounterINT author (Verzoeker activiteit)): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst 2.16.840.1.113883.2.4.3.11.60.100.11.2.659 W0659 Verzoeker activiteit (HL7) (2020-05-27T00:00:00).</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="not(@code='02')">(Activities encounterINT author (Verzoeker activiteit)): 
                                <name path=".."/>/<name/>/@code '02' moet in element personalRelationship</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10023-2020-05-27T000000.html"
              test="not(@code='03')">(Activities encounterINT author (Verzoeker activiteit)): 
                                <name path=".."/>/<name/>/@code '03' moet in element patient</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10024
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:consultant[hl7:assignedEntity[@classCode = 'ASSIGNED']]
Item: (Activities consultant (contact met))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:consultant[hl7:assignedEntity[@classCode = 'ASSIGNED']]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10024-2020-05-27T000000.html"
              test="string(@typeCode) = ('CON') or not(@typeCode)">(Activities consultant (contact met)): de waarde van typeCode MOET 'CON' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10024-2020-05-27T000000.html"
              test="count(hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED'][hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]) &gt;= 1">(Activities consultant (contact met)): element hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED'][hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10024-2020-05-27T000000.html"
              test="count(hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED'][hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]) &lt;= 1">(Activities consultant (contact met)): element hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED'][hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10024
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:consultant[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED'][hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]
Item: (Activities consultant (contact met))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:consultant[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED'][hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10024-2020-05-27T000000.html"
              test="string(@classCode) = ('ASSIGNED')">(Activities consultant (contact met)): de waarde van classCode MOET 'ASSIGNED' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10024-2020-05-27T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.680-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.680-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code]) &lt;= 1">(Activities consultant (contact met)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.680-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.680-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10024-2020-05-27T000000.html"
              test="count(hl7:assignedPerson[not(@nullFlavor)][@classCode = 'PSN'][@determinerCode = 'INSTANCE']) &gt;= 1">(Activities consultant (contact met)): element hl7:assignedPerson[not(@nullFlavor)][@classCode = 'PSN'][@determinerCode = 'INSTANCE'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10024-2020-05-27T000000.html"
              test="count(hl7:assignedPerson[not(@nullFlavor)][@classCode = 'PSN'][@determinerCode = 'INSTANCE']) &lt;= 1">(Activities consultant (contact met)): element hl7:assignedPerson[not(@nullFlavor)][@classCode = 'PSN'][@determinerCode = 'INSTANCE'] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10024
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:consultant[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED'][hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.680-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.680-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code]
Item: (Activities consultant (contact met))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:consultant[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED'][hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.680-2020-05-27T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.680-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception/@code]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10024-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Activities consultant (contact met)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10024-2020-05-27T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.680-2020-05-27T000000.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Activities consultant (contact met)): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.100.11.2.680 W0680 Contact ivm meldcode met discipline (HL7) (2020-05-27T00:00:00)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.680-2020-05-27T000000.xml')//valueSet[1]/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10024-2020-05-27T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(Activities consultant (contact met)): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst 2.16.840.1.113883.2.4.3.11.60.100.11.2.680 W0680 Contact ivm meldcode met discipline (HL7) (2020-05-27T00:00:00).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10024
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:consultant[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED'][hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:assignedPerson[not(@nullFlavor)][@classCode = 'PSN'][@determinerCode = 'INSTANCE']
Item: (Activities consultant (contact met))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:consultant[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED'][hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:assignedPerson[not(@nullFlavor)][@classCode = 'PSN'][@determinerCode = 'INSTANCE']">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10024-2020-05-27T000000.html"
              test="string(@classCode) = ('PSN')">(Activities consultant (contact met)): de waarde van classCode MOET 'PSN' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10024-2020-05-27T000000.html"
              test="string(@determinerCode) = ('INSTANCE')">(Activities consultant (contact met)): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10024-2020-05-27T000000.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(Activities consultant (contact met)): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10024-2020-05-27T000000.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(Activities consultant (contact met)): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10024
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:consultant[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED'][hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:assignedPerson[not(@nullFlavor)][@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:name[not(@nullFlavor)]
Item: (Activities consultant (contact met))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:consultant[hl7:assignedEntity[@classCode = 'ASSIGNED']]/hl7:assignedEntity[not(@nullFlavor)][@classCode = 'ASSIGNED'][hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:assignedPerson[not(@nullFlavor)][@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:name[not(@nullFlavor)]">
      <extends rule="PN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10024-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PN')">(Activities consultant (contact met)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10025
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:escort[hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]
Item: (Activities escort (begeleider))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:escort[hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10025-2024-11-01T000000.html"
              test="string(@typeCode) = ('ESC') or not(@typeCode)">(Activities escort (begeleider)): de waarde van typeCode MOET 'ESC' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10025-2024-11-01T000000.html"
              test="count(hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]) &gt;= 1">(Activities escort (begeleider)): element hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10025-2024-11-01T000000.html"
              test="count(hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]) &lt;= 1">(Activities escort (begeleider)): element hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10025
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:escort[hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]
Item: (Activities escort (begeleider))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:escort[hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10025-2024-11-01T000000.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(Activities escort (begeleider)): de waarde van classCode MOET 'ASSIGNED' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10025-2024-11-01T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]) &gt;= 1">(Activities escort (begeleider)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10025-2024-11-01T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]) &lt;= 1">(Activities escort (begeleider)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10025-2024-11-01T000000.html"
              test="count(hl7:agentPerson[@nullFlavor = 'NI']) &gt;= 1">(Activities escort (begeleider)): element hl7:agentPerson[@nullFlavor = 'NI'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10025-2024-11-01T000000.html"
              test="count(hl7:agentPerson[@nullFlavor = 'NI']) &lt;= 1">(Activities escort (begeleider)): element hl7:agentPerson[@nullFlavor = 'NI'] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10025
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:escort[hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]
Item: (Activities escort (begeleider))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:escort[hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10025-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Activities escort (begeleider)): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10025-2024-11-01T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Activities escort (begeleider)): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.100.11.2.193 W0193 Begeleider (HL7) (2024-11-01T00:00:00)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10025-2024-11-01T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(Activities escort (begeleider)): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst 2.16.840.1.113883.2.4.3.11.60.100.11.2.193 W0193 Begeleider (HL7) (2024-11-01T00:00:00).</assert>
      <report fpi="CD-DEPR-BSP"
              role="warning"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10025-2024-11-01T000000.html"
              test="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept[@type='D'][@code = $theCode][@codeSystem = $theCodeSystem])">(Activities escort (begeleider)): element hl7:code is gecodeerd met bindingssterkte 'required' en bevat een code die verouderd is.</report>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10025
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:escort[hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:agentPerson[@nullFlavor = 'NI']
Item: (Activities escort (begeleider))
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:escort[hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]]/hl7:responsibleParty[hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.193-2024-11-01T000000.xml')//valueSet[1]/conceptList/exception/@code]]/hl7:agentPerson[@nullFlavor = 'NI']">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10025-2024-11-01T000000.html"
              test="string(@nullFlavor) = ('NI')">(Activities escort (begeleider)): de waarde van nullFlavor MOET 'NI' zijn. Gevonden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10021
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:inFulfillmentOf
Item: (Activiteit Contactmomentafspraak)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11018']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11018']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11013']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11013']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11019']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11019']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11020']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11020']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11021']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11021']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11022']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11022']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11023']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11023']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11024']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11024']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11025']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11025']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11026']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11026']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11027']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11027']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11030']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11030']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11031']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11031']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11032']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11032']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11034']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11034']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11038']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11038']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11039']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11039']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11040']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11040']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11041']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11041']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11042']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11042']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11043']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11043']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11054']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11054']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11045']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11045']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10033
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11049']]]
Item: (Activities pertinentInformation RubricCluster)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:pertinentInformation[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11049']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10033-2024-11-01T000000.html"
              test="string(@typeCode) = ('PERT') or not(@typeCode)">(Activities pertinentInformation RubricCluster): de waarde van typeCode MOET 'PERT' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10021
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:component1[hl7:nonBDSData[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10028']]]
Item: (Activiteit Contactmomentafspraak)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:component1[hl7:nonBDSData[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10028']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Activiteit Contactmomentafspraak): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10021
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:component2[hl7:metaData[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10029']]]
Item: (Activiteit Contactmomentafspraak)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:component2[hl7:metaData[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10029']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Activiteit Contactmomentafspraak): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10021
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:component3[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]
Item: (Activiteit Contactmomentafspraak)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:component3[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Activiteit Contactmomentafspraak): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10021
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:subjectOf1[hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]
Item: (Activiteit Contactmomentafspraak)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:subjectOf1[hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]">
      <extends rule="d33240e0-false-d33244e0"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="string(@typeCode) = ('SUBJ') or not(@typeCode)">(Activiteit Contactmomentafspraak): de waarde van typeCode MOET 'SUBJ' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10037
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:subjectOf1[hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]
Item: (Activities subjectOf1 Conclusie)
-->
   <rule fpi="RULC-1" id="d33240e0-false-d33244e0" abstract="true">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10037-2024-11-01T000000.html"
              test="count(hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]) &gt;= 1">(Activities subjectOf1 Conclusie): element hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10037-2024-11-01T000000.html"
              test="count(hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]) &lt;= 1">(Activities subjectOf1 Conclusie): element hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10037
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:subjectOf1[hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]
Item: (Activities subjectOf1 Conclusie)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:subjectOf1[hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10037-2024-11-01T000000.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Activities subjectOf1 Conclusie): de waarde van classCode MOET 'OBS' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10037-2024-11-01T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Activities subjectOf1 Conclusie): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10037-2024-11-01T000000.html"
              test="count(hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]) &gt;= 1">(Activities subjectOf1 Conclusie): element hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10037-2024-11-01T000000.html"
              test="count(hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]) &lt;= 1">(Activities subjectOf1 Conclusie): element hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10037-2024-11-01T000000.html"
              test="count(hl7:text[not(@nullFlavor)]) &gt;= 1">(Activities subjectOf1 Conclusie): element hl7:text[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10037-2024-11-01T000000.html"
              test="count(hl7:text[not(@nullFlavor)]) &lt;= 1">(Activities subjectOf1 Conclusie): element hl7:text[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10037
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:subjectOf1[hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]
Item: (Activities subjectOf1 Conclusie)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:subjectOf1[hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10037-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Activities subjectOf1 Conclusie): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10037-2024-11-01T000000.html"
              test="@nullFlavor or (@code='482' and @codeSystem='2.16.840.1.113883.2.4.4.40.267')">(Activities subjectOf1 Conclusie): de elementwaarde MOET een zijn van 'code '482' codeSystem '2.16.840.1.113883.2.4.4.40.267''.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10037-2024-11-01T000000.html"
              test="@displayName">(Activities subjectOf1 Conclusie): attribute @displayName MOET aanwezig zijn.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10037
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:subjectOf1[hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:text[not(@nullFlavor)]
Item: (Activities subjectOf1 Conclusie)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:subjectOf1[hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:conclusion[hl7:code[(@code = '482' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:text[not(@nullFlavor)]">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10037-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(Activities subjectOf1 Conclusie): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10021
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:subjectOf2[hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]]]
Item: (Activiteit Contactmomentafspraak)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:subjectOf2[hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="string(@typeCode) = ('SUBJ') or not(@typeCode)">(Activiteit Contactmomentafspraak): de waarde van typeCode MOET 'SUBJ' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]]) &gt;= 1">(Activiteit Contactmomentafspraak): element hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10021
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:subjectOf2[hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]]]/hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]]
Item: (Activiteit Contactmomentafspraak)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:subjectOf2[hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]]]/hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]) &gt;= 1">(Activiteit Contactmomentafspraak): element hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')]) &gt;= 1">(Activiteit Contactmomentafspraak): element hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="count(hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')]) &lt;= 1">(Activiteit Contactmomentafspraak): element hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10021
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:subjectOf2[hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]]]/hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]]/hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]
Item: (Activiteit Contactmomentafspraak)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:subjectOf2[hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]]]/hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]]/hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Activiteit Contactmomentafspraak): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="@nullFlavor or (@codeSystem='2.16.840.1.113883.2.4.4.40.267')">(Activiteit Contactmomentafspraak): de elementwaarde MOET een zijn van 'codeSystem '2.16.840.1.113883.2.4.4.40.267''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10021
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:subjectOf2[hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]]]/hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]]/hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')]
Item: (Activiteit Contactmomentafspraak)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:component7/hl7:encounter[@moodCode='INT'][not(@nullFlavor)]/hl7:subjectOf2[hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]]]/hl7:annotation[hl7:code[@codeSystem = '2.16.840.1.113883.2.4.4.40.267' or @nullFlavor]]/hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')]">
      <extends rule="ST"/>
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10021-2024-11-01T000000.html"
              test="@nullFlavor or ($xsiLocalName='ST' and $xsiLocalNS='urn:hl7-org:v3')">(Activiteit Contactmomentafspraak): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10019
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:subjectOf
Item: (Care Provision Event subjectOf CareStatus)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:subjectOf">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="string(@typeCode) = ('SUBJ') or not(@typeCode)">(Care Provision Event subjectOf CareStatus): de waarde van typeCode MOET 'SUBJ' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="string(@contextConductionInd) = ('false') or not(@contextConductionInd)">(Care Provision Event subjectOf CareStatus): de waarde van contextConductionInd MOET 'false' zijn. Gevonden: "<value-of select="@contextConductionInd"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="count(hl7:careStatus[hl7:code[@code = '1197'][@codeSystem = '2.16.840.1.113883.2.4.4.40.267']][not(@nullFlavor)] | hl7:careStatus[hl7:code[@code = '487'][@codeSystem = '2.16.840.1.113883.2.4.4.40.267']][not(@nullFlavor)]) &gt;= 1">(Care Provision Event subjectOf CareStatus): keuze (hl7:careStatus[hl7:code[@code = '1197'][@codeSystem = '2.16.840.1.113883.2.4.4.40.267']][not(@nullFlavor)]  of  hl7:careStatus[hl7:code[@code = '487'][@codeSystem = '2.16.840.1.113883.2.4.4.40.267']][not(@nullFlavor)]) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="count(hl7:careStatus[hl7:code[@code = '1197'][@codeSystem = '2.16.840.1.113883.2.4.4.40.267']][not(@nullFlavor)] | hl7:careStatus[hl7:code[@code = '487'][@codeSystem = '2.16.840.1.113883.2.4.4.40.267']][not(@nullFlavor)]) &lt;= 1">(Care Provision Event subjectOf CareStatus): keuze (hl7:careStatus[hl7:code[@code = '1197'][@codeSystem = '2.16.840.1.113883.2.4.4.40.267']][not(@nullFlavor)]  of  hl7:careStatus[hl7:code[@code = '487'][@codeSystem = '2.16.840.1.113883.2.4.4.40.267']][not(@nullFlavor)]) bevat te veel elementen [max 1x]</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10019
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:subjectOf/hl7:careStatus[hl7:code[@code = '1197'][@codeSystem = '2.16.840.1.113883.2.4.4.40.267']][not(@nullFlavor)]
Item: (Care Provision Event subjectOf CareStatus)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:subjectOf/hl7:careStatus[hl7:code[@code = '1197'][@codeSystem = '2.16.840.1.113883.2.4.4.40.267']][not(@nullFlavor)]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="string(@classCode) = ('STC') or not(@classCode)">(Care Provision Event subjectOf CareStatus): de waarde van classCode MOET 'STC' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Care Provision Event subjectOf CareStatus): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="count(hl7:code[(@code = '1197' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]) &gt;= 1">(Care Provision Event subjectOf CareStatus): element hl7:code[(@code = '1197' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="count(hl7:code[(@code = '1197' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]) &lt;= 1">(Care Provision Event subjectOf CareStatus): element hl7:code[(@code = '1197' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="count(hl7:effectiveTime[not(@nullFlavor)]) &gt;= 1">(Care Provision Event subjectOf CareStatus): element hl7:effectiveTime[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="count(hl7:effectiveTime[not(@nullFlavor)]) &lt;= 1">(Care Provision Event subjectOf CareStatus): element hl7:effectiveTime[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="count(hl7:reasonCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.625-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(Care Provision Event subjectOf CareStatus): element hl7:reasonCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.625-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="count(hl7:reasonCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.625-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(Care Provision Event subjectOf CareStatus): element hl7:reasonCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.625-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10019
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:subjectOf/hl7:careStatus[hl7:code[@code = '1197'][@codeSystem = '2.16.840.1.113883.2.4.4.40.267']][not(@nullFlavor)]/hl7:code[(@code = '1197' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]
Item: (Care Provision Event subjectOf CareStatus)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:subjectOf/hl7:careStatus[hl7:code[@code = '1197'][@codeSystem = '2.16.840.1.113883.2.4.4.40.267']][not(@nullFlavor)]/hl7:code[(@code = '1197' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Care Provision Event subjectOf CareStatus): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="@nullFlavor or (@code='1197' and @codeSystem='2.16.840.1.113883.2.4.4.40.267')">(Care Provision Event subjectOf CareStatus): de elementwaarde MOET een zijn van 'code '1197' codeSystem '2.16.840.1.113883.2.4.4.40.267''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10019
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:subjectOf/hl7:careStatus[hl7:code[@code = '1197'][@codeSystem = '2.16.840.1.113883.2.4.4.40.267']][not(@nullFlavor)]/hl7:effectiveTime[not(@nullFlavor)]
Item: (Care Provision Event subjectOf CareStatus)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:subjectOf/hl7:careStatus[hl7:code[@code = '1197'][@codeSystem = '2.16.840.1.113883.2.4.4.40.267']][not(@nullFlavor)]/hl7:effectiveTime[not(@nullFlavor)]">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(Care Provision Event subjectOf CareStatus): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="not(*)">(Care Provision Event subjectOf CareStatus): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10019
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:subjectOf/hl7:careStatus[hl7:code[@code = '1197'][@codeSystem = '2.16.840.1.113883.2.4.4.40.267']][not(@nullFlavor)]/hl7:reasonCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.625-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (Care Provision Event subjectOf CareStatus)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:subjectOf/hl7:careStatus[hl7:code[@code = '1197'][@codeSystem = '2.16.840.1.113883.2.4.4.40.267']][not(@nullFlavor)]/hl7:reasonCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.625-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Care Provision Event subjectOf CareStatus): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.625-2012-05-21T012654.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Care Provision Event subjectOf CareStatus): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.100.11.2.625 W0625 Status in zorg (HL7) (2012-05-21T01:26:54)'.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="not(@nullFlavor) or @nullFlavor=('UNK')">(Care Provision Event subjectOf CareStatus): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst 2.16.840.1.113883.2.4.3.11.60.100.11.2.625 W0625 Status in zorg (HL7) (2012-05-21T01:26:54).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10019
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:subjectOf/hl7:careStatus[hl7:code[@code = '487'][@codeSystem = '2.16.840.1.113883.2.4.4.40.267']][not(@nullFlavor)]
Item: (Care Provision Event subjectOf CareStatus)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:subjectOf/hl7:careStatus[hl7:code[@code = '487'][@codeSystem = '2.16.840.1.113883.2.4.4.40.267']][not(@nullFlavor)]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="string(@classCode) = ('STC') or not(@classCode)">(Care Provision Event subjectOf CareStatus): de waarde van classCode MOET 'STC' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Care Provision Event subjectOf CareStatus): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="count(hl7:code[(@code = '487' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]) &gt;= 1">(Care Provision Event subjectOf CareStatus): element hl7:code[(@code = '487' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="count(hl7:code[(@code = '487' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]) &lt;= 1">(Care Provision Event subjectOf CareStatus): element hl7:code[(@code = '487' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="count(hl7:effectiveTime[not(@nullFlavor)]) &gt;= 1">(Care Provision Event subjectOf CareStatus): element hl7:effectiveTime[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="count(hl7:effectiveTime[not(@nullFlavor)]) &lt;= 1">(Care Provision Event subjectOf CareStatus): element hl7:effectiveTime[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="count(hl7:reasonCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.626-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(Care Provision Event subjectOf CareStatus): element hl7:reasonCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.626-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="count(hl7:reasonCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.626-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(Care Provision Event subjectOf CareStatus): element hl7:reasonCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.626-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10019
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:subjectOf/hl7:careStatus[hl7:code[@code = '487'][@codeSystem = '2.16.840.1.113883.2.4.4.40.267']][not(@nullFlavor)]/hl7:code[(@code = '487' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]
Item: (Care Provision Event subjectOf CareStatus)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:subjectOf/hl7:careStatus[hl7:code[@code = '487'][@codeSystem = '2.16.840.1.113883.2.4.4.40.267']][not(@nullFlavor)]/hl7:code[(@code = '487' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Care Provision Event subjectOf CareStatus): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="@nullFlavor or (@code='487' and @codeSystem='2.16.840.1.113883.2.4.4.40.267')">(Care Provision Event subjectOf CareStatus): de elementwaarde MOET een zijn van 'code '487' codeSystem '2.16.840.1.113883.2.4.4.40.267''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10019
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:subjectOf/hl7:careStatus[hl7:code[@code = '487'][@codeSystem = '2.16.840.1.113883.2.4.4.40.267']][not(@nullFlavor)]/hl7:effectiveTime[not(@nullFlavor)]
Item: (Care Provision Event subjectOf CareStatus)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:subjectOf/hl7:careStatus[hl7:code[@code = '487'][@codeSystem = '2.16.840.1.113883.2.4.4.40.267']][not(@nullFlavor)]/hl7:effectiveTime[not(@nullFlavor)]">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(Care Provision Event subjectOf CareStatus): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="not(*)">(Care Provision Event subjectOf CareStatus): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10019
Context: *[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:subjectOf/hl7:careStatus[hl7:code[@code = '487'][@codeSystem = '2.16.840.1.113883.2.4.4.40.267']][not(@nullFlavor)]/hl7:reasonCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.626-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (Care Provision Event subjectOf CareStatus)
-->
   <rule fpi="RULC-1"
         context="*[hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]]/hl7:CareProvisionRequest[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.10000']]/hl7:sequelTo[hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:careProvisionEvent[hl7:code[(@code = 'CPHC' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:subjectOf/hl7:careStatus[hl7:code[@code = '487'][@codeSystem = '2.16.840.1.113883.2.4.4.40.267']][not(@nullFlavor)]/hl7:reasonCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.626-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Care Provision Event subjectOf CareStatus): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.626-2012-05-21T012654.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Care Provision Event subjectOf CareStatus): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.100.11.2.626 W0626 Zorgbeëindiging (HL7) (2012-05-21T01:26:54)'.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10019-2020-05-27T000000.html"
              test="not(@nullFlavor) or @nullFlavor=('UNK')">(Care Provision Event subjectOf CareStatus): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst 2.16.840.1.113883.2.4.3.11.60.100.11.2.626 W0626 Zorgbeëindiging (HL7) (2012-05-21T01:26:54).</assert>
   </rule>
</pattern>
