<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.6.10.100.116
Name: A_Rijksvaccinatie [universal]
Description: COCT_RM900916NL04: Gegevens van rijksvaccinaties en andere vaccinaties. Verschillen met de voorgaande versie zijn:  
                     
                     InformationControlActEvent.performer is nu CMET AssignedPerson zodat naam, functie, organisatie kunnen worden ondersteund 
                     substanceAdministration.medication.administrableMedicine.code bevat nu een verduidelijking voor het gebruik van de nullFlavor 'OTH' 
                     substanceAdministration.performer is niet meer verplicht om buitenlandse vaccinaties, waarvan de uitvoerende organisatie/persoon kan ontbreken, te ondersteunen 
                     substanceAdministration.authorization is uitgebreid met conformance 'R' (required) 
                     substanceAdministration.authorization.consentEvent.reasonOf heeft nu een maximum van 1 en conformance 'C' (conditioneel), zodat er maximaal 1 bezwaar gekoppeld kan worden per vaccinatie 
                     substanceAdministration.component bevat een aan
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000">
   <title>A_Rijksvaccinatie [universal]</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]
Item: (A_Rijksvaccinatie [universal])
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]"
         id="d45e12580-false-d302098e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@classCode) = ('SBADM') or not(@classCode)">(A_Rijksvaccinatie [universal]): de waarde van classCode MOET 'SBADM' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(A_Rijksvaccinatie [universal]): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="not(@negationInd) or string(@negationInd)=('true','false')">(A_Rijksvaccinatie [universal]): attribuut @negationInd MOET datatype 'bl' hebben  - '<value-of select="@negationInd"/>'</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="not(@negationInd='true') or hl7:authorization">(A_Rijksvaccinatie [universal]): als <name/>/@negationInd 'true' is, dan MOET er bezwaar zijn in authorization</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="@negationInd='true' or not(hl7:authorization)">(A_Rijksvaccinatie [universal]): als <name/>/@negationInd 'false' is of afwezig, dan MAG er GEEN er bezwaar zijn in authorization</assert>
      <report role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="@moodCode='RMD' and ancestor::hl7:CareProvisionRequest">(A_Rijksvaccinatie [universal]): 
                    <name/>/@moodCode='RMD' is een te-verwachten-vaccinatie. Deze worden opgeleverd door het RIVM en horen niet in dossieroverdracht.</report>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="not(.//hl7:lotNumberText and hl7:authorization)">(A_Rijksvaccinatie [universal]): lotNumberText KAN GEEN waarde bevatten, als er sprake is van bezwaar</assert>
      <assert role="warning"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test=".//hl7:lotNumberText or hl7:authorization">(A_Rijksvaccinatie [universal]): lotNumberText bevat geen waarde, terwijl er geen sprake van bezwaar is</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']) &gt;= 1">(A_Rijksvaccinatie [universal]): element hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]) &gt;= 1">(A_Rijksvaccinatie [universal]): element hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:effectiveTime[not(@nullFlavor)]) &gt;= 1">(A_Rijksvaccinatie [universal]): element hl7:effectiveTime[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:effectiveTime[not(@nullFlavor)]) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:effectiveTime[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:consumable[not(@nullFlavor)][hl7:medication]) &gt;= 1">(A_Rijksvaccinatie [universal]): element hl7:consumable[not(@nullFlavor)][hl7:medication] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:consumable[not(@nullFlavor)][hl7:medication]) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:consumable[not(@nullFlavor)][hl7:medication] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:performer[hl7:assignedEntity[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.124']]]) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:performer[hl7:assignedEntity[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.124']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:reason[hl7:vaccinationReason[hl7:code[(@code = '686' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:reason[hl7:vaccinationReason[hl7:code[(@code = '686' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '608' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '608' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '872' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '872' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '1589' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '1589' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']"
         id="d45e12742-false-d302213e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(A_Rijksvaccinatie [universal]): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.6.10.100.116')">(A_Rijksvaccinatie [universal]): de waarde van root MOET '2.16.840.1.113883.2.4.6.10.100.116' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]"
         id="d45e12752-false-d302228e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(A_Rijksvaccinatie [universal]): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="@nullFlavor or (@code='IMMUNIZ' and @codeSystem='2.16.840.1.113883.5.4')">(A_Rijksvaccinatie [universal]): de elementwaarde MOET een zijn van 'code 'IMMUNIZ' codeSystem '2.16.840.1.113883.5.4''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:effectiveTime[not(@nullFlavor)]
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:effectiveTime[not(@nullFlavor)]"
         id="d45e12763-false-d302244e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(A_Rijksvaccinatie [universal]): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="not(*)">(A_Rijksvaccinatie [universal]): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="matches(@value,'^[0-9]{8}')">(A_Rijksvaccinatie [universal]): 
                        <name path=".."/>/<name/> moet tenminste tot op de dag nauwkeurig worden opgegeven</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:consumable[not(@nullFlavor)][hl7:medication]
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:consumable[not(@nullFlavor)][hl7:medication]"
         id="d45e12783-false-d302257e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@typeCode) = ('CSM') or not(@typeCode)">(A_Rijksvaccinatie [universal]): de waarde van typeCode MOET 'CSM' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:medication[not(@nullFlavor)][hl7:administrableMedicine]) &gt;= 1">(A_Rijksvaccinatie [universal]): element hl7:medication[not(@nullFlavor)][hl7:administrableMedicine] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:medication[not(@nullFlavor)][hl7:administrableMedicine]) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:medication[not(@nullFlavor)][hl7:administrableMedicine] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:consumable[not(@nullFlavor)][hl7:medication]/hl7:medication[not(@nullFlavor)][hl7:administrableMedicine]
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:consumable[not(@nullFlavor)][hl7:medication]/hl7:medication[not(@nullFlavor)][hl7:administrableMedicine]"
         id="d45e12803-false-d302277e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@classCode) = ('ADMM') or not(@classCode)">(A_Rijksvaccinatie [universal]): de waarde van classCode MOET 'ADMM' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:administrableMedicine[hl7:code[@nullFlavor or @codeSystem='2.16.840.1.113883.2.4.4.40.76']]) &gt;= 1">(A_Rijksvaccinatie [universal]): element hl7:administrableMedicine[hl7:code[@nullFlavor or @codeSystem='2.16.840.1.113883.2.4.4.40.76']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:administrableMedicine[hl7:code[@nullFlavor or @codeSystem='2.16.840.1.113883.2.4.4.40.76']]) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:administrableMedicine[hl7:code[@nullFlavor or @codeSystem='2.16.840.1.113883.2.4.4.40.76']] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:consumable[not(@nullFlavor)][hl7:medication]/hl7:medication[not(@nullFlavor)][hl7:administrableMedicine]/hl7:administrableMedicine[hl7:code[@nullFlavor or @codeSystem='2.16.840.1.113883.2.4.4.40.76']]
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:consumable[not(@nullFlavor)][hl7:medication]/hl7:medication[not(@nullFlavor)][hl7:administrableMedicine]/hl7:administrableMedicine[hl7:code[@nullFlavor or @codeSystem='2.16.840.1.113883.2.4.4.40.76']]"
         id="d45e12809-false-d302299e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@classCode) = ('MMAT') or not(@classCode)">(A_Rijksvaccinatie [universal]): de waarde van classCode MOET 'MMAT' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@determinerCode) = ('KIND') or not(@determinerCode)">(A_Rijksvaccinatie [universal]): de waarde van determinerCode MOET 'KIND' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:code[@nullFlavor or @codeSystem='2.16.840.1.113883.2.4.4.40.76']) &gt;= 1">(A_Rijksvaccinatie [universal]): element hl7:code[@nullFlavor or @codeSystem='2.16.840.1.113883.2.4.4.40.76'] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:code[@nullFlavor or @codeSystem='2.16.840.1.113883.2.4.4.40.76']) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:code[@nullFlavor or @codeSystem='2.16.840.1.113883.2.4.4.40.76'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:lotNumberText) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:lotNumberText komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:consumable[not(@nullFlavor)][hl7:medication]/hl7:medication[not(@nullFlavor)][hl7:administrableMedicine]/hl7:administrableMedicine[hl7:code[@nullFlavor or @codeSystem='2.16.840.1.113883.2.4.4.40.76']]/hl7:code[@nullFlavor or @codeSystem='2.16.840.1.113883.2.4.4.40.76']
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:consumable[not(@nullFlavor)][hl7:medication]/hl7:medication[not(@nullFlavor)][hl7:administrableMedicine]/hl7:administrableMedicine[hl7:code[@nullFlavor or @codeSystem='2.16.840.1.113883.2.4.4.40.76']]/hl7:code[@nullFlavor or @codeSystem='2.16.840.1.113883.2.4.4.40.76']"
         id="d45e12817-false-d302325e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(A_Rijksvaccinatie [universal]): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.422-2016-12-09T000000.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(A_Rijksvaccinatie [universal]): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.100.11.2.422 W0422 Soort vaccinatie (HL7) (2016-12-09T00:00:00)'.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="(@code and @displayName) or (@nullFlavor and hl7:originalText)">(A_Rijksvaccinatie [universal]): 
                                    <name/> MOET @code en @displayName bevatten OF @nullFlavor en originalText</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:consumable[not(@nullFlavor)][hl7:medication]/hl7:medication[not(@nullFlavor)][hl7:administrableMedicine]/hl7:administrableMedicine[hl7:code[@nullFlavor or @codeSystem='2.16.840.1.113883.2.4.4.40.76']]/hl7:lotNumberText
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:consumable[not(@nullFlavor)][hl7:medication]/hl7:medication[not(@nullFlavor)][hl7:administrableMedicine]/hl7:administrableMedicine[hl7:code[@nullFlavor or @codeSystem='2.16.840.1.113883.2.4.4.40.76']]/hl7:lotNumberText"
         id="d45e12844-false-d302343e0">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(A_Rijksvaccinatie [universal]): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@nullFlavor) = ('NI') or not(@nullFlavor)">(A_Rijksvaccinatie [universal]): de waarde van nullFlavor MOET 'NI' zijn. Gevonden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:performer[hl7:assignedEntity[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.124']]]
Item: (A_Rijksvaccinatie [universal])
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:performer[hl7:assignedEntity[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.124']]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@typeCode) = ('PRF') or not(@typeCode)">(A_Rijksvaccinatie [universal]): de waarde van typeCode MOET 'PRF' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:reason[hl7:vaccinationReason[hl7:code[(@code = '686' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:reason[hl7:vaccinationReason[hl7:code[(@code = '686' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]"
         id="d45e12886-false-d302376e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@typeCode) = ('RSON') or not(@typeCode)">(A_Rijksvaccinatie [universal]): de waarde van typeCode MOET 'RSON' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:vaccinationReason[hl7:code[(@code = '686' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]) &gt;= 1">(A_Rijksvaccinatie [universal]): element hl7:vaccinationReason[hl7:code[(@code = '686' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:vaccinationReason[hl7:code[(@code = '686' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:vaccinationReason[hl7:code[(@code = '686' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:reason[hl7:vaccinationReason[hl7:code[(@code = '686' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:vaccinationReason[hl7:code[(@code = '686' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:reason[hl7:vaccinationReason[hl7:code[(@code = '686' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:vaccinationReason[hl7:code[(@code = '686' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]"
         id="d45e12895-false-d302398e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(A_Rijksvaccinatie [universal]): de waarde van classCode MOET 'OBS' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(A_Rijksvaccinatie [universal]): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:code[(@code = '686' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]) &gt;= 1">(A_Rijksvaccinatie [universal]): element hl7:code[(@code = '686' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:code[(@code = '686' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:code[(@code = '686' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.417-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.417-2012-05-21T012654.xml')//valueSet[1]/conceptList/exception/@code]) &gt;= 1">(A_Rijksvaccinatie [universal]): element hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.417-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.417-2012-05-21T012654.xml')//valueSet[1]/conceptList/exception/@code] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.417-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.417-2012-05-21T012654.xml')//valueSet[1]/conceptList/exception/@code]) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.417-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.417-2012-05-21T012654.xml')//valueSet[1]/conceptList/exception/@code] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:reason[hl7:vaccinationReason[hl7:code[(@code = '686' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:vaccinationReason[hl7:code[(@code = '686' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:code[(@code = '686' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:reason[hl7:vaccinationReason[hl7:code[(@code = '686' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:vaccinationReason[hl7:code[(@code = '686' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:code[(@code = '686' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]"
         id="d45e12906-false-d302435e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(A_Rijksvaccinatie [universal]): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="@nullFlavor or (@code='686' and @codeSystem='2.16.840.1.113883.2.4.4.40.267')">(A_Rijksvaccinatie [universal]): de elementwaarde MOET een zijn van 'code '686' codeSystem '2.16.840.1.113883.2.4.4.40.267''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:reason[hl7:vaccinationReason[hl7:code[(@code = '686' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:vaccinationReason[hl7:code[(@code = '686' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.417-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.417-2012-05-21T012654.xml')//valueSet[1]/conceptList/exception/@code]
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:reason[hl7:vaccinationReason[hl7:code[(@code = '686' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:vaccinationReason[hl7:code[(@code = '686' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.417-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.417-2012-05-21T012654.xml')//valueSet[1]/conceptList/exception/@code]"
         id="d45e12917-false-d302454e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(A_Rijksvaccinatie [universal]): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.417-2012-05-21T012654.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(A_Rijksvaccinatie [universal]): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.100.11.2.417 W0417 Reden van enting (HL7) (2012-05-21T01:26:54)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.417-2012-05-21T012654.xml')//valueSet[1]/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(A_Rijksvaccinatie [universal]): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst 2.16.840.1.113883.2.4.3.11.60.100.11.2.417 W0417 Reden van enting (HL7) (2012-05-21T01:26:54).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]"
         id="d45e12933-false-d302478e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@typeCode) = ('CAUS') or not(@typeCode)">(A_Rijksvaccinatie [universal]): de waarde van typeCode MOET 'CAUS' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]) &gt;= 1">(A_Rijksvaccinatie [universal]): element hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]"
         id="d45e12942-false-d302506e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(A_Rijksvaccinatie [universal]): de waarde van classCode MOET 'OBS' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(A_Rijksvaccinatie [universal]): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]) &gt;= 1">(A_Rijksvaccinatie [universal]): element hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:value) &gt;= 1">(A_Rijksvaccinatie [universal]): element hl7:value is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:value) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:value komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:subjectOf[hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:subjectOf[hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]"
         id="d45e12953-false-d302560e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(A_Rijksvaccinatie [universal]): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="@nullFlavor or (@code='874' and @codeSystem='2.16.840.1.113883.2.4.4.40.267')">(A_Rijksvaccinatie [universal]): de elementwaarde MOET een zijn van 'code '874' codeSystem '2.16.840.1.113883.2.4.4.40.267''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10266
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:effectiveTime
Item: (Periode reactie)
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:effectiveTime"
         id="d302561e15-false-d302577e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10266-2012-08-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(Periode reactie): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:IVL_TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10266-2012-08-01T000000.html"
              test="count(hl7:low | hl7:high) &gt;= 1">(Periode reactie): keuze (hl7:low  of  hl7:high) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10266-2012-08-01T000000.html"
              test="count(hl7:low | hl7:high) &lt;= 2">(Periode reactie): keuze (hl7:low  of  hl7:high) bevat te veel elementen [max 2x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10266-2012-08-01T000000.html"
              test="count(hl7:low) &lt;= 1">(Periode reactie): element hl7:low komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10266-2012-08-01T000000.html"
              test="count(hl7:high) &lt;= 1">(Periode reactie): element hl7:high komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10266-2012-08-01T000000.html"
              test="count(hl7:width) = 0">(Periode reactie): element hl7:width MAG NIET voorkomen.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10266-2012-08-01T000000.html"
              test="count(hl7:center) = 0">(Periode reactie): element hl7:center MAG NIET voorkomen.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10266
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:effectiveTime/hl7:low
Item: (Periode reactie)
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:effectiveTime/hl7:low"
         id="d302561e56-false-d302624e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10266-2012-08-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(Periode reactie): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10266-2012-08-01T000000.html"
              test="not(*)">(Periode reactie): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10266-2012-08-01T000000.html"
              test="string(@nullFlavor) = ('UNK') or not(@nullFlavor)">(Periode reactie): de waarde van nullFlavor MOET 'UNK' zijn. Gevonden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10266
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:effectiveTime/hl7:high
Item: (Periode reactie)
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:effectiveTime/hl7:high"
         id="d302561e75-false-d302641e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10266-2012-08-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(Periode reactie): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10266-2012-08-01T000000.html"
              test="not(*)">(Periode reactie): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.10266-2012-08-01T000000.html"
              test="string(@nullFlavor) = ('UNK') or not(@nullFlavor)">(Periode reactie): de waarde van nullFlavor MOET 'UNK' zijn. Gevonden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10266
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:effectiveTime/hl7:width
Item: (Periode reactie)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.10266
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:effectiveTime/hl7:center
Item: (Periode reactie)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:value
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:value"
         id="d45e12968-false-d302674e0">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(A_Rijksvaccinatie [universal]): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:subjectOf[hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:subjectOf[hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]"
         id="d45e12976-false-d302685e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@typeCode) = ('SUBJ') or not(@typeCode)">(A_Rijksvaccinatie [universal]): de waarde van typeCode MOET 'SUBJ' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]) &gt;= 1">(A_Rijksvaccinatie [universal]): element hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:subjectOf[hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:subjectOf[hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]"
         id="d45e12985-false-d302707e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@classCode) = ('INFO') or not(@classCode)">(A_Rijksvaccinatie [universal]): de waarde van classCode MOET 'INFO' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(A_Rijksvaccinatie [universal]): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]) &gt;= 1">(A_Rijksvaccinatie [universal]): element hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:performer[@typeCode = 'PRF'][hl7:assignedPerson]) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:performer[@typeCode = 'PRF'][hl7:assignedPerson] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:subjectOf[hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:subjectOf[hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]"
         id="d45e12996-false-d302745e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(A_Rijksvaccinatie [universal]): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="@nullFlavor or (@code='875' and @codeSystem='2.16.840.1.113883.2.4.4.40.267')">(A_Rijksvaccinatie [universal]): de elementwaarde MOET een zijn van 'code '875' codeSystem '2.16.840.1.113883.2.4.4.40.267''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:subjectOf[hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:effectiveTime
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:subjectOf[hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:effectiveTime"
         id="d45e13007-false-d302761e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(A_Rijksvaccinatie [universal]): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="not(*)">(A_Rijksvaccinatie [universal]): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:subjectOf[hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:performer[@typeCode = 'PRF'][hl7:assignedPerson]
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:subjectOf[hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:performer[@typeCode = 'PRF'][hl7:assignedPerson]"
         id="d45e13015-false-d302774e0">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(A_Rijksvaccinatie [universal]): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@typeCode) = ('PRF')">(A_Rijksvaccinatie [universal]): de waarde van typeCode MOET 'PRF' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:assignedPerson[not(@nullFlavor)]) &gt;= 1">(A_Rijksvaccinatie [universal]): element hl7:assignedPerson[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:assignedPerson[not(@nullFlavor)]) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:assignedPerson[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:subjectOf[hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:performer[@typeCode = 'PRF'][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:subjectOf[hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:performer[@typeCode = 'PRF'][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]"
         id="d45e13024-false-d302797e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:id[@root = '2.16.528.1.1007.3.1'] | hl7:id[@root = '2.16.528.1.1007.5.1'] | hl7:id[@root = '2.16.840.1.113883.2.4.6.1'] | hl7:id[@nullFlavor = 'NI']) &gt;= 1">(A_Rijksvaccinatie [universal]): keuze (hl7:id[@root = '2.16.528.1.1007.3.1']  of  hl7:id[@root = '2.16.528.1.1007.5.1']  of  hl7:id[@root = '2.16.840.1.113883.2.4.6.1']  of  hl7:id[@nullFlavor = 'NI']) bevat te weinig elementen [min 1x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:id[@root = '2.16.528.1.1007.3.1'] | hl7:id[@root = '2.16.528.1.1007.5.1'] | hl7:id[@root = '2.16.840.1.113883.2.4.6.1'] | hl7:id[@nullFlavor = 'NI']) &lt;= 3">(A_Rijksvaccinatie [universal]): keuze (hl7:id[@root = '2.16.528.1.1007.3.1']  of  hl7:id[@root = '2.16.528.1.1007.5.1']  of  hl7:id[@root = '2.16.840.1.113883.2.4.6.1']  of  hl7:id[@nullFlavor = 'NI']) bevat te veel elementen [max 3x]</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:id[@root = '2.16.528.1.1007.3.1']) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:id[@root = '2.16.528.1.1007.3.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:id[@root = '2.16.528.1.1007.5.1']) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:id[@root = '2.16.528.1.1007.5.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:id[@root = '2.16.840.1.113883.2.4.6.1']) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:id[@root = '2.16.840.1.113883.2.4.6.1'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:id[@nullFlavor = 'NI']) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:id[@nullFlavor = 'NI'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE'] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:subjectOf[hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:performer[@typeCode = 'PRF'][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]/hl7:id[@root = '2.16.528.1.1007.3.1']
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:subjectOf[hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:performer[@typeCode = 'PRF'][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]/hl7:id[@root = '2.16.528.1.1007.3.1']"
         id="d45e13036-false-d302856e0">
      <extends rule="II.NL.UZI"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(A_Rijksvaccinatie [universal]): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@root) = ('2.16.528.1.1007.3.1')">(A_Rijksvaccinatie [universal]): de waarde van root MOET '2.16.528.1.1007.3.1' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:subjectOf[hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:performer[@typeCode = 'PRF'][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]/hl7:id[@root = '2.16.528.1.1007.5.1']
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:subjectOf[hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:performer[@typeCode = 'PRF'][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]/hl7:id[@root = '2.16.528.1.1007.5.1']"
         id="d45e13044-false-d302871e0">
      <extends rule="II.NL.BIG"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(A_Rijksvaccinatie [universal]): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@root) = ('2.16.528.1.1007.5.1')">(A_Rijksvaccinatie [universal]): de waarde van root MOET '2.16.528.1.1007.5.1' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:subjectOf[hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:performer[@typeCode = 'PRF'][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]/hl7:id[@root = '2.16.840.1.113883.2.4.6.1']
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:subjectOf[hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:performer[@typeCode = 'PRF'][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]/hl7:id[@root = '2.16.840.1.113883.2.4.6.1']"
         id="d45e13052-false-d302886e0">
      <extends rule="II.NL.AGB"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(A_Rijksvaccinatie [universal]): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.6.1')">(A_Rijksvaccinatie [universal]): de waarde van root MOET '2.16.840.1.113883.2.4.6.1' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:subjectOf[hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:performer[@typeCode = 'PRF'][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]/hl7:id[@nullFlavor = 'NI']
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:subjectOf[hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:performer[@typeCode = 'PRF'][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]/hl7:id[@nullFlavor = 'NI']"
         id="d45e13060-false-d302900e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(A_Rijksvaccinatie [universal]): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@nullFlavor) = ('NI')">(A_Rijksvaccinatie [universal]): de waarde van nullFlavor MOET 'NI' zijn. Gevonden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:subjectOf[hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:performer[@typeCode = 'PRF'][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]/hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:subjectOf[hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:performer[@typeCode = 'PRF'][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]/hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']"
         id="d45e13071-false-d302914e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@classCode) = ('PSN')">(A_Rijksvaccinatie [universal]): de waarde van classCode MOET 'PSN' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@determinerCode) = ('INSTANCE')">(A_Rijksvaccinatie [universal]): de waarde van determinerCode MOET 'INSTANCE' zijn. Gevonden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(A_Rijksvaccinatie [universal]): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:subjectOf[hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:performer[@typeCode = 'PRF'][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]/hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:name[not(@nullFlavor)]
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:causeOf2[hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:adverseReaction[hl7:code[(@code = '874' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:subjectOf[hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:informationControlActEvent[hl7:code[(@code = '875' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:performer[@typeCode = 'PRF'][hl7:assignedPerson]/hl7:assignedPerson[not(@nullFlavor)]/hl7:assignedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:name[not(@nullFlavor)]"
         id="d45e13082-false-d302938e0">
      <extends rule="PN"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PN')">(A_Rijksvaccinatie [universal]): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]]]
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]]]"
         id="d45e13100-false-d302949e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@typeCode) = ('AUTH') or not(@typeCode)">(A_Rijksvaccinatie [universal]): de waarde van typeCode MOET 'AUTH' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:consentEvent[hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]]) &gt;= 1">(A_Rijksvaccinatie [universal]): element hl7:consentEvent[hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:consentEvent[hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]]) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:consentEvent[hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:consentEvent[hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]]
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:consentEvent[hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]]"
         id="d45e13111-false-d302971e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@classCode) = ('CONS') or not(@classCode)">(A_Rijksvaccinatie [universal]): de waarde van classCode MOET 'CONS' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(A_Rijksvaccinatie [universal]): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@negationInd) = ('true')">(A_Rijksvaccinatie [universal]): de waarde van negationInd MOET 'true' zijn. Gevonden: "<value-of select="@negationInd"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]) &gt;= 1">(A_Rijksvaccinatie [universal]): element hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:reasonOf[hl7:observationEvent[hl7:code[(@code = '683' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:reasonOf[hl7:observationEvent[hl7:code[(@code = '683' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:consentEvent[hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:consentEvent[hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]"
         id="d45e13129-false-d303008e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(A_Rijksvaccinatie [universal]): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="@nullFlavor or (@code='IMMUNIZ' and @codeSystem='2.16.840.1.113883.5.4')">(A_Rijksvaccinatie [universal]): de elementwaarde MOET een zijn van 'code 'IMMUNIZ' codeSystem '2.16.840.1.113883.5.4''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:consentEvent[hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:reasonOf[hl7:observationEvent[hl7:code[(@code = '683' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:consentEvent[hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:reasonOf[hl7:observationEvent[hl7:code[(@code = '683' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]"
         id="d45e13139-false-d303025e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@typeCode) = ('RSON') or not(@typeCode)">(A_Rijksvaccinatie [universal]): de waarde van typeCode MOET 'RSON' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:observationEvent[hl7:code[(@code = '683' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]) &gt;= 1">(A_Rijksvaccinatie [universal]): element hl7:observationEvent[hl7:code[(@code = '683' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:observationEvent[hl7:code[(@code = '683' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:observationEvent[hl7:code[(@code = '683' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:consentEvent[hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:reasonOf[hl7:observationEvent[hl7:code[(@code = '683' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:observationEvent[hl7:code[(@code = '683' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:consentEvent[hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:reasonOf[hl7:observationEvent[hl7:code[(@code = '683' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:observationEvent[hl7:code[(@code = '683' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]"
         id="d45e13151-false-d303047e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(A_Rijksvaccinatie [universal]): de waarde van classCode MOET 'OBS' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(A_Rijksvaccinatie [universal]): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:code[(@code = '683' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]) &gt;= 1">(A_Rijksvaccinatie [universal]): element hl7:code[(@code = '683' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:code[(@code = '683' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:code[(@code = '683' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.323-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.323-2012-05-21T012654.xml')//valueSet[1]/conceptList/exception/@code]) &gt;= 1">(A_Rijksvaccinatie [universal]): element hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.323-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.323-2012-05-21T012654.xml')//valueSet[1]/conceptList/exception/@code] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.323-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.323-2012-05-21T012654.xml')//valueSet[1]/conceptList/exception/@code]) &lt;= 1">(A_Rijksvaccinatie [universal]): element hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.323-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.323-2012-05-21T012654.xml')//valueSet[1]/conceptList/exception/@code] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:consentEvent[hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:reasonOf[hl7:observationEvent[hl7:code[(@code = '683' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:observationEvent[hl7:code[(@code = '683' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:code[(@code = '683' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:consentEvent[hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:reasonOf[hl7:observationEvent[hl7:code[(@code = '683' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:observationEvent[hl7:code[(@code = '683' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:code[(@code = '683' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]"
         id="d45e13162-false-d303084e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(A_Rijksvaccinatie [universal]): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="@nullFlavor or (@code='683' and @codeSystem='2.16.840.1.113883.2.4.4.40.267')">(A_Rijksvaccinatie [universal]): de elementwaarde MOET een zijn van 'code '683' codeSystem '2.16.840.1.113883.2.4.4.40.267''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:consentEvent[hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:reasonOf[hl7:observationEvent[hl7:code[(@code = '683' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:observationEvent[hl7:code[(@code = '683' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.323-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.323-2012-05-21T012654.xml')//valueSet[1]/conceptList/exception/@code]
Item: (A_Rijksvaccinatie [universal])
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:authorization[hl7:consentEvent[hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]]]/hl7:consentEvent[hl7:code[(@code = 'IMMUNIZ' and @codeSystem = '2.16.840.1.113883.5.4')]]/hl7:reasonOf[hl7:observationEvent[hl7:code[(@code = '683' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:observationEvent[hl7:code[(@code = '683' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.323-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.323-2012-05-21T012654.xml')//valueSet[1]/conceptList/exception/@code]"
         id="d45e13173-false-d303103e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(A_Rijksvaccinatie [universal]): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.323-2012-05-21T012654.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(A_Rijksvaccinatie [universal]): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.100.11.2.323 W0323 Bezwaar (HL7) (2012-05-21T01:26:54)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.323-2012-05-21T012654.xml')//valueSet[1]/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(A_Rijksvaccinatie [universal]): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst 2.16.840.1.113883.2.4.3.11.60.100.11.2.323 W0323 Bezwaar (HL7) (2012-05-21T01:26:54).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '608' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]
Item: (A_Rijksvaccinatie [universal])
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '608' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(A_Rijksvaccinatie [universal]): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.40608
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '608' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]
Item: (obs Type oproepkaart)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.40608
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '608' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:vaccinationObservation[hl7:code[(@code = '608' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]
Item: (obs Type oproepkaart)
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '608' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:vaccinationObservation[hl7:code[(@code = '608' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.40608-2019-11-28T000000.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(obs Type oproepkaart): de waarde van classCode MOET 'OBS' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.40608-2019-11-28T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(obs Type oproepkaart): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.40608-2019-11-28T000000.html"
              test="count(hl7:code[(@code = '608' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]) &gt;= 1">(obs Type oproepkaart): element hl7:code[(@code = '608' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.40608-2019-11-28T000000.html"
              test="count(hl7:code[(@code = '608' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]) &lt;= 1">(obs Type oproepkaart): element hl7:code[(@code = '608' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.40608-2019-11-28T000000.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.416-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.416-2012-05-21T012654.xml')//valueSet[1]/conceptList/exception/@code]) &gt;= 1">(obs Type oproepkaart): element hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.416-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.416-2012-05-21T012654.xml')//valueSet[1]/conceptList/exception/@code] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.40608-2019-11-28T000000.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.416-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.416-2012-05-21T012654.xml')//valueSet[1]/conceptList/exception/@code]) &lt;= 1">(obs Type oproepkaart): element hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.416-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.416-2012-05-21T012654.xml')//valueSet[1]/conceptList/exception/@code] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.40608
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '608' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:vaccinationObservation[hl7:code[(@code = '608' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:code[(@code = '608' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]
Item: (obs Type oproepkaart)
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '608' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:vaccinationObservation[hl7:code[(@code = '608' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:code[(@code = '608' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.40608-2019-11-28T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(obs Type oproepkaart): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.40608-2019-11-28T000000.html"
              test="@nullFlavor or (@code='608' and @codeSystem='2.16.840.1.113883.2.4.4.40.267')">(obs Type oproepkaart): de elementwaarde MOET een zijn van 'code '608' codeSystem '2.16.840.1.113883.2.4.4.40.267''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.40608
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '608' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:vaccinationObservation[hl7:code[(@code = '608' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.416-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.416-2012-05-21T012654.xml')//valueSet[1]/conceptList/exception/@code]
Item: (obs Type oproepkaart)
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '608' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:vaccinationObservation[hl7:code[(@code = '608' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.416-2012-05-21T012654.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor = doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.416-2012-05-21T012654.xml')//valueSet[1]/conceptList/exception/@code]">
      <extends rule="CV"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.40608-2019-11-28T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.416-2012-05-21T012654.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(obs Type oproepkaart): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.100.11.2.416 W0416 Type oproepkaart (HL7) (2012-05-21T01:26:54)'.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.100.11.2.416-2012-05-21T012654.xml')//valueSet[1]/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.40608-2019-11-28T000000.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(obs Type oproepkaart): de nulwaarde '<value-of select="@nullFlavor"/>' voor @code MOET komen uit de set die is gedefinieerd voor dit attribuut of zijn gekoppeld aan waardelijst 2.16.840.1.113883.2.4.3.11.60.100.11.2.416 W0416 Type oproepkaart (HL7) (2012-05-21T01:26:54).</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.40608-2019-11-28T000000.html"
              test="@xsi:type">(obs Type oproepkaart): attribute @xsi:type MOET aanwezig zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.40608-2019-11-28T000000.html"
              test="not(@xsi:type) or (string-length(@xsi:type) &gt; 0 and not(matches(@xsi:type,'\s')))">(obs Type oproepkaart): attribuut @xsi:type MOET datatype 'cs' hebben  - '<value-of select="@xsi:type"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '872' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]
Item: (A_Rijksvaccinatie [universal])
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '872' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(A_Rijksvaccinatie [universal]): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.40872
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '872' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]
Item: (obs Toelichting afwijkende plaats vaccinatie)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.40872
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '872' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:vaccinationObservation[hl7:code[(@code = '872' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]
Item: (obs Toelichting afwijkende plaats vaccinatie)
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '872' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:vaccinationObservation[hl7:code[(@code = '872' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.40872-2019-11-28T000000.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(obs Toelichting afwijkende plaats vaccinatie): de waarde van classCode MOET 'OBS' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.40872-2019-11-28T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(obs Toelichting afwijkende plaats vaccinatie): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.40872-2019-11-28T000000.html"
              test="count(hl7:code[(@code = '872' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]) &gt;= 1">(obs Toelichting afwijkende plaats vaccinatie): element hl7:code[(@code = '872' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.40872-2019-11-28T000000.html"
              test="count(hl7:code[(@code = '872' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]) &lt;= 1">(obs Toelichting afwijkende plaats vaccinatie): element hl7:code[(@code = '872' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.40872-2019-11-28T000000.html"
              test="count(hl7:value[resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')]) &gt;= 1">(obs Toelichting afwijkende plaats vaccinatie): element hl7:value[resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')] is required [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.40872-2019-11-28T000000.html"
              test="count(hl7:value[resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')]) &lt;= 1">(obs Toelichting afwijkende plaats vaccinatie): element hl7:value[resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.40872
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '872' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:vaccinationObservation[hl7:code[(@code = '872' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:code[(@code = '872' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]
Item: (obs Toelichting afwijkende plaats vaccinatie)
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '872' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:vaccinationObservation[hl7:code[(@code = '872' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:code[(@code = '872' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.40872-2019-11-28T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(obs Toelichting afwijkende plaats vaccinatie): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.40872-2019-11-28T000000.html"
              test="@nullFlavor or (@code='872' and @codeSystem='2.16.840.1.113883.2.4.4.40.267')">(obs Toelichting afwijkende plaats vaccinatie): de elementwaarde MOET een zijn van 'code '872' codeSystem '2.16.840.1.113883.2.4.4.40.267''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.40872
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '872' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:vaccinationObservation[hl7:code[(@code = '872' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:value[resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')]
Item: (obs Toelichting afwijkende plaats vaccinatie)
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '872' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:vaccinationObservation[hl7:code[(@code = '872' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:value[resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')]">
      <extends rule="ST"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.40872-2019-11-28T000000.html"
              test="@xsi:type">(obs Toelichting afwijkende plaats vaccinatie): attribute @xsi:type MOET aanwezig zijn.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.40872-2019-11-28T000000.html"
              test="not(@xsi:type) or (string-length(@xsi:type) &gt; 0 and not(matches(@xsi:type,'\s')))">(obs Toelichting afwijkende plaats vaccinatie): attribuut @xsi:type MOET datatype 'cs' hebben  - '<value-of select="@xsi:type"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.116
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '1589' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]
Item: (A_Rijksvaccinatie [universal])
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '1589' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]">
      <extends rule="d303341e0-false-d303345e0"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.116-2020-05-27T000000.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(A_Rijksvaccinatie [universal]): de waarde van typeCode MOET 'COMP' zijn. Gevonden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.41589
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '1589' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]
Item: (obs Vaccinatie door RIVM afgekeurd)
-->
   <rule fpi="RULC-1" id="d303341e0-false-d303345e0" abstract="true">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.41589-2019-11-28T000000.html"
              test="count(hl7:vaccinationObservation[hl7:code[(@code = '1589' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]) &gt;= 1">(obs Vaccinatie door RIVM afgekeurd): element hl7:vaccinationObservation[hl7:code[(@code = '1589' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.41589-2019-11-28T000000.html"
              test="count(hl7:vaccinationObservation[hl7:code[(@code = '1589' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]) &lt;= 1">(obs Vaccinatie door RIVM afgekeurd): element hl7:vaccinationObservation[hl7:code[(@code = '1589' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.41589
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '1589' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:vaccinationObservation[hl7:code[(@code = '1589' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]
Item: (obs Vaccinatie door RIVM afgekeurd)
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '1589' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:vaccinationObservation[hl7:code[(@code = '1589' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.41589-2019-11-28T000000.html"
              test="count(hl7:code[(@code = '1589' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]) &gt;= 1">(obs Vaccinatie door RIVM afgekeurd): element hl7:code[(@code = '1589' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.41589-2019-11-28T000000.html"
              test="count(hl7:code[(@code = '1589' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]) &lt;= 1">(obs Vaccinatie door RIVM afgekeurd): element hl7:code[(@code = '1589' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.41589-2019-11-28T000000.html"
              test="count(hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'BL')]) &gt;= 1">(obs Vaccinatie door RIVM afgekeurd): element hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'BL')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.41589-2019-11-28T000000.html"
              test="count(hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'BL')]) &lt;= 1">(obs Vaccinatie door RIVM afgekeurd): element hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'BL')] komt te vaak voor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.41589
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '1589' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:vaccinationObservation[hl7:code[(@code = '1589' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:code[(@code = '1589' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]
Item: (obs Vaccinatie door RIVM afgekeurd)
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '1589' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:vaccinationObservation[hl7:code[(@code = '1589' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:code[(@code = '1589' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.41589-2019-11-28T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(obs Vaccinatie door RIVM afgekeurd): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.41589-2019-11-28T000000.html"
              test="@nullFlavor or (@code='1589' and @codeSystem='2.16.840.1.113883.2.4.4.40.267')">(obs Vaccinatie door RIVM afgekeurd): de elementwaarde MOET een zijn van 'code '1589' codeSystem '2.16.840.1.113883.2.4.4.40.267''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.41589
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '1589' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:vaccinationObservation[hl7:code[(@code = '1589' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'BL')]
Item: (obs Vaccinatie door RIVM afgekeurd)
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.116']]/hl7:component[hl7:vaccinationObservation[hl7:code[(@code = '1589' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]]/hl7:vaccinationObservation[hl7:code[(@code = '1589' and @codeSystem = '2.16.840.1.113883.2.4.4.40.267')]]/hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'BL')]">
      <extends rule="BL"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.41589-2019-11-28T000000.html"
              test="@xsi:type">(obs Vaccinatie door RIVM afgekeurd): attribute @xsi:type MOET aanwezig zijn.</assert>
   </rule>
</pattern>
