<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.6.10.100.11012
Name: Rubriek 12 Erfelijke belasting en ouderkenmerken
Description: Vastleggen van ziekten en afwijkingen, die in genetisch opzicht voor de jeugdige van belang kunnen zijn.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.4.6.10.100.11012-2024-11-01T000000">
   <title>Rubriek 12 Erfelijke belasting en ouderkenmerken</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.11012
Context: *[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]]
Item: (Rubriek 12 Erfelijke belasting en ouderkenmerken)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.11012
Context: *[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]]/hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]
Item: (Rubriek 12 Erfelijke belasting en ouderkenmerken)
-->
   <rule fpi="RULC-1"
         context="*[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]]/hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]"
         id="d45e8524-false-d477303e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.11012-2024-11-01T000000.html"
              test="string(@classCode) = ('CLUSTER') or not(@classCode)">(Rubriek 12 Erfelijke belasting en ouderkenmerken): de waarde van classCode MOET 'CLUSTER' zijn. Gevonden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.11012-2024-11-01T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Rubriek 12 Erfelijke belasting en ouderkenmerken): de waarde van moodCode MOET 'EVN' zijn. Gevonden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.11012-2024-11-01T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']) &gt;= 1">(Rubriek 12 Erfelijke belasting en ouderkenmerken): element hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.11012-2024-11-01T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']) &lt;= 1">(Rubriek 12 Erfelijke belasting en ouderkenmerken): element hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012'] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.11012-2024-11-01T000000.html"
              test="count(hl7:code[(@code = 'R012' and @codeSystem = '2.16.840.1.113883.2.4.4.40.391')]) &gt;= 1">(Rubriek 12 Erfelijke belasting en ouderkenmerken): element hl7:code[(@code = 'R012' and @codeSystem = '2.16.840.1.113883.2.4.4.40.391')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.11012-2024-11-01T000000.html"
              test="count(hl7:code[(@code = 'R012' and @codeSystem = '2.16.840.1.113883.2.4.4.40.391')]) &lt;= 1">(Rubriek 12 Erfelijke belasting en ouderkenmerken): element hl7:code[(@code = 'R012' and @codeSystem = '2.16.840.1.113883.2.4.4.40.391')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.11012-2024-11-01T000000.html"
              test="count(hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.40238']]]) &lt;= 1">(Rubriek 12 Erfelijke belasting en ouderkenmerken): element hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.40238']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.11012-2024-11-01T000000.html"
              test="count(hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.40240']]]) &lt;= 1">(Rubriek 12 Erfelijke belasting en ouderkenmerken): element hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.40240']]] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.11012-2024-11-01T000000.html"
              test="count(hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.40808']]]) &lt;= 1">(Rubriek 12 Erfelijke belasting en ouderkenmerken): element hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.40808']]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.11012
Context: *[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]]/hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']
Item: (Rubriek 12 Erfelijke belasting en ouderkenmerken)
-->
   <rule fpi="RULC-1"
         context="*[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]]/hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]/hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']"
         id="d45e8589-false-d477398e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.11012-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Rubriek 12 Erfelijke belasting en ouderkenmerken): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.11012-2024-11-01T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.4.6.10.100.11012')">(Rubriek 12 Erfelijke belasting en ouderkenmerken): de waarde van root MOET '2.16.840.1.113883.2.4.6.10.100.11012' zijn. Gevonden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.11012
Context: *[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]]/hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]/hl7:code[(@code = 'R012' and @codeSystem = '2.16.840.1.113883.2.4.4.40.391')]
Item: (Rubriek 12 Erfelijke belasting en ouderkenmerken)
-->
   <rule fpi="RULC-1"
         context="*[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]]/hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]/hl7:code[(@code = 'R012' and @codeSystem = '2.16.840.1.113883.2.4.4.40.391')]"
         id="d45e8600-false-d477418e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.11012-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Rubriek 12 Erfelijke belasting en ouderkenmerken): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.11012-2024-11-01T000000.html"
              test="@nullFlavor or (@code='R012' and @codeSystem='2.16.840.1.113883.2.4.4.40.391')">(Rubriek 12 Erfelijke belasting en ouderkenmerken): de elementwaarde MOET een zijn van 'code 'R012' codeSystem '2.16.840.1.113883.2.4.4.40.391''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.11012
Context: *[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]]/hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]/hl7:component[hl7:groupCluster[hl7:code[@code = 'G019'][@codeSystem = '2.16.840.1.113883.2.4.4.40.393']]]
Item: (Rubriek 12 Erfelijke belasting en ouderkenmerken)
-->
   <rule fpi="RULC-1"
         context="*[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]]/hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]/hl7:component[hl7:groupCluster[hl7:code[@code = 'G019'][@codeSystem = '2.16.840.1.113883.2.4.4.40.393']]]"
         id="d45e8610-false-d477437e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.11012-2024-11-01T000000.html"
              test="count(hl7:groupCluster[hl7:code[(@code = 'G019' and @codeSystem = '2.16.840.1.113883.2.4.4.40.393')]]) &gt;= 1">(Rubriek 12 Erfelijke belasting en ouderkenmerken): element hl7:groupCluster[hl7:code[(@code = 'G019' and @codeSystem = '2.16.840.1.113883.2.4.4.40.393')]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.11012-2024-11-01T000000.html"
              test="count(hl7:groupCluster[hl7:code[(@code = 'G019' and @codeSystem = '2.16.840.1.113883.2.4.4.40.393')]]) &lt;= 1">(Rubriek 12 Erfelijke belasting en ouderkenmerken): element hl7:groupCluster[hl7:code[(@code = 'G019' and @codeSystem = '2.16.840.1.113883.2.4.4.40.393')]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.11012
Context: *[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]]/hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]/hl7:component[hl7:groupCluster[hl7:code[@code = 'G019'][@codeSystem = '2.16.840.1.113883.2.4.4.40.393']]]/hl7:groupCluster[hl7:code[(@code = 'G019' and @codeSystem = '2.16.840.1.113883.2.4.4.40.393')]]
Item: (Rubriek 12 Erfelijke belasting en ouderkenmerken)
-->
   <rule fpi="RULC-1"
         context="*[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]]/hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]/hl7:component[hl7:groupCluster[hl7:code[@code = 'G019'][@codeSystem = '2.16.840.1.113883.2.4.4.40.393']]]/hl7:groupCluster[hl7:code[(@code = 'G019' and @codeSystem = '2.16.840.1.113883.2.4.4.40.393')]]"
         id="d45e8615-false-d477478e0">
      <let name="erfelijkeZiekten"
           value="hl7:component[hl7:observation[hl7:templateId/@root='2.16.840.1.113883.2.4.6.10.100.40080']]/hl7:observation/hl7:value/@code"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.11012-2024-11-01T000000.html"
              test="count(distinct-values($erfelijkeZiekten)) le 1">(Rubriek 12 Erfelijke belasting en ouderkenmerken): Elke groep G019 kan maar over 1 erfelijk bepaalde ziekte gaan. Gevonden codes: '<value-of select="string-join($erfelijkeZiekten, ', ')"/>' met display waardes: '<value-of select="string-join($erfelijkeZiekten/../@displayName, ', ')"/>'.</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.11012-2024-11-01T000000.html"
              test="count(hl7:code[(@code = 'G019' and @codeSystem = '2.16.840.1.113883.2.4.4.40.393')]) &gt;= 1">(Rubriek 12 Erfelijke belasting en ouderkenmerken): element hl7:code[(@code = 'G019' and @codeSystem = '2.16.840.1.113883.2.4.4.40.393')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.11012-2024-11-01T000000.html"
              test="count(hl7:code[(@code = 'G019' and @codeSystem = '2.16.840.1.113883.2.4.4.40.393')]) &lt;= 1">(Rubriek 12 Erfelijke belasting en ouderkenmerken): element hl7:code[(@code = 'G019' and @codeSystem = '2.16.840.1.113883.2.4.4.40.393')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.11012-2024-11-01T000000.html"
              test="count(hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.40080']]]) &gt;= 1">(Rubriek 12 Erfelijke belasting en ouderkenmerken): element hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.40080']]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.11012-2024-11-01T000000.html"
              test="count(hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.41608']]]) &lt;= 1">(Rubriek 12 Erfelijke belasting en ouderkenmerken): element hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.41608']]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.11012
Context: *[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]]/hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]/hl7:component[hl7:groupCluster[hl7:code[@code = 'G019'][@codeSystem = '2.16.840.1.113883.2.4.4.40.393']]]/hl7:groupCluster[hl7:code[(@code = 'G019' and @codeSystem = '2.16.840.1.113883.2.4.4.40.393')]]/hl7:code[(@code = 'G019' and @codeSystem = '2.16.840.1.113883.2.4.4.40.393')]
Item: (Rubriek 12 Erfelijke belasting en ouderkenmerken)
-->
   <rule fpi="RULC-1"
         context="*[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]]/hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]/hl7:component[hl7:groupCluster[hl7:code[@code = 'G019'][@codeSystem = '2.16.840.1.113883.2.4.4.40.393']]]/hl7:groupCluster[hl7:code[(@code = 'G019' and @codeSystem = '2.16.840.1.113883.2.4.4.40.393')]]/hl7:code[(@code = 'G019' and @codeSystem = '2.16.840.1.113883.2.4.4.40.393')]"
         id="d45e8631-false-d477530e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.11012-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Rubriek 12 Erfelijke belasting en ouderkenmerken): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.11012-2024-11-01T000000.html"
              test="@nullFlavor or (@code='G019' and @codeSystem='2.16.840.1.113883.2.4.4.40.393')">(Rubriek 12 Erfelijke belasting en ouderkenmerken): de elementwaarde MOET een zijn van 'code 'G019' codeSystem '2.16.840.1.113883.2.4.4.40.393''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.11012
Context: *[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]]/hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]/hl7:component[hl7:groupCluster[hl7:code[@code = 'G019'][@codeSystem = '2.16.840.1.113883.2.4.4.40.393']]]/hl7:groupCluster[hl7:code[(@code = 'G019' and @codeSystem = '2.16.840.1.113883.2.4.4.40.393')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.40080']]]
Item: (Rubriek 12 Erfelijke belasting en ouderkenmerken)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.11012
Context: *[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]]/hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]/hl7:component[hl7:groupCluster[hl7:code[@code = 'G019'][@codeSystem = '2.16.840.1.113883.2.4.4.40.393']]]/hl7:groupCluster[hl7:code[(@code = 'G019' and @codeSystem = '2.16.840.1.113883.2.4.4.40.393')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.41608']]]
Item: (Rubriek 12 Erfelijke belasting en ouderkenmerken)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.11012
Context: *[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]]/hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]/hl7:component[hl7:groupCluster[hl7:code[@code = 'G020'][@codeSystem = '2.16.840.1.113883.2.4.4.40.393']]]
Item: (Rubriek 12 Erfelijke belasting en ouderkenmerken)
-->
   <rule fpi="RULC-1"
         context="*[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]]/hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]/hl7:component[hl7:groupCluster[hl7:code[@code = 'G020'][@codeSystem = '2.16.840.1.113883.2.4.4.40.393']]]"
         id="d45e8652-false-d477591e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.11012-2024-11-01T000000.html"
              test="count(hl7:groupCluster[hl7:code[(@code = 'G020' and @codeSystem = '2.16.840.1.113883.2.4.4.40.393')]]) &gt;= 1">(Rubriek 12 Erfelijke belasting en ouderkenmerken): element hl7:groupCluster[hl7:code[(@code = 'G020' and @codeSystem = '2.16.840.1.113883.2.4.4.40.393')]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.11012-2024-11-01T000000.html"
              test="count(hl7:groupCluster[hl7:code[(@code = 'G020' and @codeSystem = '2.16.840.1.113883.2.4.4.40.393')]]) &lt;= 1">(Rubriek 12 Erfelijke belasting en ouderkenmerken): element hl7:groupCluster[hl7:code[(@code = 'G020' and @codeSystem = '2.16.840.1.113883.2.4.4.40.393')]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.11012
Context: *[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]]/hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]/hl7:component[hl7:groupCluster[hl7:code[@code = 'G020'][@codeSystem = '2.16.840.1.113883.2.4.4.40.393']]]/hl7:groupCluster[hl7:code[(@code = 'G020' and @codeSystem = '2.16.840.1.113883.2.4.4.40.393')]]
Item: (Rubriek 12 Erfelijke belasting en ouderkenmerken)
-->
   <rule fpi="RULC-1"
         context="*[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]]/hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]/hl7:component[hl7:groupCluster[hl7:code[@code = 'G020'][@codeSystem = '2.16.840.1.113883.2.4.4.40.393']]]/hl7:groupCluster[hl7:code[(@code = 'G020' and @codeSystem = '2.16.840.1.113883.2.4.4.40.393')]]"
         id="d45e8657-false-d477624e0">
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.11012-2024-11-01T000000.html"
              test="count(hl7:code[(@code = 'G020' and @codeSystem = '2.16.840.1.113883.2.4.4.40.393')]) &gt;= 1">(Rubriek 12 Erfelijke belasting en ouderkenmerken): element hl7:code[(@code = 'G020' and @codeSystem = '2.16.840.1.113883.2.4.4.40.393')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.11012-2024-11-01T000000.html"
              test="count(hl7:code[(@code = 'G020' and @codeSystem = '2.16.840.1.113883.2.4.4.40.393')]) &lt;= 1">(Rubriek 12 Erfelijke belasting en ouderkenmerken): element hl7:code[(@code = 'G020' and @codeSystem = '2.16.840.1.113883.2.4.4.40.393')] komt te vaak voor [max 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.11012-2024-11-01T000000.html"
              test="count(hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.40070']]]) &gt;= 1">(Rubriek 12 Erfelijke belasting en ouderkenmerken): element hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.40070']]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.11012-2024-11-01T000000.html"
              test="count(hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.40070']]]) &lt;= 1">(Rubriek 12 Erfelijke belasting en ouderkenmerken): element hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.40070']]] komt te vaak voor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.11012
Context: *[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]]/hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]/hl7:component[hl7:groupCluster[hl7:code[@code = 'G020'][@codeSystem = '2.16.840.1.113883.2.4.4.40.393']]]/hl7:groupCluster[hl7:code[(@code = 'G020' and @codeSystem = '2.16.840.1.113883.2.4.4.40.393')]]/hl7:code[(@code = 'G020' and @codeSystem = '2.16.840.1.113883.2.4.4.40.393')]
Item: (Rubriek 12 Erfelijke belasting en ouderkenmerken)
-->
   <rule fpi="RULC-1"
         context="*[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]]/hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]/hl7:component[hl7:groupCluster[hl7:code[@code = 'G020'][@codeSystem = '2.16.840.1.113883.2.4.4.40.393']]]/hl7:groupCluster[hl7:code[(@code = 'G020' and @codeSystem = '2.16.840.1.113883.2.4.4.40.393')]]/hl7:code[(@code = 'G020' and @codeSystem = '2.16.840.1.113883.2.4.4.40.393')]"
         id="d45e8664-false-d477668e0">
      <extends rule="CV"/>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.11012-2024-11-01T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CV')">(Rubriek 12 Erfelijke belasting en ouderkenmerken): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten. Gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://decor.nictiz.nl/pub/jeugdgezondheidszorg/jgz-html-20251215T175843/tmp-2.16.840.1.113883.2.4.6.10.100.11012-2024-11-01T000000.html"
              test="@nullFlavor or (@code='G020' and @codeSystem='2.16.840.1.113883.2.4.4.40.393')">(Rubriek 12 Erfelijke belasting en ouderkenmerken): de elementwaarde MOET een zijn van 'code 'G020' codeSystem '2.16.840.1.113883.2.4.4.40.393''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.11012
Context: *[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]]/hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]/hl7:component[hl7:groupCluster[hl7:code[@code = 'G020'][@codeSystem = '2.16.840.1.113883.2.4.4.40.393']]]/hl7:groupCluster[hl7:code[(@code = 'G020' and @codeSystem = '2.16.840.1.113883.2.4.4.40.393')]]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.40070']]]
Item: (Rubriek 12 Erfelijke belasting en ouderkenmerken)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.11012
Context: *[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]]/hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.40238']]]
Item: (Rubriek 12 Erfelijke belasting en ouderkenmerken)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.11012
Context: *[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]]/hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.40240']]]
Item: (Rubriek 12 Erfelijke belasting en ouderkenmerken)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.6.10.100.11012
Context: *[hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]]/hl7:rubricCluster[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.11012']]/hl7:component[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.4.6.10.100.40808']]]
Item: (Rubriek 12 Erfelijke belasting en ouderkenmerken)
-->
</pattern>
