<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl"
    xmlns:hl7="urn:hl7-org:v3"
    xmlns:cang="http://www.fenac.nl/cang3"
    exclude-result-prefixes="xs xsi xd hl7 cang"
    version="2.0">
    <xd:doc scope="stylesheet">
        <xd:desc>
            <xd:p><xd:b>Created on:</xd:b> Nov 16, 2011</xd:p>
            <xd:p><xd:b>Author:</xd:b> ahenket</xd:p>
            <xd:p></xd:p>
        </xd:desc>
    </xd:doc>
    
    <xsl:output indent="yes" xmlns="urn:hl7-org:v3"/>
    
    <xsl:variable name="datePicture" select="'[Y0001][M01][D01]'"/>
    <xsl:variable name="dateTimePicture" select="'[Y0001][M01][D01][H01][m01][s01]'"/>
    <xsl:variable name="baseOIDCANG" select="'1.2.3.4.5'"/>
    <xsl:variable name="baseOIDCANGCareProvisionEvent" select="concat($baseOIDCANG,'.1')"/>
    <xsl:variable name="baseOIDCANGEncounterEvent" select="concat($baseOIDCANG,'.2')"/>
    
    <xd:doc>
        <xd:desc/>
    </xd:doc>
    <xsl:template match="/">
        <CareProvisionEvent moodCode="EVN" classCode="PCPR">
            <id root="{$baseOIDCANGCareProvisionEvent}" extension="{generate-id()}"/>
            <code code="CPHC" codeSystem="2.16.840.1.113883.5.4"/>
            <statusCode code="active"/>
            <xsl:comment> TODO. Mogelijk reeds bekend en aan te vullen in CANG? </xsl:comment>
            <author typeCode="AUT">
                <time value="20110107"/>
                <assignedEntity>
                    <id root="2.16.528.1.1007.3.3" extension="12345678"/>
                </assignedEntity>
            </author>
            <xsl:comment> TODO. Mogelijk reeds bekend en aan te vullen in CANG? </xsl:comment>
            <performer>
                <assignedEntity>
                    <id root="2.16.528.1.1007.3.3" extension="12345678"/>
                </assignedEntity>
            </performer>
            <subject>
                <patient classCode="PAT">
                    <id root="2.16.840.1.113883.2.4.6.3" extension="{/cang:diagnostische-gegevens/cang:diagnostiek[1]/cang:patient[1]/cang:bsn[1]}"/>
                    <addr use="PHYS">
                        <houseNumber><xsl:value-of select="/cang:diagnostische-gegevens/cang:diagnostiek[1]/cang:patient[1]/cang:adres[1]/cang:straat[1]"/></houseNumber>
                        <city><xsl:value-of select="/cang:diagnostische-gegevens/cang:diagnostiek[1]/cang:patient[1]/cang:adres[1]/cang:plaats[1]"/></city>
                    </addr>
                    <patientPerson>
                        <name>
                            <given partType="GIV" qualifier="CL"><xsl:value-of select="/cang:diagnostische-gegevens/cang:diagnostiek[1]/cang:patient[1]/cang:roepnaam[1]"/></given>
                            <family partType="FAM"><xsl:value-of select="/cang:diagnostische-gegevens/cang:diagnostiek[1]/cang:patient[1]/cang:achternaam[1]"/></family>
                        </name>
                        <xsl:call-template name="handleGender"/>
                        <birthTime value="{replace(/cang:diagnostische-gegevens/cang:diagnostiek[1]/cang:patient[1]/cang:geboortedatum[1],'-','')}"/>
                    </patientPerson>
                </patient>
            </subject>
            <component>
                <encounterEvent moodCode="EVN" classCode="ENC">
                    <id root="{$baseOIDCANGEncounterEvent}" extension="{generate-id()}"/>
                    <xsl:comment> TODO. Welke activiteitscode is hier van toepassing? </xsl:comment>
                    <code code="35" codeSystem="2.16.840.1.113883.2.4.4.40.308" displayName="Neonatale gehoorscreening">
                        <originalText><xsl:value-of select="/cang:diagnostische-gegevens/cang:diagnostiek[1]/cang:gebeurtenissen[1]/cang:gebeurtenis[1]/cang:type[1]"/></originalText>
                    </code>
                    <effectiveTime>
                        <low value="{format-date(xs:date(/cang:diagnostische-gegevens/cang:diagnostiek[1]/cang:gebeurtenissen[1]/cang:gebeurtenis[1]/cang:datum[1]),$datePicture)}"/>
                    </effectiveTime>
                    <pertinentInformation>
                        <rubricCluster moodCode="EVN" classCode="CLUSTER">
                            <xsl:comment> TODO. Welke RubriekID is hier van toepassing? </xsl:comment>
                            <code code="R040" codeSystem="2.16.840.1.113883.2.4.4.40.391" displayName="Gehooronderzoek"/>
                            <component>
                                <observation moodCode="EVN" classCode="OBS">
                                    <code displayName="Gehooronderzoek uitgevoerd" code="438" codeSystem="2.16.840.1.113883.2.4.4.40.267"/>
                                    <value xsi:type="BL" value="true"/>
                                </observation>
                            </component>
                        </rubricCluster>
                    </pertinentInformation>
                </encounterEvent>
            </component>
        </CareProvisionEvent>
    </xsl:template>
    
    <xsl:template name="handleGender">
        <xsl:choose>
            <xsl:when test="/cang:diagnostische-gegevens/cang:diagnostiek[1]/cang:patient[1]/cang:geslacht[1]='M'">
                <administrativeGenderCode code="M" codeSystem="2.16.840.1.113883.5.1"/>
            </xsl:when>
            <xsl:when test="/cang:diagnostische-gegevens/cang:diagnostiek[1]/cang:patient[1]/cang:geslacht[1]='V'">
                <administrativeGenderCode code="F" codeSystem="2.16.840.1.113883.5.1"/>
            </xsl:when>
            <xsl:when test="/cang:diagnostische-gegevens/cang:diagnostiek[1]/cang:patient[1]/cang:geslacht[1]='O' or 
                empty(/cang:diagnostische-gegevens/cang:diagnostiek[1]/cang:patient[1]/cang:geslacht[1])"/>
            <xsl:otherwise>
                <xsl:message>Onbekende code voor geslacht '<xsl:value-of select="/cang:diagnostische-gegevens/cang:diagnostiek[1]/cang:patient[1]/cang:geslacht[1]"/>'</xsl:message>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>