<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:hl7="urn:hl7-org:v3" xmlns:saxon="http://saxon.sf.net/" xmlns:local="urn:local" exclude-result-prefixes="#all" version="2.0">
    <xd:doc scope="stylesheet">
        <xd:desc>
            <xd:p><xd:b>Created on:</xd:b> May 1, 2014</xd:p>
            <xd:p><xd:b>Author:</xd:b> ahenket</xd:p>
            <xd:p/>
        </xd:desc>
    </xd:doc>
    <xsl:output method="html" indent="yes" version="4.01" encoding="UTF-8" doctype-public="-//W3C//DTD HTML 4.01//EN" doctype-system="http://www.w3.org/TR/html4/strict.dtd"/>
    <xd:doc>
        <xd:desc/>
    </xd:doc>
    <xsl:template match="hl7:REPC_IN002160NL">
        <html>
            <head>
                <title>Vaccinatieoproeplijst voor <xsl:value-of select="count(hl7:ControlActProcess/hl7:subject//hl7:subject/hl7:patient)"/> kinderen</title>
                <link href="../css/nictiz.css" rel="stylesheet" type="text/css"/>
                <xsl:call-template name="doCSS"/>
            </head>
            <body>
                <h3>Vaccinatieoproeplijst (dd. <xsl:value-of select="local:formatDate(hl7:creationTime/@value)"/>)</h3>
                <table width="100%">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Naam</th>
                            <th>voorvoegsel</th>
                            <th>Geslachtsnaam</th>
                            <th>Geslacht</th>
                            <th>Geboortedatum</th>
                            <th>Straatnaam</th>
                            <th>Huisnummer</th>
                            <th>Postcode</th>
                            <th>Gemeente</th>
                            <th>Adrestype</th>
                            <th>Vaccinsoort</th>
                        </tr>
                    </thead>
                    <tbody>
                        <xsl:for-each select="hl7:ControlActProcess/hl7:subject/hl7:immunizationRequestList/hl7:component/hl7:organizer">
                            <tr class="{if (position() mod 2 = 0) then 'alternate' else ''}">
                                <td>
                                    <xsl:for-each select="hl7:subject/hl7:patient/hl7:id">
                                        <xsl:value-of select="@extension"/>
                                        <xsl:choose>
                                            <xsl:when test="@root = '2.16.840.1.113883.2.4.6.3'"> (BSN)</xsl:when>
                                            <xsl:when test="@root = '2.16.840.1.113883.2.4.6.20'"> (V-nummer)</xsl:when>
                                            <xsl:otherwise> (<xsl:value-of select="@root"/>?)</xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:for-each>
                                </td>
                                <td>
                                    <xsl:value-of select="hl7:subject/hl7:patient/hl7:patientPerson/hl7:name/hl7:given"/>
                                </td>
                                <td>
                                    <xsl:value-of select="hl7:subject/hl7:patient/hl7:patientPerson/hl7:name/hl7:prefix"/>
                                </td>
                                <td>
                                    <xsl:value-of select="hl7:subject/hl7:patient/hl7:patientPerson/hl7:name/hl7:family"/>
                                </td>
                                <td>
                                    <xsl:value-of select="local:getDisplayName(hl7:subject/hl7:patient/hl7:patientPerson/hl7:administrativeGenderCode)"/>
                                </td>
                                <td>
                                    <xsl:value-of select="local:formatDate(hl7:subject/hl7:patient/hl7:patientPerson/hl7:birthTime/@value)"/>
                                </td>
                                <td>
                                    <xsl:value-of select="hl7:subject/hl7:patient/hl7:addr/hl7:streetName"/>
                                </td>
                                <td>
                                    <xsl:value-of select="hl7:subject/hl7:patient/hl7:addr/string-join((hl7:houseNumberNumeric | hl7:houseNumber | hl7:buildingNumberSuffix | hl7:additionalLocator), ' ')"/>
                                </td>
                                <td>
                                    <xsl:value-of select="hl7:subject/hl7:patient/hl7:addr/hl7:postalCode"/>
                                </td>
                                <td>
                                    <xsl:value-of select="hl7:subject/hl7:patient/hl7:addr/hl7:county"/>
                                </td>
                                <td>
                                    <xsl:variable name="use" select="hl7:subject/hl7:patient/hl7:addr/@use"/>
                                    <xsl:for-each select="tokenize($use, '\s')">
                                        <xsl:choose>
                                            <xsl:when test=". = 'HP'">
                                                <div>Woonadres</div>
                                            </xsl:when>
                                            <xsl:when test=". = 'WP'">
                                                <div>Werkadres</div>
                                            </xsl:when>
                                            <xsl:when test=". = 'TMP'">
                                                <div>Tijdelijk</div>
                                            </xsl:when>
                                            <xsl:when test=". = 'PST'">
                                                <div>Postadres</div>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:value-of select="$use"/>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:for-each>
                                </td>
                                <td>
                                    <xsl:for-each select="hl7:component/hl7:substanceAdministration/hl7:consumable/hl7:medication/hl7:administrableMedicine/hl7:code">
                                        <div>
                                            <xsl:value-of select="local:getDisplayName(.)"/>
                                        </div>
                                    </xsl:for-each>
                                </td>
                            </tr>
                        </xsl:for-each>
                    </tbody>
                </table>
            </body>
        </html>
    </xsl:template>
    <xd:doc>
        <xd:desc/>
    </xd:doc>
    <xsl:template match="hl7:REPC_IN002171NL">
        <html>
            <head>
                <title>Vaccinatieoverzicht voor <xsl:value-of select="string-join(.//hl7:patientPerson/hl7:name//text()/normalize-space(), ' ')"/></title>
                <link href="../css/nictiz.css" rel="stylesheet" type="text/css"/>
                <xsl:call-template name="doCSS"/>
            </head>
            <body>
                <h3>Vaccinatieoverzicht (dd. <xsl:value-of select="local:formatDate(hl7:creationTime/@value)"/>)</h3>
                <table class="person-data">
                    <tr>
                        <td class="header">Kind</td>
                        <td class="strong">
                            <xsl:value-of select="string-join(.//hl7:patientPerson/hl7:name//text()/normalize-space(), ' ')"/>
                            <xsl:text> (</xsl:text>
                            <xsl:value-of select="local:getDisplayName(.//hl7:patientPerson/hl7:administrativeGenderCode)"/>
                            <xsl:text> / geboortedatum </xsl:text>
                            <xsl:value-of select="local:formatDate(.//hl7:patientPerson/hl7:birthTime/@value)"/>
                            <xsl:text>)</xsl:text>
                        </td>
                    </tr>
                    <tr>
                        <td class="header">Adres</td>
                        <td class="strong">
                            <xsl:value-of select="string-join(.//hl7:patient/hl7:addr//text()/normalize-space(), ' ')"/>
                        </td>
                    </tr>
                </table>
                <xsl:variable name="components" select="hl7:ControlActProcess/hl7:subject/hl7:VaccinationAdministrationList/hl7:component/hl7:substanceAdministration" as="element()*"/>
                <xsl:variable name="actual" select="$components[not(hl7:limitation)]"/>
                <xsl:variable name="planned" select="$components[hl7:limitation]"/>
                <xsl:variable name="actualDates" select="$actual/hl7:effectiveTime/@value"/>
                <xsl:variable name="plannedDates" select="$planned/hl7:limitation/hl7:dateCriterion[hl7:code[@code = '30981-5'][@codeSystem = '2.16.840.1.113883.6.1']]/hl7:value/@value"/>
                <table class="values">
                    <tr>
                        <th>Vaccintype</th>
                        <xsl:for-each select="distinct-values($actualDates | $plannedDates)">
                            <xsl:sort select="substring(concat(., '00000000'), 1, 8)"/>
                            <th>
                                <xsl:value-of select="local:formatDate(.)"/>
                            </th>
                        </xsl:for-each>
                    </tr>
                    <xsl:for-each-group select="$components" group-by="hl7:consumable/hl7:medication/hl7:administrableMedicine/hl7:code/concat(@code, @codeSystem, hl7:originalText)">
                        <tr class="hover">
                            <td class="header">
                                <xsl:value-of select="hl7:consumable/hl7:medication/hl7:administrableMedicine/hl7:code/@code"/>
                                <xsl:text> </xsl:text>
                                <xsl:value-of select="local:getDisplayName(hl7:consumable/hl7:medication/hl7:administrableMedicine/hl7:code)"/>
                            </td>
                            <xsl:for-each select="distinct-values($actualDates | $plannedDates)">
                                <xsl:sort select="substring(concat(., '00000000'), 1, 8)"/>
                                <xsl:variable name="d" select="."/>
                                <xsl:variable name="c" select="$components[hl7:consumable/hl7:medication/hl7:administrableMedicine/hl7:code/concat(@code, @codeSystem, hl7:originalText) = current-grouping-key()]"/>
                                <xsl:choose>
                                    <xsl:when test="$c[@moodCode = 'EVN'][not(@negationInd = 'true')]/hl7:effectiveTime[@value = $d]">
                                        <xsl:variable name="performer" select="$c[@moodCode = 'EVN'][not(@negationInd = 'true')][hl7:effectiveTime[@value = $d]]/hl7:performer//hl7:assignedOrganization/hl7:name"/>
                                        <xsl:variable name="lotNumber" select="$c[@moodCode = 'EVN'][not(@negationInd = 'true')][hl7:effectiveTime[@value = $d]]/hl7:consumable/hl7:medication/hl7:administrableMedicine/hl7:lotNumberText/text()"/>
                                        <td class="vaccine-administered" title="Partijnummer: {if ($lotNumber) then $lotNumber else ('onbekend')}, uitvoerende organisatie {if ($performer) then $performer else ('onbekend')}">J</td>
                                    </xsl:when>
                                    <xsl:when test="$c[@moodCode = 'EVN'][@negationInd = 'true']/hl7:effectiveTime[@value = $d]">
                                        <xsl:variable name="performer" select="$c[@moodCode = 'EVN'][@negationInd = 'true'][hl7:effectiveTime[@value = $d]]/hl7:performer//hl7:assignedOrganization/hl7:name"/>
                                        <td class="vaccine-refused" title="Bezwaar, uitvoerende organisatie {if ($performer) then $performer else ('onbekend')}">N</td>
                                    </xsl:when>
                                    <xsl:when test="$c[@moodCode = 'RMD']/hl7:limitation/hl7:dateCriterion[hl7:code[@code = '30981-5'][@codeSystem = '2.16.840.1.113883.6.1']]/hl7:value[@value = $d]">
                                        <xsl:variable name="e" select="$c[@moodCode = 'RMD'][hl7:limitation/hl7:dateCriterion[hl7:code[@code = '30981-5'][@codeSystem = '2.16.840.1.113883.6.1']]/hl7:value[@value = $d]]/hl7:limitation/hl7:dateCriterion[hl7:code[@code = '30980-7'][@codeSystem = '2.16.840.1.113883.6.1']]/hl7:value/@value"/>
                                        <td class="vaccine-planned" title="Gepland, niet voor {local:formatDate($d)} en niet na {local:formatDate($e)}">P</td>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <td/>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:for-each>
                        </tr>
                    </xsl:for-each-group>
                </table>
            </body>
        </html>
    </xsl:template>
    <xd:doc>
        <xd:desc/>
        <xd:param name="element"/>
    </xd:doc>
    <xsl:function name="local:getDisplayName" as="xs:string?">
        <xsl:param name="element" as="element()?"/>
        <xsl:choose>
            <xsl:when test="$element/@displayName">
                <xsl:value-of select="$element/@displayName"/>
            </xsl:when>
            <xsl:when test="$element/hl7:originalText">
                <xsl:value-of select="$element/hl7:originaText"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$codes/*[@code = $element/@code][@codeSystem = $element/@codeSystem]/@displayName"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>
    
    <xd:doc>
        <xd:desc> Return (yyyy(-mm(-dd)?)?)? </xd:desc>
        <xd:param name="date"/>
    </xd:doc>
    <xsl:function name="local:formatDate" as="xs:string?">
        <xsl:param name="date" as="xs:string?"/>
        <xsl:choose>
            <xsl:when test="matches($date,'^[\d\.+-]+$')">
                <xsl:choose>
                    <xsl:when test="string-length($date) >= 8">
                        <xsl:value-of select="concat(substring($date, 1, 4), '-', substring($date, 5, 2), '-', substring($date, 7, 2))"/>
                    </xsl:when>
                    <xsl:when test="string-length($date) >= 6">
                        <xsl:value-of select="concat(substring($date, 1, 4), '-', substring($date, 5, 2))"/>
                    </xsl:when>
                    <xsl:when test="string-length($date) >= 4">
                        <xsl:value-of select="substring($date, 1, 4)"/>
                    </xsl:when>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="$date='{datetime:format-dateTime(current-dateTime(),''yyyyMMddHHmmssZ'')}'">
                <xsl:value-of select="format-dateTime(current-dateTime(),'[Y0001]-[M01]-[D01] [H01]:[m01]:[s01][Z]')"/>
            </xsl:when>
            <xsl:when test="$date='{datetime:format-dateTime(current-dateTime(),''yyyyMMddHHmmss'')}'">
                <xsl:value-of select="format-dateTime(current-dateTime(),'[Y0001]-[M01]-[D01] [H01]:[m01]:[s01]')"/>
            </xsl:when>
            <xsl:when test="$date='{datetime:format-dateTime(current-dateTime(),''yyyyMMdd'')}'">
                <xsl:value-of select="format-dateTime(current-dateTime(),'[Y0001]-[M01]-[D01]')"/>
            </xsl:when>
            <xsl:when test="matches($date,'^\{format.*\}$')">
                <xsl:value-of select="local:formatDate(saxon:evaluate(substring($date,2,string-length($date)-2)))"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$date"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>
    <xd:doc>
        <xd:desc/>
    </xd:doc>
    <xsl:template name="doCSS">
        <style type="text/css">
            table.person-data{
                width:100%;
                border:1px solid black;
                margin-bottom:20px;
            }
            td.strong{
                font-weight:bold;
            }
            tr.hover:hover{
                background-color:lightyellow;
            }
            td.vaccine-administered{
                background-color:lightgreen;
                text-align:center;
            }
            th.header,
            td.header{
                width:100px;
            }
            th.header:hover,
            td.header:hover,
            td.vaccine-administered:hover,
            td.vaccine-refused:hover,
            td.vaccine-planned:hover{
                font-weight:bold;
            }
            td.vaccine-refused{
                background-color:lightsalmon;
                text-align:center;
            }
            td.vaccine-planned{
                background-color:whitesmoke;
                font-style:italic;
                text-align:center;
            }</style>
    </xsl:template>
    <xsl:variable name="codes" as="element()">
        <codes>
            <concept code="F" codeSystem="2.16.840.1.113883.5.1" displayName="meisje"/>
            <concept code="M" codeSystem="2.16.840.1.113883.5.1" displayName="jongen"/>
            <concept code="UN" codeSystem="2.16.840.1.113883.5.1" displayName="Onbepaald"/>
            <concept code="01" codeSystem="2.16.840.1.113883.2.4.3.11.60.100.12.422" displayName="DKTP"/>
            <concept code="02" codeSystem="2.16.840.1.113883.2.4.3.11.60.100.12.422" displayName="DTP"/>
            <concept code="03" codeSystem="2.16.840.1.113883.2.4.3.11.60.100.12.422" displayName="Hib"/>
            <concept code="04" codeSystem="2.16.840.1.113883.2.4.3.11.60.100.12.422" displayName="BMR"/>
            <concept code="05" codeSystem="2.16.840.1.113883.2.4.3.11.60.100.12.422" displayName="Hepatitis B"/>
            <concept code="06" codeSystem="2.16.840.1.113883.2.4.3.11.60.100.12.422" displayName="MenC"/>
            <concept code="07" codeSystem="2.16.840.1.113883.2.4.3.11.60.100.12.422" displayName="BCG"/>
            <concept code="08" codeSystem="2.16.840.1.113883.2.4.3.11.60.100.12.422" displayName="Pneu"/>
            <concept code="09" codeSystem="2.16.840.1.113883.2.4.3.11.60.100.12.422" displayName="HPV"/>
            <concept code="10" codeSystem="2.16.840.1.113883.2.4.3.11.60.100.12.422" displayName="DKTP-Hib"/>
            <concept code="11" codeSystem="2.16.840.1.113883.2.4.3.11.60.100.12.422" displayName="DKTP-Hib-Hepatitis B"/>
            <concept code="26" codeSystem="2.16.840.1.113883.2.4.3.11.60.100.12.422" displayName="DKTP-Hepatitis B"/>
            <concept code="12" codeSystem="2.16.840.1.113883.2.4.3.11.60.100.12.422" displayName="D"/>
            <concept code="13" codeSystem="2.16.840.1.113883.2.4.3.11.60.100.12.422" displayName="DKT"/>
            <concept code="14" codeSystem="2.16.840.1.113883.2.4.3.11.60.100.12.422" displayName="DT"/>
            <concept code="15" codeSystem="2.16.840.1.113883.2.4.3.11.60.100.12.422" displayName="aK (acellulair kinkhoest vaccin)"/>
            <concept code="16" codeSystem="2.16.840.1.113883.2.4.3.11.60.100.12.422" displayName="DaKT"/>
            <concept code="17" codeSystem="2.16.840.1.113883.2.4.3.11.60.100.12.422" displayName="DaKTP"/>
            <concept code="18" codeSystem="2.16.840.1.113883.2.4.3.11.60.100.12.422" displayName="DP"/>
            <concept code="19" codeSystem="2.16.840.1.113883.2.4.3.11.60.100.12.422" displayName="T"/>
            <concept code="20" codeSystem="2.16.840.1.113883.2.4.3.11.60.100.12.422" displayName="P"/>
            <concept code="21" codeSystem="2.16.840.1.113883.2.4.3.11.60.100.12.422" displayName="B"/>
            <concept code="22" codeSystem="2.16.840.1.113883.2.4.3.11.60.100.12.422" displayName="M"/>
            <concept code="23" codeSystem="2.16.840.1.113883.2.4.3.11.60.100.12.422" displayName="R"/>
            <concept code="24" codeSystem="2.16.840.1.113883.2.4.3.11.60.100.12.422" displayName="BM"/>
            <concept code="25" codeSystem="2.16.840.1.113883.2.4.3.11.60.100.12.422" displayName="MR"/>
            <concept code="26" codeSystem="2.16.840.1.113883.2.4.3.11.60.100.12.422" displayName="DKTP-Hepatitis B"/>
        </codes>
    </xsl:variable>
</xsl:stylesheet>
